
--
-- Ensure correct encoding
--
SET NAMES utf8;


--
-- Table structure for table `lang_languages`
--


DROP TABLE IF EXISTS `lang_languages`;
CREATE TABLE `lang_languages` (
  `lang_id` int(11) NOT NULL auto_increment,
  `lang_code` char(2) NOT NULL default '',
  `lang_description` varchar(100) default NULL,
  `lang_is_rtl` TINYINT DEFAULT 0,
  UNIQUE KEY `lang_id` (`lang_id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 ;


--
-- Dumping data for table `lang_languages`
--

INSERT INTO `lang_languages`   (`lang_id`, `lang_code`, `lang_description`, `lang_is_rtl`) VALUES
(1, 'en', 'English (Standard)', 0),
(2, 'se', 'Swedish', 0),
(3, 'es', 'Spanish (Spain)', 0),
(4, 'el', 'Spanish (Latin American)', 0),
(5, 'de', 'German', 0),
(6, 'du', 'Dutch', 0),
(7, 'he', 'Hebrew', 1),
(8, 'fr', 'French (Standard)', 0),
(9, 'fq', 'French (Canadian)', 0),
(10, 'zh', 'Chinese (Simplified)', 0),
(11, 'zt', 'Chinese (Traditional)', 0),
(12, 'ru', 'Russian', 0),
(13, 'hy', 'Armenian', 0),
(14, 'id', 'Bahasa Indonesia', 0),
(15, 'gr', 'Greek', 0),
(16, 'ei', 'English (Indian)', 0),
(17, 'pe', 'Portuguese (European)', 0),
(18, 'pt', 'Portuguese (Brazilian)', 0),
(19, 'ar', 'Arabic', 1),
(20, 'da', 'Danish', 0),
(21, 'tr', 'Turkish', 0),
(22, 'po', 'Polish', 0),
(23, 'it', 'Italian', 0),
(24, 'hi', 'Hindi', 0),
(25, 'ro', 'Romanian', 0),
(26, 'vi', 'Vietnamese', 0),
(27, 'sq', 'Albanian', 0),
(28, 'cs', 'Czech', 0),
(29, 'uk', 'Ukrainian', 0),
(30, 'fa', 'Persian', 1),
(31, 'ja', 'Japanese', 0),
(32, 'fi', 'Finnish', 0),
(33, 'mr', 'Marathi', 0),
(34, 'ta', 'Tamil', 0),
(35, 'dd', 'dummy', 0);

--


-- 
-- Table structure for table `lang_constants`
-- 


DROP TABLE IF EXISTS `lang_constants`;
CREATE TABLE `lang_constants` (
  `cons_id` int(11) NOT NULL auto_increment,
  `constant_name` mediumtext BINARY,
  UNIQUE KEY `cons_id` (`cons_id`),
  KEY `constant_name` (`constant_name`(100))
) ENGINE=InnoDB AUTO_INCREMENT=11756 ;


-- 
-- Dumping data for table `lang_constants`
--

INSERT INTO `lang_constants`   (`cons_id`, `constant_name`) VALUES
(1, 'A'),
(2, 'A check number or claim number to identify the payment'),
(3, 'A claim must be selected to enable this menu.'),
(4, 'A client certificate for the admin user'),
(5, 'A Clinical Decision Rule is patient specific information that is filtered and presented at appropriate times to enhance health and health care'),
(6, 'A clinical document is attached'),
(7, 'A clinical document is attached.'),
(8, 'A code of this type is already selected. Erase the field first if you need to replace it.'),
(9, 'A dated reminder message can be either forwarded by clicking the Forward button or removed from the dated reminders list by clicking on the Set As Completed button'),
(10, 'A dedicated security key needs to be purchased'),
(11, 'A default code is optional as the needed code can be entered at the time of placing the actual order'),
(12, 'A detailed guide on how to enable and setup a Clinical Decision rule is found here'),
(13, 'A distributor is required'),
(14, 'A due date can be specified or a specific time period can be chosen for the dated reminder to to show up'),
(15, 'A few words to indicate the reason for the visit'),
(16, 'A followup appointment can also be scheduled right from the fee sheet.'),
(17, 'A GCAC visit form should be added to this visit.'),
(18, 'A HL7 v2.x message simply consists of several lines of text, each line is called a segment and is further divided into fields by using the pipe (|) character'),
(19, 'A large application like openEMR is used by a multitude of users with varying roles and degrees of responsibility. It is imperative that access to various parts of the program be granted to users on a need to know basis. To achieve this - Access Control Lists (ACL) are used.'),
(20, 'A lot number is required'),
(21, 'A lot number is required!'),
(22, 'A lowercase letter'),
(23, 'A New Appointment'),
(24, 'A new feature helps to group frequently ordered tests so that they can be ordered together'),
(25, 'A new message can thus be sent to a single or multiple users and/or can be about a single or multiple patients'),
(26, 'A new tab sub menu will be visible at the top of the Message center page'),
(27, 'A number'),
(28, 'A Patient Must Be Selected to Generate This Report'),
(29, 'A patient with this ID already exists.'),
(30, 'A patient with this name already exists.'),
(31, 'A patient with this SS already exists.'),
(32, 'A Payment is Required!. Please input a payment line item entry.'),
(33, 'A place to document and display the patient\'s past medical history, family history, personal history'),
(34, 'A popup box will alert you about success or failure'),
(35, 'A positive number will show that many past appointments on a Widget in the Patient Summary screen (a negative number will show the past appointments in descending order)'),
(36, 'A positive number will show that many past appointments on a Widget in the Patient Summary screen.'),
(37, 'A product was selected but there is no product section in this form.'),
(38, 'A provider or warehouse can be selected in the dropwdown box. For this option to be displayed \'Support provider in line item in fee sheet\' box must be checked in Administration > Globals> Billing page'),
(39, 'A Referral has an additional action - to print the referral or save it as a pdf file'),
(40, 'A Referral is the most common type of transaction'),
(41, 'A referral source may be specified for each visit.'),
(42, 'A related IPPF code is required!'),
(43, 'A secure (HTTPS) web connection is required for U2F'),
(44, 'A short description of this group that will appear when you hover over the newly created group (ARO).'),
(45, 'A short description of this group, Serum chemistry tests'),
(46, 'A short description of this procedure or result code'),
(47, 'A special character'),
(48, 'A standardized form called the Health Insurance Claim Form is used to submit claims'),
(49, 'A third alternative is to scan the results and save it as a document - TIFF, JPEG or PDF in the patient\'s chart under documents'),
(50, 'A two tabbed form will be revealed'),
(51, 'A unique value to identify this field, not visible to the user'),
(52, 'A useful start would be to obtain a paper lab slip from a few labs and look at the way the tests are organized on the lab slip'),
(53, 'A visit already exists for this group today. Click Cancel to open it, or OK to proceed with creating a new one.'),
(54, 'A visit already exists for this patient today. Click Cancel to open it, or OK to proceed with creating a new one.'),
(55, 'a.c.'),
(56, 'a.m.'),
(57, 'A/C{{anterior chamber}}'),
(58, 'A/F Level Right:'),
(59, 'AAA Segments'),
(60, 'AB'),
(61, 'Abbreviation'),
(62, 'Abcess:'),
(63, 'Abdominal'),
(64, 'Able to Bear Weight four (4) steps:'),
(65, 'Abn'),
(66, 'ABN1'),
(67, 'ABNL'),
(68, 'Abnormal'),
(69, 'Abnormal Blood Test'),
(70, 'Abnormal Hair Growth'),
(71, 'Abnormal Mammogram'),
(72, 'Abort'),
(73, 'Abortion'),
(74, 'Abortion Issues'),
(75, 'Abortion Method'),
(76, 'Abortion-Related Categories'),
(77, 'Abortions'),
(78, 'About'),
(79, 'About Portal Dashboard'),
(80, 'About the calendar'),
(81, 'About Your Portal'),
(82, 'Above upper panic limits'),
(83, 'Absences by Diagnosis'),
(84, 'Accept'),
(85, 'Accept Assignment'),
(86, 'Accept Payment'),
(87, 'Accept Payment for'),
(88, 'Accept Payment for '),
(89, 'Accepts Assignment'),
(90, 'Access can be given to other groups by editing User Memberships or Groups and Access Controls in Administration > ACL'),
(91, 'Access Control'),
(92, 'Access Control List Administration'),
(93, 'Access Control List Help'),
(94, 'Access Control Lists'),
(95, 'Access core data set of patient information at the beginning of an encounter'),
(96, 'Access date'),
(97, 'Access denied'),
(98, 'Access is then granted selectively to portions of the program on a need to know basis.'),
(99, 'access not allowed'),
(100, 'Access not allowed'),
(101, 'Access Not Authorized'),
(102, 'Access Your Medical Records'),
(103, 'Access Your Patient Portal'),
(104, 'Accident'),
(105, 'Account'),
(106, 'Account Id issued for NewCrop eRx service, used to separate multi-facility accounts.'),
(107, 'Account Id issued for Weno eRx service.'),
(108, 'Account Id issued for Your clinics eRx service.'),
(109, 'Account is validated. Send new credentials?'),
(110, 'Account Name'),
(111, 'Account Name issued for NewCrop eRx service.'),
(112, 'Account Password issued for NewCrop eRx service.'),
(113, 'Accounting'),
(114, 'Accounting (acct)'),
(115, 'Accountings'),
(116, 'Acct'),
(117, 'ACD{{anterior chamber depth}}'),
(118, 'Aches'),
(119, 'Acknowledge as my Electronic Signature'),
(120, 'Acknowledgment Requested (ISA14)'),
(121, 'Acknowledgments, Licensing and Certification'),
(122, 'ACL'),
(123, 'ACL Administration'),
(124, 'ACL Administration (acl)'),
(125, 'ACL Administration Not Authorized'),
(126, 'ACL Fine Granular Control'),
(127, 'ACL Updated Successfully'),
(128, 'Acne'),
(129, 'ACO'),
(130, 'ACOM{{Anterior Segment}}'),
(131, 'Act'),
(132, 'Act Date'),
(133, 'Action'),
(134, 'Action Taken'),
(135, 'Action Taken Time'),
(136, 'Action User'),
(137, 'Actions'),
(138, 'Activate'),
(139, 'Activate CCR/CCD Reporting'),
(140, 'activate to sort column ascending'),
(141, 'activate to sort column descending'),
(142, 'Activate UB04/837I Claim Support'),
(143, 'Active'),
(144, 'Active - By default any value added here will be set to Active, to prevent/remove an item from showing up in the drop-down list just uncheck and deactivate'),
(145, 'Active Alert'),
(146, 'Active Alert - that presents as a pop-up notification when a patient\'s chart is entered'),
(147, 'Active Alert Rules'),
(148, 'Active Alerts/Reminders'),
(149, 'Active Chart'),
(150, 'Active Directory - Domains Base'),
(151, 'Active Directory - Domains Controllers'),
(152, 'Active Directory - Suffix Of Account'),
(153, 'Active Encounter'),
(154, 'Active Issue Codes'),
(155, 'Active lists'),
(156, 'Active Messages'),
(157, 'Active Patient'),
(158, 'Active Plans'),
(159, 'Active Templates'),
(160, 'Activity'),
(161, 'Activity Type'),
(162, 'Actual Receipts'),
(163, 'Acuity'),
(164, 'ACUITY'),
(165, 'Acuity with Autorefraction'),
(166, 'Acuity with Contact Lenses'),
(167, 'Acuity with correction'),
(168, 'Acuity with Cycloplegic Refraction'),
(169, 'Acuity with Manifest Refraction'),
(170, 'Acuity with Pinhole'),
(171, 'Acuity without correction'),
(172, 'Acute Intoxication/Withdrawal'),
(173, 'Acute Manifestation of a Chronic Condition'),
(174, 'Acute on Chronic'),
(175, 'Ad Reviewed'),
(176, 'Add'),
(177, 'add'),
(178, 'ADD'),
(179, 'Add a Company'),
(180, 'Add a condition'),
(181, 'ADD A NEW RECALL'),
(182, 'Add a New Recall'),
(183, 'Add a note to the biller'),
(184, 'Add a Pharmacy'),
(185, 'Add all needed providers in a similar manner'),
(186, 'Add all rules to plan'),
(187, 'add an event for '),
(188, 'Add as a new message'),
(189, 'Add as a new note'),
(190, 'Add as New'),
(191, 'Add as new patient'),
(192, 'Add Bottom Border Row'),
(193, 'Add Buttons'),
(194, 'Add Buttons for Special Chars,Texts to be Displayed on Top of the Editor for inclusion to the text on a Click'),
(195, 'Add Category'),
(196, 'Add Constant'),
(197, 'Add Context'),
(198, 'Add Copay'),
(199, 'Add criteria'),
(200, 'Add Custom Button'),
(201, 'Add Data Bottom Border'),
(202, 'Add desired privileges by moving items (ACOs) from the \'Inactive\' column to the \'Active\' column.'),
(203, 'Add Diagnosis'),
(204, 'Add Drug'),
(205, 'Add Edit Transactions Help'),
(206, 'Add encounter'),
(207, 'Add Encounter'),
(208, 'Add encounter/notes'),
(209, 'Add Facility'),
(210, 'Add Field'),
(211, 'Add following lines to the Apache configuration file'),
(212, 'Add Group'),
(213, 'Add group'),
(214, 'Add ICD Code'),
(215, 'Add Immunization'),
(216, 'Add is not authorized!'),
(217, 'Add Issue'),
(218, 'Add item to track'),
(219, 'Add Language'),
(220, 'Add manually'),
(221, 'Add Mode'),
(222, 'Add modifiers for this field type. You may select more than one.'),
(223, 'Add More Items'),
(224, 'Add New'),
(225, 'Add new'),
(226, 'Add new category : '),
(227, 'Add new certificates to the Apache configuration file'),
(228, 'Add New Component'),
(229, 'Add New Components'),
(230, 'Add new database'),
(231, 'Add New Entry'),
(232, 'Add New Event'),
(233, 'ADD NEW GROUP'),
(234, 'Add New Group'),
(235, 'Add New Issue'),
(236, 'Add new lot and transaction'),
(237, 'Add New Message'),
(238, 'Add New Note'),
(239, 'Add new note'),
(240, 'Add New Partner'),
(241, 'Add New Patient'),
(242, 'ADD NEW PLAN'),
(243, 'Add New...'),
(244, 'Add Note'),
(245, 'Add Onsite Portal Activity'),
(246, 'Add Package'),
(247, 'Add Patient'),
(248, 'Add Patient Record'),
(249, 'Add Prescription'),
(250, 'Add Procedure'),
(251, 'Add Provider Number'),
(252, 'Add Recall'),
(253, 'Add Rehab'),
(254, 'Add Rule'),
(255, 'Add the remaining codes, in order to do so the CPT code must already exist in the database'),
(256, 'Add Time to Date'),
(257, 'Add to'),
(258, 'ADD TO EXISTING MESSAGE'),
(259, 'Add To Existing Message'),
(260, 'Add to list'),
(261, 'Add to Medication List'),
(262, 'Add Top Level'),
(263, 'Add Transaction'),
(264, 'Add User'),
(265, 'Add User To Group'),
(266, 'Add.{{Additional Measurements}}'),
(267, 'Add/Edit eRx'),
(268, 'Add/Edit Issue'),
(269, 'Add/Edit Patient Transaction'),
(270, 'added'),
(271, 'Adding'),
(272, 'Adding a participant'),
(273, 'Adding demographics is not authorized.'),
(274, 'Adding item to track failed'),
(275, 'Addison Syndrom'),
(276, 'Addison Syndrome'),
(277, 'Additional Attributes'),
(278, 'Additional Data Points'),
(279, 'Additional Date:'),
(280, 'Additional Diagnosis:'),
(281, 'Additional Findings'),
(282, 'Additional functionality including the ability to send SMS text messages, automated phone dialing, emails etc. can be accessed by enabling the optional MedEx Communication Service'),
(283, 'Additional help to fill out this form is available by hovering over labels of each box and clicking on the dark blue help ? icon that is revealed'),
(284, 'Additional History'),
(285, 'Additional history notes'),
(286, 'Additional Info'),
(287, 'Additional information about the individual pages can be found in their respective help files'),
(288, 'Additional information to process paper claims'),
(289, 'Additional Labs'),
(290, 'Additional Notes'),
(291, 'Additional Notes field is for local use in openEMR'),
(292, 'Additional notes for this result or recommendation'),
(293, 'Additional Notes:'),
(294, 'Additional Notes: '),
(295, 'Additional X-RAY Notes:'),
(296, 'Additionally, the corresponding US Snomed Extension Package can be imported separately after installing the International (English version) Snomed Release'),
(297, 'Additonal Rx{{Additional glasses}}'),
(298, 'addonly'),
(299, 'addonly - can read and add but not modify'),
(300, 'Addr Bk'),
(301, 'Addr Book'),
(302, 'Address'),
(303, 'Address and Postal Code'),
(304, 'Address and State'),
(305, 'Address Book'),
(306, 'Address book entry for the company performing this procedure'),
(307, 'Address book entry for the distributor'),
(308, 'Address book entry for the vendor'),
(309, 'Address Book Types'),
(310, 'Address Label'),
(311, 'Address Labels'),
(312, 'Address Only'),
(313, 'Address, City, State and Postal Code'),
(314, 'Address, State and Postal Code'),
(315, 'Address1'),
(316, 'Address2'),
(317, 'ADDRESSED TO'),
(318, 'ADDRESSEE'),
(319, 'ADD{{Bifocal Add}}'),
(320, 'ADD{{Near Add}}'),
(321, 'Adj'),
(322, 'Adj Amount'),
(323, 'Adjust'),
(324, 'Adjustment'),
(325, 'Adjustment Amt'),
(326, 'Adjustment Reasons'),
(327, 'Adjustment value for code '),
(328, 'Adjustments'),
(329, 'Adm adjust'),
(330, 'Admin'),
(331, 'Admin Email Address'),
(332, 'Administer Via'),
(333, 'Administer Via is not relevant in this context and can be left Unassigned'),
(334, 'Administered'),
(335, 'Administered By'),
(336, 'Administered Date'),
(337, 'Administered Site'),
(338, 'Administration'),
(339, 'Administration (admin)'),
(340, 'Administration Site'),
(341, 'Administrators'),
(342, 'Administrators can do anything'),
(343, 'Admit Date'),
(344, 'Adnexa'),
(345, 'Adopted Child'),
(346, 'Adult Weight Screening and Follow-Up'),
(347, 'Adult Weight Screening and Follow-Up (CQM)'),
(348, 'Advance Directive'),
(349, 'Advance Directives'),
(350, 'Advance Directives Warning'),
(351, 'Advance Options'),
(352, 'Advanced'),
(353, 'Advanced - Finer Access Control'),
(354, 'Advantages and Disadvantages of TOTP and U2F'),
(355, 'Advice'),
(356, 'Afar'),
(357, 'Affect normal'),
(358, 'Afrikaans'),
(359, 'after'),
(360, 'after (PM)'),
(361, 'After hrs calls'),
(362, 'After migration from the old password mechanisms where passwords are stored in the users table without salt is complete, this flag should be set to false so that only authentication by the new method is possible'),
(363, 'After performing above configurations, import the admin client certificate to the browser and restart Apache server (empty password).'),
(364, 'After saving the PDF, click [View Log] to check for errors.'),
(365, 'After saving the PDF, click[View Log] to check for errors.'),
(366, 'After saving the TEXT file(s), click [View Log] to check for errors.'),
(367, 'After saving the TEXT file(s), click[View Log] to check for errors.'),
(368, 'After saving your batch, click [View Log] to check for errors.'),
(369, 'After saving your batch, click[View Log] to check for errors.'),
(370, 'After that the Match column will show the selected patient ID, or 0 to create.'),
(371, 'After the information is correctly entered, click the Save button.'),
(372, 'After Uploading click the button \"Import\"'),
(373, 'After Uploading, click \"Import\"'),
(374, 'After you filled in the spreadsheet with the relevant ICD categories and ICD codes go to Administration > Lists. Select \'Service Category\' from the dropdown box'),
(375, 'After you have finished entering all the ICD 10 codes go to Adminstration > Lists and select \'Code Types\' from the dropdown box. Select \'ICD10 Diagnosis\' from the last dropdown box under ICD 10'),
(376, 'AfterCare Planning'),
(377, 'Again'),
(378, 'Age'),
(379, 'Age at death'),
(380, 'Age By'),
(381, 'Age Category'),
(382, 'Age data is out of range.'),
(383, 'Age Display Format'),
(384, 'Age format for \"age from\" is not valid'),
(385, 'Age format for \"age up to\" is not valid'),
(386, 'Age From'),
(387, 'Age in Years for Display Format Change'),
(388, 'Age max'),
(389, 'Age min'),
(390, 'Age Range'),
(391, 'Aging Columns'),
(392, 'Aging Columns:'),
(393, 'Akan'),
(394, 'Albanian'),
(395, 'Alcohol'),
(396, 'Alcohol consumption'),
(397, 'Alcohol Use'),
(398, 'Alert'),
(399, 'Alert Count'),
(400, 'Alert on and after birthday'),
(401, 'Alert on and up to 28 days after birthday'),
(402, 'Alert on patient birthday'),
(403, 'Alert only on birthday'),
(404, 'Alert Time'),
(405, 'Alerts'),
(406, 'Alerts Log'),
(407, 'Alerts/Reminders'),
(408, 'Alert{{Mental Status}}'),
(409, 'ALEUT'),
(410, 'All'),
(411, 'ALL'),
(412, 'all'),
(413, 'All (Collated Format A)'),
(414, 'All (Collated Format B)'),
(415, 'All (Cumulative)'),
(416, 'All Alerts'),
(417, 'All Automated Measure Calculations (AMC)'),
(418, 'All Categories'),
(419, 'All Clinical Quality Measures (CQM)'),
(420, 'All Codes'),
(421, 'All Dates'),
(422, 'All Day'),
(423, 'All day event'),
(424, 'All demographics fields, with search and duplication check'),
(425, 'All Encounters'),
(426, 'All Facilities'),
(427, 'All Injuries/Problems/Issues'),
(428, 'All Languages Allowed'),
(429, 'All Messages'),
(430, 'All Official Clinical Quality Measures (CQM) Measure Groups'),
(431, 'All or part of the first name'),
(432, 'All or part of the last name'),
(433, 'All or part of the organization'),
(434, 'All patient interactions in OpenEMR are linked to encounters'),
(435, 'All Patients'),
(436, 'All pending messages are displayed on the MY MESSAGES pane'),
(437, 'All Products'),
(438, 'All Providers'),
(439, 'All Reviewed and Negative:'),
(440, 'All sections are not required, rather, they are available based on the information a practitioner believes is critical data for the patient at any given moment in time'),
(441, 'All set. Click Send Request below to finish registration'),
(442, 'All Topics'),
(443, 'All TOTP authenticator apps use the same algorithm and secure hash function - HMAC-SHA1 to generate the unique key'),
(444, 'All Transactions for the patient will appear on the Transactions page in descending order of its date of creation'),
(445, 'All Users'),
(446, 'Allergic'),
(447, 'Allergic to'),
(448, 'Allergies'),
(449, 'Allergies - will show the allergies listed under Issues > Allergies. If eRx is enabled the allergy list has to be entered on the eRx page'),
(450, 'Allergies/Alerting Data'),
(451, 'Allergies:'),
(452, 'Allergy'),
(453, 'Allergy import successfully completed'),
(454, 'Allergy Issue List'),
(455, 'Allergy Reaction'),
(456, 'ALLERGY WARNING'),
(457, 'Allergy Warning'),
(458, 'Allocate'),
(459, 'Allow'),
(460, 'Allow Administrators to Delete Patients'),
(461, 'Allow all available languages as choices on menu at login.'),
(462, 'Allow Check In before the appointment\'s time.'),
(463, 'Allow creation of claims containing diagnoses but not procedures or charges. Most clinics do not want this.'),
(464, 'Allow Debugging Language'),
(465, 'Allow Early Check In'),
(466, 'Allow Email'),
(467, 'Allow email messages?'),
(468, 'Allow Email?'),
(469, 'Allow Encounter Claims'),
(470, 'Allow Encounter For Each Appointment'),
(471, 'Allow Health Info Exchange'),
(472, 'Allow Health Information Exchange'),
(473, 'Allow Immunization Info Share'),
(474, 'Allow Immunization Info Sharing'),
(475, 'Allow Immunization Registry Use'),
(476, 'Allow institutional claims support.'),
(477, 'Allow insurance eligibility checks using Office Ally'),
(478, 'Allow Mail Message'),
(479, 'Allow multiple databases'),
(480, 'Allow Notice'),
(481, 'Allow Onsite New Patient Registration Widget'),
(482, 'Allow Onsite Online Appointments'),
(483, 'Allow Onsite Online Payments'),
(484, 'Allow Onsite Online Secure Chat'),
(485, 'Allow Onsite Patient Ledger'),
(486, 'Allow Onsite Patient to make and view appointments online.'),
(487, 'Allow Onsite Patient to make payments online.'),
(488, 'Allow Onsite Patient to use Secure Chat Application.'),
(489, 'Allow Onsite Patient to view their accounting ledger online.'),
(490, 'Allow Onsite Patients to Reset Credentials'),
(491, 'Allow Patient Flow Board to Select Patients for Drug Testing.'),
(492, 'Allow Patient Portal'),
(493, 'Allow Postal Mail'),
(494, 'Allow SMS'),
(495, 'Allow SMS (text messages)?'),
(496, 'Allow Statement Exclusions from Printing'),
(497, 'Allow submitted events to be made active instantly?'),
(498, 'Allow telephone messages?'),
(499, 'Allow to use with multiple database'),
(500, 'Allow users to publish Global Events'),
(501, 'Allow users to publish Personal Calendars'),
(502, 'Allow Version 2 Onsite New Patient Registration Widget'),
(503, 'Allow Version 2 Onsite Online Payments'),
(504, 'Allow Version 2 Onsite Patient to make payments online.'),
(505, 'Allow Version 2 Patients to Reset Credentials'),
(506, 'Allow Voice Call'),
(507, 'Allow Voice Message'),
(508, 'Allowed'),
(509, 'Allowed Languages'),
(510, 'Allowed to discount prices (in Fee Sheet or Checkout form) (disc)'),
(511, 'Allowed(c)'),
(512, 'Allows E-Sign on the entire encounter'),
(513, 'Allows E-Signing Individual Forms'),
(514, 'Allows Mail'),
(515, 'Allows Voice msgs'),
(516, 'Already at the top of the page'),
(517, 'already exists'),
(518, 'already exists.'),
(519, 'Already registered'),
(520, 'Already used, choose another identifier'),
(521, 'Already used, choose another title'),
(522, 'Also provides a short description of the visit in Patient Reports'),
(523, 'Alt Address'),
(524, 'alter'),
(525, 'Alternate Cover Test'),
(526, 'Alternatively a CPT code can be used. It is 84550 for Serum Uric Acid'),
(527, 'Alternatively download a sample spreadsheet by clicking on the Download button'),
(528, 'Alternatively it can be accessed by clicking in the Messages menu item in the top navigation bar'),
(529, 'Alternatively you could clear all selections and select only the items that you want to be a part of the report'),
(530, 'Alternatively, you may choose to upload an electronic remittance (X12 835) file that you have obtained from your payer or clearinghouse. You can do this by first selecting the \'ERA upload\' option in the initial \'Select Method\' section. This brings up the \'ERA Upload\' Section.'),
(531, 'Alternatively, you may use the search page to upload an electronic remittance (X12 835) file that you have obtained from your payer or clearinghouse.  You can do this by clicking the Browse button and selecting the file to upload, and then clicking Search to perform the upload and display the corresponding invoices.  In this case the other parameters mentioned above do not apply and will be ignored.  Uploading saves the file but does not yet process its contents -- that is done separately as described below.'),
(532, 'Although the HCFA-1500 originally was developed for submitting Medicare claims, it eventually was accepted by all commercial/ private insurance carriers to facilitate the standardization of the claims process'),
(533, 'AM'),
(534, 'AM Program'),
(535, 'Amblyopia'),
(536, 'Ambulance - Air or Water'),
(537, 'Ambulance - Land'),
(538, 'Ambulatory Surgical Center'),
(539, 'AMC'),
(540, 'AMC Tracking'),
(541, 'AMC-2011'),
(542, 'AMC-2014'),
(543, 'AMC-2014 Stage I'),
(544, 'AMC-2014 Stage II'),
(545, 'AMD{{age related macular degeneration}}'),
(546, 'Amend Existing Message'),
(547, 'Amend Existing Note'),
(548, 'Amendment From'),
(549, 'Amendment List'),
(550, 'Amendment Status'),
(551, 'Amendments'),
(552, 'Amendments (write,addonly optional)'),
(553, 'Amendments (write,addonly optional) (amendment)'),
(554, 'Amendments - Enable a user to electronically select the record affected by a patient’s request for amendment and either append the amendment to the affected record or include a link that indicates the amendment’s location'),
(555, 'Amendments for'),
(556, 'American Indian'),
(557, 'American Indian or Alaska Native'),
(558, 'AMEX'),
(559, 'Amharic'),
(560, 'Amount'),
(561, 'Amount Administered'),
(562, 'Amount Charged'),
(563, 'Amount Charges'),
(564, 'Amount Charges:'),
(565, 'Amount Due'),
(566, 'Amount for Past Balance'),
(567, 'Amount for This Visit'),
(568, 'Amount Paid'),
(569, 'Amount:'),
(570, 'Amplitudes'),
(571, 'Amsler'),
(572, 'Amt Billed'),
(573, 'An appointment can be scheduled by clicking on the calendar icon in that cell'),
(574, 'An e-mail with your new account credentials will be sent to the e-mail address supplied earlier. You may still review or edit any part of your information by using the top step buttons to go to the appropriate panels. Note to be sure you have given your correct e-mail address. If after receiving credentials and you have trouble with access to the portal, please contact administration.'),
(575, 'An electronic order and the returned result is in the form of a message called the HL7 message. HL7 stands for Health Level (Application Layer) 7. HL7’s prime objective is to simplify the implementation of interfaces between healthcare software applications and various vendors so as to reduce the pain and cost involved in custom interface programming'),
(576, 'An end date later than the start date is required for repeated events!'),
(577, 'An error occured signing the form'),
(578, 'An error occurred while dumping OpenEMR web directory tree'),
(579, 'An error occurred while dumping phpGACL web directory tree'),
(580, 'An error occurred while dumping SQL-Ledger web directory tree'),
(581, 'An error occurred: Missing file to upload: Use back button!'),
(582, 'An important concept to grasp is that once the secret key delivered via the QR code is captured by the authenticator app there is no further communication between the app and OpenEMR, each will use the current UNIX time and its copy of the user-specific shared secret key to generate the same unique 6 digit number'),
(583, 'An important point to remember is that the various individuals tests in each panel are listed as Results, the fruit, you cannot directly order these individual tests'),
(584, 'An incomplete GCAC issue has been created and linked. Someone will need to complete it later.'),
(585, 'An Issue concerns matters relating to the patient\'s health'),
(586, 'An issue is a medical problem, allergy, medication, surgery or dental issue'),
(587, 'An order has now been successfully created, however a place to receive and document the returned result does not exist as yet and needs to be created'),
(588, 'An Outcome for the problem - Resolved, Improved, Status Quo, Worse, Pending Followup or leave as Unassigned'),
(589, 'An undefined error occurred, please contact your systems administrator.'),
(590, 'An unexpected error has occurred.'),
(591, 'An Updated Appointment'),
(592, 'An uppercase letter'),
(593, 'Analyzed'),
(594, 'and'),
(595, 'And'),
(596, 'AND'),
(597, 'and '),
(598, 'and all subordinate data? This action will be logged'),
(599, 'and modifier'),
(600, 'and processed.'),
(601, 'and restart Apache server.'),
(602, 'and the Reason is'),
(603, 'android'),
(604, 'Anemia'),
(605, 'Ankle'),
(606, 'Ankle + heel'),
(607, 'Ankle Evaluation Form'),
(608, 'Ankle Problems'),
(609, 'Ankylosing Sondlilitis'),
(610, 'Ankylosing Spondlilitis'),
(611, 'Anorexia'),
(612, 'Another thing you can do in the posting window is request secondary billing. If you select this checkbox before saving, then the original claim will be re-opened and queued on the Billing page, and will be processed during the next billing run.'),
(613, 'Another way to select an ICD code to justify the CPT4 code is to click on the label CPT4 at the beginning of the row'),
(614, 'Answering Service'),
(615, 'ante'),
(616, 'Anterior Chamber Depth'),
(617, 'Anterior Segment'),
(618, 'Anterior Segment Default Values'),
(619, 'ant{{anterior}}'),
(620, 'Anus nl, no rectal tenderness/mass'),
(621, 'Anxiety'),
(622, 'Any'),
(623, 'any'),
(624, 'Any additional information pertaining to this provider'),
(625, 'Any carotid bruits appreciated?'),
(626, 'Any Category'),
(627, 'Any changes here will be reviewed by provider staff before commiting to chart. The following apply'),
(628, 'Any changes that you need to make to this particular line item should be made here and saved'),
(629, 'any date'),
(630, 'Any Demographic Search'),
(631, 'Any part of the desired code or its description'),
(632, 'Any part of the desired specialty'),
(633, 'Any part of the drug id or drug name'),
(634, 'Any part of the immunization id or immunization name'),
(635, 'Any part of the patient name, or \"last,first\", or \"X-Y\"'),
(636, 'Anyother Relevant Information'),
(637, 'Anything else occur at the same time?'),
(638, 'AOE Q&A'),
(639, 'APD{{afferent pupillary defect}}'),
(640, 'API key for SMS Gateway.'),
(641, 'Apnea'),
(642, 'App'),
(643, 'Appearance'),
(644, 'Appearance:'),
(645, 'Append'),
(646, 'Append this message'),
(647, 'Append this note'),
(648, 'Append to the existing message'),
(649, 'Append to the existing note'),
(650, 'Append to this note'),
(651, 'Append to This Note'),
(652, 'Appendectomy'),
(653, 'appendectomy'),
(654, 'Applicable Patients'),
(655, 'Application'),
(656, 'Application name for login page and main window title.'),
(657, 'Application Receiver Code (GS03 - If blank ISA08 will be used)'),
(658, 'Application Sender Code (GS02)'),
(659, 'Application Title'),
(660, 'Applies to the Vitals form and Growth Chart'),
(661, 'Applies to Vitals form'),
(662, 'Apply the changes to the Current event only, to this and all Future occurrences, or to All occurrences?'),
(663, 'apply to affected area'),
(664, 'apply to skin'),
(665, 'Applying'),
(666, 'Applying Patch to site'),
(667, 'Appointment'),
(668, 'Appointment Category'),
(669, 'Appointment Date'),
(670, 'Appointment Display Sets - Color 1'),
(671, 'Appointment Display Sets - Color 2'),
(672, 'Appointment Display Sets - Color 3'),
(673, 'Appointment Display Sets - Color 4'),
(674, 'Appointment Display Sets - Ignore Display Limit (Last Set)'),
(675, 'Appointment Display Style'),
(676, 'Appointment made by'),
(677, 'Appointment Reminder Rule'),
(678, 'Appointment Reminders'),
(679, 'Appointment status'),
(680, 'Appointment Statuses'),
(681, 'Appointment within'),
(682, 'Appointment/Event Color'),
(683, 'Appointments'),
(684, 'Appointments (write optional)'),
(685, 'Appointments (write,wsome optional)'),
(686, 'Appointments (write,wsome optional) (appt)'),
(687, 'Appointments - Group Summary - Number to Display'),
(688, 'Appointments - Onsite Patient Portal - Number to Display'),
(689, 'Appointments - Patient Summary - Number to Display'),
(690, 'Appointments - shows all future appointments as well as Recalls'),
(691, 'Appointments and Encounters'),
(692, 'Appointments for'),
(693, 'Appointments Report'),
(694, 'Appointments-Encounters Report'),
(695, 'Appropriate Results'),
(696, 'Appropriate Testing for Children with Pharyngitis (CQM)'),
(697, 'Approve'),
(698, 'Approve Order'),
(699, 'Approve the patient from Patient/Client->Import->Pending Approval'),
(700, 'Approved'),
(701, 'Approved Events Administration'),
(702, 'Approved Successfully'),
(703, 'Apps'),
(704, 'Appt Date'),
(705, 'Appt Status'),
(706, 'Appt Time'),
(707, 'Appt-Enc'),
(708, 'Appt. Reminders'),
(709, 'Appts'),
(710, 'Appt{{Abbreviation for appointment}}'),
(711, 'App{{Applanation abbreviation}}'),
(712, 'Apr'),
(713, 'April'),
(714, 'AP{{applanation}}'),
(715, 'Arabic'),
(716, 'Aragonese'),
(717, 'Archive'),
(718, 'Archive Log Files'),
(719, 'Archive old files'),
(720, 'Are access control group names to be translated?'),
(721, 'Are appointment category names to be translated?'),
(722, 'Are document category names to be translated?'),
(723, 'Are fees charged for this type?'),
(724, 'are off'),
(725, 'are on'),
(726, 'Are patient note titles to be translated?'),
(727, 'Are the codes stored in external sql tables (0-No, 1-ICD10, 2-SNOMED(RF1), 3-SNOMED(RF2)) ?'),
(728, 'Are you prepared to complete a new GCAC issue for this visit?'),
(729, 'Are you sure to clear chat history?'),
(730, 'Are you sure to post for today?'),
(731, 'Are you sure you want to approve these events?'),
(732, 'Are you sure you want to cancel your changes?'),
(733, 'Are you sure you want to completely remove this form?'),
(734, 'Are you sure you want to delete'),
(735, 'Are you sure you want to delete this disclosure?'),
(736, 'Are you sure you want to delete this event?'),
(737, 'Are you sure you want to delete this item from the database?'),
(738, 'Are you sure you want to delete this message?'),
(739, 'Are you sure you want to delete this note?'),
(740, 'Are you sure you want to delete this plan?'),
(741, 'Are you sure you want to edit these events?'),
(742, 'Are you sure you want to hide these events?'),
(743, 'Are you sure you want to remove namespace'),
(744, 'Are you sure you want to transmit it again?'),
(745, 'Are you sure you want to view these events?'),
(746, 'Are you sure you wish to delete the entire group named'),
(747, 'Are you sure you wish to delete the entire list'),
(748, 'Are you sure you wish to delete the field in'),
(749, 'Are you sure you wish to delete the selected fields?'),
(750, 'Are you sure you\'d like to continue with these actions?'),
(751, 'Area not specified'),
(752, 'Arm'),
(753, 'Armenian'),
(754, 'ARNear{{Auto-refraction near acuity}}'),
(755, 'ARNear{{autorefraction near}}'),
(756, 'Arrival'),
(757, 'Arrive Time'),
(758, 'Arrived'),
(759, 'Arrived late'),
(760, 'Arrythmia'),
(761, 'Arthritis'),
(762, 'Arthritis / degen joint diseas'),
(763, 'Arthritis / degen joint disease'),
(764, 'Article'),
(765, 'AR{{Autorefraction Acuity}}'),
(766, 'AR{{autorefraction}}'),
(767, 'as'),
(768, 'As appears on documents'),
(769, 'As Of'),
(770, 'As the first step choose Group or Custom Favorite Group, as the case may be, as the Top Level Tier 1 and fill in the required details'),
(771, 'As the secret key need by the authenticator is stored on the mobile phone malware can steal these keys and thus compromise authentication'),
(772, 'As this is an infrequently performed process additional help in provided by clicking on the help icon that is revealed when you hover over the label for each box'),
(773, 'As we are creating a Custom Group for manual entry of returned results we need to create a place to enter these results'),
(774, 'As will appear on documents.'),
(775, 'ASC'),
(776, 'Asian'),
(777, 'Assamese'),
(778, 'Assess Penicillin Allergy'),
(779, 'Assessment'),
(780, 'Assign it to this one?'),
(781, 'Assign Severity and Save'),
(782, 'Assign the dosage values etc. and click Save'),
(783, 'Assign the message to the correct patient by clicking Patient: Click to select, assign a Type and forward the message on to the correct clinician or staff member'),
(784, 'Assigned To'),
(785, 'Assistant'),
(786, 'Assisted Living Facility'),
(787, 'Associate'),
(788, 'Associated'),
(789, 'Associated Notes.'),
(790, 'Assume patients permit Messaging'),
(791, 'Assume patients receive HIPAA policy'),
(792, 'Asthma'),
(793, 'at'),
(794, 'At least one search parameter is required if you select All.'),
(795, 'At present e-prescribing from openEMR is possible only in the United States'),
(796, 'At present only Continuity of Care Record (CCR) Continuity of Care Document (CCD) can be sent using phiMail'),
(797, 'At the Navicular'),
(798, 'At the Navicular:'),
(799, 'Athletic team'),
(800, 'Athletic Team'),
(801, 'Athletic/Injury'),
(802, 'ATNA audit CA certificate'),
(803, 'ATNA audit host'),
(804, 'ATNA audit local certificate'),
(805, 'ATNA audit port'),
(806, 'Atropine 1%'),
(807, 'Attending physician'),
(808, 'Attention'),
(809, 'Attention: Pending Documents'),
(810, 'Attn'),
(811, 'Attributes'),
(812, 'Audiological physician'),
(813, 'Audit CDR Engine Queries'),
(814, 'Audit Changes'),
(815, 'Audit Log Tamper'),
(816, 'Audit Log Tamper Report'),
(817, 'Audit log tampering evident at entry number'),
(818, 'Audit Log Validated Successfully'),
(819, 'Audit Log Validation Failed'),
(820, 'Audit Logging Backups'),
(821, 'Audit Logging Miscellaneous'),
(822, 'Audit Logging Order'),
(823, 'Audit Logging Patient Record'),
(824, 'Audit Logging Scheduling'),
(825, 'Audit Logging Security Administration'),
(826, 'Audit Logging SELECT Query'),
(827, 'Audit Payment'),
(828, 'Aug'),
(829, 'August'),
(830, 'Aunt'),
(831, 'Auth'),
(832, 'Auth/notes'),
(833, 'Authenticate TOTP'),
(834, 'Authenticate U2F'),
(835, 'Authenticating the user thus becomes an important factor in this endeavor'),
(836, 'Authentication Error'),
(837, 'Authenticator'),
(838, 'Authenticator apps are available for both ios and android devices at their respective app stores and is free to use'),
(839, 'Author'),
(840, 'Authorization'),
(841, 'Authorization group'),
(842, 'Authorization Status'),
(843, 'Authorizations'),
(844, 'Authorize'),
(845, 'Authorize - any encounters'),
(846, 'Authorize - any encounters (auth_a)'),
(847, 'Authorize - my encounters'),
(848, 'Authorize - my encounters (auth)'),
(849, 'Authorize as my Electronic Signature.'),
(850, 'Authorize or not as needed'),
(851, 'Authorize.Net'),
(852, 'Authorize.net'),
(853, 'Authorized'),
(854, 'Authorized Id'),
(855, 'Authorized Only'),
(856, 'Authorized Users'),
(857, 'Authy'),
(858, 'Auto Refraction'),
(859, 'Auto Send'),
(860, 'Auto Sign-Off [days]'),
(861, 'Auto Transfer'),
(862, 'Auto-Create New Encounters'),
(863, 'Auto-generated'),
(864, 'Auto-Refraction'),
(865, 'Automated Measure Calculations (AMC)'),
(866, 'Automated Measure Calculations (AMC) - 2011'),
(867, 'Automated Measure Calculations (AMC) - 2014'),
(868, 'Automated Measure Calculations (AMC) - 2014 Stage I'),
(869, 'Automated Measure Calculations (AMC) - 2014 Stage II'),
(870, 'Automated Measure Calculations (AMC) Tracking'),
(871, 'Automated Measures (AMC)'),
(872, 'Automated Voice Message permission'),
(873, 'Automatic'),
(874, 'Automatic from sale'),
(875, 'Automatically applies correct extension on successful upload'),
(876, 'Automatically create a new encounter when an appointment check in status is selected.'),
(877, 'Automatically create a new encounter when appointment status is set to \"@\" (arrived).'),
(878, 'Automatically replicate justification codes in Fee Sheet'),
(879, 'Automatically replicate justification codes in Fee Sheet (basically fills in the blanks with the justification code above it).'),
(880, 'Automobile Medical'),
(881, 'AutoRef'),
(882, 'autosaved'),
(883, 'Auto{{autorefraction}}'),
(884, 'Available Appointments Calendar'),
(885, 'Available categories'),
(886, 'Available Recipients'),
(887, 'Available Services'),
(888, 'Available Times'),
(889, 'Available Tracks'),
(890, 'Avaric'),
(891, 'Avery Label type for printing patient labels from popups in left nav screen'),
(892, 'Avestan'),
(893, 'Avg Monthly'),
(894, 'AVM'),
(895, 'AVM Confirmed'),
(896, 'AVM OK'),
(897, 'Avulsion / avulsion fracture'),
(898, 'Avulsion lateral malleolus'),
(899, 'Avulsion medial malleolus '),
(900, 'Awareness-Based'),
(901, 'Axial Length'),
(902, 'Axillary'),
(903, 'Axis{{Axis in a glasses prescription}}'),
(904, 'Axis{{Axis of a glasses prescription}}'),
(905, 'AXIS{{Axis of a glasses prescription}}'),
(906, 'AxLength{{axial Length}}'),
(907, 'Aymara'),
(908, 'Azerbaijani'),
(909, 'b.i.d.'),
(910, 'Back'),
(911, 'back'),
(912, 'Back eight visits'),
(913, 'Back eleven visits'),
(914, 'Back five visits'),
(915, 'Back four visits'),
(916, 'Back nine visits'),
(917, 'Back one visit'),
(918, 'Back Pain'),
(919, 'Back Problems'),
(920, 'Back seven visits'),
(921, 'Back six visits'),
(922, 'Back Surgery'),
(923, 'Back ten visits'),
(924, 'Back three visits'),
(925, 'Back to Admin Page'),
(926, 'Back To Editor'),
(927, 'Back to encounter'),
(928, 'Back to Patient'),
(929, 'Back To Patient'),
(930, 'Back to patient dashboard'),
(931, 'Back to Users'),
(932, 'Back To View'),
(933, 'Back twelve visits'),
(934, 'Back two visits'),
(935, 'Background Services'),
(936, 'Backup'),
(937, 'Backup Failed missing generated file'),
(938, 'Backup file has been created. Will now send download.'),
(939, 'Backup List'),
(940, 'Backup Successfully taken in'),
(941, 'Bad check'),
(942, 'Bad debt'),
(943, 'Bahasa Indonesia'),
(944, 'Bal'),
(945, 'Balance'),
(946, 'balance'),
(947, 'Balance Amt'),
(948, 'Balance Due'),
(949, 'Balance Payment'),
(950, 'Balanced'),
(951, 'Bambara'),
(952, 'Bank Draft'),
(953, 'Barcode Label'),
(954, 'Barcode Label Type'),
(955, 'Barcode type for printing barcode labels from popups in left nav screen.'),
(956, 'Base of fifth (5th) Metarsal'),
(957, 'Base of fifth (5th) Metarsal:'),
(958, 'Base URL for FHIR Server.'),
(959, 'Base URL for FHIR Server. Url should end with /'),
(960, 'Based on the individual practice\'s need the tests can be organized into various groups'),
(961, 'Bashkir'),
(962, 'Basic patient information is included, such as patient and provider information, insurance, patient health status, recent care provided, care plan information, and reason for referral or transfer'),
(963, 'Basque'),
(964, 'Batch Claim'),
(965, 'Batch Communication Tool'),
(966, 'Batch Communication Tool (batchcom)'),
(967, 'Batch Payment Entry'),
(968, 'Batch Payments'),
(969, 'Batch processing initiated; this may take a while.'),
(970, 'Batch Results'),
(971, 'BatchCom'),
(972, 'BAT{{Brightness Acuity Testing}}'),
(973, 'BC{{Base Curve}}'),
(974, 'Be patient, some files can take several minutes to process!'),
(975, 'Be patient, this can take a while.'),
(976, 'Be sure to branch it off the Well Woman Tests line (Tier 1), if properly branched both TSH and vitamin D should have a Tier value of 2'),
(977, 'because that id does not exist.'),
(978, 'before'),
(979, 'before (PM)'),
(980, 'Before beginning to use the Fee Sheet read through this help page and do some preliminary setup.'),
(981, 'Before proceeding to configuring the tests themselves you would need to review the values included in the standard release and make changes according to need'),
(982, 'Before we proceed to create a Custom Group of Tests and save it as a Favorite a quick recap of the principles involved'),
(983, 'Before you begin customization please ensure that all the ICD and CPT codes you will be needing have been entered into the database'),
(984, 'Before you start entering data check the spreadsheet once again and make adjustments as needed'),
(985, 'Before you try out electronic ordering you need to understand the issues involved'),
(986, 'Begin'),
(987, 'Begin and End date if information is available'),
(988, 'Begin Date'),
(989, 'Begin date if known'),
(990, 'Beginning Date for Ledger Report'),
(991, 'Beginning date of service yyyy-mm-dd'),
(992, 'Beginning hour of day for calendar events.'),
(993, 'Beginning of Current Work Week'),
(994, 'Being a software application it can be compromised by malware that steals the secret key or by social engineering'),
(995, 'Belarusian'),
(996, 'Belching'),
(997, 'Below lower panic limits'),
(998, 'Below this is a table that contains the existing transactions, if any, pertaining to the current patient'),
(999, 'Benefit Type'),
(1000, 'Bengali'),
(1001, 'Bengali- Bangla'),
(1002, 'Best of Luck.'),
(1003, 'between'),
(1004, 'bg{{image canvas label}}'),
(1005, 'Bidirectional'),
(1006, 'Bifocal'),
(1007, 'Bifocals'),
(1008, 'Bihari'),
(1009, 'Bilateral'),
(1010, 'Bilateral:'),
(1011, 'Bill'),
(1012, 'Bill Date'),
(1013, 'Bill Date:'),
(1014, 'Bill Type'),
(1015, 'Bill/Collect'),
(1016, 'Billed'),
(1017, 'Billed Date'),
(1018, 'Billing'),
(1019, 'Billing (write optional)'),
(1020, 'Billing (write optional) (bill)'),
(1021, 'Billing - provides a summary of the balances - Patient Balance Due, Insurance Balance Due, Total Balance Due and lists the name of the Primary Insurance along with its effective date'),
(1022, 'Billing Address'),
(1023, 'Billing Attn'),
(1024, 'Billing Code Descriptions'),
(1025, 'Billing Code for Requested Service'),
(1026, 'Billing codes'),
(1027, 'Billing Data'),
(1028, 'Billing Department'),
(1029, 'Billing Facility'),
(1030, 'Billing Facility lets you choose the facility used for billing. To create and edit the billing facility go to Administration  > Facilities'),
(1031, 'Billing Information'),
(1032, 'Billing Location'),
(1033, 'Billing Log'),
(1034, 'Billing Log Append'),
(1035, 'Billing log is empty'),
(1036, 'Billing Log Option'),
(1037, 'Billing Log Overwrite'),
(1038, 'Billing log setting to append or overwrite the log file.'),
(1039, 'Billing Manager'),
(1040, 'Billing Note'),
(1041, 'Billing Note for '),
(1042, 'Billing Note:'),
(1043, 'Billing queue results'),
(1044, 'Billing queue results:'),
(1045, 'Billing Report'),
(1046, 'Billing Status'),
(1047, 'Billing Status = Unbilled'),
(1048, 'billing to '),
(1049, 'Billing View'),
(1050, 'Binocular Pupillary Diameter - Distance'),
(1051, 'Binocular Pupillary Diameter - Near'),
(1052, 'Biopsy'),
(1053, 'Birth Certificate'),
(1054, 'Birth Date'),
(1055, 'Birth-24 months'),
(1056, 'Birthing Center'),
(1057, 'Bislama'),
(1058, 'Black'),
(1059, 'Black lines show previously existing information.'),
(1060, 'Black list'),
(1061, 'Black Lung'),
(1062, 'Black or African American'),
(1063, 'Bladder Cancer'),
(1064, 'Bladder Infections'),
(1065, 'Blank'),
(1066, 'Blank Forms'),
(1067, 'Bleeding Problems'),
(1068, 'Blind Spots'),
(1069, 'Blindness'),
(1070, 'Bloating'),
(1071, 'Block all files types that are not found in the White List. Can find interface to edit the White List at Administration->Files.'),
(1072, 'Blocked'),
(1073, 'Blood'),
(1074, 'Blood Pressure'),
(1075, 'Blood pressure'),
(1076, 'Bloody Nose'),
(1077, 'Blue Cross Blue Shield'),
(1078, 'Blue lines in this report are informational.'),
(1079, 'Blue lines in this report are informational. Black lines show previously existing information.  Green lines show changes that were successfully applied.  Red lines indicate errors, or changes that were not applied; these must be processed manually.  Currently denied claims and payment reversals are not handled automatically and so will appear in red.'),
(1080, 'Blurred Vision'),
(1081, 'BMI'),
(1082, 'BMI Status'),
(1083, 'Body'),
(1084, 'Body Region'),
(1085, 'Body Site'),
(1086, 'Body site, if applicable'),
(1087, 'Bone Tenderness:'),
(1088, 'Bone Tenderness: Medial Malleolus'),
(1089, 'Boolean'),
(1090, 'Bosnian'),
(1091, 'Bot'),
(1092, 'Both'),
(1093, 'Both Ears'),
(1094, 'both ears'),
(1095, 'Both Name and Category will be highlighted yellow to provide an additional visual clue that this is an order. A fact that will be appreciated when several orders are entered in the system along with their respective groups and results'),
(1096, 'Both rendering and supervising providers can be set here'),
(1097, 'Bottom'),
(1098, 'Bottom Margin (px)'),
(1099, 'Box 10 - This information indicates whether the patient’s illness or injury is related to employment, auto accident, or other accident'),
(1100, 'Box 10 A. Employment related'),
(1101, 'BOX 10 A. Employment related '),
(1102, 'Box 10 B. Auto Accident'),
(1103, 'BOX 10 B. Auto Accident '),
(1104, 'Box 10 C. Other Accident'),
(1105, 'BOX 10 C. Other Accident '),
(1106, 'Box 10 D - Is used to submit the Early and Periodic Screening, Diagnosis and Treatment (EPSDT) Referral Code'),
(1107, 'Box 10 D. EPSDT Referral Code'),
(1108, 'BOX 10 D. EPSDT Referral Code'),
(1109, 'Box 10. a. Employment related:'),
(1110, 'Box 10. b. Auto Accident:'),
(1111, 'Box 10. c. Other Accident:'),
(1112, 'Box 10. d. EPSDT Referral Code:'),
(1113, 'Box 14 - It identifies the first date of onset of illness, the actual date of injury, or the LMP for pregnancy. Enter the date in the first box and select either Onset of Current Symptoms or Illness or LMP from the drop-down box'),
(1114, 'BOX 14 Date Qualifier'),
(1115, 'BOX 14. Is Populated from the Encounter Screen as the Onset Date'),
(1116, 'Box 14. Onset Date:'),
(1117, 'Box 15 - The Other Date identifies additional date information about the patient’s condition or treatment. Enter the date in the first box and select a qualifier from the drop-down box'),
(1118, 'BOX 15 Other Date Qualifier'),
(1119, 'BOX 15. Date of same or similar illness (yyyy-mm-dd):'),
(1120, 'BOX 15. Date of same or similar illness/Other Date (yyyy-mm-dd):'),
(1121, 'Box 15. Other Date:'),
(1122, 'Box 16 - Dates Patient Unable to Work in Current Occupation - is the time span the patient is or was unable to work'),
(1123, 'Box 16. Date unable to work from'),
(1124, 'BOX 16. Date unable to work from'),
(1125, 'BOX 16. Date unable to work from (yyyy-mm-dd):'),
(1126, 'Box 16. Date unable to work from:'),
(1127, 'Box 16. Date unable to work to'),
(1128, 'BOX 16. Date unable to work to'),
(1129, 'BOX 16. Date unable to work to (yyyy-mm-dd):'),
(1130, 'Box 16. Date unable to work to:'),
(1131, 'Box 17 - The name entered is the referring provider, ordering provider or supervising provider who referred, ordered, or supervised the service(s) or supply(ies) on the claim. If multiple providers are involved, enter one provider using the following priority order: 1. Referring Provider, 2. Ordering Provider, 3. Supervising Provider.'),
(1132, 'Box 17. Provider'),
(1133, 'BOX 17. Provider'),
(1134, 'Box 17. Provider Qualifier'),
(1135, 'BOX 17. Provider Qualifier'),
(1136, 'Box 17. Provider Qualifier:'),
(1137, 'Box 17. Provider:'),
(1138, 'Box 18 - The “Hospitalization Dates Related to Current Services” would refer to an inpatient stay and indicates the admission and discharge dates associated with the service(s) on the claim'),
(1139, 'Box 18. Hospitalization date from'),
(1140, 'BOX 18. Hospitalization date from'),
(1141, 'BOX 18. Hospitalization date from (yyyy-mm-dd): '),
(1142, 'Box 18. Hospitalization date from:'),
(1143, 'Box 18. Hospitalization date to'),
(1144, 'BOX 18. Hospitalization date to'),
(1145, 'BOX 18. Hospitalization date to (yyyy-mm-dd): '),
(1146, 'Box 18. Hospitalization date to:'),
(1147, 'Box 20 - Indicates that services have been rendered by an independent provider as indicated in Box 32 (Service Facility Location Information) and the related costs'),
(1148, 'Box 20. Is Outside Lab used?'),
(1149, 'BOX 20. Is Outside Lab used?'),
(1150, 'Box 22 - Medicaid Resubmission Code and Original Reference Number is the code and original reference number assigned by the destination payer or receiver to indicate a previously submitted claim or encounter'),
(1151, 'Box 22. Medicaid Resubmission Code (ICD-10)'),
(1152, 'Box 22. Medicaid Resubmission Code (ICD-9) '),
(1153, 'BOX 22. Medicaid Resubmission Code (ICD-9) '),
(1154, 'Box 23 - Prior Authorization Number is the payer assigned number authorizing the service(s)'),
(1155, 'Box 23. Prior Authorization No.'),
(1156, 'Box 23. Prior Authorization No. '),
(1157, 'BOX 23. Prior Authorization No. '),
(1158, 'BP'),
(1159, 'BP Diastolic'),
(1160, 'BP Systolic'),
(1161, 'BPD'),
(1162, 'Bpd'),
(1163, 'BPD-D{{abbreviation for Binocular Pupillary Diameter - Distance}}'),
(1164, 'BPD-N{{abbreviation for Binocular Pupillary Diameter - Near}}'),
(1165, 'BPS'),
(1166, 'Bps'),
(1167, 'Brand'),
(1168, 'Brazilian Portuguese'),
(1169, 'Breast'),
(1170, 'Breast Biopsy'),
(1171, 'Breast Discharge'),
(1172, 'Breast Disease'),
(1173, 'Breast Exam'),
(1174, 'Breast Mass'),
(1175, 'Breath'),
(1176, 'Breath Sounds:'),
(1177, 'Breton'),
(1178, 'Brightness Acuity Testing'),
(1179, 'Broken Bones'),
(1180, 'broken form'),
(1181, 'Bronchitis Form'),
(1182, 'Brother'),
(1183, 'Brow'),
(1184, 'Browse'),
(1185, 'Browse for Record'),
(1186, 'Bruising/haematoma'),
(1187, 'Build Your Plan'),
(1188, 'Bulgarian'),
(1189, 'Bulging Right:'),
(1190, 'Burmese'),
(1191, 'Burning with Urination'),
(1192, 'Burning With Urination'),
(1193, 'Business Associate Agreement'),
(1194, 'Business Phone'),
(1195, 'Busy'),
(1196, 'but not yet processed.'),
(1197, 'Buttock'),
(1198, 'Buttock + S.I.'),
(1199, 'by'),
(1200, 'By'),
(1201, 'By default Active Messages are displayed as indicated in the section below the Messages caption'),
(1202, 'By default all codes are selected, uncheck the codes you do not want and click \'Add\'. These codes will then be added to the current encounter'),
(1203, 'By default only Demographics and Billing information is selected'),
(1204, 'By default only five dated reminders are shown at a time'),
(1205, 'By default the User Memberships section is selected and all the active registered users will be listed in alphabetical order by their user names.'),
(1206, 'by mouth'),
(1207, 'By selecting a payment method the rates calculated for that payment method will be automatically displayed in \'Selected Fee Sheet Codes and Charges for Current Encounter\' section'),
(1208, 'By/Source'),
(1209, 'By:'),
(1210, 'by{{made by/manufacturer}}'),
(1211, 'B{{both sides}}'),
(1212, 'C'),
(1213, 'C/D Ratio{{cup to disc ration}}'),
(1214, 'CA Certificate for verifying the RFC 5425 TLS syslog server.'),
(1215, 'Cache Lifetime (in seconds)'),
(1216, 'Cache template output?'),
(1217, 'Caffeine'),
(1218, 'Caffeine consumption'),
(1219, 'Calendar'),
(1220, 'Calendar Ending Hour'),
(1221, 'Calendar Interval'),
(1222, 'Calendar Screen'),
(1223, 'Calendar Settings'),
(1224, 'Calendar Settings (calendar)'),
(1225, 'Calendar Starting Hour'),
(1226, 'Calendar UI'),
(1227, 'Calendar View'),
(1228, 'calendar_external to events'),
(1229, 'Call Back Notes'),
(1230, 'Call to addForm() goes here.<br>'),
(1231, 'Callback'),
(1232, 'Callback Performed'),
(1233, 'Callback requested'),
(1234, 'Calories'),
(1235, 'Cambodian'),
(1236, 'CAMOS'),
(1237, 'Can not determine OS!'),
(1238, 'Can not set this unless the Summary of Care Sent toggle is set.'),
(1239, 'Can\'t find file!'),
(1240, 'Can\'t upload'),
(1241, 'Canada'),
(1242, 'Cancel'),
(1243, 'cancel'),
(1244, 'Cancel Changes'),
(1245, 'Canceled'),
(1246, 'Canceled < 24h'),
(1247, 'Cancer'),
(1248, 'Cancer Screening: Colon Cancer Screening'),
(1249, 'Cancer Screening: Mammogram'),
(1250, 'Cancer Screening: Pap Smear'),
(1251, 'Cancer Screening: Prostate Cancer Screening'),
(1252, 'Cannot add this entry because it already exists!'),
(1253, 'Cannot add/update this entry because a duplicate already exists!'),
(1254, 'cannot be archived, ignored'),
(1255, 'cannot be converted to JPEG. Perhaps ImageMagick is not installed?'),
(1256, 'cannot be deleted, ignored'),
(1257, 'cannot be displayed inline because its type is not supported by the browser.'),
(1258, 'cannot be displayed inline becuase its type is not supported by the browser'),
(1259, 'cannot be displayed inline becuase its type is not supported by the browser.'),
(1260, 'Cannot be used in case of the absence of the cellular coverage'),
(1261, 'Cannot create'),
(1262, 'Cannot create file'),
(1263, 'Cannot delete (from SFTP server) file'),
(1264, 'Cannot delete file'),
(1265, 'Cannot determine a destination filename'),
(1266, 'Cannot find '),
(1267, 'Cannot find a destination filename'),
(1268, 'Cannot find a skip source field for'),
(1269, 'Cannot find a skip target field for'),
(1270, 'Cannot find patient from SQL-Ledger customer id'),
(1271, 'Cannot find postscript document reference in '),
(1272, 'Cannot find provider from SQL-Ledger employee = '),
(1273, 'Cannot Modify Payments.Undistributed is Negative.'),
(1274, 'Cannot open'),
(1275, 'Cannot open '),
(1276, 'Cannot Post for Insurance.The Paying Entity selected is Patient.'),
(1277, 'Cannot Post for Patient.The Paying Entity selected is Insurance.'),
(1278, 'Cannot Post Payments.Undistributed is Negative.'),
(1279, 'Cannot read'),
(1280, 'Cannot read directory'),
(1281, 'Cannot update because you are not editing an existing entry!'),
(1282, 'Capitalize'),
(1283, 'Capitalize all'),
(1284, 'capsule'),
(1285, 'Card'),
(1286, 'Card CVV'),
(1287, 'Card Expiry Date'),
(1288, 'Card Expiry Date and Card Holders Zip'),
(1289, 'Card Holder Zip'),
(1290, 'Card Name'),
(1291, 'Card Number'),
(1292, 'Card Type'),
(1293, 'Cardiac'),
(1294, 'Cardiac Catheterization'),
(1295, 'Cardiac Echo'),
(1296, 'Cardiovascular'),
(1297, 'Care Coordination'),
(1298, 'Care Coordination Only'),
(1299, 'Care documentation'),
(1300, 'Care giver'),
(1301, 'Care Plan'),
(1302, 'Care Plan Form'),
(1303, 'Care plan recommendations'),
(1304, 'Care Team'),
(1305, 'Careful planning is essential before entering the tests to ensure subsequent ease of use and proper display of results'),
(1306, 'Carotid Bruit'),
(1307, 'Carotid{{carotid arteries}}'),
(1308, 'Cartilage / chondral / disc damage'),
(1309, 'Cartilage injury'),
(1310, 'Cartoid pulsations nl, pedal pulses nl'),
(1311, 'CAR{{carotid arteries}}'),
(1312, 'cash'),
(1313, 'Cash'),
(1314, 'Cash Rec'),
(1315, 'Cash Receipts by Provider'),
(1316, 'Catalan- Valencian'),
(1317, 'Cataract'),
(1318, 'Cataract Surgery'),
(1319, 'Cataracts'),
(1320, 'Categories'),
(1321, 'Categories for'),
(1322, 'Category'),
(1323, 'category'),
(1324, 'Category '),
(1325, 'Category - Order, Result and Recommendation need an identifying code'),
(1326, 'Category changed.'),
(1327, 'Category Color Schema'),
(1328, 'Category Details'),
(1329, 'Category Limits'),
(1330, 'Category Name'),
(1331, 'Category name is empty'),
(1332, 'Category/Title'),
(1333, 'Caucasian'),
(1334, 'Causes Receipts to Print Encounter/Primary Provider Info'),
(1335, 'cc Distance{{with correction at distance}}'),
(1336, 'cc Near{{with correction at Near}}'),
(1337, 'CCD'),
(1338, 'CCDA'),
(1339, 'ccDist{{ACT with Correction Distance}}'),
(1340, 'ccDist{{with correction distance}}'),
(1341, 'ccNear{{ACT with Correction Near}}'),
(1342, 'ccNear{{with correction at near}}'),
(1343, 'CCR'),
(1344, 'CCR Approve'),
(1345, 'CCR Patient Review'),
(1346, 'CCR Review and Approve'),
(1347, 'CC{{Chief Complaint}}'),
(1348, 'cc{{with correction}}'),
(1349, 'CC{{with correction}}'),
(1350, 'CDA defines building blocks which can be used to contain healthcare data elements that can be captured, stored, accessed, displayed and transmitted electronically for use and reuse in many formats'),
(1351, 'CDA or Clinical Document Architecture is a document standard developed by the HL7 organization'),
(1352, 'CDC Code'),
(1353, 'CDC-NIP Code'),
(1354, 'CDR'),
(1355, 'CDR Reports Processing Priority'),
(1356, 'Cell'),
(1357, 'Cell Phone'),
(1358, 'Cell phone number'),
(1359, 'Cell Phone Number'),
(1360, 'Central Certification'),
(1361, 'Central Macular Thickness'),
(1362, 'Central/South American'),
(1363, 'Certificate Authority crt file location cannot be empty'),
(1364, 'Certificate Authority key file location cannot be empty'),
(1365, 'Certificate to send to RFC 5425 TLS syslog server.'),
(1366, 'Certificate User'),
(1367, 'Certificates'),
(1368, 'Chamorro'),
(1369, 'ChampUS'),
(1370, 'ChampUSVA'),
(1371, 'change'),
(1372, 'Change'),
(1373, 'Change Activity'),
(1374, 'Change any item available and when ready click Send for review. The changes will be flagged and staff notified to review changes before commiting them to chart. During the time period before changes are reviewed the Revised button will show Pending and profile data is still available for changes. When accessing profile in pending state all previous edits will appear in Blue and current chart values in Red. You may revert any edit to chart value by clicking that red item (or vica versa) but remember that when you click Send for Review then items that populate the field items are the ones that are sent. Revert Edits button changes everything back to chart values and you may make changes from there. So to recap: Items in BLUE are patient edits with items in RED being original values before any edits.'),
(1375, 'Change failed! CouchDB connect error?'),
(1376, 'Change in Vision'),
(1377, 'Change In Vision'),
(1378, 'Change Password'),
(1379, 'Change Password for'),
(1380, 'Change Status for'),
(1381, 'Changed'),
(1382, 'Changed Bowel'),
(1383, 'Changing patient ID for document'),
(1384, 'Changing the status to Done will remove the message from the active message list'),
(1385, 'Changing the status to New will achieve the same result'),
(1386, 'Changing the status to Read would leave it as a read message in the active messages list of the current user'),
(1387, 'Channels'),
(1388, 'Characteristics'),
(1389, 'Characters Remaining'),
(1390, 'Charge'),
(1391, 'Charge adjustment'),
(1392, 'Charge Coded'),
(1393, 'Charge Total'),
(1394, 'Charges'),
(1395, 'Chart'),
(1396, 'Chart Activity'),
(1397, 'Chart Check-in/out Activity Report'),
(1398, 'Chart ID'),
(1399, 'Chart ID:'),
(1400, 'Chart Label'),
(1401, 'Chart Location Activity'),
(1402, 'Chart Note'),
(1403, 'Chart Number'),
(1404, 'Chart pulled'),
(1405, 'Chart Storage Locations'),
(1406, 'Chart Tracker'),
(1407, 'Chart Trk'),
(1408, 'Charts Checked Out'),
(1409, 'Charts Out'),
(1410, 'Chat'),
(1411, 'Chat history'),
(1412, 'Chechen'),
(1413, 'Check'),
(1414, 'check'),
(1415, 'Check All'),
(1416, 'Check All - Components'),
(1417, 'Check Amount'),
(1418, 'Check and adjust the settings in the standard release'),
(1419, 'Check Date'),
(1420, 'Check expiration dates.'),
(1421, 'Check for differences of translations with custom language table.'),
(1422, 'Check if a help file exists for this page in'),
(1423, 'Check if you plan to print postcards locally'),
(1424, 'Check if you plan to send postcards via MedEx'),
(1425, 'Check if you plan to use Avery Labels for Reminders or Recalls'),
(1426, 'Check In'),
(1427, 'Check In To'),
(1428, 'Check Input Data'),
(1429, 'Check items to graph'),
(1430, 'Check Lab Results'),
(1431, 'Check mark indicates reviewed'),
(1432, 'Check No'),
(1433, 'Check Number'),
(1434, 'Check Out'),
(1435, 'Check Out Time'),
(1436, 'Check Payment'),
(1437, 'Check the box if this is an encrypted file'),
(1438, 'Check the CPOE (Computerized Provider Order Entry) check-box'),
(1439, 'Check the Enable phiMail Direct Messaging Service check-box'),
(1440, 'Check the Sequence numbers'),
(1441, 'Check this if you want providers to see all appointments by default and not just their own.'),
(1442, 'Check this to go live. Not checked is testing mode.'),
(1443, 'Check to create problem from this diagnosis'),
(1444, 'Check/EOB Date'),
(1445, 'Check/EOB Date:'),
(1446, 'Check/EOB No.'),
(1447, 'Check/EOB No.:'),
(1448, 'Check/Ref Number'),
(1449, 'Check/Reference Number'),
(1450, 'Checkbox list'),
(1451, 'checkbox list'),
(1452, 'checkbox w/ text'),
(1453, 'Checkbox w/text'),
(1454, 'Checkbox(es)'),
(1455, 'Checkboxes above indicate if you want to reject and delete the HL7 file.'),
(1456, 'Checkboxes w/text'),
(1457, 'Checked'),
(1458, 'checked'),
(1459, 'Checked box = yes ,  empty = no'),
(1460, 'Checked box = yes, empty = no'),
(1461, 'Checked Drug Formulary?'),
(1462, 'Checked Out'),
(1463, 'Checked out'),
(1464, 'Checking any of the check boxes will result in a Yes on the CMS 1500 form'),
(1465, 'Checking the Groups and Access Controls checkbox will reveal this section that lists all the categories with sub-categories (ACOs), i.e. the parts of the program controlled by the access control list privileges.'),
(1466, 'Checking the lock checkbox will prevent any futher edits on any forms in this encounter.'),
(1467, 'Checking the Postcards check box will let you print a postcard that can be mailed to a patient'),
(1468, 'Checkout'),
(1469, 'Checksum'),
(1470, 'Chest'),
(1471, 'Chest CTAB'),
(1472, 'Chest Pain'),
(1473, 'Chest Pain:'),
(1474, 'Chest Pains'),
(1475, 'Chest physician'),
(1476, 'Chg'),
(1477, 'Chichewa- Chewa- Nyanja'),
(1478, 'Chief Complaint'),
(1479, 'Chief Complaint 2'),
(1480, 'Chief Complaint 3'),
(1481, 'Child'),
(1482, 'Child in-law'),
(1483, 'Childhood immunization Status (CQM)'),
(1484, 'Chills'),
(1485, 'Chinese'),
(1486, 'Chinese (Simplified)'),
(1487, 'Chinese (Traditional)'),
(1488, 'Chiropractic'),
(1489, 'Choices'),
(1490, 'Cholecystectomy'),
(1491, 'cholecystectomy'),
(1492, 'Cholecystestomy'),
(1493, 'Choose'),
(1494, 'choose'),
(1495, 'Choose a period or dates (YYYY-MM-DD)'),
(1496, 'Choose a section and click an item within it; then in the other section you will see the related items highlighted, and you can click in that section to add and delete relationships.'),
(1497, 'Choose Criteria'),
(1498, 'Choose CSV table'),
(1499, 'Choose Download or Display Inline'),
(1500, 'Choose either current provider or current logged in provider'),
(1501, 'Choose File'),
(1502, 'Choose from list'),
(1503, 'Choose Layout Direction'),
(1504, 'Choose list'),
(1505, 'Choose one if appropriate'),
(1506, 'Choose one of the four return values that reflect varying degrees of privilege.'),
(1507, 'Choose Paper Size'),
(1508, 'Choose Patient'),
(1509, 'Choose PDF languange Preference'),
(1510, 'Choose print format for this encounter report.'),
(1511, 'Choose the layout (need to logout and then login to see this new setting).'),
(1512, 'Choose your default encounter view'),
(1513, 'Chrome browser version 41 and above, Mozilla Firefox browser version 64 and above, Microsoft Edge browser version 19 and above, Safari browser version 13 and above, Opera browser version 40 and Opera browser version 42 and above support FIDO U2F API'),
(1514, 'Chronic Bronchitis'),
(1515, 'Chronic Joint Pain'),
(1516, 'Chronic Kidney Disease (CKD)'),
(1517, 'Chronic or Inactive Problems'),
(1518, 'Chronic Problems'),
(1519, 'Chronic synovitis / effusion / joint pain / gout'),
(1520, 'Chronic/Inactive Problems'),
(1521, 'Chronic/Recurrent'),
(1522, 'Chuvash'),
(1523, 'Cigs'),
(1524, 'Cirrhosis of the Liver'),
(1525, 'Cirrhosis Of The Liver'),
(1526, 'City'),
(1527, 'City Name'),
(1528, 'City, State'),
(1529, 'City, State Zip'),
(1530, 'City,St,Zip'),
(1531, 'City/State'),
(1532, 'Claim'),
(1533, 'Claim '),
(1534, 'Claim Edit'),
(1535, 'Claim Status'),
(1536, 'Claim test has completed running'),
(1537, 'Claim Type'),
(1538, 'Claim was generated to file'),
(1539, 'Claim was generated to file '),
(1540, 'Claims'),
(1541, 'Classification'),
(1542, 'Clear'),
(1543, 'clear'),
(1544, 'Clear 2FA'),
(1545, 'CLEAR ACTIVE PATIENT'),
(1546, 'CLEAR ACTIVE THERAPY GROUP'),
(1547, 'Clear All'),
(1548, 'Clear Filters'),
(1549, 'Clear history'),
(1550, 'Clear HL7 Data'),
(1551, 'Clear Justification'),
(1552, 'Clear Pad'),
(1553, 'Clear Signature'),
(1554, 'Clear Smarty Cache'),
(1555, 'Clearing house info required for EDI 270 batch creation.'),
(1556, 'CLIA Number'),
(1557, 'Click'),
(1558, 'Click \'export\' to export your Category, Subcategory, Item, Content data to a text file. Any resemblance of this file to an XML file is purely coincidental. The opening and closing tags must be on the same line, they must be lowercase with no spaces. To import, browse for a file and click \'import\'. If the data is completely different, it will merge with your existing data. If there are similar item names, The old one will be kept and the new one saved with a number added to the end.'),
(1559, 'Click \'Save\''),
(1560, 'Click \'Save\'. Now you will be able to use the Search feature to search all ICD 10 codes'),
(1561, 'Click a spot on the graphic to add a new annotation, click it again to remove it'),
(1562, 'Click and drag bottom right corner to resize this display'),
(1563, 'Click Browse and select one Electronic Remittance Advice (ERA) file...'),
(1564, 'Click Close to exit the Select Codes pop-up page'),
(1565, 'Click Download Certificate to download the certificates in the file ssl.zip'),
(1566, 'click for more'),
(1567, 'Click for more details'),
(1568, 'Click for order summary'),
(1569, 'Click for results'),
(1570, 'Click for Shorthand Help.'),
(1571, 'Click here'),
(1572, 'Click Here to add a new patient.'),
(1573, 'Click here to add new injury change status and edit daily activity'),
(1574, 'Click here to add new row'),
(1575, 'Click here to choose a date'),
(1576, 'Click here to choose a date and time'),
(1577, 'Click here to choose a start date'),
(1578, 'Click here to choose date time'),
(1579, 'Click here to choose date time from'),
(1580, 'Click here to choose date time to'),
(1581, 'Click Here to Configure This module'),
(1582, 'Click here to delete the row'),
(1583, 'Click here to delete the selection'),
(1584, 'Click Here to Disable This module'),
(1585, 'Click here to duplicate the row'),
(1586, 'Click here to edit list of available Lens Materials'),
(1587, 'Click here to edit list of available Lens Treatment Options'),
(1588, 'Click here to Edit the Contact Lens Brand List'),
(1589, 'Click here to Edit the Course/Occurrence List'),
(1590, 'Click here to Edit the Manufacter List'),
(1591, 'Click here to Edit the Supplier List'),
(1592, 'Click here to Edit this Doctor\'s Plan options'),
(1593, 'Click here to Edit this Doctor\'s Quick Pick list'),
(1594, 'Click here to Edit this Provider\'s Exam Default values'),
(1595, 'Click Here to Enable This module'),
(1596, 'Click Here to Install This module'),
(1597, 'click here to search'),
(1598, 'Click here to see observation results'),
(1599, 'click here to update priority, category and nickname settings'),
(1600, 'click here to update priority, category, nickname and access control settings'),
(1601, 'Click here to view all.'),
(1602, 'Click here to view and graph'),
(1603, 'Click here to view and graph all labdata.'),
(1604, 'Click here to view and graph all vitals.'),
(1605, 'Click here to view patient details'),
(1606, 'Click here to view them all.'),
(1607, 'Click here to view/edit more details'),
(1608, 'Click in signature on file'),
(1609, 'Click Install button to install database release from the following date'),
(1610, 'Click OK if you are sure.'),
(1611, 'Click OK to Clear or Cancel to continue processing.'),
(1612, 'Click OK to import these patients into the patient input box'),
(1613, 'Click on Add to bring up the Add/Edit Issue pop-up page'),
(1614, 'Click on Add to List button to add to the bottom section'),
(1615, 'Click on any of the time parts to increase it'),
(1616, 'Click on Create New Transaction to open the Add/Edit Patient Transaction page'),
(1617, 'Click on either the Invoice Search button on the far right, for manual entry or ERA Upload button for uploading an entire electronic remittance advice ERA file'),
(1618, 'Click on the \'Add Group\' button to create this new group (ARO).'),
(1619, 'Click on the + sign adjacent to the Serum Uric Acid test Name to reveal the newly created Result line'),
(1620, 'Click on the + sign at the far end of the Blood Glucose line to bring up the Enter Details pop-up in the Add Mode'),
(1621, 'Click on the Add icon at the far end of the Serum Chemistry line'),
(1622, 'Click on the Add New dropdown box and select an option'),
(1623, 'Click on the Allergy/Intolerance button'),
(1624, 'Click on the black + sign at the far end of the Well Woman Tests line to create a direct descendant or child to this Custom Top Group'),
(1625, 'Click on the black + sign on the Electrolyte Panel line to create a direct descendant or child'),
(1626, 'Click on the blue + sign to see the Procedure Order that was saved'),
(1627, 'Click on the blue plus sign under Name to reveal test names'),
(1628, 'Click on the Diagnosis Codes box to open the Select Diagnosis Codes pop-up window'),
(1629, 'Click on the File menu item on the top left of the Message center page ansd select Setup MedEx'),
(1630, 'Click on the icon next to the \'Access Control List Administration\' title to go to the phpGACL page.'),
(1631, 'Click on the Issues menu item to bring up the Issues page'),
(1632, 'Click on the Ledger menu item in the navigation bar to to enter the Patient Ledger page'),
(1633, 'Click on the Name text box on the left section to bring up the patient finder pop-up'),
(1634, 'Click on the New Recall button to open a new recall scheduling page'),
(1635, 'Click on the the following link to learn more about what is involved.'),
(1636, 'Click Patient Name to Open Patient File'),
(1637, 'Click Refresh and click on the blue + mark that precedes the name Serum Chemistry'),
(1638, 'Click Refresh to view all results, or please input search criteria above to view specific results.'),
(1639, 'Click Register to register the TOTP'),
(1640, 'Click Save'),
(1641, 'Click Save and then Refresh'),
(1642, 'Click Save to close the pop-up'),
(1643, 'Click Save to close the pop-up window'),
(1644, 'Click Save to create a new line with a Name of Well Womans Tests preceded by a vertical line indicating that it has no descendants or children'),
(1645, 'Click Save to save and close the pop-up'),
(1646, 'Click Save to save this problem'),
(1647, 'Click the \'Add New Group\' button to display the \'New Group Information\' section.'),
(1648, 'Click the \'Delete Group\' button to completely remove this group.'),
(1649, 'Click the \'Remove Group\' button to display the \'Remove Group Form\'.'),
(1650, 'Click the \'Yes\' radio button.'),
(1651, 'Click the Clear button to clear the imported patient names and start afresh'),
(1652, 'Click the Clear button to start afresh'),
(1653, 'Click the Delete button to delete all selected codes or select individual codes to be deleted from the drop-down box adjacent to the delete button and then click the Delete button'),
(1654, 'Click the pencil icon to grant and remove access privileges to the selected user'),
(1655, 'Click the Save button'),
(1656, 'Click the Search for Allergy button'),
(1657, 'Click the slashed-eye icon to close.'),
(1658, 'Click the Submit button to display the main log'),
(1659, 'Click the Transmit button to reveal the Direct address box'),
(1660, 'Click this to display/hide additional tests'),
(1661, 'Click to activate and send to this recipient.'),
(1662, 'Click to add a diagnosis'),
(1663, 'Click to add HCFA 1500 miscellaneous billing options'),
(1664, 'Click to add new components'),
(1665, 'Click to add new consultation'),
(1666, 'Click to add patient'),
(1667, 'Click to choose diagnoses to justify.'),
(1668, 'Click to Contract and set to henceforth open in Centered mode'),
(1669, 'Click to display shorthand field names.'),
(1670, 'Click to download'),
(1671, 'Click to edit'),
(1672, 'Click to edit description'),
(1673, 'Click to edit this event'),
(1674, 'Click to Expand and set to henceforth open in Expanded mode'),
(1675, 'Click to generate the report'),
(1676, 'Click to go to page'),
(1677, 'Click to Hide'),
(1678, 'Click to hide advanced search'),
(1679, 'Click to Hide Filters'),
(1680, 'Click to hide search'),
(1681, 'Click to learn more about the Clinical Document Architecture (CDA) and Consolidated CDA (C-CDA)'),
(1682, 'Click to make chat this current recipient only...'),
(1683, 'Click to manually configure access control, recommended for advanced users'),
(1684, 'Click to match patient'),
(1685, 'Click to print'),
(1686, 'Click to receive (add) new lot'),
(1687, 'Click to reveal more information'),
(1688, 'Click to see more information'),
(1689, 'Click to select'),
(1690, 'Click To Select'),
(1691, 'Click to select a default diagnosis or procedure code for this order'),
(1692, 'Click to select an industry-standard code for this procedure'),
(1693, 'Click to select diagnosis or procedure code to default to order'),
(1694, 'Click to select group'),
(1695, 'Click to select optional procedure code'),
(1696, 'Click to select or change coding'),
(1697, 'Click to select or change CVX code'),
(1698, 'Click to select or change diagnoses'),
(1699, 'Click to select or change service codes'),
(1700, 'Click to select patient'),
(1701, 'Click to select related code'),
(1702, 'Click to select services to perform if this result is abnormal'),
(1703, 'Click to select services to perform if this result is abnormal.'),
(1704, 'Click to select services to perform if this result is abnormal. This is optional'),
(1705, 'Click to select the desired procedure'),
(1706, 'Click to Show'),
(1707, 'Click to show advanced search'),
(1708, 'Click to Show Filters'),
(1709, 'Click to show messages for all users'),
(1710, 'Click to show messages for only the current user'),
(1711, 'Click to show search'),
(1712, 'Click to sort'),
(1713, 'Click to view'),
(1714, 'Click to view Help'),
(1715, 'Click to view or edit'),
(1716, 'Click to view/edit'),
(1717, 'Click Update List to display billing information filtered by the selected Current Criteria'),
(1718, 'Click Upgrade button to upgrade database release from the following date'),
(1719, 'Click where indicated above to match the patient.'),
(1720, 'Click:'),
(1721, 'Clicking on \'Review\' will list all the codes entered for previous encounters'),
(1722, 'Clicking on either the Enter Name or Enter ID tab will bring up the search box which you can use to select a patient'),
(1723, 'Clicking on Set As Completed will remove the reminder from the active display'),
(1724, 'Clicking on the + button on the patient header panel opens the New Encounter Form'),
(1725, 'Clicking on the Add Issue button brings up the add issue pop-up box'),
(1726, 'Clicking on the Coding cell will bring up the Educational materials pop-up that will let you search by ICD10 code'),
(1727, 'Clicking on the Create A Dated Reminder button will bring up the Send a Reminder popup'),
(1728, 'Clicking on the Create Online/Offsite Portal Credentials button will generate a username and password for the patient that has to be given to the patient'),
(1729, 'Clicking on the Delete button will delete the message'),
(1730, 'Clicking on the first cell under Title will bring up the Add/Edit Issue pop-up page that will let you edit this entry'),
(1731, 'Clicking on the icon next to the caption will display everyone\'s messages and the caption will change to All Messages'),
(1732, 'Clicking on the icon next to their name will bring up the \'Edit\' window.'),
(1733, 'Clicking on the Miscellaneous > MFA Management menu item or User Name > MFA Management menu item brings you to the landing page for managing the multi factor authentication page for that user'),
(1734, 'Clicking on the patient\'s name will reveal the message'),
(1735, 'Clicking on the pencil icon will enter the Edit mode and will display the Enter Details pop-up window that was used to create the entry displayed on this line'),
(1736, 'Clicking on the Show All or Show Inactive buttons will show the appropriate messages'),
(1737, 'Clicking on the slashed eye icon will hide the filters'),
(1738, 'Clicking on the View Log button will bring up the Dated Message Log popup'),
(1739, 'Clicking Options will present a multiselection drop menu to add behaviors to the selected data type. Typing after pull down activates allows search in options.'),
(1740, 'Clicking the button will reveal a popup that will list the E/M codes, check the appropriate code and click \'OK\''),
(1741, 'Clicking the Transmit button will open up a text box where the Direct address of the recipient needs to be entered'),
(1742, 'Client Certificate Expiration Days'),
(1743, 'Client certificate validation period'),
(1744, 'Client certificate validity should be a valid number.'),
(1745, 'Client Copy'),
(1746, 'Client ID'),
(1747, 'Client medical history summary'),
(1748, 'Client Name'),
(1749, 'Client Number'),
(1750, 'Client Profile - New Clients'),
(1751, 'Client Profile - Unique Clients'),
(1752, 'Clients'),
(1753, 'Clinic'),
(1754, 'Clinic Copy'),
(1755, 'Clinic Daily Record'),
(1756, 'Clinic ID'),
(1757, 'Clinical'),
(1758, 'Clinical Decision Rules Alert Manager'),
(1759, 'Clinical documents are produced by arranging or limiting CDA elements in defined ways using templates and Implementation Guides (IG)'),
(1760, 'Clinical History'),
(1761, 'Clinical Instructions'),
(1762, 'Clinical Instructions Form'),
(1763, 'Clinical Plans'),
(1764, 'Clinical Quality Measures (CQM)'),
(1765, 'Clinical Quality Measures (CQM) - 2011'),
(1766, 'Clinical Quality Measures (CQM) - 2014'),
(1767, 'Clinical Reminders'),
(1768, 'Clinical Reminders - is a widget that displays the Passive Alerts for a Clinical Decision Rule'),
(1769, 'Clinical Reminders/Alerts (write,addonly optional)'),
(1770, 'Clinical Reminders/Alerts (write,addonly optional) (alert)'),
(1771, 'Clinical Reports'),
(1772, 'Clinical Rule Action Category'),
(1773, 'Clinical Rule Action Item'),
(1774, 'Clinical Rule Filter Methods'),
(1775, 'Clinical Rule Target Methods'),
(1776, 'Clinical Rules'),
(1777, 'Clinical Rules Age Intervals'),
(1778, 'Clinical Rules Comparisons'),
(1779, 'Clinical Rules Encounter Types'),
(1780, 'Clinical Rules Reminder Due Options'),
(1781, 'Clinical Rules Reminder Inactivation Options'),
(1782, 'Clinical Rules Reminder Intervals'),
(1783, 'Clinical Rules Reminder Methods'),
(1784, 'Clinical Rules Target Intervals'),
(1785, 'Clinical targets'),
(1786, 'Clinical Term'),
(1787, 'Clinical Term Code(s)'),
(1788, 'Clinical View'),
(1789, 'Clinicians'),
(1790, 'Clone'),
(1791, 'Clone Past Visit'),
(1792, 'Close'),
(1793, 'close'),
(1794, 'Close All Current Rx Panels and make this a Preference to stay closed'),
(1795, 'Close and make this a Preference to stay closed'),
(1796, 'Close this panel and delete this Rx'),
(1797, 'Close this panel and make this a Preference to stay closed'),
(1798, 'Close Window'),
(1799, 'close window'),
(1800, 'Close...'),
(1801, 'Closed'),
(1802, 'cm'),
(1803, 'CMS 1500 incl FORM'),
(1804, 'CMS 1500 Margins'),
(1805, 'CMS 1500 Margins Left'),
(1806, 'CMS 1500 Paper Form Format'),
(1807, 'CMS 1500 PDF'),
(1808, 'CMS 1500 PREPRINTED FORM'),
(1809, 'CMS 1500 TEXT'),
(1810, 'CMS 1500 was revised on 2012-02-01 and is hence called Form 1500 (02-12) and is set to expire on 2020-03-31. As of April 1, 2014 only the revised, 02-12 version is accepted.'),
(1811, 'CMS 1500: Box 31 Format'),
(1812, 'CMS 1500: Date in Box 31 (Signature)'),
(1813, 'CMS ID'),
(1814, 'CMS ID For Encounter Claims'),
(1815, 'CMS Portal'),
(1816, 'CMS Portal Login'),
(1817, 'CMS Portal Login ID'),
(1818, 'CMS Portal not enabled!'),
(1819, 'CMS Portal Password'),
(1820, 'CMS Portal Request'),
(1821, 'CMS Portal Site Address'),
(1822, 'CMS Portal Username'),
(1823, 'Cmsportal Login'),
(1824, 'CMT{{Central Macular Thickness}}'),
(1825, 'CN VII{{cranial nerve seven}}'),
(1826, 'CN V{{cranial nerve five}}'),
(1827, 'CN2-12 intact'),
(1828, 'CN5{{cranial nerve five}}'),
(1829, 'CN7{{cranial nerve seven}}'),
(1830, 'Co Pay'),
(1831, 'Co Pay Paid'),
(1832, 'Co-managing/referring provider'),
(1833, 'CO-PAY'),
(1834, 'Co-Payment'),
(1835, 'Code'),
(1836, 'code'),
(1837, 'Code Finder'),
(1838, 'Code must be two letter lowercase'),
(1839, 'Code or symbol to indicate currency'),
(1840, 'Code Search'),
(1841, 'Code Text'),
(1842, 'Code Type'),
(1843, 'code type'),
(1844, 'Code type not recognized'),
(1845, 'Code type not yet defined'),
(1846, 'Code Types'),
(1847, 'Code(s)'),
(1848, 'Coded'),
(1849, 'Codes'),
(1850, 'Codes - Leave blank'),
(1851, 'Coding'),
(1852, 'Coding (click for education)'),
(1853, 'Coding - any encounters (write,wsome optional)'),
(1854, 'Coding - any encounters (write,wsome optional) (coding_a)'),
(1855, 'Coding - my encounters (write,wsome optional)'),
(1856, 'Coding - my encounters (write,wsome optional) (coding)'),
(1857, 'Coding complete'),
(1858, 'Coding done'),
(1859, 'Coding Engine'),
(1860, 'Coding not authorized'),
(1861, 'Coffee'),
(1862, 'Coffee Use'),
(1863, 'Coins'),
(1864, 'Coinsurance'),
(1865, 'Coll w/o'),
(1866, 'Collaborator'),
(1867, 'Collapse'),
(1868, 'collapse'),
(1869, 'Collapse All'),
(1870, 'Collapse all'),
(1871, 'collapse all'),
(1872, 'Collect For'),
(1873, 'Collect Payment'),
(1874, 'Collected'),
(1875, 'Collection Date'),
(1876, 'Collection Date/Time'),
(1877, 'Collections'),
(1878, 'Collections Report'),
(1879, 'Colon Cancer'),
(1880, 'Colon Cancer Screening'),
(1881, 'Colon Cancer Surgery'),
(1882, 'Colonoscopy'),
(1883, 'colonoscopy'),
(1884, 'Color'),
(1885, 'Color for even sets (except when last set is even and all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed) or not all member appointments are displayed).'),
(1886, 'Color for odd sets (except when last set is odd and all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed) or not all member appointments are displayed).'),
(1887, 'Color for the last set when all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed).'),
(1888, 'Color for the last set when not all member appointments are displayed.'),
(1889, 'Color Vision'),
(1890, 'Color:Abbr'),
(1891, 'Column'),
(1892, 'Columns'),
(1893, 'Combine Reminders'),
(1894, 'Combining Lots'),
(1895, 'Comma'),
(1896, 'Comment'),
(1897, 'Comments'),
(1898, 'Comments for this result or recommendation'),
(1899, 'Commercial Insurance Co.'),
(1900, 'Commit Changes'),
(1901, 'Commonly used standards are HOTP (hash-based one-time password, RFC4226), TOTP (time-based one-time password or OCRA (OATH challenge-response algorithm, RFC6287) that were developed and are supported by the OATH (Initiative for Open Authentication)'),
(1902, 'Communication'),
(1903, 'Communication Engine'),
(1904, 'Communications'),
(1905, 'Community health physician'),
(1906, 'Community Mental Health Center'),
(1907, 'Company'),
(1908, 'Company Name'),
(1909, 'Complete'),
(1910, 'Complete Visit Time'),
(1911, 'Completed'),
(1912, 'completed'),
(1913, 'Completed Ad'),
(1914, 'Completed?'),
(1915, 'Completely remove the ability to display the Patient Flow Board.'),
(1916, 'Completion Status'),
(1917, 'Complications by Service Provider'),
(1918, 'Complications of Abortion'),
(1919, 'Components'),
(1920, 'Compose Message'),
(1921, 'Compose new'),
(1922, 'Comprehensive Inpatient Rehabilitation Facility'),
(1923, 'Comprehensive Outpatient Rehabilitation Facility'),
(1924, 'Computer Aided Medical Ordering System'),
(1925, 'Conclusions'),
(1926, 'Condition'),
(1927, 'Condition field not found'),
(1928, 'Condition Status'),
(1929, 'Config'),
(1930, 'Configuration'),
(1931, 'Configuration Export/Import'),
(1932, 'Configuration saved successfully'),
(1933, 'Configure Apache and OpenEMR to use Client side SSL certificates.'),
(1934, 'Configure Apache to use Client side SSL certificates'),
(1935, 'Configure Apache to use HTTPS.'),
(1936, 'Configure Openemr to use Client side SSL certificates'),
(1937, 'Configure Orders and Results'),
(1938, 'Configure Orders Help'),
(1939, 'Configure the lab test structure'),
(1940, 'Configure tracks'),
(1941, 'Configure Tracks'),
(1942, 'Configuring Multiple Orders'),
(1943, 'Configuring multiple orders'),
(1944, 'Confirm'),
(1945, 'Confirm Create New Patient'),
(1946, 'Confirm Email Address'),
(1947, 'Confirm New Password'),
(1948, 'Confirm Payment'),
(1949, 'Confirm to Delete Current Thread?'),
(1950, 'Confirm to Delete Selected?'),
(1951, 'Confirm to remove item'),
(1952, 'Confirmed'),
(1953, 'Conflicted Allergies'),
(1954, 'Conflicted Medications'),
(1955, 'Conflicted Problems'),
(1956, 'Congenital'),
(1957, 'Congratulations for enabling 2FA'),
(1958, 'Conjuntiva, pupils'),
(1959, 'Conj{{Conjunctiva}}'),
(1960, 'Connection error'),
(1961, 'Connectors'),
(1962, 'Constant'),
(1963, 'constant name'),
(1964, 'Constant name is blank'),
(1965, 'constants'),
(1966, 'Constipation'),
(1967, 'Constitutional'),
(1968, 'Construction Firm'),
(1969, 'Consultant physician'),
(1970, 'Consultation Brief Description'),
(1971, 'Consultation Notes - 2008'),
(1972, 'Contact'),
(1973, 'Contact Email'),
(1974, 'Contact Email Address'),
(1975, 'Contact EMR Direct to subscribe to the phiMail Direct messaging service'),
(1976, 'contact info'),
(1977, 'Contact Lens'),
(1978, 'Contact Lens Refraction'),
(1979, 'Contact Lenses'),
(1980, 'Contact Medical Information Integration, LLC at http://mi-squared.com for Lab Exchange Service.'),
(1981, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing the eRx service'),
(1982, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing to the NewCrop eRx service.'),
(1983, 'Contact mi-squared at http://www.mi-squared.com/products-services/openemr/ or ZH Healthcare at https://blueehr.com/contact-us/ for subscribing to the NewCrop eRx service.'),
(1984, 'Contact name'),
(1985, 'Contact Open Med Practice, www.openmedpractice.com for subscribing to the Weno Free eRx service.'),
(1986, 'Contact or Notify Phone'),
(1987, 'Contact Person'),
(1988, 'Contact Phone'),
(1989, 'Contact Phone Number'),
(1990, 'Contact Relationship'),
(1991, 'Contact ZMG, LLC (zmghealth@gmail.com) for subscribing the eRx service'),
(1992, 'Contacts'),
(1993, 'contain at least three of the four following items:'),
(1994, 'Container Group Name'),
(1995, 'Content'),
(1996, 'content'),
(1997, 'Contents'),
(1998, 'Context'),
(1999, 'Context name can\'t be empty'),
(2000, 'Continue'),
(2001, 'Continuity of Care Document'),
(2002, 'Continuity of Care Document (CCD)'),
(2003, 'Continuity of Care Document (CCD) is an electronic document containing patient specific information that aids in continuity of care'),
(2004, 'Continuity of Care Document (CCD) is meant to be created at the conclusion of an encounter prior to transfer of care to enable the next provider to easily access such information'),
(2005, 'Continuity of Care Record (CCR)'),
(2006, 'Contra Clients'),
(2007, 'Contraception'),
(2008, 'Contraception Issues'),
(2009, 'Contraceptive Complication (specify)'),
(2010, 'Contraceptive Method'),
(2011, 'Contraceptive Products'),
(2012, 'Contraceptive services previously started'),
(2013, 'Contraceptives Start'),
(2014, 'Contrast Acuity'),
(2015, 'Contrast Acuity Testing'),
(2016, 'Contrastart'),
(2017, 'Contrast{{Constrast Visual Acuity}}'),
(2018, 'Control ID'),
(2019, 'Control No.'),
(2020, 'Controlled Substance?'),
(2021, 'Convergence'),
(2022, 'Convergence Amps'),
(2023, 'Conversation'),
(2024, 'Conversation from'),
(2025, 'Convert a JavaScript object into a JSON string, and send it to the server.'),
(2026, 'Convert between plus and minus cylinder'),
(2027, 'Coordinating Counselors'),
(2028, 'COPAY'),
(2029, 'Copay'),
(2030, 'CoPay'),
(2031, 'Copay not positive'),
(2032, 'Copay Paid'),
(2033, 'Copays'),
(2034, 'COPD'),
(2035, 'Copy Pages to Patient Chart'),
(2036, 'Copy these values into current visit.'),
(2037, 'Copy Values'),
(2038, 'Copying the database file. This will take some time...'),
(2039, 'Copyright Notice'),
(2040, 'Cor Disease'),
(2041, 'Core'),
(2042, 'Cornea'),
(2043, 'Cornish'),
(2044, 'Coronary Artery Bypass'),
(2045, 'Coronary Artery Bypass Graft (CABG)'),
(2046, 'Corrected'),
(2047, 'Corsican'),
(2048, 'CouchDB'),
(2049, 'CouchDB Connection Failed.'),
(2050, 'CouchDB Database'),
(2051, 'CouchDB database name'),
(2052, 'CouchDB Error Log'),
(2053, 'CouchDB error log is empty'),
(2054, 'CouchDB host'),
(2055, 'CouchDB HostName'),
(2056, 'CouchDB Log Enable'),
(2057, 'CouchDB Password'),
(2058, 'CouchDB Port'),
(2059, 'CouchDB port'),
(2060, 'CouchDB save failed'),
(2061, 'CouchDB UserName'),
(2062, 'Cough'),
(2063, 'Cough:'),
(2064, 'could not connect to server'),
(2065, 'Could not find RxNorm Table! Please install.'),
(2066, 'Could not import the document. Please contact the EMR vendor.'),
(2067, 'could not open table'),
(2068, 'Could not read file'),
(2069, 'Could not read the file'),
(2070, 'Could not send email due to a server problem, '),
(2071, 'Could not send email due to a server problem.'),
(2072, 'Could not send email due to a server problem. '),
(2073, 'Couldn\'t create backup dir:'),
(2074, 'Couldn\'t remove dir:'),
(2075, 'Couldn\'t remove old backup file:'),
(2076, 'Couldn\'t remove old export file: '),
(2077, 'Coumadin Management - INR Monitoring'),
(2078, 'Couns by Method'),
(2079, 'Counseling'),
(2080, 'Counseling activities'),
(2081, 'Counselors'),
(2082, 'Counter Referral Form'),
(2083, 'COUNTER REFERRAL FORM'),
(2084, 'Counter-Referral'),
(2085, 'Country'),
(2086, 'Country Code'),
(2087, 'Country Data Type'),
(2088, 'Country list'),
(2089, 'Country List (write,addonly optional)'),
(2090, 'Country List (write,addonly optional) (country)'),
(2091, 'Country Name should be represent in two letters. (Example: United States is US)'),
(2092, 'county'),
(2093, 'County'),
(2094, 'Coupon'),
(2095, 'Course'),
(2096, 'Cousin'),
(2097, 'Coverage Level'),
(2098, 'Coverage Period'),
(2099, 'Coverage Type'),
(2100, 'CPOE'),
(2101, 'CPT'),
(2102, 'CPT Code'),
(2103, 'CPT Codes'),
(2104, 'CPT4 Procedure/Service'),
(2105, 'CPTII Performance Measures'),
(2106, 'CQM'),
(2107, 'CR (Wet)'),
(2108, 'Crackles:'),
(2109, 'Cranial Nerve 5: Trigeminal Nerve'),
(2110, 'Cranial Nerve 7: Facial Nerve'),
(2111, 'cream'),
(2112, 'Create a Client side SSL certificate for each user or client machine.'),
(2113, 'Create a client side SSL certificate for either a user or a client hostname.'),
(2114, 'CREATE A COUNTER-REFERRAL'),
(2115, 'Create A Dated Reminder'),
(2116, 'CREATE A LOCATION FOR RESULTS'),
(2117, 'Create a new track'),
(2118, 'CREATE A REFERRAL'),
(2119, 'Create a reminder to schedule a future visit'),
(2120, 'CREATE A SIMPLE TRANSACTION TYPE'),
(2121, 'Create a spreadsheet in openoffice/LibreOffice, have 5 columns - CPT Code, Description, Standard, Credit Card and Cash. Fill in the values. From this spreadsheet manually copy and paste the values via Administration > Codes'),
(2122, 'CREATE A TOP LEVEL CUSTOM GROUP'),
(2123, 'CREATE A TOP LEVEL ENTRY'),
(2124, 'Create an Event'),
(2125, 'CREATE AN ORDER'),
(2126, 'Create an Order for a Panel of Tests'),
(2127, 'Create an Order for a Single Test'),
(2128, 'Create and download a full backup'),
(2129, 'Create and modify tracks'),
(2130, 'Create Backup'),
(2131, 'Create batch'),
(2132, 'Create Client Certificate'),
(2133, 'Create Client side SSL certificates'),
(2134, 'Create custom white list of MIME content type of a files to secure your documents system'),
(2135, 'Create Date'),
(2136, 'Create Duplicate'),
(2137, 'Create Encounter'),
(2138, 'Create Eventlog Backup'),
(2139, 'Create new issue'),
(2140, 'Create New Message'),
(2141, 'Create New Patient'),
(2142, 'Create new Track'),
(2143, 'Create New Transaction'),
(2144, 'Create Offsite Portal Credentials'),
(2145, 'Create Online Portal Credentials'),
(2146, 'Create Onsite Portal Credentials'),
(2147, 'Create Patient'),
(2148, 'Create Patient Note'),
(2149, 'CREATE THE CUSTOM ORDERS'),
(2150, 'Create the SSL Certificate Authority and Server certificates.'),
(2151, 'Create Visit'),
(2152, 'Created'),
(2153, 'Creates a report that contains various sections of the patient\'s medical record'),
(2154, 'Creating a Custom Favorite Group to order frequently ordered tests together '),
(2155, 'Creating a Custom Group of Tests as Favorites'),
(2156, 'CREATING A NEW DATED REMINDER'),
(2157, 'CREATING A NEW MESSAGE'),
(2158, 'Creating and Managing Encounters'),
(2159, 'Creating anyway'),
(2160, 'Creating export file'),
(2161, 'Creating new track failed'),
(2162, 'Creating this file on remote host failed'),
(2163, 'Creator'),
(2164, 'credit'),
(2165, 'Credit Card'),
(2166, 'Credit or Debit Card'),
(2167, 'Credits'),
(2168, 'Cree'),
(2169, 'Criteria'),
(2170, 'Croatian'),
(2171, 'Crohn\'s Disease'),
(2172, 'Crohns Disease'),
(2173, 'CR{{Cycloplegic Refraction}}'),
(2174, 'CSV'),
(2175, 'CSV Export'),
(2176, 'CSV File'),
(2177, 'CSV Tables'),
(2178, 'CSV to calendar_external table'),
(2179, 'CTL'),
(2180, 'CTL{{Contact Lens Vision}}'),
(2181, 'CTL{{Contact Lens}}'),
(2182, 'CU.MM'),
(2183, 'Cuban'),
(2184, 'Cup'),
(2185, 'Currency Decimal Places'),
(2186, 'Currency Decimal Point Symbol'),
(2187, 'Currency Designator'),
(2188, 'Currency Thousands Separator'),
(2189, 'Current'),
(2190, 'Current Alcohol'),
(2191, 'Current Authentication Method for'),
(2192, 'Current Authentication Method for the logged in user'),
(2193, 'Current Consultation'),
(2194, 'Current Criteria'),
(2195, 'Current Day'),
(2196, 'Current day highlight color'),
(2197, 'Current every day smoker'),
(2198, 'Current Eye Meds'),
(2199, 'Current file name was changed to'),
(2200, 'Current Glasses'),
(2201, 'Current Hash'),
(2202, 'Current Location'),
(2203, 'Current Logged in User'),
(2204, 'Current Medications'),
(2205, 'Current Password'),
(2206, 'Current Patient'),
(2207, 'Current patient unavailable here. Use Patient Documents'),
(2208, 'Current Provider'),
(2209, 'Current Pt Only'),
(2210, 'Current Recipients'),
(2211, 'Current Recreational Drugs'),
(2212, 'Current RX'),
(2213, 'Current some day smoker'),
(2214, 'Current Status'),
(2215, 'Current Status Time'),
(2216, 'Current Target'),
(2217, 'Current user'),
(2218, 'Current Value'),
(2219, 'Currently Active'),
(2220, 'Currently Busy'),
(2221, 'Currently off-line'),
(2222, 'Currently Running'),
(2223, 'Currently there are 5 types of transactions in OpenEMR'),
(2224, 'Currently there are no facilities.'),
(2225, 'Currently working on making this document'),
(2226, 'Cushing Syndrom'),
(2227, 'Cushing Syndrome'),
(2228, 'Custodial Care Facility'),
(2229, 'Custodian'),
(2230, 'Custom'),
(2231, 'Custom Billing Phone Number'),
(2232, 'Custom Favorite Group - to group individual tests '),
(2233, 'Custom Favorite Group > Custom Favorite Item > Discrete results'),
(2234, 'Custom Favorite Group and Custom Favorite Item is used to create customized groups of orders'),
(2235, 'Custom Favorite Item  - for individual orders or tests'),
(2236, 'Custom Greeting'),
(2237, 'Custom input?'),
(2238, 'Custom Order'),
(2239, 'Custom Statement message'),
(2240, 'Custom Sub Group'),
(2241, 'Custom Table'),
(2242, 'Custom text for Flow Board postcards. After changing text, print samples before printing mass quantities!'),
(2243, 'Custom Top Group'),
(2244, 'Customize the Fee Sheet'),
(2245, 'Customize the Transaction Form'),
(2246, 'CVV'),
(2247, 'Cvx Code'),
(2248, 'CVX Code'),
(2249, 'CVX Code Mapping'),
(2250, 'CVX Immunization'),
(2251, 'CV{{Cardiovascular}}'),
(2252, 'Cycle'),
(2253, 'Cyclo 1%'),
(2254, 'CycloMydril'),
(2255, 'Cycloplegic (Wet) Refraction'),
(2256, 'Cyl{{Cylinder}}'),
(2257, 'CYL{{Cylinder}}'),
(2258, 'CYP'),
(2259, 'CYP Factor'),
(2260, 'CYP Report'),
(2261, 'Czech'),
(2262, 'D'),
(2263, 'D&C'),
(2264, 'D&E'),
(2265, 'D&V Full OU{{Ductions and Versions full both eyes}}'),
(2266, 'D.O.B.'),
(2267, 'daily'),
(2268, 'Daily Record'),
(2269, 'Daily Report'),
(2270, 'Daily Summary Report'),
(2271, 'Danish'),
(2272, 'Dashboard'),
(2273, 'Dashboard - summarizes all patient related information'),
(2274, 'Dashboard{{patient file}}'),
(2275, 'Data Alike is already in database, please change code and/or description'),
(2276, 'Data Alike is already in database, please change constant name'),
(2277, 'Data Cols'),
(2278, 'Data Enterer'),
(2279, 'Data Entry - Social Security Number'),
(2280, 'Data Error'),
(2281, 'Data from'),
(2282, 'Data integrity has been compromised'),
(2283, 'data of all encounters so far'),
(2284, 'Data Section'),
(2285, 'Data Type'),
(2286, 'Database'),
(2287, 'Database is not installed.'),
(2288, 'Database name'),
(2289, 'Database Patch'),
(2290, 'Database Reporting'),
(2291, 'Database Reporting (database)'),
(2292, 'Database upgrade finished.'),
(2293, 'DataCols must be a number between 1 and 999'),
(2294, 'Date'),
(2295, 'DATE'),
(2296, 'Date & Time Administered'),
(2297, 'Date / Time'),
(2298, 'Date Administered'),
(2299, 'Date and time of sample collection'),
(2300, 'Date and time of this observation'),
(2301, 'Date and time of this report'),
(2302, 'Date and time that the sample was collected'),
(2303, 'Date Cannot be greater than Today'),
(2304, 'Date contraceptive services initially provided'),
(2305, 'Date Created'),
(2306, 'Date Deceased'),
(2307, 'Date Destroyed'),
(2308, 'Date Display Format'),
(2309, 'Date format for \"appointment end\" is not valid'),
(2310, 'Date format for \"appointment start\" is not valid'),
(2311, 'Date format for \"Next Appointment\" is not valid'),
(2312, 'Date format for \"not seen since\" is not valid'),
(2313, 'Date format for \"seen before\" is not valid'),
(2314, 'Date format for \"seen since\" is not valid'),
(2315, 'Date Immunization Information Statements Given'),
(2316, 'Date is missing for code '),
(2317, 'Date Master Criteria'),
(2318, 'Date of appointments'),
(2319, 'Date of appointments mm/dd/yyyy'),
(2320, 'Date of bank deposit yyyy-mm-dd'),
(2321, 'Date of Billing'),
(2322, 'Date of Birth'),
(2323, 'Date of birth'),
(2324, 'Date Of Birth'),
(2325, 'Date of Birth and Age'),
(2326, 'Date of Entry'),
(2327, 'Date of exit'),
(2328, 'Date of Injury'),
(2329, 'Date of Onset'),
(2330, 'Date of onset or hospitalization'),
(2331, 'Date of onset, surgery or start of medication'),
(2332, 'Date of payment yyyy-mm-dd'),
(2333, 'Date of recovery or end of medication'),
(2334, 'Date of referral'),
(2335, 'Date of registration'),
(2336, 'Date of reply'),
(2337, 'Date of Report'),
(2338, 'Date of Service'),
(2339, 'Date of service'),
(2340, 'Date Of Service'),
(2341, 'Date of Service = Today'),
(2342, 'Date of Service is today\'s date by default. If needed it can be changed to any valid date'),
(2343, 'Date of service mm/dd/yyyy'),
(2344, 'Date of Service:'),
(2345, 'Date Of Signature'),
(2346, 'Date of Status Change'),
(2347, 'Date of this letter'),
(2348, 'Date of this order'),
(2349, 'Date of this report'),
(2350, 'Date of VIS Statement'),
(2351, 'Date Ordered'),
(2352, 'Date Range'),
(2353, 'Date Selector'),
(2354, 'Date selector'),
(2355, 'Date Sent'),
(2356, 'Date The Message Was Sent'),
(2357, 'Date Time'),
(2358, 'Date values Cannot be Blank.'),
(2359, 'Date VIS Presented'),
(2360, 'Date VIS Published'),
(2361, 'Date/Appt'),
(2362, 'Date/Notes'),
(2363, 'Date/Notes of Last'),
(2364, 'Date/Time'),
(2365, 'Date:'),
(2366, 'dated'),
(2367, 'Dated Message Log'),
(2368, 'Dated Reminders'),
(2369, 'Dated reminders maximum alerts to show'),
(2370, 'Day'),
(2371, 'day'),
(2372, 'day ago'),
(2373, 'Day Sheet Report'),
(2374, 'Day View'),
(2375, 'Day(s)'),
(2376, 'Day(s) M-F'),
(2377, 'days'),
(2378, 'Days'),
(2379, 'days ago'),
(2380, 'Days and Games Missed'),
(2381, 'Days From Last Encounter'),
(2382, 'Days Missed'),
(2383, 'days of each other'),
(2384, 'Days Of Week'),
(2385, 'Days per Column:'),
(2386, 'Days/Col'),
(2387, 'Days/Col:'),
(2388, 'DB installed'),
(2389, 'DD/MM/YYYY'),
(2390, 'De Identification'),
(2391, 'De Identification Process is completed'),
(2392, 'De Identification Process is ongoing'),
(2393, 'De Identification process is started and running in background'),
(2394, 'De Identified data may not be complete'),
(2395, 'De-identification files will be saved in'),
(2396, 'DEA'),
(2397, 'DEA Number'),
(2398, 'DEA number'),
(2399, 'Deactivate'),
(2400, 'Deactivated'),
(2401, 'Deaf'),
(2402, 'Debt'),
(2403, 'Debug Information'),
(2404, 'DEBUG OUTPUT'),
(2405, 'Debugging'),
(2406, 'Dec'),
(2407, 'Deceased'),
(2408, 'DECEASED'),
(2409, 'DECEASED (1 day ago)'),
(2410, 'DECEASED (Today)'),
(2411, 'Deceased Date'),
(2412, 'Deceased Date should not be greater than Today'),
(2413, 'DECEASED NOTIFICATION'),
(2414, 'Deceased Reason'),
(2415, 'December'),
(2416, 'Decide on the code categories and the order you want them to appear, these will be displayed on the buttons in the \'Select Codes\' section'),
(2417, 'Decide on the Identifying Codes and Standard Codes, remember the Identifying code has to be unique to ensure proper display of results'),
(2418, 'Decide whether or not you will want to order individual tests which are a part of a panel of tests'),
(2419, 'Decimal pounds or pounds and ounces separated by #(e.g. 5#4)'),
(2420, 'Declined To Specify'),
(2421, 'Deductible'),
(2422, 'Deductible Met'),
(2423, 'deep'),
(2424, 'Default'),
(2425, 'Default - Check any check box and this value will show up in the displayed drop-down box as the default value'),
(2426, 'Default Calendar View'),
(2427, 'Default Eligibility X12 Partner'),
(2428, 'Default Encounter Form ID'),
(2429, 'Default Encounter View'),
(2430, 'Default Facility'),
(2431, 'Default font'),
(2432, 'Default font (need to logout/login after change this setting)'),
(2433, 'Default font size'),
(2434, 'Default font size (need to logout/login after change this setting)'),
(2435, 'Default Language'),
(2436, 'Default language if no other is allowed or chosen.'),
(2437, 'Default left print margin for CMS 1500'),
(2438, 'Default left print margin for UB04'),
(2439, 'Default List (write,addonly optional)'),
(2440, 'Default List (write,addonly optional) (default)'),
(2441, 'Default Method'),
(2442, 'Default Password Expiration Days'),
(2443, 'Default password expiration period in days. 0 means this feature is disabled.'),
(2444, 'Default Patient Country'),
(2445, 'Default Patient Country sent to NewCrop eRx, only if patient country is not set.'),
(2446, 'Default Price Level'),
(2447, 'Default Priority'),
(2448, 'Default Provider'),
(2449, 'Default provider changed'),
(2450, 'Default Range'),
(2451, 'Default Reason for Visit'),
(2452, 'Default Rendering Provider in Fee Sheet'),
(2453, 'Default Search Code Type'),
(2454, 'Default Second Tab'),
(2455, 'Default selection for rendering provider in fee sheet.'),
(2456, 'Default Setting'),
(2457, 'Default state of New Window checkbox in the patient list.'),
(2458, 'Default Template'),
(2459, 'Default to a provider for line item in the fee sheet'),
(2460, 'Default to a provider for line item in the fee sheet.(only applicable if Support line item billing in option above)'),
(2461, 'Default to previous value'),
(2462, 'Default top print margin for CMS 1500'),
(2463, 'Default top print margin for UB04'),
(2464, 'Default Units'),
(2465, 'Default Units and Range as appropriate'),
(2466, 'Default Value'),
(2467, 'Default Visit Category'),
(2468, 'Default Warehouse'),
(2469, 'Default X12 Partner'),
(2470, 'Default/Global'),
(2471, 'Default: Checked. When checked, messages are processed for patients with Patient Demographic Choice (Phone/Text/Email) set to \'Unassigned\' or \'Yes\'. If this is unchecked, a given type of message can only be sent if its Demographic Choice = \'Yes\'.'),
(2472, 'Defaults'),
(2473, 'Define a default visit category'),
(2474, 'Define lab service locations'),
(2475, 'Del'),
(2476, 'del'),
(2477, 'Delayed Recurrence (> 12 Mo)'),
(2478, 'Delete'),
(2479, 'delete'),
(2480, 'Delete Categories with ID(s) : '),
(2481, 'Delete Category'),
(2482, 'Delete Document'),
(2483, 'Delete Encounter Form'),
(2484, 'Delete failed!'),
(2485, 'Delete Group'),
(2486, 'Delete List'),
(2487, 'Delete Onsite Portal Activity'),
(2488, 'Delete Pages'),
(2489, 'Delete Patient, Encounter, Form, Issue, Document, Payment, Billing or Transaction'),
(2490, 'Delete Plan'),
(2491, 'Delete Row'),
(2492, 'Delete Selected Items'),
(2493, 'Delete Selected Requests'),
(2494, 'Delete Successful'),
(2495, 'Delete successful.'),
(2496, 'Delete this document'),
(2497, 'Delete this form'),
(2498, 'Delete this message'),
(2499, 'Delete this note'),
(2500, 'Deleted Successfully'),
(2501, 'Deleted Successfully.'),
(2502, 'Deleting'),
(2503, 'Deleting this event cannot be undone. It cannot be recovered once it is gone. Are you sure you wish to delete this event?'),
(2504, 'Deletion failed because group has appointments or encounters'),
(2505, 'Delivered'),
(2506, 'Delivery Confirmed'),
(2507, 'Delivery is not allowed to the specified Direct Address.'),
(2508, 'Delivery is not currently permitted to the specified Direct Address.'),
(2509, 'Delivery of the attached clinical document was requested by the patient'),
(2510, 'Delivery of the attached clinical document was requested by the patient.'),
(2511, 'Dementia'),
(2512, 'Demographic changes made here are recorded system-wide'),
(2513, 'Demographics'),
(2514, 'Demographics (write,addonly optional)'),
(2515, 'Demographics (write,addonly optional) (demo)'),
(2516, 'Demographics - patient demographics and insurance information'),
(2517, 'Demographics Fields'),
(2518, 'Demographics filter criteria'),
(2519, 'Demographics Legend Red: Charted Values. Blue: Patient Edits'),
(2520, 'Demographics not authorized'),
(2521, 'Demographics not authorized.'),
(2522, 'Denied'),
(2523, 'denies'),
(2524, 'Denominator'),
(2525, 'Denominator Exception'),
(2526, 'Denominator Exclusion'),
(2527, 'Dental'),
(2528, 'Dental Issue List'),
(2529, 'Dental Issues'),
(2530, 'Dep Date'),
(2531, 'Dependency Modules'),
(2532, 'Dependency Problem'),
(2533, 'Depending on the level of access you can View/Edit the Transaction'),
(2534, 'Depending on the type of bill you are testing you will see HCFA like output on a blank page for HCFA bills, you will see many lines of somewhat garbled text  and information if you are testing an X12 claim. That garbled text is the X12 EDI 4010A format. Occasionally you will see odd characters that look like dominoes or  squiglies, these are control characters such as page feeds and are normal.'),
(2535, 'Depending on whether or not NewCrop eRx module is enabled the method of entry will vary'),
(2536, 'Deposit Date'),
(2537, 'Deposit Date Cannot be greater than Today'),
(2538, 'Deposit Date:'),
(2539, 'Depressed'),
(2540, 'Depression'),
(2541, 'Dept'),
(2542, 'Dermatology'),
(2543, 'Derm{{dermatologic}}'),
(2544, 'DERM{{Dermatology}}'),
(2545, 'DESC'),
(2546, 'Description'),
(2547, 'description'),
(2548, 'Description is default text'),
(2549, 'Description of the Disclosure'),
(2550, 'Description of this procedure or result code'),
(2551, 'Description Translation'),
(2552, 'Desired Filename'),
(2553, 'Destination'),
(2554, 'Destination Filename'),
(2555, 'Destroy Lot'),
(2556, 'Destroy...'),
(2557, 'Destroyed'),
(2558, 'Destroyed Drugs'),
(2559, 'Destroyed Drugs Report'),
(2560, 'Detail'),
(2561, 'Detail\'s group was saved successfully'),
(2562, 'Detailed exam'),
(2563, 'Detailed HPI'),
(2564, 'Detailed information on how to setup and troubleshoot phiMail messages is available here'),
(2565, 'Details'),
(2566, 'Developer'),
(2567, 'Developmental abnormality'),
(2568, 'Deviation'),
(2569, 'Diabetes'),
(2570, 'Diabetes Mellitus'),
(2571, 'Diabetes: Blood Pressure Management (CQM)'),
(2572, 'Diabetes: Eye Exam'),
(2573, 'Diabetes: Eye Exam (CQM)'),
(2574, 'Diabetes: Foot Exam'),
(2575, 'Diabetes: Foot Exam (CQM)'),
(2576, 'Diabetes: HbA1c Poor Control (CQM)'),
(2577, 'Diabetes: Hemoglobin A1C'),
(2578, 'Diabetes: LDL Management & Control (CQM)'),
(2579, 'Diabetes: Urine Microalbumin'),
(2580, 'Diag'),
(2581, 'Diagnoses'),
(2582, 'Diagnosis'),
(2583, 'Diagnosis Code'),
(2584, 'Diagnosis Codes'),
(2585, 'Diagnosis Date'),
(2586, 'Diagnosis Description'),
(2587, 'Diagnosis must be coded into a linked encounter'),
(2588, 'Diagnosis Name'),
(2589, 'Diagnosis Report'),
(2590, 'Diagnosis Reporting'),
(2591, 'Diagnosis Reporting Only'),
(2592, 'Diagnosis Title'),
(2593, 'Diagnosis:'),
(2594, 'Diagnosis: '),
(2595, 'Diagnostic'),
(2596, 'Diagnostic Tests:'),
(2597, 'Dials'),
(2598, 'Diam{{Diameter}}'),
(2599, 'DIAM{{Diameter}}'),
(2600, 'Diaphragms/Caps'),
(2601, 'Diarrhea'),
(2602, 'Diastolic'),
(2603, 'Dictation'),
(2604, 'Dictation: '),
(2605, 'Did you receive a copy of the HIPAA Notice?'),
(2606, 'Diffuse:'),
(2607, 'Digitally Signed'),
(2608, 'Dilated with'),
(2609, 'Dilation orders/risks reviewed'),
(2610, 'Dim'),
(2611, 'Direct'),
(2612, 'DIRECT ADDRESS'),
(2613, 'Direct Address'),
(2614, 'Direct Email'),
(2615, 'Direct Mail'),
(2616, 'Direct Message Log'),
(2617, 'Direct Message Received.'),
(2618, 'Direct messaging is currently unavailable.'),
(2619, 'Direct Messaging Send Failure.'),
(2620, 'Directions'),
(2621, 'Director Name'),
(2622, 'Directory delete failed; continuing.'),
(2623, 'Disability'),
(2624, 'Disable'),
(2625, 'Disable Auto Adjustment Calculations in EOB Posting'),
(2626, 'Disable Auto Adjustments'),
(2627, 'Disable automatically calculating balance adjustments for invoice posting'),
(2628, 'Disable Calendar'),
(2629, 'Disable Chart Tracker'),
(2630, 'Disable Help Modal'),
(2631, 'Disable Immunizations'),
(2632, 'Disable Insurance Eligibility Reports Download'),
(2633, 'Disable Old Metric Vitals Form'),
(2634, 'Disable Patient Flow Board'),
(2635, 'Disable phpMyAdmin'),
(2636, 'Disable Prescriptions'),
(2637, 'Disable User Groups'),
(2638, 'disabled'),
(2639, 'Disabled'),
(2640, 'Disabled Beneficiary Under Age 65 with Large Group Health Plan (LGHP)'),
(2641, 'Disabling automatic checking would be appropriate if message checking is managed through another mechanism, such as a system cron job'),
(2642, 'Disadvantages being cost of device, potential for loss and running out of battery power'),
(2643, 'Disc'),
(2644, 'DISC'),
(2645, 'Discard'),
(2646, 'Discarded'),
(2647, 'Discharge'),
(2648, 'Discharge From Urethra'),
(2649, 'Discharge Medications'),
(2650, 'Discharge Right'),
(2651, 'Discharge Right:'),
(2652, 'Discharge Summary'),
(2653, 'Discharge Summary - 2009'),
(2654, 'Discharge Time'),
(2655, 'Discharged'),
(2656, 'Disclosure Info'),
(2657, 'Disclosure Type'),
(2658, 'Disclosure Types'),
(2659, 'Disclosures'),
(2660, 'Disclosures (write,addonly optional)'),
(2661, 'Disclosures (write,addonly optional) (disclosure)'),
(2662, 'Disclosures - Record disclosures made for treatment, payment, and health care operations with date, time, patient identification (name or number), user identification (name or number), and a description of the disclosure'),
(2663, 'Discontinue'),
(2664, 'Discount'),
(2665, 'Discount Amount'),
(2666, 'Discount Level'),
(2667, 'Discount Percentage'),
(2668, 'Discounts as Monetary Amounts'),
(2669, 'Discounts at checkout time are entered as money amounts, as opposed to percentage.'),
(2670, 'Discrete Result'),
(2671, 'Discrete Results - for manual entry of returned result values'),
(2672, 'Disease'),
(2673, 'Disease with presumed immunity'),
(2674, 'Dislocation'),
(2675, 'Dismiss'),
(2676, 'Dismiss Help'),
(2677, 'Disp #'),
(2678, 'Dispatch'),
(2679, 'Dispatch Received Document'),
(2680, 'Dispense Rx'),
(2681, 'Dispense this Rx'),
(2682, 'Dispense this RX'),
(2683, 'Dispensed'),
(2684, 'Display'),
(2685, 'Display Additional measurements (Ks, IOL cals, etc)'),
(2686, 'Display advance directives in the demographics page.'),
(2687, 'Display Application Errors Only'),
(2688, 'Display Documents'),
(2689, 'Display event dates in block?'),
(2690, 'Display Format for US Weights'),
(2691, 'Display how many events?'),
(2692, 'Display Invoice Number or Patient Name in the Cash Receipt Report'),
(2693, 'Display Invoice Number or Patient Name or Both in the Sales Report'),
(2694, 'Display location in block?'),
(2695, 'Display Name'),
(2696, 'Display the Autorefraction Panel'),
(2697, 'Display the calendar?'),
(2698, 'Display the Contact Lens Panel'),
(2699, 'Display the Encounter Billing Note or Patient Billing Note or Both in the Billing Screen.'),
(2700, 'Display the Manifest Refraction panel'),
(2701, 'Display the patient\'s current glasses'),
(2702, 'Display the recurrent appointment widget in the patient summary.'),
(2703, 'Display the Units Column on the Billing Screen'),
(2704, 'Display today\'s events in the block?'),
(2705, 'Display topic in block?'),
(2706, 'Display upcoming events in block?'),
(2707, 'Display Window Errors Only'),
(2708, 'Displayed Columns'),
(2709, 'Displaying the following number of most recent disclosures:'),
(2710, 'Displaying the following number of most recent messages'),
(2711, 'Displaying the following number of most recent notes'),
(2712, 'Displaying the following number of most recent notes:'),
(2713, 'Distance'),
(2714, 'Distance from the \'top\' of the envelope in mm'),
(2715, 'Distance from the right most edge of the envelope in portrait position in mm'),
(2716, 'Distribute'),
(2717, 'Distribution'),
(2718, 'Distributions'),
(2719, 'Distributor'),
(2720, 'Dist{{distance}}'),
(2721, 'Divehi- Dhivehi- Maldivian-'),
(2722, 'Divergence'),
(2723, 'Divergence Amps'),
(2724, 'Diverticulitis'),
(2725, 'Diverticulitis Surgery'),
(2726, 'Divirticulitis'),
(2727, 'Divirticulitis Surgery'),
(2728, 'Divorced'),
(2729, 'Dizziness:'),
(2730, 'Do not allow insurance eligibility report log download'),
(2731, 'Do not allow SQL queries to be outputted to screen.'),
(2732, 'Do not change'),
(2733, 'Do not display Allergies uploaded after visiting NewCrop eRx.'),
(2734, 'Do not display Allergy uploaded to NewCrop'),
(2735, 'Do not display Medications uploaded after visiting NewCrop eRx.'),
(2736, 'Do not display Medications uploaded to NewCrop'),
(2737, 'Do not display NewCrop eRx Allergy uploaded'),
(2738, 'Do not display NewCrop eRx Medications uploaded'),
(2739, 'Do not display the calendar.'),
(2740, 'Do not display the patient flow board.'),
(2741, 'Do not display the Recall Board.'),
(2742, 'Do not enter the server URL into your browser address bar, as this will not work'),
(2743, 'Do not inventory and sell any products'),
(2744, 'Do not know what to do!'),
(2745, 'Do Not Print'),
(2746, 'Do not require patient notes to be authorized'),
(2747, 'Do Not Resuscitate Order'),
(2748, 'do not save'),
(2749, 'do not substitute'),
(2750, 'Do Not Use Safe Apostrophe'),
(2751, 'do nothing'),
(2752, 'Do you really want to change Warehouse?'),
(2753, 'Do You Really Want to Continue'),
(2754, 'Do you really want to delete'),
(2755, 'Do you really want to delete the selection?'),
(2756, 'Do you really want to delete this group'),
(2757, 'Do you really want to delete?'),
(2758, 'Do you want to continue?'),
(2759, 'Do you want to delete this?'),
(2760, 'Do you want to delete?'),
(2761, 'Do you want to remove this record?'),
(2762, 'Do you wish to continue adding this new patient?'),
(2763, 'Do you wish to continue with the new name?'),
(2764, 'Do you wish to PERMANENTLY delete this immunization record?'),
(2765, 'DOB'),
(2766, 'DOB is missing, please enter if possible'),
(2767, 'Doc Id'),
(2768, 'Docs'),
(2769, 'Doctor'),
(2770, 'Doctor:'),
(2771, 'Doctor\'s name and signature'),
(2772, 'Document'),
(2773, 'document'),
(2774, 'document 3 and their status to reach the detailed HPI level'),
(2775, 'Document Categories'),
(2776, 'Document category for lab results does not exist'),
(2777, 'Document category name for storage of electronically received lab results.'),
(2778, 'Document category name for storage of electronically received MDM documents.'),
(2779, 'Document Category or Discard'),
(2780, 'Document clinical findings in Shorthand Format'),
(2781, 'Document could not be moved to patient id'),
(2782, 'Document created'),
(2783, 'Document Date'),
(2784, 'Document date and issue updated successfully'),
(2785, 'Document ID'),
(2786, 'Document identifying information'),
(2787, 'Document Library'),
(2788, 'Document moved to new category'),
(2789, 'Document moved to patient id'),
(2790, 'Document passed integrity check'),
(2791, 'Document passed integrity check.'),
(2792, 'Document Storage Method'),
(2793, 'Document successfully renamed.'),
(2794, 'Document tagged to Encounter successfully'),
(2795, 'Document Template Management'),
(2796, 'Document Templates'),
(2797, 'Document Uploader/Viewer'),
(2798, 'Document(s)'),
(2799, 'Document/Imaging Store'),
(2800, 'Documentation for a Detailed HPI requires'),
(2801, 'Documents'),
(2802, 'documents'),
(2803, 'Documents (write,addonly optional)'),
(2804, 'Documents (write,addonly optional) (docs)'),
(2805, 'Documents - a repository of the patient\'s scanned/faxed paper documents. It also the place to download patient specific templates'),
(2806, 'Documents Delete'),
(2807, 'Documents Delete (docs_rm)'),
(2808, 'Documents List'),
(2809, 'Documents setup error'),
(2810, 'DOC{{document format}}'),
(2811, 'DOE'),
(2812, 'Does anything make it better? Worse?'),
(2813, 'Does it occur in certain situations?'),
(2814, 'Does not equal'),
(2815, 'does not have enough data to graph'),
(2816, 'does not match the PV1 encounter number'),
(2817, 'does not seem valid'),
(2818, 'Does this type allow related codes?'),
(2819, 'Domestic Partner'),
(2820, 'Don\'t Save'),
(2821, 'Don\'t Save'),
(2822, 'Don\'t Save Changes'),
(2823, 'DONATE NOW!'),
(2824, 'Done'),
(2825, 'Done with'),
(2826, 'Done with:'),
(2827, 'Done.  Will now send download.'),
(2828, 'DOS'),
(2829, 'Dosage'),
(2830, 'Dose'),
(2831, 'Double click on a DX\'s handle'),
(2832, 'Double Click on this icon to pop up document in a new viewer.'),
(2833, 'double click to edit'),
(2834, 'Double Clicking a NPI box will bring up a current Users dialog for providers.'),
(2835, 'Double Vision'),
(2836, 'Download'),
(2837, 'DOWNLOAD'),
(2838, 'Download - the created CCD is downloaded as a pdf file to the downloads from the browser'),
(2839, 'Download - the created CCR is downloaded as a pdf file to the downloads from the browser'),
(2840, 'Download all patient documents'),
(2841, 'Download Anyway'),
(2842, 'Download billing file, post to accounting and mark as billed'),
(2843, 'Download CCDA file'),
(2844, 'Download Certificates'),
(2845, 'Download configuration data'),
(2846, 'Download CSV File'),
(2847, 'Download document template for this patient and visit'),
(2848, 'Download Documents'),
(2849, 'download encrypted file'),
(2850, 'Download Fax'),
(2851, 'Download HL7 file'),
(2852, 'Download Lab Documents'),
(2853, 'Download Offsite Portal Connection Files'),
(2854, 'Download or Delete a Template'),
(2855, 'Download PDF'),
(2856, 'Download QRDA Category III File'),
(2857, 'Download report as a pdf file into the browser\'s download folder'),
(2858, 'Download Selected Statements'),
(2859, 'Download will download a text file containing the order in the HL7v2.3 message format to the downloads directory of your computer'),
(2860, 'Dr Check'),
(2861, 'Dr Visit'),
(2862, 'Dr.'),
(2863, 'Drafts'),
(2864, 'Drag a DX over by its handle'),
(2865, 'Drag the arrow for each diagnosis to sort the list.'),
(2866, 'Drag to move'),
(2867, 'Draw'),
(2868, 'Dribbling'),
(2869, 'Drivers License or State ID'),
(2870, 'Drop files here to upload'),
(2871, 'Drug'),
(2872, 'Drug - Drug Interaction'),
(2873, 'Drug Code'),
(2874, 'Drug Finder'),
(2875, 'Drug Forms'),
(2876, 'Drug ID missing!'),
(2877, 'Drug Intervals'),
(2878, 'Drug Inventory'),
(2879, 'Drug name'),
(2880, 'Drug Name'),
(2881, 'Drug Routes'),
(2882, 'Drug Screen'),
(2883, 'Drug Screen Completed'),
(2884, 'Drug Screen Report'),
(2885, 'Drug units'),
(2886, 'Drug Units'),
(2887, 'Drug Use'),
(2888, 'Drug-Drug'),
(2889, 'Drug-Drug Interaction'),
(2890, 'Drug1 Name{{Drug1 Interaction}}'),
(2891, 'Drug2 Name{{Drug2 Interaction}}'),
(2892, 'Drugs'),
(2893, 'Drugs and Products'),
(2894, 'Dry Mouth'),
(2895, 'DSMIV Diagnosis'),
(2896, 'DT 1'),
(2897, 'DT 2'),
(2898, 'DT 3'),
(2899, 'DT 4'),
(2900, 'DT 5'),
(2901, 'DTaP 1'),
(2902, 'DTaP 2'),
(2903, 'DTaP 3'),
(2904, 'DTaP 4'),
(2905, 'DTaP 5'),
(2906, 'Due'),
(2907, 'Due Date'),
(2908, 'Due date'),
(2909, 'Due date mm/dd/yyyy or yyyy-mm-dd'),
(2910, 'Due Date:'),
(2911, 'Due Ins'),
(2912, 'Due Pt'),
(2913, 'Due Soon'),
(2914, 'Due Status'),
(2915, 'Due Status Update'),
(2916, 'Dumping OpenEMR database'),
(2917, 'Dumping OpenEMR web directory tree'),
(2918, 'Dumping phpGACL database'),
(2919, 'Dumping phpGACL web directory tree'),
(2920, 'Dumping SQL-Ledger database'),
(2921, 'Dumping SQL-Ledger web directory tree'),
(2922, 'Dup Check'),
(2923, 'Dup Check on only Edit'),
(2924, 'Dup Check on only New'),
(2925, 'Duplicate Rx -- unchanged from current Rx{{The refraction did not change, New Rx=old Rx}}'),
(2926, 'Duplicated ID on line'),
(2927, 'Duplicated name on line'),
(2928, 'DUPLICATION WARNING'),
(2929, 'Durable Power of Attorney'),
(2930, 'Duration'),
(2931, 'duration'),
(2932, 'Dutch'),
(2933, 'Dx Codes'),
(2934, 'Dx Rep'),
(2935, 'Dysphagia'),
(2936, 'Dyspnea:'),
(2937, 'Dysuria'),
(2938, 'Dzongkha'),
(2939, 'E(T){{intermittent esotropia}}'),
(2940, 'E-Mail'),
(2941, 'E-mail'),
(2942, 'E-Mail Address'),
(2943, 'E-mail Messaging'),
(2944, 'E-mail OK'),
(2945, 'E-PRESCRIBING'),
(2946, 'E-Prescription?'),
(2947, 'E-Reports'),
(2948, 'e-Rx'),
(2949, 'e-Rx EPCS'),
(2950, 'e-Rx Renewal'),
(2951, 'e-signed'),
(2952, 'Each of these groups (AROs) has access to pre-determined parts of the program (ACOs).'),
(2953, 'Each recipient must set their own messages as completed.'),
(2954, 'Each Section has one Narrative Block and zero to many coded Entries'),
(2955, 'Each segment is identified by a unique three letter header that constitutes the first three letters on that line'),
(2956, 'Each test or panel in this group has to be in an individual Custom Favorite Item tier'),
(2957, 'Each Transaction is listed on a separate line'),
(2958, 'Early Recurrence (<2 Mo)'),
(2959, 'Ears'),
(2960, 'Easy to forget on the computer used to login'),
(2961, 'Easy to setup'),
(2962, 'Easy to use'),
(2963, 'ECG'),
(2964, 'eClaims'),
(2965, 'ECL{{equivalent contact lens power at the corneal level}}'),
(2966, 'ECOM{{external comments abbreviation}}'),
(2967, 'Edema'),
(2968, 'EDI File'),
(2969, 'edi history'),
(2970, 'EDI History'),
(2971, 'EDI History (under Fees) for storing and interpreting EDI claim response files'),
(2972, 'EDI-271 File Upload'),
(2973, 'EDI-271 Response File Upload'),
(2974, 'Edit'),
(2975, 'edit'),
(2976, 'Edit Allergies'),
(2977, 'Edit Appointment'),
(2978, 'Edit Categories'),
(2979, 'Edit Current Patient'),
(2980, 'Edit Definitions'),
(2981, 'Edit definitions'),
(2982, 'Edit Diagnoses for'),
(2983, 'Edit Disclosure'),
(2984, 'Edit Document'),
(2985, 'Edit Entry'),
(2986, 'Edit Event'),
(2987, 'EDIT EXISTING GROUP'),
(2988, 'Edit Facilities'),
(2989, 'Edit Facility'),
(2990, 'Edit Facility Information'),
(2991, 'Edit Facility Specific User Information'),
(2992, 'Edit File in'),
(2993, 'Edit form'),
(2994, 'Edit Global Settings'),
(2995, 'Edit History and Lifestyle'),
(2996, 'Edit is not authorized!'),
(2997, 'Edit Issue'),
(2998, 'Edit layout'),
(2999, 'Edit Layout Properties'),
(3000, 'Edit list'),
(3001, 'Edit Mode'),
(3002, 'Edit Onsite Portal Activity'),
(3003, 'Edit Payment'),
(3004, 'Edit Structure'),
(3005, 'Edit Template'),
(3006, 'Edit this form'),
(3007, 'Edit User'),
(3008, 'Edit User Settings'),
(3009, 'Edit your entered data'),
(3010, 'Editing failed'),
(3011, 'Education'),
(3012, 'Education Date'),
(3013, 'Educational materials for'),
(3014, 'ee the  * GNU General Public License for more details.  *   * You should have received a copy of the GNU General Public License  * along with this program; if not, write to the Free '),
(3015, 'Effective Date'),
(3016, 'Effective Dates'),
(3017, 'Effectiveness'),
(3018, 'eg. aching, burning, radiating pain'),
(3019, 'EIN'),
(3020, 'Either type a search term in appropriate box or double click box to see available codes.'),
(3021, 'Either way data entered by any method will feature in both locations'),
(3022, 'Ejaculations'),
(3023, 'Elbow'),
(3024, 'Elbow Problems'),
(3025, 'Electronic'),
(3026, 'Electronic document received'),
(3027, 'Electronic Notes'),
(3028, 'Electronic orders'),
(3029, 'Electronic Remits'),
(3030, 'Electronic Reports'),
(3031, 'Electronic results can be bidirectional - both order tests and receive results electronically or unidirectional - only receive the results electronically'),
(3032, 'electronically signed on'),
(3033, 'Eligibility'),
(3034, 'Eligibility 270 Inquiry Batch'),
(3035, 'Eligibility Response'),
(3036, 'Eligibility Service Date (270 DTP03)'),
(3037, 'Eligibility status for Vaccine for Children supplied vaccine'),
(3038, 'Eligible'),
(3039, 'Ellipse'),
(3040, 'Email'),
(3041, 'email'),
(3042, 'EMAIL'),
(3043, 'Email Address'),
(3044, 'Email address is missing'),
(3045, 'Email address of the sender for patient reminders. Replies to patient reminders will be directed to this address. It is important to use an address from your clinic\'s domain to avoid help prevent patient reminders from going to junk mail folders.'),
(3046, 'Email address, if any, to receive administrative notifications.'),
(3047, 'Email address, if any, to receive emergency login user activation messages.'),
(3048, 'Email Auth'),
(3049, 'EMAIL Confimed'),
(3050, 'Email Direct'),
(3051, 'Email from Batchcom'),
(3052, 'Email Notification'),
(3053, 'Email Notification Hours'),
(3054, 'Email Notification Report'),
(3055, 'Email Notification Settings Updated Successfully'),
(3056, 'Email Selected Statements'),
(3057, 'Email send before'),
(3058, 'Email Sender'),
(3059, 'Email Sent'),
(3060, 'Email sent to'),
(3061, 'Email Subject'),
(3062, 'email subject'),
(3063, 'Email Text, Usable Tag: ***NAME*** , i.e. Dear ***NAME***'),
(3064, 'Email Text, Usable Tag: ***NAME*** , i.e. Dear ***NAME***{{Do Not translate the ***NAME*** elements of this constant.}}'),
(3065, 'Email Transport Method'),
(3066, 'Email was sent to following address'),
(3067, 'emails not sent'),
(3068, 'Emergency Care'),
(3069, 'Emergency contact'),
(3070, 'Emergency Contact'),
(3071, 'Emergency Contact Person'),
(3072, 'Emergency Contact Phone Number'),
(3073, 'Emergency Contraception'),
(3074, 'Emergency Login'),
(3075, 'Emergency Login ACL is chosen. The user is still in active state, please de-activate the user and activate the same when required during emergency situations. Visit Administration->Users for activation or de-activation.'),
(3076, 'Emergency Login activation email will be circulated only if following settings in the interface/globals.php file are configured:'),
(3077, 'Emergency Login Email Address'),
(3078, 'Emergency Login user can do anything'),
(3079, 'Emergency Phone'),
(3080, 'Emergency Room - Hospital'),
(3081, 'Emotional / Behavioral Conditions & Complications'),
(3082, 'Emphysema'),
(3083, 'Employee'),
(3084, 'Employer'),
(3085, 'Employer Address'),
(3086, 'Employer Data'),
(3087, 'Employer Name'),
(3088, 'EMPTY'),
(3089, 'Empty'),
(3090, 'Empty Password Not Allowed'),
(3091, 'Empty table'),
(3092, 'Empty value in \"Email Hours\"'),
(3093, 'Empty value in \"Email Sender\"'),
(3094, 'Empty value in \"Email Subject\"'),
(3095, 'Empty value in \"Email Text\"'),
(3096, 'Empty value in \"Name of Provider\"'),
(3097, 'Empty value in \"Password\"'),
(3098, 'Empty value in \"SMS Hours\"'),
(3099, 'Empty value in \"SMS Text\"'),
(3100, 'Empty value in \"Username\"'),
(3101, 'EMR Direct'),
(3102, 'EMR Direct phiMail is a secure, scalable, standards-based way for participants to send authenticated, encrypted health information directly to known, trusted recipients over the Internet'),
(3103, 'Enable'),
(3104, 'Enable a Payment Gateway Service for processing credit card transactions'),
(3105, 'Enable Alert Log'),
(3106, 'Enable Alert Logging'),
(3107, 'Enable Allergy Check'),
(3108, 'Enable Allergy Check Against Medications and Prescriptions'),
(3109, 'Enable AMC Prompting'),
(3110, 'Enable AMC Report Itemization'),
(3111, 'Enable AMC Reporting'),
(3112, 'Enable AMC Tracking'),
(3113, 'Enable amendments feature'),
(3114, 'Enable ATNA Auditing'),
(3115, 'Enable Audit Log Encryption'),
(3116, 'Enable Audit Logging'),
(3117, 'Enable Audit Trail and Node Authentication (ATNA).'),
(3118, 'Enable Automated Measure Calculations (AMC) Reporting'),
(3119, 'Enable Batch Payment'),
(3120, 'Enable C-CDA Alternate Service'),
(3121, 'Enable Client SSL'),
(3122, 'Enable client SSL certificate authentication.'),
(3123, 'Enable Clinical Active Reminder Popup'),
(3124, 'Enable Clinical Decisions Rules (CDR)'),
(3125, 'Enable Clinical Passive New Reminder(s) Popup'),
(3126, 'Enable Clinical Passive Reminder Widget'),
(3127, 'Enable Clinical Quality Measure (CQM) Reporting'),
(3128, 'Enable Clinical Reminder Popup'),
(3129, 'Enable Clinical Reminder Widget'),
(3130, 'Enable CMS Portal'),
(3131, 'Enable CQM Report Itemization'),
(3132, 'Enable CQM Reporting'),
(3133, 'Enable EDI History'),
(3134, 'Enable EDI History In Left Menu'),
(3135, 'Enable Encryption of Items Stored on Drive'),
(3136, 'Enable Extension'),
(3137, 'Enable Facility'),
(3138, 'Enable Fees In Left Menu'),
(3139, 'Enable Fees Submenu'),
(3140, 'Enable FHIR Provider Client Service'),
(3141, 'Enable Group Therapy'),
(3142, 'Enable Help Modal'),
(3143, 'Enable Hylafax Support'),
(3144, 'Enable import status message after visiting NewCrop eRx.'),
(3145, 'Enable import status message for NewCrop erx'),
(3146, 'Enable Itemization of AMC Reports'),
(3147, 'Enable Itemization of CQM Reports'),
(3148, 'Enable Itemization of Standard Clinical Rules Reports'),
(3149, 'Enable Lab Exchange'),
(3150, 'Enable lock toggle'),
(3151, 'Enable log for document uploads/downloads to CouchDB'),
(3152, 'Enable logging of all SQL SELECT queries.'),
(3153, 'Enable logging of backup related activities.'),
(3154, 'Enable logging of CDR Engine Queries.'),
(3155, 'Enable logging of miscellaneous activities.'),
(3156, 'Enable logging of ordering activities.'),
(3157, 'Enable logging of patient record modifications.'),
(3158, 'Enable logging of scheduling activities.'),
(3159, 'Enable logging of security and administration activities.'),
(3160, 'Enable MedEx Communication Service'),
(3161, 'Enable NewCrop eRx import status message'),
(3162, 'Enable NewCrop eRx Service'),
(3163, 'Enable NewCrop eRx Service.'),
(3164, 'Enable Office Ally Insurance Eligibility'),
(3165, 'Enable Offsite Patient Portal'),
(3166, 'Enable Offsite Patient Portal.'),
(3167, 'Enable only one type of portal by checking the relevant check-box'),
(3168, 'Enable Onsite Patient Portal'),
(3169, 'Enable Onsite Patient Portal Document Download'),
(3170, 'Enable Onsite Patient Portal new patient to self register.'),
(3171, 'Enable Onsite Patient Portal.'),
(3172, 'Enable OpenEMR REST API'),
(3173, 'Enable OpenEMR RESTful API. SSL Required'),
(3174, 'Enable Patient Reminder Widget'),
(3175, 'Enable phiMail Direct Messaging Service'),
(3176, 'Enable Posting'),
(3177, 'Enable Prompting For Automated Measure Calculations (AMC) Required Data'),
(3178, 'Enable Random Drug Testing'),
(3179, 'Enable Reporting of Tracking Date For Automated Measure Calculations (AMC)'),
(3180, 'Enable Scanner Support'),
(3181, 'Enable Standard Report Itemization'),
(3182, 'Enable support for the open source WordPress Portal by Sunset Systems'),
(3183, 'Enable the Medical Information Integration, LLC Lab Exchange Service.'),
(3184, 'Enable the OpenEMR Support LLC Lab Exchange Service.'),
(3185, 'Enable User Certificate Authentication'),
(3186, 'Enable Version 1 Onsite Patient Portal'),
(3187, 'Enable Version 2 Onsite Patient Portal'),
(3188, 'Enable Version 2 Onsite Patient Portal new patient to self register.'),
(3189, 'Enable Weno eRx Service'),
(3190, 'Enable ZMG, LLC eRx service'),
(3191, 'enabled'),
(3192, 'Enabled Services'),
(3193, 'Enables choose due date to message'),
(3194, 'Enables groups module in system.'),
(3195, 'Enables the ability to download documents in the Onsite Patient Portal by the user.'),
(3196, 'Enables the old Charges panel for entering billing codes and payments. Not recommended, use the Fee Sheet instead.'),
(3197, 'Enables to submit changes for all appointments of a recurrence at once.'),
(3198, 'Enabling EMR Direct phiMail'),
(3199, 'Enc'),
(3200, 'Encnter'),
(3201, 'Encounter'),
(3202, 'encounter'),
(3203, 'Encounter '),
(3204, 'encounter acute inpatient or ED'),
(3205, 'Encounter Balance'),
(3206, 'Encounter Billing Note'),
(3207, 'Encounter Checkup Procedure'),
(3208, 'Encounter Count'),
(3209, 'encounter data'),
(3210, 'Encounter Date'),
(3211, 'Encounter Diagnosis'),
(3212, 'Encounter Dt / Rsn'),
(3213, 'Encounter EDI Record'),
(3214, 'Encounter Esigned'),
(3215, 'Encounter Forms'),
(3216, 'encounter health and behavior assessment'),
(3217, 'Encounter History'),
(3218, 'Encounter ID'),
(3219, 'encounter influenza'),
(3220, 'Encounter Information'),
(3221, 'Encounter Information (encounters)'),
(3222, 'Encounter number'),
(3223, 'Encounter Number'),
(3224, 'encounter nursing discharge'),
(3225, 'encounter nursing facility'),
(3226, 'encounter occupational therapy'),
(3227, 'encounter office visit'),
(3228, 'encounter outpatient'),
(3229, 'encounter outpatient w/PCP & obgyn'),
(3230, 'Encounter Page Size'),
(3231, 'Encounter Payment'),
(3232, 'encounter pregnancy'),
(3233, 'encounter preventive medicine - individual counseling'),
(3234, 'encounter preventive medicine 40 and older'),
(3235, 'encounter preventive medicine group counseling'),
(3236, 'encounter preventive medicine other services'),
(3237, 'encounter preventive medicine services 18 and older'),
(3238, 'Encounter Preview'),
(3239, 'encounter psychiatric & psychologic'),
(3240, 'Encounter statistics'),
(3241, 'Encounter Summary'),
(3242, 'Encounter type'),
(3243, 'Encounter was coded'),
(3244, 'Encounter:'),
(3245, 'Encounter: encounter non-acute inpt, outpatient, or ophthalmology'),
(3246, 'Encounters'),
(3247, 'Encounters & Forms'),
(3248, 'Encounters &amp; Forms'),
(3249, 'Encounters not authorized'),
(3250, 'Encounters Report'),
(3251, 'Encounters Section'),
(3252, 'Encrypted File'),
(3253, 'Encryption'),
(3254, 'End'),
(3255, 'End (yyyy-mm-dd): '),
(3256, 'End Date'),
(3257, 'End date'),
(3258, 'End Date From'),
(3259, 'End Date leave blank if ongoing'),
(3260, 'End date must be equal or bigger than start date'),
(3261, 'End date must be later than Begin date!'),
(3262, 'End date should be greater than Begin date'),
(3263, 'End Date To'),
(3264, 'End Date:'),
(3265, 'End of Day by Provider or allow Totals Only'),
(3266, 'End Of Day Report'),
(3267, 'End of report'),
(3268, 'End of Requisition'),
(3269, 'End Time'),
(3270, 'End-Stage Renal Disease Beneficiary in MCP with Employer`s Group Plan'),
(3271, 'End-Stage Renal Disease Treatment Facility'),
(3272, 'Ending date'),
(3273, 'Ending date of service yyyy-mm-dd'),
(3274, 'Ending DOS mm/dd/yyyy if you wish to enter a range'),
(3275, 'Ending hour of day for calendar events.'),
(3276, 'Endo Abnormal Blood'),
(3277, 'Endocrine'),
(3278, 'Endoscopy'),
(3279, 'ENDO{{Endocrine}}'),
(3280, 'Enforce E-Mail in Portal Log On Dialog'),
(3281, 'Engineer'),
(3282, 'Engineering Firm'),
(3283, 'English'),
(3284, 'English '),
(3285, 'English (Indian)'),
(3286, 'English (Standard)'),
(3287, 'Enscript command used by Hylafax.'),
(3288, 'Ensure OpenEMR has write privileges to directory'),
(3289, 'Ensure that Identifying Codes are unique'),
(3290, 'ENT Discharge'),
(3291, 'ENT Pain'),
(3292, 'Enter 1 under sequence, more about sequence numbers later'),
(3293, 'Enter a Begin Date'),
(3294, 'Enter a diagnosis code to exclude all invoices not containing it'),
(3295, 'Enter a sequence 1'),
(3296, 'Enter an amendment...'),
(3297, 'Enter an End Date if the problem has been resolved'),
(3298, 'Enter Application Name'),
(3299, 'Enter body of letter here'),
(3300, 'Enter City'),
(3301, 'Enter Database root Password'),
(3302, 'Enter Database root Username'),
(3303, 'Enter Details'),
(3304, 'Enter Details for Custom Favorite Group'),
(3305, 'Enter Details for Discrete Results'),
(3306, 'Enter Details for Group'),
(3307, 'Enter Details for Individual Custom Favorite Item'),
(3308, 'Enter Details for Individual Procedures'),
(3309, 'Enter Details for Recommendation'),
(3310, 'Enter Diagnosis'),
(3311, 'Enter Drugs'),
(3312, 'Enter E-Mail Address'),
(3313, 'Enter email address to receive registration.'),
(3314, 'Enter Encounter'),
(3315, 'Enter Encounter Number'),
(3316, 'Enter Facility Name'),
(3317, 'Enter ID'),
(3318, 'Enter Immunizations'),
(3319, 'Enter Key'),
(3320, 'Enter Last'),
(3321, 'Enter name'),
(3322, 'Enter needed information to help process this particular claim'),
(3323, 'Enter new data'),
(3324, 'Enter new office note here'),
(3325, 'Enter new State'),
(3326, 'Enter Occurrence if appropriate'),
(3327, 'Enter or select the options in the various boxes to filter the results according to need and press Filter'),
(3328, 'Enter Password'),
(3329, 'Enter Provider Details'),
(3330, 'Enter Recipient\'s Direct Address'),
(3331, 'Enter Self if None'),
(3332, 'Enter Serum Uric Acid in the Name box'),
(3333, 'Enter Serum Uric Acid order in the Description box'),
(3334, 'Enter Serum Uric Acid result under Description'),
(3335, 'Enter Serum Uric Acid under Name'),
(3336, 'Enter the category data in the appropriate fields and click \'Save\'. These will be used to group the ICD codes and will be displayed on the buttons in the \'Select Codes\' section'),
(3337, 'Enter the code from your authentication application on your device'),
(3338, 'Enter the default range values if applicable, used in manual entry of results.'),
(3339, 'Enter the default units for this test.'),
(3340, 'Enter the details - Name - Well Woman Tests, Description - Well Woman Tests, an appropriate sequence number depending on the procedure orders already entered, Order From - Local Lab'),
(3341, 'Enter the details as follows Name - Blood Glucose, Description - Fasting Glucose result, Sequence - 1, Identifying Code - any unique value - WWT01R, Default Units - mg/dL, Default Range - 70-100, leave Followup Services blank and click Save'),
(3342, 'Enter the Direct address and click Send CCR/Send CCD as the case may be'),
(3343, 'Enter the following: Name - Blood Glucose, Description - Fasting Blood Glucose, Sequence - 1, Order From - Local Lab'),
(3344, 'Enter the laterality of this procedure, if applicable.'),
(3345, 'Enter the Logical Observation Identifiers Names and Codes (LOINC) code for this procedure'),
(3346, 'Enter the Logical Observation Identifiers Names and Codes (LOINC) code for this procedure. LOINC is a database and universal standard for identifying medical laboratory observations.'),
(3347, 'Enter the LOINC code for this procedure'),
(3348, 'Enter the OpenEMR login password for the user and click Submit'),
(3349, 'Enter the Re Identification code'),
(3350, 'Enter the relevant site if applicable.'),
(3351, 'Enter the Server Address, Username, and Password provided to you'),
(3352, 'Enter the Severity of the allergy'),
(3353, 'Enter the specimen type if applicable.'),
(3354, 'Enter the values 3.4 - 7.2 - Men, 2.4–6.1 - Women'),
(3355, 'Enter their OpenEMR username in the notification user field'),
(3356, 'Enter User Login ID'),
(3357, 'Enter values in this section to create a new group also known as Access Request Object (ARO)'),
(3358, 'Enter your credentials'),
(3359, 'Enter your search criteria above'),
(3360, 'Enter Your Zip'),
(3361, 'Entered By'),
(3362, 'Entered in Error'),
(3363, 'entries'),
(3364, 'Envelope Height in mm'),
(3365, 'Envelope Width in mm'),
(3366, 'Envelope x-axis starting pt'),
(3367, 'Envelope y-axis starting pt'),
(3368, 'Environmental'),
(3369, 'EOB Data Entry'),
(3370, 'EOB Data Entry (eob)'),
(3371, 'EOB Id'),
(3372, 'EOB Invoice'),
(3373, 'EOB Posting - Electronic Remittances'),
(3374, 'EOB Posting - Instructions'),
(3375, 'EOB Posting - Invoice'),
(3376, 'EOB Posting - Patient Note'),
(3377, 'EOB Posting - Search'),
(3378, 'EOBs'),
(3379, 'Epilepsy'),
(3380, 'Episode'),
(3381, 'EPSDT'),
(3382, 'EPSDT:'),
(3383, 'Equals'),
(3384, 'Equivalent contact lens power at the corneal level'),
(3385, 'ERA'),
(3386, 'ERA Files'),
(3387, 'ERA Posting'),
(3388, 'ERA Upload'),
(3389, 'Erase'),
(3390, 'Eraser'),
(3391, 'Erections'),
(3392, 'Error'),
(3393, 'ERROR'),
(3394, 'Error confirming receipt of lab results'),
(3395, 'Error creating directory!'),
(3396, 'Error getting lab results from Lab Exchange Network'),
(3397, 'Error in \"Gender\" selection'),
(3398, 'Error in \"HIPAA\" selection'),
(3399, 'Error in \"Process\" selection'),
(3400, 'Error in \"SMS Gateway\" selection'),
(3401, 'Error in \"Sort By\" selection'),
(3402, 'Error in gzip compression of file: '),
(3403, 'Error in YES or NO option'),
(3404, 'ERROR Missing Patient ID'),
(3405, 'Error number'),
(3406, 'Error opening uploaded file for reading'),
(3407, 'Error processing file'),
(3408, 'Error processing upload'),
(3409, 'Error Removing Message'),
(3410, 'Error retrieving results from Lab Exchange Network'),
(3411, 'Error retrieving values.'),
(3412, 'Error saving document'),
(3413, 'Error when granting file privilege to the OpenEMR user.'),
(3414, 'Error while adding new plan'),
(3415, 'Error while deleting the plan'),
(3416, 'error while registering form!'),
(3417, 'Error while saving to the file'),
(3418, 'Error while updating the plan'),
(3419, 'Error while writing to file'),
(3420, 'ERROR!... in Update'),
(3421, 'error(s) encountered from new results'),
(3422, 'Error, the CA Certificate File doesn\'t exist'),
(3423, 'Error, the CA Key File doesn\'t exist'),
(3424, 'Error, the file does not exist'),
(3425, 'ERROR, unable to collect data from server'),
(3426, 'Error, unable to create client certificate.'),
(3427, 'Error, unable to create the admin.p12 certificate.'),
(3428, 'Error, unable to create the Certificate Authority certificate.'),
(3429, 'Error, unable to create the Server certificate.'),
(3430, 'Error, unable to open file'),
(3431, 'Error, User Certificate Authentication is not enabled in OpenEMR'),
(3432, 'Error. Try again later'),
(3433, 'Error. You need to install the Archive/Tar.php php module.'),
(3434, 'ERROR: could not open table.sql, broken form?'),
(3435, 'Error: Duplicated field ID'),
(3436, 'Error: duplicated ID'),
(3437, 'Error: duplicated ID on line'),
(3438, 'Error: duplicated name on line'),
(3439, 'ERROR: Field'),
(3440, 'ERROR: Missing ZipArchive PHP Module'),
(3441, 'ERROR: No ICD import directory.'),
(3442, 'Error: passwords don\'t match. Please check your typing.'),
(3443, 'Error: passwords don\'t match. Please check your typing.'),
(3444, 'Error: the file does not exist'),
(3445, 'ERROR: The following variable contains invalid characters'),
(3446, 'ERROR: Unable to copy the file.'),
(3447, 'Error: Unable to create downloadable archive'),
(3448, 'ERROR: Unable to Create Zip Archive.'),
(3449, 'ERROR: Unable to extract the file.'),
(3450, 'ERROR: Unable to load the file into the database.'),
(3451, 'ERROR: Unable to set the version number.'),
(3452, 'Errors'),
(3453, 'eRx Account Status'),
(3454, 'eRx Logs'),
(3455, 'ERX Name'),
(3456, 'ERX Password'),
(3457, 'ERX Role'),
(3458, 'ERX User'),
(3459, 'Erythema:'),
(3460, 'eSign'),
(3461, 'eSign Log'),
(3462, 'Eskimo'),
(3463, 'Esophoria'),
(3464, 'Esotropia'),
(3465, 'Esperanto'),
(3466, 'Established'),
(3467, 'Established Patient'),
(3468, 'Estonian'),
(3469, 'Ethnicity'),
(3470, 'Ethnicity or Race'),
(3471, 'Ethnicity-Race List (write,addonly optional)'),
(3472, 'Ethnicity-Race List (write,addonly optional) (ethrace)'),
(3473, 'Ethnoracial'),
(3474, 'ETIN'),
(3475, 'ETOH'),
(3476, 'ET{{esotropia}}'),
(3477, 'Event'),
(3478, 'Event Begins'),
(3479, 'Event Category'),
(3480, 'Event Date'),
(3481, 'event date or starting date'),
(3482, 'Event Description'),
(3483, 'Event Details'),
(3484, 'Event does not repeat'),
(3485, 'Event Duration'),
(3486, 'Event duration in minutes'),
(3487, 'Event Fee'),
(3488, 'Event Location'),
(3489, 'Event repeats every'),
(3490, 'Event repeats on'),
(3491, 'Event start time'),
(3492, 'Event title'),
(3493, 'Event Title'),
(3494, 'Event Website'),
(3495, 'Events'),
(3496, 'Events for'),
(3497, 'Events open in new window'),
(3498, 'Events Scheduled'),
(3499, 'every'),
(3500, 'Every'),
(3501, 'Every 2nd'),
(3502, 'every 3 hours'),
(3503, 'Every 3rd'),
(3504, 'every 4 hours'),
(3505, 'Every 4th'),
(3506, 'every 5 hours'),
(3507, 'Every 5th'),
(3508, 'every 6 hours'),
(3509, 'Every 6th'),
(3510, 'every 8 hours'),
(3511, 'Every Fourth'),
(3512, 'Every name in the address book appears here, not only physicians.'),
(3513, 'Every Other'),
(3514, 'Every Third'),
(3515, 'Every, every other, every 3rd, etc.'),
(3516, 'Ewe'),
(3517, 'Exam and test results'),
(3518, 'Exam results'),
(3519, 'Exam Room #'),
(3520, 'Exam Room Number'),
(3521, 'Examination'),
(3522, 'Examination Date'),
(3523, 'Example'),
(3524, 'Example authenticator apps include'),
(3525, 'Example Privacy_Agreement.txt becomes Privacy Agreement button in Patient Documents'),
(3526, 'Examples'),
(3527, 'Examples of Sections are - Medications, Allergies, Vital Signs'),
(3528, 'Exams/Tests'),
(3529, 'Exam{{Physical Exam}}'),
(3530, 'Except'),
(3531, 'Excessive Tearing'),
(3532, 'Excluded Appointments - Tooltip - Number to Display'),
(3533, 'Excluded Patients'),
(3534, 'Exclusion'),
(3535, 'Exclusive Provider Organization (EPO)'),
(3536, 'Executables not allowed'),
(3537, 'Executive Paper Size'),
(3538, 'Exercise'),
(3539, 'Exercise patterns'),
(3540, 'Exercise Patterns'),
(3541, 'Exist'),
(3542, 'Exit'),
(3543, 'Exit from Administration'),
(3544, 'Exit Mail'),
(3545, 'Exophoria'),
(3546, 'Exotropia'),
(3547, 'Exp'),
(3548, 'Exp Date'),
(3549, 'Expand'),
(3550, 'expand'),
(3551, 'Expand All'),
(3552, 'Expand All Document Categories'),
(3553, 'Expand All Document Categories by Default'),
(3554, 'Expand Form'),
(3555, 'Expanded View'),
(3556, 'Expected form_encounter.pid to be '),
(3557, 'Expiration'),
(3558, 'Expiration Date'),
(3559, 'Expires'),
(3560, 'expires in'),
(3561, 'Export'),
(3562, 'Export as CSV'),
(3563, 'Export Billing'),
(3564, 'Export Configuration'),
(3565, 'Export File'),
(3566, 'Export Individual Invoices'),
(3567, 'Export OFX'),
(3568, 'Export Patient Demographics'),
(3569, 'Export Patient Demographics XML'),
(3570, 'Export PQRI Report'),
(3571, 'Export QRDA Report'),
(3572, 'Export Selected as CSV'),
(3573, 'Export Selected to Collections'),
(3574, 'Export to CSV'),
(3575, 'Export to external billing system'),
(3576, 'Export Zero Balances'),
(3577, 'Exposure to Foreign Countries'),
(3578, 'Exposure To Foreign Countries'),
(3579, 'Ext Time Collected'),
(3580, 'Extended family'),
(3581, 'External'),
(3582, 'External Data'),
(3583, 'External Data - any external data linked to either encounters or procedures'),
(3584, 'External Data Loads'),
(3585, 'External Database Import Utility'),
(3586, 'External Exam'),
(3587, 'External Exam Default Values'),
(3588, 'External ID'),
(3589, 'External Id'),
(3590, 'External identifier'),
(3591, 'External Only'),
(3592, 'External Organization'),
(3593, 'External Provider'),
(3594, 'External Referral'),
(3595, 'External Referral Followups'),
(3596, 'External referral?'),
(3597, 'External Referrals'),
(3598, 'Extract the zip file'),
(3599, 'Extracting the file. This will take some time...'),
(3600, 'Exudate:'),
(3601, 'Eye'),
(3602, 'Eye Coding Fields'),
(3603, 'Eye Coding Terms'),
(3604, 'Eye Contact Lens Brand list'),
(3605, 'Eye Contact Lens Manufacturer list'),
(3606, 'Eye Contact Lens Supplier list'),
(3607, 'Eye Dx{{eye diagnosis}}'),
(3608, 'Eye Exam'),
(3609, 'Eye Exam Default Values for New Providers'),
(3610, 'Eye Irritation'),
(3611, 'Eye Lens Material'),
(3612, 'Eye Lens Treatments'),
(3613, 'Eye Med'),
(3614, 'Eye Orders Defaults'),
(3615, 'Eye Pain'),
(3616, 'Eye QP List ANTSEG for New Providers'),
(3617, 'Eye QP List EXT for New Providers'),
(3618, 'Eye QP List RETINA for New Providers'),
(3619, 'Eye Redness'),
(3620, 'Eye Surgery'),
(3621, 'Eyedropper'),
(3622, 'Eyes'),
(3623, 'E{{esophoria}}'),
(3624, 'F'),
(3625, 'F/H Blood Problems'),
(3626, 'F/H Female Hirsutism/Striae'),
(3627, 'Facilities'),
(3628, 'Facility'),
(3629, 'facility'),
(3630, 'Facility Administration'),
(3631, 'Facility City'),
(3632, 'Facility Code'),
(3633, 'Facility Color Schema'),
(3634, 'Facility Country code'),
(3635, 'Facility Fax'),
(3636, 'Facility ID'),
(3637, 'Facility Name'),
(3638, 'Facility NPI'),
(3639, 'Facility Phone'),
(3640, 'Facility reflects the facility in which the visit occurred'),
(3641, 'Facility Specific User Information'),
(3642, 'Facility State'),
(3643, 'Facility Street'),
(3644, 'Facility Taxonomy'),
(3645, 'Facility Zip'),
(3646, 'Facility Zip Code'),
(3647, 'Facility:'),
(3648, 'FAIL'),
(3649, 'failed'),
(3650, 'Failed'),
(3651, 'Failed - already has group with the same name'),
(3652, 'Failed Patients'),
(3653, 'Failed to add patient to portal'),
(3654, 'Failed to compute a unique filename'),
(3655, 'Failed to create'),
(3656, 'Failed to create folder'),
(3657, 'Failed to create new group'),
(3658, 'Failed to create temporary folder. CouchDB will not work.'),
(3659, 'Failed to generate'),
(3660, 'Failed to get URL:'),
(3661, 'Failed to send'),
(3662, 'Failed UTF8 encoding check! Could not automatically fix.'),
(3663, 'Failed.'),
(3664, 'failure'),
(3665, 'Failure'),
(3666, 'FAILURE NOTICE: Direct Message Send Failed.'),
(3667, 'FAILURE: Couldn\'t create the zip'),
(3668, 'FAILURE: No patients for measure'),
(3669, 'Falls: Screening, Risk-Assessment, and Plan of Care to Prevent Future Falls (CQM)'),
(3670, 'Family Health History'),
(3671, 'Family History'),
(3672, 'Family history - Documents the patient\'s family history, an ICD10 diagnosis can be linked to the medical conditions'),
(3673, 'Family History of Glaucoma'),
(3674, 'Family History:'),
(3675, 'Family Member'),
(3676, 'Family Payment'),
(3677, 'Family Size'),
(3678, 'Fancy'),
(3679, 'Faroese'),
(3680, 'Farsi'),
(3681, 'Fasting'),
(3682, 'Fatal'),
(3683, 'Father'),
(3684, 'Fathers History'),
(3685, 'Fatigue'),
(3686, 'Fatigued'),
(3687, 'Favorites'),
(3688, 'Fax'),
(3689, 'Fax Count'),
(3690, 'Fax number'),
(3691, 'Fax sending failed'),
(3692, 'Fax/Scan'),
(3693, 'Faxes In'),
(3694, 'Faxes Out'),
(3695, 'Features'),
(3696, 'Feb'),
(3697, 'February'),
(3698, 'FECA'),
(3699, 'Federal Drug ID'),
(3700, 'Federal EIN'),
(3701, 'Federal Tax ID'),
(3702, 'Federally Qualified Health Center'),
(3703, 'Fee'),
(3704, 'fee'),
(3705, 'Fee is not allowed'),
(3706, 'Fee Sheet'),
(3707, 'Fee Sheet for'),
(3708, 'Fee Sheet Options'),
(3709, 'Fees'),
(3710, 'Female'),
(3711, 'Female AP'),
(3712, 'Female Condoms'),
(3713, 'Female G'),
(3714, 'Female LC'),
(3715, 'Female P'),
(3716, 'Female Symptoms'),
(3717, 'Female VSC'),
(3718, 'Fetch'),
(3719, 'Fetching following file from portal'),
(3720, 'Fever'),
(3721, 'Fever:'),
(3722, 'FH Blood Problems'),
(3723, 'FHD, WUXGA'),
(3724, 'FHIR Server Base Address'),
(3725, 'FH{{Family History}}'),
(3726, 'Fibroids'),
(3727, 'FIDO U2F - Universal 2nd Factor from the Fast IDentity Online alliance'),
(3728, 'Field'),
(3729, 'Field \'name\' cannot be NULL'),
(3730, 'Field ID'),
(3731, 'Field not suitable for edit option M'),
(3732, 'Field type to use for employer or subscriber country in demographics.'),
(3733, 'Field type to use for employer or subscriber state in demographics.'),
(3734, 'Field(s) are missing!'),
(3735, 'FIELD: Text(.a); '),
(3736, 'Fields in This Form'),
(3737, 'Fields{{visual fields}}'),
(3738, 'Fifth account message'),
(3739, 'Fijian'),
(3740, 'File'),
(3741, 'File base name becomes Menu selection'),
(3742, 'File Error'),
(3743, 'file in the Documentation directory to learn how to automate the process of creating log backups'),
(3744, 'file location'),
(3745, 'File management'),
(3746, 'file missing'),
(3747, 'File Name'),
(3748, 'File not found'),
(3749, 'File Not Found'),
(3750, 'File on server (modification date)'),
(3751, 'File path not found.'),
(3752, 'File privilege granted to OpenEMR user.'),
(3753, 'File retrieval from CouchDB failed'),
(3754, 'File Room'),
(3755, 'File to upload'),
(3756, 'File to Upload'),
(3757, 'File with same name already exists at location:'),
(3758, 'Filename'),
(3759, 'Filename must end with \".pdf\"'),
(3760, 'Files'),
(3761, 'Files type white list'),
(3762, 'Files with empty thumbnail'),
(3763, 'filetype is not accepted'),
(3764, 'Filipino'),
(3765, 'fill'),
(3766, 'Fill any of the Below Row.'),
(3767, 'Fill here only if sending email notification to patients'),
(3768, 'Fill in any missing details or edit existing information. This will be saved in the patient\'s demographics page in openEMR'),
(3769, 'Fill in the CPT codes using the displayed format. The common E/M codes are already filled in, add more as needed'),
(3770, 'Fill in the details as required and click Save'),
(3771, 'Fill in the details for the Organ/Disease Panel as before and click Save to close the pop-up'),
(3772, 'Fill in the details in a fashion similar to that used for allergies'),
(3773, 'Fill in the necessary details in a fashion similar to that for Medical Problems'),
(3774, 'Fill in the reason and select a provider and clinic and click the Add Recall button to complete the process'),
(3775, 'Fill in the required details especially for the external facilities and click Save'),
(3776, 'Fill in the values below'),
(3777, 'Fill Instructions'),
(3778, 'Fill the Row.'),
(3779, 'Fill your first and last name'),
(3780, 'Filling in the other fields will help provide additional details pertinent to the referral'),
(3781, 'Filter'),
(3782, 'Filter for Constants'),
(3783, 'Filter for Definitions'),
(3784, 'filtered from'),
(3785, 'Filters'),
(3786, 'filters'),
(3787, 'Final'),
(3788, 'Final Diagnosis'),
(3789, 'Final diagnosis by specialist'),
(3790, 'Final Status'),
(3791, 'Financial'),
(3792, 'Financial Close Date (yyyy-mm-dd)'),
(3793, 'Financial Reporting - anything'),
(3794, 'Financial Reporting - anything (rep_a)'),
(3795, 'Financial Reporting - my encounters'),
(3796, 'Financial Reporting - my encounters (rep)'),
(3797, 'Financial Review'),
(3798, 'Financial Review Date'),
(3799, 'Financial Summary by Service Code'),
(3800, 'Financial transactions corresponding to the date range, if any, will be listed in the table'),
(3801, 'Find'),
(3802, 'Find Available'),
(3803, 'Find Available Appointments'),
(3804, 'Find Patient'),
(3805, 'Find Patient Education Materials'),
(3806, 'Find Procedure Order'),
(3807, 'Findings'),
(3808, 'Findings by specialist'),
(3809, 'Fine'),
(3810, 'Finish'),
(3811, 'Finish Payments'),
(3812, 'Finished'),
(3813, 'finished'),
(3814, 'Finnish'),
(3815, 'First'),
(3816, 'First account message'),
(3817, 'First day in the week'),
(3818, 'First day of the week'),
(3819, 'First Modern Contraception at this Clinic (with Prior Contraceptive Use)'),
(3820, 'First Modern Contraceptive Use (Lifetime)'),
(3821, 'First Name'),
(3822, 'First name'),
(3823, 'First Name:'),
(3824, 'First Visit or Consultation'),
(3825, 'First visit: No Old Records'),
(3826, 'First-time visits only'),
(3827, 'Firstname Lastname'),
(3828, 'Fitness'),
(3829, 'Fitness Level'),
(3830, 'Fitness level for this player on this day'),
(3831, 'Fitness Testing'),
(3832, 'Fitness to Play'),
(3833, 'Fix encounter dates - any encounters'),
(3834, 'Fix encounter dates - any encounters (date_a)'),
(3835, 'Fix this'),
(3836, 'FL'),
(3837, 'Flash'),
(3838, 'Flatulence'),
(3839, 'Flow'),
(3840, 'Flow Board'),
(3841, 'Flow Board will only display completed checkouts for this many minutes. Zero is continuous display.'),
(3842, 'Flow Board: Allow Date Range'),
(3843, 'Flow Board: Default Ending Date'),
(3844, 'Flow Board: Default Starting Date'),
(3845, 'Flow Board: Disable'),
(3846, 'Flow Board: display completed checkouts (minutes)'),
(3847, 'Flow Board: Enable Random Drug Testing'),
(3848, 'Flow Board: Ending Date'),
(3849, 'Flow Board: Max tests per Patient per year'),
(3850, 'Flow Board: Percentage of Patients to Drug Test'),
(3851, 'Flow Board: Show Encounter Number'),
(3852, 'Flow Board: Show Patient ID'),
(3853, 'Flow Board: Show Staff Action'),
(3854, 'Flow Board: Show Visit Reason'),
(3855, 'Flow Board: Timer Refresh Interval'),
(3856, 'Flu season'),
(3857, 'Flu Season'),
(3858, 'Flu Vaccination'),
(3859, 'Fluid and electrolyte problem'),
(3860, 'FMS'),
(3861, 'Folio Paper Size'),
(3862, 'Follow manually'),
(3863, 'Follow these instructions for installing or upgrading the following database'),
(3864, 'Follow Up'),
(3865, 'Follow Up Note'),
(3866, 'Follow Up Reason'),
(3867, 'Following audit log entry number is missing'),
(3868, 'Following is a new custom constant:'),
(3869, 'Following is a new custom language:'),
(3870, 'Following is a new definition (Language, Constant, Definition):'),
(3871, 'Following rows in the audit log have been tampered'),
(3872, 'Followup Services'),
(3873, 'Followups Indicated'),
(3874, 'Font Size'),
(3875, 'Font Size in Pt'),
(3876, 'Food Intolerance'),
(3877, 'Foot'),
(3878, 'Foot Problems'),
(3879, 'Foot:'),
(3880, 'Football Injuries'),
(3881, 'Football Injury'),
(3882, 'Football Injury Report'),
(3883, 'Footwear Type'),
(3884, 'for'),
(3885, 'For'),
(3886, 'for '),
(3887, 'For a Recognized Panel of Tests'),
(3888, 'For a search to show results the codes must exist in the database.'),
(3889, 'For added ease of use the Fee Sheet needs to be customized'),
(3890, 'For an existing patient, go to Patient Summary->Documents. For a new patient, go to Miscellanous->New Documents'),
(3891, 'For code'),
(3892, 'For Custom Groups'),
(3893, 'For Dates'),
(3894, 'For detailed instructions close the \'Enter Details\' pop-up and click on the Help icon on the main form. '),
(3895, 'For detailed instructions close the \'Enter Provider Details\' popup and click on the Help icon on the main form. '),
(3896, 'For each issue type there is a list of commonly selected titles which are customizable for your clinic\'s specific needs'),
(3897, 'For ease of use it is rendered as a unique 6 digit number'),
(3898, 'For editing the values under Procedures you would need to modify'),
(3899, 'For Encounter Claims'),
(3900, 'for Encounter on'),
(3901, 'For example:'),
(3902, 'For Firefox click'),
(3903, 'For full billing functionality in the United States CPT/HCPCS codes will then need to be installed'),
(3904, 'For HCFA 02/12 Box 15 is Other Date with a qualifier to specify what the date indicates'),
(3905, 'For HCFA 02/12 Onset date specified on the Encounter Form needs a qualifier'),
(3906, 'For Identifying Code use 34392 the code used by a major lab, if using an external lab this is a vendor specific code if not you can assign any unique value'),
(3907, 'for Invoice'),
(3908, 'For manual lab entry you can give the organization any name  - e.g Local Lab and click Save'),
(3909, 'For Medicare only, forces the referring provider to be the same as the rendering provider.'),
(3910, 'For more information on Issues see the '),
(3911, 'for OBR placer order number'),
(3912, 'for patient'),
(3913, 'For procedures performed in the practice, whether it is an office based procedure or a lab or radiological procedure done in the facility, the provider can be defined as Local Lab, Office Based or have any descriptive name'),
(3914, 'For proper display of results the Identifying Codes for each test entered in the Procedure Orders module has to be unique'),
(3915, 'For proper display of results this is a required field'),
(3916, 'For proper display of the order and results the entry indicating a result has to be the immediate successor or child of an order'),
(3917, 'For proper tabulated display of tests and results an identifying code is required'),
(3918, 'For Provider'),
(3919, 'For Referred Organization/Practitioner'),
(3920, 'For the deceased notification to appear the date of death must be noted under Medical Dashboard > Edit Demographics > Misc'),
(3921, 'For the name to appear on the drop-down list it must be first entered in Administration > Address Book '),
(3922, 'For the past'),
(3923, 'For the Procedure Module to be useful several tests have to be setup using the above methods'),
(3924, 'For the Standard Code use the LOINC code 24326-1'),
(3925, 'For this name to show in the drop-down box in the Procedures > Providers setup page select only Lab Service as the Type even if it represents a Radiological facility'),
(3926, 'for this patient not yet assigned to any encounter.'),
(3927, 'For those interested details of OTP'),
(3928, 'For those interested in details of what constitutes a Continuity of Care Record (CCR) click on the eye icon'),
(3929, 'For those interested in what happens under the hood'),
(3930, 'For those lines the Description will indicate the details of the code'),
(3931, 'For those with administrative privileges an icon is displayed next to the My Messages caption'),
(3932, 'For TOTP to work a unique secret key must be shared between OpenEMR and the user'),
(3933, 'For U2F support on Linux click'),
(3934, 'for variable'),
(3935, 'for:'),
(3936, 'Force Billing Widget Open'),
(3937, 'Force Create New Patient'),
(3938, 'Force Show'),
(3939, 'Forearm'),
(3940, 'Form'),
(3941, 'form'),
(3942, 'Form element not found'),
(3943, 'Form Keys'),
(3944, 'Form signed successfully'),
(3945, 'Format'),
(3946, 'format'),
(3947, 'Format for age display'),
(3948, 'Format incorrect for NDC'),
(3949, 'Format used to display most dates.'),
(3950, 'Format used to display most times.'),
(3951, 'Formatted Report'),
(3952, 'Former smoker'),
(3953, 'Forms'),
(3954, 'Forms Administration'),
(3955, 'Forms Administration (forms)'),
(3956, 'Forms Esigned'),
(3957, 'Formularies are inserted into table'),
(3958, 'Formularies inserted into table'),
(3959, 'Forward'),
(3960, 'FORWARD A DATED REMINDER'),
(3961, 'Forward message to practice.'),
(3962, 'Forward Pages via Fax'),
(3963, 'Forward this Reminder'),
(3964, 'Forwarded'),
(3965, 'Forwarded Portal Message Re: '),
(3966, 'Foster Child'),
(3967, 'Fourth'),
(3968, 'Fourth account message'),
(3969, 'Fracture'),
(3970, 'Fracture at the Navicula'),
(3971, 'Fracture lateral malleolus'),
(3972, 'Fracture medial malleolus'),
(3973, 'Fracture, Base of fifth (5th) Metatarsal'),
(3974, 'Frame'),
(3975, 'Frame support required'),
(3976, 'Free authenticator app'),
(3977, 'French'),
(3978, 'French (Canadian)'),
(3979, 'French (Standard)'),
(3980, 'Frequency'),
(3981, 'Frequent Colds'),
(3982, 'Frequent Illness'),
(3983, 'Fri'),
(3984, 'Friday'),
(3985, 'Friend'),
(3986, 'From'),
(3987, 'FROM'),
(3988, 'from'),
(3989, 'From Date Cannot be Greater than To Date.'),
(3990, 'From date should be less than To date'),
(3991, 'From Period'),
(3992, 'From the Issues Menu item on the Nav Bar'),
(3993, 'From the Patient dashboard via the individual Issues widgets on the right hand column'),
(3994, 'From:'),
(3995, 'From: '),
(3996, 'FROM_CITY'),
(3997, 'FROM_EMAIL'),
(3998, 'FROM_FNAME'),
(3999, 'FROM_LNAME'),
(4000, 'FROM_MNAME'),
(4001, 'FROM_PHONE'),
(4002, 'FROM_PHONECELL'),
(4003, 'FROM_POSTAL'),
(4004, 'FROM_STATE'),
(4005, 'FROM_STREET'),
(4006, 'FROM_TITLE'),
(4007, 'FROM_VALEDICTORY'),
(4008, 'Front Office'),
(4009, 'Front Office Receipts'),
(4010, 'Front Office Receipts Report'),
(4011, 'Front Rec'),
(4012, 'Frontal Right:'),
(4013, 'Fr{{Friday}}'),
(4014, 'FTCF{{Full to count fingers}}'),
(4015, 'FTN{{Finger Tension abbreviation}}'),
(4016, 'FT{{finger tension}}'),
(4017, 'Fula- Fulah- Pulaar- Pular'),
(4018, 'Full Name'),
(4019, 'Full or Initial'),
(4020, 'Full path to directory containing MySQL executables.'),
(4021, 'Full path to directory containing Perl executables.'),
(4022, 'Full path to directory for event log backup.'),
(4023, 'Full path to directory used for temporary files.'),
(4024, 'Full Play'),
(4025, 'Full Screen'),
(4026, 'Full Training'),
(4027, 'Fullscreen'),
(4028, 'Fully Paid'),
(4029, 'Functional and Cognitive Status'),
(4030, 'Functional and Cognitive Status Form'),
(4031, 'Functional Cognitive Status'),
(4032, 'Functional Condition'),
(4033, 'Funding Source'),
(4034, 'Further information regarding using the e-prescribing modules can be found by clicking this link'),
(4035, 'Future'),
(4036, 'Future Appointments'),
(4037, 'F{{Friday}}'),
(4038, 'G'),
(4039, 'G/DL'),
(4040, 'Galaxy S9/S9 Plus'),
(4041, 'Galician'),
(4042, 'Gall Bladder Condition'),
(4043, 'Gall Stones'),
(4044, 'Game Period'),
(4045, 'Games'),
(4046, 'Games Missed'),
(4047, 'games/events'),
(4048, 'Games/Events Missed'),
(4049, 'Ganda'),
(4050, 'Gastritis'),
(4051, 'Gastro Pain'),
(4052, 'Gastrointestinal'),
(4053, 'Gateway API Login Auth Name or Secret'),
(4054, 'Gateway Publishable Key'),
(4055, 'Gateway Transaction Key'),
(4056, 'GCAC Statistics Report'),
(4057, 'GCAC Stats'),
(4058, 'GCAC visit form is missing'),
(4059, 'Gender'),
(4060, 'Gender '),
(4061, 'General'),
(4062, 'General data'),
(4063, 'General Issue List'),
(4064, 'General physician'),
(4065, 'General Service Category'),
(4066, 'General Tab - lists the risk factors / past medical conditions on the left and the Results of various clinical exams, procedures and tests on the right'),
(4067, 'General Theme'),
(4068, 'General Theme (need to logout/login after change this setting)'),
(4069, 'Generally a good idea to include it'),
(4070, 'Generally, the first field in a group should be Label Cols = 1 Data Cols = number of Layout columns from Group Properties.'),
(4071, 'Generate'),
(4072, 'Generate and download CMS 1500 paper claims'),
(4073, 'Generate and download CMS 1500 paper claims on Preprinted form'),
(4074, 'Generate and download HCFA 1500 paper claims'),
(4075, 'Generate and download UB-04 CMS1450'),
(4076, 'Generate and download UB-04 CMS1450 with form'),
(4077, 'Generate and download X12 batch'),
(4078, 'Generate and download X12 encounter claim batch'),
(4079, 'Generate and transmit permissible prescriptions electronically (All Prescriptions).'),
(4080, 'Generate and transmit permissible prescriptions electronically (Not including controlled substances).'),
(4081, 'Generate and transmit permissible prescriptions electronically.'),
(4082, 'Generate CMS 1500'),
(4083, 'Generate CMS 1500 PDF'),
(4084, 'Generate CMS 1500 TEXT'),
(4085, 'Generate HCFA'),
(4086, 'Generate Institutional X12 837I'),
(4087, 'Generate Invoice'),
(4088, 'Generate Letter'),
(4089, 'Generate Letter regarding '),
(4090, 'Generate new key'),
(4091, 'Generate PQRI report (Method A)'),
(4092, 'Generate PQRI report (Method A) - 2011'),
(4093, 'Generate PQRI report (Method E)'),
(4094, 'Generate PQRI report (Method E) - 2011'),
(4095, 'Generate QRDA I – 2014'),
(4096, 'Generate QRDA III - 2014'),
(4097, 'Generate Report'),
(4098, 'Generate Report - that opens the CCD in a separate tab on the browser'),
(4099, 'Generate Report - that opens the CCR in a separate tab on the browser'),
(4100, 'Generate Report that creates a report and displays it in a separate tab on the browser '),
(4101, 'Generate safe key'),
(4102, 'Generate thumbnail'),
(4103, 'Generate thumbnail images'),
(4104, 'Generate Thumbnails'),
(4105, 'Generate Username And Password For'),
(4106, 'Generate X12'),
(4107, 'Generate X12 837I'),
(4108, 'Generate X12 Encounter'),
(4109, 'Generate/Download QRDA I - 2014'),
(4110, 'Generated on'),
(4111, 'Generated thumbnail(s)'),
(4112, 'Generates'),
(4113, 'Genericname1'),
(4114, 'Genericname2'),
(4115, 'Genericval1'),
(4116, 'Genericval2'),
(4117, 'Genitourinary'),
(4118, 'Genitourinary medicine physician'),
(4119, 'GEN{{General}}'),
(4120, 'Georgian'),
(4121, 'German'),
(4122, 'Gest age'),
(4123, 'Gestational Age'),
(4124, 'Get History'),
(4125, 'GET HL7'),
(4126, 'Get HL7'),
(4127, 'Get Started'),
(4128, 'Give a Name to this group, in our case it will be called Serum Chemistry'),
(4129, 'Give it a sequence number of 3'),
(4130, 'GI{{Gastrointestinal}}'),
(4131, 'Glare{{Acuity under Glare conditions}}'),
(4132, 'Glaucoma'),
(4133, 'Glaucoma Family History'),
(4134, 'Glaucoma Zone'),
(4135, 'Global'),
(4136, 'Global All Patients'),
(4137, 'Global Default Patient Country'),
(4138, 'Global ID'),
(4139, 'Global Settings'),
(4140, 'Globals'),
(4141, 'GM/DL'),
(4142, 'go'),
(4143, 'GO'),
(4144, 'Go'),
(4145, 'Go Back'),
(4146, 'Go back'),
(4147, 'Go to'),
(4148, 'Go to Administration > Address Book > Add New'),
(4149, 'Go to Administration > Globals > CDR > Dated reminders maximum alerts to show and change the value to a higher number'),
(4150, 'Go to Administration > Globals > Connectors'),
(4151, 'Go to Administration > Globals > Connectors and check the Enable MedEx Communication Service check box and click Save'),
(4152, 'Go to Administration > Lists, select each one of the above lists from the drop-down box and make changes as needed'),
(4153, 'Go to Administration > Lists. Select \'Fee Sheet\' from the dropdown box'),
(4154, 'Go to Adminstration > Codes. Select ICD 10 under Type, enter ICD 10 Code, enter Description, under category select an appropriate category, this ICD 10 code will then appear when the button with that category is clicked'),
(4155, 'Go to Adminstration > Lists and select \'Code Types\' from the dropdown box. Use either ICD 9 or ICD 10, inactivate ICD 9 and select \'No\' in the last dropdown box under ICD 10'),
(4156, 'Go to Procedures > Providers and click on the Add New button'),
(4157, 'Go to week of'),
(4158, 'Go Today'),
(4159, 'Goal A'),
(4160, 'Goal and Methods'),
(4161, 'Goal B'),
(4162, 'Goal C'),
(4163, 'Gonioscopy'),
(4164, 'Gonio{{Gonioscopy abbreviation}}'),
(4165, 'Google Auth'),
(4166, 'Grade of Injury'),
(4167, 'Grade:'),
(4168, 'grams'),
(4169, 'Grand Total'),
(4170, 'Grand Totals'),
(4171, 'Grandchild'),
(4172, 'Grandparent'),
(4173, 'Graphable'),
(4174, 'Great Grandparent'),
(4175, 'Greater Than'),
(4176, 'Greater Than or Equal To'),
(4177, 'Greek'),
(4178, 'Greek, Modern'),
(4179, 'Green lines show changes that were successfully applied.'),
(4180, 'Group'),
(4181, 'Group > Group > Procedure Order > Discrete Result'),
(4182, 'Group > Procedure Order > Discrete Result'),
(4183, 'Group appointments'),
(4184, 'Group Attendance Form'),
(4185, 'Group Attendance Statuses'),
(4186, 'Group detailed log of appointment in patient record'),
(4187, 'Group detailed log of appointment in patient record (gdlog)'),
(4188, 'Group Details'),
(4189, 'Group Encounter'),
(4190, 'Group Encounter Form'),
(4191, 'Group encounter log'),
(4192, 'Group encounter log (glog)'),
(4193, 'Group Finder'),
(4194, 'Group Home'),
(4195, 'Group Id'),
(4196, 'Group name'),
(4197, 'Group Name'),
(4198, 'Group names cannot be blank'),
(4199, 'Group names cannot start with numbers or spaces.'),
(4200, 'Group names cannot start with numbers.'),
(4201, 'Group Number'),
(4202, 'Group number'),
(4203, 'Group Payment'),
(4204, 'Group Properties'),
(4205, 'Group Search'),
(4206, 'Group Statuses'),
(4207, 'Group Type'),
(4208, 'Group\'s name'),
(4209, 'Group:'),
(4210, 'Groupname'),
(4211, 'Groups'),
(4212, 'Groups (groups)'),
(4213, 'Groups and Access Controls'),
(4214, 'Growth Chart'),
(4215, 'Growth-Chart'),
(4216, 'gtts(drops)'),
(4217, 'Guamanian'),
(4218, 'Guarani'),
(4219, 'Guaraní'),
(4220, 'Guardian'),
(4221, 'Guardian Email Address'),
(4222, 'Guardian\'s Name'),
(4223, 'Guardians Name'),
(4224, 'Guest counselors'),
(4225, 'Gujarati'),
(4226, 'GU{{Genitourinary}}'),
(4227, 'Gynecological Exam'),
(4228, 'h'),
(4229, 'H(T){{intermittent hypertropia}}'),
(4230, 'h.s.'),
(4231, 'H/O Hepatitis'),
(4232, 'had been successfully deleted. Any sub-categories if present were moved below'),
(4233, 'Haematoma / bruising'),
(4234, 'HAI Status'),
(4235, 'Haitian- Haitian Creole'),
(4236, 'Half-Sibling'),
(4237, 'Hand + fingers'),
(4238, 'Hand Problems'),
(4239, 'Handicapped dependent'),
(4240, 'Happy Birthday'),
(4241, 'Hard copy OTP'),
(4242, 'Hard copy OTP is used for online banking in some countries'),
(4243, 'Hard Disk'),
(4244, 'Hardship w/o'),
(4245, 'has been linked to visit'),
(4246, 'has expired'),
(4247, 'Hash'),
(4248, 'Hash did not exist for this file. A new hash was generated.'),
(4249, 'Hash does not match. Data integrity has been compromised.'),
(4250, 'Hausa'),
(4251, 'Hawaiian'),
(4252, 'Hazardous activities'),
(4253, 'Hazardous Activities'),
(4254, 'HB{{abbreviation for Horizontal Prism Base}}'),
(4255, 'HCFA 1500 or CMS 1500 - both refer to the same form. Prior to 2001 the federal agency within the United States Department of Health and Human Services (HHS) that administers the Medicare program was called Health Care Financing Administration (HCFA) since then it is called Centers for Medicare & Medicaid Services (CMS)'),
(4256, 'HCFA FORM'),
(4257, 'HCFA left margin in points'),
(4258, 'HCFA Margins'),
(4259, 'HCFA top margin in points'),
(4260, 'HCPCS Procedure/Service'),
(4261, 'HD'),
(4262, 'HD+'),
(4263, 'he PostCalendar '),
(4264, 'Head'),
(4265, 'Head Circ'),
(4266, 'Head Circumference'),
(4267, 'Headache'),
(4268, 'Headaches'),
(4269, 'Header'),
(4270, 'health care operations'),
(4271, 'Health Care Operations'),
(4272, 'Health Care Providers'),
(4273, 'Health centre/clinic'),
(4274, 'Health Insurance Claim Form'),
(4275, 'Health Level-7 or HL7 refers to a set of international standards for transfer of clinical and administrative data between software applications used by various healthcare providers'),
(4276, 'Health Maintenance Organization'),
(4277, 'Health Maintenance Organization (HMO) Medicare Risk'),
(4278, 'Hearing Loss'),
(4279, 'Heart Attack'),
(4280, 'Heart Disease'),
(4281, 'Heart Failure'),
(4282, 'Heart Problem'),
(4283, 'Heart Problems'),
(4284, 'Heart Surgery'),
(4285, 'Heart Transplant'),
(4286, 'HEART:'),
(4287, 'Heartburn'),
(4288, 'Heat or Cold'),
(4289, 'Heat Or Cold'),
(4290, 'Heavy tobacco smoker'),
(4291, 'Hebrew'),
(4292, 'Hebrew (modern)'),
(4293, 'HEENT'),
(4294, 'Height'),
(4295, 'Height/Length'),
(4296, 'Help'),
(4297, 'help'),
(4298, 'Help content goes here'),
(4299, 'Hematemesis'),
(4300, 'Hematochezia'),
(4301, 'Hematologic'),
(4302, 'Hematuria'),
(4303, 'Hemoglobin'),
(4304, 'Hemoglobin A1C'),
(4305, 'Hemoptysis'),
(4306, 'Hepatitis'),
(4307, 'Hepatitis A 1'),
(4308, 'Hepatitis A 2'),
(4309, 'Hepatitis B 1'),
(4310, 'Hepatitis B 2'),
(4311, 'Hepatitis B 3'),
(4312, 'here'),
(4313, 'Here you can customize the ACL further.'),
(4314, 'Herero'),
(4315, 'Hernia Repair'),
(4316, 'Herniated Disc'),
(4317, 'Herpes'),
(4318, 'Hertel Exophthalmometry'),
(4319, 'HERT{{Hertel exophthalmometry}}'),
(4320, 'Hesitancy'),
(4321, 'heyyo. you have been here for '),
(4322, 'Hib 1'),
(4323, 'Hib 2'),
(4324, 'Hib 3'),
(4325, 'Hib 4'),
(4326, 'Hidden'),
(4327, 'Hidden Events Administration'),
(4328, 'Hide'),
(4329, 'Hide Billing Widget'),
(4330, 'Hide Details'),
(4331, 'Hide Empty E-Sign Logs On Report'),
(4332, 'Hide Encryption/Decryption Options In Document Management'),
(4333, 'Hide Help Modal'),
(4334, 'Hide Menu'),
(4335, 'Hide print feature'),
(4336, 'Hide Reminders'),
(4337, 'hide this field'),
(4338, 'Hide/Show Columns'),
(4339, 'HIE'),
(4340, 'High'),
(4341, 'High (high)'),
(4342, 'High Blood Pressure'),
(4343, 'Hindi'),
(4344, 'Hip + groin'),
(4345, 'Hip and groin'),
(4346, 'Hip Problems'),
(4347, 'Hip Replacement'),
(4348, 'Hipaa Message'),
(4349, 'HIPAA Notice Received'),
(4350, 'Hiri Motu'),
(4351, 'Hirsutism/Striae'),
(4352, 'Hispanic'),
(4353, 'Hispanic - Other (Born in US)'),
(4354, 'Hispanic - Other (Born outside US)'),
(4355, 'Hispanic or Latino'),
(4356, 'Historical information -source unspecified'),
(4357, 'History'),
(4358, 'History & Lifestyle'),
(4359, 'History - patient\'s past medical history, family history, personal history'),
(4360, 'History and Lifestyle'),
(4361, 'History and Lifestyle Help'),
(4362, 'History and Physical 2008'),
(4363, 'History Data'),
(4364, 'History Date'),
(4365, 'History Fields'),
(4366, 'History Murmur'),
(4367, 'History not authorized'),
(4368, 'History of Heart Murmur'),
(4369, 'History of Present Illness: A detailed HPI may be completed by using either four or more HPI elements OR the status of three chronic or inactive problems.'),
(4370, 'History Order'),
(4371, 'History order'),
(4372, 'Hits'),
(4373, 'HIV'),
(4374, 'Hives'),
(4375, 'HL7'),
(4376, 'HL7 - MSH-11 - Processing ID'),
(4377, 'HL7 - MSH-3.1 - Sending application'),
(4378, 'HL7 - MSH-4.1 - Sending facility'),
(4379, 'HL7 - MSH-5.1 - Receiving application'),
(4380, 'HL7 - MSH-6.1 - Receiving facility'),
(4381, 'HL7 Code'),
(4382, 'HL7 is supported by more than 1,600 members from over 50 countries, making it a widely accepted standard'),
(4383, 'HL7 Viewer'),
(4384, 'HL7-V3 Concept Code'),
(4385, 'HMOL/L'),
(4386, 'Hmong'),
(4387, 'Hold down [Ctrl] for multiple selections or to unselect'),
(4388, 'Hold down Ctrl button to select multiple issues'),
(4389, 'Hold down Ctrl to select multiple items'),
(4390, 'Hold down Ctrl to select multiple squads'),
(4391, 'Holidays management'),
(4392, 'Home'),
(4393, 'Home Phone'),
(4394, 'Home Phone Number'),
(4395, 'Homeless'),
(4396, 'Homeless or similar?'),
(4397, 'Homeless Shelter'),
(4398, 'Homeless, etc'),
(4399, 'Homeless, etc.'),
(4400, 'Hooks'),
(4401, 'Horiz Base{{abbreviation for Horizontal Prism Base}}'),
(4402, 'Horiz Prism{{abbreviation for Horizontal Prism Power}}'),
(4403, 'Horizontal Prism Base'),
(4404, 'Horizontal Prism Power'),
(4405, 'Hospice'),
(4406, 'Hospital date needed for successful billing of hospital encounters'),
(4407, 'Host'),
(4408, 'Host Name'),
(4409, 'Host Name cannot be empty'),
(4410, 'hour'),
(4411, 'Hour'),
(4412, 'Hours'),
(4413, 'hours'),
(4414, 'How bad is it? 0-10, mild, mod, severe?'),
(4415, 'How did Injury Occur?'),
(4416, 'How did Injury Occur?:'),
(4417, 'How did they hear about us'),
(4418, 'How long does it last?'),
(4419, 'How many months ahead to query for upcoming events?'),
(4420, 'How Referred'),
(4421, 'How to sort a drop-lists'),
(4422, 'How-to Build the Impression/Plan'),
(4423, 'However SMS text messages can be intercepted and the use of SMS as a method of implementing out-of-band two-factor authentication is discouraged'),
(4424, 'HPI'),
(4425, 'HPI Elements'),
(4426, 'HPI:'),
(4427, 'HP{{abbreviation for Horizontal Prism Power}}'),
(4428, 'HT'),
(4429, 'HTML'),
(4430, 'HTML Output?'),
(4431, 'HTN{{hypertension}}'),
(4432, 'Http Error'),
(4433, 'Https link for the OpenEMR Support LLC Lab Exchange Service.'),
(4434, 'HT{{hyperphoria}}'),
(4435, 'Hungarian'),
(4436, 'Hylafax Directory'),
(4437, 'Hylafax Enscript Command'),
(4438, 'Hylafax Server'),
(4439, 'Hylafax server hostname.'),
(4440, 'Hyperactive'),
(4441, 'Hyperphoria'),
(4442, 'Hypertension'),
(4443, 'Hypertension: Blood Pressure Measurement'),
(4444, 'Hypertension: Blood Pressure Measurement (CQM)'),
(4445, 'Hyperthyroidism'),
(4446, 'hypo(T){{intermittent hypotropia}}'),
(4447, 'Hypothyroidism'),
(4448, 'Hypotropia'),
(4449, 'hypoT{{hypotropia}}'),
(4450, 'Hysterectomy'),
(4451, 'I'),
(4452, 'I am busy during this time.'),
(4453, 'I do not have permission to read '),
(4454, 'I have read and accept the'),
(4455, 'I have read and my practice agrees to the'),
(4456, 'I know but we need it!'),
(4457, 'ICD'),
(4458, 'ICD10 Diagnosis'),
(4459, 'ICD10 Procedure/Service'),
(4460, 'ICD9'),
(4461, 'ICD9 Diagnosis'),
(4462, 'ICD9 Procedure/Service'),
(4463, 'Icelandic'),
(4464, 'icon'),
(4465, 'Icon Legend'),
(4466, 'Icons'),
(4467, 'ID'),
(4468, 'id'),
(4469, 'Id'),
(4470, 'ID - select a unique three letter id, all in lower case'),
(4471, 'ID cannot be blank'),
(4472, 'ID Card'),
(4473, 'ID Card/Photos - will display any ID Card or patient photo that has been uploaded to Documents > Patient Information > Patient ID Card and Patient Photograph folders'),
(4474, 'ID Number (ETIN)'),
(4475, 'IDays'),
(4476, 'identified as'),
(4477, 'Identifier(one word)'),
(4478, 'Identifying Code'),
(4479, 'Idle Session Timeout Seconds'),
(4480, 'Ido'),
(4481, 'if'),
(4482, 'If a field\'s Data Col = 0 the data field will immediately follow its label field on the same line'),
(4483, 'If a field\'s Label Col = 0 the label will immediately follow the previous data field in the Order sequence, on the same line as the Data field.'),
(4484, 'If a field\'s Label Col = 1 the label field will go to a new line unless the previous field\'s total column values (Label + Data) is less than number of Layout columns from Group Properties or Layout Properties.'),
(4485, 'If a product is sold then change the default to reflect required number. Leave it at one for procedures'),
(4486, 'If a wrong code was selected click on the Coding text-box to to bring up the Select Codes pop-up page'),
(4487, 'If all data for all columns are complete for this form'),
(4488, 'If all the details were entered correctly you will see Blood Glucose in the Name column with a vertical bar before it indicating that it has no descendants or children, Result in the Category column, WWT01R in the Code column, the Tier column value should be 3 and the Description column should say Fasting Glucose result'),
(4489, 'If billing justification is used enter the name of the diagnosis code type.'),
(4490, 'If configured correctly the Name column should say Blood Glucose with a vertical bar before it indicating no descendants or children, the Category column should say Custom Order and both Name and Category columns will be highlighted in pink indicating a custom grouped order'),
(4491, 'If desired the current message can be printed'),
(4492, 'If enabled, uses the specified active directory for login and authentication.'),
(4493, 'if entered, select only those who have had this service'),
(4494, 'If it it still active i.e. End Date is not entered it will be displayed in red, if the problem has an end Date then it will be displayed in black'),
(4495, 'If name, any part of lastname or lastname,firstname'),
(4496, 'If NewCrop eRx - the electronic prescription module, is enabled the NewCrop MedEntry and NewCrop Account Status buttons will be appear here'),
(4497, 'If not listed you can add the drug to the Title text-box'),
(4498, 'If only capture the QR code but do not register the TOTP key with OpenEMR this feature will not be enabled at login'),
(4499, 'If patient has appointment click OK to create encounter otherwise, cancel this and then create an encounter for today visit.'),
(4500, 'If paying by'),
(4501, 'If person is deceased, then enter date of death.'),
(4502, 'If phone is lost will not be able to login'),
(4503, 'If privileges have to be modified then it can be done either one user at a time at Administration > Users or more conveniently on this page i.e. Administration > ACL where all users are listed on one page and more options are available.'),
(4504, 'If set as high will restrict visibility of encounter to users belonging to certain groups (AROs). By default - Physicians and Administrators'),
(4505, 'If SMTP is used, the server`s hostname or IP address.'),
(4506, 'If SMTP is used, the server`s TCP port number (usually 25).'),
(4507, 'If so desired the default board can be disabled by going to Administration > Calendar > Recall Board: Disable and checking the checkbox and click Save'),
(4508, 'If so you will have to create individual Procedure Orders (the orders) for these tests along with Discrete Results (the place to enter and display the returned result)'),
(4509, 'If successful it authenticates the user'),
(4510, 'If the checkbox is checked and the message is sent to multiple users then each user has to sign off on the message by clicking the Set As Completed Button for that message'),
(4511, 'If the checkbox is checked then each individual of a group receiving this message will have to sign off by clicking the Set As Completed button'),
(4512, 'If the csv file has been uploaded, then click on the \"Import holiday events\" button. NOTE that clicking on the button will remove all the existing rows in the calendar_external table'),
(4513, 'If the desired title is not included, it can be typed into the text box below the list'),
(4514, 'If the displayed table says No matching record found it means that the ICD10 code set is not installed'),
(4515, 'If the help file does not exist create one and place it in'),
(4516, 'If the issue has not been linked to an encounter it will display 0'),
(4517, 'If the medical problem is not listed in the drop-down box click on Coding text-box to bring up the Select Codes pop-up page'),
(4518, 'If the message is forwarded it will show up in the active messages list of the user to whom the message was forwarded and disappear from the current user\'s active messages list'),
(4519, 'If the Offsite Patient portal is enabled there will be either a button that says Create Offsite Portal Credentials provided the patient has given permission to access the online patient portal or a message that says Patient has not authorized the Patient Portal'),
(4520, 'If the Online Patient portal is enabled there will be either a button that says Create Online Portal Credentials provided the patient has given permission to access the online patient portal or a message that says Patient has not authorized the Patient Portal'),
(4521, 'If the Online/Offsite Portal Credentials has already been set the button will change to'),
(4522, 'If the patient has any demographic data entered in openEMR it will automatically populate the relevant fields on the right sections'),
(4523, 'If the patient has not authorized patient portal then a Patient has not authorized the Patient Portal message will be shown here'),
(4524, 'If the patient is being added to the recall list on the day of the visit it would reflect the current date'),
(4525, 'If the patient is calling back to be added to the list the last visit may be in the remote past. Be aware that the 1,2,3 plus years are calculated and displayed on the Date box at the bottom of this section'),
(4526, 'If the patient is deceased then the deceased notification will appear in red in this section'),
(4527, 'If the report is sent electronically all steps needed for safe and secure transmission of Protected Health Information (PHI) must be followed'),
(4528, 'If there is no vendor enter any arbitrary unique number, preferably a 5 digit zero-padded e.g. 00211'),
(4529, 'If these tests are being sent to the same external lab they will have identical vendor specific Identifying Codes causing duplicate lines to appear when results are displayed'),
(4530, 'If they have been configured correctly each result should have a Tier value of 4, indicating they are the successor or child to the first line above with a Tier value of 3, i.e Electrolyte Panel'),
(4531, 'If this page does not refresh, reload the Messages page manually'),
(4532, 'If unassigned will default to php.ini setting for date.timezone.'),
(4533, 'if unemployed enter Student'),
(4534, 'If value is left as zero, will be sorted alphabetically'),
(4535, 'If YMD is selected for age display, switch to just Years when patients older than this value in years'),
(4536, 'If you are having troubles logging into your account.'),
(4537, 'If you are interested in what happens under the hood'),
(4538, 'If you are only using a small subset of the CPT codes you can manually enter it in Administration > Codes'),
(4539, 'If you are planning on entering different prices for different modalities of payment go to Administration > Lists'),
(4540, 'If you are using Electronic lab entry then fill in the required details and click Save'),
(4541, 'If you are using multiple labs enter the details for each one of them'),
(4542, 'If you change e-RX Role for ePrescription, it may affect the ePrescription workflow. If you face any difficulty, contact your ePrescription vendor.'),
(4543, 'If you change your Smartphone you can recapture the TOTP key QR code on to a new device by first logging in using the authenticator app on your old phone and then going to Miscellaneous > MFA Authentication and clicking the View button on the Current Authentication Method section'),
(4544, 'If you check the check box in any of these cells it will generate an entry in the last cell called Progress'),
(4545, 'If you choose to do a manual entry click the \'Invoice Search\' radio button. It displays two sections \'Post Item\' and \'Invoice Search\''),
(4546, 'If you choose to integrate lab results with the patient\'s record then some preliminary setup has to be performed'),
(4547, 'If you click on any user in the \'User Memberships\' section you will now see these newly created group (ARO) in the \'Inactive\' column. These can now be assigned in the usual fashion as needed.'),
(4548, 'If you click on the edit icon next to this newly created group (ARO) you will note that the \'Active\' column contains only a single entry - Placeholder (Maintains empty ACLs). As yet this new group (ARO) has NO access to any part of the program as there are no ACOs assigned in the \'Active\' column.'),
(4549, 'If you Click the blue + sign on Serum Chemistry you will see a new line called Organ/Disease Panel with a Category of Sub Group'),
(4550, 'If you continue to experience this error please contact support.'),
(4551, 'If you do not find a required value in the drop-down box you will need to add it via Administration > Lists > Procedure Units. Refer to the help file in Procedures > Providers'),
(4552, 'If you do not select a match the patient will be created.'),
(4553, 'If you do not select at least one of these, OpenEMR will operate in a receive-only mode'),
(4554, 'If you do not submit orders electronically or receive result electronically leave it as the default value, Download'),
(4555, 'If you do not want to do so the following method involves adding data manually using the openEMR interface'),
(4556, 'If you drill down to the Electrolyte Panel line and click on the + sign in the Name column you should see Sodium listed underneath it with a Category value of Result with a Tier value of 4'),
(4557, 'If you drill down to the Electrolyte Panel line you should see it have a Category of Order and be highlighted in yellow indicating that it is a search-able and valid order and has a Tier value of 3'),
(4558, 'If you had selected multiple codes they will be separated by semi-colons'),
(4559, 'If you have already filled the calendar_external table, then click on \"Synchronize\" button to have the holidays in the calendar view. NOTE that clicking on the button will remove all the existing items in the calendar view related to holidays'),
(4560, 'If you have an old superbill you can use its grouping of codes as a template to start the customization'),
(4561, 'If you have chosen to upload electronic remittances, then the search window redisplays itself with the matching invoices from the X12 file.  You may click on any of these invoice numbers (as described below) if you wish to make any corrections before the remittance information is applied. To apply the changes, click the Process ERA File button at the bottom of the page.  This will produce a new window with a detailed report.'),
(4562, 'If you have chosen to upload electronic remittances, then the search window redisplays itself with the matching invoices from the X12 file. You may click on any of these invoice numbers (as described above) if you wish to make any corrections before the remittance information is applied. To apply the changes, click the \'Process ERA File\' button at the bottom of the page. This will produce a new window with a detailed report.'),
(4563, 'If you have enabled the TOTP method the next time you login you will be asked to enter the TOTP password'),
(4564, 'If you have entered a Pay Date in the search page, this will override the posting date of payments and adjustments that are otherwise taken from the X12 file.  This may be useful for reporting purposes, if you want your receipts reporting to use your posting date rather than the insurance company\'s processing date.  Note that this will also affect dates of prior payments and adjustments that are put into secondary claims.'),
(4565, 'If you have entered a Pay Date in the search page, this will override the posting date of payments and adjustments that are otherwise taken from the X12 file. This may be useful for reporting purposes, if you want your receipts reporting to use your posting date rather than the insurance company\'s processing date. Note that this will also affect dates of prior payments and adjustments that are put into secondary claims.'),
(4566, 'If you have followed all the above steps correctly you should see Serum Uric Acid under Name, it will be preceded by a vertical bar indicating the absence of descendants or children to this entry'),
(4567, 'If you have followed the above steps correctly the Serum Uric Acid Test should now have a + sign preceding the Name indicating the presence of successors or children'),
(4568, 'If you have lost your Smartphone those with administrator privileges can delete the keys by going to Administration > Users and checking the Clear 2FA checkbox and clicking Save'),
(4569, 'If you have NewCrop eRx module enabled then the allergies have to be entered on the NewCrop MedEntry page'),
(4570, 'If you have not already done some pre-configuration, including adding providers, do so by going to Procedures > Providers'),
(4571, 'If you have the need to order individual components of the panel you will have to create a separate Procedure Order for each individual component of the panel and store the returned result under a Discrete Result created in a fashion similar to that used earlier to create an order for Serum Uric Acid'),
(4572, 'If you hit the refresh button without setting any filters then all dated reminders for the user will appear below'),
(4573, 'If you leave it at the default of 0 then the top level entries that you make will be sorted alphabetically'),
(4574, 'If you made changes and want to re-send it, delete the original (in Communications) and try again.'),
(4575, 'If you made changes and want to re-send it, delete the original (in Communications) or wait 60 seconds, and try again.'),
(4576, 'If you need to manually enter the returned result each test (Custom Favorite Item) should have a Discrete Result as a direct descendant'),
(4577, 'If you see no entries in the Order From drop-down box it means that you have not set up a lab under Procedures > Providers'),
(4578, 'If you want to change data types, or add rows or columns'),
(4579, 'If you want to upgrade the database, then place the database zip file in the following directory'),
(4580, 'If your search was successful the search results will be displayed in the search results box below'),
(4581, 'Igbo'),
(4582, 'Ignore'),
(4583, 'IIS Code'),
(4584, 'Illness'),
(4585, 'IM'),
(4586, 'Image canvas'),
(4587, 'Image Results'),
(4588, 'Images'),
(4589, 'Imaging'),
(4590, 'Imaging Integration, and DICOM Diagnostic Imaging Reports - 2009'),
(4591, 'Imaging Service'),
(4592, 'Immune System'),
(4593, 'Immunization'),
(4594, 'Immunization Administered Site'),
(4595, 'Immunization Code'),
(4596, 'Immunization Completion Status'),
(4597, 'Immunization Date'),
(4598, 'Immunization Expiration Date'),
(4599, 'Immunization Information Source'),
(4600, 'Immunization Lot Number'),
(4601, 'Immunization Manufacturer'),
(4602, 'Immunization Observation Criteria'),
(4603, 'Immunization Observation Results'),
(4604, 'Immunization Ordering Provider'),
(4605, 'Immunization Refusal Reason'),
(4606, 'Immunization Registry'),
(4607, 'Immunization Registry Status'),
(4608, 'Immunization Registry Status Effective Date'),
(4609, 'Immunization Report'),
(4610, 'Immunization Service'),
(4611, 'Immunization Title'),
(4612, 'Immunization Vaccine Eligibility Results'),
(4613, 'Immunizations'),
(4614, 'Immunizations - lists immunization history and allows for adding new entries or editing existing ones'),
(4615, 'Immunize'),
(4616, 'Immunologic'),
(4617, 'Immuno{{immunologic}}'),
(4618, 'IMMUNO{{Immunology/Rheumatology}}'),
(4619, 'Implants'),
(4620, 'Import'),
(4621, 'Import All'),
(4622, 'Import CCDA'),
(4623, 'Import CCR'),
(4624, 'Import certificate to the browser.'),
(4625, 'Import Configuration'),
(4626, 'Import deferred for time-to-live'),
(4627, 'Import Formularies'),
(4628, 'Import holiday events'),
(4629, 'Import Holidays'),
(4630, 'Import Patient'),
(4631, 'Import Patient Demographics'),
(4632, 'Import Patient Demographics XML'),
(4633, 'Import Pharmacies'),
(4634, 'Import Pharmacies Script'),
(4635, 'Important - the Identifying Code for Custom Favorite Group is always user defined'),
(4636, 'Important Codes'),
(4637, 'IMPORTANT: The NPI number also exists in the Address Book entry for the provider, take care to enter the correct NPI number'),
(4638, 'IMPORTANT: This upload tool is only for uploading documents on patients that are not yet entered into the system. To upload files for patients whom already have been entered into the system, please use the upload tool linked within the Patient Summary screen.'),
(4639, 'Imported Allergies'),
(4640, 'Imported from Accounting'),
(4641, 'Imported Medications'),
(4642, 'Imported Problems'),
(4643, 'Importing the entire CPT code set after you license it from the American Medical Association would get you all the relevant CPT codes in one fell swoop'),
(4644, 'Impression/Plan'),
(4645, 'Impression/Plan Builder'),
(4646, 'Improved'),
(4647, 'IMP{{impression}}'),
(4648, 'in'),
(4649, 'IN'),
(4650, 'In a likewise fashion you will create a Discrete Result for Potassium, Chloride and Carbon Dioxide'),
(4651, 'In a likewise manner create a Custom Favorite Item each for TSH (Sequence 2, Identifying Code WWT02, Standard Code 30166-3) and Vitamin D (Sequence 3, Identifying Code WWT03, Standard Code 35365-6)'),
(4652, 'In a likewise manner create a Discrete Result each for TSH (Sequence - 2, Identifying Code - WWT02R, Default Units - mU/L, Default Range - 0.4-4, leave Followup Services blank) and Vitamin D (Sequence - 3, Identifying Code - WWT03R, Default Units - ng/mL, Default Range - 0-20, leave Followup Services blank)'),
(4653, 'In addition there are 2 checkboxes'),
(4654, 'In addition to creating a Referral the system also allows you to print a blank referral form that can be manually filled to generate a Referral'),
(4655, 'In any case establishing a connection, ensuring HIPAA compliance, data security etc will require coding, the cost of which is generally borne by the lab. They however will only approve if the volume of business justifies their investment'),
(4656, 'In Current Chat'),
(4657, 'in each eye'),
(4658, 'In exam room'),
(4659, 'In House'),
(4660, 'in left eye'),
(4661, 'in nostril'),
(4662, 'In Office'),
(4663, 'In openEMR the Continuity of Care Record (CCR) reports to be generated can be limited to a specific date range by checking the Use Date Range check-box and entering the desired date range'),
(4664, 'In order to fulfill Meaningful Use requirements for Computerized Provider Order Entry (CPOE) for lab and radiology tests this module needs to be used'),
(4665, 'In order to properly store and retrieve test results and place new orders, tests/orders have to be setup in a hierarchical manner'),
(4666, 'In order to record the values of the results returned you have to create a separate Discrete Result (Tier 4) for each of the panel\'s constituents, the fruit, as direct descendants of this (General Health Panel) branch (Tier 3). Examples of the results being CBC - Hemoglobin, CBC - Hematocrit, CMP - Sodium, CMP - Potassium, TSH etc. '),
(4667, 'In order to register your device, please provide your OpenEMR login password'),
(4668, 'In order to send Continuity of Care Record (CCR) and /or Continuity of Care Document (CCD) optionally check phiMail Allow CCD Send and/or phiMail Allow CCR Send to enable the Transmit feature for these data types'),
(4669, 'In our case we will choose Local Lab that was setup previously'),
(4670, 'In our case we will leave it as Unassigned'),
(4671, 'In Portrait mode, determines the height of the envelope along the y-axis in mm'),
(4672, 'In Portrait mode, determines the width of the envelope along the x-axis in mm'),
(4673, 'in right eye'),
(4674, 'In short electronic orders can be done, it involves a significant amount of testing and customization to be certified by the lab, generally through a third party and can only happen if the lab agrees to give the green light to the project'),
(4675, 'In the \'Post Item\' section that is displayed at the top you may enter a source (e.g. check number), pay date and check amount. The reason for the source and pay date is so that you don\'t have to enter them over and over again for each claim. The amount that you enter will be decreased for each invoice that is given part of the payment, and hopefully will end at zero when you are done.'),
(4676, 'In the above example an order for a single test was created, i.e. Serum Uric Acid'),
(4677, 'In the default installation click on Add to bring up the Add/Edit Issue pop-up page'),
(4678, 'In the patient\'s words'),
(4679, 'In the second stage of Meaningful Use, the CCD, but not the CCR, was included as part of the standard for clinical document exchange'),
(4680, 'In this case the Custom Favorite Group will be called Preop Labs and the two recognized panels will be direct descendants, each in a Custom Favorite Item Tier named CBC and Renal Panel respectively'),
(4681, 'In this case you will create a Procedure Order, the fruit bearing branch called General Health Panel (Tier 3)'),
(4682, 'In total, there are seventeen sections that can be included within a Continuity of Care Record (CCR)'),
(4683, 'In Use'),
(4684, 'in-house'),
(4685, 'In-process'),
(4686, 'Inactive'),
(4687, 'Inactive - Lost to follow - up'),
(4688, 'Inactive - Moved or gone elsewhere'),
(4689, 'Inactive - Permanently inactive'),
(4690, 'Inactive - Unspecified'),
(4691, 'Inactive Days'),
(4692, 'Inactive Messages'),
(4693, 'Inbox'),
(4694, 'INCITS Code'),
(4695, 'Include all values reported for each result code'),
(4696, 'Include Checksum'),
(4697, 'Include Completed'),
(4698, 'Include Inactive'),
(4699, 'Include inactive users'),
(4700, 'Include Uncategorized'),
(4701, 'Include Unstructured data'),
(4702, 'Include Vitals'),
(4703, 'Include vitals data?'),
(4704, 'Included Providers'),
(4705, 'including CVF{{Confrontational Visual Fields}} and Pupils'),
(4706, 'Inclusion'),
(4707, 'Income'),
(4708, 'Incoming results requiring attention:'),
(4709, 'Incomplete'),
(4710, 'Incomplete Abortion Treatment'),
(4711, 'Incontinence'),
(4712, 'Incorporate clinical lab-test results into certified EHR technology as structured data.'),
(4713, 'Incorrect password!'),
(4714, 'Increase the limit to a larger number say 100 so that you can decide on which ones to act upon'),
(4715, 'increased:'),
(4716, 'Indemnity Insurance'),
(4717, 'Independent Clinic'),
(4718, 'Independent Laboratory'),
(4719, 'Indeterminate'),
(4720, 'Indian'),
(4721, 'Indian Health Service Free-standing Facility'),
(4722, 'Indian Health Service Provider-based Facility'),
(4723, 'Indicates abnormality'),
(4724, 'Indicates if this issue is an ophthalmic-specific medication'),
(4725, 'Indicates if this issue is currently active'),
(4726, 'Indications'),
(4727, 'Indicator for specialized usage'),
(4728, 'Indigent Patients'),
(4729, 'Indigent Patients Report'),
(4730, 'Indigents'),
(4731, 'Individual access can be tailored to fit the needs by assigning a user to one or more groups (AROs). The user will then inherit all the privileges, i.e have access to parts of the program (ACO), of each group (ARO) the user belongs to.'),
(4732, 'Individual pages can override 2nd and 3rd options by implementing a log message.'),
(4733, 'Individual tests or even individual recognized panel of tests can be grouped together as a Custom Favorite Group'),
(4734, 'Indonesian'),
(4735, 'Induced Abortion'),
(4736, 'Industry'),
(4737, 'Ineligible'),
(4738, 'Infection / Abscess'),
(4739, 'Infections'),
(4740, 'Infert Couns'),
(4741, 'Infertility'),
(4742, 'Influenza 1'),
(4743, 'Influenza 2'),
(4744, 'Influenza Immunization for Patients >= 50 Years Old'),
(4745, 'Influenza Immunization for Patients >= 50 Years Old (CQM)'),
(4746, 'Influenza Vaccine'),
(4747, 'Info'),
(4748, 'Info test 1'),
(4749, 'Info test 2'),
(4750, 'Info test 3'),
(4751, 'Info test 4'),
(4752, 'Info test 5'),
(4753, 'Info test 6'),
(4754, 'Informant'),
(4755, 'Information regarding the Patient Portal is also shown in the header section'),
(4756, 'Information Source'),
(4757, 'inf{{inferior}}'),
(4758, 'inhalations'),
(4759, 'Inhale'),
(4760, 'inhilations'),
(4761, 'Initial Patient Population'),
(4762, 'Initial Treatment'),
(4763, 'Initial User'),
(4764, 'Initially Open Group'),
(4765, 'Inj/Rehab'),
(4766, 'Injectables'),
(4767, 'Injection'),
(4768, 'Injured Body Part'),
(4769, 'Injured Out'),
(4770, 'Injury'),
(4771, 'Injury Mechanism'),
(4772, 'Injury Overview Report'),
(4773, 'Injury Surveillance'),
(4774, 'Injury Type'),
(4775, 'Injury/illness-related'),
(4776, 'Inline'),
(4777, 'Inpatient Hospital'),
(4778, 'Inpatient Psychiatric Facility'),
(4779, 'Input does not begin with a MSH segment'),
(4780, 'Input Fields'),
(4781, 'INR'),
(4782, 'Ins 1'),
(4783, 'Ins 2 or Ins 3'),
(4784, 'Ins Address'),
(4785, 'Ins adjust'),
(4786, 'Ins bundling'),
(4787, 'Ins Code'),
(4788, 'Ins Group'),
(4789, 'Ins Name'),
(4790, 'Ins overpaid'),
(4791, 'Ins Policy'),
(4792, 'Ins refund'),
(4793, 'Ins Summary'),
(4794, 'Ins/fin issue'),
(4795, 'Ins1'),
(4796, 'Ins2'),
(4797, 'Ins3'),
(4798, 'Insert'),
(4799, 'Insert failed: '),
(4800, 'Insert normals'),
(4801, 'Insert normals - 100/100'),
(4802, 'Insert normals - 11/11'),
(4803, 'Insert old events into tables'),
(4804, 'Insert special field'),
(4805, 'Insert the key into the USB port'),
(4806, 'Insert U2F Key'),
(4807, 'Insert your key into a USB port and click the Authenticate button below.'),
(4808, 'Inserted'),
(4809, 'Insomnia'),
(4810, 'Inspect the log'),
(4811, 'Inspection'),
(4812, 'Instability / subluxation'),
(4813, 'INSTALL'),
(4814, 'Install'),
(4815, 'Install Code Set'),
(4816, 'install DB'),
(4817, 'Install it by going to Administration > Other > External Data Loads > ICD10 > Staged Releases and click Install'),
(4818, 'Install Layout Service Codes'),
(4819, 'Install the EMR Direct trust anchor certificate'),
(4820, 'Installations processing a large number of Direct messages may want a shorter interval'),
(4821, 'Installed Release'),
(4822, 'Installing codes in openEMR'),
(4823, 'Instructed'),
(4824, 'Instruction'),
(4825, 'Instructions'),
(4826, 'Instructions:'),
(4827, 'Insufficient inventory for product'),
(4828, 'Insufficient inventory for product ID'),
(4829, 'Insulin Dependent Diabetes'),
(4830, 'Insurance'),
(4831, 'insurance'),
(4832, 'Insurance Address'),
(4833, 'Insurance Adj'),
(4834, 'Insurance Adjustment'),
(4835, 'Insurance Balance'),
(4836, 'Insurance Balance Due'),
(4837, 'Insurance Comp'),
(4838, 'Insurance Companies'),
(4839, 'Insurance Company'),
(4840, 'Insurance Company Search/Add'),
(4841, 'Insurance Credit'),
(4842, 'Insurance Data'),
(4843, 'Insurance ID'),
(4844, 'Insurance Information'),
(4845, 'Insurance information on file'),
(4846, 'Insurance Name'),
(4847, 'Insurance Numbers'),
(4848, 'Insurance Payment'),
(4849, 'Insurance Payments'),
(4850, 'Insurance Provider'),
(4851, 'Insurance Search/Select/Add'),
(4852, 'Insurance Types'),
(4853, 'Insurances'),
(4854, 'Insured'),
(4855, 'Intake Conclusion'),
(4856, 'Intake Date'),
(4857, 'Integers1-100'),
(4858, 'Integrating lab results into a patient\'s chart in openEMR can be done manually i.e. both ordering tests and uploading the received results or electronically'),
(4859, 'Intellectual Decline'),
(4860, 'Inter-pupillary distance'),
(4861, 'Interact with created transactions'),
(4862, 'Interlingua'),
(4863, 'Interlingue'),
(4864, 'Intermediate Care Facility/Mentally Retarded'),
(4865, 'Intermittent Esotropia'),
(4866, 'Intermittent Exotropia'),
(4867, 'intermittent hyperphoria'),
(4868, 'Intermittent hypotropia'),
(4869, 'Internal Allergies'),
(4870, 'Internal error - no pages were selected!'),
(4871, 'Internal error - patient ID was not provided!'),
(4872, 'Internal error accessing uploaded file!'),
(4873, 'Internal error in tableNameFromLayout'),
(4874, 'Internal error!'),
(4875, 'Internal error, no drug ID specified!'),
(4876, 'Internal error: Cannot find MSH-10'),
(4877, 'Internal error: claim '),
(4878, 'Internal error: encounter \''),
(4879, 'Internal error: pid or encounter is missing.'),
(4880, 'Internal error: we do not seem to be in an encounter!'),
(4881, 'Internal Identifier (pid)'),
(4882, 'Internal Medications'),
(4883, 'Internal Problems'),
(4884, 'Internal Referrals'),
(4885, 'Internal Time Collected'),
(4886, 'International Duty'),
(4887, 'Internet Explorer browser version 6 to Internet Explorer browser version 11 does not support FIDO U2F API'),
(4888, 'Interpreter'),
(4889, 'Interpreter needed?'),
(4890, 'Interstitial Lung Disease'),
(4891, 'Interval'),
(4892, 'Interval (minutes)'),
(4893, 'Interval between message checks (set to zero for manual checks only)'),
(4894, 'Intervention'),
(4895, 'Intervention Provided'),
(4896, 'Intolerance'),
(4897, 'Intradermal'),
(4898, 'Intramuscular'),
(4899, 'intramuscularly'),
(4900, 'Intraocular Pressures'),
(4901, 'Intraocular Pressures (mmHg) by Date'),
(4902, 'intravenously'),
(4903, 'Introduction'),
(4904, 'Inuktitut'),
(4905, 'Inupiaq'),
(4906, 'Invalid character in'),
(4907, 'Invalid Content'),
(4908, 'Invalid Credit Card Number'),
(4909, 'Invalid Credit Card Values: Please correct'),
(4910, 'Invalid date range'),
(4911, 'Invalid encapsulated data encoding type'),
(4912, 'Invalid File'),
(4913, 'Invalid layout ID'),
(4914, 'Invalid length for'),
(4915, 'Invalid non-numeric character in'),
(4916, 'Invalid or missing payer in source for code '),
(4917, 'Invalid password'),
(4918, 'Invalid recipient address. Please try again.'),
(4919, 'Invalid Service Codes'),
(4920, 'Invalid source designation \"'),
(4921, 'Invalid Total!'),
(4922, 'Invalid username or password'),
(4923, 'InvAmt'),
(4924, 'Inventory'),
(4925, 'Inventory Activity'),
(4926, 'Inventory and sell both drugs and non-drug products'),
(4927, 'Inventory and sell drugs only'),
(4928, 'Inventory is not available for this order.'),
(4929, 'Inventory List'),
(4930, 'Inventory Transactions'),
(4931, 'Invoice'),
(4932, 'invoice'),
(4933, 'Invoice Actions'),
(4934, 'Invoice Balance'),
(4935, 'Invoice Balance cannot be posted. No Encounter is created.'),
(4936, 'Invoice Date'),
(4937, 'Invoice Details'),
(4938, 'Invoice has no date!'),
(4939, 'Invoice Number'),
(4940, 'Invoice Reference Number'),
(4941, 'Invoice reference number pool, if used'),
(4942, 'Invoice Reference Number Pools'),
(4943, 'Invoice Refno Pool'),
(4944, 'Invoice Search'),
(4945, 'Invoice:'),
(4946, 'IOP Chart'),
(4947, 'IOP Dilated{{Dilated Intraocular Pressure}}'),
(4948, 'IOP Graph'),
(4949, 'ios'),
(4950, 'iPad Pro 10.5 inches'),
(4951, 'iPad Pro 12.5 inches'),
(4952, 'iPad/iPad Mini, XGA'),
(4953, 'iPhone 6/7/8 Plus'),
(4954, 'iPhone X/XS'),
(4955, 'iPhone XR/XS Max'),
(4956, 'IPPF'),
(4957, 'IPPF Abortion'),
(4958, 'IPPF Contraception'),
(4959, 'IPPF SRH Data for'),
(4960, 'IPPF Statistics Report'),
(4961, 'IPPF Stats'),
(4962, 'IPV 1'),
(4963, 'IPV 2'),
(4964, 'IPV 3'),
(4965, 'IPV 4'),
(4966, 'Iris'),
(4967, 'Irish'),
(4968, 'Irregular Heart Beat'),
(4969, 'Irritability'),
(4970, 'Irritation'),
(4971, 'is a different language version of the following database'),
(4972, 'is a different version of the following database'),
(4973, 'is a more recent version of the following database'),
(4974, 'Is a record of all financial transactions between the patient and the practice'),
(4975, 'is a required field.'),
(4976, 'is a root node and can not be deleted.'),
(4977, 'is an extension of the following database'),
(4978, 'Is Authorizing Signature'),
(4979, 'Is it ok to map these CVX codes to already existent immunizations?'),
(4980, 'is misplaced or unknown'),
(4981, 'is not a valid email address'),
(4982, 'Is not selected'),
(4983, 'is not valid'),
(4984, 'is not valid (decimal fractions are OK).'),
(4985, 'Is PHP using Safe Mode?'),
(4986, 'Is selected'),
(4987, 'Is text from form layouts to be translated?'),
(4988, 'Is text from lists to be translated?'),
(4989, 'Is The File Encrypted?'),
(4990, 'Is this a Clinical Term code type?'),
(4991, 'Is this a diagnosis type?'),
(4992, 'Is this a Medical Problem code type?'),
(4993, 'Is this a Medication type?'),
(4994, 'Is this a procedure/service type?'),
(4995, 'Is this active?'),
(4996, 'Is this code type active?'),
(4997, 'Is this code type used in claims?'),
(4998, 'Is this Okay?'),
(4999, 'Is this really OK?'),
(5000, 'Is this type hidden in the fee sheet?'),
(5001, 'Is this using external sql tables? If it is, then choose the format.'),
(5002, 'is too long'),
(5003, 'ISO 639-2 Code'),
(5004, 'Issue'),
(5005, 'issue'),
(5006, 'Issue Date'),
(5007, 'Issue ID'),
(5008, 'Issue Subtypes'),
(5009, 'Issue Title'),
(5010, 'Issue Type'),
(5011, 'Issue Types'),
(5012, 'Issues'),
(5013, 'Issues (Injuries/Medical/Allergy)'),
(5014, 'Issues (Injuries/Medical/Allergy):'),
(5015, 'Issues - summarizes the patient\'s medical problems, allergies, medications, surgeries and dental issues'),
(5016, 'Issues and Encounters'),
(5017, 'Issues and Encounters for'),
(5018, 'Issues and Immunizations wiki page'),
(5019, 'Issues can also be linked to zero or more encounters'),
(5020, 'Issues Help'),
(5021, 'Issues List'),
(5022, 'Issues not authorized'),
(5023, 'Issues Section'),
(5024, 'It allows the browser to communicate directly to the USB device avoiding the need for the user to do anything more than insert the device into an USB port and tap it to activate it'),
(5025, 'It also lets you create new groups (AROs) as well as remove existing ones.'),
(5026, 'It can also just receive results electronically'),
(5027, 'It can be either linked to a patient or just be a message addressed to another user(s)'),
(5028, 'It combines what the user knows i.e. user password with what the user has i.e. a device that is unique or a mechanism to generate/receive a unique code to be used at each login'),
(5029, 'It consists of three sections '),
(5030, 'It consists of two parts - defining a Provider and configuring the Orders and Results'),
(5031, 'It consists of two parts - the Receiving application and Receiving facility'),
(5032, 'It consists of two parts - the Sending application and Sending facility'),
(5033, 'It contains a left and right section'),
(5034, 'It contains a QR code that needs to be captured by the authenticator app'),
(5035, 'It contains structured data that is included in the Continuity of Care Record (CCR) set to the the Clinical Document Architecture standard'),
(5036, 'It does not refer to the actual referral that has been created'),
(5037, 'It does so by using an algorithm to combine the current UNIX time with the secret key to generate an ever changing unique key'),
(5038, 'It has four tabs'),
(5039, 'It has three tiers '),
(5040, 'It is a commercial messaging module available to openEMR practices utilizing version 5.0.1 and higher'),
(5041, 'It is a field in the HL7 Message header known as Processing ID'),
(5042, 'It is a part of the medical record'),
(5043, 'It is also a subscription based service'),
(5044, 'It is also necessary to list an ICD10 code in order for the problem to be listed in Continuity of Care Report (CCR) and Continuity of Care Document (CCD)'),
(5045, 'It is divided into two sections'),
(5046, 'It is essential that you read through the first four sections to understand the underlying principles'),
(5047, 'It is far easier and intuitive to make major changes and reorganize the data on the spreadsheet before you start entering the data in openEMR'),
(5048, 'It is important to realize that this manages the MFA for the logged in user'),
(5049, 'It is important to understand the function of these two icons as all subsequent steps needed to properly set up the hierarchy will depend on the correct use of these two icons'),
(5050, 'It is intended to include only the information that is critical to effectively continue care'),
(5051, 'It is issued to health care providers in the United States by the Centers for Medicare and Medicaid Services (CMS)'),
(5052, 'It is not necessary for local lab, instead you can use any arbitrary unique number'),
(5053, 'It is not necessary to fill default Diagnosis Codes as ICD10 codes can be entered at the time of the actual ordering of the test'),
(5054, 'It is not submitted with the claim'),
(5055, 'It is not uncommon to order several blood tests together, grouping them as a panel of tests facilitates this process'),
(5056, 'It is the basic paper claim form prescribed by many payers for claims submitted by individual doctors & practices, nurses, and professionals, including therapists, chiropractors, and out-patient clinics, and in some cases, for ambulance services'),
(5057, 'It is used to link problems with encounters and is also used to see which encounters are associated to a particular issue'),
(5058, 'It is useful to practice on a trial site to become familiar with the process before doing so on the production openEMR application'),
(5059, 'It lets you search by ICD 9 and ICD 10 diagnostic codes and CPT4 and HCPCS service/procedure codes'),
(5060, 'It lets you send messages and dated reminders to staff members, add patient to the recall list and send SMS text messages to patients'),
(5061, 'It serves as a necessary bridge to a different environment, often with new clinicians who know nothing about the patient, enabling next provider to easily'),
(5062, 'It therefore stands to reason that you cannot create a Counter-Referral by itself'),
(5063, 'It uses an open standard and therefore available from various manufactures'),
(5064, 'It uses the HMAC-SHA256 hash function to generate a unique private key for the account'),
(5065, 'It uses this private key to sign the challenge and sends the response back to the application'),
(5066, 'It will be displayed in the visit summary'),
(5067, 'It will bring up the Enter Details pop-up form'),
(5068, 'It will bring up the Multi patient finder  popup'),
(5069, 'It will display the justify display pop-up. It has a search box that wil let you search for a ICD code.  It will also display the 10 most commonly used ICD codes. You can select any or all codes by checking the J (justify) checkbox and pressing update'),
(5070, 'It will have a value of 2 in the Tier column indicating it is a successor or child on the first line above having a Tier value of 1 which in this case is Serum Chemistry'),
(5071, 'It will have two sections - the Issues Section and the Encounters Section'),
(5072, 'It will help later in troubleshooting problems that may arise with your configuration of the Procedure Orders module'),
(5073, 'It will open the Create New Message section'),
(5074, 'It will take you to the MedEx sign-up page'),
(5075, 'It will then appear in the Allergies widget on the Patient Dashboard as well as under allergies in the Issues page'),
(5076, 'It will then appear in the Medications widget on the Patient Dashboard as well as under Medications in the Issues page'),
(5077, 'Italian'),
(5078, 'Item'),
(5079, 'item'),
(5080, 'Item Details'),
(5081, 'items'),
(5082, 'Items load failed'),
(5083, 'IU/L'),
(5084, 'IUD'),
(5085, 'IV'),
(5086, 'Jaeger'),
(5087, 'Jaeger{{Near Acuity Type Jaeger}}'),
(5088, 'Jan'),
(5089, 'January'),
(5090, 'Japanese'),
(5091, 'Jaundice'),
(5092, 'Javanese'),
(5093, 'Job Description'),
(5094, 'Job ID'),
(5095, 'Joint dislocations'),
(5096, 'Joint Pain'),
(5097, 'Joint sprains'),
(5098, 'Jul'),
(5099, 'July'),
(5100, 'Jump to Next Row'),
(5101, 'Jun'),
(5102, 'June'),
(5103, 'Just below the check information is a blue area where you put in your search parameters.  You can search by patient name, chart number, encounter number or date of service, or any combination of these.  You may also select whether you want to see all invoices, open invoices, or only invoices that are due (by the patient).  Click the Search button to perform the search.'),
(5104, 'Just Mine'),
(5105, 'Justification Entries'),
(5106, 'Justify'),
(5107, 'Justify Dx'),
(5108, 'Justify each CPT code with one or more justifications using the dropdown box. These will reflect the diagnosis codes that was previously selected in \'Select Codes\''),
(5109, 'Justify/Save'),
(5110, 'J{{Justify Header}}'),
(5111, 'k, here\'s the rest '),
(5112, 'K1{{Keratometry 1}}'),
(5113, 'K2{{Keratometry 2}}'),
(5114, 'Kalaallisut, Greenlandic'),
(5115, 'Kannada'),
(5116, 'Kanuri'),
(5117, 'Kashmiri'),
(5118, 'Kazakh'),
(5119, 'key'),
(5120, 'Key'),
(5121, 'Key access failed with error'),
(5122, 'Key for multiple database credentials encryption'),
(5123, 'Key Name'),
(5124, 'Keywords'),
(5125, 'kg'),
(5126, 'kg/m^2'),
(5127, 'Khmer'),
(5128, 'Kidney Cancer'),
(5129, 'Kidney Failure'),
(5130, 'Kidney Infections'),
(5131, 'Kidney Stones'),
(5132, 'Kidney Transplant'),
(5133, 'Kikuyu, Gikuyu'),
(5134, 'Kindle Fire HDX, Laptop MDPI, WXGA'),
(5135, 'Kinyarwanda'),
(5136, 'Kiosk'),
(5137, 'Kirundi'),
(5138, 'Knee'),
(5139, 'Knee Problems'),
(5140, 'Knee Replacement'),
(5141, 'Komi'),
(5142, 'Kongo'),
(5143, 'Korean'),
(5144, 'Kurdish'),
(5145, 'Kwanyama, Kuanyama'),
(5146, 'Kyrgyz'),
(5147, 'Lab'),
(5148, 'Lab Documents'),
(5149, 'Lab Exchange Site Address'),
(5150, 'Lab Exchange Site ID'),
(5151, 'Lab Exchange Token ID'),
(5152, 'Lab Order'),
(5153, 'Lab overview'),
(5154, 'Lab Overview'),
(5155, 'Lab Query Status'),
(5156, 'Lab Reference ID'),
(5157, 'Lab Report'),
(5158, 'Lab Result'),
(5159, 'Lab Results'),
(5160, 'Lab Results (write,addonly optional)'),
(5161, 'Lab Results Category Name'),
(5162, 'Lab Results Report'),
(5163, 'Lab Service'),
(5164, 'Lab Test Results'),
(5165, 'Lab/File'),
(5166, 'Label'),
(5167, 'Label cannot be blank'),
(5168, 'Label Cols'),
(5169, 'Label for this type'),
(5170, 'Label printed by'),
(5171, 'LabelCols must be a number between 1 and 999'),
(5172, 'Labels'),
(5173, 'Labels can be printed either for one patient or for all the selected patients'),
(5174, 'Laboratory Information'),
(5175, 'Laboratory Test'),
(5176, 'Labs'),
(5177, 'Laceration / skin condition'),
(5178, 'Laceration/abrasion'),
(5179, 'LAC{{left anterior chamber}}'),
(5180, 'LADate'),
(5181, 'LAD{{left adnexa}}'),
(5182, 'Landscape'),
(5183, 'Language'),
(5184, 'Language Code'),
(5185, 'Language definition added'),
(5186, 'Language Interface Tool'),
(5187, 'Language Interface Tool (language)'),
(5188, 'Language List (write,addonly optional)'),
(5189, 'Language List (write,addonly optional) (language)'),
(5190, 'Language Name'),
(5191, 'Language:'),
(5192, 'Lao'),
(5193, 'Laotian'),
(5194, 'Laptop HiDPI, WXGA+'),
(5195, 'Laser Interferometry'),
(5196, 'Laser Interferometry Acuity'),
(5197, 'Last'),
(5198, 'Last Activity Date'),
(5199, 'Last Appendectomy'),
(5200, 'Last Bill Date:'),
(5201, 'Last Breast Exam'),
(5202, 'Last Calendar Year'),
(5203, 'Last Cataract Surgery'),
(5204, 'Last Cholecystestomy'),
(5205, 'last date of this event'),
(5206, 'Last Encounter'),
(5207, 'Last Gyn. Exam'),
(5208, 'Last Heart Surgery'),
(5209, 'Last Hernia Repair'),
(5210, 'Last Hip Replacement'),
(5211, 'Last Hysterectomy'),
(5212, 'Last Knee Replacement'),
(5213, 'Last Level Billed'),
(5214, 'Last Mammogram'),
(5215, 'Last Menstrual Period'),
(5216, 'Last Modified'),
(5217, 'Last Month'),
(5218, 'Last Name'),
(5219, 'Last name'),
(5220, 'Last name, First name'),
(5221, 'Last name, first name'),
(5222, 'Last name, first name (title)'),
(5223, 'Last name, first name (title: comments)'),
(5224, 'Last Name:'),
(5225, 'Last Physical Exam'),
(5226, 'Last Prostate Exam'),
(5227, 'Last Rectal Exam'),
(5228, 'Last Reviewed'),
(5229, 'Last Run Started At'),
(5230, 'Last Saved'),
(5231, 'Last Sigmoid/Colonoscopy'),
(5232, 'Last Stmt'),
(5233, 'Last Tonsillectomy'),
(5234, 'Last Tx Date'),
(5235, 'Last update'),
(5236, 'Last update by'),
(5237, 'Last Verified On'),
(5238, 'Last Visit'),
(5239, 'Last X-ray'),
(5240, 'Late Recurrence (2-12 Mo)'),
(5241, 'Lateral Malleolus'),
(5242, 'Lateral malleolus:'),
(5243, 'Laterality'),
(5244, 'Laterality of this procedure, if applicable'),
(5245, 'laterally displaced PMI:'),
(5246, 'Latest Health Alerts'),
(5247, 'Latest Medical Records'),
(5248, 'Latest Results Only'),
(5249, 'Latest Visit or Consultation'),
(5250, 'Latin'),
(5251, 'Latvian'),
(5252, 'lat{{lateral}}'),
(5253, 'Law Firm'),
(5254, 'Lawyer'),
(5255, 'Layout'),
(5256, 'Layout (need to logout/login after change this setting)'),
(5257, 'Layout Based'),
(5258, 'Layout Columns'),
(5259, 'Layout Editor'),
(5260, 'Layout groups'),
(5261, 'Layout ID'),
(5262, 'Layout Properties'),
(5263, 'Layout Style'),
(5264, 'Layout-Based Transaction Forms'),
(5265, 'Layout-Based Visit Forms'),
(5266, 'Layouts'),
(5267, 'lb'),
(5268, 'LBF Encounter Form Preview'),
(5269, 'LBF_Validations'),
(5270, 'lbs'),
(5271, 'LB{{left brow}}'),
(5272, 'LCMT{{left Central Macular Thickness}}'),
(5273, 'LCUP{{left cup}}'),
(5274, 'LC{{left conjunctiva}}'),
(5275, 'LDL'),
(5276, 'LD{{left disc}}'),
(5277, 'leave blank if still active'),
(5278, 'Leave Blank To Keep Original Filename'),
(5279, 'Leave blank to keep password unchanged.'),
(5280, 'Leave Coding Blank'),
(5281, 'Leave coding blank as currently you can only enter ICD10 codes'),
(5282, 'Leave Destination blank'),
(5283, 'Leave it blank if the problem is still active'),
(5284, 'Leave Message With'),
(5285, 'Leave the Followup Services blank and click Save'),
(5286, 'Leave The Form'),
(5287, 'Leaving the pass phrase blank will not encrypt the document'),
(5288, 'Ledger'),
(5289, 'Ledger - Summarizes and tabulates all the charges, payments, adjustments and balances for all encounters pertaining to the patient'),
(5290, 'Left'),
(5291, 'Left Arm'),
(5292, 'Left Deltoid'),
(5293, 'Left Ear'),
(5294, 'left ear'),
(5295, 'Left Gluteus Medius'),
(5296, 'Left Lens'),
(5297, 'Left Lower Forearm'),
(5298, 'Left Margin (mm)'),
(5299, 'Left Thigh'),
(5300, 'Left Vastus Lateralis'),
(5301, 'Left w/o visit'),
(5302, 'Left:'),
(5303, 'Left: '),
(5304, 'Leg Pain/Cramping'),
(5305, 'Legal'),
(5306, 'Legal Authenticator'),
(5307, 'Legal Paper Size'),
(5308, 'Legend:'),
(5309, 'Length'),
(5310, 'Length of modifier, 0 if none'),
(5311, 'Lens'),
(5312, 'Lens Material'),
(5313, 'Lens Material Options'),
(5314, 'Lens Thickness'),
(5315, 'Lens Treatments'),
(5316, 'Less Than'),
(5317, 'Less Than or Equal To'),
(5318, 'Less-private information (write,addonly optional)'),
(5319, 'Less-private information (write,addonly optional) (relaxed)'),
(5320, 'Lets you delete a line or row. Hit \'Refresh\' and the line will have a strikethrough across it'),
(5321, 'Lets you filter the results as per the chosen criteria'),
(5322, 'Lets you send messages to staff members about patient related matters'),
(5323, 'Letter'),
(5324, 'Letter Generator'),
(5325, 'Letter Paper Size'),
(5326, 'Letterhead that doctor signs'),
(5327, 'Letterhead that patient signs'),
(5328, 'Lev Fn{{levator function}}'),
(5329, 'Levator Function'),
(5330, 'Level of urgency'),
(5331, 'LF{{levator function}}'),
(5332, 'LH{{left hertel measurement}}'),
(5333, 'Liability'),
(5334, 'Liability Medical'),
(5335, 'Library'),
(5336, 'License/ID'),
(5337, 'Licensed Prescriber'),
(5338, 'Licensed Prescriber First Name'),
(5339, 'Licensed Prescriber Last Name'),
(5340, 'Licensed Prescriber NPI'),
(5341, 'Licensed Prescriber Title (Prefix)'),
(5342, 'LicensedPrescriber Last name'),
(5343, 'LicensedPrescriber NPI'),
(5344, 'LicensedPrescriber UPIN'),
(5345, 'Life partner'),
(5346, 'Life threatening severity'),
(5347, 'Lifestyle'),
(5348, 'Lifestyle - lists the patient\'s use of Tobacco, Coffee, Alcohol, Recreational Drugs etc'),
(5349, 'Lifestyle status'),
(5350, 'Ligament tear or sprain'),
(5351, 'Light tobacco smoker'),
(5352, 'Likewise Laterality is not relevant in this context and can be left Unassigned'),
(5353, 'Limburgish, Limburgan, Limburger'),
(5354, 'Limit Of Events'),
(5355, 'Limited Exam'),
(5356, 'Limited HPI'),
(5357, 'Limits'),
(5358, 'Line'),
(5359, 'Lingala'),
(5360, 'Link'),
(5361, 'Link To Patient'),
(5362, 'Link/Add Issues (Injuries/Medical/Allergy) to Current Visit'),
(5363, 'Linked'),
(5364, 'Linked document'),
(5365, 'Linked procedure order'),
(5366, 'linked to document'),
(5367, 'linked to procedure order'),
(5368, 'List'),
(5369, 'List box'),
(5370, 'list box'),
(5371, 'list box w/ add'),
(5372, 'List box w/add'),
(5373, 'List Editor'),
(5374, 'List encounters'),
(5375, 'List groups'),
(5376, 'List Insurance Companies'),
(5377, 'List item ID'),
(5378, 'List items can not start with a number.'),
(5379, 'List items contains illegal character(s).'),
(5380, 'List layout items'),
(5381, 'List lists'),
(5382, 'List modifiers, up to 4 can be listed, each separated by a space or a colon'),
(5383, 'List Name'),
(5384, 'List names cannot start with numbers.'),
(5385, 'List of '),
(5386, 'List of health care practitioners'),
(5387, 'List of previous refractions'),
(5388, 'List of previously dispensed Spectacle and Contact Lens Rxs'),
(5389, 'List Prescriptions'),
(5390, 'List used by above Country Data Type option.'),
(5391, 'List used by above State Data Type option.'),
(5392, 'Listening port of the RFC 5425 TLS syslog server.'),
(5393, 'Listing an ICD10 code will let you search for educational material for that particular code '),
(5394, 'Lists'),
(5395, 'Lists (lists)'),
(5396, 'Lithuanian'),
(5397, 'Living Will'),
(5398, 'LI{{Laser Interferometry Acuity}}'),
(5399, 'LI{{Laser Interferometry}}'),
(5400, 'LK{{left cornea}}'),
(5401, 'LLL:'),
(5402, 'LLL{{left lower eyelid}}'),
(5403, 'LL{{left iris}}'),
(5404, 'LL{{left lens}}'),
(5405, 'LMAC{{left macula}}'),
(5406, 'LMC{{left medial chathus}}'),
(5407, 'LMP'),
(5408, 'Load Compendium'),
(5409, 'Load Definitions'),
(5410, 'Load Lab Configuration'),
(5411, 'Load OE Question Options'),
(5412, 'Load Order Definitions'),
(5413, 'Load Order Entry Questions'),
(5414, 'LOAD SUCCESSFUL. Codes inserted'),
(5415, 'LOADING'),
(5416, 'Loading'),
(5417, 'Loading data'),
(5418, 'Loading more results'),
(5419, 'Loading the files into the database. This will take some time...'),
(5420, 'Loading... Please wait'),
(5421, 'LOC'),
(5422, 'Local'),
(5423, 'Local Content'),
(5424, 'Local Filesystem'),
(5425, 'Local Filesystem will store the order as a HL7v2.3 message in a predefined location in the local server hosting openEMR'),
(5426, 'Locale'),
(5427, 'Locality'),
(5428, 'Location'),
(5429, 'location of the openemr machine and may contain sensitive data, so it is recommended to manually delete the files after its use'),
(5430, 'Location of this lot'),
(5431, 'Location unspecified'),
(5432, 'Location where Hylafax stores faxes.'),
(5433, 'Location where scans are stored.'),
(5434, 'Location:'),
(5435, 'Lock'),
(5436, 'Lock an e-signed form individually'),
(5437, 'Lock e-signed encounters and their forms'),
(5438, 'Lock?'),
(5439, 'Locked'),
(5440, 'Locked Payment Pending'),
(5441, 'Log all NewCrop eRx Requests and / or Responses.'),
(5442, 'Log entire document'),
(5443, 'Log In'),
(5444, 'Log in'),
(5445, 'Log Out'),
(5446, 'Logged in'),
(5447, 'Logged in as'),
(5448, 'Logged in as: '),
(5449, 'Logged out.'),
(5450, 'Logging'),
(5451, 'Login'),
(5452, 'login'),
(5453, 'Login - details are only required if you are connecting to a facility using the SFTP protocol '),
(5454, 'Login Into Facility'),
(5455, 'Login name of WordPress user for portal access'),
(5456, 'Login to remote host'),
(5457, 'Login to this remote host failed'),
(5458, 'Login with your user id and password and it will automatically authenticate you'),
(5459, 'Logout'),
(5460, 'logout'),
(5461, 'Logs'),
(5462, 'Logs Viewer'),
(5463, 'LOINC'),
(5464, 'LOINC Code'),
(5465, 'LOINC, rhymes with oink, is a database and universal standard for identifying medical laboratory observations'),
(5466, 'Look Up'),
(5467, 'Lot'),
(5468, 'Lot ID missing!'),
(5469, 'Lot Number'),
(5470, 'Low'),
(5471, 'Low Priority'),
(5472, 'Lower leg'),
(5473, 'Lower Lids'),
(5474, 'Lowest Priority'),
(5475, 'LP{{left peripheral retina}}'),
(5476, 'LT{{lens thickness}}'),
(5477, 'Luba-Katanga'),
(5478, 'Luhn'),
(5479, 'LUL{{left upper eyelid}}'),
(5480, 'Lumbar spine'),
(5481, 'LUNCH'),
(5482, 'Lunch'),
(5483, 'Lung Cancer'),
(5484, 'Lung Cancer Surgery'),
(5485, 'LUNGS:'),
(5486, 'Lungs:'),
(5487, 'Lupus'),
(5488, 'Luxembourgish, Letzeburgesch'),
(5489, 'LVIT{{left vitreous}}'),
(5490, 'LV{{left vessels}}'),
(5491, 'L{{left side}}'),
(5492, 'L{{left}}'),
(5493, 'M'),
(5494, 'MA Category'),
(5495, 'MA Client Accepting Abortion'),
(5496, 'MA Stats'),
(5497, 'Macedonian'),
(5498, 'Macula'),
(5499, 'Mail'),
(5500, 'Mail Order'),
(5501, 'Mail Sent'),
(5502, 'Mailing Address'),
(5503, 'Main'),
(5504, 'Main Address'),
(5505, 'Main Counselors'),
(5506, 'Main Log'),
(5507, 'Main Menu Role'),
(5508, 'Main Provider'),
(5509, 'Main Top Pane Screen'),
(5510, 'Main Top Pane Screen(Or Default First Tab)'),
(5511, 'Mainly Authorize.Net uses two keys'),
(5512, 'Maintain active medication allergy list.'),
(5513, 'Maintain active medication list.'),
(5514, 'Maintain an up-to-date problem list of current and active diagnoses.'),
(5515, 'Make modifications to current categories.'),
(5516, 'Make new appointment for'),
(5517, 'Make Payment'),
(5518, 'Make subsequent fields in the same row, Label = 0 Data = 0 and ensure enough columns are available from previous items to allow space for this new item. Otherwise result could be unpredictable'),
(5519, 'Make sure \"'),
(5520, 'Making batch text files for uploading to Clearing House and will mark as billed'),
(5521, 'Malagasy'),
(5522, 'Malaise:'),
(5523, 'Malay'),
(5524, 'Malayalam'),
(5525, 'Male'),
(5526, 'Male Condoms'),
(5527, 'Male VSC'),
(5528, 'Maltese'),
(5529, 'Mammogram'),
(5530, 'Manage'),
(5531, 'Manage Hooks'),
(5532, 'Manage Lists'),
(5533, 'Manage modules'),
(5534, 'Manage Modules'),
(5535, 'Manage modules (manage_modules)'),
(5536, 'Manage Multi Factor Authentication'),
(5537, 'Manage Templates'),
(5538, 'Manage Translations'),
(5539, 'Management'),
(5540, 'Manager'),
(5541, 'Mandatory'),
(5542, 'Mandatory and specified fields'),
(5543, 'Mandatory or specified fields only, dup check, no search'),
(5544, 'Mandatory or specified fields only, search and dup check'),
(5545, 'Mandatory or specified fields only, use patient validation Zend module'),
(5546, 'Manifest (Dry) Refraction'),
(5547, 'Manual'),
(5548, 'Manual Posting'),
(5549, 'Manual Processing Required'),
(5550, 'Manually retrieve description on Fee Sheet'),
(5551, 'Manually type into the New DX box above.'),
(5552, 'Manufacturer'),
(5553, 'Manx'),
(5554, 'Many code items have a lookup/hint.'),
(5555, 'Many companies block operations with USB ports on corporate computers'),
(5556, 'Many of the LOINC codes can be used for both tests and their results'),
(5557, 'Maori'),
(5558, 'Mar'),
(5559, 'Marathi'),
(5560, 'Marathi (Marathi)'),
(5561, 'Marathi (Marāṭhī)'),
(5562, 'March'),
(5563, 'Marginal Reflex Distance'),
(5564, 'Marital'),
(5565, 'Marital Status'),
(5566, 'Mark all as read'),
(5567, 'Mark as Billed'),
(5568, 'Mark as billed but skip billing'),
(5569, 'Mark as Cleared'),
(5570, 'Mark as not billed'),
(5571, 'Mark Message as Completed'),
(5572, 'Mark Note as Completed'),
(5573, 'Mark these reports as reviewed'),
(5574, 'Marked as cleared'),
(5575, 'Married'),
(5576, 'Marshallese'),
(5577, 'Mask'),
(5578, 'Mask for Invoice Numbers'),
(5579, 'Mask for Patient IDs'),
(5580, 'Mask for Product IDs'),
(5581, 'Mass Immunization Center'),
(5582, 'Match'),
(5583, 'Match case'),
(5584, 'Match Found'),
(5585, 'Match Patient'),
(5586, 'Matched Patient'),
(5587, 'Matching for Patient'),
(5588, 'MaternalAunt'),
(5589, 'MaternalCousin'),
(5590, 'MaternalGrandparent'),
(5591, 'MaternalGreatgrandparent'),
(5592, 'MaternalUncle'),
(5593, 'Matrix'),
(5594, 'max'),
(5595, 'Max'),
(5596, 'Max 255 characters'),
(5597, 'max file count reached'),
(5598, 'max file count reached - reload names below'),
(5599, 'Max Size'),
(5600, 'Maxillary Right:'),
(5601, 'Maximum Age'),
(5602, 'Maximum characters'),
(5603, 'Maximum Failed Login Attempts'),
(5604, 'Maximum Failed Login Attempts (0 for no maximum).'),
(5605, 'Maximum idle time in seconds before logout. Default is 7200 (2 hours).'),
(5606, 'Maximum number of times a Patient can be tested in a year'),
(5607, 'Maximum number of times a Patient can be tested in a year. Zero is no limit.'),
(5608, 'Maximum reasonable inventory, 0 if not applicable'),
(5609, 'Maximum Size'),
(5610, 'Maximum Size (entering 0 will allow any size)'),
(5611, 'Maximum size of thumbnail file'),
(5612, 'May'),
(5613, 'MBO '),
(5614, 'MC'),
(5615, 'mcg'),
(5616, 'MDM Document Category Name'),
(5617, 'Means none of last three passwords are allowed when changing a password.'),
(5618, 'Measure Blood Pressure'),
(5619, 'Measure Group Code'),
(5620, 'Measure INR'),
(5621, 'Measurement'),
(5622, 'MedEx automates Appointment Reminders and Recalls using phone calls, text messages and e-mails'),
(5623, 'MedEx Communication Service'),
(5624, 'MedEx needs a valid mobile number to send SMS messages...'),
(5625, 'MedEx Setup'),
(5626, 'Medial Canthi'),
(5627, 'Medial malleolus:'),
(5628, 'Medicaid'),
(5629, 'Medicaid Original Reference No.'),
(5630, 'Medical'),
(5631, 'Medical Abortion'),
(5632, 'Medical Administration'),
(5633, 'Medical Dashboard Help'),
(5634, 'Medical History'),
(5635, 'Medical Issue'),
(5636, 'Medical issue'),
(5637, 'Medical Issues'),
(5638, 'Medical prescription'),
(5639, 'Medical Problem'),
(5640, 'Medical problem'),
(5641, 'Medical Problem Issue List'),
(5642, 'Medical Problems'),
(5643, 'Medical Problems - will show the patient\'s medical issues, Issues > Medical Problems'),
(5644, 'Medical Record'),
(5645, 'Medical Record #'),
(5646, 'Medical Record Dashboard'),
(5647, 'Medical Records'),
(5648, 'Medical Records and History (write,addonly optional) (med)'),
(5649, 'Medical Records Sent'),
(5650, 'Medical Specialty'),
(5651, 'Medical Summary Given'),
(5652, 'Medical System'),
(5653, 'Medical Type'),
(5654, 'Medical/History (write,addonly optional)'),
(5655, 'Medical/History (write,addonly optional) (med)'),
(5656, 'Medicare Part B'),
(5657, 'Medicare Referrer Is Renderer'),
(5658, 'Medication'),
(5659, 'Medication Allergy List'),
(5660, 'Medication Issue List'),
(5661, 'Medication List'),
(5662, 'Medication Reconciliation Performed?'),
(5663, 'Medications'),
(5664, 'Medications - lists the medications under Issues > Medications. If eRx is enabled the medication list has to be entered on the eRx page'),
(5665, 'Medications Allergy List'),
(5666, 'Medications:'),
(5667, 'Medicine Units'),
(5668, 'Medium'),
(5669, 'MedlinePlus Connect'),
(5670, 'med{{medial}}'),
(5671, 'Member Association Statistics Report'),
(5672, 'Member Id'),
(5673, 'Memory Problems'),
(5674, 'Men'),
(5675, 'Men and Women'),
(5676, 'Men Only'),
(5677, 'Menarche'),
(5678, 'Menopause'),
(5679, 'Menstrual Flow'),
(5680, 'Menstrual Frequency'),
(5681, 'Mental Illness'),
(5682, 'Mental Status'),
(5683, 'Menu'),
(5684, 'Menu (menu)'),
(5685, 'Menu Text'),
(5686, 'Menus'),
(5687, 'Menus (menus)'),
(5688, 'Merge'),
(5689, 'Merge complete.'),
(5690, 'Merge Patients'),
(5691, 'Merge to any patient'),
(5692, 'Message'),
(5693, 'Message and Reminder Center'),
(5694, 'Message Center'),
(5695, 'Message Center Help'),
(5696, 'Message content is not plain text so it has been stored as a document.'),
(5697, 'Message from patient'),
(5698, 'Message Log'),
(5699, 'Message Sent'),
(5700, 'Message Status'),
(5701, 'Message Title'),
(5702, 'Message to patient'),
(5703, 'Message to Reviewer'),
(5704, 'Message type'),
(5705, 'MESSAGE:'),
(5706, 'Messages'),
(5707, 'Messages - due date'),
(5708, 'Messages Screen'),
(5709, 'Messages You have sent Today'),
(5710, 'Messages, Reminders'),
(5711, 'Messages, Reminders, Recalls'),
(5712, 'Messaging'),
(5713, 'Method'),
(5714, 'Method and Specific Product'),
(5715, 'Method Change at this Clinic'),
(5716, 'Method for sending outgoing email.'),
(5717, 'Method of Destruction'),
(5718, 'Mexican/MexAmer/Chicano'),
(5719, 'Mexico'),
(5720, 'MFA'),
(5721, 'MFA Authorization'),
(5722, 'MFA Manaagement'),
(5723, 'MFA Management'),
(5724, 'mg'),
(5725, 'mg/1cc'),
(5726, 'mg/2cc'),
(5727, 'mg/3cc'),
(5728, 'mg/4cc'),
(5729, 'mg/5cc'),
(5730, 'MG/DL'),
(5731, 'mid'),
(5732, 'Middle'),
(5733, 'Middle Name'),
(5734, 'Middle name'),
(5735, 'Midlevel Prescriber'),
(5736, 'Midlevel Prescriber DEA'),
(5737, 'Midlevel Prescriber First name'),
(5738, 'Midlevel Prescriber Last name'),
(5739, 'Midlevel Prescriber NPI'),
(5740, 'Midlevel Prescriber Prefix'),
(5741, 'Midlevel Prescriber UPIN'),
(5742, 'Mid{{Middle Distance Add}}'),
(5743, 'Mid{{middle Rx strength}}'),
(5744, 'Mid{{Middle segment in a trifocal glasses prescription}}'),
(5745, 'mid{{middle}}'),
(5746, 'Mien'),
(5747, 'Migrant or seasonal worker?'),
(5748, 'Migrant Seasonal'),
(5749, 'Migrant/Seasonal'),
(5750, 'Mil/CU.MM'),
(5751, 'Mild'),
(5752, 'Mild to moderate'),
(5753, 'Military Treatment Facility'),
(5754, 'MIME Type'),
(5755, 'MimeType'),
(5756, 'Min'),
(5757, 'min'),
(5758, 'Mini'),
(5759, 'Minimum Age'),
(5760, 'Minor joint strain +/- synovitis'),
(5761, 'minute'),
(5762, 'Minute'),
(5763, 'minutes'),
(5764, 'Minutes'),
(5765, 'Mirth IP'),
(5766, 'Misc'),
(5767, 'Misc Billing Options'),
(5768, 'Misc Billing Options for HCFA-1500'),
(5769, 'Misc Billing Options HCFA'),
(5770, 'Miscellaneous'),
(5771, 'Miscellaneous Billing Options for HCFA-1500'),
(5772, 'Missed'),
(5773, 'missing'),
(5774, 'Missing a required field'),
(5775, 'Missing a required field and will be highlighted'),
(5776, 'Missing Fee'),
(5777, 'Missing Identifying Code'),
(5778, 'Missing Insurance Payer Id'),
(5779, 'Missing Mods Only'),
(5780, 'Missing or Invalid'),
(5781, 'Missing PID.'),
(5782, 'Missing report date'),
(5783, 'Missing slash after payer in source for code '),
(5784, 'Missing Subscriber Policy Number or DOB'),
(5785, 'Missing Title'),
(5786, 'Mixed'),
(5787, 'mL'),
(5788, 'ml'),
(5789, 'MM/DD/YYYY'),
(5790, 'mm/hg'),
(5791, 'mmHg'),
(5792, 'MMR 1'),
(5793, 'MMR 2'),
(5794, 'mm{{millimeters}}'),
(5795, 'Mobile'),
(5796, 'Mobile Phone'),
(5797, 'Mobile phones'),
(5798, 'Mobile phones are ubiquitous and are generally easily accessible by any user'),
(5799, 'Mobile Unit'),
(5800, 'Mod'),
(5801, 'Mod Date'),
(5802, 'Mode - Do Not Show SQL Queries'),
(5803, 'Moderate'),
(5804, 'Moderate Priority'),
(5805, 'Moderate to severe'),
(5806, 'Moderate/Low Priority'),
(5807, 'Modern/images'),
(5808, 'Modifier'),
(5809, 'Modifier 22: Increased Procedural Services: When the work required to provide a service is substantially greater than typically required, it may be identified by adding modifier 22 to the usual procedure code.'),
(5810, 'Modifier 24: Unrelated Evaluation and Management Service by the Same Physician During a Postoperative Period'),
(5811, 'Modifier 25: Significant, separately identifiable evaluation and management (E/M) service by the same physician on the day of a procedure or other service'),
(5812, 'Modifier 57: Indicates an Evaluation and Management (E/M) service resulted in the initial decision to perform surgery either the day before a major surgery (90 day global) or the day of a major surgery.'),
(5813, 'Modifier(s)'),
(5814, 'Modifiers'),
(5815, 'Modify'),
(5816, 'Modify Date'),
(5817, 'Modify Patient Form'),
(5818, 'Modify Payments'),
(5819, 'Modifying'),
(5820, 'ModLength'),
(5821, 'Module'),
(5822, 'Module Directory not found'),
(5823, 'Module Installer'),
(5824, 'Module Name'),
(5825, 'Module name already exist'),
(5826, 'Modules'),
(5827, 'Modules (modle)'),
(5828, 'Mon'),
(5829, 'Mon thru Fri'),
(5830, 'Mon, Wed &amp; Fri'),
(5831, 'Monday'),
(5832, 'Mongolian'),
(5833, 'Monocular Pupillary Diameter - Distance'),
(5834, 'Monocular Pupillary Diameter - Near'),
(5835, 'month'),
(5836, 'Month'),
(5837, 'Month View'),
(5838, 'Month(s)'),
(5839, 'Monthly Income'),
(5840, 'months'),
(5841, 'Months'),
(5842, 'months ago'),
(5843, 'Mood/Affect Nml{{Mood and affect normal}}'),
(5844, 'More information about Clinical Decision Rule can be found here'),
(5845, 'More information about Issues can be found here'),
(5846, 'More information about what phiMail is and how to set it up is available here'),
(5847, 'More information available at the openEMR MedEx wiki page'),
(5848, 'More information on how to edit this form and other such forms can be found here'),
(5849, 'More information on the use of phiMail messages is available here'),
(5850, 'More options'),
(5851, 'More than'),
(5852, 'More than 100 records found. Please narrow your search criteria.'),
(5853, 'More than 50 results, please make your search more specific.'),
(5854, 'More than one appointment was found'),
(5855, 'Moreover there is a recurring cost incurred in sending the text messages'),
(5856, 'Most activities in relation to a patient are based on an encounter'),
(5857, 'Most column headers can be clicked to change sort order'),
(5858, 'Most often this is due to a Username/Password mismatch'),
(5859, 'Most recent from'),
(5860, 'Most recent lab data:'),
(5861, 'Most recent visit'),
(5862, 'Most recent vitals from:'),
(5863, 'Mother'),
(5864, 'Mother\'s Name'),
(5865, 'Mothers History'),
(5866, 'Mothers Name'),
(5867, 'Motility'),
(5868, 'Mouth'),
(5869, 'Move'),
(5870, 'Move Document to Category:'),
(5871, 'Move Down'),
(5872, 'Move failed!'),
(5873, 'Move the individual items from \'Active\' to \'Inactive\' or vice-versa by selecting the items and pressing the relevant button with the double chevron.'),
(5874, 'Move to Patient'),
(5875, 'Move to...'),
(5876, 'Move Up'),
(5877, 'Moving'),
(5878, 'Mo{{Monday}}'),
(5879, 'MPD-D{{abbreviation for Monocular Pupillary Diameter - Distance}}'),
(5880, 'MPD-N{{abbreviation for Monocular Pupillary Diameter - Near}}'),
(5881, 'MR (Dry)'),
(5882, 'Mr.'),
(5883, 'MRD{{marginal reflex distance}}'),
(5884, 'MRN (pid)'),
(5885, 'MRNear{{Manifest Near Acuity}}'),
(5886, 'MRNear{{manifest refraction near}}'),
(5887, 'Mrs.'),
(5888, 'MR{{Manifest Refraction}}'),
(5889, 'Ms.'),
(5890, 'MSH-11'),
(5891, 'MSH-3.1'),
(5892, 'MSH-4.1'),
(5893, 'MSH-5.1'),
(5894, 'MSH-6.1'),
(5895, 'MSH.8 message type is not supported'),
(5896, 'MSH.8 message type is not valid'),
(5897, 'MSP Code'),
(5898, 'MSP Remit Codes'),
(5899, 'Multi Factor Authorization - MFA has been increasingly used to authenticate a user without making the process of authentication too onerous'),
(5900, 'Multi Factor Authorization Help'),
(5901, 'Multi Language Tool'),
(5902, 'Multi-select desired DX(s) and click the'),
(5903, 'Multiple areas'),
(5904, 'Multiple DataBase'),
(5905, 'Multiple files can be uploaded at one time by selecting them using CTRL+Click or SHIFT+Click.'),
(5906, 'Multiple Lots'),
(5907, 'Multiple modifiers can be separated by colons or spaces, maximum of 4 (M1:M2:M3:M4)'),
(5908, 'Multiple Select List'),
(5909, 'Multipledb'),
(5910, 'Multipledb (multipledb)'),
(5911, 'Multiracial'),
(5912, 'Murmur:'),
(5913, 'Musc Ache'),
(5914, 'Musc Aches'),
(5915, 'Musc Redness'),
(5916, 'Musc Stiffness'),
(5917, 'Musc Swelling'),
(5918, 'Musc Warm'),
(5919, 'Muscle'),
(5920, 'Muscle injury'),
(5921, 'Musculoskeletal'),
(5922, 'Musculo{{musculoskeletal}}'),
(5923, 'Must be current email address on file.'),
(5924, 'Must be empty if SMTP authentication is not used.'),
(5925, 'Must be future date'),
(5926, 'Must choose at least one day!'),
(5927, 'Mutually Defined'),
(5928, 'MVA'),
(5929, 'MVX Code'),
(5930, 'My default facility'),
(5931, 'My Default Values'),
(5932, 'My Health'),
(5933, 'My Messages'),
(5934, 'My Term'),
(5935, 'Myself'),
(5936, 'M{{Monday}}'),
(5937, 'Māori'),
(5938, 'N.B.{{Nota bene}}'),
(5939, 'N/A'),
(5940, 'n/a'),
(5941, 'N/A{{not applicable}}'),
(5942, 'Name'),
(5943, 'NAME'),
(5944, 'Name (click for more)'),
(5945, 'Name - Select a provider name from the drop-down list'),
(5946, 'Name 1'),
(5947, 'Name 2'),
(5948, 'Name and Title of Immunization Administrator'),
(5949, 'Name for this Category, Procedure or Result'),
(5950, 'Name in EMR'),
(5951, 'Name must be like codetype_code_language.pdf, for example icd9_274.11_en.pdf'),
(5952, 'Name of Events'),
(5953, 'Name of insurance company'),
(5954, 'Name of Provider'),
(5955, 'Name of the sender for patient reminders.'),
(5956, 'Name of the Surgeon'),
(5957, 'Name of zend template for html print'),
(5958, 'Name of zend template for html print, possible to add custom template in the PrescriptionTemplate module'),
(5959, 'Name of zend template for pdf export'),
(5960, 'Name of zend template for pdf export, possible to add custom template in the PrescriptionTemplate module'),
(5961, 'Name on Card'),
(5962, 'Name Translation'),
(5963, 'Name/Value'),
(5964, 'Name:'),
(5965, 'Names'),
(5966, 'Namespace'),
(5967, 'Narcotic drugs imported'),
(5968, 'NARES:'),
(5969, 'NARES: Normal Right'),
(5970, 'Narrative'),
(5971, 'nasal'),
(5972, 'Nasal mucosa pink, septum midline'),
(5973, 'Nation Notes'),
(5974, 'Nation Notes (nationnotes)'),
(5975, 'Nation Notes (nn_configure)'),
(5976, 'Nation Notes Configure'),
(5977, 'Nation Notes Replace Buttons'),
(5978, 'Nationality'),
(5979, 'NationNotes'),
(5980, 'Native Data Loads'),
(5981, 'Native Hawaiian or Other Pacific Islander'),
(5982, 'Natural Child'),
(5983, 'Natural child'),
(5984, 'Natural Parent'),
(5985, 'Natural Sibling'),
(5986, 'Nauru'),
(5987, 'Nausea'),
(5988, 'Nav Bar'),
(5989, 'Navajo, Navaho'),
(5990, 'Navigation'),
(5991, 'Navigation area includes encounter forms'),
(5992, 'Navigation area uses full height of frameset'),
(5993, 'Navigation Area Visit Forms'),
(5994, 'Navigation Area Width'),
(5995, 'Navigation Area Width for Frames'),
(5996, 'Navigation menu consists of pairs of radio buttons'),
(5997, 'Navigation menu is a tree view'),
(5998, 'Navigation uses a sliding menu'),
(5999, 'NCI CONCEPT ID'),
(6000, 'NCOM{{Neuro comments}}'),
(6001, 'NCPDP'),
(6002, 'NDC'),
(6003, 'NDC Data'),
(6004, 'NDC Number'),
(6005, 'Ndonga'),
(6006, 'Near'),
(6007, 'Near Acuity AutoRefraction'),
(6008, 'Near Acuity Manifest Refraction'),
(6009, 'Near Acuity with Autorefraction'),
(6010, 'Near Acuity with Correction'),
(6011, 'Near Acuity with Manifest (Dry) refraction'),
(6012, 'Near Acuity without Correction'),
(6013, 'Near Point of Accomodation'),
(6014, 'Near Point of Convergence'),
(6015, 'Necessary Medical Equipment'),
(6016, 'Neck'),
(6017, 'Neck Problems'),
(6018, 'Neck supple'),
(6019, 'Need more than one drug.'),
(6020, 'Need to enter a description'),
(6021, 'Need to enter a Return Value'),
(6022, 'Need to enter identifier'),
(6023, 'Need to enter title'),
(6024, 'need to logout/login after changing these settings'),
(6025, 'Needs a Smartphone'),
(6026, 'Needs Auth'),
(6027, 'Needs Justify'),
(6028, 'Needs secondary billing'),
(6029, 'Negative'),
(6030, 'Negative payments not accepted'),
(6031, 'Negatives'),
(6032, 'Neg{{negative}}'),
(6033, 'Neighbor'),
(6034, 'Neo 10%'),
(6035, 'Neo 2.5%'),
(6036, 'Nepali'),
(6037, 'Nerve injury'),
(6038, 'Network Indicator'),
(6039, 'Neural condition / nerve damage'),
(6040, 'Neuro'),
(6041, 'Neuro Numbness'),
(6042, 'Neuro Weakness'),
(6043, 'Neuro-physiology'),
(6044, 'Neuro/Phys Exam Default Values'),
(6045, 'Neurologic'),
(6046, 'Neurology'),
(6047, 'Neuro{{neurologic}}'),
(6048, 'NEURO{{Neurology}}'),
(6049, 'Never'),
(6050, 'Never Alcohol'),
(6051, 'Never smoker'),
(6052, 'New'),
(6053, 'New =>'),
(6054, 'New Acceptors'),
(6055, 'New Alerts'),
(6056, 'New Allergy'),
(6057, 'New amendment request'),
(6058, 'New Appointment'),
(6059, 'New Categories'),
(6060, 'New Category'),
(6061, 'New Clients'),
(6062, 'New Consultation'),
(6063, 'New Crop'),
(6064, 'New Definition set added'),
(6065, 'New Document'),
(6066, 'New Documents'),
(6067, 'New Due Clinical Reminders'),
(6068, 'New Dx{{new diagnosis}}'),
(6069, 'New Encounter'),
(6070, 'New encounter created with id'),
(6071, 'New Encounter Form'),
(6072, 'New encounters not authorized'),
(6073, 'New Enctr'),
(6074, 'New Facility Information'),
(6075, 'New file'),
(6076, 'New Files'),
(6077, 'New form validation'),
(6078, 'New Group'),
(6079, 'New group encounter created with id'),
(6080, 'New Group Encounter Form'),
(6081, 'New Group Information'),
(6082, 'New group was saved successfully'),
(6083, 'New Immunization Record'),
(6084, 'New in ACL Ver 4'),
(6085, 'New in ACL Ver 5'),
(6086, 'New in ACL Ver 6'),
(6087, 'New in ACL Ver 7'),
(6088, 'New in ACL Ver 8'),
(6089, 'New in openEMR ver 5.0.2 '),
(6090, 'New Inj/Status'),
(6091, 'New Items (see above for details)'),
(6092, 'New Layout'),
(6093, 'New Limit of Events'),
(6094, 'New List'),
(6095, 'New Message'),
(6096, 'new messages'),
(6097, 'New Note'),
(6098, 'New Orders'),
(6099, 'New Paragraph'),
(6100, 'New Password'),
(6101, 'New Patient'),
(6102, 'NEW PATIENT'),
(6103, 'New Patient Encounter'),
(6104, 'New Patient Form'),
(6105, 'New Patient ID'),
(6106, 'New patient registration received from patient portal. Reminder to check for possible new appointment'),
(6107, 'New Patients'),
(6108, 'New Payment'),
(6109, 'New Portal Login'),
(6110, 'New Pt'),
(6111, 'New Recall'),
(6112, 'New results from Lab Exchange'),
(6113, 'New Search'),
(6114, 'New Submissions'),
(6115, 'New to openEMR 5.0.2'),
(6116, 'New User'),
(6117, 'New Value'),
(6118, 'New Visit'),
(6119, 'New/Search'),
(6120, 'NewCrop Account Status'),
(6121, 'NewCrop Admin'),
(6122, 'NewCrop call failed'),
(6123, 'NewCrop Doctor'),
(6124, 'NewCrop eRx Account Id'),
(6125, 'NewCrop eRx Account Name'),
(6126, 'NewCrop eRx Debug Setting'),
(6127, 'NewCrop eRx Default Patient Country'),
(6128, 'NewCrop eRx Name'),
(6129, 'NewCrop eRx Partner Name'),
(6130, 'NewCrop eRx Password'),
(6131, 'NewCrop eRX Role'),
(6132, 'NewCrop eRx Role'),
(6133, 'NewCrop eRx Site Address'),
(6134, 'NewCrop eRx SOAP Request Time-To-Live for Allergies'),
(6135, 'NewCrop eRx SOAP Request Time-To-Live for Medications'),
(6136, 'NewCrop eRx User Role'),
(6137, 'NewCrop eRx User Role * invalid selection *'),
(6138, 'NewCrop eRx Web Service Address'),
(6139, 'NewCrop Manager'),
(6140, 'NewCrop MedEntry'),
(6141, 'NewCrop Midlevel Prescriber'),
(6142, 'NewCrop Nurse'),
(6143, 'NewCrop Supervising Doctor'),
(6144, 'Newer'),
(6145, 'NewRx'),
(6146, 'Newspaper'),
(6147, 'Next'),
(6148, 'Next Appointment Date'),
(6149, 'Next Day'),
(6150, 'Next Month'),
(6151, 'Next month (hold for menu)'),
(6152, 'Next of Kin Relationship'),
(6153, 'Next Scheduled Run'),
(6154, 'Next Visit'),
(6155, 'Next Visit Orders'),
(6156, 'Next Week'),
(6157, 'Next year (hold for menu)'),
(6158, 'Nick Name'),
(6159, 'Nickname'),
(6160, 'Niece/Nephew'),
(6161, 'Night Sweats'),
(6162, 'NKDA{{No known drug allergies}}'),
(6163, 'Nl ext genitalia, vag mucosa, cervix'),
(6164, 'No'),
(6165, 'NO'),
(6166, 'no'),
(6167, 'No access'),
(6168, 'No active patient reminders.'),
(6169, 'No adenopathy (2 areas required)'),
(6170, 'No adjustment reason type found for'),
(6171, 'No adnexal tenderness/masses'),
(6172, 'No alert'),
(6173, 'No amendment requests available'),
(6174, 'No Appointments'),
(6175, 'No archive files present'),
(6176, 'No Archives'),
(6177, 'No audit log tampering detected in the selected date range.'),
(6178, 'No automatic refresh'),
(6179, 'No billing system is currently active'),
(6180, 'No Bills Found to Include in OFX Export'),
(6181, 'No Bills Found to Include in OFX Export<br>'),
(6182, 'No Changes Detected'),
(6183, 'No code was specified!'),
(6184, 'No Configuration Defined for this Module'),
(6185, 'No data available in table'),
(6186, 'No Data to Process'),
(6187, 'No Diagnosis'),
(6188, 'no diagnosis was auto-generated from the clinical findings.'),
(6189, 'No Documents'),
(6190, 'No Documents Found'),
(6191, 'No Encounter could be created'),
(6192, 'No encounter...'),
(6193, 'No end date'),
(6194, 'No entries found, use the form below to add an entry.'),
(6195, 'No errors found'),
(6196, 'No Events'),
(6197, 'No Fax Number Saved For The Selected Organization'),
(6198, 'No files staged for installation'),
(6199, 'No group was selected'),
(6200, 'No hernia'),
(6201, 'No Hooks Available in this Module'),
(6202, 'No Hooks enabled for this Module'),
(6203, 'No injury/illness'),
(6204, 'No Insurance Companies Found'),
(6205, 'No interactions found'),
(6206, 'No Issues'),
(6207, 'No issues in this encounter.'),
(6208, 'No items under selected category'),
(6209, 'No items were selected!'),
(6210, 'No Known Allergies'),
(6211, 'No Known Clinical Instructions'),
(6212, 'No Known Encounters'),
(6213, 'No Known Immunizations'),
(6214, 'No Known Lab Results'),
(6215, 'No Known Medications'),
(6216, 'No Known Plan of Care'),
(6217, 'No Known Problems'),
(6218, 'No Known Procedures'),
(6219, 'No Known Referrals'),
(6220, 'No Known Social Functional Status'),
(6221, 'No Known Social History'),
(6222, 'No Known Vitals'),
(6223, 'No lab data documented.'),
(6224, 'No log file exist for the selected date'),
(6225, 'No logging'),
(6226, 'No logs older than 7 days'),
(6227, 'No masses, tenderness'),
(6228, 'No match Patient record found for the given Re Idenitification code'),
(6229, 'No matches for'),
(6230, 'No matches found. Try search again.'),
(6231, 'No matches were found.'),
(6232, 'No matches were found. Create the new patient now?'),
(6233, 'No matching records found'),
(6234, 'No member fields found for'),
(6235, 'No method enabled'),
(6236, 'No Name'),
(6237, 'No new messages on'),
(6238, 'No new results found'),
(6239, 'No notes'),
(6240, 'No ogrganomegoly'),
(6241, 'No openings were found for this period.'),
(6242, 'No Order found, please enter procedure order first'),
(6243, 'No organomegaly'),
(6244, 'No other phone numbers listed'),
(6245, 'No parameters selected'),
(6246, 'No Partners Found'),
(6247, 'No Patient record found for given Selection criteria'),
(6248, 'No Patient record found for the given Re Identification code'),
(6249, 'No peripheral edema'),
(6250, 'No Pharmacies Found'),
(6251, 'No Prescriptions Found'),
(6252, 'No prescriptions selected'),
(6253, 'No presenting illness/injury'),
(6254, 'No previous entries.'),
(6255, 'No Primary Business Entity selected in facility list'),
(6256, 'No prior encounters.'),
(6257, 'No procedures in this encounter.'),
(6258, 'No provider was matched'),
(6259, 'No Providers Found'),
(6260, 'No rash or abnormal lesions'),
(6261, 'No Recall'),
(6262, 'No records available'),
(6263, 'No records found'),
(6264, 'No records found.'),
(6265, 'No records found. Please expand your search criteria.'),
(6266, 'No reminder/recall'),
(6267, 'No Reminders'),
(6268, 'No Result Found, for the above search criteria.'),
(6269, 'No Results'),
(6270, 'No results found'),
(6271, 'No results found for'),
(6272, 'No Results Found For Search'),
(6273, 'No results found, please try again.'),
(6274, 'No results, please tray again.'),
(6275, 'No results, please try again.'),
(6276, 'No Settings avaliable in this module'),
(6277, 'No Show'),
(6278, 'No show'),
(6279, 'no signature in document'),
(6280, 'No signatures on file'),
(6281, 'No Sinus Tenderness:'),
(6282, 'No skin dimpling or breast nodules'),
(6283, 'NO SUCH CONTEXT NAME'),
(6284, 'No table selected! Select a table.'),
(6285, 'No testicular tenderness, masses'),
(6286, 'No Thanks'),
(6287, 'No thrills or heaves'),
(6288, 'No track selected'),
(6289, 'No tracks have been documented.'),
(6290, 'No version of Internet Explorer supports U2F'),
(6291, 'No visit'),
(6292, 'No vitals have been documented.'),
(6293, 'No, Cancel'),
(6294, 'No-fault Insurance including Auto is Primary'),
(6295, 'No:'),
(6296, 'Nocturia'),
(6297, 'Non Paid'),
(6298, 'Non Reported Report'),
(6299, 'Non specific injury'),
(6300, 'Non-electronic'),
(6301, 'Non-Insulin Dependent Diabetes'),
(6302, 'Non-Insured'),
(6303, 'Non-residential Substance Abuse Treatment Facility'),
(6304, 'Non-SRH Medical'),
(6305, 'Non-SRH Non-Medical'),
(6306, 'None'),
(6307, 'none'),
(6308, 'None defined'),
(6309, 'None documented'),
(6310, 'None have been documented'),
(6311, 'None of the above'),
(6312, 'None of the Top Distribution Row Can be Completly Blank.'),
(6313, 'None Selected'),
(6314, 'None{{Encounter}}'),
(6315, 'None{{Patient}}'),
(6316, 'Noninsulin Dependent Diabetes'),
(6317, 'Nor'),
(6318, 'Normal'),
(6319, 'Normal (normal)'),
(6320, 'Normal BL'),
(6321, 'Normal Cardiac Exam:'),
(6322, 'Normal Cardiac Exam: '),
(6323, 'Normal Lung Exam:'),
(6324, 'Normal Lung Exam: '),
(6325, 'Normal Office Visit'),
(6326, 'Normal Oropharynx:'),
(6327, 'Normal Right'),
(6328, 'Normal Right:'),
(6329, 'Normal View'),
(6330, 'normal:'),
(6331, 'Normally this should be checked. Not related to access control.'),
(6332, 'North Ndebele'),
(6333, 'Northern Sami'),
(6334, 'Norwegian'),
(6335, 'Norwegian Bokmal'),
(6336, 'Norwegian Bokmål'),
(6337, 'Norwegian Nynorsk'),
(6338, 'Nose'),
(6339, 'Nosebleed'),
(6340, 'not a letter or number'),
(6341, 'Not active'),
(6342, 'Not Administered'),
(6343, 'Not all fields are required for all codes or code types.'),
(6344, 'Not all old browsers support U2F. Using the latest versions of modern browsers - Chrome, Firefox, Safari, Edge and Opera should suffice'),
(6345, 'Not Allowed'),
(6346, 'Not allowed to delete the Administrators group'),
(6347, 'Not Allowed to Edit'),
(6348, 'Not allowed to inactivate all security objects'),
(6349, 'Not allowed to inactivate anything from the Administrators ACL'),
(6350, 'Not allowed to remove the admin user from the Administrators group'),
(6351, 'Not allowed to remove this user from the Administrators group'),
(6352, 'Not Applicable'),
(6353, 'Not authorised to access PostCalendar module'),
(6354, 'Not Authorized'),
(6355, 'Not authorized'),
(6356, 'Not authorized for this squad!'),
(6357, 'Not authorized for this squad.'),
(6358, 'Not authorized to manage users!'),
(6359, 'Not authorized to sign results'),
(6360, 'Not authorized to view this encounter'),
(6361, 'Not authorized!'),
(6362, 'Not Available'),
(6363, 'Not Billed'),
(6364, 'Not billed'),
(6365, 'Not Checked'),
(6366, 'Not checked out'),
(6367, 'Not Coded'),
(6368, 'Not documented'),
(6369, 'Not Due'),
(6370, 'Not Esigned'),
(6371, 'Not Examined'),
(6372, 'Not Examined:'),
(6373, 'Not Examined: '),
(6374, 'Not For Diagnostic Use'),
(6375, 'not found'),
(6376, 'Not Found'),
(6377, 'not found!'),
(6378, 'Not Hispanic or Latino'),
(6379, 'Not installed'),
(6380, 'Not Installed'),
(6381, 'Not Possible'),
(6382, 'Not seen since'),
(6383, 'Not sent'),
(6384, 'Not Sent Yet'),
(6385, 'Not Specified'),
(6386, 'Not Specified.'),
(6387, 'Not VFC eligible'),
(6388, 'Not yet implemented.'),
(6389, 'Note'),
(6390, 'NOTE'),
(6391, 'Note Codes'),
(6392, 'Note it will take 5-10 minutes to fully process after you click Install'),
(6393, 'Note it will take 5-10 minutes to fully process after you click Upgrade'),
(6394, 'Note that Audit Logging needs to be enabled above'),
(6395, 'Note that the pop-up form heading will now read Enter Details for Custom Favorite Group'),
(6396, 'Note that the pop-up form heading will now read Enter Details for Discrete Results'),
(6397, 'Note that the pop-up form heading will now read Enter Details for Individual Procedures'),
(6398, 'Note there is no \'Save\' button.'),
(6399, 'Note this refers to the Continuity of Care Record (CCR) or Continuity of Care Document (CCD) as the case may be'),
(6400, 'Note Type'),
(6401, 'Note: 12:00 noon is PM, not AM'),
(6402, 'NOTE: Importing external data can take more than an hour depending on your hardware configuration. For example, one of the RxNorm data tables contain in excess of 6 million rows.'),
(6403, 'NOTE: Only the Biannual International Snomed Release is currently supported'),
(6404, 'NOTE: Only the Biannual International Snomed Releases and the US Snomed Releases are currently supported'),
(6405, 'NOTE: Only the full monthly RxNorm release is currently supported'),
(6406, 'NOTE: Only the XML formats and Eligible Professionals valuesets supported'),
(6407, 'NOTE: The import can take up to several hours'),
(6408, 'Note: This code has not been authorized.'),
(6409, 'Note: This code was not entered by an authorized user. Only authorized codes may be uploaded to the Open Medical Billing Network for processing. If you wish to upload these codes, please select an authorized user here.'),
(6410, 'Note: This copay was entered against billing that has not been authorized. Please review status.'),
(6411, 'Note: this is not an email address'),
(6412, 'NOTE: Uploading files with duplicate names will cause the files to be automatically renamed (for example, file.jpg will become file.1.jpg). Filenames are considered unique per patient, not per category.'),
(6413, 'NOTE: Uploading files with duplicate names will cause the files to be automatically renamed. For example \'<i>file.jpg</i>\' will become \'<i>file.jpg.1</i>\'. Filenames are considered unique per patient, not per category. '),
(6414, 'Notes'),
(6415, 'NOTES'),
(6416, 'Notes - A short description that will show up as a tooltip'),
(6417, 'Notes - any encounters (write,addonly optional)'),
(6418, 'Notes - any encounters (write,addonly optional) (notes_a)'),
(6419, 'Notes - my encounters (write,addonly optional)'),
(6420, 'Notes - my encounters (write,addonly optional) (notes)'),
(6421, 'Notes by'),
(6422, 'Notes not authorized'),
(6423, 'Nothing found - sorry'),
(6424, 'Nothing Pending for Approval'),
(6425, 'Nothing Recorded'),
(6426, 'Nothing returned to report'),
(6427, 'Nothing to display'),
(6428, 'Nothing to import for Allergy'),
(6429, 'Nothing to import for Prescription'),
(6430, 'Nothing to Post! Please review entries or use Cancel to exit transaction'),
(6431, 'Nothing To Report'),
(6432, 'Nothing to show'),
(6433, 'Nothing was selected'),
(6434, 'Notice'),
(6435, 'Notice how the Top Group entry that was initially created called Serum Chemistry now has a blue + sign before its name indicating the presence of descendants or children to this entry'),
(6436, 'Notice Received'),
(6437, 'NOTICE:: PostCalendar Submission/Modification'),
(6438, 'Notification'),
(6439, 'Notification Email Address'),
(6440, 'Notification FAILED'),
(6441, 'Notification FAILED: Not Portal Authorized'),
(6442, 'Notification sent to'),
(6443, 'Notification Settings'),
(6444, 'Notifications'),
(6445, 'Notify Admin About Event Submission/Modification?'),
(6446, 'Notify Patient'),
(6447, 'Notify via Patient Portal'),
(6448, 'Nov'),
(6449, 'November'),
(6450, 'Now is the time to check and adjust the settings in openEMR for default units, sites, etc., refer to the help file in Procedures > Providers'),
(6451, 'Now posting for'),
(6452, 'Now posting for:'),
(6453, 'Now printing'),
(6454, 'Now printing $stmt_count statements and updating encounters.'),
(6455, 'Now printing $stmt_count statements and updating invoices.'),
(6456, 'Now printing $stmt_count statements; encounters will not be updated.'),
(6457, 'Now printing $stmt_count statements; invoices will not be updated.'),
(6458, 'Now when you bring up the Select Codes pop-up you will see all the ICD10 codes listed'),
(6459, 'Now when you bring up the Select Diagnosis Codes pop-up you will see all the ICD10 codes listed'),
(6460, 'NPA{{near point of accomodation}}'),
(6461, 'NPC{{near point of convergence}}'),
(6462, 'NPI'),
(6463, 'NPI - Enter the Provider\'s unique 10-digit National Provider Identifier or NPI identification number'),
(6464, 'NQF'),
(6465, 'Number'),
(6466, 'Number labs'),
(6467, 'Number of Appointments on Statement'),
(6468, 'Number of Appointments to display in the Group Summary'),
(6469, 'Number of Appointments to display in the Onsite Patient Portal'),
(6470, 'Number of Appointments to display in the Patient Summary'),
(6471, 'Number of columns in year view.'),
(6472, 'Number of days before showing fifth account message'),
(6473, 'Number of days before showing first account message'),
(6474, 'Number of days before showing first account message.'),
(6475, 'Number of days before showing fourth account message'),
(6476, 'Number of days before showing second account message'),
(6477, 'Number of days before showing third account message'),
(6478, 'Number of days that the client certificate is valid.'),
(6479, 'Number of days to search from the start date'),
(6480, 'Number of digits after decimal point for currency, usually 0 or 2.'),
(6481, 'Number of encounters to display per page.'),
(6482, 'Number of Excluded Appointments to display in the Tooltip'),
(6483, 'Number of games or events missed, if any'),
(6484, 'Number of hours in advance to send email notifications.'),
(6485, 'Number of hours in advance to send Phone notification.'),
(6486, 'Number of hours in advance to send SMS notifications.'),
(6487, 'Number of Messages Displayed in Patient Summary'),
(6488, 'Number of Minutes to display completed checkouts'),
(6489, 'Number of Minutes to display completed checkouts. Zero is continuous display'),
(6490, 'Number of past history columns'),
(6491, 'Number of patients to display per page in the patient list.'),
(6492, 'Numbness'),
(6493, 'Numerator'),
(6494, 'Numeric display order'),
(6495, 'Nuosu'),
(6496, 'Nursing Facility'),
(6497, 'Nutrition'),
(6498, 'Nutritional'),
(6499, 'O.A.F.V.'),
(6500, 'O2 Sat'),
(6501, 'Obesity I'),
(6502, 'Obesity II'),
(6503, 'Obesity III'),
(6504, 'Objective'),
(6505, 'Obligatory participation'),
(6506, 'Observation'),
(6507, 'Observation Criteria'),
(6508, 'Observation Criteria Value'),
(6509, 'Observation Form'),
(6510, 'Observation Results'),
(6511, 'Observation Results in Immunization'),
(6512, 'Occitan'),
(6513, 'Occupation'),
(6514, 'Occupational physician'),
(6515, 'occurred while uploading file named'),
(6516, 'Occurrence'),
(6517, 'Oct'),
(6518, 'October'),
(6519, 'OD'),
(6520, 'OD{{right eye}}'),
(6521, 'oeFHIR'),
(6522, 'of'),
(6523, 'of quantity'),
(6524, 'of tablets'),
(6525, 'of the month every'),
(6526, 'Ofc Notes'),
(6527, 'Off'),
(6528, 'Off Campus-Outpatient Hospital'),
(6529, 'Off: No Service.'),
(6530, 'Office'),
(6531, 'Office Announcements'),
(6532, 'Office Note'),
(6533, 'Office Notes'),
(6534, 'Office Visit'),
(6535, 'Official Clinical Quality Measures (CQM) Measure Groups'),
(6536, 'Offsite Https link for the Patient Portal.'),
(6537, 'Offsite Https link for the Patient Portal.(Patient Link)'),
(6538, 'Offsite Patient Portal Password'),
(6539, 'Offsite Patient Portal Password(Put Blank If not Registered).'),
(6540, 'Offsite Patient Portal Provider ID'),
(6541, 'Offsite Patient Portal Provider ID(Put Blank If not Registered).'),
(6542, 'Offsite Patient Portal Site Address'),
(6543, 'Offsite Patient Portal Site Address (Patient Link)'),
(6544, 'Offsite Patient Portal Username'),
(6545, 'Offsite Patient Portal Username(Put Blank If not Registered).'),
(6546, 'Offsite Portal web Service Failed'),
(6547, 'Offspring'),
(6548, 'Offspring History'),
(6549, 'Oh Snap!'),
(6550, 'OID'),
(6551, 'ointment'),
(6552, 'Ojibwe, Ojibwa'),
(6553, 'OK'),
(6554, 'OK to close this other popup window?'),
(6555, 'OK to link the GCAC issue dated'),
(6556, 'Old'),
(6557, 'Old Church Slavonic, Church Slavonic, Old Bulgarian'),
(6558, 'Old Clients'),
(6559, 'Old fracture non / malunion'),
(6560, 'Old style layout with no left menu'),
(6561, 'Old-style static form without search or duplication check'),
(6562, 'Older'),
(6563, 'Older than'),
(6564, 'Omit'),
(6565, 'Omit circumferences'),
(6566, 'Omit employer information in patient demographics'),
(6567, 'Omit Employers'),
(6568, 'Omit form, route and interval which then become part of dosage'),
(6569, 'Omit insurance and some other things from the demographics form'),
(6570, 'Omit internal users?'),
(6571, 'Omit method of payment from the co-pay panel'),
(6572, 'omit to autoassign'),
(6573, 'On'),
(6574, 'on'),
(6575, 'on file email'),
(6576, 'On first page'),
(6577, 'On Hand'),
(6578, 'On mobile devices tap once on the label to reveal the help icon and tap on the icon to show the help section'),
(6579, 'On Order'),
(6580, 'On Site'),
(6581, 'On the other hand if you click register but do not capture the QR code with the authenticator app you will not be able to login'),
(6582, 'On these lines the Code column will be blank'),
(6583, 'On this date there is a holiday, use it anyway?'),
(6584, 'On: HAPI FHIR.'),
(6585, 'On: Smart on FHIR.'),
(6586, 'Once a rule is setup it can be enabled for a particular patient'),
(6587, 'Once a Transaction is saved it will appear on the Transaction page'),
(6588, 'Once an appointment is scheduled the name automatically drops off the recall board'),
(6589, 'Once an appointment is scheduled the recall will drop off the Recall Board'),
(6590, 'Once completed, view and store this encounter as a PDF file'),
(6591, 'Once saved the entity for a Custom Favorite Group cannot be changed. If you need to change the entity you have to delete this entry and create a new one'),
(6592, 'Once the app captures the QR code it will show the OpenEMR user name in the app'),
(6593, 'Once the Primary Business Facility is set, changing the facility id will affect NewCrop ePrescription.'),
(6594, 'Once the Primary Business Facility is set, it should not be changed. Changing the facility will affect the working in NewCrop ePrescription.'),
(6595, 'Once this feature is enabled you will be required to type in the 6 digit key at each login'),
(6596, 'Once this is done the shared secret key that is unique for each user should only exist in OpenEMR and on the user\'s authenticator app'),
(6597, 'Once this step is completed you can proceed to next step - to configure the tests that can be ordered from the system'),
(6598, 'Once you change your password, you will have to re-login.'),
(6599, 'Once you select a justification code for the first CPT line all subsequent CPT code lines will have the same justification. Can be manually altered later if so desired'),
(6600, 'Oncology: Medical and Radiation – Pain Intensity Quantified (CQM)'),
(6601, 'One Day Ago'),
(6602, 'One Day Ahead'),
(6603, 'One Encounter Per Day'),
(6604, 'One Month Ago'),
(6605, 'One Month Ahead'),
(6606, 'One or more transactions failed'),
(6607, 'One such lab uses 905 for Uric Acid and in our example we will enter that number in the box'),
(6608, 'One Week Ahead'),
(6609, 'One Year Ago'),
(6610, 'One Year Ahead'),
(6611, 'One-time password or OTP is a commonly used strategy used to provide a unique code for each login'),
(6612, 'Online'),
(6613, 'Online Support'),
(6614, 'Online Support Link'),
(6615, 'Only Active'),
(6616, 'Only applicable if a provider or collated list was chosen above. PRIMARY only selects patients that the provider is the primary provider. ENCOUNTER selects all patients that the provider has seen.'),
(6617, 'Only entries with a Code are billable'),
(6618, 'Only for comparisons'),
(6619, 'Only for HTML5 compatible browsers.'),
(6620, 'only if billing location'),
(6621, 'Only images files are accepted'),
(6622, 'Only Inactive'),
(6623, 'Only Mine'),
(6624, 'Only one TOTP Key can be set up per user'),
(6625, 'Only recall to provider, no reminder'),
(6626, 'Only reminder to provider, no recall'),
(6627, 'Only Show Diagnosis Reporting Codes'),
(6628, 'Only Show Service Code Finance Reporting Codes'),
(6629, 'Only upload active prescriptions'),
(6630, 'Only upload active prescriptions to NewCrop eRx.'),
(6631, 'Onset'),
(6632, 'Onset of Current Symptoms or Illness'),
(6633, 'Onset of Illness:'),
(6634, 'Onset of Ilness: '),
(6635, 'Onset of Swelling:'),
(6636, 'Onset/hosp. date'),
(6637, 'Onset/hosp. date - is used for billing hospital encounters'),
(6638, 'Onset/hosp. date:'),
(6639, 'Onsite Activity Views'),
(6640, 'Onsite Patient Activities'),
(6641, 'Onsite Patient Portal'),
(6642, 'Onsite Patient Portal Site Address'),
(6643, 'Onsite Portal'),
(6644, 'Onsite Portal Activities'),
(6645, 'Oops!'),
(6646, 'Open'),
(6647, 'Open a spreadsheet and type in the various groups, procedure orders and discrete results, arrange according to need'),
(6648, 'Open a spreadsheet in openoffice/LibreOffice create 5 columns - three for E/M / CPT codes and two for the ICD code categories'),
(6649, 'Open all expandable forms in expanded state'),
(6650, 'Open and review the message content and any attachments'),
(6651, 'Open Demographics in New Window from Patient Flow Board'),
(6652, 'Open Encounter'),
(6653, 'Open Fee Sheet'),
(6654, 'Open in New Window'),
(6655, 'Open Med Practice and its suppliers use their commercially reasonable efforts to provide the most current and complete data available to them concerning prescription histories, drug interactions and formularies, patient allergies and other factors, but by your use of this service you acknowledge that (1) the completeness and accuracy of such data depends upon the completeness and accuracy with which it is entered into connected electronic databases by physicians, physician’s offices, pharmaceutical benefits managers, electronic medical records firms, and other network participants, (2) such data is subject to error or omission in input, storage or retrieval, transmission and display, technical disruption, power or service outages, or other interruptions in electronic communication, any or all of which may be beyond the control of Open Med Practice and its suppliers, and (3) some information may be unavailable due to regulatory, contractual, privacy or other legal restrictions. You are responsible to use your clinical judgment at all times in rendering medical service and advice.'),
(6656, 'Open Patient'),
(6657, 'Open Patient in New Window'),
(6658, 'Open the Quick Pick panels'),
(6659, 'Open the Shorthand Window and display Shorthand Codes'),
(6660, 'Open Today`s Visit'),
(6661, 'Open/Close the Anterior Segment drawing panel'),
(6662, 'Open/Close the Anterior Segment Exam Quick Picks panel'),
(6663, 'Open/Close the detailed HPI panel'),
(6664, 'Open/Close the External drawing panel'),
(6665, 'Open/Close the External Exam Quick Picks panel'),
(6666, 'Open/Close the HPI Canvas'),
(6667, 'Open/Close the Imp/Plan drawing panel'),
(6668, 'Open/Close the Impression/Plan Builder panel'),
(6669, 'Open/Close the Neuro drawing panel'),
(6670, 'Open/Close the Neuro Exam Quick Picks panel'),
(6671, 'Open/Close the PMH draw panel'),
(6672, 'Open/Close the PMSFH summary panel'),
(6673, 'Open/Close the Retina drawing panel'),
(6674, 'Open/Close the Retinal Exam Quick Picks panel'),
(6675, 'Open/Close the Shorthand Window and display Shorthand Codes'),
(6676, 'Open/Close the Shorthand Window and display Shorthand Codes next to each field'),
(6677, 'OpenEMR'),
(6678, 'OpenEMR allows one TOTP but multiple U2F methods per user'),
(6679, 'OpenEMR already has a Certificate Authority configured.'),
(6680, 'OpenEMR Application'),
(6681, 'OpenEMR Application Category'),
(6682, 'OpenEMR Database Upgrade'),
(6683, 'OpenEMR Database Upgrade for De-identification'),
(6684, 'OpenEMR does not recognize the incoming file in the contrib directory. This is most likely because you need to configure the release in the supported_external_dataloads table in the MySQL database.'),
(6685, 'OpenEMR must be configured to use certificates before it can create client certificates.'),
(6686, 'OpenEMR offers 2 methods of 2FA'),
(6687, 'OpenEMR Portal'),
(6688, 'OpenEMR Product Registration'),
(6689, 'OpenEMR requires Javascript to perform user authentication.'),
(6690, 'OpenEMR Users'),
(6691, 'Openings'),
(6692, 'Opens in Bottom frame'),
(6693, 'Opens in Top frame'),
(6694, 'Operation Failed'),
(6695, 'Operative Note - 2009'),
(6696, 'Operator'),
(6697, 'Opthalmic'),
(6698, 'Optic Discs'),
(6699, 'Optic Nerve Analysis'),
(6700, 'Option'),
(6701, 'Option to save method of document storage.'),
(6702, 'Option to support inventory and sales of products'),
(6703, 'Optional'),
(6704, 'Optional category name for an ID Card image that can be viewed from the patient summary page.'),
(6705, 'Optional category name for photo images that can be viewed from the patient summary page.'),
(6706, 'Optional category name of a document to link to from the patient summary page. Lets you click on a patient name to see their ID card.'),
(6707, 'Optional default range for manual entry of results'),
(6708, 'Optional default units for manual entry of results'),
(6709, 'Optional Destination Name'),
(6710, 'Optional drug name, use % as a wildcard'),
(6711, 'Optional end date'),
(6712, 'Optional end date mm/dd/yyyy'),
(6713, 'Optional immunization name or code, use % as a wildcard'),
(6714, 'Optional information about this event'),
(6715, 'Optional lot number, use % as a wildcard'),
(6716, 'Optional numeric patient ID'),
(6717, 'Optional procedure code'),
(6718, 'Optional procedure/service code'),
(6719, 'Options'),
(6720, 'OR'),
(6721, 'Or'),
(6722, 'or choose'),
(6723, 'or click and drag for faster selection.'),
(6724, 'Or create this new field ID'),
(6725, 'Or Out To'),
(6726, 'or select from inventory'),
(6727, 'or Shift-click to decrease it'),
(6728, 'Or upload ERA file:'),
(6729, 'or utilize the Impression/Plan Builder'),
(6730, 'Oral'),
(6731, 'Oral mucosa pink, throat clear'),
(6732, 'Order'),
(6733, 'Order - The order in which the item will be displayed - incrementing by 10 will allow for up to 9 values to be inserted in between if so desired at a later date'),
(6734, 'Order and Result Types'),
(6735, 'Order Catalog'),
(6736, 'Order Date'),
(6737, 'Order Descriptions'),
(6738, 'Order From'),
(6739, 'Order ID'),
(6740, 'Order must be a number between 1 and 999'),
(6741, 'Order must be a number between 1 and 9999'),
(6742, 'Order Name'),
(6743, 'Order Notes'),
(6744, 'Order Priorities'),
(6745, 'Order Processor'),
(6746, 'Order Questions'),
(6747, 'Order Results'),
(6748, 'Order Status'),
(6749, 'Order Statuses'),
(6750, 'Order Summary'),
(6751, 'Order Tracks'),
(6752, 'Order Type'),
(6753, 'Order Types'),
(6754, 'Order/Result Type'),
(6755, 'Ordered'),
(6756, 'Ordered By'),
(6757, 'Ordered Procedure'),
(6758, 'Ordering a recognized panel of tests'),
(6759, 'Ordering Physician'),
(6760, 'Ordering Provider'),
(6761, 'Ordering tests individually can be tedious and there are two ways of ordering multiple tests together'),
(6762, 'Orders'),
(6763, 'Orders and Results are setup in an hierarchical manner, there are four tiers in this hierarchy'),
(6764, 'Orders Path'),
(6765, 'Orders Path - is only required if you are submitting an electronic order to an external facility'),
(6766, 'Organ injury'),
(6767, 'Organization'),
(6768, 'Organization Name'),
(6769, 'Organizational Unit Name'),
(6770, 'Organizations'),
(6771, 'Orientated x 3'),
(6772, 'Oriented TPP{{oriented to person and place}}'),
(6773, 'Original'),
(6774, 'Original Checksum'),
(6775, 'Original file'),
(6776, 'Original file deletion error'),
(6777, 'Oriya'),
(6778, 'Oromo'),
(6779, 'OROPHARYNX: '),
(6780, 'Ortho'),
(6781, 'Orthophoric'),
(6782, 'Orthopnea'),
(6783, 'ORTHO{{Orthopedics}}'),
(6784, 'Ortho{{orthophoric}}'),
(6785, 'OR{{as in AND/OR, ie. not an abbreviation}}'),
(6786, 'OS'),
(6787, 'Osetoarthritis'),
(6788, 'Ossetian, Ossetic'),
(6789, 'Osteopathy'),
(6790, 'OS{{left eye}}'),
(6791, 'Other'),
(6792, 'OTHER'),
(6793, 'other'),
(6794, 'Other (specify)'),
(6795, 'Other - lists items not covered in the above sections'),
(6796, 'Other - Specified'),
(6797, 'Other adult'),
(6798, 'Other Documents'),
(6799, 'Other Federal Program'),
(6800, 'Other HCFA'),
(6801, 'Other injury not elsewhere specified'),
(6802, 'Other Liability Insurance is Primary'),
(6803, 'Other Logs'),
(6804, 'other month'),
(6805, 'Other Non-Federal Programs'),
(6806, 'Other Notes'),
(6807, 'Other Pertinent Symptoms'),
(6808, 'Other Pertinent Symptoms:'),
(6809, 'Other Place of Service'),
(6810, 'Other Provider'),
(6811, 'Other pt resp'),
(6812, 'Other Registry'),
(6813, 'Other stress/Over use injury'),
(6814, 'Other Surgical'),
(6815, 'Other/Generic Abortion-Related'),
(6816, 'Other/Miscellaneous'),
(6817, 'Others'),
(6818, 'Otherwise known as Dated Reminders are short messages of up to 160 characters'),
(6819, 'otherwise you will destroy references to/from existing data.'),
(6820, 'OTP can be delivered by various methods'),
(6821, 'OTP can be generated either using time synchronization where the current time is combined with a secret key and hashed to generate the OTP or using mathematical algorithms were an initial seed (a random number) is combined with the previously used password to generate the OTP'),
(6822, 'Ottawa Ankle Rules'),
(6823, 'OU'),
(6824, 'Our Out To'),
(6825, 'OUT'),
(6826, 'Out Of Office'),
(6827, 'Out Time'),
(6828, 'Outbound Referral'),
(6829, 'Outcome'),
(6830, 'Outline Data Col'),
(6831, 'Outline Entire Row'),
(6832, 'Outlook'),
(6833, 'Outpatient Hospital'),
(6834, 'Output Type'),
(6835, 'OU{{both eyes}}'),
(6836, 'Over'),
(6837, 'Overall Status Of Discharge'),
(6838, 'OVERDUE'),
(6839, 'Overlay CMS 1500 on the Preprinted form'),
(6840, 'Override (if necessary) the appointment display limit to allow all appointments to be displayed for the last set'),
(6841, 'Override HIPAA choice'),
(6842, 'Overuse'),
(6843, 'Overview'),
(6844, 'Overweight'),
(6845, 'Overwrite HIPAA choice'),
(6846, 'Owner'),
(6847, 'Oxygen Saturation'),
(6848, 'oz'),
(6849, 'P'),
(6850, 'p.c.'),
(6851, 'p.m.'),
(6852, 'p.r.n.'),
(6853, 'Pachymetry'),
(6854, 'Pachymetry: Central Corneal Thickness'),
(6855, 'Pachy{{Pachymetry}}'),
(6856, 'Pacific Islander'),
(6857, 'Paedeatric'),
(6858, 'Page'),
(6859, 'Page Validation'),
(6860, 'Pages'),
(6861, 'Paid'),
(6862, 'Paid amount that you will allocate'),
(6863, 'Paid Amt'),
(6864, 'Paid Via'),
(6865, 'Pain'),
(6866, 'Pali'),
(6867, 'Palliative care physician'),
(6868, 'Palpitation'),
(6869, 'PAM{{Potential Acuity Meter}}'),
(6870, 'Pan'),
(6871, 'Panjabi, Punjabi'),
(6872, 'Pap Smear'),
(6873, 'Paper'),
(6874, 'Paper Size'),
(6875, 'Paralysis'),
(6876, 'Parent'),
(6877, 'parent in-law'),
(6878, 'Parent Recall'),
(6879, 'Parent Written Record'),
(6880, 'Parental decision'),
(6881, 'Parse HL7'),
(6882, 'Partially Administered'),
(6883, 'Participant\'s name'),
(6884, 'participants'),
(6885, 'Participants '),
(6886, 'Partner'),
(6887, 'Partner Name'),
(6888, 'Partner Name issued for NewCrop eRx service.'),
(6889, 'Partner not configured'),
(6890, 'Pashto, Pushto'),
(6891, 'Pass Phrase'),
(6892, 'Pass phrase to decrypt document'),
(6893, 'Passed Patients'),
(6894, 'Passive Alert'),
(6895, 'Passive Alert - that will be displayed in the Clinical Reminders widget section'),
(6896, 'Passive Alert Rules'),
(6897, 'password'),
(6898, 'Password'),
(6899, 'Password Change'),
(6900, 'Password change successful'),
(6901, 'Password change successful.'),
(6902, 'Password does not meet minimum requirements and should contain at least three of the four following items: A number, a lowercase letter, an uppercase letter, a special character (Not a leter or number).'),
(6903, 'Password Expiration Grace Period'),
(6904, 'Password for Phone Gateway.'),
(6905, 'Password for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(6906, 'Password for SMS Gateway'),
(6907, 'Password for SMS Gateway.'),
(6908, 'Password for the above user'),
(6909, 'Password security has recently been upgraded.'),
(6910, 'Password to connect to CouchDB'),
(6911, 'Password too short. Minimum 8 characters required.'),
(6912, 'Password:'),
(6913, 'Passwords do not match'),
(6914, 'Passwords do not match.'),
(6915, 'Passwords Don\'t match!'),
(6916, 'Passwords must be 8-12 characters long and include one capital letter, one lower case letter and one special character'),
(6917, 'Past Appoinments'),
(6918, 'Past Appointment Display Widget'),
(6919, 'Past Appointments'),
(6920, 'Past Appointments - will show all past appointments'),
(6921, 'Past Date'),
(6922, 'Past due'),
(6923, 'Past Due'),
(6924, 'Past Due Interval (Clinical Reminders)'),
(6925, 'Past Due Interval (Patient Reminders)'),
(6926, 'Past Encounter List'),
(6927, 'Past Encounters'),
(6928, 'Past Encounters and Documents'),
(6929, 'Past Encounters for'),
(6930, 'Past Medical History'),
(6931, 'Past meetings'),
(6932, 'Past Ocular History'),
(6933, 'Past Ocular Surgery'),
(6934, 'Past Surgical History'),
(6935, 'Past Therapy Group Encounters'),
(6936, 'Past Year'),
(6937, 'Paste HL7 Data'),
(6938, 'Paste the data to import into the text area below:'),
(6939, 'Pat'),
(6940, 'Pat Ledger'),
(6941, 'Patch'),
(6942, 'PaternalAunt'),
(6943, 'PaternalCousin'),
(6944, 'PaternalGrandparent'),
(6945, 'PaternalGreatgrandparent'),
(6946, 'PaternalUncle'),
(6947, 'Path for Event Log Backup'),
(6948, 'Path to CA Certificate File'),
(6949, 'Path to CA Key File'),
(6950, 'Path to MySQL Binaries'),
(6951, 'Path to Perl Binaries'),
(6952, 'Path to Temporary Files'),
(6953, 'Patient'),
(6954, 'patient'),
(6955, 'PATIENT'),
(6956, 'Patient Access'),
(6957, 'Patient Address'),
(6958, 'Patient Address is missing'),
(6959, 'Patient Adj'),
(6960, 'Patient Adjustment'),
(6961, 'Patient allergies'),
(6962, 'Patient Allergies'),
(6963, 'Patient already in form'),
(6964, 'Patient and Insured Informatiom - Boxes 1 - 13 and Physician or Supplier Information - Boxes 14 - 33'),
(6965, 'Patient Appointment'),
(6966, 'Patient Balance'),
(6967, 'Patient Balance Due'),
(6968, 'Patient Billing Note'),
(6969, 'Patient birthday alert requires turning off'),
(6970, 'Patient Characteristics'),
(6971, 'Patient chart ID'),
(6972, 'Patient Chat'),
(6973, 'Patient Checkout'),
(6974, 'Patient Checkout for '),
(6975, 'Patient City'),
(6976, 'Patient City is missing'),
(6977, 'Patient city missing'),
(6978, 'Patient Communication sent'),
(6979, 'Patient Comunication Sent'),
(6980, 'Patient Country'),
(6981, 'Patient Country is missing. Also you have not set default Patient Country in Global Settings'),
(6982, 'Patient Coverage'),
(6983, 'Patient Credentials Reset'),
(6984, 'Patient Credit'),
(6985, 'Patient Dashboard'),
(6986, 'Patient Data'),
(6987, 'Patient Date Of Birth'),
(6988, 'Patient Date Of Birth is missing'),
(6989, 'Patient decision'),
(6990, 'Patient Default'),
(6991, 'Patient Demographics'),
(6992, 'Patient details'),
(6993, 'Patient Details'),
(6994, 'Patient DOB'),
(6995, 'Patient DOB missing'),
(6996, 'Patient Document'),
(6997, 'Patient Document Template Upload'),
(6998, 'Patient Document Templates'),
(6999, 'Patient Documents'),
(7000, 'Patient Education'),
(7001, 'Patient Education Materials'),
(7002, 'Patient Encounter'),
(7003, 'Patient Encounter Form'),
(7004, 'Patient Encounters'),
(7005, 'Patient Finder'),
(7006, 'Patient Finder Screen'),
(7007, 'Patient First name'),
(7008, 'Patient First Name'),
(7009, 'Patient First name is missing'),
(7010, 'Patient Flow Board'),
(7011, 'Patient Flow Board Report'),
(7012, 'Patient Flow Board Rooms'),
(7013, 'Patient Flow Board Timer Interval'),
(7014, 'Patient Gender'),
(7015, 'Patient Gender is missing'),
(7016, 'Patient has not authorized the Patient Portal.'),
(7017, 'Patient History'),
(7018, 'Patient History / Lifestyle'),
(7019, 'Patient Home phone'),
(7020, 'Patient ID'),
(7021, 'Patient Id'),
(7022, 'Patient ID card'),
(7023, 'Patient ID Category Name'),
(7024, 'Patient identifying information'),
(7025, 'Patient Images'),
(7026, 'Patient Immunization'),
(7027, 'Patient Information'),
(7028, 'Patient Information (patients)'),
(7029, 'Patient Instructions'),
(7030, 'Patient Insurance Distribution'),
(7031, 'Patient Insurance Distribution Report'),
(7032, 'Patient insurance/financial information'),
(7033, 'Patient is required to enter their contact e-mail if present in Demographics Contact.'),
(7034, 'Patient Issues'),
(7035, 'Patient Label Type'),
(7036, 'Patient Last name'),
(7037, 'Patient Last Name'),
(7038, 'Patient Last name is missing'),
(7039, 'Patient Ledger'),
(7040, 'Patient Ledger by Date'),
(7041, 'Patient Ledger Help'),
(7042, 'Patient Level Billing Note (Collections)'),
(7043, 'Patient List'),
(7044, 'Patient List Columns'),
(7045, 'Patient List Creation'),
(7046, 'Patient List New Window'),
(7047, 'Patient List Page Size'),
(7048, 'Patient Lookup Errors'),
(7049, 'Patient Mail'),
(7050, 'Patient may change their logon from portal login dialog.'),
(7051, 'Patient Medical Problems'),
(7052, 'Patient Medications'),
(7053, 'Patient Menu Role'),
(7054, 'Patient Message'),
(7055, 'Patient Messages'),
(7056, 'Patient Messaging'),
(7057, 'Patient must be set manually'),
(7058, 'Patient Name'),
(7059, 'Patient name'),
(7060, 'Patient Name & Address'),
(7061, 'Patient Name and ID'),
(7062, 'Patient Name and Invoice'),
(7063, 'Patient Name Required'),
(7064, 'Patient Name/ID'),
(7065, 'Patient Note'),
(7066, 'Patient Note Types'),
(7067, 'Patient Notes'),
(7068, 'Patient Notes (write,addonly optional)'),
(7069, 'Patient Notes (write,addonly optional) (notes)'),
(7070, 'Patient Number'),
(7071, 'Patient Payment'),
(7072, 'Patient Payments'),
(7073, 'Patient Photo Category Name'),
(7074, 'Patient Portal'),
(7075, 'PATIENT PORTAL'),
(7076, 'Patient Portal (patientportal)'),
(7077, 'Patient Portal (portal)'),
(7078, 'Patient Portal connectivity issue'),
(7079, 'Patient Portal is turned off'),
(7080, 'Patient Portal Login'),
(7081, 'Patient Portal Secure'),
(7082, 'Patient Portal Web Address'),
(7083, 'Patient Printed Report'),
(7084, 'Patient Recalls'),
(7085, 'Patient Record Report'),
(7086, 'Patient Record Request'),
(7087, 'Patient Records Request'),
(7088, 'Patient Religion'),
(7089, 'Patient Reminder'),
(7090, 'Patient Reminder - that is used to communicate relevant information pertaining to that particular Clinical Decision Rule and is shown in the Patient Reminders widget as Well as under Administration > Patient Reminders'),
(7091, 'Patient Reminder Batch Job'),
(7092, 'Patient Reminder Creation Processing Priority'),
(7093, 'Patient Reminder Rules'),
(7094, 'Patient Reminder Sender Email'),
(7095, 'Patient Reminder Sender Name'),
(7096, 'Patient Reminders'),
(7097, 'Patient Reminders (write,addonly optional)'),
(7098, 'Patient Reminders (write,addonly optional) (reminder)'),
(7099, 'Patient Reminders - a list reminders for preventive or follow-up care according to patient preferences based on demographic data, specific conditions, and/or medication list as well as the status of the notification'),
(7100, 'Patient Report'),
(7101, 'Patient Reports'),
(7102, 'Patient Reports Help'),
(7103, 'Patient Request'),
(7104, 'Patient Requested Medical Records'),
(7105, 'Patient Resource'),
(7106, 'Patient Results'),
(7107, 'Patient Search'),
(7108, 'Patient Search Not Available'),
(7109, 'Patient search or select.'),
(7110, 'Patient Search Results Style'),
(7111, 'Patient Search/Add Screen'),
(7112, 'Patient Secure Mail'),
(7113, 'Patient Setting'),
(7114, 'Patient sex missing'),
(7115, 'Patient Signed'),
(7116, 'Patient Signed Date'),
(7117, 'Patient State'),
(7118, 'Patient state missing'),
(7119, 'Patient Statement Bill'),
(7120, 'Patient statements can be generated as plain text or with a modern graphical appearance.'),
(7121, 'Patient Street Address'),
(7122, 'Patient street missing'),
(7123, 'Patient Summary'),
(7124, 'Patient Surveys'),
(7125, 'Patient Transactions'),
(7126, 'Patient Transactions Help'),
(7127, 'Patient validation'),
(7128, 'Patient Zip'),
(7129, 'Patient Zip Code missing'),
(7130, 'Patient\'s number'),
(7131, 'patient(s) in the database that match the demographic information you have entered.'),
(7132, 'Patient/Client'),
(7133, 'Patient:'),
(7134, 'PatientID'),
(7135, 'Patients'),
(7136, 'Patients (patients)'),
(7137, 'Patients Processed'),
(7138, 'Patients with debt'),
(7139, 'Patient’s health status'),
(7140, 'Pay'),
(7141, 'Pay attention to the \"Done with\" checkboxes.  After the insurances are marked complete then we will start asking the patient to pay the remaining balance; if you fail to mark all of the insurances complete then the remaining amount will not be collected!  Also if there is a balance that the patient should pay, then set the due date appropriately, as this will affect the language that appears on patient statements.'),
(7142, 'Pay attention to the \'Done with\' checkboxes. After the insurances are marked complete then we will start asking the patient to pay the remaining balance; if you fail to mark all of the insurances complete then the remaining amount will not be collected! Also if there is a balance that the patient should pay, then set the due date appropriately, as this will affect the language that appears on patient statements.'),
(7143, 'Pay Date'),
(7144, 'Pay Date:'),
(7145, 'Pay Invoice'),
(7146, 'Pay Now'),
(7147, 'Pay Status'),
(7148, 'Payee Name'),
(7149, 'Payer'),
(7150, 'Payer ID'),
(7151, 'Payer Id For Eligibility'),
(7152, 'Payer ID For Encounter Claims'),
(7153, 'Payer Type'),
(7154, 'Paying'),
(7155, 'Paying Entity'),
(7156, 'Payment'),
(7157, 'payment'),
(7158, 'Payment Adjustment Code'),
(7159, 'Payment against'),
(7160, 'Payment Amount'),
(7161, 'Payment Amount must be Numeric'),
(7162, 'Payment Category'),
(7163, 'Payment date'),
(7164, 'Payment Date'),
(7165, 'payment entered on'),
(7166, 'Payment From'),
(7167, 'Payment Gateways'),
(7168, 'Payment Information'),
(7169, 'Payment Ins'),
(7170, 'Payment List'),
(7171, 'Payment Method'),
(7172, 'Payment Sort By'),
(7173, 'Payment Status'),
(7174, 'Payment successfully sent for authorization. You will be notified when payment is posted. Until payment is accepted and you are notified, you may resubmit this payment at anytime with new amounts or different credit card. Thank you'),
(7175, 'Payment successfully sent for review and posting to your account.'),
(7176, 'Payment Tracking Id'),
(7177, 'Payment Type'),
(7178, 'Payment Validated: Save?'),
(7179, 'Payment value for code '),
(7180, 'Payment was successfully authorized and your card is charged.'),
(7181, 'Payments'),
(7182, 'Payor'),
(7183, 'Payor ID'),
(7184, 'Payor/Carrier Code'),
(7185, 'PCP'),
(7186, 'Pct (%) of rows'),
(7187, 'PD-D{{abbreviation for Binocular Pupillary Diameter - Distance}}'),
(7188, 'PD-N{{abbreviation for Binocular Pupillary Diameter - Near}}'),
(7189, 'PDF'),
(7190, 'PDF buttons will save, mark claim reviewed and download claim'),
(7191, 'PDF Download Selected Statements'),
(7192, 'PDF Language'),
(7193, 'Pdf With Form'),
(7194, 'Pdf Without Form'),
(7195, 'PD{{Inter-pupillary distance}}'),
(7196, 'PD{{pupillary distance}}'),
(7197, 'Pelvis and buttock'),
(7198, 'Pemphigus'),
(7199, 'Pencil'),
(7200, 'pend'),
(7201, 'Pending'),
(7202, 'Pending Action'),
(7203, 'Pending Approval'),
(7204, 'Pending Auth since'),
(7205, 'Pending Documents'),
(7206, 'Pending F/U'),
(7207, 'Pending followup'),
(7208, 'Pending Followup from Results'),
(7209, 'Pending Orders'),
(7210, 'Pending Res'),
(7211, 'Pending Review'),
(7212, 'Pending Rx Count'),
(7213, 'Pending since'),
(7214, 'Penicillin Allergy'),
(7215, 'Pennington Firm OpenEMR  v'),
(7216, 'Peptic Ulcer Disease'),
(7217, 'Per Encounter'),
(7218, 'per min'),
(7219, 'Per Nostril'),
(7220, 'per nostril'),
(7221, 'Per Oris'),
(7222, 'per oris'),
(7223, 'Per Rectum'),
(7224, 'per rectum'),
(7225, 'Percent'),
(7226, 'Percentage'),
(7227, 'Percentage of Patients to Drug Test'),
(7228, 'Percentage of Patients to select for Random Drug Testing.'),
(7229, 'Percentile'),
(7230, 'Perforated Right:'),
(7231, 'Perform Search'),
(7232, 'Perform this action'),
(7233, 'Performance Percentage'),
(7234, 'performed'),
(7235, 'Performer'),
(7236, 'Performing Laboratory Facility'),
(7237, 'Performing organization'),
(7238, 'Period'),
(7239, 'Period in days where a user may login with an expired password.'),
(7240, 'Perioperative Care'),
(7241, 'Periph'),
(7242, 'Peripheral'),
(7243, 'Periph{{peripheral retina}}'),
(7244, 'Periph{{periphery}}'),
(7245, 'Permit unsalted passwords'),
(7246, 'Persian'),
(7247, 'Persian (Farsi)'),
(7248, 'Person'),
(7249, 'Personalize'),
(7250, 'Persons needing a recall, no appt scheduled yet'),
(7251, 'PG'),
(7252, 'Pharm'),
(7253, 'Pharm Com Count'),
(7254, 'Pharmacies'),
(7255, 'Pharmacy'),
(7256, 'Pharmacy Dispensary'),
(7257, 'Pharmacy Dispensary (drugs)'),
(7258, 'Pharmacy Id'),
(7259, 'Pharmacy missing NCPDP ID or less than 7 digits'),
(7260, 'Pharmacy missing NPI  or less than 10 digits'),
(7261, 'Pharmacy not assigned to the patient'),
(7262, 'Pheumothorax'),
(7263, 'phiMail Allow CCD Send'),
(7264, 'phiMail Allow CCR Send'),
(7265, 'phiMail Message Check Interval (minutes)'),
(7266, 'phiMail notification user'),
(7267, 'phiMail Password'),
(7268, 'phiMail Server Address'),
(7269, 'phiMail Username'),
(7270, 'PHIN Questions'),
(7271, 'Phone'),
(7272, 'Phone Biz'),
(7273, 'Phone call list'),
(7274, 'Phone Call List'),
(7275, 'Phone Call List report'),
(7276, 'Phone call made by'),
(7277, 'Phone Cell'),
(7278, 'Phone Contact'),
(7279, 'Phone Gateway Password'),
(7280, 'Phone Gateway URL'),
(7281, 'Phone Gateway Username'),
(7282, 'Phone Home'),
(7283, 'Phone Notification Hour'),
(7284, 'Phone number'),
(7285, 'Phone Number'),
(7286, 'Phone number for billing inquiries'),
(7287, 'Phone Number for Vendor Support that Appears on the About Page.'),
(7288, 'Phone(W)'),
(7289, 'Photophobia'),
(7290, 'Photos'),
(7291, 'PHP compressed'),
(7292, 'PHP CURL module should be enabled in your server.'),
(7293, 'PHP extracted'),
(7294, 'php-GACL access controls are turned off'),
(7295, 'PHP-gacl is not installed'),
(7296, 'Physical Exam'),
(7297, 'Physician'),
(7298, 'Physician Request'),
(7299, 'Physician Signature'),
(7300, 'Physician Type'),
(7301, 'Physician\'s UPIN'),
(7302, 'Physicians'),
(7303, 'PH{{pinhole acuity}}'),
(7304, 'PH{{Pinhole Vision}}'),
(7305, 'PH{{Pinhole}}'),
(7306, 'pick'),
(7307, 'Pick'),
(7308, 'Pick a CSS theme.'),
(7309, 'Pick a general theme (need to logout/login after change this setting).'),
(7310, 'Pick a general theme (need to logout/login after changing this setting).'),
(7311, 'PID'),
(7312, 'Pid'),
(7313, 'PID (Pelvic Inflammatory Disease)'),
(7314, 'Pill Size'),
(7315, 'Pills'),
(7316, 'Pinhole Vision'),
(7317, 'Place of Employment-Worksite'),
(7318, 'Place the database zip file in the following directory if want the option to install'),
(7319, 'Place the downloaded ICD 10 database zip files into the following directory'),
(7320, 'Place the downloaded ICD 9 database zip file into the following directory'),
(7321, 'Place the downloaded RxNorm database zip file into the following directory'),
(7322, 'Place the downloaded Snomed database zip file into the following directory'),
(7323, 'Place the downloaded VALUESET database zip file into the following directory'),
(7324, 'Place your logo in sites/default/images and type the filename including gif extension here.'),
(7325, 'Placeholder'),
(7326, 'Placeholder (Maintains empty ACLs)'),
(7327, 'Placeholder (Maintains empty ACLs) (filler)'),
(7328, 'Placeholder (placeholder)'),
(7329, 'Plain Text'),
(7330, 'Plan'),
(7331, 'Plan Added Successfully'),
(7332, 'Plan Already in list_options'),
(7333, 'Plan copay if known'),
(7334, 'Plan Description'),
(7335, 'Plan Name'),
(7336, 'Plan Name Already Exists'),
(7337, 'Plan Name Already Taken'),
(7338, 'Plan Name Missing'),
(7339, 'Plan of Care'),
(7340, 'Plan of Care Type'),
(7341, 'Plan Set'),
(7342, 'Plan Status Changed'),
(7343, 'Plan Status Failed to Change'),
(7344, 'Plan Type'),
(7345, 'Plan Updated Successfully'),
(7346, 'Plan:'),
(7347, 'Planned Activity'),
(7348, 'Planned Date'),
(7349, 'Plans'),
(7350, 'Plans Configuration'),
(7351, 'Player'),
(7352, 'Playing Position'),
(7353, 'Please call if any of the above information is incorrect'),
(7354, 'Please call if any of the above information is incorrect.'),
(7355, 'Please call or message if any of the above information is incorrect.'),
(7356, 'Please call our office to schedule'),
(7357, 'Please change your password.'),
(7358, 'Please Choose a file'),
(7359, 'Please choose a patient'),
(7360, 'Please choose a valid selection from the list.'),
(7361, 'Please choose a valid selection.'),
(7362, 'Please choose a value for'),
(7363, 'Please choose date range criteria above, and click Refresh to view results.'),
(7364, 'Please choose the proper formatted EDI-271 file'),
(7365, 'Please Click download button to download the De Identified data'),
(7366, 'Please Click download button to download the Re Identified data'),
(7367, 'Please close this window.'),
(7368, 'Please compare the new name'),
(7369, 'Please consider sending in a donation to'),
(7370, 'Please contact your provider.'),
(7371, 'Please contact your systems administrator, the following component(s) are required but are missing.'),
(7372, 'Please correct the value(s) before proceeding!'),
(7373, 'Please create the following directory before proceeding'),
(7374, 'Please delete characters'),
(7375, 'Please do not accept this prescription unless it was received via facimile.'),
(7376, 'Please do not accept this prescription unless it was received via facsimile.'),
(7377, 'Please do NOT use your browsers stop or reload button while this page is running unless more than 10 minutes have elapsed, this will not cause the process to  stop on the server and will consume uneccesary resources.'),
(7378, 'PLEASE ENABLE CURL EXTENSION'),
(7379, 'PLEASE ENABLE OPENSSL EXTENSION'),
(7380, 'PLEASE ENABLE SOAP EXTENSION'),
(7381, 'PLEASE ENABLE XML EXTENSION'),
(7382, 'Please ensure that there is only one image file - jpeg, png or bmp in the Patient Photograph folder'),
(7383, 'Please enter a date for Last Reviewed.'),
(7384, 'Please enter a date.'),
(7385, 'Please enter a dollar amount using only numbers and a decimal point.'),
(7386, 'Please enter a due date'),
(7387, 'Please enter a enter valid range'),
(7388, 'Please enter a message'),
(7389, 'Please enter a monetary amount using only numbers and a decimal point.'),
(7390, 'Please enter a name for this key.'),
(7391, 'Please Enter a New Password'),
(7392, 'Please enter a title!'),
(7393, 'Please enter a valid Direct Address above.'),
(7394, 'Please enter at least the item\'s name'),
(7395, 'Please enter at least the track\'s name'),
(7396, 'Please enter card comfirmation authorization'),
(7397, 'Please enter correct Re Identification code'),
(7398, 'Please Enter End Date greater than Begin Date!'),
(7399, 'Please enter more characters'),
(7400, 'Please enter new search string'),
(7401, 'Please enter the correct Re Identification code'),
(7402, 'Please enter the password'),
(7403, 'Please fill in credit information and send for review.'),
(7404, 'Please fill out facility city properly'),
(7405, 'Please fill out facility fax properly'),
(7406, 'Please fill out facility name properly'),
(7407, 'Please fill out facility phone properly'),
(7408, 'Please fill out facility postal code properly'),
(7409, 'Please fill out facility state properly'),
(7410, 'Please fill out facility street properly'),
(7411, 'Please Fill the Check Number'),
(7412, 'Please Fill the Check/Ref Number'),
(7413, 'Please Fill the Date'),
(7414, 'Please Fill the Payment Amount'),
(7415, 'Please Fill the Payment Category'),
(7416, 'Please Fill the Payment From'),
(7417, 'Please Fill the Post To Date'),
(7418, 'Please fill them in before continuing.'),
(7419, 'Please give this key a name'),
(7420, 'Please indicate visit reason'),
(7421, 'Please input search criteria above, and click Submit to start report.'),
(7422, 'Please input search criteria above, and click Submit to view results.'),
(7423, 'Please input search criteria above, and click Submit to view results. (Results will be displayed in a pop up window)'),
(7424, 'Please login again.'),
(7425, 'Please note that this can take a very long time, up to several minutes, your web browser may not appear very active during this time but generating a bill is a  complicated process and your web browser is merely waiting for more information.'),
(7426, 'Please Note: constants are case sensitive and any string is allowed.'),
(7427, 'Please only use alphabetic characters'),
(7428, 'Please only use alphabetic characters with no spaces'),
(7429, 'Please pay this amount'),
(7430, 'Please place your install files in following directory'),
(7431, 'Please provide a valid e-mail address to proceed'),
(7432, 'Please provide a valid email address'),
(7433, 'Please refer to'),
(7434, 'Please reset the password.'),
(7435, 'Please restart the apache server before playing with de-identification'),
(7436, 'Please return this bottom part with your payment'),
(7437, 'Please see forum and wiki'),
(7438, 'Please see http://www.open-emr.org/wiki/index.php/LBV_Forms for more on this topic'),
(7439, 'Please see the attached PDF.'),
(7440, 'Please Select'),
(7441, 'Please select a format'),
(7442, 'Please select a language'),
(7443, 'Please Select a Patient.'),
(7444, 'Please select a Primary Business Entity facility with \'Tax ID\' as your facility Tax ID. If you are an individual practitioner, use your tax id. This is used for identifying you in the NewCrop system.'),
(7445, 'Please select a Primary Business Entity facility with \'Tax ID\' as your facility Tax ID. If you are an individual practitioner, use your tax id. This is used for identifying you in the NewCrop system.'),
(7446, 'Please select a procedure provider'),
(7447, 'Please Select A Recipient'),
(7448, 'Please Select a Recipient for Message.'),
(7449, 'Please select a start date and end date'),
(7450, 'Please select a valid recipient'),
(7451, 'Please Select an Active Group'),
(7452, 'Please select an adjustment reason for code '),
(7453, 'Please select an event'),
(7454, 'Please select an item that has more data'),
(7455, 'Please select any Search Option.'),
(7456, 'Please select at least one criteria to download'),
(7457, 'Please select at least one patient.'),
(7458, 'Please select at least one prescription!'),
(7459, 'Please select encounter'),
(7460, 'Please select From date'),
(7461, 'Please select image procedure'),
(7462, 'Please select message(s) to delete'),
(7463, 'Please select the desired pages to copy or forward:'),
(7464, 'Please Select the Payment Method'),
(7465, 'Please select To date'),
(7466, 'Please Select Type Of Payment.'),
(7467, 'Please select visit category'),
(7468, 'Please select X12 partner, required to create the 270 batch'),
(7469, 'Please set'),
(7470, 'Please set de_identification_config variable back to zero'),
(7471, 'Please set pharmacy in patient\'s chart!'),
(7472, 'Please Specify at least One Direct Address'),
(7473, 'Please start new De Identification process'),
(7474, 'Please supply a heading'),
(7475, 'Please upgrade OpenEMR Database to include De Identification procedures, function, tables'),
(7476, 'Please use valid NPI'),
(7477, 'Please view De Identification error log table for more details'),
(7478, 'Please visit De Identification screen after some time'),
(7479, 'Please visit Re Identification screen after some time'),
(7480, 'Please visit the screen after some time'),
(7481, 'Please wait...'),
(7482, 'Plot item'),
(7483, 'Plot selected Items'),
(7484, 'Plural'),
(7485, 'plus 1 year'),
(7486, 'plus 2 years'),
(7487, 'plus 3 years'),
(7488, 'PM'),
(7489, 'PM Program'),
(7490, 'PMH'),
(7491, 'PMH Dx'),
(7492, 'PMH{{Past Medical History}}'),
(7493, 'PMSFH Panel'),
(7494, 'PMSFH{{Abbreviation for Past medical Surgical Family and Social History}}'),
(7495, 'Pmt Method'),
(7496, 'PND'),
(7497, 'Pneumococcal Conjugate 1'),
(7498, 'Pneumococcal Conjugate 2'),
(7499, 'Pneumococcal Conjugate 3'),
(7500, 'Pneumococcal Conjugate 4'),
(7501, 'Pneumococcal Vaccine'),
(7502, 'Pneumonia Vaccination'),
(7503, 'Pneumonia Vaccination Status for Older Adults'),
(7504, 'Pneumonia Vaccination Status for Older Adults (CQM)'),
(7505, 'Podiatric'),
(7506, 'Podiatry'),
(7507, 'POH{{Past Ocular History}}'),
(7508, 'Point of Service (POS)'),
(7509, 'Policy'),
(7510, 'Policy Begin Date'),
(7511, 'Policy effective date'),
(7512, 'Policy No'),
(7513, 'Policy Number'),
(7514, 'Polish'),
(7515, 'Polydypsia'),
(7516, 'Polygon'),
(7517, 'Polyps'),
(7518, 'Polyuria'),
(7519, 'Poor Appetite'),
(7520, 'Poor Circulation'),
(7521, 'Poor Hearing'),
(7522, 'Pop Out Full Screen.'),
(7523, 'Pop ups need to be enabled to see these reports'),
(7524, 'Populate Fee Sheet'),
(7525, 'Populate the year view with events?'),
(7526, 'Popups'),
(7527, 'Port'),
(7528, 'Portal'),
(7529, 'Portal Activity'),
(7530, 'Portal Alerts'),
(7531, 'Portal Audits'),
(7532, 'Portal Chats'),
(7533, 'Portal Dashboard'),
(7534, 'Portal ID'),
(7535, 'Portal ID does not match request from portal!'),
(7536, 'Portal Mail'),
(7537, 'Portal Only'),
(7538, 'Portal password is missing'),
(7539, 'Portal Payments'),
(7540, 'Portal Requests'),
(7541, 'Portal Uses Server Base Path (internal)'),
(7542, 'Portrait'),
(7543, 'Portuguese'),
(7544, 'Portuguese (Brazilian)'),
(7545, 'Portuguese (European)'),
(7546, 'POS Code'),
(7547, 'Position'),
(7548, 'Position of Gaze'),
(7549, 'Positive'),
(7550, 'Positives'),
(7551, 'Possible'),
(7552, 'Post Date'),
(7553, 'Post For'),
(7554, 'Post Item'),
(7555, 'Post Nasal Drip'),
(7556, 'Post Payment'),
(7557, 'Post Payments'),
(7558, 'Post surgical'),
(7559, 'Post to accounting and mark as billed'),
(7560, 'Post To Date'),
(7561, 'Post To Date Cannot be greater than Today'),
(7562, 'Post To Date Must be greater than the Financial Close Date.'),
(7563, 'Post-Abortion Care'),
(7564, 'Post-Abortion Contraception'),
(7565, 'Post-Abortion Counseling'),
(7566, 'Post-Abortion Followup'),
(7567, 'Postal'),
(7568, 'Postal Code'),
(7569, 'Postal code'),
(7570, 'Postal Code and Box Number'),
(7571, 'PostCalendar'),
(7572, 'PostCalendar Administration'),
(7573, 'PostCalendar Category Settings'),
(7574, 'PostCalendar Global Settings'),
(7575, 'Postcard'),
(7576, 'POSTCARD'),
(7577, 'Postcard printed by'),
(7578, 'Postcards'),
(7579, 'Posted on'),
(7580, 'Posterior Segment'),
(7581, 'Posting'),
(7582, 'Posting Date'),
(7583, 'post{{posterior}}'),
(7584, 'Pos{{Abbreviation for Position}}'),
(7585, 'POS{{Past Ocular Surgery}}'),
(7586, 'Potential Acuity'),
(7587, 'Potential Acuity Meter'),
(7588, 'Powered by'),
(7589, 'PPE + Prev Med/Surg Hx'),
(7590, 'PQRI'),
(7591, 'PQRI Registry ID'),
(7592, 'PQRI Registry Name'),
(7593, 'Practice'),
(7594, 'Practice Default Setting'),
(7595, 'Practice Settings'),
(7596, 'Practice Settings (practice)'),
(7597, 'Practitioner'),
(7598, 'Pre Participation Assessment'),
(7599, 'Pre Pay'),
(7600, 'Pre Payment'),
(7601, 'Pre-Abortion Consultation'),
(7602, 'Pre-Abortion Counseling'),
(7603, 'Pre-payment Amount'),
(7604, 'Pref Cat'),
(7605, 'Preference'),
(7606, 'Preferences'),
(7607, 'Preferences updated successfully'),
(7608, 'Preferred Event Category'),
(7609, 'Preferred Language'),
(7610, 'Preferred Pharmacy'),
(7611, 'Preferred Provider Organization (PPO)'),
(7612, 'Preg Test'),
(7613, 'Preliminary'),
(7614, 'Preparing To Run Report'),
(7615, 'Prepay'),
(7616, 'Prepend Blank Row'),
(7617, 'Prescription'),
(7618, 'Prescription - lists the prescriptions of the current patient'),
(7619, 'prescription has reached its limit of'),
(7620, 'Prescription History'),
(7621, 'Prescription History import successfully completed'),
(7622, 'Prescription Label'),
(7623, 'Prescription Report'),
(7624, 'Prescription successfully removed.'),
(7625, 'Prescription Transmit Review'),
(7626, 'Prescriptions'),
(7627, 'Prescriptions (write,addonly optional)'),
(7628, 'Prescriptions (write,addonly optional) (rx)'),
(7629, 'Prescriptions and Dispensations'),
(7630, 'Prescriptions and other referrals'),
(7631, 'Prescriptions and/or referrals by specialist'),
(7632, 'Prescriptions Report'),
(7633, 'Prescriptions/Referrals'),
(7634, 'Present'),
(7635, 'Presenting Complaint'),
(7636, 'Presenting Issue(s)'),
(7637, 'Press Continue to proceed'),
(7638, 'Press the flashing button on the USB key within 1 minute of inserting it and click on register to register the key with OpenEMR'),
(7639, 'Press this icon to build your Impression/Plan.'),
(7640, 'Presumed Diagnosis'),
(7641, 'Presumed diagnosis by specialist'),
(7642, 'Prev'),
(7643, 'Prev Med/Surg Hx'),
(7644, 'Prev. month (hold for menu)'),
(7645, 'Prev. year (hold for menu)'),
(7646, 'Preventative Care'),
(7647, 'Prevention Rehab'),
(7648, 'Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention (CQM)'),
(7649, 'Preview Event'),
(7650, 'Preview file'),
(7651, 'Preview not available for this document type'),
(7652, 'Preview of'),
(7653, 'Previous'),
(7654, 'Previous Consultations'),
(7655, 'Previous Day'),
(7656, 'Previous History/Screening'),
(7657, 'Previous Month'),
(7658, 'Previous Week'),
(7659, 'Price'),
(7660, 'Price can be manually set or if already set can be altered here'),
(7661, 'Price changed'),
(7662, 'Price Discounting'),
(7663, 'Price Level'),
(7664, 'Price level changed'),
(7665, 'Price Level:'),
(7666, 'Pricelevel'),
(7667, 'Prices'),
(7668, 'Primary'),
(7669, 'Primary Business Entity'),
(7670, 'Primary Business Entity tax id is used as account id for NewCrop ePrescription. Changing the facility will affect the working in NewCrop.'),
(7671, 'Primary Business Entity tax id is used as the account id for NewCrop ePrescription.'),
(7672, 'Primary Care'),
(7673, 'Primary Care Provider'),
(7674, 'Primary Facility City'),
(7675, 'Primary Facility Country code'),
(7676, 'Primary Facility State'),
(7677, 'Primary Facility Street Address'),
(7678, 'Primary Facility Zip Code'),
(7679, 'Primary Ins'),
(7680, 'Primary Insurance'),
(7681, 'Primary Insurance Data'),
(7682, 'Primary Insurance Provider'),
(7683, 'Primary Provider'),
(7684, 'Print'),
(7685, 'Print (HTML)'),
(7686, 'Print (PDF)'),
(7687, 'Print Amendments'),
(7688, 'Print Any Encounter'),
(7689, 'Print Blank Referral Form'),
(7690, 'Print Command'),
(7691, 'Print Custom Message'),
(7692, 'Print Date'),
(7693, 'Print End of Day Report 1'),
(7694, 'Print End of Day Report 2'),
(7695, 'Print End of Day Report 3'),
(7696, 'Print Entire Listing'),
(7697, 'Print Format'),
(7698, 'Print Four Panel'),
(7699, 'Print Ledger'),
(7700, 'Print locally'),
(7701, 'Print message'),
(7702, 'Print Multiple'),
(7703, 'Print Multiple To Fax'),
(7704, 'Print name, sign and date.'),
(7705, 'Print Notes'),
(7706, 'Print Page 1'),
(7707, 'Print Page 2'),
(7708, 'Print Patient Address Label'),
(7709, 'Print Patient Billing Note'),
(7710, 'Print Receipts by Provider'),
(7711, 'Print Record'),
(7712, 'Print remotely'),
(7713, 'Print Report'),
(7714, 'Print Selected Statements'),
(7715, 'Print Shot Record'),
(7716, 'Print the Next Appointment on the Bottom of the Ledger'),
(7717, 'Print This Encounter'),
(7718, 'Print this form'),
(7719, 'Print this note'),
(7720, 'Print This Note'),
(7721, 'Print To'),
(7722, 'Print To Fax'),
(7723, 'Print View'),
(7724, 'printable'),
(7725, 'Printable Version'),
(7726, 'Printed'),
(7727, 'Printer'),
(7728, 'Printing Log Option'),
(7729, 'Printing results:'),
(7730, 'Printing skipped; see test output in'),
(7731, 'Printing skipped; see test output in '),
(7732, 'Prints the CMS 1500 on the Preprinted form'),
(7733, 'Prior Auth'),
(7734, 'Prior Authorization Form'),
(7735, 'Prior Exam'),
(7736, 'Prior Eye Meds'),
(7737, 'Prior IMP/PLAN'),
(7738, 'Prior Refractions'),
(7739, 'Prior Visit'),
(7740, 'Prior Visits'),
(7741, 'Priority'),
(7742, 'Priority '),
(7743, 'Prism'),
(7744, 'Prism Diopters'),
(7745, 'Prison Correctional Facility'),
(7746, 'Private'),
(7747, 'Problem'),
(7748, 'Problem DX'),
(7749, 'Problem List'),
(7750, 'Problems'),
(7751, 'Problems & Diagnoses'),
(7752, 'Problems/Issues'),
(7753, 'Proc Bat'),
(7754, 'Proc Cat'),
(7755, 'Proc Load'),
(7756, 'Proc Pending Rev'),
(7757, 'Proc Prov'),
(7758, 'Proc Res'),
(7759, 'Procedure'),
(7760, 'Procedure Body Sites'),
(7761, 'Procedure Body Sites - Arm, Buttock and Other - used for immunization - modify as needed'),
(7762, 'Procedure Boolean Results'),
(7763, 'Procedure Boolean Results - No and Yes'),
(7764, 'Procedure Code'),
(7765, 'Procedure Codes'),
(7766, 'Procedure Lateralities'),
(7767, 'Procedure Lateralities - Left, Right and Bilateral'),
(7768, 'Procedure Name'),
(7769, 'Procedure Note - 2010'),
(7770, 'Procedure Order'),
(7771, 'Procedure order'),
(7772, 'Procedure Order Details'),
(7773, 'Procedure Order for'),
(7774, 'Procedure order not found'),
(7775, 'procedure order not found in database contact tech support'),
(7776, 'Procedure Orders and Reports'),
(7777, 'Procedure Picker'),
(7778, 'Procedure provider'),
(7779, 'Procedure Provider'),
(7780, 'Procedure Provider Help'),
(7781, 'Procedure Providers'),
(7782, 'Procedure Report'),
(7783, 'Procedure Report Abnormal'),
(7784, 'Procedure Report Abnormal - No, Yes, High, Low Above upper panic limit and Below lower panic limit'),
(7785, 'Procedure Report Statuses'),
(7786, 'Procedure Report Statuses - Final, Reviewed, Preliminary, Canceled, Error and Corrected'),
(7787, 'Procedure Result Abnormal'),
(7788, 'Procedure Result Statuses'),
(7789, 'Procedure Result Statuses - Final, Preliminary, Canceled, Error, Corrected and Incomplete'),
(7790, 'Procedure Results'),
(7791, 'Procedure Routes'),
(7792, 'Procedure Routes - Injection, Oral and Other'),
(7793, 'Procedure Specimen Types'),
(7794, 'Procedure Specimen Types - Blood, Saliva, Urine and Other'),
(7795, 'Procedure Statistics Report'),
(7796, 'Procedure Test'),
(7797, 'Procedure Tier'),
(7798, 'Procedure Type'),
(7799, 'Procedure Types'),
(7800, 'Procedure Types - Group, Procedure Order, Discrete Result, Recommendation, Custom Favorite Group and Custom Favorite Item. Used in the next step - Configure the lab test structure'),
(7801, 'Procedure Units'),
(7802, 'Procedure Units - various units needed to define result values - may need to add to this list depending on the tests that are included, will vary according to need'),
(7803, 'Procedure/Service'),
(7804, 'Procedures'),
(7805, 'Proceeding to Preferences'),
(7806, 'Process'),
(7807, 'Process and Send Reminders'),
(7808, 'Process ERA File'),
(7809, 'Process New Files'),
(7810, 'Process new files for CSV records'),
(7811, 'Process Reminders'),
(7812, 'Process takes some time'),
(7813, 'Processed'),
(7814, 'Processed By'),
(7815, 'Processed Date'),
(7816, 'processed successfully'),
(7817, 'Processing'),
(7818, 'Processing and Sending Patient Reminders'),
(7819, 'Processing format'),
(7820, 'Processing Patient Reminders'),
(7821, 'Processing Time'),
(7822, 'Processing...'),
(7823, 'Product'),
(7824, 'Product added'),
(7825, 'Product Contraceptive Method'),
(7826, 'Product deleted'),
(7827, 'Production'),
(7828, 'Products'),
(7829, 'Products but no prescription drugs and no templates'),
(7830, 'Products Provided'),
(7831, 'Prof.'),
(7832, 'Profile'),
(7833, 'Profile Demographics'),
(7834, 'Profiles'),
(7835, 'Prog.{{Progressive lenses}}'),
(7836, 'Progress'),
(7837, 'Progress Note - 2010'),
(7838, 'Progress Notes'),
(7839, 'Progressive'),
(7840, 'Properties'),
(7841, 'Proprietary hardware tokens'),
(7842, 'Proprietary hardware tokens are tamper proof and are not connected to the internet or any network'),
(7843, 'Prostate Cancer'),
(7844, 'Prostate Cancer Screening'),
(7845, 'Prostate Exam'),
(7846, 'Prostate Problems'),
(7847, 'Prostate w/o enlrgmt, nodules, tender'),
(7848, 'Protection Indicator'),
(7849, 'Protection Indicator Effective Date'),
(7850, 'Protocol'),
(7851, 'Protocol - consists of two parts - the method used to send orders and receive results and whether it is used to receive results only or is used to send orders and receive result i.e. bidirectional'),
(7852, 'Provide absolute path'),
(7853, 'Provide absolute path of file'),
(7854, 'Provide clinical summaries for patients for each office visit (New).'),
(7855, 'Provide clinical summaries for patients for each office visit.'),
(7856, 'Provide Password for'),
(7857, 'Provide patients with an electronic copy of their health information (including diagnostic test results, problem list, medication lists, medication allergies), upon request.'),
(7858, 'Provide patients with timely electronic access to their health information (including lab results, problem list, medication lists, medication allergies) within four business days of the information being available to the EP.'),
(7859, 'Provide Records to Patient for Visit'),
(7860, 'Provide TOTP code'),
(7861, 'Provide valid Email Address'),
(7862, 'Provided Clinical Summary?'),
(7863, 'Provided Education Resource(s)?'),
(7864, 'Provider'),
(7865, 'provider'),
(7866, 'Provider Access'),
(7867, 'Provider Dashboard'),
(7868, 'Provider Id'),
(7869, 'Provider ID'),
(7870, 'Provider ID at Specified Facility'),
(7871, 'Provider Matching Errors'),
(7872, 'Provider Missing Add one in Choices'),
(7873, 'provider name'),
(7874, 'Provider not available, please choose another.'),
(7875, 'Provider not available, use it anyway?'),
(7876, 'Provider Number'),
(7877, 'Provider Number (Type)'),
(7878, 'Provider Qualifier Code'),
(7879, 'Provider Relationship'),
(7880, 'Provider Type'),
(7881, 'Provider/Warehouse'),
(7882, 'Provider:'),
(7883, 'Providers'),
(7884, 'Providers NPI'),
(7885, 'Providers See Entire Calendar'),
(7886, 'Prv'),
(7887, 'PSA'),
(7888, 'Psoriasis'),
(7889, 'Psych'),
(7890, 'Psych Diagnosis'),
(7891, 'Psych Medication'),
(7892, 'Psychiatric'),
(7893, 'Psychiatric Brief Letter'),
(7894, 'Psychiatric Diagnosis'),
(7895, 'Psychiatric Examination'),
(7896, 'Psychiatric Facility-Partial Hospitalization'),
(7897, 'Psychiatric History'),
(7898, 'Psychiatric Intake'),
(7899, 'Psychiatric Medication'),
(7900, 'Psychiatric Residential Treatment Center'),
(7901, 'Psych{{psychiatric}}'),
(7902, 'PSYCH{{Psychiatry}}'),
(7903, 'Pt %'),
(7904, 'Pt Debt'),
(7905, 'Pt Notes'),
(7906, 'Pt Notes/Auth'),
(7907, 'Pt overpaid'),
(7908, 'Pt Paid'),
(7909, 'Pt Rec Request'),
(7910, 'Pt refund'),
(7911, 'Pt released'),
(7912, 'Pt Report'),
(7913, 'PT Student, or leave blank'),
(7914, 'PT_CITY'),
(7915, 'PT_DOB'),
(7916, 'PT_EMAIL'),
(7917, 'PT_FNAME'),
(7918, 'PT_LNAME'),
(7919, 'PT_MNAME'),
(7920, 'PT_PHONE_CELL'),
(7921, 'PT_PHONE_HOME'),
(7922, 'PT_POSTAL'),
(7923, 'PT_SSN'),
(7924, 'PT_STATE'),
(7925, 'PT_STREET'),
(7926, 'Pubid'),
(7927, 'Public'),
(7928, 'Public Agency'),
(7929, 'Public Health Clinic'),
(7930, 'Public health physician'),
(7931, 'Public Health Service (PHS) or Other Federal Agency'),
(7932, 'Public Patient Id'),
(7933, 'Publicity Code'),
(7934, 'Publicity Code Effective Date'),
(7935, 'Publish'),
(7936, 'Publish Patient to FHIR Server'),
(7937, 'Pubpid'),
(7938, 'Puerto Rican'),
(7939, 'puff'),
(7940, 'Pulmonary'),
(7941, 'PULM{{Pulmonary}}'),
(7942, 'Pulse'),
(7943, 'Punjabi'),
(7944, 'Pupils'),
(7945, 'Purchase'),
(7946, 'Purchase/Return'),
(7947, 'Purchases'),
(7948, 'px'),
(7949, 'Pyschiatry'),
(7950, 'P{{Justify Header}}'),
(7951, 'Pāli'),
(7952, 'q.3h'),
(7953, 'q.4h'),
(7954, 'q.5h'),
(7955, 'q.6h'),
(7956, 'q.8h'),
(7957, 'q.d.'),
(7958, 'q.i.d.'),
(7959, 'QHD'),
(7960, 'QOE'),
(7961, 'QOH'),
(7962, 'QOH is less than monthly usage'),
(7963, 'Qty'),
(7964, 'QTY'),
(7965, 'Quality'),
(7966, 'Quality Measures (CQM)'),
(7967, 'Quantity'),
(7968, 'Quantity changed'),
(7969, 'Quantity for NDC'),
(7970, 'Quantity On Hand'),
(7971, 'quantity seems unusable'),
(7972, 'Quantity:'),
(7973, 'Quechua'),
(7974, 'Query Error'),
(7975, 'Question Mark'),
(7976, 'Queue for HCFA batch processing'),
(7977, 'Queue for HCFA batch processing and printing'),
(7978, 'Queue for UB-92 batch processing'),
(7979, 'Queue for UB-92 batch processing and printing'),
(7980, 'Queued'),
(7981, 'Queued Events Administration'),
(7982, 'Queued for'),
(7983, 'Queued for Transfer'),
(7984, 'Queued Submissions Administration'),
(7985, 'Quick Picks'),
(7986, 'Quit'),
(7987, 'Quit Alcohol'),
(7988, 'QWXGA'),
(7989, 'R'),
(7990, 'R/LG{{right/left gonioscopy}}'),
(7991, 'R/LPACH{{right/left pachymetry}}'),
(7992, 'R/LSCH1{{right/left Schirmers I (w/o anesthesia)}}'),
(7993, 'R/LSCH2{{right/left Schirmers II (w/ anesthesia)}}'),
(7994, 'R/LTBUT{{right/left Tear Break Up Time}}'),
(7995, 'RA for Patient, Encounter, or Trace'),
(7996, 'Race'),
(7997, 'Race and Ethnicity'),
(7998, 'Race/Ethnicity'),
(7999, 'RAC{{right anterior chamber}}'),
(8000, 'Radio'),
(8001, 'Radio buttons'),
(8002, 'Radio Group Master'),
(8003, 'Radio Group Member'),
(8004, 'RAD{{right adnexa}}'),
(8005, 'Random Drug Screen'),
(8006, 'Range'),
(8007, 'Rashes'),
(8008, 'Rate'),
(8009, 'Rather than granting access to each ACO individually for each user the program grants access to groups that request these privileges. These groups are called Access Request Objects (ARO).'),
(8010, 'Ratio'),
(8011, 'Raw Report'),
(8012, 'RB{{right brow}}'),
(8013, 'RCMT{{right Central Macular Thickness}}'),
(8014, 'RCOM{{right comments}}'),
(8015, 'RCUP{{right cup}}'),
(8016, 'RC{{right conjunctiva}}'),
(8017, 'RD{{retinal detachment}}'),
(8018, 'RD{{right disc}}'),
(8019, 'Re Identification'),
(8020, 'Re Identification Process is completed'),
(8021, 'Re Identification Process is ongoing'),
(8022, 'Re-identification files will be saved in'),
(8023, 'Re-Injury?'),
(8024, 'Re-Open'),
(8025, 'Re-Open Visit'),
(8026, 'Re-opened'),
(8027, 'Re-opening this visit will cause a void. Payment information will need to be re-entered. Do you want to proceed?'),
(8028, 'Reaction'),
(8029, 'Reaction - hives, nausea, shortness of breath or unassigned'),
(8030, 'Reactions'),
(8031, 'Reactivate'),
(8032, 'react{{reactivity}}'),
(8033, 'Read'),
(8034, 'Read Only'),
(8035, 'Read the help file there to understand the initial pre-configuration steps'),
(8036, 'Read these two wiki articles for customizing the Fee Sheet'),
(8037, 'Read this wiki page for more details'),
(8038, 'Read through this help file and its supporting documents before you start to configure the orders and results'),
(8039, 'Read-only from History'),
(8040, 'Real Name'),
(8041, 'Really delete'),
(8042, 'Reason'),
(8043, 'Reason Deceased'),
(8044, 'Reason for Death'),
(8045, 'Reason for Referral'),
(8046, 'Reason for referral'),
(8047, 'Reason for visit'),
(8048, 'Reason for Visit'),
(8049, 'Reason/Form'),
(8050, 'Reason/Plan'),
(8051, 'Recall'),
(8052, 'Recall Board'),
(8053, 'RECALL BOARD - Default - without MedEx Communication Service'),
(8054, 'Recall Board: Disable'),
(8055, 'Recall Campaigns'),
(8056, 'Recall only - any method'),
(8057, 'Recall only - no calls'),
(8058, 'Recall Reason'),
(8059, 'Recall Schedule'),
(8060, 'Recall to provider'),
(8061, 'Recall When'),
(8062, 'Recalls'),
(8063, 'Receipt'),
(8064, 'Receipt for Payment'),
(8065, 'Receipt Generated'),
(8066, 'Receipts by Payment Method Report'),
(8067, 'Receipts Summary'),
(8068, 'Received'),
(8069, 'Received By'),
(8070, 'Received Faxes'),
(8071, 'Received messages are processed and a new Patient Note is delivered to a specified user and appears in that user\'s Message Center'),
(8072, 'Received, not reviewed'),
(8073, 'Received, unreviewed'),
(8074, 'Receiver'),
(8075, 'Receiver ID'),
(8076, 'Receiver ID (ISA08)'),
(8077, 'Receiver ID Qualifier (ISA07)'),
(8078, 'Receiver IDs'),
(8079, 'Receiver IDs - is only required if you are submitting an electronic order to an external facility'),
(8080, 'RECEIVING A MESSAGE'),
(8081, 'Receiving Fac.'),
(8082, 'Recent three passwords are not allowed.'),
(8083, 'Recently Completed'),
(8084, 'Recipient'),
(8085, 'Recipient List Is Empty'),
(8086, 'Recipient Name'),
(8087, 'Recipient of the Disclosure'),
(8088, 'Recipient required unless status is Done'),
(8089, 'Recommendation'),
(8090, 'Recommendation - Optional'),
(8091, 'Recommendation For Follow Up'),
(8092, 'Recommendations'),
(8093, 'Recommendations and treatment'),
(8094, 'Recommendations by specialist'),
(8095, 'RECORD'),
(8096, 'Record'),
(8097, 'Record already exist'),
(8098, 'Record and chart changes in vital signs ( Height / Weight / BP with in scope ).'),
(8099, 'Record and chart changes in vital signs (BP out of scope).'),
(8100, 'Record and chart changes in vital signs (Height / Weight out of scope).'),
(8101, 'Record and chart changes in vital signs (New).'),
(8102, 'Record and chart changes in vital signs (SET 1).'),
(8103, 'Record and chart changes in vital signs.'),
(8104, 'Record demographics.'),
(8105, 'Record Disclosure'),
(8106, 'Record of Fitness'),
(8107, 'Record Payment'),
(8108, 'Record Request'),
(8109, 'Record Request Date'),
(8110, 'Record smoking status for patients 13 years old or older.'),
(8111, 'Records'),
(8112, 'records found'),
(8113, 'records found.'),
(8114, 'records per page'),
(8115, 'Recreational drug use'),
(8116, 'Recreational Drugs'),
(8117, 'Rectal'),
(8118, 'Rectal Exam'),
(8119, 'rectally'),
(8120, 'Rectangle'),
(8121, 'Recurrence'),
(8122, 'Recurrent Appointment Display Widget'),
(8123, 'Recurrent Appointments'),
(8124, 'Recurrent Appointments - shows all recurring appointments'),
(8125, 'Red Desaturation'),
(8126, 'Red Desat{{red desaturation}}'),
(8127, 'Red lines  indicate errors, or changes that were not applied; these must be processed manually. Currently denied claims and payment reversals are not handled automatically and so will appear in red.'),
(8128, 'Red Triangle indicates a required code that is missing'),
(8129, 'Redirection'),
(8130, 'Redness'),
(8131, 'Redo'),
(8132, 'reduced:'),
(8133, 'Ref Prov'),
(8134, 'Refer'),
(8135, 'Refer By'),
(8136, 'Refer Date'),
(8137, 'Refer To'),
(8138, 'Refer to Message'),
(8139, 'Reference classification (risk level)'),
(8140, 'Reference range of results'),
(8141, 'Reference Reason'),
(8142, 'Reference this Account Id: '),
(8143, 'Referer'),
(8144, 'Referer name and signature'),
(8145, 'Referral'),
(8146, 'Referral By'),
(8147, 'Referral Card'),
(8148, 'Referral Date'),
(8149, 'Referral Form'),
(8150, 'REFERRAL FORM'),
(8151, 'Referral ID'),
(8152, 'Referral Provider'),
(8153, 'Referral Reason'),
(8154, 'Referral Source'),
(8155, 'Referral Source for Encounters'),
(8156, 'Referral To'),
(8157, 'Referrals'),
(8158, 'Referrals Report'),
(8159, 'Referred by'),
(8160, 'Referred By'),
(8161, 'Referred By, Outcome and Destination can be left blank'),
(8162, 'Referred to'),
(8163, 'Referrer'),
(8164, 'Referrer Address'),
(8165, 'Referrer Diagnosis'),
(8166, 'Referrer diagnosis'),
(8167, 'Referrerid'),
(8168, 'Referring physician and practice'),
(8169, 'Referring provider'),
(8170, 'Referring Provider'),
(8171, 'ReFill'),
(8172, 'Refill'),
(8173, 'Refill Rx'),
(8174, 'Refills'),
(8175, 'refills'),
(8176, 'Reflexes normal'),
(8177, 'Refraction Comments'),
(8178, 'Refraction Method'),
(8179, 'Refractive States'),
(8180, 'Refresh'),
(8181, 'Refresh Screen'),
(8182, 'Refresh the Message Center or just reopen it'),
(8183, 'Refreshing Reminders'),
(8184, 'Refund'),
(8185, 'Refused'),
(8186, 'Refused To State'),
(8187, 'reg_re'),
(8188, 'regarding'),
(8189, 'regarding appointment dated'),
(8190, 'Register'),
(8191, 'register'),
(8192, 'Register Time Based One Time Password Key'),
(8193, 'Register TOTP Key for'),
(8194, 'Register U2F Key for'),
(8195, 'Register Universal 2nd Factor Key'),
(8196, 'Register your installation with OEMR to receive important notifications, such as security fixes and new release announcements.'),
(8197, 'Registered'),
(8198, 'registered'),
(8199, 'Registered email'),
(8200, 'Registered id'),
(8201, 'Registered Modules'),
(8202, 'Registration Date'),
(8203, 'Registration error'),
(8204, 'Registration failed with error'),
(8205, 'Registration Form'),
(8206, 'Rehabilitation'),
(8207, 'Rehabilitation physician'),
(8208, 'Rejected'),
(8209, 'Relapse Potential'),
(8210, 'Relate To'),
(8211, 'Related'),
(8212, 'Related Issue'),
(8213, 'Related Patient Notes'),
(8214, 'Relation(s) / Children'),
(8215, 'Relations'),
(8216, 'Relationship'),
(8217, 'Relative ordering of this entity'),
(8218, 'Relatives'),
(8219, 'Relatives - lists the patient relatives having various medical conditions like Cancer, Diabetes, Hypertension etc'),
(8220, 'Relatives Blood Pressure'),
(8221, 'Relatives Cancer'),
(8222, 'Relatives Diabetes'),
(8223, 'Relatives Epilepsy'),
(8224, 'Relatives Heart'),
(8225, 'Relatives Mental Illness'),
(8226, 'Relatives Stroke'),
(8227, 'Relatives Suicide'),
(8228, 'Relatives Tuberculosis'),
(8229, 'Relay Health credentials are missing from this user account.'),
(8230, 'Relay Health ID'),
(8231, 'Release'),
(8232, 'Release Date'),
(8233, 'Relevant for insurance claim submission in the United States'),
(8234, 'Religion'),
(8235, 'Religious Affiliation'),
(8236, 'Religious exemption'),
(8237, 'Reload'),
(8238, 'reload names below'),
(8239, 'Relogin'),
(8240, 'Remdr'),
(8241, 'Remember grouping of tests is only for conveniently organizing the data in the Procedure Order module in openEMR, for this process to work, configuring the Procedure Orders (the tests themselves) and the Discrete Result (the place to enter and display the returned result) are critically important'),
(8242, 'Remember Selected Facility'),
(8243, 'Remember the dictum that Identifying codes have to be unique, you should not set up a custom grouping of a panel of tests as well have the panels setup as individual recognized panel, i.e. have CBC and Renal panel grouped as a Custom Favorite and list CBC and Renal Panel separately as individually ordered panels'),
(8244, 'Remember these Discrete Results or fruit (Tier 4)  will have to hang off the fruit bearing branch or Procedure Order namely Electrolyte Panel (Tier 3)'),
(8245, 'Reminder'),
(8246, 'Reminder Campaigns'),
(8247, 'Reminder done'),
(8248, 'Reminder intervals'),
(8249, 'Reminder Not Sent Yet'),
(8250, 'Reminder only - any method'),
(8251, 'Reminder only - no calls'),
(8252, 'Reminder Sent'),
(8253, 'Reminder Sent On'),
(8254, 'Reminder to provider'),
(8255, 'Reminder/recall - any method'),
(8256, 'Reminder/recall - no calls'),
(8257, 'Reminder/recall - to provider'),
(8258, 'Reminders'),
(8259, 'REMIT TO'),
(8260, 'Remote Host'),
(8261, 'Remote Host - is only required if you are submitting an electronic order to an external facility or just receiving results from it'),
(8262, 'Remove'),
(8263, 'Remove all rules from plan'),
(8264, 'Remove Bottom Pane'),
(8265, 'REMOVE GROUP'),
(8266, 'Remove Group'),
(8267, 'Remove Group Form'),
(8268, 'Remove multi-factor authentications for this person.'),
(8269, 'Remove Tab'),
(8270, 'Remove this Prescription from the list of RXs dispensed'),
(8271, 'Removes support for immunizations'),
(8272, 'Removes support for phpMyAdmin'),
(8273, 'Removes support for prescriptions'),
(8274, 'Removes the bottom pane by default on start up.'),
(8275, 'Removes the Chart Tracker feature'),
(8276, 'Renal Stones'),
(8277, 'Rename'),
(8278, 'Rename Group'),
(8279, 'Rendering'),
(8280, 'Rendering Provider'),
(8281, 'Rendering Provider Number'),
(8282, 'Rendering Provider Number (Type)'),
(8283, 'Reorder'),
(8284, 'Reorder At'),
(8285, 'Reorder point has been reached'),
(8286, 'Reorder point, 0 if not applicable'),
(8287, 'Rep'),
(8288, 'Repeat'),
(8289, 'Repeat New Password'),
(8290, 'Repeat password'),
(8291, 'Repeating event'),
(8292, 'Repeating Info:'),
(8293, 'Repeats'),
(8294, 'REPLACE'),
(8295, 'Replace'),
(8296, 'Replace entire code set'),
(8297, 'Replace the existing group and option values with these ones taking care to match the E/M codes'),
(8298, 'Replace the hostname and port with the values provided to you by EMR Direct'),
(8299, 'replaced'),
(8300, 'Replies'),
(8301, 'Replies from patients are displayed directly in your EHR'),
(8302, 'Replies retrieved'),
(8303, 'Reply'),
(8304, 'Reply Date'),
(8305, 'Reply From'),
(8306, 'Reply to this message'),
(8307, 'Report'),
(8308, 'report'),
(8309, 'Report - Clinical'),
(8310, 'Report - Generates and downloads the patient\'s Continuity of Care Record (CCR), Continuity of Care Document (CCD) and Patient Report'),
(8311, 'Report - Patient List Creation'),
(8312, 'Report by'),
(8313, 'Report Content'),
(8314, 'Report Date'),
(8315, 'Report End (Relinquished Care Date)'),
(8316, 'Report has been sent to the patient.'),
(8317, 'Report History/Results'),
(8318, 'Report of visit'),
(8319, 'Report Results'),
(8320, 'Report Results/History'),
(8321, 'Report Start (Assumed Care Date)'),
(8322, 'Report Status'),
(8323, 'Report Totals'),
(8324, 'Report was faxed. Click to view.'),
(8325, 'Report/ Form'),
(8326, 'Report?'),
(8327, 'Reportable'),
(8328, 'Reported'),
(8329, 'Reported Date'),
(8330, 'Reports'),
(8331, 'Reports consisting of various portions of the patient\'s medical record can be created here'),
(8332, 'Request & Response'),
(8333, 'Request Content Fails Integrity Test'),
(8334, 'Request Description'),
(8335, 'Request Eligibility'),
(8336, 'Request ID is missing!'),
(8337, 'Request ignored - claims processing is already running!'),
(8338, 'Request Message'),
(8339, 'Request New Appointment'),
(8340, 'Request Only'),
(8341, 'Request Status'),
(8342, 'Request Type'),
(8343, 'Request type not implemented'),
(8344, 'request was received from portal patient'),
(8345, 'Requested By'),
(8346, 'Requested Date'),
(8347, 'Requested Service'),
(8348, 'Requested template does not exist'),
(8349, 'Requests Sent'),
(8350, 'Require Audit'),
(8351, 'Require Strong Passwords'),
(8352, 'Require Unique Passwords'),
(8353, 'Required'),
(8354, 'Required Co Pay'),
(8355, 'Required Field Missing: Please choose the EDI-271 file to upload'),
(8356, 'Required field missing: Please enter the First name'),
(8357, 'Required field missing: Please enter the Last name'),
(8358, 'Required field missing: Please enter the User Name'),
(8359, 'Required fields'),
(8360, 'Requirements'),
(8361, 'Requisition Number'),
(8362, 'RESERVED'),
(8363, 'Reserved'),
(8364, 'Reserved for use to define Scheduled Vacation Time'),
(8365, 'Reserved to define when a provider may not have available appointments after.'),
(8366, 'Reserved to define when an event did not occur as specified.'),
(8367, 'Reserved todefine when a provider may haveavailable appointments after.'),
(8368, 'Reset'),
(8369, 'Reset button resets the edited claim to the fee sheet version. If subsequently saved, it will replace last claim version and be considered reviewed. Otherwise, claim is reset to fee sheet version.'),
(8370, 'Reset claim form to Fee Sheet Version'),
(8371, 'Reset Credentials'),
(8372, 'Reset Offsite Portal Credentials'),
(8373, 'Reset Online Portal Credentials'),
(8374, 'Reset Onsite Portal Credentials'),
(8375, 'Reset to no patient'),
(8376, 'Reset Version'),
(8377, 'Resident physician'),
(8378, 'Residential Substance Abuse Treatment Facility'),
(8379, 'Resist the temptation to start entering data in an unorganized manner'),
(8380, 'Resn'),
(8381, 'Resolve Orphan Results'),
(8382, 'Resolved'),
(8383, 'Resource (select one)'),
(8384, 'Resources'),
(8385, 'Respiration'),
(8386, 'Respirator effort unlabored'),
(8387, 'Respiratory'),
(8388, 'Response'),
(8389, 'Response Only'),
(8390, 'Responsible Party'),
(8391, 'Responsive Vertical Menu Style for Tabs'),
(8392, 'Restore'),
(8393, 'Restore Archive'),
(8394, 'Restrict non-authorized users to the Schedule Facilities set in User admin.'),
(8395, 'Restrict Users to Facilities'),
(8396, 'Restricted Training'),
(8397, 'Result'),
(8398, 'Result Name'),
(8399, 'Result Status'),
(8400, 'Result status or abnormality is missing'),
(8401, 'Result, use % as a wildcard'),
(8402, 'Results'),
(8403, 'Results and'),
(8404, 'Results Found For Search'),
(8405, 'Results Group'),
(8406, 'Results Only'),
(8407, 'Results Path'),
(8408, 'Results Path - is only required if you are submitting an electronic order to an external facility or just receiving results from it'),
(8409, 'Results per page'),
(8410, 'Results/Details'),
(8411, 'Retina'),
(8412, 'Retina Default Values'),
(8413, 'Retinal Exam'),
(8414, 'Retracted Right:'),
(8415, 'Return'),
(8416, 'Return above part with your payment'),
(8417, 'Return button simply returns, then refreshes billing manager'),
(8418, 'Return Home'),
(8419, 'Return to calendar'),
(8420, 'Return To Report Results'),
(8421, 'Return to this page and you will be able to complete the ICD10 installation process by clicking on the ICD10 section header'),
(8422, 'Return to this page and you will be able to complete the ICD9 installation process by clicking on the ICD9 section header'),
(8423, 'Return to this page and you will be able to complete the RxNorm installation process by clicking on the RXNORM section header'),
(8424, 'Return to this page and you will be able to complete the Snomed installation process by clicking on the SNOMED section header'),
(8425, 'Return to this page and you will be able to complete the Valueset installation process by clicking on the VALUESET section header'),
(8426, 'Return Value'),
(8427, 'Return Visit'),
(8428, 'Returned to Play'),
(8429, 'Reuse of three previous passwords not allowed!'),
(8430, 'Revenue'),
(8431, 'Revenue Code'),
(8432, 'Revenue Code for this item. Type for hints/search'),
(8433, 'Revenue Code for this item. Type to search or double click for list'),
(8434, 'Revert'),
(8435, 'Revert Edits'),
(8436, 'Review'),
(8437, 'Review & Approve'),
(8438, 'Review all the parameters that are entered and only then move to the next step. This is because once you create a group (ARO) you will NOT be able of modify any of the data that you have entered in THIS section. You can only delete the entire group (ARO) and start afresh.'),
(8439, 'Review and Approve'),
(8440, 'Review Audits'),
(8441, 'Review of PMH:'),
(8442, 'Review of System'),
(8443, 'Review Of Systems'),
(8444, 'Review of Systems Checks'),
(8445, 'Review Status'),
(8446, 'Review UB04'),
(8447, 'Reviewed'),
(8448, 'Reviewed Date'),
(8449, 'Revise'),
(8450, 'Revision'),
(8451, 'Rheumatoid Arthritis'),
(8452, 'Rheumotoid Arthritis'),
(8453, 'RH{{right hertel measurement}}'),
(8454, 'Right'),
(8455, 'Right Arm'),
(8456, 'Right Deltoid'),
(8457, 'Right Ear'),
(8458, 'right ear'),
(8459, 'Right Gluteus Medius'),
(8460, 'Right Lens'),
(8461, 'Right Lower Forearm'),
(8462, 'Right Margin (mm)'),
(8463, 'Right Thigh'),
(8464, 'Right Vastus Lateralis'),
(8465, 'Right:'),
(8466, 'Ringing in Ears'),
(8467, 'Ringing In Ears'),
(8468, 'Risk Category Assessment'),
(8469, 'Risk Factors'),
(8470, 'Risk Level'),
(8471, 'Risky Beh.'),
(8472, 'RI{{right iris}}'),
(8473, 'RK{{right cornea}}'),
(8474, 'RLL:'),
(8475, 'RLL{{right lower eyelid}}'),
(8476, 'RL{{right lens}}'),
(8477, 'RMAC{{right macula}}'),
(8478, 'RMC{{right medial canthus}}'),
(8479, 'ROM'),
(8480, 'Romanian'),
(8481, 'Romansh'),
(8482, 'Room 1'),
(8483, 'Room 2'),
(8484, 'Room 3'),
(8485, 'Room Number'),
(8486, 'Roommate'),
(8487, 'Roster'),
(8488, 'ROS{{Review of Systems}}'),
(8489, 'Round and Reactive'),
(8490, 'Route'),
(8491, 'Route of administration, if applicable'),
(8492, 'Routed'),
(8493, 'Rows'),
(8494, 'RP{{right peripheral retina}}'),
(8495, 'RRR without MOR'),
(8496, 'Rub:'),
(8497, 'Rubs:'),
(8498, 'Rule'),
(8499, 'Rule Add'),
(8500, 'Rule Detail'),
(8501, 'Rule Developer'),
(8502, 'Rule Edit'),
(8503, 'Rule Funding Source'),
(8504, 'Rule Release'),
(8505, 'Rule Set'),
(8506, 'Rule Set and Plan Set selections are not consistent. Please fix and Submit again.'),
(8507, 'Rule Title'),
(8508, 'Rules'),
(8509, 'rules already in plan'),
(8510, 'Rules Configuration'),
(8511, 'RUL{{right upper eyelid}}'),
(8512, 'Run Setup again or contact support for assistance'),
(8513, 'Running Command: '),
(8514, 'Rupture'),
(8515, 'Rural Health Clinic'),
(8516, 'Russian'),
(8517, 'RVIT{{right vitreous}}'),
(8518, 'RV{{right vessels}}'),
(8519, 'Rx'),
(8520, 'RX'),
(8521, 'Rx Bottom Margin (px)'),
(8522, 'RX Date'),
(8523, 'Rx Details'),
(8524, 'Rx Dispensed History'),
(8525, 'Rx Enable DEA #'),
(8526, 'Rx Enable NPI'),
(8527, 'Rx Enable State Lic. #'),
(8528, 'Rx History'),
(8529, 'Rx html print - zend module'),
(8530, 'Rx ID'),
(8531, 'Rx Left Margin (px)'),
(8532, 'Rx Log'),
(8533, 'Rx NLM Drug-Drug'),
(8534, 'Rx Paper Size'),
(8535, 'Rx pdf - zend template'),
(8536, 'RX Print Date'),
(8537, 'Rx Right Margin (px)'),
(8538, 'Rx Show DEA #'),
(8539, 'Rx Show NPI'),
(8540, 'Rx Show State Lic. #'),
(8541, 'Rx Top Margin (px)'),
(8542, 'Rx Type'),
(8543, 'Rx Type{{Type of glasses prescription}}'),
(8544, 'Rx/Distance'),
(8545, 'RXCUI Medication'),
(8546, 'RxNorm'),
(8547, 'RxNorm Database'),
(8548, 'R{{History of Refraction}}'),
(8549, 'R{{right side}}'),
(8550, 'R{{right}}'),
(8551, 'S'),
(8552, 'S.S.'),
(8553, 'S3:'),
(8554, 'S4:'),
(8555, 'SA  *  * To read the license please read the docs/license.txt or visit  * http://www.gnu.org/copyleft/gpl.html  *  */  //========================================================================= // '),
(8556, 'Safe key database'),
(8557, 'Sale'),
(8558, 'Sales'),
(8559, 'Sales by Item'),
(8560, 'Sales by Product Report'),
(8561, 'Saliva'),
(8562, 'Same Day'),
(8563, 'Samoan'),
(8564, 'Sample'),
(8565, 'Sanction Type'),
(8566, 'Sango'),
(8567, 'Sanskrit (Samskrta)'),
(8568, 'Sanskrit (Saṁskṛta)'),
(8569, 'Sardinian'),
(8570, 'Sat'),
(8571, 'Sat &amp; Sun'),
(8572, 'Saturday'),
(8573, 'Save'),
(8574, 'SAVE'),
(8575, 'Save & Exit'),
(8576, 'Save Activity'),
(8577, 'Save and Checkout'),
(8578, 'Save and Close'),
(8579, 'Save and Continue'),
(8580, 'Save and Delete Request'),
(8581, 'Save and Dispense'),
(8582, 'Save and Print'),
(8583, 'Save and Transmit'),
(8584, 'Save as New'),
(8585, 'Save as new message'),
(8586, 'Save as new note'),
(8587, 'Save button saves claim and marks reviewed'),
(8588, 'Save Category'),
(8589, 'Save Certificate Settings'),
(8590, 'Save Changes'),
(8591, 'Save Claim'),
(8592, 'Save claim for batch processing'),
(8593, 'Save codes history'),
(8594, 'Save Completed'),
(8595, 'Save Current'),
(8596, 'Save for printing to a pre printed sheet'),
(8597, 'Save for printing with form'),
(8598, 'Save Form'),
(8599, 'Save Immunization'),
(8600, 'Save New Field'),
(8601, 'Save New Group'),
(8602, 'Save New List'),
(8603, 'Save new template'),
(8604, 'Save omission selections'),
(8605, 'Save Patient Demographics'),
(8606, 'Save Payer'),
(8607, 'Save Report as PDF'),
(8608, 'Save Successful'),
(8609, 'Save Successful for chart ID'),
(8610, 'Save to Chart'),
(8611, 'Save Transaction'),
(8612, 'Saved Successfully'),
(8613, 'Saved to Documents->Onsite Portal->Reviewed - Open there to move or rename.'),
(8614, 'Saving denied'),
(8615, 'Sa{{Saturday}}'),
(8616, 'sc Distance{{without correction distance}}'),
(8617, 'sc Near{{without correction near}}'),
(8618, 'Scan the following QR code with your preferred authenticator app to register a new TOTP key.'),
(8619, 'Scanned'),
(8620, 'Scanned Encounter Note'),
(8621, 'Scanner Directory'),
(8622, 'Scanner In'),
(8623, 'scDist{{ACT without Correction Distance}}'),
(8624, 'scDist{{without correction distance}}'),
(8625, 'Schedule'),
(8626, 'Schedule Facilities:'),
(8627, 'Schedule New Appointment'),
(8628, 'Scheduled'),
(8629, 'Scheduling'),
(8630, 'Schirmer I'),
(8631, 'Schirmer II'),
(8632, 'Schirmers I'),
(8633, 'Schirmers I (w/o anesthesia)'),
(8634, 'Schirmers II'),
(8635, 'Schirmers II (w/ anesthesia)'),
(8636, 'School'),
(8637, 'SCHOOL NOTE'),
(8638, 'School Record'),
(8639, 'Sclera'),
(8640, 'scNear{{ACT without Correction Near}}'),
(8641, 'scNear{{without correction near}}'),
(8642, 'Scoliosis'),
(8643, 'Scottish Gaelic- Gaelic'),
(8644, 'Screen'),
(8645, 'Screening / Testing'),
(8646, 'SC{{Acuity without correction}}'),
(8647, 'sc{{without correction}}'),
(8648, 'SC{{without correction}}'),
(8649, 'SE'),
(8650, 'SE Address'),
(8651, 'SE City'),
(8652, 'SE Country'),
(8653, 'SE Locality'),
(8654, 'SE Postal Code'),
(8655, 'SE State'),
(8656, 'SE Zip Code'),
(8657, 'Search'),
(8658, 'SEARCH'),
(8659, 'search'),
(8660, 'search again'),
(8661, 'Search all columns'),
(8662, 'Search and select a patient and click OK'),
(8663, 'Search Appointment'),
(8664, 'Search by'),
(8665, 'Search by:'),
(8666, 'Search Diagnoses'),
(8667, 'Search for'),
(8668, 'Search for Additional Codes'),
(8669, 'Search for the drug by typing its name in the Search for Allergy text-box'),
(8670, 'Search for:'),
(8671, 'Search global settings'),
(8672, 'Search In'),
(8673, 'Search in'),
(8674, 'Search Not Available'),
(8675, 'Search or Add Patient'),
(8676, 'Search Payment'),
(8677, 'Search Payments'),
(8678, 'Search Products'),
(8679, 'Search Results'),
(8680, 'Search Results:'),
(8681, 'Search Selected'),
(8682, 'Search Services'),
(8683, 'Search string does not match with list in database'),
(8684, 'Search string should have at least three characters'),
(8685, 'search term was not found, please try another search'),
(8686, 'Search Text'),
(8687, 'Search the Events'),
(8688, 'Search user settings'),
(8689, 'Search with exact method'),
(8690, 'Search/Add'),
(8691, 'Search/Add Insurer'),
(8692, 'Searching'),
(8693, 'Searching for appointments'),
(8694, 'Searching...'),
(8695, 'Seatbelt'),
(8696, 'Seatbelt use'),
(8697, 'Seatbelt Use'),
(8698, 'Second'),
(8699, 'second'),
(8700, 'Second account message'),
(8701, 'Secondary'),
(8702, 'Secondary billing'),
(8703, 'Secondary Insurance'),
(8704, 'Secondary Insurance Data'),
(8705, 'Secondary Insurance Provider'),
(8706, 'Secondary Medicare Type'),
(8707, 'seconds'),
(8708, 'Section ID'),
(8709, 'Section ID and Name Cannot be Empty'),
(8710, 'Section Name'),
(8711, 'Section saved successfully'),
(8712, 'Secure Chat'),
(8713, 'Secure Electronic Messaging'),
(8714, 'Secure File Transfer Protocol, or SFTP is a network protocol that provides file access, file transfer, and file management over a secure connection'),
(8715, 'Secure Messaging'),
(8716, 'Secure Password Required'),
(8717, 'Secure Patient Chat'),
(8718, 'Secure Upload Files with White List'),
(8719, 'Security'),
(8720, 'See All'),
(8721, 'See All Messages'),
(8722, 'See Authorizations'),
(8723, 'See couchdb error log'),
(8724, 'See Customize the Fee Sheet'),
(8725, 'See Growth-Chart'),
(8726, 'See messages from the last set of generated claims'),
(8727, 'See Setup the Fee Sheet'),
(8728, 'See the Clinical Reminders widget for more details'),
(8729, 'Seen since'),
(8730, 'Seen within'),
(8731, 'Segment name'),
(8732, 'Segments Batch Claim'),
(8733, 'Seizures'),
(8734, 'Sel'),
(8735, 'Select'),
(8736, 'select'),
(8737, 'Select \'Price Levels\' and enter Credit Card and Cash'),
(8738, 'Select a Component'),
(8739, 'Select a Context'),
(8740, 'Select a date range and click Submit'),
(8741, 'Select a lab from the Order From drop-down box'),
(8742, 'Select a patient by clicking on the patient input box'),
(8743, 'Select a percentage of the rows or or select dates'),
(8744, 'Select a surgery if it is listed in the drop-down box or enter a new surgery name under Title'),
(8745, 'Select a Time Span'),
(8746, 'Select a User'),
(8747, 'Select a validation rule'),
(8748, 'Select Action'),
(8749, 'Select All'),
(8750, 'Select all'),
(8751, 'Select Amendment Date'),
(8752, 'Select amendments to print'),
(8753, 'Select an appropriate ICD/CPT code. This helps search for education material to give to the patient for that particular problem'),
(8754, 'Select as appropriate and fill in the text box and click Save'),
(8755, 'Select Bidirectional or Results Only as appropriate, again only used for electronic orders'),
(8756, 'Select Blood in the Specimen Type drop-down box'),
(8757, 'Select CAMOS Entries for Printing'),
(8758, 'Select Case'),
(8759, 'Select category'),
(8760, 'Select Code'),
(8761, 'Select Codes'),
(8762, 'Select Communication Preferences'),
(8763, 'Select corresponding checkboxes to delete'),
(8764, 'Select Credit Card Payment Gateway'),
(8765, 'Select Criteria to Remove'),
(8766, 'Select CSV table'),
(8767, 'Select Custom Favorite Group from the Procedure Tier drop-down box'),
(8768, 'Select Custom Favorite Item in the Procedure Tier drop-down box'),
(8769, 'Select Data Required for De Identification'),
(8770, 'Select data to be included in De Identified data'),
(8771, 'Select date'),
(8772, 'Select Default Codes'),
(8773, 'Select desired squad'),
(8774, 'Select Diagnosis'),
(8775, 'Select Diagnosis Codes'),
(8776, 'Select Diagnosis for De Identification request'),
(8777, 'Select Discrete Result from the Procedure Tier'),
(8778, 'Select Discrete Result from the Procedure Tier drop-down box'),
(8779, 'Select Discrete Result under Procedure Tier in the Enter Details pop-up'),
(8780, 'Select Drug'),
(8781, 'Select Drugs'),
(8782, 'Select Drugs for De Identification request'),
(8783, 'Select EDI-271 file'),
(8784, 'Select Encounter'),
(8785, 'Select field'),
(8786, 'Select Field'),
(8787, 'Select Fields'),
(8788, 'Select for printing'),
(8789, 'Select from the displayed list'),
(8790, 'Select Group'),
(8791, 'Select Group in the drop-down box labeled Procedure Tier'),
(8792, 'Select Group under Procedure Tier, think of it as creating a large branch off the main tree trunk, and call it Organ/Disease Panel'),
(8793, 'Select Image Procedure'),
(8794, 'Select Immunizations'),
(8795, 'Select Immunizations for De Identification request'),
(8796, 'Select Insurance, by typing'),
(8797, 'Select Issue'),
(8798, 'Select items'),
(8799, 'Select Lab Service in the Type drop-down box and enter a name under organization'),
(8800, 'Select Language'),
(8801, 'Select list'),
(8802, 'Select List'),
(8803, 'Select Method'),
(8804, 'Select MG/DL as Default Units'),
(8805, 'Select Month'),
(8806, 'Select One'),
(8807, 'Select one or more diagnosis codes to justify the service'),
(8808, 'Select one or more files to upload'),
(8809, 'Select only one code per problem'),
(8810, 'Select Options for Current Encounter'),
(8811, 'Select Options for Current Procedure Order Id '),
(8812, 'Select output'),
(8813, 'Select Pharmacy'),
(8814, 'SELECT PLAN'),
(8815, 'Select Primary Physician'),
(8816, 'Select Procedure Order from Procedure Tier pop-up box'),
(8817, 'Select Procedure Order in Procedure Tier'),
(8818, 'Select Providers'),
(8819, 'Select Referral from the Transaction type drop-down box'),
(8820, 'Select Requested By'),
(8821, 'Select Role'),
(8822, 'Select SMS Gateway'),
(8823, 'Select source'),
(8824, 'Select State and City to Import for Pharmacy'),
(8825, 'Select Template'),
(8826, 'Select the appropriate choice - Debugging or Production'),
(8827, 'Select the appropriate radio button. Enter the search term in the search box and click \'Search\''),
(8828, 'Select the configuration items to export'),
(8829, 'Select the default font'),
(8830, 'Select the default font (need to logout/login after changing this setting).'),
(8831, 'Select the default font size'),
(8832, 'Select the default font size (need to logout/login after changing this setting).'),
(8833, 'Select the diagnoses to include in the Impression/Plan.'),
(8834, 'Select the group (ARO) that you wish to remove.'),
(8835, 'Select the issue primarily responsible for any missed events on this day'),
(8836, 'Select the Lab From lab name'),
(8837, 'Select the message type to more accurately reflect the type of message you are sending. You may choose to leave it as unassigned'),
(8838, 'Select the name of the entity from the Name drop-down box'),
(8839, 'Select the type of Occurrence of the problem from the drop-down box, the choices are Unknown or N/A, First, Early Recurrence, Late Recurrence, Delayed Recurrence, Chronic/Recurrent and Acute on Chronic'),
(8840, 'Select to print patient address labels from popups in left nav screen.'),
(8841, 'Select to transmit'),
(8842, 'Select Track'),
(8843, 'Select Transaction Type'),
(8844, 'Select Type'),
(8845, 'Select User'),
(8846, 'SELECT Users FROM The Dropdown LIST'),
(8847, 'Select Users From The Dropdown List'),
(8848, 'Select which languages, if any, may be chosen at login. (only pertinent if above All Languages Allowed is turned off)'),
(8849, 'Select Year'),
(8850, 'Select Yes to confirm group deletion'),
(8851, 'Select your current facility in the login page'),
(8852, 'Select/Add Authentication Method for the logged in user'),
(8853, 'Select/Add New Authentication Method for'),
(8854, 'Select1'),
(8855, 'Select2'),
(8856, 'Selected'),
(8857, 'Selected Encounter'),
(8858, 'Selected Fee Sheet Codes and Charges for Current Encounter'),
(8859, 'Selected Files'),
(8860, 'Selected files and data will be removed from folders and tables'),
(8861, 'Selecting the width for responsive vertical style menus in tab based layout (need to logout/login after changing this setting)'),
(8862, 'Selecting this will create a message that needs to be processed by each recipient individually (this is not a group task).'),
(8863, 'Seleted Message id'),
(8864, 'Self'),
(8865, 'Self Pay'),
(8866, 'SEND'),
(8867, 'Send'),
(8868, 'Send A Dated Reminder'),
(8869, 'Send a Reminder'),
(8870, 'Send an email to '),
(8871, 'Send CCD'),
(8872, 'Send CCR'),
(8873, 'Send Complete - Prescription(s) Return Status'),
(8874, 'Send Emails'),
(8875, 'Send for Review'),
(8876, 'Send in progress'),
(8877, 'Send It'),
(8878, 'Send Message'),
(8879, 'Send message'),
(8880, 'Send message from the permanent group therapist to the personal therapist'),
(8881, 'Send message from the permanent group therapist to the personal therapist (gm)'),
(8882, 'Send NewRx'),
(8883, 'Send Notes'),
(8884, 'Send Payment'),
(8885, 'Send Reminders Batch'),
(8886, 'Send reminders to patients per patient preference for preventive/follow up care.'),
(8887, 'Send Request'),
(8888, 'Send Selected to Archive'),
(8889, 'Send Selected to Trash'),
(8890, 'Send Summaries with Referrals'),
(8891, 'Send this file'),
(8892, 'Send This Message'),
(8893, 'Send to'),
(8894, 'Send To'),
(8895, 'SEND TO'),
(8896, 'Send to all'),
(8897, 'Send to Archive'),
(8898, 'Send To HIE failed'),
(8899, 'Send to portal'),
(8900, 'Send to Portal'),
(8901, 'Send to Trash'),
(8902, 'Sender'),
(8903, 'Sender ID'),
(8904, 'Sender ID (ISA06)'),
(8905, 'Sender ID Qualifier (ISA05)'),
(8906, 'Sender IDs'),
(8907, 'Sender IDs - is only required if you are submitting an electronic order to an external facility'),
(8908, 'sender name'),
(8909, 'SENDING A MESSAGE'),
(8910, 'Sending application name will be provided by the facility that you will be connecting to'),
(8911, 'Sending facility name is user defined'),
(8912, 'Sending Invoice to Patient Portal Completed'),
(8913, 'Sending To'),
(8914, 'Sensitivities'),
(8915, 'Sensitivities (sensitivities)'),
(8916, 'Sensitivity'),
(8917, 'Sensitivity - lets you limit the information in this encounter to those with appropriate privileges'),
(8918, 'Sensitivity:'),
(8919, 'Sensory exam normal'),
(8920, 'Sent'),
(8921, 'Sent - Confirmed'),
(8922, 'Sent By, Leave Blank For All'),
(8923, 'Sent by:'),
(8924, 'Sent Date'),
(8925, 'Sent Items'),
(8926, 'Sent Medical Records?'),
(8927, 'Sent successfully'),
(8928, 'Sent Summary of Care Electronically?'),
(8929, 'Sent Summary of Care?'),
(8930, 'sent to printer.'),
(8931, 'Sent To, Leave Blank For All'),
(8932, 'Sent to:'),
(8933, 'Sent, but delivery not yet confirmed.'),
(8934, 'Sent, not received'),
(8935, 'Sep'),
(8936, 'Separated'),
(8937, 'September'),
(8938, 'Seq'),
(8939, 'Sequence'),
(8940, 'Serbian'),
(8941, 'Serv Rep'),
(8942, 'Server error: try again later'),
(8943, 'Server Login'),
(8944, 'Server may be offline'),
(8945, 'Server message:'),
(8946, 'Service'),
(8947, 'Service added'),
(8948, 'Service Category'),
(8949, 'Service Code'),
(8950, 'Service Code Finance Reporting'),
(8951, 'Service Codes'),
(8952, 'Service Date'),
(8953, 'Service Date From'),
(8954, 'Service Date To'),
(8955, 'Service Date:'),
(8956, 'Service deleted'),
(8957, 'Service Facility'),
(8958, 'Service is not compatible with the sex of this client.'),
(8959, 'Service Location'),
(8960, 'Service Name'),
(8961, 'Service provided by specialist'),
(8962, 'Service provider changed'),
(8963, 'Service Reporting'),
(8964, 'Service Reporting Only'),
(8965, 'Services'),
(8966, 'Services by Category'),
(8967, 'Services Provided'),
(8968, 'Services provided'),
(8969, 'Services/Products'),
(8970, 'Session Type'),
(8971, 'Set'),
(8972, 'Set a facility cookie to remember the selected facility between logins.'),
(8973, 'Set As Completed'),
(8974, 'SET AS COMPLETED'),
(8975, 'Set aside some uninterrupted time for the data entry'),
(8976, 'Set Gateway to Production Mode'),
(8977, 'Set POS code in encounter'),
(8978, 'Set Price Level'),
(8979, 'Set processing priority for CDR engine based reports.'),
(8980, 'Set processing priority for creation of Patient Reminders (in full clinic mode).'),
(8981, 'Set the priority level'),
(8982, 'Set this to the full absolute path. For creating client SSL certificates for HTTPS.'),
(8983, 'Set To'),
(8984, 'Set to Default'),
(8985, 'set value to'),
(8986, 'Set which radio button is selected by default in \'Search for Additional Codes\' section'),
(8987, 'Sets the font of the address text on the envelope in mm'),
(8988, 'Setting the version number in the database...'),
(8989, 'Setting up 2FA'),
(8990, 'Settings'),
(8991, 'Setup MedEx'),
(8992, 'Setup the Fee Sheet'),
(8993, 'Several additional drop-down and text boxes will be visible'),
(8994, 'Severe'),
(8995, 'Severe Migraine'),
(8996, 'Severity'),
(8997, 'Severity information will be missing if interaction is found'),
(8998, 'Severity of Pain'),
(8999, 'Severity of Pain:'),
(9000, 'Sex'),
(9001, 'Sexually Transmitted Disease'),
(9002, 'SFTP'),
(9003, 'SFTP will send the order as a HL7v2.3 message to the receiving lab using the SFTP protocol'),
(9004, 'Sha-1 Hash'),
(9005, 'Sharing'),
(9006, 'Shell command for printing from the server.'),
(9007, 'Shift'),
(9008, 'Shona'),
(9009, 'Short Description'),
(9010, 'Shorthand'),
(9011, 'Shorthand Help'),
(9012, 'Shortness of Breath'),
(9013, 'Shortness Of Breath'),
(9014, 'Shortness Of Breath 2'),
(9015, 'Shot Record'),
(9016, 'Shot Record as of:'),
(9017, 'Should be Enabled'),
(9018, 'should be like nnnnn-nnnn-nn'),
(9019, 'Should be two letters'),
(9020, 'should contain 10 digits'),
(9021, 'should contain only 10 digits'),
(9022, 'Shoulder'),
(9023, 'Shoulder + clavicle'),
(9024, 'Shoulder Problems'),
(9025, 'Show'),
(9026, 'Show Active'),
(9027, 'Show Additional Insurance Information'),
(9028, 'Show Aging on Custom Statement'),
(9029, 'Show All'),
(9030, 'Show all payment history in Patient Ledger'),
(9031, 'Show all procedures'),
(9032, 'Show All Results'),
(9033, 'Show All Transactions'),
(9034, 'Show as Busy'),
(9035, 'Show Authorized Only'),
(9036, 'Show Available Times'),
(9037, 'Show both US and metric (main unit is metric)'),
(9038, 'Show both US and metric (main unit is US)'),
(9039, 'Show button for download fax template'),
(9040, 'Show button in the prescription list for download fax template'),
(9041, 'Show Current Signature On File'),
(9042, 'Show Details'),
(9043, 'Show Diagnoses Section'),
(9044, 'Show Errors Only?'),
(9045, 'Show Extra Logo on Login'),
(9046, 'Show Graph'),
(9047, 'Show Help Modal'),
(9048, 'Show hovering event text on mouseover?'),
(9049, 'Show how many events on admin pages?'),
(9050, 'Show Inactive'),
(9051, 'Show Insurance Address Information in the Insurance Panel of Demographics.'),
(9052, 'Show IOP by Date'),
(9053, 'Show IOP by Time'),
(9054, 'Show Menu'),
(9055, 'Show metric only'),
(9056, 'Show Mini Logo 1'),
(9057, 'Show Mini Logo 2'),
(9058, 'Show Notes'),
(9059, 'Show only latest values reported for each result code'),
(9060, 'Show only procedures not omitted'),
(9061, 'Show Patient Encounter Number in Patient Flow Board'),
(9062, 'Show Patient ID in Patient Flow Board'),
(9063, 'Show Patient Notes'),
(9064, 'Show pounds and ounces'),
(9065, 'Show pounds as decimal value'),
(9066, 'Show Primary Complete'),
(9067, 'Show Products Section'),
(9068, 'Show Receipt'),
(9069, 'Show records'),
(9070, 'Show Reminders'),
(9071, 'Show Report'),
(9072, 'Show search/submit links in block?'),
(9073, 'Show Selected for Drug Screens'),
(9074, 'Show Services Section'),
(9075, 'Show Status of Drug Screens'),
(9076, 'Show the custom state form for the add list widget (will ask for title and abbreviation).'),
(9077, 'Show the last three Refractions'),
(9078, 'Show this category on the patient summary screen even if no issues have been entered for this category.'),
(9079, 'Show Title on Login'),
(9080, 'Show track history'),
(9081, 'Show Unbilled Only'),
(9082, 'Show US only'),
(9083, 'Show Visit Reason in Patient Flow Board'),
(9084, 'Show/Hide the Selection Area'),
(9085, 'Showing'),
(9086, 'Showing 0 to 0 of 0 entries'),
(9087, 'Showing items'),
(9088, 'Showing page'),
(9089, 'Showing result'),
(9090, 'Shows the hierarchal level of this line'),
(9091, 'Shutting Down Service ...'),
(9092, 'Sibling'),
(9093, 'Sibling History'),
(9094, 'Sibling in-law'),
(9095, 'Siblings'),
(9096, 'Sickle Cell'),
(9097, 'Sig'),
(9098, 'Sigmoid/Colonoscopy'),
(9099, 'Sign'),
(9100, 'Sign In'),
(9101, 'Sign Lab Results (write,addonly optional)'),
(9102, 'Sign Lab Results (write,addonly optional) (sign)'),
(9103, 'Sign Results'),
(9104, 'Sign-up'),
(9105, 'Sign-up successful for'),
(9106, 'Signature'),
(9107, 'Signature on File'),
(9108, 'Signature On File'),
(9109, 'Signature:'),
(9110, 'Signed Rx'),
(9111, 'Significant Other'),
(9112, 'Significant Swelling:'),
(9113, 'Simplified'),
(9114, 'Simplified Co-Pay'),
(9115, 'Simplified Demographics'),
(9116, 'Simplified Prescriptions'),
(9117, 'Since'),
(9118, 'Sincerely,'),
(9119, 'Sindhi'),
(9120, 'Single'),
(9121, 'Single Tests'),
(9122, 'Single-selection list'),
(9123, 'Single-selection list with ability to add to the list'),
(9124, 'Singular'),
(9125, 'Sinhala'),
(9126, 'Sinhala, Sinhalese'),
(9127, 'Sinus Problems'),
(9128, 'Sinus Surgery'),
(9129, 'SINUS TENDERNESS:'),
(9130, 'Sinusitis'),
(9131, 'Sister'),
(9132, 'Site'),
(9133, 'Site ID'),
(9134, 'Site ID for the Medical Information Integration, LLC Lab Exchange Service.'),
(9135, 'Site ID for the OpenEMR Support LLC Lab Exchange Service.'),
(9136, 'Site Worker'),
(9137, 'Six Months Ago'),
(9138, 'Six Months Ahead'),
(9139, 'Size'),
(9140, 'size'),
(9141, 'Size must be a number between 1 and 999'),
(9142, 'Size/List'),
(9143, 'Skilled Nursing Facility'),
(9144, 'Skin'),
(9145, 'Skin Cancer'),
(9146, 'Skin Disease'),
(9147, 'Skin Other'),
(9148, 'Skip Authorization of Patient Notes'),
(9149, 'Skipping section'),
(9150, 'Skipping SQL-Ledger dump - not implemented for Windows server'),
(9151, 'Sl.No'),
(9152, 'Slab Off'),
(9153, 'Sleep'),
(9154, 'Sleep patterns'),
(9155, 'Sleep Patterns'),
(9156, 'Sleeping'),
(9157, 'Sliding'),
(9158, 'Slovak'),
(9159, 'Slovene'),
(9160, 'Sm debt w/o'),
(9161, 'Smartphones can have authenticator apps that can calculate OTP using either time based or algorithm based approaches and is a common method of OTP delivery'),
(9162, 'Smarty Cache has been cleared'),
(9163, 'Smoker, current status unknown'),
(9164, 'Smoking'),
(9165, 'Smoking Status'),
(9166, 'SMS'),
(9167, 'SMS Auth'),
(9168, 'SMS based delivery of OTP is easy to implement with no additional steps needed by the user'),
(9169, 'SMS Confirmed'),
(9170, 'SMS Gateway'),
(9171, 'SMS Gateway API key'),
(9172, 'SMS Gateway API Key'),
(9173, 'SMS Gateway Password'),
(9174, 'SMS Gateway Username'),
(9175, 'SMS Messages'),
(9176, 'SMS Notification'),
(9177, 'SMS Notification Hours'),
(9178, 'SMS Notification Settings Updated Successfully'),
(9179, 'SMS OK'),
(9180, 'SMS send before'),
(9181, 'SMS Sent'),
(9182, 'SMS Text Usable Tags'),
(9183, 'SMS Text, Usable Tag: ***NAME***, ***PROVIDER***, ***DATE***, ***STARTTIME***, ***ENDTIME***<br> i.e. Dear ***NAME***'),
(9184, 'SMS Text, Usable Tags: '),
(9185, 'SMS Zone'),
(9186, 'SMS zone - This section lets use send and receive SMS texts'),
(9187, 'SMS/Email Alert Settings'),
(9188, 'SMS/Email Alert Settings Updated Successfully'),
(9189, 'SMTP Password for Authentication'),
(9190, 'SMTP Security Protocol'),
(9191, 'SMTP security protocol to connect with. Required by some servers such as gmail.'),
(9192, 'SMTP Server Hostname'),
(9193, 'SMTP Server Port Number'),
(9194, 'SMTP User for Authentication'),
(9195, 'SNOMED'),
(9196, 'SNOMED (RF1) Clinical Term'),
(9197, 'SNOMED (RF1) Diagnosis'),
(9198, 'SNOMED (RF1) Procedure'),
(9199, 'SNOMED (RF2) Clinical Term'),
(9200, 'SNOMED (RF2) Diagnosis'),
(9201, 'SNOMED (RF2) Procedure'),
(9202, 'SNOMED Clinical Term'),
(9203, 'SNOMED Database'),
(9204, 'SNOMED Diagnosis'),
(9205, 'SNOMED Procedure'),
(9206, 'SNOMED-CT Code'),
(9207, 'Snoring'),
(9208, 'SOAP'),
(9209, 'Soap Import Status'),
(9210, 'Soc Hx{{Social History}}'),
(9211, 'Social'),
(9212, 'Social Difficulties'),
(9213, 'Social History'),
(9214, 'Social History Element'),
(9215, 'Social History:'),
(9216, 'Social Security Number'),
(9217, 'Social Security(Optional)'),
(9218, 'solution'),
(9219, 'Somali'),
(9220, 'Somatic Context'),
(9221, 'Some authorizations were not displayed. Click here to view all'),
(9222, 'Some codes were not displayed.'),
(9223, 'Some encounters were not displayed. Click here to view all.'),
(9224, 'Some error has occured during De Identification Process'),
(9225, 'Some global parameters on the setup and printing of the generated claims can be set in Adminstration > Globals > Billing'),
(9226, 'Some notes were not displayed.'),
(9227, 'Some office notes were not displayed. Click here to view all.'),
(9228, 'Some smaller local labs may agree to deal directly with the practice'),
(9229, 'some words'),
(9230, 'Someone else has just changed this visit. Please cancel this page and try again.'),
(9231, 'Something went wrong'),
(9232, 'Something went wrong.'),
(9233, 'Something went wrong. Please try again.'),
(9234, 'Soon Due Interval (Clinical Reminders)'),
(9235, 'Soon Due Interval (Patient Reminders)'),
(9236, 'Sore Throat'),
(9237, 'Sorry No Appointment is Fixed'),
(9238, 'Sorry you are not privileged enough. Enrollment is limited to Adminstrator accounts.'),
(9239, 'Sorry! Not Authorized.'),
(9240, 'Sorry, there was a problem uploading your file'),
(9241, 'Sorry, there was a problem!'),
(9242, 'Sort alphabetically'),
(9243, 'Sort by'),
(9244, 'Sort By'),
(9245, 'Sort by Category'),
(9246, 'Sort by Checksum'),
(9247, 'Sort by Comments'),
(9248, 'Sort by Crt User'),
(9249, 'Sort by date'),
(9250, 'Sort by date/time'),
(9251, 'Sort by Event'),
(9252, 'Sort by Group'),
(9253, 'Sort by New Checksum'),
(9254, 'Sort by Old Checksum'),
(9255, 'Sort by PatientID'),
(9256, 'Sort by seq'),
(9257, 'Sort by Success'),
(9258, 'Sort by Tamper date/time'),
(9259, 'Sort by User'),
(9260, 'Sort by vaccine'),
(9261, 'Sort Down'),
(9262, 'Sort Result by'),
(9263, 'Sort Up'),
(9264, 'Source'),
(9265, 'Source CSV File'),
(9266, 'Source File'),
(9267, 'Source File Path'),
(9268, 'Source is missing for code '),
(9269, 'Source Lot'),
(9270, 'Source of the document'),
(9271, 'Source Patient'),
(9272, 'Source patient has no DOB'),
(9273, 'Source patient not found'),
(9274, 'Source:'),
(9275, 'South Ndebele'),
(9276, 'Southern Sotho'),
(9277, 'Space'),
(9278, 'SPACE'),
(9279, 'Span Entire Row'),
(9280, 'Spanish'),
(9281, 'Spanish (Latin American)'),
(9282, 'Spanish (Spain)'),
(9283, 'Spanish- Castilian'),
(9284, 'Special characters are not allowed'),
(9285, 'Special treatment for the Vitals form'),
(9286, 'Specialist'),
(9287, 'Specialist name and signature'),
(9288, 'Specialized physician'),
(9289, 'Specialty'),
(9290, 'Specialty Systems'),
(9291, 'Specialty:'),
(9292, 'Specific'),
(9293, 'Specific Application'),
(9294, 'Specific Contraceptive Service'),
(9295, 'Specific Result'),
(9296, 'Specific Service'),
(9297, 'Specified'),
(9298, 'Specifies formatting for codes. # = digit, * = any character. Empty if not used.'),
(9299, 'Specifies formatting for codes. # = digit, @ = alpha, * = any character. Empty if not used.'),
(9300, 'Specifies formatting for invoice reference numbers.  # = digit, * = any character.  Empty if not used.'),
(9301, 'Specifies formatting for invoice reference numbers.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(9302, 'Specifies formatting for product NDC fields.  # = digit, * = any character.  Empty if not used.'),
(9303, 'Specifies formatting for product NDC fields.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(9304, 'Specifies formatting for the external patient ID.  # = digit, * = any character.  Empty if not used.'),
(9305, 'Specifies formatting for the external patient ID.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(9306, 'Specify the interval for automatic message checking, 5 or 10 minutes as a starting point'),
(9307, 'Specify the OpenEMR user who will receive notification of new incoming Direct messages'),
(9308, 'Specimen'),
(9309, 'Specimen number/identifier'),
(9310, 'Specimen Type'),
(9311, 'Specimen type'),
(9312, 'Speech Dictation'),
(9313, 'Spermicides'),
(9314, 'Sph{{Sphere}}'),
(9315, 'SPH{{Sphere}}'),
(9316, 'Splenectomy'),
(9317, 'Spouse'),
(9318, 'Spouses History'),
(9319, 'Sputum'),
(9320, 'Sputum:'),
(9321, 'SQ'),
(9322, 'sql'),
(9323, 'SQL-Ledger'),
(9324, 'Squad'),
(9325, 'Squad Membership'),
(9326, 'Squads'),
(9327, 'Squads (squads)'),
(9328, 'SRH'),
(9329, 'SRH - Family Planning'),
(9330, 'SRH Non Family Planning'),
(9331, 'SRH Referrals'),
(9332, 'SRH Visit Form'),
(9333, 'Srv Date'),
(9334, 'SS'),
(9335, 'SSL Certificate Administration'),
(9336, 'SSN'),
(9337, 'Stability'),
(9338, 'Stack Trace'),
(9339, 'Staged Releases'),
(9340, 'Standard'),
(9341, 'Standard check'),
(9342, 'Standard Code'),
(9343, 'Standard Measures'),
(9344, 'Standard Measures (Active Alerts)'),
(9345, 'Standard Measures (Passive Alerts)'),
(9346, 'Standard Measures (Patient Reminders)'),
(9347, 'Standard Name'),
(9348, 'Standard; Simplified: only title, start date, comments and an Active checkbox;no diagnosis, occurrence, end date, referred-by or sports fields. ; Football Injury'),
(9349, 'Start'),
(9350, 'Start (yyyy-mm-dd): '),
(9351, 'Start Another Report'),
(9352, 'Start Batch Processing'),
(9353, 'Start by clicking on Add Top Level to bring up the Enter Details pop-up box in the Add Mode'),
(9354, 'Start by clicking on the black plus sign at the end of the Serum Chemistry line to bring up the Enter Details pop-up'),
(9355, 'Start by clicking the Browse button and selecting the file to upload, and then clicking \'Upload\' to perform the upload and display the corresponding invoices. In this case the other parameters mentioned above do not apply and will be ignored. Uploading saves the file but does not yet process its contents -- that is done separately as described below.'),
(9356, 'Start Date'),
(9357, 'Start date'),
(9358, 'Start Date at This Clinic'),
(9359, 'Start Date should not be greater than End Date'),
(9360, 'Start date:'),
(9361, 'Start Date:'),
(9362, 'Start entering the data in an orderly manner, tier by tier, one top order group at a time'),
(9363, 'Start Time'),
(9364, 'Starting date'),
(9365, 'Starting Date'),
(9366, 'Starting date for search'),
(9367, 'Starting Date From'),
(9368, 'Starting Date To'),
(9369, 'stat'),
(9370, 'State'),
(9371, 'State Data Type'),
(9372, 'State Lic. #'),
(9373, 'State License Number'),
(9374, 'State list'),
(9375, 'State List (write,addonly optional)'),
(9376, 'State List (write,addonly optional) (state)'),
(9377, 'State List Widget Custom Fields'),
(9378, 'State Or Province'),
(9379, 'State/Locality'),
(9380, 'State/Parish'),
(9381, 'State:'),
(9382, 'Statement Appearance'),
(9383, 'Statement Logo GIF Filename'),
(9384, 'STATEMENT SUMMARY'),
(9385, 'statements and updating invoices.'),
(9386, 'Statements Sent'),
(9387, 'Statements Sent:'),
(9388, 'statements; invoices will not be updated.'),
(9389, 'Static Text'),
(9390, 'Statistics'),
(9391, 'Stats'),
(9392, 'Status'),
(9393, 'Status in the group'),
(9394, 'Status in the meeting'),
(9395, 'Status Of Admission'),
(9396, 'Status of Claim'),
(9397, 'Status quo'),
(9398, 'Status Type'),
(9399, 'STD/AIDS Couns'),
(9400, 'Stength and Conditioning'),
(9401, 'Step Child'),
(9402, 'Step Parent'),
(9403, 'Step Sibling'),
(9404, 'Stepchild'),
(9405, 'Steps for uploading CCR XML'),
(9406, 'Steps to install the DSM IV database'),
(9407, 'Steps to install the ICD 10 database'),
(9408, 'Steps to install the ICD 9 database'),
(9409, 'Steps to install the RxNorm database'),
(9410, 'Steps to install the Snomed database'),
(9411, 'Steps to install the VALUSET database'),
(9412, 'Stereopsis'),
(9413, 'Stiff Joints'),
(9414, 'Stiffness'),
(9415, 'Still Loading...'),
(9416, 'Stock Months'),
(9417, 'Stomach Pains'),
(9418, 'Stop'),
(9419, 'STOP'),
(9420, 'Store your safe key at settings globals in security tab'),
(9421, 'Stored Hash'),
(9422, 'Strabismus'),
(9423, 'Strain of muscle'),
(9424, 'Streak'),
(9425, 'Stream'),
(9426, 'Street'),
(9427, 'Street Address'),
(9428, 'Street and Number'),
(9429, 'Strength'),
(9430, 'Strength and Conditioning'),
(9431, 'Strep Throat'),
(9432, 'Stress fracture'),
(9433, 'Stress Test'),
(9434, 'Stripe'),
(9435, 'Stroke'),
(9436, 'stroke'),
(9437, 'Strong password means at least 8 characters, and at least three of: a number, a lowercase letter, an uppercase letter, a special character.'),
(9438, 'Style'),
(9439, 'Style of form used for adding new patients'),
(9440, 'Style your messsage and/or add Image/Video'),
(9441, 'Stylings'),
(9442, 'Sub Group'),
(9443, 'Sub-category'),
(9444, 'Sub-Total'),
(9445, 'Subcategory'),
(9446, 'subcategory'),
(9447, 'subcutaneously'),
(9448, 'Subject'),
(9449, 'Subjective'),
(9450, 'Sublingual'),
(9451, 'sublingual'),
(9452, 'Submit'),
(9453, 'submit'),
(9454, 'Submit All Content'),
(9455, 'Submit and Delete Request'),
(9456, 'Submit Changes For All Appts At Once'),
(9457, 'Submit Event'),
(9458, 'submit form'),
(9459, 'Submit Payment for Authorization'),
(9460, 'Submit Selected Content'),
(9461, 'Submitted'),
(9462, 'submitted'),
(9463, 'Submitted by'),
(9464, 'Submitter EDI Access Number (PER06)'),
(9465, 'Subscriber'),
(9466, 'Subscriber Address'),
(9467, 'Subscriber City'),
(9468, 'Subscriber Country'),
(9469, 'Subscriber Date of Birth'),
(9470, 'Subscriber Employer'),
(9471, 'Subscriber Employer (SE)'),
(9472, 'Subscriber Employer Address'),
(9473, 'Subscriber Employer City'),
(9474, 'Subscriber Employer Country'),
(9475, 'Subscriber Employer State'),
(9476, 'Subscriber Employer Street'),
(9477, 'Subscriber Employer Zip'),
(9478, 'Subscriber Employer Zip Code'),
(9479, 'Subscriber First Name'),
(9480, 'Subscriber Last Name'),
(9481, 'Subscriber Member'),
(9482, 'Subscriber Middle Name'),
(9483, 'Subscriber Phone'),
(9484, 'Subscriber Relationship'),
(9485, 'Subscriber relationship is not self but name is the same! Is this really OK?'),
(9486, 'Subscriber relationship is not self but SS number is the same!'),
(9487, 'Subscriber relationship is self but name is different! Is this really OK?'),
(9488, 'Subscriber relationship is self but SS number is different!'),
(9489, 'Subscriber Sex'),
(9490, 'Subscriber SS'),
(9491, 'Subscriber State'),
(9492, 'Subscriber Zip'),
(9493, 'Subscriber/Policy'),
(9494, 'Subscribers will receive the username, password, and server address information with which to configure OpenEMR'),
(9495, 'Subscribter Phone'),
(9496, 'Substance'),
(9497, 'Substance Refusal Reason'),
(9498, 'Substitution'),
(9499, 'substitution allowed'),
(9500, 'Subtitle'),
(9501, 'Subtype'),
(9502, 'Success'),
(9503, 'success'),
(9504, 'Success confirming receipt of lab result'),
(9505, 'Success getting lab results'),
(9506, 'Success retrieving results from Lab Exchange Network'),
(9507, 'Successful Transfers'),
(9508, 'Successfully added category'),
(9509, 'successfully added to category,'),
(9510, 'Successfully Completed'),
(9511, 'Successfully Deleted'),
(9512, 'Successfully Imported the details. Please approve the patient from the Pending Approval Screen'),
(9513, 'Successfully installed the database.'),
(9514, 'Successfully installed the following database'),
(9515, 'Successfully Modified'),
(9516, 'Successfully Saved.Would you like to Allocate?'),
(9517, 'Successfully Saved.Would you like to Distribute?'),
(9518, 'Successfully Sent'),
(9519, 'successfully stored.'),
(9520, 'Successfully upgraded the database.'),
(9521, 'Successfully upgraded the following database'),
(9522, 'successfully.'),
(9523, 'Suffix'),
(9524, 'Suggestions for the Imp/Plan are built from the Exam, the Past Ocular History (POH and POS) and the Past Medical History (PMH)'),
(9525, 'Suicide'),
(9526, 'Suite'),
(9527, 'Summary'),
(9528, 'Summary of'),
(9529, 'Summary of Acuities for this patient'),
(9530, 'Summary Of Care Provided?'),
(9531, 'Summary of Care Provided?'),
(9532, 'Summary of Care Sent'),
(9533, 'Summary of Care Sent Electronically'),
(9534, 'Sun'),
(9535, 'Sundanese'),
(9536, 'Sunday'),
(9537, 'Superbill'),
(9538, 'Superbill Codes'),
(9539, 'Superbill Codes Administration'),
(9540, 'Superbill Codes Administration (superbill)'),
(9541, 'Superbill Report'),
(9542, 'Superbill/Fee Sheet'),
(9543, 'Superbills'),
(9544, 'Superbills, sometimes referred to as Encounter Forms or Routing Slips, are an essential part of most medical practices.'),
(9545, 'Superuser'),
(9546, 'Superuser - can delete patients, encounters, issues (super)'),
(9547, 'Supervising'),
(9548, 'Supervising Doctor'),
(9549, 'Supervising Doctor DEA'),
(9550, 'Supervising Doctor First name'),
(9551, 'Supervising Doctor Last name'),
(9552, 'Supervising Doctor NPI'),
(9553, 'Supervising Doctor UPIN'),
(9554, 'Supervising Provider'),
(9555, 'Supplier'),
(9556, 'Supplier facility name'),
(9557, 'Support calendar events that apply to multiple providers'),
(9558, 'Support export/import of configuration data via the Backup page.'),
(9559, 'Support Multi-Provider Events'),
(9560, 'Support Phone Number'),
(9561, 'Support provider in line item in fee sheet'),
(9562, 'Supports AES-256-CBC encryption/decryption only.'),
(9563, 'Supports TripleDES encryption/decryption only.'),
(9564, 'sup{{superior}}'),
(9565, 'Surface Type'),
(9566, 'Surgeon'),
(9567, 'Surgeries'),
(9568, 'Surgery'),
(9569, 'Surgery Issue List'),
(9570, 'Suspended'),
(9571, 'suspension'),
(9572, 'Su{{Sunday}}'),
(9573, 'Svc Date'),
(9574, 'Svc Date:'),
(9575, 'Swahili'),
(9576, 'Swati'),
(9577, 'Sweating:'),
(9578, 'Swedish'),
(9579, 'Swelling'),
(9580, 'Swelling Right'),
(9581, 'Swollen Joints'),
(9582, 'Swollen Lymph Nodes'),
(9583, 'Symbol used as the decimal point for currency. Not used if Decimal Places is 0.'),
(9584, 'Symbol used to separate thousands for currency.'),
(9585, 'Symptoms'),
(9586, 'Synchronize'),
(9587, 'Synchronize translations with custom language table.'),
(9588, 'Synchronized new custom constant:'),
(9589, 'Synchronized new custom language:'),
(9590, 'Synchronized new definition (Language, Constant, Definition):'),
(9591, 'Syncope'),
(9592, 'Syndromic Surveillance'),
(9593, 'Syndromic Surveillance - Non Reported Issues'),
(9594, 'Syndromic Surveillance Report'),
(9595, 'Synovitis, impingement, bursitis'),
(9596, 'System'),
(9597, 'Systolic'),
(9598, 'S{{Saturday}}'),
(9599, 's{{suffix to make Document plural, ie. Documents}}'),
(9600, 'S{{Sunday}}'),
(9601, 'T'),
(9602, 't.i.d.'),
(9603, 'T.V.'),
(9604, 'Table'),
(9605, 'Table Action'),
(9606, 'Table Args'),
(9607, 'Table Code'),
(9608, 'Table creation failed'),
(9609, 'Table update failed'),
(9610, 'Tables'),
(9611, 'tablet'),
(9612, 'Tabs'),
(9613, 'Tabs Layout Theme'),
(9614, 'Tabs Layout Theme (need to logout/login after change this setting)'),
(9615, 'Tag to Encounter'),
(9616, 'Tag to Image Procedure'),
(9617, 'Tagalog'),
(9618, 'Tahitian'),
(9619, 'Tajik'),
(9620, 'Take'),
(9621, 'Take care and click on the black + sign on the Electrolyte Panel line to create these Discrete Results'),
(9622, 'Take Insurance, from Drop Down'),
(9623, 'Take Payment From, from Drop Down'),
(9624, 'Takeback'),
(9625, 'Takes long'),
(9626, 'Takes you to the Register Time Based One Time Password Key - TOTP page'),
(9627, 'Takes you to the Register Universal 2nd Factor Key - U2F page'),
(9628, 'Tall Navigation Area'),
(9629, 'Tamil'),
(9630, 'Tamper Date'),
(9631, 'Tampered Checksum'),
(9632, 'Target and source DOB do not match'),
(9633, 'Target and source pid may not be the same!'),
(9634, 'Target and source SSN do not match'),
(9635, 'Target Date'),
(9636, 'Target Patient'),
(9637, 'Target patient has no DOB'),
(9638, 'Target patient not found'),
(9639, 'Target/Action Groups'),
(9640, 'Targets'),
(9641, 'Taskman: Documents in openEMR'),
(9642, 'Tatar'),
(9643, 'Tax Id'),
(9644, 'Tax ID'),
(9645, 'Tax Rate'),
(9646, 'Taxes'),
(9647, 'Taxonomy'),
(9648, 'TA{{temporal arteries}}'),
(9649, 'TB'),
(9650, 'TBUT'),
(9651, 'TBUT{{tear breakup time}}'),
(9652, 'Td'),
(9653, 'Team Injury Overview'),
(9654, 'Team Roster'),
(9655, 'Team Roster View'),
(9656, 'Team/Squad'),
(9657, 'Tear Break Up Time'),
(9658, 'Tel'),
(9659, 'Telehealth'),
(9660, 'Telephone Country Code'),
(9661, 'Tell me more'),
(9662, 'Telugu'),
(9663, 'Temp'),
(9664, 'Temp Location'),
(9665, 'Temp Method'),
(9666, 'Temp. Art.{{temporal arteries}}'),
(9667, 'Temperature'),
(9668, 'Template'),
(9669, 'Template Name'),
(9670, 'Template names cannot start with numbers.'),
(9671, 'Template selector changed'),
(9672, 'Template:'),
(9673, 'Templates'),
(9674, 'Temporal Art.{{Temporal Artery}}'),
(9675, 'Temporal Arteries'),
(9676, 'Temporal Artery'),
(9677, 'Temporary Lodging'),
(9678, 'temp{{temporal}}'),
(9679, 'Tendon injury'),
(9680, 'Tendonitis / osis / bursitis'),
(9681, 'Tension'),
(9682, 'Tentative Invoice Ref No'),
(9683, 'Terms and Conditions'),
(9684, 'Tertiary'),
(9685, 'Tertiary Insurance'),
(9686, 'Tertiary Insurance Data'),
(9687, 'Tertiary Insurance provider'),
(9688, 'Test only, skip updates'),
(9689, 'Test Ordered'),
(9690, 'Test Scheduling'),
(9691, 'Test System'),
(9692, 'Test/Order'),
(9693, 'Tests Performed'),
(9694, 'Text'),
(9695, 'Text Diagnosis'),
(9696, 'Text field'),
(9697, 'Text for Custom statement message.'),
(9698, 'Text for fifth account message.'),
(9699, 'Text for first account message.'),
(9700, 'Text for fourth account message.'),
(9701, 'Text for second account message.'),
(9702, 'Text for third account message.'),
(9703, 'Text Message permission'),
(9704, 'Text-date'),
(9705, 'text-date'),
(9706, 'Textarea'),
(9707, 'textarea'),
(9708, 'Textbox'),
(9709, 'textbox'),
(9710, 'Textbox list'),
(9711, 'textbox list'),
(9712, 'Thai'),
(9713, 'Thank You'),
(9714, 'Thank you for choosing'),
(9715, 'Thank You.'),
(9716, 'The \'Clear\' button will remove all annotations.'),
(9717, 'The \'Edit\' window is divided into two columns, \'Active\' and \'Inactive\'. The groups (AROs) that are listed in the active column are those groups that the user belongs to.'),
(9718, 'The \'Select Codes\' section will now have all the CPT and ICD codes that you entered grouped under the categories that you had decided upon'),
(9719, 'The *Tab* key creates each entry.'),
(9720, 'The 1500 Claim Form may also be used to report patient encounter data to federal, state, and/or other public health agencies'),
(9721, 'The 837P (Professional) is the standard format used by health care professionals and suppliers to transmit health care claims electronically'),
(9722, 'The ability to link individual issues to patient encounters will let the user quickly determine the outcome of the issue over time'),
(9723, 'The above statement failed'),
(9724, 'The ACL page two sections.'),
(9725, 'The actual amounts that will be displayed must exist in the database'),
(9726, 'The actual tests or procedures that can be searched for and ordered are highlighted in yellow'),
(9727, 'The Add icon is used to setup a tier that will be a direct descendant of this tier'),
(9728, 'The advantage of integrating the results with the patient\'s chart as structured data is the ability to manipulate it to see trends in one convenient location, to plot graphs with the data and use it in data analysis'),
(9729, 'The advantage of scanning the results into the chart is simplicity - no setup is required other than defining a directory/folder in the patient\'s chart under Documents where the result will be stored. Being unstructured data it does not have the above advantages and will not fulfill Meaningful Use criteria for Computerized Provider Order Entry (CPOE)'),
(9730, 'The Allscripts solution integrates the Allscripts ePrescribe web site with openEMR'),
(9731, 'The American Medical Association has defined 9 panels that can be ordered. Each panel contains several tests grouped together'),
(9732, 'The amount will be displayed in either the Payment or Adjustment column as the case may be'),
(9733, 'The Apache SSL server certificate and public key'),
(9734, 'The application generates challenge - a random number and passes it to the USB key along with the nonce and checksum stored in the application'),
(9735, 'The application then uses the public key that the USB device sent on registration to verify the response'),
(9736, 'The appointment status changes and encounter creations are managed through the Patient Tracker.'),
(9737, 'The Auth Name or API key for selected account. Auth Name for Authorize.Net and API Secret for Stripe.'),
(9738, 'The Balance column would be empty'),
(9739, 'The basic purpose of the authenticator app is to generate a 20 bytes (160 bits) code encoded in base32 using a secure hash function, SHA-1, and is called HMAC-SHA1 (Hash-based Message Authentication Code)'),
(9740, 'The basis for CCR is a Patient Care Referral Form developed by the Massachusetts Department of Public Health'),
(9741, 'The Billed Date/Payor column will show the date the line item payment was received and the Payor name - either insurance or patient'),
(9742, 'The Billed Date/Payor column will show the date the line item was billed and the Payor - either insurance or patient'),
(9743, 'The Body contains the clinical data that may be structured and organized as one or more sections or may be an unstructured blob of data'),
(9744, 'The Body Site, Administer Via and Laterality boxes can be left as Unassigned'),
(9745, 'The bottom group consists of the Copays'),
(9746, 'The Category column will be Custom Top Group and will be highlighted in pink'),
(9747, 'The Category column will say Order indicating that it is an order'),
(9748, 'The Category will be Result'),
(9749, 'The CDA is a plain text document that is coded using the Extensible Markup Language (XML) and contains a Header and Body'),
(9750, 'The Certificate Authority certificate'),
(9751, 'The Charge column would be blank'),
(9752, 'The Charge will be the actual amount being charged for each line item'),
(9753, 'The claim file: '),
(9754, 'The CMS 1500 form has 33 boxes and is divided into two sections'),
(9755, 'The Code column should have 905, the vendor specific Identifying code that was entered previously'),
(9756, 'The Code column will be empty as items listed as a Group are not used in the actual reporting of results and therefore do not have a distinct code number'),
(9757, 'The Code will be R905, the Identifying Code value that was entered for the Discrete Result'),
(9758, 'The code you entered was not valid'),
(9759, 'The compatible staged US Extension SNOMED package has already been installed.'),
(9760, 'The Contacts cell has various bits of contact information like phone numbers, email etc'),
(9761, 'The Continuity of Care Document (CCD) and Continuity of Care Record (CCR) were both selected as acceptable formats to extract information for clinical care summaries as a part of Meaningful Use Stage 1'),
(9762, 'The Continuity of Care Record (CCR) has been developed jointly by ASTM International - an organization that is involved in the development and delivery of voluntary consensus, the Massachusetts Medical Society (MMS), the Health Information Management and Systems Society (HIMSS), the American Academy of Family Physicians (AAFP), and the American Academy of Pediatrics'),
(9763, 'The Continuity of Care Record (CCR) is the clinical record of the patient’s current and historical health care status'),
(9764, 'The core dataset consists of'),
(9765, 'The corresponding private key'),
(9766, 'The created report can contain as much or as little information based on the need'),
(9767, 'The Current Authentication Method for the logged in user section will now feature the activated methods'),
(9768, 'The Current Authentication Method lists all the methods that are active'),
(9769, 'The custmomized Fee Sheet can be used. If and when you come across a code that is not there in the custom \'Select Codes\' section you can always use the \'Search for Additional Codes\' section'),
(9770, 'The Custom Favorite Item Tier should be the direct descendant or child of the relevant Custom Favorite Group'),
(9771, 'The custom grouping will also let you group two recognized panel of tests into a custom group and thus order them together, e.g. a custom group of Preop Labs may contain two panels, CBC and Renal Panel'),
(9772, 'The dashboard is the central location for convenient access the patient\'s medical record'),
(9773, 'The Dashboard page is divided into three sections'),
(9774, 'The data integrity test failed for this form'),
(9775, 'The data section of the dashboard page lists all pertinent items related to a patient'),
(9776, 'The dated reminder will start to appear 5 days before the reminder date under Dated Reminders '),
(9777, 'The default code type to search for in the Fee Sheet.'),
(9778, 'The default fee sheet can be modified and customized to make it more useful.'),
(9779, 'The default fee sheet is divided into several sections and is designed to be filled from top to bottom with the save button at the very end.'),
(9780, 'The default form can be customized by editing it in Administration > Layouts'),
(9781, 'The default has two buttons that is set for \'New Patient\' and \'Established\' patient'),
(9782, 'The default installation has six such groups - Accounting, Administrators, Clinicians, Emergency Login, Front Office and Physicians.'),
(9783, 'The default installation has the following items'),
(9784, 'The default installation lists 5 types of issues that can be documented'),
(9785, 'The default installation will not make the phone call automatically'),
(9786, 'The default is \'Standard\' usually used to reflect rates charged for insurance billing. You can have a different amount charged for credit card payment and for cash payment'),
(9787, 'The default is Normal, i.e. it is visible to everyone. Selecting High will restrict it to users belonging to the Physicians and Administrators groups by default'),
(9788, 'The default issue type is set to Problem'),
(9789, 'The default messaging center is divided into three sections - Messages, Reminders and Recalls'),
(9790, 'The default values for the rendering providers can be set'),
(9791, 'the Denial code is'),
(9792, 'the Denial Group code is'),
(9793, 'The Description column displays the short description that was entered, Serum chemistry tests'),
(9794, 'The Description column will reflect the description value that was entered previously'),
(9795, 'The Description should say Serum Uric Acid result'),
(9796, 'The Description will detail the type of payment or adjustment - Cash, Check, Electronic etc '),
(9797, 'The destination form was closed'),
(9798, 'The destination form was closed; I cannot act on your selection.'),
(9799, 'The difference between the two is that for a panel of tests that are ordered together the individual tests are represented by Discrete Result only and these tests cannot be ordered separately unless they have also been setup as single tests'),
(9800, 'The Discrete result Tier must be the direct descendant or child of a Procedure Order Tier for proper display of results'),
(9801, 'The Discrete Results for each panel will contain the names of the individual tests to hold the values of the returned results - WBC, Hemoglobin, Platelets, Sodium, Potassium etc'),
(9802, 'The display window can be resized by clicking and dragging the bottom right corner of the window'),
(9803, 'The Each Appointment option will allow a new encounter regardless of same day visit.'),
(9804, 'The Encounter Preview button is useful for showing encounter type layout forms as seen when using form in an encounter. Note, this feature is only useful for showing encounter forms and won\'t display system forms like Demographics'),
(9805, 'The Encounters Section will display the date of encounter as well as the presenting complaint'),
(9806, 'The end result was a confusing collection of documents containing ambiguous and/or conflicting information'),
(9807, 'The Enter Details pop-up box will open in the Add Mode'),
(9808, 'The Enter Provider Details pop-up will be visible'),
(9809, 'The entire collection of ACOs forms the Access Control List (ACL).'),
(9810, 'The entity for a Custom Favorite Item is the entity chosen for the Custom Favorite Group and cannot be changed'),
(9811, 'The entity performing this procedure'),
(9812, 'The Entries contain data used for further computer processing'),
(9813, 'The entries highlighted in yellow can be ordered as a test or procedure those highlighted in pink can be ordered as a Custom Group'),
(9814, 'The EP, eligible hospital or CAH who receives a patient from another setting of care or provider of care or believes an encounter is relevant should perform medication reconciliation.'),
(9815, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral (Measure A).'),
(9816, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral (Measure B).'),
(9817, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral.'),
(9818, 'The event(s) have been approved.'),
(9819, 'The event(s) have been hidden.'),
(9820, 'The exported data appears in the text area below.  You can copy and paste this into an email or to any other desired destination.'),
(9821, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination (or) download the below link.'),
(9822, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination.'),
(9823, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination.{{MARK FOR DELETION DURING NEXT TRANSLATION BUILD}}'),
(9824, 'The features of a MedEx enabled installation are explained in this video'),
(9825, 'The file could not be saved to CouchDB.'),
(9826, 'The file could not be succesfully renamed, this error is usually related to permissions problems on the storage system.'),
(9827, 'The file could not be succesfully stored, this error is usually related to permissions problems on the storage system'),
(9828, 'The filter section can be hidden or revealed by clicking the arrowhead  on the bottom right '),
(9829, 'The filtered results will show up in the section below it'),
(9830, 'The first (\"target\") chart is the one that is considered the most complete and accurate. Demographics, history and insurance sections for this one will be retained.'),
(9831, 'The first column contains the Group/Category name that will be displayed on the button'),
(9832, 'The first column is the name that you gave this entry, i.e. Serum Chemistry. A vertical bar will precede the actual name. That indicates that there are no descendants or children to this entry'),
(9833, 'The first four sections deal with creating procedure orders in a structured manner in order to facilitate easy ordering of tests and entering the returned results manually'),
(9834, 'The first line will show the Encounter date and Reason as well as the Provider for that encounter'),
(9835, 'The first section lets you either link this message to a patient if so desired.'),
(9836, 'The first Segment in every HL7 Message is always the Message Header, a Segment that conveys the metadata of the message like who sent it and when. The Message header is indicated in the first three letters of the segment as MSH'),
(9837, 'The first step is signing up for a production Direct messaging account with EMR Direct by registering on their website'),
(9838, 'The first step is to download the SNOMED CT release. Access to SNOMED CT is provided by IHTSDO and their member countries. For more information see'),
(9839, 'The first step is to download the VALUESET release. Access to VALUESET is provided by NLM. Only valueset for Eligible Professionals need to be downloaded and it should be downloaded in XML format from Sorted By CMS ID column. For more details see the below link'),
(9840, 'The first step is to open an account with the Unified Medical Language System web site'),
(9841, 'The first step is to plan what your Fee Sheet \'Select Codes\' section should display'),
(9842, 'The first step is to select a Transaction type'),
(9843, 'The first step would be to create a top level entry. Do so by clicking on Add Top Level button'),
(9844, 'The first tab is the referral tab that constitutes the referral being made'),
(9845, 'The first two numbers in the first and second colum will be used to determine the sort order of the buttons and the lists that are present in the popup'),
(9846, 'The following calendar event has been added:'),
(9847, 'The following calendar event has been modifed:'),
(9848, 'The following categories will be removed from your category List'),
(9849, 'The following database release is currently installed'),
(9850, 'The following documents were attached to this Direct message:'),
(9851, 'The following EDI file failed save to archive'),
(9852, 'The following EDI file has been uploaded'),
(9853, 'The following EDI file upload failed to open'),
(9854, 'The following Emergency Login User is activated:'),
(9855, 'The following errors occurred'),
(9856, 'The following field has an invalid value'),
(9857, 'The following fields are empty.'),
(9858, 'The following fields are required'),
(9859, 'The following fields have to be filled to send a request.'),
(9860, 'The following fields have to be filled to send request.'),
(9861, 'The following International Snomed Release languages are supported'),
(9862, 'The following occurred'),
(9863, 'The following problems have the same diagnosis codes. Encounter issues will not be updated. Please use the encounter interface instead.'),
(9864, 'The following steps will help customize the Fee Sheet to mimic the old paper superbill with a list of CPT4 and ICD codes arranged in categories'),
(9865, 'The group (ARO) that you created will now appear in alphabetical order in the \'Groups and Access Controls\' section.'),
(9866, 'The Header defines the context for the clinical document as a whole'),
(9867, 'The header section will reveal patient specific information across most pages related to the patient\'s medical record'),
(9868, 'The Health Insurance Claim Form is often referred to by its form number CMS 1500 (HCFA 1500)'),
(9869, 'The help file is divided into the following sections'),
(9870, 'The help file there will guide you on further steps in setting up the lab tests'),
(9871, 'The help icon will let you access context sensitive help for each of the pages accessed'),
(9872, 'The hostname of the ATNA audit repository machine.'),
(9873, 'The Identifying Code has to be unique in order for the results to display correctly, you could just use R905 as an example'),
(9874, 'The Identifying code has to be unique, if sending to an external lab the vendor supplied Identifying Code has to be entered. We will enter an arbitrary unique value - WWT01'),
(9875, 'The Identifying Code is a vendor-specific code identifying this procedure or result. You can see examples of it in the paper lab slips that the labs use'),
(9876, 'The Identifying Code is essential for the proper display and tabulation of results'),
(9877, 'The Identifying Code of R34392-1, an arbitrary number, in this case the Identifying Code preceded by R to indicate result and succeeded by 1 to indicate the first in the sequence, it could be anything unique you choose'),
(9878, 'The information entered here is used to display a summary of the encounter. It is also used for billing purposes'),
(9879, 'The information entered in this form will be used to complete a paper claim'),
(9880, 'The information provided in the New Encounter Form and Fee Sheet in openEMR is used to generate the paper claim as well as electronic claims'),
(9881, 'The initial efforts led to the creation of duplicative and conflicting Implementation Guides (IGs) published by different standards organizations'),
(9882, 'The initial screen lets you select a method by offering you these two options.'),
(9883, 'The initial window is the invoice search page.  At the top you may enter a source (e.g. check number), pay date and check amount.  The reason for the source and pay date is so that you don\'t have to enter them over and over again for each claim.  The amount that you enter will be decreased for each invoice that is given part of the payment, and hopefully will end at zero when you are done.'),
(9884, 'The input should be a CSV file with 3 columns: layout ID, code type and code.'),
(9885, 'The installation directory needs to be created.'),
(9886, 'The installed International SNOMED version is not compatible with the staged US Extension SNOMED package.'),
(9887, 'The installed International SNOMED version is out of date and not compatible with the staged US Extension SNOMED file.'),
(9888, 'The installed version and the staged files are the same.'),
(9889, 'The installed version is a more recent version than the staged files.'),
(9890, 'The Instruction manual on how to fill the CMS 1500 form can be found here'),
(9891, 'The IP address of your domain controller(s).'),
(9892, 'The Issues can be entered in one of two ways'),
(9893, 'The Issues section will display all the issues entered for the patient and will display the type of issue, its title and a description'),
(9894, 'The items listed in the \'Active\' column delineate the privileges of this group (ARO) and constitutes this group\'s Access Control List (ACL).'),
(9895, 'The items that have asterisks after them are mandated'),
(9896, 'The label that appears to the user on the form'),
(9897, 'The last cell on the line in Encounter'),
(9898, 'The last line of this encounter block will give the encounter totals of Charges, Payments, Adjustments and the Balance'),
(9899, 'The last section deals with electronic orders'),
(9900, 'The last visit date will automatically be filled'),
(9901, 'The latest version is FHIR – Fast Healthcare Interoperability Resources – is a next generation standards framework created by HL7. This is gaining popularity but has not yet been widely implemented'),
(9902, 'The length should not exceed the following number of characters'),
(9903, 'The log table will show a list of both messages and dated reminders if any'),
(9904, 'The LOINC code for serum uric acid is 3084-1, LOINC refers to it as Urate in Serum or Plasma'),
(9905, 'The merge will not run unless SSN and DOB for the two charts are identical. DOBs cannot be empty.'),
(9906, 'The message could not be sent at this time.'),
(9907, 'The message status will be New as it a new message that is being created'),
(9908, 'The messages that were sent by the user on that day will be displayed in the table below'),
(9909, 'The messaging center conveniently consolidates communications options in one place'),
(9910, 'The messaging center will open with the Messages tab activated and will display the logged in user\'s messages as indicated by the caption My Messages'),
(9911, 'The minimum information required to create a new encounter is to select a visit category'),
(9912, 'The miscellaneous billing options for HCFA-1500 form is used to provide additional information for an individual claim'),
(9913, 'The most common method is called 2-Factor Authorization or 2FA'),
(9914, 'The most important issue that needs to be addressed is who you are trying to connect to and what needs to happen at their end. Most major labs will not deal with individuals practices, in such cases a third party vendor will act an an intermediary who will be responsible for setting up a connection between the practice and the lab through their (the intermediary\'s) interface'),
(9915, 'The most popular maker of Security Keys is Yubico it offers regular USB versions as well as those made for devices that require USB-C connections, such as Apple’s newer Mac OS systems'),
(9916, 'The Name cell contains the name, date of birth, patient ID and date of last visit'),
(9917, 'The Narrative Block contains information that is rendered as readable text'),
(9918, 'The National Uniform Claim Committee (NUCC) is responsible for the maintenance of the 1500 Claim Form'),
(9919, 'The Nav Bar allows one to quickly navigate to various parts of the patient\'s medical record'),
(9920, 'The new category will be a sub-category of '),
(9921, 'The new password can not be the same as the current password.'),
(9922, 'The new password fields are not the same.'),
(9923, 'The NewCrop eRx Partner Name, NewCrop eRx Name and NewCrop eRx Password will be provided by the vendor'),
(9924, 'The next box is Body Site, not relevant for a blood test but may be more useful in say tracking injections or ordering X-rays'),
(9925, 'The next few lines will list all the E/M and CPT codes that were billed, one line per code'),
(9926, 'The next group consists of the ICD codes'),
(9927, 'The next three cells are the action cells that let you perform some recall activity'),
(9928, 'The next two boxes denoting the Identifying Code and Standard Code are very important'),
(9929, 'The Notes cell lets you add a note to an action that you take in the 3 action cells or just a note without any association to the action'),
(9930, 'The Number of Future Appointments to Display on the Statement.'),
(9931, 'The number of staged files is incorrect. Only place the file that you wish to install/upgrade to.'),
(9932, 'The number of staged files is incorrect. Only place the files that you wish to install/upgrade to.'),
(9933, 'The Office: Phone cell lets you indicate a phone call was made'),
(9934, 'The option Span Entire Row is useful when using Static Text in allowing text to wrap and span entire row regardless of column settings. Another use could be to create an empty row as spacer or add additional option Add Bottom Border to create a line break.Only Bottom Border Row is useful here.'),
(9935, 'The options for Outline and Border will either wrap a row in thin border or add a border to the bottom of an item.'),
(9936, 'The order in which the Category, Procedure or Result appears'),
(9937, 'The other 4 transaction types are simple transaction types - Patient Request, Physician Request, Legal and Billing'),
(9938, 'The other Segments contain additional information in a strictly structured fashion'),
(9939, 'The page will be redirected to Demographics. You can edit the country field and clickthrough to NewCrop again.'),
(9940, 'The page you requested was not found. Please check that you typed the URL correctly.'),
(9941, 'The parts of the program to which access can be controlled are called Access Control Objects (ACOs). '),
(9942, 'The password must be at least eight characters, and should'),
(9943, 'The password you entered is invalid'),
(9944, 'The Past Ocular History (POH) and Past Medical History (PMH) are negative.'),
(9945, 'The patient already registered to the group'),
(9946, 'The patient record request has been recorded.'),
(9947, 'The patient reminders have been sent'),
(9948, 'The patient reminders have been updated'),
(9949, 'The patient was not logged in when submitting this form'),
(9950, 'The patient will have to change their credentials at the first login'),
(9951, 'The Patients Rights'),
(9952, 'The Payment, Adjustment and Balance will be blank as these lines reflect only the charges being made'),
(9953, 'The payments posted cannot go below this date.This ensures that after taking the final report nobody post for previous dates.'),
(9954, 'The pop-up form heading will now read Enter Details for Individual Custom Favorite Item'),
(9955, 'The portal has data for this patient and form. Load it now?'),
(9956, 'The previous message can however be viewed by clicking on the View Log button'),
(9957, 'The Procedure Order page lists the following procedure types'),
(9958, 'The procedure request needs to be structured in a hierarchical manner and a unique identifying code assigned to it that will then be used to track and tabulate the result'),
(9959, 'The Procedures module is used to place and review orders'),
(9960, 'The process for forwarding the message is quite similar to that of creating a new message'),
(9961, 'The Progress cell lists all the actions along with any associated notes if any'),
(9962, 'The public access key for secure tokenize of credit or debit card authorization. PCI compliance'),
(9963, 'The QR code also contains the user name and needs to be captured by the user on to their mobile device using an authenticator app'),
(9964, 'The raw data feed release can be obtained from'),
(9965, 'The Recall cell has the date of recall and the reason for recall'),
(9966, 'The Recalls tab has two buttons New Recall and Recall Board'),
(9967, 'The Recommendation Tier is optional'),
(9968, 'The remaining information below applies only if you are posting manually, or if you are doing manual corrections.'),
(9969, 'The reminder for the current day will have an orange exclamation icon'),
(9970, 'The reminders that are past the due date will have a red exclamation triangle icon'),
(9971, 'The requested document is not present at the expected location on the filesystem or there are not sufficient permissions to access it'),
(9972, 'The requested document is not present at the expected location on the filesystem or there are not sufficient permissions to access it.'),
(9973, 'The rest may be left blank if so preferred'),
(9974, 'The rest of the boxes related to the NewCrop eRx service can be left at default values'),
(9975, 'The Result Line will begin with a Name Serum Uric Acid that will be preceded by a vertical bar indicating no successors or children'),
(9976, 'The results could not be loaded'),
(9977, 'The results, Discrete Result, will be the fruit on this branch and we will create one such Discrete Result for each of the component tests, Sodium, Potassium, Chloride and Carbon Dioxide'),
(9978, 'The rows containing the CPT4 codes has several boxes that need to be filled to ensure proper billing of claims'),
(9979, 'The saved Medical Problem will now be listed as a single line in the main Issues page under Medical Problems'),
(9980, 'The screen refresh time in Seconds for the Patient Flow Board Screen.'),
(9981, 'The Search results are displayed in the section \'Search Results\'.'),
(9982, 'The second (\"source\") chart will have its demographics, history and insurance sections discarded.  Its other data will be merged into the target chart.'),
(9983, 'The second column contains the options that will be displayed when the button is clicked'),
(9984, 'The second column is Category and should say Top Group to indicate its position as the top item in this particular hierarchical tree that we will be constructing'),
(9985, 'The second section lets you choose to whom you wish to send the message'),
(9986, 'The second tab, is somewhat ambiguously named as Counter-Referral, is the place to document the received reply to the referral being made'),
(9987, 'The section labeled \'Invoice Search\' is where you put in your search parameters. You can search by patient name, chart number, encounter number or date of service, or any combination of these. You may also select whether you want to see all invoices, open invoices, or only invoices that are due (by the patient). Click the \'Search\' button to perform the search.'),
(9988, 'The selected code will be added to the coding text-box and the Description on the code will be added to the Title text-box'),
(9989, 'The selected codes will then appear in the \'Selected Fee Sheet Codes and Charges for Current Encounter\' section'),
(9990, 'The selections in this section will be used in charging for this encounter'),
(9991, 'The sequence is the order in which this top order item will be displayed on the page, 1 to denote the first top level group'),
(9992, 'The server address will be of the form '),
(9993, 'The setup for lab tests will be described in detail, minor modification to these steps will be needed to setup in-office procedures and other procedure types'),
(9994, 'The somewhat ambiguously named Counter-Referral is the space where the reply to the referral being made can be documented'),
(9995, 'The Source and Date columns are copied from the first page, so normally you will not need to touch those.  You can put a payment amount in the Pay column, an adjustment amount in the Adjust column, or both.  You can also click the \"W\" on the right to automatically compute an adjustment value that writes off the remainder of the charge for that line item.'),
(9996, 'The Source and Date columns are copied from the first page, so normally you will not need to touch those. You can put a payment amount in the Pay column, an adjustment amount in the Adjust column, or both. You can also click the \'W\' on the right to automatically compute an adjustment value that writes off the remainder of the charge for that line item.'),
(9997, 'The Specimen Type will be Blood, this drop-down list can also be edited as needed'),
(9998, 'The staged files release dates are not all from the same release.'),
(9999, 'The staged files revisions are not all from the same release.'),
(10000, 'The staged US Extension SNOMED package can not be installed until after the International SNOMED package has been installed.'),
(10001, 'The Standard Code is optional if using a local i.e. practice based lab but recommended when using an external lab'),
(10002, 'The Standard Code will be the LOINC code if sending to an external lab or can be any unique number. We will enter the LOINC code for Fasting Glucose 1558-6'),
(10003, 'the status of three chronic/inactive problems'),
(10004, 'The subsequent lines will indicate the details of the payments received, adjustments made and the balance due'),
(10005, 'The suffix of the account.'),
(10006, 'The system does not permit uploading files of with size 0.'),
(10007, 'The system does not permit uploading files with MIME content type'),
(10008, 'The system is also designed to parse incoming HL7 messages and place the results in the appropriate patient chart, failing which it will give you an opportunity to manually link it to a patient chart'),
(10009, 'The system is designed to both place orders electronically and receive the results electronically'),
(10010, 'The third column will contain the CPT code'),
(10011, 'The Tier column value will be 1 indicating it is a top level item'),
(10012, 'The Tier column value will be 3, indicating this is a successor or child to the first line above it having a value of 2'),
(10013, 'The Tier column will be 2, indicating this is a successor or child to the first line above it having a value of 1'),
(10014, 'The Tier Column would be 1 indicating it is the Top Group'),
(10015, 'The time granularity of the calendar and the smallest interval in minutes for an appointment slot.'),
(10016, 'The Title will be the name of the new group (ARO) that you are going to create.'),
(10017, 'The top group consists of charges for the encounter - one row per charge'),
(10018, 'The top portion of the Recall Board allows the setting of filters to display specified data'),
(10019, 'The traditional mechanism of using a login and password is no longer considered to be sufficient to prevent an unauthorized user from gaining access to the application'),
(10020, 'The translated label that will appear on the form in current language'),
(10021, 'The translated Title that will appear in current language'),
(10022, 'The translation of description in current language'),
(10023, 'The translation tables are synchronized.'),
(10024, 'The type of this entity'),
(10025, 'The Type will be blank'),
(10026, 'The Type will Insurance or Patient'),
(10027, 'The Type would be Allergy'),
(10028, 'The Type would be Dental Issues'),
(10029, 'The Type would be Medication'),
(10030, 'The Type would be Problem indicating a medical problem'),
(10031, 'The Type would be Surgery'),
(10032, 'The UB-04 (CMS 1450) is a claim form used by hospitals, nursing facilities, in-patient, and other facility providers'),
(10033, 'The Unit column would be blank'),
(10034, 'The Units will be 1 as each code is billed only once for the encounter'),
(10035, 'The upcoming reminders have a green exclamation icon'),
(10036, 'The USB devices communicate with the host computer using the human interface device (HID) protocol, essentially mimicking a keyboard'),
(10037, 'The USB key needs to be plugged in to the computer and then registered with OpenEMR'),
(10038, 'The USB key takes this the nonce supplied by the application after confirming the checksum and generates a private key using the process similar to that used in the registration process'),
(10039, 'The user\'s actual privileges are determined by the access to the parts of the program i.e. (ACO) that each group (ARO) has.'),
(10040, 'The Username is your Direct Address'),
(10041, 'The values in the drop-down box can be edited by following the steps outlined in the Procedures > Providers help file'),
(10042, 'The values listed here will show up in the drop-down boxes that will be used to process orders'),
(10043, 'The vendor-specific code identifying this procedure or result'),
(10044, 'The vendor-specific code identifying this procedure or result. If no vendor enter any arbitrary unique number, preferably a 5 digit zero-padded e.g. 00211'),
(10045, 'The very first step would be install the ICD codes. Go to Administraion > Other > External Data Loads. Select the Code sets you want to install and click Install'),
(10046, 'The very last line of this report will give the Grand Total of Charges, Payments, Adjustments and the Balance'),
(10047, 'The Weno Exchange is well integrated with openEMR and is not subscription based'),
(10048, 'The X12 files as well as the resulting HTML output reports are archived in the \"era\" subdirectory of the main OpenEMR installation directory.  You will want to refer to these archives from time to time.  The URL is '),
(10049, 'The X12 files as well as the resulting HTML output reports are archived in the \'era\' subdirectory of the main OpenEMR installation directory. You will want to refer to these archives from time to time.'),
(10050, 'The zip file will contain the following items'),
(10051, 'Theme'),
(10052, 'Theme of the tabs layout (need to logout and then login to see this new setting).'),
(10053, 'Theme of the tabs layout (need to logout and then login to see this new setting). Note this is only applicable if use the Light or Manila general theme below.'),
(10054, 'Then pass it\'s name as a value to the element'),
(10055, 'Then press the flashing button on your key within 1 minute to complete registration'),
(10056, 'Then press the flashing button on your key within 1 minute.'),
(10057, 'Then the raw data feed release can be obtained from'),
(10058, 'Therapeutic Injections'),
(10059, 'Therapy'),
(10060, 'Therapy group'),
(10061, 'Therapy Group'),
(10062, 'Therapy Group Encounter'),
(10063, 'Therapy Group Finder'),
(10064, 'There are'),
(10065, 'There are 10 settings that are related to procedures included in the standard release of openEMR'),
(10066, 'There are 3 forms in the Core category - Demographics, Facility Specific User Information and History and all 5 forms in Transactions that can be edited '),
(10067, 'There are currently no prescriptions'),
(10068, 'There are errors with your submission.  These are outlined below.'),
(10069, 'There are four message statuses - New, Forwarded, Read and Done'),
(10070, 'There are multiple options regarding patient portals and information on how to setup the patient portal is available here'),
(10071, 'There are multiple patients with portal login'),
(10072, 'There are nine C-CDA templates that are currently defined'),
(10073, 'There are no charts checked out.'),
(10074, 'There are no disclosures recorded for this patient.'),
(10075, 'There are no Glasses or Contact Lens Presciptions on file for this patient'),
(10076, 'There are no messages on file for this patient.'),
(10077, 'There are no New Submissions'),
(10078, 'There are no notes on file for this patient.'),
(10079, 'There are no record(s) found.'),
(10080, 'There are no transactions on file for this patient.'),
(10081, 'There are several versions of HL7, versions 2.x and version 3'),
(10082, 'There are several ways to customize the fee sheet. It depends on how comfortable you are in adding information to the database itself'),
(10083, 'There are three actions that are possible - Create a New Dated Reminder, Forward and Set as Completed'),
(10084, 'There are three actions that can be performed here - edit an existing group (ARO), add a new group (ARO) or delete an existing group (ARO).'),
(10085, 'There are three main types of reports that can be created, two pertain to continuity of ongoing care - Continuity of Care Record (CCR) and Continuity of Care Document (CCD) and the third - Patient Report that creates a document containing various sections of the patient\'s medical record including demographics, medical issues, procedures and encounters. It also has the ability to include all or any of the scanned documents in the patient\'s chart'),
(10086, 'There are three options available when you create a Continuity of Care Document (CCD)'),
(10087, 'There are three options available when you create a Continuity of Care Record (CCR)'),
(10088, 'There are three sets of actions that can be performed on this page, in addition the form can be customized'),
(10089, 'There are two buttons that enable you to Check or Clear all available check-boxes'),
(10090, 'There are two options for the records that will be created'),
(10091, 'There are two sections that are visible'),
(10092, 'There are two sources that can be searched - MedlinePlus Connect or Local Content'),
(10093, 'There are two ways this can be accomplished, either by the manual method, by searching and entering data for individual invoices or by uploading an entire electronic remittance advice ERA file.'),
(10094, 'There are various selections to be filled, the minimum data needed to successfully save the referral is Referral Date, Refer To and Reason'),
(10095, 'There has been a mail error sending to'),
(10096, 'There is a lab order'),
(10097, 'There is a Post error'),
(10098, 'There is already a category named'),
(10099, 'There is already a subcategory named'),
(10100, 'There is already an item named'),
(10101, 'There is already an open patient record request.'),
(10102, 'There is no COA entry for AR account '),
(10103, 'There is no COA entry for cash account '),
(10104, 'There is no COA entry for income account '),
(10105, 'There is no current patient'),
(10106, 'There is no local content for this topic.'),
(10107, 'There is no match for invoice id'),
(10108, 'There is no match for invoice id = '),
(10109, 'There is no parts entry for services ID '),
(10110, 'There is no patient with portal login'),
(10111, 'There was a problem sending the message.'),
(10112, 'There was an error while processing your request.'),
(10113, 'There was an OpenEMR SQL Escaping ERROR of the following string'),
(10114, 'Therefore each user has to individually activate this feature'),
(10115, 'These ACOs are grouped into ten broad categories that are part of the default installation. They are - Administration, Accounting, Patient Information, Encounter Information, Squads, Sensitivities, Lists, Placeholder, Nation Notes and Patient Portal. Each of these categories has one or several sub-categories that provide access to specific parts of the program.'),
(10116, 'These are free and can be downloaded from the respective app store for ios and android devices'),
(10117, 'These are the 2012 links'),
(10118, 'These are used to populate fields 3 and 4 in the HL7 MSH - message header'),
(10119, 'These are used to populate fields 5 and 6 in the HL7 MSH - message header'),
(10120, 'These credentials will be used by the patient to login to the patient portal for the first time'),
(10121, 'These custom groups are application specific and not user specific'),
(10122, 'These entries will be used to define the Providers in the Procedures module'),
(10123, 'These groups (AROs) can then be given a set of privileges by assigning different categories (ACOs).'),
(10124, 'These items can be edited if the user has sufficient privilege'),
(10125, 'These lists are used to determine who can access what in openEMR. They work in a top down manner, i.e. initially everybody is denied access to those parts of the program controlled by the ACL.'),
(10126, 'These numbers need to match to successfully authenticate the user'),
(10127, 'These Patient notes are sent without an assigned patient'),
(10128, 'These sub-categories represent the actual Access Control Objects (ACOs).'),
(10129, 'These three steps are essential before orders can be placed and received results linked to a patient\'s chart'),
(10130, 'These Transactions are generally used to document events that have already occurred'),
(10131, 'These two actions are available for all transactions'),
(10132, 'They are displayed in rows and are sub divided into three groups'),
(10133, 'They are Electrolyte Panel, Basic Metabolic Panel, Comprehensive Metabolic Panel, Renal Function Panel, General Health Panel, Obstetric Panel, Acute Hepatitis panel, Hepatic Function Panel and Lipid Panel'),
(10134, 'They are listed in ascending order by encounter date'),
(10135, 'They do not share the vulnerabilities of SMS based methods and generally do not require an internet connection except to keep their clocks synchronized with the current time'),
(10136, 'They will be provided by the facility that you will be connecting to'),
(10137, 'Thickened Right:'),
(10138, 'Thigh'),
(10139, 'Thigh + hamstring'),
(10140, 'Things that back office can only read'),
(10141, 'Things that back office can read and enter but not modify'),
(10142, 'Things that back office can read and modify'),
(10143, 'Things that back office can read and partly modify'),
(10144, 'Things that clinicians can only read'),
(10145, 'Things that clinicians can read and enter but not modify'),
(10146, 'Things that clinicians can read and modify'),
(10147, 'Things that clinicians can read and partly modify'),
(10148, 'Things that front office can only read'),
(10149, 'Things that front office can read and enter but not modify'),
(10150, 'Things that front office can read and modify'),
(10151, 'Things that front office can read and partly modify'),
(10152, 'Things that physicians can only read'),
(10153, 'Things that physicians can read and enter but not modify'),
(10154, 'Things that physicians can read and modify'),
(10155, 'Things that physicians can read and partly modify'),
(10156, 'Third'),
(10157, 'Third account message'),
(10158, 'This account already exists.'),
(10159, 'This action CANNOT be undone.'),
(10160, 'This action cannot be undone.'),
(10161, 'This action cannot be undone. Are you sure you wish to delete this form?'),
(10162, 'This action will be logged'),
(10163, 'This action will reset your claim!'),
(10164, 'This Allows a Date Range to be Selected in Patient Flow Board.'),
(10165, 'This appointment slot is already used, please choose another.'),
(10166, 'This appointment slot is already used, use it anyway?'),
(10167, 'This appointment slot is not available, please choose another.'),
(10168, 'This Calendar Year'),
(10169, 'This claim has been canceled.'),
(10170, 'This claim has been closed.'),
(10171, 'This claim has been denied.Reason:-'),
(10172, 'This claim has been forwarded to next level.'),
(10173, 'This claim has HCFA 1500 miscellaneous billing options'),
(10174, 'This code is optional if only using manual lab data entry'),
(10175, 'This code is optional, but is a good practice to do so.'),
(10176, 'This code is optional, but is a good practice.'),
(10177, 'This code is optional.'),
(10178, 'This code type does not accept relations.'),
(10179, 'This completes a basic setup and will let use use the Fee Sheet to document charges for billing purposes'),
(10180, 'This context contains categories, which will be deleted. Do you still want to continue?'),
(10181, 'This Conversation'),
(10182, 'This Custom Favorite item can only be sent to the displayed lab, the one that was chosen in the Custom Favorite Group'),
(10183, 'This determines how appointments display on the calendar.'),
(10184, 'This determines which color schema used for appointment'),
(10185, 'This Enables provider in line item in the fee sheet'),
(10186, 'This Encounter'),
(10187, 'This encounter has been billed. If you need to change it, it must be re-opened.'),
(10188, 'This encounter has been billed. To make changes, re-open it or select Add More Items.'),
(10189, 'This encounter is locked. No new forms can be added.'),
(10190, 'This EOB item does not meet minimum print requirements setup in Globals or there is an unknown error.'),
(10191, 'This fax has already been sent.'),
(10192, 'This feature is not yet available'),
(10193, 'This feature is used to add patients to a recall list, i.e those that need an appointment at a future date but the appointment has not yet been scheduled'),
(10194, 'This feature is very experimental and not fully tested. Use at your own risk!'),
(10195, 'This feature will allow the default POS facility code to be overridden from the encounter.'),
(10196, 'This feature will allow the default POS facility code to be overriden from the encounter.'),
(10197, 'This field is used to decide whether to process the message as defined in HL7 Application (level 7) Processing rules'),
(10198, 'This form allows you to enter details of a visit or patient interaction'),
(10199, 'This fully functional Recall Board included in the default install can be used to add patients to the recall list'),
(10200, 'This gives you the option to delete any unwanted individual test in the group'),
(10201, 'This has to entered once in this form'),
(10202, 'This help file is divided into four sections'),
(10203, 'This help file is divided into the following sections'),
(10204, 'This ICD code can be automatically added to to Problem List by checking the P (Problem) checkbox. This selected item will show up in the Issues section under Medical problems'),
(10205, 'This invoice number has been changed to '),
(10206, 'This is a child of result'),
(10207, 'This is done in Administration > Users.'),
(10208, 'This is followed by the Edit and Add columns containing a pencil icon and a + icon'),
(10209, 'This is not a valid request'),
(10210, 'This is passed to the application along with checksum value and is unique for each USB key and thereby the user who owns it'),
(10211, 'This is required for both manual lab result entry and for electronic ordering tests and receiving results'),
(10212, 'This is the Beginning date for the Ledger Report.'),
(10213, 'This is the chart that is to be merged into the main chart and then deleted.'),
(10214, 'This is the default Beginning date for the Patient Flow Board. (only applicable if Allow Date Range in option above is Enabled)'),
(10215, 'This is the default Ending date for the Patient Flow Board. (only applicable if Allow Date Range in option above is Enabled)'),
(10216, 'This is the default left print margin for CMS 1500. It will adjust the final printed output left or right.'),
(10217, 'This is the default left print margin for UB04. It will adjust the final printed output left or right.'),
(10218, 'This is the default top print margin for CMS 1500. It will adjust the final printed output up or down.'),
(10219, 'This is the default top print margin for UB04. It will adjust the final printed output up or down.'),
(10220, 'This is the Ending date for the Patient Flow Board Date Range. (only applicable if Allow Date Range in option above is Enabled)'),
(10221, 'This is the latest of multiple result values.'),
(10222, 'This is the main chart that is to receive the merged data.'),
(10223, 'This is the number of messages that will be displayed in the messages widget in the patient summary screen.'),
(10224, 'This is the recommended method for a non-technical user, if executed carefully will reduce configuration errors'),
(10225, 'This is where the referrals and various other simple transactions are created'),
(10226, 'This item does not have enough data to graph'),
(10227, 'This item will be displayed on the page on a single line'),
(10228, 'This key is generated by the application and is presented to the user in the form of a QR code'),
(10229, 'This key name is already in use by you. Try again.'),
(10230, 'This layout does not exist.'),
(10231, 'This layout ID already exists'),
(10232, 'This lets you manually enter the reply to the referral as structured data'),
(10233, 'This lets you set the price level for the charges and let you charge different rates for different modes of payment.'),
(10234, 'this location'),
(10235, 'This message need not necessarily be linked to a patient'),
(10236, 'This message text is not saved automatically. Copy and save it as appropriate for the content.'),
(10237, 'This method will however result in the data becoming non-structured and one would loose the ability to document the reply in an electronic format'),
(10238, 'This module is being used by '),
(10239, 'This module is in test mode. The database will not be changed.'),
(10240, 'This module is subscription based and needs to be enabled from Administration > Globals > Connectors > Enable NewCrop eRx Service'),
(10241, 'This module is well integrated with openEMR, there are however two non-subscription based alternatives, Weno and Allscripts that can be used instead'),
(10242, 'This module promotes efficient entry of EOB data.'),
(10243, 'This Month to Date'),
(10244, 'This name already exists under this parent.'),
(10245, 'This namespace already exists in database'),
(10246, 'This new category will be a sub-category of '),
(10247, 'This order was already transmitted on'),
(10248, 'This page allows you to review each of the supported external dataloads that you can install and upgrade. Each section below can be expanded by clicking on the section header to review the status of the particular database of interest.'),
(10249, 'This page deactivated for security reasons.'),
(10250, 'This page lets you configure the orders and results'),
(10251, 'This page will inline include the login page, so that we do not have to click relogin every time.'),
(10252, 'This patient already has an appointment scheduled for'),
(10253, 'This patient does not allow SMS messaging!'),
(10254, 'This patient has no activity.'),
(10255, 'This patient ID is already in use!'),
(10256, 'This portals authentication.'),
(10257, 'This product allows only one lot per warehouse.'),
(10258, 'This protocol is not implemented'),
(10259, 'This report currently only works for ICD9 codes.'),
(10260, 'This section allows you to create and remove groups and modify or grant access privileges to existing groups. Check the check box to display section'),
(10261, 'This section can be customized to group the codes into various categories'),
(10262, 'This section DOES NOT let you create new ACOs.'),
(10263, 'This section is where the codes use to charge for the visit are selected'),
(10264, 'This section lets you search for the needed code if it is not in the default or customized options in \'Select Code\' section'),
(10265, 'This section will allow the logged in user to view existing methods or to delete them '),
(10266, 'This sets the Default Calendar View, Default is Day.'),
(10267, 'This specifies the Printing of the Custom End of Day Report grouped Provider or allow the Printing of Totals Only'),
(10268, 'This specifies whether to include date in Box 31.'),
(10269, 'This specifies which revision of the form the billing module should generate'),
(10270, 'This step will generate a file which you have to save for future use. The file cannot be generated again. Do you want to proceed?'),
(10271, 'This user is not a member of any group'),
(10272, 'This user will receive notification of new incoming Direct messages'),
(10273, 'This utility is experimental.  Back up your database and documents before using it!'),
(10274, 'This visit begins new contraceptive use'),
(10275, 'This visit will need a GCAC form, referral or procedure service.'),
(10276, 'This was the older metric-only Vitals form, now deprecated.'),
(10277, 'This Week to Date'),
(10278, 'This will abandon your unsaved changes. Are you sure?'),
(10279, 'This will activate the CCR(Continuity of Care Record) and CCD(Continuity of Care Document) reporting.'),
(10280, 'This will allow printing of a custom Message on the statements.'),
(10281, 'This will allow printing of the Patient Billing Note on the statements.'),
(10282, 'This will allow selection of the debugging (\'dummy\') language.'),
(10283, 'This will allow the display of help modal on help enabled pages'),
(10284, 'This will allow the use of the custom End of Day report and indicate which report to use.'),
(10285, 'This will allow use of the custom Dunning Messages on the statements.'),
(10286, 'This will be a \"dry run\" with no physical data updates.'),
(10287, 'This will clear the data from all Anterior Segment Exam fields'),
(10288, 'This will clear the data from all External Exam fields'),
(10289, 'This will clear the data from all Retina Exam fields'),
(10290, 'This will copy the selected code to the Diagnosis Codes box in the underlying Enter Details for Individual Custom Favorite Item pop-up form'),
(10291, 'This will create a backup in tar format and then send it to your web browser so you can save it'),
(10292, 'This will deactivate document the encryption and decryption features, and hide them in the UI.'),
(10293, 'This will disable the Edit button on all forms whose parent encounter is e-signed'),
(10294, 'This will disable the Edit button on any form that is e-signed'),
(10295, 'This will Display the Invoice Number in the Sales Report or the Patient Name and ID or Patient Name and Invoice Number.'),
(10296, 'This will enable encryption of items that are stored on the drive.'),
(10297, 'This will enable signing an entire encounter, rather than individual forms'),
(10298, 'This will enable signing individual forms separately'),
(10299, 'This will enable the Ability to Exclude Selected Patient Statements from Printing.'),
(10300, 'This will fill in the Title text-box as well as ICD10 code in the Coding text-box'),
(10301, 'This will force the Billing Widget in the Patient Summary screen to always be open.'),
(10302, 'This will give the user the option to lock (separate locking and signing)'),
(10303, 'This will give you the option to set different price levels when you are manually entering CPT codes'),
(10304, 'This will hide empty e-sign logs on the patient report'),
(10305, 'This will hide the Billing Widget in the Patient Summary screen'),
(10306, 'This will merge two patient charts into one.  It is useful when a patient has been duplicated by mistake.  If that happens often, fix your office procedures - do not run this routinely!'),
(10307, 'This will not prevent you from going to the e-Prescriptions site.'),
(10308, 'This Will Print the Next Appointment on the Bottom of the Patient Ledger'),
(10309, 'This will re-display the secret key via the QR code that can then be captured and stored on the new Smartphone via its authenticator app'),
(10310, 'This will register a new U2F USB key'),
(10311, 'This will reveal the Register TOTP Key section for logged in user'),
(10312, 'This will Show Aging on the custom Statement.'),
(10313, 'This will turn off use of safe apostrophe, which is done by converting \' and \" to `.(it is highly recommended that this setting is turned off and that safe apostrophe\'s are used)'),
(10314, 'This will use the custom immunizations list rather than the standard CVX immunization list.'),
(10315, 'This will use the custom Statement showing the description instead of the codes.'),
(10316, 'This will use the custom Statment showing the description instead of the codes.'),
(10317, 'Thoracic physician'),
(10318, 'Thoracic spine'),
(10319, 'Those with adequate privilege would be able to able to Delete the transaction'),
(10320, 'Thous/CU.MM'),
(10321, 'Three Months Ago'),
(10322, 'Three Months Ahead'),
(10323, 'Three or four digits at back of your card'),
(10324, 'Thrills'),
(10325, 'Throat'),
(10326, 'Throat Cancer'),
(10327, 'Throat Cancer Surgery'),
(10328, 'Thrombosis/Stroke'),
(10329, 'Thu'),
(10330, 'Thumbnail size'),
(10331, 'Thurdsay'),
(10332, 'Thursday'),
(10333, 'Thus far the tests that can be ordered were placed in the Procedure Order Tier, only one test at a time can be placed in this tier, when ordering a recognized panel of tests the entire panel of tests is grouped together as a single test e.g. Sodium, Potassium, Chloride and Carbon dioxide grouped as Electrolyte Panel. The results of the individual returned tests in the panel are recorded as Discrete Results'),
(10334, 'Thyroid normal'),
(10335, 'Thyroid Problems'),
(10336, 'Th{{Thursday}}'),
(10337, 'TIA'),
(10338, 'Tibetan Standard, Tibetan, Central'),
(10339, 'TID'),
(10340, 'Tier'),
(10341, 'Tier 1 - Group - e.g. Serum Chemistry'),
(10342, 'Tier 1 entries should be of Category Top Group'),
(10343, 'Tier 2 - Group (will display in category column as Sub Group) - e.g. Organ/Disease Panel'),
(10344, 'Tier 2 - Procedure Order - e.g. Serum Uric Acid'),
(10345, 'Tier 3 - Discrete Result - e.g. Serum Uric Acid - will hold the returned result value and Default Units, Default Range etc'),
(10346, 'Tier 3 - Procedure Order - e.g. Electrolyte Panel'),
(10347, 'Tier 4 - Discrete Result - The actual test names to hold the results returned Na, K, Cl, CO2 and Default Units, Default Range etc'),
(10348, 'Tigrinya'),
(10349, 'Time'),
(10350, 'Time Display Format'),
(10351, 'Time Increment for Add (minutes 1-60)'),
(10352, 'Time selection'),
(10353, 'Time slot is available, saving event'),
(10354, 'Time slot is open, saving event'),
(10355, 'Time Zone'),
(10356, 'Time-To-Live for Allergies SOAP Request in seconds'),
(10357, 'Time-To-Live for Medications SOAP Request in seconds'),
(10358, 'Time-To-Live for NewCrop eRx Allergies SOAP Request in seconds.'),
(10359, 'Time-To-Live for NewCrop eRx Medications SOAP Request in seconds.'),
(10360, 'Timed event'),
(10361, 'Times array (N/A)'),
(10362, 'Timestamp and Text'),
(10363, 'Timing'),
(10364, 'TIN'),
(10365, 'Tinnitus'),
(10366, 'Tips'),
(10367, 'Title'),
(10368, 'Title - The value that will be displayed - Each word to begin with an uppercase letter'),
(10369, 'Title V'),
(10370, 'TitleCols must be a number between 1 and 999'),
(10371, 'Titles'),
(10372, 'TM\'S:'),
(10373, 'TMs/EAMs/EE, ext nose'),
(10374, 'to'),
(10375, 'To'),
(10376, 'TO'),
(10377, 'to absolute path of file'),
(10378, 'To access it click on the Recall Board menu item in the top navigation bar or click on the Recall Board button in the Message Center'),
(10379, 'To add a copay click the \'Add Copay\' button'),
(10380, 'To add messages, please click here'),
(10381, 'To add more options to the dropdown menu go to Administration > Lists > Manage Lists and select \'Price Level\' in the dropdown box and enter the types e.g: Credit Card, Cash etc.'),
(10382, 'To add notes, please click '),
(10383, 'To add notes, please click here'),
(10384, 'To Affected Area'),
(10385, 'to affected area'),
(10386, 'To allow for each procedure line to have a separate provider you have to check the \'Support provider in line item in fee sheet\' checkbox in Administration > Globals > Billing. If not checked the rendering provider in this section will be used for all claims'),
(10387, 'To authorize the patient portal for the patient go to Dashboard > Demographics > Edit > Choices and select Yes in Allow Patient Portal drop-down box and Save'),
(10388, 'To automatically open the specified form. Some sports teams use football_injury_audit here.'),
(10389, 'To be able to link this issue to an encounter click on the button to bring up the Issues and Encounters pop-up page'),
(10390, 'To Billing View'),
(10391, 'to category'),
(10392, 'To change and activate the default parameters in the Fee Sheet go to Administration > Globals > Billing'),
(10393, 'To Clinical View'),
(10394, 'To configure the lab test go to Procedures > Configuration'),
(10395, 'To copay'),
(10396, 'To create a new message click on the Add New button at the bottom'),
(10397, 'To create another panel of tests you will repeat this process but will start by creating a Procedure Order or fruit bearing branch Tier 3, for example - Acute Hepatitis panel under the main branch or Sub Group Organ/Disease Panel (Tier 2)'),
(10398, 'To date must be later than From date!'),
(10399, 'To ded\'ble'),
(10400, 'To delete any or all the selected ICD10 codes click again on the Diagnosis Codes box to bring up the Select Diagnosis Codes pop-up window'),
(10401, 'To delink just click on the item to delink and it will get delinked and will no longer be highlighted'),
(10402, 'To Dems'),
(10403, 'To disable automatic message checking go to Administration > Globals > Connectors  and set phiMail Message Check Interval to 0 (zero) '),
(10404, 'To Disable client side SSL certificates, comment above lines in Apache configuration file and set'),
(10405, 'To Disable HTTPS, comment the above lines in Apache configuration file and restart Apache server.'),
(10406, 'To display the copay amount it must have been entered in the patient\'s insurance under Edit > Demographics'),
(10407, 'To do so click on the black + sign at the far end on the Serum Uric Acid order line to bring up the Enter Details pop-up'),
(10408, 'To edit an existing group (ARO) click on the icon next to the desired group. This will bring up the edit window.'),
(10409, 'To enable any other form of connectivity will require writing new code'),
(10410, 'To enable Client side ssl certificates'),
(10411, 'To Enable Client side SSL certificates authentication, HTTPS should be enabled.'),
(10412, 'To enable help - Go to  Administration > Globals > Features > Enable Help Modal'),
(10413, 'To enable help - Go to the User Name on top left > Settings > Features > Enable Help Modal'),
(10414, 'To enable help - Go to the User Name on top right > Settings > Features > Enable Help Modal'),
(10415, 'To Enable only HTTPS, perform the above changes and restart Apache server. If you want to configure client side certificates also, please configure them in the next section.'),
(10416, 'To enable Patient Portal go to Administration > Portal > Enable Version 2 Onsite Patient Portal, Enable Offsite Patient Portal or Enable CMS Portal'),
(10417, 'To Enctr'),
(10418, 'To filter by sex'),
(10419, 'To fulfill Meaningful use requirements and help track its use you can check on the Sent Summary of Care check-box and the Sent Summary of Care Electronically check-box if appropriate'),
(10420, 'To fully delete hit \'Save\''),
(10421, 'To get started you choose one of the two radio buttons. \'Invoice Search\' or \'ERA Upload\' '),
(10422, 'To help explore the various components of the Report page especially if you want to use it as an instruction manual it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR '),
(10423, 'To help familiarize you with the various components of the Dashboard page it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR'),
(10424, 'To help simplify implementations, commonly used templates were harmonized from existing CDA implementation guides and consolidated into a single implementation guide – the C-CDA Implementation Guide (IG) (07/2012)'),
(10425, 'To History'),
(10426, 'To include the scanned documents that are a part of the patient\'s record select the desired records by check the relevant check-boxes'),
(10427, 'To Issues'),
(10428, 'To link the Issues to an encounter first select the issue, it will be highlighted yellow, then click on one or more encounters to link them, the selected encounters will be highlighted in purple'),
(10429, 'To link this encounter/consult to an existing issue, click the '),
(10430, 'To link this encounter/consult to an existing issue, click the desired issue above to highlight it and then click [Save]. Hold down [Ctrl] button to select multiple issues.'),
(10431, 'To link this encounter/consult to an existing issue, click the desired issue above to highlight it and then click Save'),
(10432, 'to login again'),
(10433, 'To move the groups from one column to another select one or more items from the column that you need to move them out of and press the relevant button with the double chevrons.'),
(10434, 'To proceed you need a USB security key, a secure HTTPS web connection and a browser that supports U2F'),
(10435, 'To recap, a Group called Serum Chemistry (Tier 1) was created, a direct descendant or child called Serum Uric Acid (Tier 2) was created beneath it as a Procedure Order which had a single direct descendant or child also called Serum Uric Acid (Tier 3) as a Discrete Result that will hold the result value'),
(10436, 'To receive error notifications from the Direct Messaging service a valid Notification Email Address needs to be entered for the user named in Administration > Globals > Connectors > phiMail notification user'),
(10437, 'To record disclosures, please click'),
(10438, 'To register you need an authenticator app installed on your Smartphone'),
(10439, 'To resend, delete the file from Communications and try again.'),
(10440, 'To resend, delete the file from Communications, reload this page and try again.'),
(10441, 'To reveal the filters click on the eye icon'),
(10442, 'to run'),
(10443, 'To see to all the ACOs that are available click on the eye icon.'),
(10444, 'To select a particular code identify it in the returned results and click on it to select'),
(10445, 'To select multiple groups hold down the \'Shift\' or \'Ctrl\' keys while clicking.'),
(10446, 'To setup https access with client certificate authentication, do the following'),
(10447, 'To Skin'),
(10448, 'to skin'),
(10449, 'To summarize'),
(10450, 'to this visit?'),
(10451, 'To upload CCR document of already existing patient use Patient Summary Screen->Documents. For CCR document of a new patient use Miscellanous->New Documents screen'),
(10452, 'To use the help page as an instruction manual it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR '),
(10453, 'To use this help file as an instruction manual it is best to resize your browser to occupy half the screen, open another instance of the browser to fill the other half of the screen, login to openEMR and open the help file in this browser and resize it by clicking and dragging the bottom right corner so that it occupies the entire half screen'),
(10454, 'To use this help file as an instruction manual it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR'),
(10455, 'To:'),
(10456, 'To: '),
(10457, 'TO_CITY'),
(10458, 'TO_FAX'),
(10459, 'TO_FNAME'),
(10460, 'TO_LNAME'),
(10461, 'TO_MNAME'),
(10462, 'TO_ORGANIZATION'),
(10463, 'TO_PHONE'),
(10464, 'TO_PHONECELL'),
(10465, 'TO_POSTAL'),
(10466, 'TO_STATE'),
(10467, 'TO_STREET'),
(10468, 'TO_TITLE'),
(10469, 'TO_VALEDICTORY'),
(10470, 'Tobacco'),
(10471, 'Tobacco Cessation Intervention'),
(10472, 'Tobacco Cessation Intervention (CQM)'),
(10473, 'Tobacco use'),
(10474, 'Tobacco Use'),
(10475, 'Tobacco Use Assessment'),
(10476, 'Tobacco Use Assessment (CQM)'),
(10477, 'Today'),
(10478, 'TODAY'),
(10479, 'today'),
(10480, 'Today\'s Balance'),
(10481, 'Today\'s Charges'),
(10482, 'Today\'s Date'),
(10483, 'Today\'s Events'),
(10484, 'Toggle'),
(10485, 'Toggle All'),
(10486, 'Toggle navigation'),
(10487, 'Toggle the Patient Panel'),
(10488, 'Toggle the right-sided PMSFH panel'),
(10489, 'Token ID for the Medical Information Integration, LLC Lab Exchange Service.'),
(10490, 'Token ID for the OpenEMR Support LLC Lab Exchange Service.'),
(10491, 'Tonga (Tonga Islands)'),
(10492, 'Tonsillectomy'),
(10493, 'tonsillectomy'),
(10494, 'Tooltips'),
(10495, 'Top'),
(10496, 'Top Group'),
(10497, 'Top Margin (mm)'),
(10498, 'Topic'),
(10499, 'Total'),
(10500, 'total'),
(10501, 'Total active actions'),
(10502, 'Total active reminders after update'),
(10503, 'Total active reminders before update'),
(10504, 'Total Adj'),
(10505, 'Total amount due'),
(10506, 'Total Amount Paid'),
(10507, 'Total Balance Due'),
(10508, 'Total Charge'),
(10509, 'Total Charges'),
(10510, 'Total Clients'),
(10511, 'Total Co-Pay'),
(10512, 'Total Cost'),
(10513, 'Total Distribution for following check number is not full'),
(10514, 'total entries'),
(10515, 'Total failed reminders sent via email'),
(10516, 'Total failed reminders sent via phone'),
(10517, 'Total for'),
(10518, 'Total for '),
(10519, 'Total for category'),
(10520, 'Total inactivated reminders'),
(10521, 'Total Minimum Amount of Statement to Allow Printing'),
(10522, 'Total Minimum Dollar Amount of Statement to Allow Printing.(only applicable if Allow Statement Exclusions from Printing is enabled)'),
(10523, 'Total new reminders'),
(10524, 'Total number of appointments'),
(10525, 'Total number of Drug Screen entries'),
(10526, 'Total Number of Immunizations'),
(10527, 'Total Number of Issues'),
(10528, 'Total number of Patient Flow Board entries'),
(10529, 'Total Number of Patients'),
(10530, 'Total Pages'),
(10531, 'Total Patient Balance'),
(10532, 'Total patients'),
(10533, 'Total Patients'),
(10534, 'Total Payments'),
(10535, 'Total Records'),
(10536, 'total records'),
(10537, 'Total Records Found'),
(10538, 'Total size'),
(10539, 'Total SRH & Family Planning'),
(10540, 'Total successful reminders sent via email'),
(10541, 'Total successful reminders sent via phone'),
(10542, 'Total Time'),
(10543, 'Total Transfers'),
(10544, 'Total unchanged reminders'),
(10545, 'Total unsent reminders after sending process'),
(10546, 'Total unsent reminders after update'),
(10547, 'Total unsent reminders before sending process'),
(10548, 'Total unsent reminders before update'),
(10549, 'Total updated reminders'),
(10550, 'Totals'),
(10551, 'Totals for'),
(10552, 'Totals for '),
(10553, 'Totals Only'),
(10554, 'TOTP'),
(10555, 'TOTP - Cons'),
(10556, 'TOTP - Pros'),
(10557, 'TOTP - Time-Based One-Time Password'),
(10558, 'TOTP Key'),
(10559, 'TOTP Method already exists and is enabled. Try again.'),
(10560, 'TOTP Registration'),
(10561, 'TOTP Verification'),
(10562, 'to{{range}}'),
(10563, 'To{{range}}'),
(10564, 'Tpn{{Tonopen abbreviation}}'),
(10565, 'TP{{tonopen}}'),
(10566, 'tr'),
(10567, 'Track'),
(10568, 'Track Report'),
(10569, 'Tracks'),
(10570, 'Tracks - if the Track Anything feature is enabled it will display a list of values that can be tracked and graphed'),
(10571, 'Train'),
(10572, 'Trainer'),
(10573, 'Training'),
(10574, 'Training Type'),
(10575, 'Transact'),
(10576, 'Transaction'),
(10577, 'transaction'),
(10578, 'Transaction failed, insufficient quantity in destination lot'),
(10579, 'Transaction failed, quantity is less than zero'),
(10580, 'Transaction Id'),
(10581, 'Transaction Type'),
(10582, 'Transactions'),
(10583, 'transactions'),
(10584, 'Transactions (write optional)'),
(10585, 'Transactions (write optional) (trans)'),
(10586, 'Transactions - lists various notes about happenings in a patient\'s chart with respect to billing, legal, patient request, physician request and also generates a patient referral or counter-referral'),
(10587, 'Transactions are for events or information not necessarily tied to one specific visit or encounter'),
(10588, 'Transactions provides a mechanism to link an activity to patient that is not encounter based'),
(10589, 'Transactions, e.g. referrals (write optional) (trans)'),
(10590, 'Transactions/Referrals'),
(10591, 'Transdermal'),
(10592, 'Transfer'),
(10593, 'Transfer date'),
(10594, 'Transfer failed, insufficient quantity in source lot'),
(10595, 'Transfer Summary'),
(10596, 'Transfer to'),
(10597, 'Transferred By'),
(10598, 'Transferred Date'),
(10599, 'Transfers'),
(10600, 'Transition Of Care'),
(10601, 'Transition/Transfer of Care?'),
(10602, 'Translate Access Control Groups'),
(10603, 'Translate Appointment Categories'),
(10604, 'Translate Document Categories'),
(10605, 'Translate Layouts'),
(10606, 'Translate Lists'),
(10607, 'Translate Patient Note Titles'),
(10608, 'translate this'),
(10609, 'Translation'),
(10610, 'Translations'),
(10611, 'Transmit'),
(10612, 'Transmit - securely transmit the CCD using phiMail Direct Messaging'),
(10613, 'Transmit - securely transmit the CCR using phiMail Direct Messaging'),
(10614, 'Transmit failed'),
(10615, 'Transmit Order'),
(10616, 'Transmit Selected Orders'),
(10617, 'Trash'),
(10618, 'Trauma'),
(10619, 'Treatment'),
(10620, 'Treatment Completion Status'),
(10621, 'Treatment Goals'),
(10622, 'Treatment Plan'),
(10623, 'Treatment Planning'),
(10624, 'Treatment Received'),
(10625, 'Treatment:'),
(10626, 'Treatment: '),
(10627, 'Tree'),
(10628, 'Trend'),
(10629, 'trftime($month_format, mktime(0, 0, 0, $i, 1, 2000)) );             $month_value'),
(10630, 'Tribal 638 Free-standing Facility'),
(10631, 'Tribal 638 Provider-based Facility'),
(10632, 'Trifocal'),
(10633, 'Trifocals'),
(10634, 'Trigger point / compartment syndrome / DOMS / cramp'),
(10635, 'Trimalleolar'),
(10636, 'Tropic 2.5%'),
(10637, 'Trunk and abdomen'),
(10638, 'Trusted Direct Email Address'),
(10639, 'Trusted Email'),
(10640, 'Trying'),
(10641, 'Trying to create user with existing username!'),
(10642, 'Tsonga'),
(10643, 'tsp'),
(10644, 'Tswana'),
(10645, 'TTS'),
(10646, 'Tuberculosis'),
(10647, 'Tue'),
(10648, 'Tues &amp; Thur'),
(10649, 'Tuesday'),
(10650, 'Tumour'),
(10651, 'Turkish'),
(10652, 'Turkmen'),
(10653, 'Turn off auto calculations of adjustments in EOB'),
(10654, 'Turn Off birthday alert'),
(10655, 'Turn on to show all payment history in Patient Ledger'),
(10656, 'Turn the Tooltips on/off'),
(10657, 'Tu{{Tuesday}}'),
(10658, 'Twi'),
(10659, 'twice daily'),
(10660, 'Two Years Ago'),
(10661, 'Two Years Ahead'),
(10662, 'Tx Date'),
(10663, 'Tympanic Membrane'),
(10664, 'Type'),
(10665, 'Type a brief message and hit Send Message '),
(10666, 'Type a name for the key in the text box'),
(10667, 'Type a name for your key, insert it into a USB port and click the Register button below'),
(10668, 'Type Id or Name.3 characters minimum (including spaces).'),
(10669, 'Type in Electrolyte Panel as the Name'),
(10670, 'Type in the location of the directory or folder in which the created orders (HL7 messages) will be stored'),
(10671, 'Type in the location of the directory or folder in which the returned results (HL7 messages) will be stored'),
(10672, 'Type in the URL of the external facility to which the order will be sent, this will be provided by the facility'),
(10673, 'Type in the username and password provided by the facility'),
(10674, 'Type of columns displayed for patient search results'),
(10675, 'Type of Disclosure'),
(10676, 'Type of Events'),
(10677, 'Type of group'),
(10678, 'Type of screen layout'),
(10679, 'Type or scan the patient identifier here'),
(10680, 'Type Sodium under Name and Sodium result under description'),
(10681, 'Type the message and click Send Message '),
(10682, 'Type the name of the drug in the Drug Search text-box'),
(10683, 'Type to search and select revenue code'),
(10684, 'Type Your message here'),
(10685, 'Types of Orders and Results'),
(10686, 'T{{one letter abbreviation for Tension/Pressure}}'),
(10687, 'T{{Thursday}}'),
(10688, 'T{{Tuesday}}'),
(10689, 'U2F'),
(10690, 'U2F - Cons'),
(10691, 'U2F - Pros'),
(10692, 'U2F devices are relatively costly'),
(10693, 'U2F Key Authentication error'),
(10694, 'U2F Key Verification'),
(10695, 'U2F Registration'),
(10696, 'U2F USB Device'),
(10697, 'UAC Appl'),
(10698, 'UAC Tot'),
(10699, 'UB04 FORM'),
(10700, 'UB04 FORM PDF'),
(10701, 'UB04 left margin in points'),
(10702, 'UB04 Margins'),
(10703, 'UB04 Margins Left'),
(10704, 'UB04 TEXT PDF'),
(10705, 'UB04 top margin in points'),
(10706, 'UCSMC codes provided by the University of Calgary Sports Medicine Centre'),
(10707, 'Ukrainian'),
(10708, 'Ulcerations'),
(10709, 'Ulcerative Colitis'),
(10710, 'Ulcers:'),
(10711, 'Unable insert version information into database'),
(10712, 'Unable to access directory'),
(10713, 'Unable to access URL'),
(10714, 'Unable to create'),
(10715, 'Unable to create patient document subdirectory'),
(10716, 'Unable to decrypt these comments since decryption failed.'),
(10717, 'Unable to decrypt these comments since the PHP mycrypt module is not installed.'),
(10718, 'Unable to decrypt these comments since the PHP openssl module is not installed.'),
(10719, 'Unable to either create credentials or send email.'),
(10720, 'Unable to find window to build'),
(10721, 'Unable to find your records. Be sure to use your correct Dob, First and Last name and Email of record. If you have opted out of email with none on file then leave blank.'),
(10722, 'Unable to locate the data in this file.'),
(10723, 'Unable to match this payment in ar_activity'),
(10724, 'Unable to modify application config Please give write permission to'),
(10725, 'Unable to save file: Use back button!'),
(10726, 'Unapplied'),
(10727, 'Unassigned'),
(10728, 'Unauthorized'),
(10729, 'Unauthorized access to ePrescription'),
(10730, 'Unauthorized access.'),
(10731, 'Unbilled'),
(10732, 'Unbilled Only'),
(10733, 'Uncategorized'),
(10734, 'Uncle'),
(10735, 'under tongue'),
(10736, 'Underneath it will be some common drugs'),
(10737, 'Underneath it will be some common problems'),
(10738, 'Underweight'),
(10739, 'Undiagnosed'),
(10740, 'Undistributed'),
(10741, 'UNDISTRIBUTED'),
(10742, 'Undistributed is'),
(10743, 'Undo'),
(10744, 'Undo Checkout'),
(10745, 'Unexpected non-match, creating new patient for segment'),
(10746, 'Unique Clients'),
(10747, 'Unique human-readable identifier for this type'),
(10748, 'Unique New Clients'),
(10749, 'Unique numeric identifier for this type'),
(10750, 'Unique Seen Patients'),
(10751, 'Unique Seen Patients Report'),
(10752, 'Unique SP'),
(10753, 'Unit'),
(10754, 'Units'),
(10755, 'units'),
(10756, 'Units applicable to the result value'),
(10757, 'Units for Visit Forms'),
(10758, 'Units must be a number'),
(10759, 'Units not defined'),
(10760, 'Units/L'),
(10761, 'Unknown'),
(10762, 'unknown (see log)'),
(10763, 'Unknown Error'),
(10764, 'Unknown if ever smoked'),
(10765, 'Unknown or N/A'),
(10766, 'Unknown Transaction Error Maybe Subscriber Effective or DOB Dates'),
(10767, 'Unknown user id:'),
(10768, 'Unknown version'),
(10769, 'Unlike a message sent in Messages the dated reminder is not a part of the medical record'),
(10770, 'Unlike ordering a recognized panel as a single test and thus have all the component tests performed these three tests will be presented as three individual tests'),
(10771, 'Unlike the regular Groups that were created earlier, each Custom Favorite Group has an Identifying Code that has to be unique. As this is our custom group and not a lab recognized panel we will give it our arbitrary unique Identifying Code - CFGWWT001'),
(10772, 'Unlike the regular Procedure Order a Diagnostic Codes box is present allowing you to enter one or more ICD10 Diagnosis Codes as default diagnoses for this order'),
(10773, 'Unlike the regular Top Groups created thus far the Code column will have a value CFGWWT001'),
(10774, 'Unlike TOTP where there is no communication between the application and the device having the authenticator app each time the USB key is plugged in the application communicates with the USB key via the browser'),
(10775, 'unlink patient'),
(10776, 'Unnamed insurance company'),
(10777, 'Unregistered'),
(10778, 'Unregistered Modules'),
(10779, 'Unrelated Friend'),
(10780, 'Unselect All'),
(10781, 'Unselected'),
(10782, 'Unspecified'),
(10783, 'unstructured'),
(10784, 'Unstructured Documents - 2010'),
(10785, 'UNSUPPORTED database load file'),
(10786, 'Unsupported MDM OBX result type'),
(10787, 'until'),
(10788, 'until date'),
(10789, 'Until then you will continue to see payment details here.'),
(10790, 'Untimely filing'),
(10791, 'Unused'),
(10792, 'UOR'),
(10793, 'Up to'),
(10794, 'UPCOMING'),
(10795, 'Upcoming Appointments'),
(10796, 'Upcoming Events'),
(10797, 'Update'),
(10798, 'update'),
(10799, 'Update Active'),
(10800, 'Update by'),
(10801, 'Update files'),
(10802, 'Update Info'),
(10803, 'Update information when the patient goes to another provider, to support safety, quality, and continuity of patient care'),
(10804, 'Update List'),
(10805, 'Update policy number from ERA'),
(10806, 'Update Provider Number'),
(10807, 'Update Selected Items'),
(10808, 'Update Status'),
(10809, 'Update the chart to activate the Builder.'),
(10810, 'Update the chart to build this list'),
(10811, 'Update the following variables in file'),
(10812, 'Update User Information'),
(10813, 'Updated By'),
(10814, 'Updated fields will be purple.'),
(10815, 'Updated!'),
(10816, 'Updating demographics is not authorized.'),
(10817, 'Updating global configuration defaults'),
(10818, 'Updating version indicators'),
(10819, 'UPGRADE'),
(10820, 'Upgrade'),
(10821, 'Upgrade Database'),
(10822, 'Upgrades the OpenEMR database to include Procedures, Functions and tables needed for De-identification process'),
(10823, 'Upgrading will continue'),
(10824, 'UPIN'),
(10825, 'Upload'),
(10826, 'Upload / Save'),
(10827, 'Upload a Template'),
(10828, 'Upload and Apply'),
(10829, 'Upload and Install'),
(10830, 'Upload configuration data'),
(10831, 'Upload Document'),
(10832, 'Upload failed!'),
(10833, 'Upload Image to'),
(10834, 'Upload import file:'),
(10835, 'Upload Item'),
(10836, 'Upload Patient Education PDF to'),
(10837, 'Upload processed successfully'),
(10838, 'Upload Report'),
(10839, 'Upload Template for'),
(10840, 'Upload the xml file under the category CCR'),
(10841, 'Upload this file:'),
(10842, 'Upon a successful search you are presented with a list of invoices. You may click on one of the invoice numbers to open a second window, which is the data entry page for manual posting. You may also click on a patient name if you want to enter a note that the front office staff will see when the patient checks in, and you may select invoices to appear on patient statements and print those statements.'),
(10843, 'Upon clicking an invoice number the \"manual posting window\" appears. Here you can change the due date and notes for the invoice, select the party for whom you are posting, and select the insurances for which all expected paymants have been received.  Most importantly, for each billing code for which an amount was charged, you can enter payment and adjustment information.'),
(10844, 'Upon clicking an invoice number the \'manual posting window\' appears. Here you can change the due date and notes for the invoice, select the party for whom you are posting, and select the insurances for which all expected payments have been received. Most importantly, for each billing code for which an amount was charged, you can enter payment and adjustment information.'),
(10845, 'Upon entering the page there are two buttons visible below the navigation bar'),
(10846, 'Upon logging in to openEMR a small envelope icon is visible on the top right. It shows the number of pending messages and dated reminders'),
(10847, 'Upon reaching a predetermined point, either a date or value, the rule will trigger one or more events'),
(10848, 'Upon searching you are presented with a list of invoices.  You may click on one of the invoice numbers to open a second window, which is the data entry page for manual posting.  You may also click on a patient name if you want to enter a note that the front office staff will see when the patient checks in, and you may select invoices to appear on patient statements and print those statements.'),
(10849, 'Upon selecting a list to edit the edit page with the list values will be displayed'),
(10850, 'Upon successful registration you will be taken back to the Manage Multi Factor Authentication landing page'),
(10851, 'Upper arm'),
(10852, 'Upper Lids'),
(10853, 'Urdu'),
(10854, 'Urgency'),
(10855, 'Urgent Care'),
(10856, 'Urgent Care Facility'),
(10857, 'Urine'),
(10858, 'Urine Dribbling'),
(10859, 'Urine Frequency'),
(10860, 'Urine Hesitancy'),
(10861, 'Urine Microalbumin'),
(10862, 'Urine Stream'),
(10863, 'Urine Urgency'),
(10864, 'URL'),
(10865, 'URL for NewCrop eRx Site Address.'),
(10866, 'URL for OpenEMR support.'),
(10867, 'URL for Phone Gateway.'),
(10868, 'URL for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(10869, 'URL for the WordPress site that supports the portal'),
(10870, 'URLs for NewCrop eRx Service Address, separated by a semi-colon.'),
(10871, 'USA'),
(10872, 'Usage'),
(10873, 'Usage - is only required if you are submitting an electronic order to an external facility'),
(10874, 'Usage Indicator (ISA15)'),
(10875, 'Usage Tips'),
(10876, 'USB based tokens are used for Universal 2nd Factor - U2F authentication and as they are connected to a computer do not need batteries'),
(10877, 'Use % alone in a field to just sort on that column'),
(10878, 'Use 24 hour time format?'),
(10879, 'Use a pdf template from zend module'),
(10880, 'Use a unique word to identify this group, it has to be a single word, if using two words link them together with an underscore or hyphen.'),
(10881, 'Use Active Directory'),
(10882, 'Use an html template from zend module'),
(10883, 'Use Avery Labels'),
(10884, 'Use Blood or Serum as Specimen Type'),
(10885, 'Use certified EHR technology to identify patient-specific education resources and provide those resources to the patient if appropriate(New).'),
(10886, 'Use certified EHR technology to identify patient-specific education resources and provide those resources to the patient if appropriate.'),
(10887, 'Use Charges Panel'),
(10888, 'Use CPOE for medication orders directly entered by any licensed healthcare professional who can enter orders into the medical record per state, local and professional guidelines.'),
(10889, 'Use CPOE for medication orders.'),
(10890, 'Use CPOE for medication orders.(Alternative)'),
(10891, 'Use CPOE for procedure orders.'),
(10892, 'Use CPOE for radiology orders.'),
(10893, 'Use Custom Dunning Messages'),
(10894, 'Use Custom End of Day Report'),
(10895, 'Use Custom Immunization List'),
(10896, 'Use Custom Statement'),
(10897, 'Use Date Range'),
(10898, 'Use Defaults'),
(10899, 'Use Delete Option to Remove.'),
(10900, 'Use international date style?'),
(10901, 'Use Portal Dashboard to confirm with patient.'),
(10902, 'Use servers protocol and host in urls (portal internal only).'),
(10903, 'Use source filename'),
(10904, 'Use the fee sheet to charge for services or products. '),
(10905, 'Use the fields below for a purchase or transfer.'),
(10906, 'Use the help file on that page for further help'),
(10907, 'Use the latest versions of the following modern browsers - Chrome, Firefox, Safari, Edge and Opera'),
(10908, 'Use the Select User dropdown box to select the user(s) to whom the message will be sent'),
(10909, 'Use this feature only with newly installed sites, '),
(10910, 'Use this section to delete existing groups or Access Request Objects (AROs)'),
(10911, 'Use topics?'),
(10912, 'Used to enter information that pertains to this particular claim in order to facilitate processing and submitting this claim'),
(10913, 'User'),
(10914, 'User '),
(10915, 'User / Groups'),
(10916, 'User Administration'),
(10917, 'User and Facility Administration'),
(10918, 'User and Group Administration'),
(10919, 'User Cannot be Deleted'),
(10920, 'User Certificate Authentication is disabled'),
(10921, 'User Debugging Mode.'),
(10922, 'User Debugging Options'),
(10923, 'User Defined'),
(10924, 'User Defined Area 11'),
(10925, 'User Defined Area 12'),
(10926, 'User Defined Field'),
(10927, 'User Defined List 1'),
(10928, 'User Defined List 2'),
(10929, 'User Defined List 3'),
(10930, 'User Defined List 4'),
(10931, 'User Defined List 5'),
(10932, 'User Defined List 6'),
(10933, 'User Defined List 7'),
(10934, 'User Defined Text 1'),
(10935, 'User Defined Text 2'),
(10936, 'User Defined Text 3'),
(10937, 'User Defined Text 4'),
(10938, 'User Defined Text 5'),
(10939, 'User Defined Text 6'),
(10940, 'User Defined Text 7'),
(10941, 'User Defined Text 8'),
(10942, 'User First name'),
(10943, 'User Id'),
(10944, 'User ID'),
(10945, 'User is required to have this access control for Active Alerts and Passive Alerts'),
(10946, 'User Logon (If 03 above, else leave spaces) (ISA02)'),
(10947, 'User logon Required Indicator (ISA01~ use 00 or 03)'),
(10948, 'User Manual'),
(10949, 'User Memberships'),
(10950, 'User Name'),
(10951, 'User name or Host name cannot be empty'),
(10952, 'User or Host name'),
(10953, 'User Password'),
(10954, 'User Password (ISA04~ if 01 above, else leave spaces)'),
(10955, 'User password required Indicator (ISA03~ use 00 or 01)'),
(10956, 'User Settings'),
(10957, 'User Signature'),
(10958, 'User Specific Setting'),
(10959, 'User\'s New Password'),
(10960, 'Userlist1'),
(10961, 'Userlist2'),
(10962, 'Userlist3'),
(10963, 'Userlist4'),
(10964, 'Userlist5'),
(10965, 'Userlist6'),
(10966, 'Userlist7'),
(10967, 'username'),
(10968, 'Username'),
(10969, 'Username for Phone Gateway.'),
(10970, 'Username for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(10971, 'Username for SMS Gateway'),
(10972, 'Username for SMS Gateway.'),
(10973, 'Username to connect to CouchDB'),
(10974, 'Username:'),
(10975, 'Users'),
(10976, 'Users is the standard windows CN, replace the DC stuff with your domain.'),
(10977, 'Users may leave it plugged in at all times thus negating its function in 2FA'),
(10978, 'Users with appropriate privileges can edit these items by clicking on the Edit button'),
(10979, 'Users/Groups/Logs Administration'),
(10980, 'Users/Groups/Logs Administration (users)'),
(10981, 'Usertext1'),
(10982, 'Usertext2'),
(10983, 'Usertext3'),
(10984, 'Usertext4'),
(10985, 'Usertext5'),
(10986, 'Usertext6'),
(10987, 'Usertext7'),
(10988, 'Usertext8'),
(10989, 'uses php <a href=\"http://php.net/strftime\">strftime</a> format'),
(10990, 'Using 2FA'),
(10991, 'Using a fruit tree as an easier to visualize analogy will explain the concept of this hierarchy better, the trunk of the tree is the Group (Serum Chemistry), the fruit bearing branch is the actual order, Procedure Order (Serum Uric acid) and the fruit is the result, Discrete Result, also called (Serum Uric Acid) that will hold the value of the returned result. Just as the fruit is not borne on the main trunk you should not place a Discrete Result as a direct descendant or child of a Top Group. Similarly the fruit bearing branch (Procedure Order) cannot be placed as a direct descendant or child of a fruit (Discrete Result)'),
(10992, 'Using technology to improve productivity'),
(10993, 'Using the details entered into the system openEMR will generate valid HL7 v2.3 messages in 3 formats, a text file that is automatically downloaded to the downloads folder of your browser, a HL7 message that is written to a folder or directory on the server running openEMR or use SFTP - Secure File Transfer Protocol, which is a network protocol that provides file access, file transfer, and file management over a secure connection and transfer this message to a lab'),
(10994, 'Using the Feesheet'),
(10995, 'Using the main headings on the lab slip will help start this process - Organ/Disease Panels, Hematology, Individual Tests, Microbiology, Other'),
(10996, 'Using this fruit tree analogy we can get a better understanding of the steps needed to create an order for a panel of tests'),
(10997, 'UTIs'),
(10998, 'Uyghur, Uighur'),
(10999, 'Uzbek'),
(11000, 'VACATION'),
(11001, 'Vacation'),
(11002, 'Vaccine'),
(11003, 'Vaccine funding program eligibility category'),
(11004, 'Vaccine Type'),
(11005, 'Vaginal Ring'),
(11006, 'Valedictory'),
(11007, 'Validate'),
(11008, 'validate'),
(11009, 'Validate Log'),
(11010, 'Validating'),
(11011, 'Validation error: Fix and resubmit.'),
(11012, 'Validation error: Fix and resubmit. Payment values are preserved!'),
(11013, 'Validation error: Fix and resubmit. This popup info is preserved!'),
(11014, 'Validation mechanism for when modifying patient demographics.'),
(11015, 'Validation rule'),
(11016, 'Value'),
(11017, 'Value 1'),
(11018, 'Value 2'),
(11019, 'Value if comparing'),
(11020, 'Value Should be Numeric'),
(11021, 'Var1'),
(11022, 'Var2'),
(11023, 'variable to one to run de-identification upgrade script'),
(11024, 'Variation in red color discrimination between the eyes (eg. OD=100, OS=75)'),
(11025, 'Variation in white (muscle) light brightness discrimination between the eyes (eg. OD=$1.00, OS=$0.75)'),
(11026, 'Varicella 1'),
(11027, 'Varicella 2'),
(11028, 'Varicose Veins'),
(11029, 'Various text fields and drop-down boxes will be displayed'),
(11030, 'Vascular condition'),
(11031, 'Vascular injury'),
(11032, 'Vascular Surgery'),
(11033, 'Va{{Visual Acuities}}'),
(11034, 'VB{{abbreviation for Vertical Prism Base}}'),
(11035, 'VD{{abbreviation for Vertex Distance}}'),
(11036, 'Venda'),
(11037, 'Vendor'),
(11038, 'Verified On'),
(11039, 'Verify'),
(11040, 'Version'),
(11041, 'Version 1 Onsite Patient Portal Site Address'),
(11042, 'Version 2 Onsite Patient Portal Site Address'),
(11043, 'Version 2.x is widely used in the healthcare industry and openEMR uses HL7 version 2.3 '),
(11044, 'Version Number'),
(11045, 'Vert Base{{abbreviation for Vertical Prism Base}}'),
(11046, 'Vert Distance{{abbreviation for Vertex Distance}}'),
(11047, 'Vert Fissure{{vertical fissure height}}'),
(11048, 'Vert Fissure{{vertical fissure}}'),
(11049, 'Vert Fusional Amps'),
(11050, 'Vert Prism{{abbreviation for Vertical Prism Power}}'),
(11051, 'Vertex Distance'),
(11052, 'Vertical Fissure: central height between lid margins'),
(11053, 'Vertical Fusional'),
(11054, 'Vertical Menu Style'),
(11055, 'Vertical Menu Style for frame based layouts'),
(11056, 'Vertical Menu Style for Frames'),
(11057, 'Vertical Prism Base'),
(11058, 'Vertical Prism Power'),
(11059, 'Vertigo'),
(11060, 'Very secure'),
(11061, 'Vessels'),
(11062, 'Veteran`s Administration'),
(11063, 'Veterans Administration Plan'),
(11064, 'Vfc'),
(11065, 'VFC'),
(11066, 'VFC eligible- American Indian/Alaskan Native'),
(11067, 'VFC eligible- Uninsured'),
(11068, 'VFC eligible-Federally Qualified Health Center Patient (under-insured)'),
(11069, 'VFC eligible-Medicaid/Medicaid Managed Care'),
(11070, 'VF{{vertical fissure}}'),
(11071, 'via{{shipped by/supplier}}'),
(11072, 'Vietnamese'),
(11073, 'view'),
(11074, 'View'),
(11075, 'view - can only read but not add or modify'),
(11076, 'View Allergies'),
(11077, 'View an x12-835 ERA file'),
(11078, 'View Batch Claim x12 text'),
(11079, 'View Blank Referral Form'),
(11080, 'View CCD'),
(11081, 'View CCDA'),
(11082, 'View Comprehensive Patient Report'),
(11083, 'View CSV tables'),
(11084, 'View details'),
(11085, 'View document'),
(11086, 'View EDI x12 file'),
(11087, 'View encounter'),
(11088, 'View ERA x12 text'),
(11089, 'View events in a popup window?'),
(11090, 'View Facility Specific User Information'),
(11091, 'View Four Panel'),
(11092, 'View local x12 file'),
(11093, 'View Log'),
(11094, 'View Messages'),
(11095, 'View mode - only administrator can edit another administrator user'),
(11096, 'View Page 1'),
(11097, 'View Page 2'),
(11098, 'View Past and Future Reminders'),
(11099, 'View Past Encounter'),
(11100, 'View Past Encounters'),
(11101, 'View Patient'),
(11102, 'View Plan Rules'),
(11103, 'View Printable'),
(11104, 'View Printable Report'),
(11105, 'View Printable Version'),
(11106, 'View related encounters'),
(11107, 'View Report'),
(11108, 'View the README file'),
(11109, 'View the Summary Report sent to Fax Server.'),
(11110, 'View the Summary Report sent via Fax Server on'),
(11111, 'View, Download, Transmit (VDT)  (Measure B)'),
(11112, 'View, Download, Transmit (VDT) (Measure A)'),
(11113, 'View/Add/Update groups'),
(11114, 'View/Add/Update groups (gadd)'),
(11115, 'View/Create/Update groups appointment in calendar'),
(11116, 'View/Create/Update groups appointment in calendar (gcalendar)'),
(11117, 'View/Edit'),
(11118, 'View/Edit Allergies'),
(11119, 'View/edit issue'),
(11120, 'View/Print'),
(11121, 'View/Print Blank Referral Form'),
(11122, 'View/Print Blank Referral Form - that can be filled by hand'),
(11123, 'View:'),
(11124, 'VISA'),
(11125, 'VISA/MC/AMEX/Dis'),
(11126, 'VISA/MC/Discovery/HSA'),
(11127, 'Visceral damage/trauma/surgery'),
(11128, 'VisForm'),
(11129, 'Vision'),
(11130, 'Visit'),
(11131, 'Visit Attributes'),
(11132, 'Visit Categories'),
(11133, 'Visit Category'),
(11134, 'Visit Category:'),
(11135, 'Visit Date'),
(11136, 'Visit date'),
(11137, 'Visit Details'),
(11138, 'Visit Form Attributes'),
(11139, 'Visit form ID must start with LBF. Transaction form ID must start with LBT.'),
(11140, 'Visit Forms'),
(11141, 'Visit History'),
(11142, 'Visit Patient Home Page'),
(11143, 'Visit Provider Home Page'),
(11144, 'Visit Reason'),
(11145, 'Visit Status'),
(11146, 'Visit Summary'),
(11147, 'Visit Test Server'),
(11148, 'Visit Type'),
(11149, 'Visited Patients'),
(11150, 'Visits'),
(11151, 'Visits From'),
(11152, 'Visual Acuities'),
(11153, 'Visual Acuity'),
(11154, 'Visual Fields'),
(11155, 'Visualize this as not making a fruit hang off another fruit. Instead it should hang off the fruit bearing branch'),
(11156, 'Vital Signs'),
(11157, 'Vitals'),
(11158, 'Vitals (Metric)'),
(11159, 'Vitals Form Options'),
(11160, 'Vitreous'),
(11161, 'Voice'),
(11162, 'Voice Messages'),
(11163, 'Voice Sent'),
(11164, 'Voice your opinion'),
(11165, 'Void Checkout and Re-Open'),
(11166, 'Volapuk'),
(11167, 'Volapük'),
(11168, 'Vomiting'),
(11169, 'Voucher Number'),
(11170, 'VP{{abbreviation for Vertical Prism Power}}'),
(11171, 'V{{One letter abbrevation for Vision}}'),
(11172, 'W'),
(11173, 'W Rx{{Acuity with correction}}'),
(11174, 'W2W{{white-to-white}}'),
(11175, 'Waist Circ'),
(11176, 'Waist Circumference'),
(11177, 'Waiting'),
(11178, 'Walk-In'),
(11179, 'Walk-in Retail Health Clinic'),
(11180, 'Walloon'),
(11181, 'Walt Pennington'),
(11182, 'Ward of court'),
(11183, 'Warehouse'),
(11184, 'Warehouse changed'),
(11185, 'Warehouse maximum, 0 if not applicable'),
(11186, 'Warehouse minimum, 0 if not applicable'),
(11187, 'Warehouses'),
(11188, 'Warm'),
(11189, 'Warning'),
(11190, 'WARNING'),
(11191, 'WARNING - FOLLOWING ACTIVE MEDICATIONS ARE ALLERGIES'),
(11192, 'Warning, Check Number already exist in the database'),
(11193, 'Warning, patient has ambiguous codes in the problems list!'),
(11194, 'Warning: A visit was already created for this patient today!'),
(11195, 'Warning: Contraception for a patient under 10 or over 50.'),
(11196, 'Warning: Contraceptive method is not compatible with a male patient.'),
(11197, 'WARNING: If you are using the 2012-10-31 Spanish version, then note you need to unzip it once before placing it in the contrib/snomed (this is because the released file was \"double-zipped\").'),
(11198, 'Warning: Navigation error. Please refresh this page.'),
(11199, 'Warning: Patient ID is not unique!'),
(11200, 'Warning: There is no product matching the contraceptive service.'),
(11201, 'Warning: There is no service matching the contraceptive product.'),
(11202, 'WARNING: This will overwrite configuration information with data from the uploaded file!'),
(11203, 'WARNINGS'),
(11204, 'Warnings'),
(11205, 'WARNINGS and Alerts/Reminders'),
(11206, 'was already uploaded'),
(11207, 'was not found'),
(11208, 'We appreciate prompt payment of balances due'),
(11209, 'We appreciate prompt payment of balances due.'),
(11210, 'We are going to create the test that can be ordered called Serum Uric Acid'),
(11211, 'we have seen your above patient for evaluation and treatment at our outpatient psychiatry clinic. Thank you for this referral.'),
(11212, 'We ran into some problems connecting your EHR to the MedEx servers'),
(11213, 'We will be basing the Electrolyte panel off the main trunk or Group (Serum Chemistry)'),
(11214, 'We will be creating an order for three tests Blood Glucose, TSH and Vitamin D and group it in a custom group called Well Woman Tests and create a place to manually enter the returned results'),
(11215, 'We will go through the process of setting up the order for a single blood test - Serum Uric Acid'),
(11216, 'We will now create the order, or Procedure Order, called Electrolyte Panel that can be visualized as the fruit bearing branch in our hypothetical fruit tree'),
(11217, 'We will set up the order for the Electrolyte panel that consists of Serum Sodium, Potassium, Chloride and Carbon Dioxide'),
(11218, 'We will start with the most basic unit of the Procedure Orders module, to set up a single lab test order and the ability to manually record the returned result'),
(11219, 'We will use a Discrete Result for each test to hold the returned result values'),
(11220, 'We will use this branch to hold all the 9 panels, here we will be just creating the order representing one panel, the Electrolyte Panel'),
(11221, 'Weakness'),
(11222, 'Wear RX'),
(11223, 'Web based methods'),
(11224, 'Web based methods use Authentication-as-a-service and deliver OTP without need for tokens'),
(11225, 'Web Reference'),
(11226, 'Web Search'),
(11227, 'Website'),
(11228, 'Website link for the Onsite Patient Portal.'),
(11229, 'Website link for the Version 1 Onsite Patient Portal.'),
(11230, 'Website link for the Version 2 Onsite Patient Portal.'),
(11231, 'Wed'),
(11232, 'Wednesday'),
(11233, 'Week'),
(11234, 'week'),
(11235, 'Week View'),
(11236, 'Week(s)'),
(11237, 'Weekly Exposures'),
(11238, 'weeks'),
(11239, 'Weeks'),
(11240, 'Weight'),
(11241, 'Weight Assessment and Counseling for Children and Adolescents'),
(11242, 'Weight Assessment and Counseling for Children and Adolescents (CQM)'),
(11243, 'Weight Change'),
(11244, 'Weight Loss'),
(11245, 'Weight loss clinic'),
(11246, 'Welcome'),
(11247, 'Welcome to OpenEMR'),
(11248, 'Welsh'),
(11249, 'Weno Account Clinic ID information missing'),
(11250, 'Weno Account ID information missing'),
(11251, 'Weno Admin'),
(11252, 'Weno eRx Account Id'),
(11253, 'Weno eRx Account Pass'),
(11254, 'Weno eRx Clinic ID'),
(11255, 'Weno Provider ID'),
(11256, 'Weno Sample Code'),
(11257, 'Weno Service is Enabled'),
(11258, 'Western Frisian'),
(11259, 'We{{Wednesday}}'),
(11260, 'What constitutes the order and what is its electronic format, how is it sent, how is the result received, if the system will only receive results or send orders and receive results, what labs you will be connecting to and what needs to happen at the other end, whether or not a third party will be involved in this transaction'),
(11261, 'What is to be counted?'),
(11262, 'What kind of sorting will be in the drop lists.'),
(11263, 'Wheezes:'),
(11264, 'Wheezing'),
(11265, 'Wheezing:'),
(11266, 'When a new user is created, access control is granted by the administrator or by a user with similar privileges by selecting which groups (AROs) a user can belong to.'),
(11267, 'When and how often?'),
(11268, 'When Checked, Demographics Will Open in New Window from Patient Flow Board.'),
(11269, 'When Checked, Last Staff to Update Board Will Show in Patient Flow Board.'),
(11270, 'When checked, messages are processed for patients with Patient Demographic Choice: \"Hipaa Notice Received\" set to \"Unassigned\" or \"Yes\". When unchecked, this choice must = \"YES\" to process the patient reminder. For patients with Choice =\"No\", Reminders will need to be processed manually.'),
(11271, 'When Checked, Patient Encounter Number Will Show in Patient Flow Board.'),
(11272, 'When Checked, Patient ID Will Show in Patient Flow Board.'),
(11273, 'When Checked, Visit Reason Will Show in Patient Flow Board.'),
(11274, 'When dealing with protected health information (PHI) and personally identifying information (PII) it is important to allow only authorized users access to the data'),
(11275, 'When done, click Submit (below) to apply your choices.'),
(11276, 'When such an order is placed the returned results will contains the values for all components of CBC, Comprehensive Metabolic Panel and TSH'),
(11277, 'When the generated report is displayed in a separate tab there is an option that lets you view a Printable Version that can be printed'),
(11278, 'When the key is first registered it generates a random number, which is called a nonce'),
(11279, 'When the user initially visits this page the following message will be visible'),
(11280, 'When you place an order you can search for Well Woman Tests under favorites and select it to automatically order Blood Glucose, TSH and Vitamin D with a single click'),
(11281, 'Where may related scanned or paper documents be found?'),
(11282, 'Where on your body does it occur?'),
(11283, 'Whether Insured'),
(11284, 'which days are your weekend days?'),
(11285, 'Which notes are to be displayed in the Billing Screen'),
(11286, 'While forwarding a dated reminder the old message is displayed, it can be overwritten'),
(11287, 'While it is intuitive to think of this module as the place where lab tests and imaging studies can be ordered and reviewed this module can also be used to track other procedures performed in office'),
(11288, 'While lab tests and radiological tests can be performed in the practice facility they are generally done at an external facility and the provider details for that entity will have to be entered in openEMR before the Procedure module setup can begin'),
(11289, 'Whiplash'),
(11290, 'White'),
(11291, 'White list'),
(11292, 'White-to-white'),
(11293, 'Who'),
(11294, 'Who replied?'),
(11295, 'Whose Online'),
(11296, 'Widowed'),
(11297, 'Width'),
(11298, 'Width in pixels of the left navigation frame in frame based layout.'),
(11299, 'Width in pixels of the left navigation frame.'),
(11300, 'Will add another dropdown menu in the CPT line to let you select a provider for that line item'),
(11301, 'will be hidden if'),
(11302, 'will have the following validation rules'),
(11303, 'With checked items plot'),
(11304, 'with import'),
(11305, 'with preferred language'),
(11306, 'With selected:'),
(11307, 'with the old name'),
(11308, 'With the U2F key you will need to plug it in to the USB port and then access OpenEMR using the latest versions of the following modern browsers - Chrome, Firefox, Safari, Edge and Opera and pressing the button on the device'),
(11309, 'with value'),
(11310, 'With whom may we leave a message?'),
(11311, 'Withheld'),
(11312, 'within hours'),
(11313, 'within hours:'),
(11314, 'within minutes'),
(11315, 'within minutes:'),
(11316, 'Without Facility'),
(11317, 'Without Provider'),
(11318, 'Without Update'),
(11319, 'Witness'),
(11320, 'wk'),
(11321, 'WNL'),
(11322, 'Wolof'),
(11323, 'Women'),
(11324, 'Women Only'),
(11325, 'WordPress Portal'),
(11326, 'Work'),
(11327, 'WORK NOTE'),
(11328, 'Work Phone'),
(11329, 'Work Phone Number'),
(11330, 'Work related?'),
(11331, 'Work/ Education/ Hobbies'),
(11332, 'Work/School Note'),
(11333, 'workday'),
(11334, 'Worker`s Compensation'),
(11335, 'Workers Compensation Health Plan'),
(11336, 'Working Aged Beneficiary or Spouse with Employer Group Health Plan'),
(11337, 'Working!'),
(11338, 'Working... this may take a minute.'),
(11339, 'Worse'),
(11340, 'Would you like the balance amount to apply to Global Account?'),
(11341, 'Would You Like them to be Marked as Cleared.'),
(11342, 'Would you like to Allocate?'),
(11343, 'Would you like to Cancel Distribution for this Patient?'),
(11344, 'Would you like to Delete Payment Distribution?'),
(11345, 'Would you like to Delete Payments?'),
(11346, 'Would you like to Modify and Finish Payments?'),
(11347, 'Would you like to Modify Payments?'),
(11348, 'Would you like to Post and Finish Payments?'),
(11349, 'Would you like to Post Payments?'),
(11350, 'Would you like to save?'),
(11351, 'Wrist'),
(11352, 'Wrist and hand'),
(11353, 'Wrist Problems'),
(11354, 'write'),
(11355, 'write - can read and fully modify'),
(11356, 'write off'),
(11357, 'Write Once'),
(11358, 'wsome'),
(11359, 'wsome - can read and partially modify'),
(11360, 'WSXGA+'),
(11361, 'WT'),
(11362, 'W{{Current Rx - wearing}}'),
(11363, 'W{{Wednesday}}'),
(11364, 'x Canceled'),
(11365, 'x Cancelled'),
(11366, 'X(T){{intermittent exophoria}}'),
(11367, 'X-ray'),
(11368, 'X-RAY Interpretation:'),
(11369, 'X-Ray Interpretation:'),
(11370, 'X12 only ICN resubmission No.'),
(11371, 'X12 only replacement claim:'),
(11372, 'X12 only: Replacement Claim'),
(11373, 'X12 only: Replacement Claim '),
(11374, 'X12 only: Replacement Claim, X12 only ICN resubmission No is used for electronic resubmission of claims. Requirement varies by insurer'),
(11375, 'X12 OPTIONS'),
(11376, 'X12 Partner'),
(11377, 'X12 Partners'),
(11378, 'x12 Segments'),
(11379, 'x12 Text'),
(11380, 'Xhosa'),
(11381, 'XHR Failed:'),
(11382, 'XML'),
(11383, 'XT{{exotropia}}'),
(11384, 'X{{exophoria}}'),
(11385, 'Y'),
(11386, 'year'),
(11387, 'Year'),
(11388, 'Year View'),
(11389, 'Year(s)'),
(11390, 'Years'),
(11391, 'years ago'),
(11392, 'Years or months'),
(11393, 'Years, months and days'),
(11394, 'Yes'),
(11395, 'YES'),
(11396, 'yes'),
(11397, 'YES!'),
(11398, 'Yes, Delete and Log'),
(11399, 'Yes, Delete this form'),
(11400, 'Yes/No'),
(11401, 'Yes:'),
(11402, 'Yiddish'),
(11403, 'Yoruba'),
(11404, 'You are about to delete template'),
(11405, 'You are about to delete the following form from this encounter'),
(11406, 'You are about to permanently replace the existing template. Are you sure you wish to continue?'),
(11407, 'You are currently logged in as'),
(11408, 'You are in Grace Login period. Change your password before'),
(11409, 'You are not allowed to delete this event'),
(11410, 'You are not allowed to edit this event'),
(11411, 'You are not authorized for this.'),
(11412, 'You are not authorized to access this squad'),
(11413, 'You are not authorized to access this squad.'),
(11414, 'You are not authorized to add/edit issues'),
(11415, 'You are not authorized to schedule appointments.'),
(11416, 'You are not authorized to see this encounter.'),
(11417, 'You are not authorized!'),
(11418, 'You are posting against an old encounter?'),
(11419, 'You are sending to yourself!'),
(11420, 'You are using patient validation module'),
(11421, 'You can add multiple patients to the list'),
(11422, 'You can add multiple users by selecting them one at a time'),
(11423, 'You can also add an Issue from this page by clicking on the Add Issue button to bring up the Add issue pop-up page'),
(11424, 'You can change the type or leave it as it is'),
(11425, 'You can click on the envelope icon to access the messaging center'),
(11426, 'You can click on the patient name to quickly access the patient\'s chart'),
(11427, 'You can click on the Select All button to choose all authorized users'),
(11428, 'You can close the edit box by clicking on the \'slashed eye\' icon next to the group\'s name.'),
(11429, 'You can delete the recall by clicking on the X button on the top right corner of the cell'),
(11430, 'You can download the Loinc Universal LabOrders ValueSet.csv file from here'),
(11431, 'You can edit the title if you so choose'),
(11432, 'You can enter data into all 5 categories from this page'),
(11433, 'You can link the allergy to one or more encounters if appropriate'),
(11434, 'You can link the medication to one or more encounters if appropriate'),
(11435, 'You can not access this function directly.'),
(11436, 'You can not change status to \'Arrive\' before the appointment\'s time'),
(11437, 'You can only add to the existing message and cannot edit previously entered data'),
(11438, 'You can only place an order for Electrolyte Panel and have the entire panel tested and have their results returned'),
(11439, 'You can only select'),
(11440, 'You can search for and select the codes by clicking once on each line containing the code'),
(11441, 'You can sort the pending messages in ascending or descending order by clicking on the arrowhead in each cell of the table header'),
(11442, 'You can then proceed to link the newly added issue to encounters'),
(11443, 'You can upload content and label them by ICD10 code enable you to search and download the selected material'),
(11444, 'You can use LOINC codes for the Standard Codes'),
(11445, 'You can use the above method to create orders for the rest of the Organ/Disease Panels except for the General Health Panel that consists of CBC, Comprehensive Metabolic Panel and TSH and the Obstetric Panel that has CBC as one of its components'),
(11446, 'You can use the codes given on the paper lab slip of a local lab of major lab as the Identifying codes'),
(11447, 'You cannot access this page directly.'),
(11448, 'You cannot add a blank value for a category!'),
(11449, 'You cannot add a blank value for a subcategory!'),
(11450, 'You cannot add a blank value for an item!'),
(11451, 'You cannot edit the already chosen lab, if sending to different lab delete entry and create a new one'),
(11452, 'You cannot enter a future date with a completed value of YES.'),
(11453, 'You could manually edit this date should you choose to or an entirely different date'),
(11454, 'You did not choose any actions.'),
(11455, 'You do not have access to view/edit this note'),
(11456, 'You have'),
(11457, 'You have an invoice due for payment in your Patient Documents. There you may pay, download or print the invoice. Thank you.'),
(11458, 'You have attempted to alter content which is locked. Remove the lock if you want to do this. To unlock, remove the line, \'/*lock::*/\''),
(11459, 'You have been successfully logged out.'),
(11460, 'You have chosen to be self insured or currently do not have insurance. Click next to continue registration.'),
(11461, 'You have not entered any clinical services or products. Click Cancel to add them. Or click OK if you want to save as-is.'),
(11462, 'You have now successfully completed an order for a single lab test'),
(11463, 'You have to have an understanding how the program is structured and the ability and willingness to modify the underlying code.'),
(11464, 'You have unsaved changes.'),
(11465, 'You have unsaved changes. Abandon them?'),
(11466, 'You have unsaved changes. Do you really want to close this form?'),
(11467, 'You may only upload .txt files'),
(11468, 'You may optionally upload HL7 results from a file'),
(11469, 'You may put text here as the default complaint in the New Patient Encounter form.'),
(11470, 'You may type in a name of the person referring or leave blank'),
(11471, 'You may want to try returning to the the previous page and verifying that all fields have been filled out correctly.'),
(11472, 'You must activate Weno first! Go to Administration, Globals, Connectors'),
(11473, 'You must agree to the HIPAA Business Associate Agreement'),
(11474, 'You must agree to the Terms & Conditions before signing up'),
(11475, 'You must enter a pass phrase to encrypt the document'),
(11476, 'You must enter your own password to change user passwords. Leave blank to keep password unchanged.'),
(11477, 'You must first select an item in the section whose radio button is checked.'),
(11478, 'You must first select or add a patient or therapy group.'),
(11479, 'You must first select or add a patient.'),
(11480, 'You must first select or create an encounter.'),
(11481, 'You must select a visit category'),
(11482, 'You must select a visit category.'),
(11483, 'You must select some fields to continue.'),
(11484, 'You need administrator privileges to add more options'),
(11485, 'You need administrator privileges to disable the default Recall Board'),
(11486, 'You need administrator privileges to enable the MedEx Communication Service'),
(11487, 'You need administrator privileges to give access to other groups'),
(11488, 'You need administrator privileges to increase the number of reminders to show'),
(11489, 'You need administrator privileges to perform the changes to the values in the drop-down boxes.'),
(11490, 'You need administrator privileges to perform the setup'),
(11491, 'You need administrator privileges to perform this action'),
(11492, 'You need to go back and and create a provider'),
(11493, 'You should be running this test if this claim appeared to generate successfully but the actual claim file does not contain any data or only an unfinished portion of the amount of data it is supposed to contain. It is obvious with HCFA claims because they are human readable, with X12 claims it is a more difficult process to determine if the claim is properly complete.'),
(11494, 'You should not make Discrete Result for Potassium be a descendant of a preceding Discrete Result i.e Sodium , i.e have a Tier value of 5'),
(11495, 'You should select at least one context'),
(11496, 'You should select at least one Provider'),
(11497, 'You will be automatically redirected to Demographics. You may make the necessary corrections and navigate to NewCrop again.'),
(11498, 'You will be notified when the payment transaction is confirmed.'),
(11499, 'You will be notified when your payment is applied for this invoice.'),
(11500, 'You will need Administrator privileges to edit this form'),
(11501, 'You will need Administrator privileges to enable the patient portal'),
(11502, 'You will need Administrator Privileges to install the ICD10 code set'),
(11503, 'You will need Administrator privileges to setup phiMail Direct Messaging'),
(11504, 'You will need Administrator privileges to setup the NewCrop service and has to be setup in conjunction with technical support from the NewCrop eRx service'),
(11505, 'Your Clinical Report'),
(11506, 'Your credentials are provided by your provider'),
(11507, 'Your current TOTP key QR code is displayed below.'),
(11508, 'your email address'),
(11509, 'Your end date is invalid'),
(11510, 'Your event has been deleted.'),
(11511, 'Your event has been modified.'),
(11512, 'Your event has been submitted.'),
(11513, 'Your file doesn\'t have an extension'),
(11514, 'Your file is too large'),
(11515, 'Your first day of the week.'),
(11516, 'Your installation of OpenEMR has been registered'),
(11517, 'Your Lab Results'),
(11518, 'Your list name has been changed to meet naming requirements.'),
(11519, 'Your message was submitted for delivery to'),
(11520, 'Your name for this category, procedure or result'),
(11521, 'Your new credentials have been sent. Check your email inbox and also possibly your spam folder. Once you log into your patient portal feel free to make an appointment or send us a secure message. We look forward to seeing you soon.'),
(11522, 'your next appointment at'),
(11523, 'Your on file email address'),
(11524, 'Your Password'),
(11525, 'Your Password Expired. Please change your password.'),
(11526, 'Your Password Expires on'),
(11527, 'Your Password Expires today. Please change your password.'),
(11528, 'Your password is your signature'),
(11529, 'Your PostCalendar configuration has been reset to use defaults.'),
(11530, 'Your PostCalendar configuration has been updated.'),
(11531, 'Your repeating frequency must be an integer.'),
(11532, 'Your repeating frequency must be at least 1.'),
(11533, 'Your safe key is'),
(11534, 'Your start date is greater than your end date'),
(11535, 'Your start date is invalid'),
(11536, 'Your submission failed.'),
(11537, 'Your weekend days'),
(11538, 'Yubikey also sells more expensive U2F keys designed to work with mobile devices'),
(11539, 'yyyy-mm-dd'),
(11540, 'YYYY-MM-DD'),
(11541, 'yyyy-mm-dd date associated with this document'),
(11542, 'yyyy-mm-dd date destroyed'),
(11543, 'yyyy-mm-dd date of birth'),
(11544, 'yyyy-mm-dd Date of Birth'),
(11545, 'yyyy-mm-dd date of expiration'),
(11546, 'yyyy-mm-dd Date of onset or hospitalization'),
(11547, 'yyyy-mm-dd date of onset, surgery or start of medication'),
(11548, 'yyyy-mm-dd date of purchase or transfer'),
(11549, 'yyyy-mm-dd date of recovery or end of medication'),
(11550, 'yyyy-mm-dd Date of return to play'),
(11551, 'yyyy-mm-dd Date of service'),
(11552, 'yyyy-mm-dd date of this letter'),
(11553, 'yyyy-mm-dd date returned to play'),
(11554, 'yyyy-mm-dd document date'),
(11555, 'yyyy-mm-dd End Date'),
(11556, 'yyyy-mm-dd event date or starting date'),
(11557, 'yyyy-mm-dd H:m End Date'),
(11558, 'yyyy-mm-dd H:m End date'),
(11559, 'yyyy-mm-dd H:m Start Date'),
(11560, 'yyyy-mm-dd H:m Start date'),
(11561, 'yyyy-mm-dd hh:mm:ss'),
(11562, 'yyyy-mm-dd Hours(24):minutes'),
(11563, 'yyyy-mm-dd last date of this event'),
(11564, 'yyyy-mm-dd Start Date'),
(11565, 'yyyy-mm-dd starting date for search'),
(11566, 'ZEF segment internal error'),
(11567, 'Zend Module'),
(11568, 'Zend Module check in addition to standard check'),
(11569, 'Zero'),
(11570, 'Zhuang, Chuang'),
(11571, 'Zip'),
(11572, 'Zip Code'),
(11573, 'Zip/Country:'),
(11574, 'Zoom'),
(11575, 'Zoom in'),
(11576, 'Zoom out'),
(11577, 'Zoom: click-drag, Pan: shift-click-drag, Restore: double-click'),
(11578, 'Zulu'),
(11579, ' but was '),
(11580, ' could not be accessed.'),
(11581, ' Do you really want to delete'),
(11582, ' Drug'),
(11583, ' emails not sent'),
(11584, ' from'),
(11585, ' has been created. '),
(11586, ' has been re-opened.'),
(11587, ' History'),
(11588, ' is not a number'),
(11589, ' is ready for re-billing.'),
(11590, ' LLL:'),
(11591, ' Lot'),
(11592, ' Medicaid Original Reference No. '),
(11593, ' min'),
(11594, ' not found!'),
(11595, ' Pecularities in many browsers may mean that the output below enters your screen in sudden jerks and that there are long pauses of several seconds where it  appears as though things may have crashed. That is not the case, you will eventually see output coming out line by line. There may be sequential numbers appearing  below, this is to indicate that even though nothing else may be displaying there is activity going on. These numbers will be interspersed with the content of the  billing and that is normal.'),
(11596, ' prescription has reached its limit of'),
(11597, ' until '),
(11598, ' update failed, not in database?'),
(11599, ' was marked as billed only.'),
(11600, ' was queued successfully.'),
(11601, '! Left w/o visit'),
(11602, '\" for code '),
(11603, '\" is CHECKED in PostCalendar Settings!'),
(11604, '# Ins/fin issue'),
(11605, '# of tablets:'),
(11606, '$'),
(11607, '$ Coding done'),
(11608, '$label (yyyy-mm-dd): '),
(11609, '%'),
(11610, '% Canceled < 24h'),
(11611, '% Cancelled <  24h '),
(11612, '\' should exist but does not.'),
(11613, '(% matches any string, _ matches any character)'),
(11614, '([ctrl] + click to select multiple recipients)'),
(11615, '(Back)'),
(11616, '(Click to edit)'),
(11617, '(Email delivery is immediate, while automated VOIP is sent to the service provider for further processing.)'),
(11618, '(More)'),
(11619, '(New Patient)'),
(11620, '(Notes and Authorizations)'),
(11621, '(Patient Notes)'),
(11622, '(Select one of these, or type your own title)'),
(11623, '(Shift-)Click or drag to change value'),
(11624, '* Reminder done'),
(11625, '** Please move surgeries to Issues!'),
(11626, '*Required'),
(11627, '+ Chart pulled'),
(11628, '+1'),
(11629, '+2'),
(11630, '+3'),
(11631, '- None'),
(11632, '- Not Reported'),
(11633, '-- All --'),
(11634, '--Select Role--'),
(11635, '.'),
(11636, '0'),
(11637, '0-10'),
(11638, '0-24'),
(11639, '02/12{{CMS 1500 format date revision setting in globals}}'),
(11640, '08/05{{CMS 1500 format date revision setting in globals}}'),
(11641, '1'),
(11642, '1 = North America. See http://www.wtng.info/ for a list of other country codes.'),
(11643, '1 Day From Now'),
(11644, '1 Month From Now'),
(11645, '1 Week From Now'),
(11646, '1 Year From Now'),
(11647, '1.Rest 2. Ice for two days 3. Compression, leave the dressing in place unless the foot develops numbness or pale color 4. Elevate the foot and leg'),
(11648, '11-14'),
(11649, '12 hr'),
(11650, '15-19'),
(11651, '1mm'),
(11652, '1st'),
(11653, '2'),
(11654, '2 Days From Now'),
(11655, '2 Months From Now'),
(11656, '2 Weeks From Now'),
(11657, '2 Years From Now'),
(11658, '2-20 years'),
(11659, '20-24'),
(11660, '2011 Automated Measure Calculations (AMC)'),
(11661, '2011 Clinical Quality Measures (CQM)'),
(11662, '2011 Official Clinical Quality Measures (CQM) Measure Groups'),
(11663, '2014 Automated Measure Calculations (AMC)'),
(11664, '2014 Automated Measure Calculations (AMC) - Stage I'),
(11665, '2014 Automated Measure Calculations (AMC) - Stage II'),
(11666, '2014 Clinical Quality Measures (CQM)'),
(11667, '2014 Official Clinical Quality Measures (CQM) Measure Groups'),
(11668, '2111-13'),
(11669, '24 hr'),
(11670, '25+'),
(11671, '25-29'),
(11672, '271 Returned'),
(11673, '2mm'),
(11674, '2nd'),
(11675, '3 Days From Now'),
(11676, '3 months'),
(11677, '3 Months From Now'),
(11678, '3 times daily'),
(11679, '3 Weeks From Now'),
(11680, '30-34'),
(11681, '35-39'),
(11682, '3mm'),
(11683, '3rd'),
(11684, '4 Days From Now'),
(11685, '4 months'),
(11686, '4 Months From Now'),
(11687, '4 times daily'),
(11688, '4 Weeks From Now'),
(11689, '40-44'),
(11690, '45+'),
(11691, '465.9, URI'),
(11692, '466.0, Bronchitis, Acute NOS'),
(11693, '486.0, Pneumonia, Acute'),
(11694, '491.21, COPD Exacerbation'),
(11695, '491.8, Bronchitis, Chronic'),
(11696, '493.92, Asthma, Acute Exac.'),
(11697, '496.0, COPD'),
(11698, '4K UHD'),
(11699, '4mm'),
(11700, '4th'),
(11701, '5 Days From Now'),
(11702, '5 Months From Now'),
(11703, '5 Weeks From Now'),
(11704, '519.7, Bronchospasm'),
(11705, '5mm'),
(11706, '5th'),
(11707, '6 Days From Now'),
(11708, '6 months'),
(11709, '6 Months From Now'),
(11710, '6 Weeks From Now'),
(11711, '6th'),
(11712, '7 Months From Now'),
(11713, '8 Months From Now'),
(11714, '8-12 characters long, including at least one upper case letter, one lower case letter, one number, one special character and no common strings'),
(11715, '824.0 Fracture, medial malleolus, closed'),
(11716, '824.2 Fracture, lateral malleolus, closed'),
(11717, '824.6 Fracture, Trimalleolar, closed'),
(11718, '825.32 Fracture, of Navicular (ankle)'),
(11719, '825.35 Fracture, Base of fifth (5th) Metatarsal'),
(11720, '845.00 ankle sprain NOS'),
(11721, '845.01 Sprain Medial (Deltoid) Lig.'),
(11722, '845.02 Sprain, Calcaneal fibular'),
(11723, '9 Months From Now'),
(11724, '99212 Established - Uncomplicated'),
(11725, '99213 Established - Low Complexity'),
(11726, '< In exam room'),
(11727, '< Not Reported'),
(11728, '= Took Place'),
(11729, '> 3 HPI elements'),
(11730, '> Checked out'),
(11731, '> Did Not Take Place'),
(11732, '?'),
(11733, '? Did Not Attend'),
(11734, '? No show'),
(11735, '@ Arrived'),
(11736, '@ Attended'),
(11737, '[Change View]'),
(11738, '[Date of Last Encounter]'),
(11739, '[Days Since Last Encounter]'),
(11740, '[EOBs]'),
(11741, '[Export OFX]'),
(11742, '[not recommended]'),
(11743, '[Number Of Encounters]'),
(11744, '[Reports]'),
(11745, '[Select All]'),
(11746, '[SQL-Ledger]'),
(11747, '[Start Batch Processing]'),
(11748, '[View Log]'),
(11749, '[View Printable Report]'),
(11750, '^ Pending'),
(11751, '_PC_DUR_HOURS'),
(11752, '_PC_DUR_MINUTES'),
(11753, '_PC_LOCALE'),
(11754, '~ Arrived late'),
(11755, '~ Late Arrival');

--


-- 
-- Table structure for table `lang_definitions`
-- 


DROP TABLE IF EXISTS `lang_definitions`;
CREATE TABLE `lang_definitions` (
  `def_id` int(11) NOT NULL auto_increment,
  `cons_id` int(11) NOT NULL default '0',
  `lang_id` int(11) NOT NULL default '0',
  `definition` mediumtext,
  UNIQUE KEY `def_id` (`def_id`),
  KEY `cons_id` (`cons_id`) 
) ENGINE=InnoDB AUTO_INCREMENT=186363 ;


-- 
-- Dumping data for table `lang_definitions`
--

INSERT INTO `lang_definitions` VALUES (1, 1, 2, 'En');
INSERT INTO `lang_definitions` VALUES (2, 2, 2, 'Ett betalningsnr för att identifiera betalningen');
INSERT INTO `lang_definitions` VALUES (3, 4, 2, 'Klientcertifikat för admin användaren');
INSERT INTO `lang_definitions` VALUES (4, 7, 2, 'Ett klinikdokument är bifogat');
INSERT INTO `lang_definitions` VALUES (5, 13, 2, 'En distributör behövs');
INSERT INTO `lang_definitions` VALUES (6, 17, 2, 'Ett GCAC besöksformulär ska läggas till för detta besök');
INSERT INTO `lang_definitions` VALUES (7, 20, 2, 'Ett lot-nr krävs!');
INSERT INTO `lang_definitions` VALUES (8, 21, 2, 'Ett lot-nr krävs!');
INSERT INTO `lang_definitions` VALUES (9, 22, 2, 'En liten bokstav');
INSERT INTO `lang_definitions` VALUES (10, 27, 2, 'Ett tal');
INSERT INTO `lang_definitions` VALUES (11, 29, 2, 'En patient med detta ID finns redan');
INSERT INTO `lang_definitions` VALUES (12, 30, 2, 'En patient med detta namn finns redan');
INSERT INTO `lang_definitions` VALUES (13, 31, 2, 'En patient med detta personnummer ( SS ) finns redan');
INSERT INTO `lang_definitions` VALUES (14, 36, 2, 'Ett positivt nummer kommer visa antalet tidigare bokningar i en ruta på patientöversikten.');
INSERT INTO `lang_definitions` VALUES (15, 41, 2, 'Den remitterande instansen kan framgå vid varje besök');
INSERT INTO `lang_definitions` VALUES (16, 42, 2, 'En relaterad IPPF kod krävs!');
INSERT INTO `lang_definitions` VALUES (17, 47, 2, 'Ett specialtecken');
INSERT INTO `lang_definitions` VALUES (18, 51, 2, 'Ett unikt värde, som ej är synlig för användaren, identifierar detta fält.');
INSERT INTO `lang_definitions` VALUES (19, 55, 2, 'Före måltid');
INSERT INTO `lang_definitions` VALUES (20, 56, 2, 'förmiddag');
INSERT INTO `lang_definitions` VALUES (21, 60, 2, 'AB');
INSERT INTO `lang_definitions` VALUES (22, 61, 2, 'Förkortning');
INSERT INTO `lang_definitions` VALUES (23, 62, 2, 'Abscess');
INSERT INTO `lang_definitions` VALUES (24, 63, 2, 'Abdominell');
INSERT INTO `lang_definitions` VALUES (25, 64, 2, 'kan bära vikt fyra (4) steg:');
INSERT INTO `lang_definitions` VALUES (26, 65, 2, 'Patologisk');
INSERT INTO `lang_definitions` VALUES (27, 66, 2, 'ABN1');
INSERT INTO `lang_definitions` VALUES (28, 68, 2, 'Patologisk');
INSERT INTO `lang_definitions` VALUES (29, 69, 2, 'Patologiskt blodprov');
INSERT INTO `lang_definitions` VALUES (30, 70, 2, 'Avvikande hårväxt');
INSERT INTO `lang_definitions` VALUES (31, 71, 2, 'Patologisk mammografi');
INSERT INTO `lang_definitions` VALUES (32, 73, 2, 'Abort');
INSERT INTO `lang_definitions` VALUES (33, 74, 2, 'Abortrelaterad problematik');
INSERT INTO `lang_definitions` VALUES (34, 75, 2, 'Abortmetod');
INSERT INTO `lang_definitions` VALUES (35, 76, 2, 'Abortrelaterade kategorier');
INSERT INTO `lang_definitions` VALUES (36, 77, 2, 'Aborter');
INSERT INTO `lang_definitions` VALUES (37, 80, 2, 'Om kalendern');
INSERT INTO `lang_definitions` VALUES (38, 83, 2, 'Frånvaro av Diagnos');
INSERT INTO `lang_definitions` VALUES (39, 85, 2, 'Acceptera uppdrag');
INSERT INTO `lang_definitions` VALUES (40, 87, 2, 'acceptera betalning för');
INSERT INTO `lang_definitions` VALUES (41, 88, 2, 'acceptera betalning för');
INSERT INTO `lang_definitions` VALUES (42, 89, 2, 'Accepterar uppdrag');
INSERT INTO `lang_definitions` VALUES (43, 91, 2, 'Åtkomstkontroll');
INSERT INTO `lang_definitions` VALUES (44, 92, 2, 'Hantera åtkomst');
INSERT INTO `lang_definitions` VALUES (45, 100, 2, 'Åtkomst ej tillåten');
INSERT INTO `lang_definitions` VALUES (46, 101, 2, 'Åtkomst ej tillåten');
INSERT INTO `lang_definitions` VALUES (47, 103, 2, 'Öppna patientöversikten');
INSERT INTO `lang_definitions` VALUES (48, 110, 2, 'Konto namn');
INSERT INTO `lang_definitions` VALUES (49, 113, 2, 'Redovisning');
INSERT INTO `lang_definitions` VALUES (50, 118, 2, 'värker');
INSERT INTO `lang_definitions` VALUES (51, 120, 2, 'Begärt godokännande (ISA14)');
INSERT INTO `lang_definitions` VALUES (52, 121, 2, 'Godkännande, licenser och certifikat');
INSERT INTO `lang_definitions` VALUES (53, 122, 2, 'Användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (54, 123, 2, 'Administration av användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (55, 125, 2, 'Ej behörig administrera användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (56, 128, 2, 'Akne');
INSERT INTO `lang_definitions` VALUES (57, 131, 2, 'Aktuellt');
INSERT INTO `lang_definitions` VALUES (58, 132, 2, 'Aktivitetsdatum');
INSERT INTO `lang_definitions` VALUES (59, 133, 2, 'Åtgärd');
INSERT INTO `lang_definitions` VALUES (60, 137, 2, 'Åtgärder');
INSERT INTO `lang_definitions` VALUES (61, 139, 2, 'Rapportera fortsatt vårdbegäran (CCR/CCD)');
INSERT INTO `lang_definitions` VALUES (62, 143, 2, 'Aktiva');
INSERT INTO `lang_definitions` VALUES (63, 145, 2, 'Aktiv påminnelse');
INSERT INTO `lang_definitions` VALUES (64, 147, 2, 'Regler för aktiv påminnelse');
INSERT INTO `lang_definitions` VALUES (65, 148, 2, 'Aktiva påminnelser');
INSERT INTO `lang_definitions` VALUES (66, 153, 2, 'Aktivt besök');
INSERT INTO `lang_definitions` VALUES (67, 154, 2, 'Códigos de questões ativas');
INSERT INTO `lang_definitions` VALUES (68, 155, 2, 'Aktiva listor');
INSERT INTO `lang_definitions` VALUES (69, 157, 2, 'Aktiv patient');
INSERT INTO `lang_definitions` VALUES (70, 158, 2, 'Aktuella planeringar');
INSERT INTO `lang_definitions` VALUES (71, 160, 2, 'Aktiviteter');
INSERT INTO `lang_definitions` VALUES (72, 161, 2, 'Aktivitetstyp');
INSERT INTO `lang_definitions` VALUES (73, 172, 2, 'Akut förgiftning / Utsättning');
INSERT INTO `lang_definitions` VALUES (74, 174, 2, 'Akut försämring av kronisk');
INSERT INTO `lang_definitions` VALUES (75, 176, 2, 'Lägg till');
INSERT INTO `lang_definitions` VALUES (76, 177, 2, 'lägg till');
INSERT INTO `lang_definitions` VALUES (77, 178, 2, 'Lägg till');
INSERT INTO `lang_definitions` VALUES (78, 179, 2, 'Lägg till ett företag');
INSERT INTO `lang_definitions` VALUES (79, 184, 2, 'Lägg till ett apotek');
INSERT INTO `lang_definitions` VALUES (80, 187, 2, 'lägg till ett händelse för');
INSERT INTO `lang_definitions` VALUES (81, 189, 2, 'Lägg till som en ny anteckning');
INSERT INTO `lang_definitions` VALUES (82, 190, 2, 'Lägg till som ny');
INSERT INTO `lang_definitions` VALUES (83, 193, 2, 'Lägg till knappar');
INSERT INTO `lang_definitions` VALUES (84, 194, 2, 'Lägg till knappar för specialtecken och texter att visa längst upp i editorn för inkludering i texten med ett klick');
INSERT INTO `lang_definitions` VALUES (85, 195, 2, 'Lägg till en ny Kategori');
INSERT INTO `lang_definitions` VALUES (86, 196, 2, 'Lägg till en ny Konstant');
INSERT INTO `lang_definitions` VALUES (87, 197, 2, 'Lägg till ett sammanhang');
INSERT INTO `lang_definitions` VALUES (88, 198, 2, 'Lägg till en delbetalning');
INSERT INTO `lang_definitions` VALUES (89, 199, 2, 'Lägg till ett nytt kriterium');
INSERT INTO `lang_definitions` VALUES (90, 200, 2, 'Lägg till anpassad knapp');
INSERT INTO `lang_definitions` VALUES (91, 203, 2, 'Lägg till en ny diagnos');
INSERT INTO `lang_definitions` VALUES (92, 204, 2, 'Lägg till ett nytt Läkemedel');
INSERT INTO `lang_definitions` VALUES (93, 207, 2, 'Lägg till ett nytt besök');
INSERT INTO `lang_definitions` VALUES (94, 208, 2, 'Lägg till ett nytt besök/anteckning');
INSERT INTO `lang_definitions` VALUES (95, 209, 2, 'Lägg till en ny klinik');
INSERT INTO `lang_definitions` VALUES (96, 210, 2, 'Lägg till ett nytt fält');
INSERT INTO `lang_definitions` VALUES (97, 211, 2, 'Lägg till följande meningar till Apache konfigurationsfilen');
INSERT INTO `lang_definitions` VALUES (98, 212, 2, 'Lägg till en ny Grupp');
INSERT INTO `lang_definitions` VALUES (99, 214, 2, 'Lägg till en ny diagnos-kod (ICD)');
INSERT INTO `lang_definitions` VALUES (100, 215, 2, 'Lägg till en ny vaccination');
INSERT INTO `lang_definitions` VALUES (101, 216, 2, 'Inte tillåtet att lägga till!');
INSERT INTO `lang_definitions` VALUES (102, 217, 2, 'Lägg till händelse');
INSERT INTO `lang_definitions` VALUES (103, 219, 2, 'Lägg till ett nytt Språk');
INSERT INTO `lang_definitions` VALUES (104, 224, 2, 'Lägg till Ny');
INSERT INTO `lang_definitions` VALUES (105, 225, 2, 'Lägg till Ny');
INSERT INTO `lang_definitions` VALUES (106, 226, 2, 'Lägg till en ny kategori:');
INSERT INTO `lang_definitions` VALUES (107, 227, 2, 'Lägg till ett nytt certifikat till Apache konfigurationsfil');
INSERT INTO `lang_definitions` VALUES (108, 234, 2, 'Lägg till en ny grupp');
INSERT INTO `lang_definitions` VALUES (109, 236, 2, 'Lägg till en ny lot och överföring');
INSERT INTO `lang_definitions` VALUES (110, 238, 2, 'Lägg till en ny kommentar');
INSERT INTO `lang_definitions` VALUES (111, 239, 2, 'Lägg till en ny kommentar');
INSERT INTO `lang_definitions` VALUES (112, 240, 2, 'Lägg till en ny partner');
INSERT INTO `lang_definitions` VALUES (113, 244, 2, 'Lägg till en ny anteckning');
INSERT INTO `lang_definitions` VALUES (114, 248, 2, 'Lägg till en ny patient');
INSERT INTO `lang_definitions` VALUES (115, 249, 2, 'Lägg till ett nytt recept');
INSERT INTO `lang_definitions` VALUES (116, 250, 2, 'Lägg till åtgärd');
INSERT INTO `lang_definitions` VALUES (117, 251, 2, 'Lägg till Vårdgivares nummer');
INSERT INTO `lang_definitions` VALUES (118, 253, 2, 'Lägg till rehab');
INSERT INTO `lang_definitions` VALUES (119, 254, 2, 'Lägg till en ny regel');
INSERT INTO `lang_definitions` VALUES (120, 257, 2, 'Tillägg till');
INSERT INTO `lang_definitions` VALUES (121, 261, 2, 'Lägg till i medicinlista');
INSERT INTO `lang_definitions` VALUES (122, 262, 2, 'Tillägg av högsta nivå');
INSERT INTO `lang_definitions` VALUES (123, 263, 2, 'Lägg till en ny överföring');
INSERT INTO `lang_definitions` VALUES (124, 264, 2, 'Lägg till en ny användare');
INSERT INTO `lang_definitions` VALUES (125, 265, 2, 'Lägg till användaren i gruppen');
INSERT INTO `lang_definitions` VALUES (126, 267, 2, 'Lägg till/ändra elektroniskt recept');
INSERT INTO `lang_definitions` VALUES (127, 269, 2, 'Lägg till/ändra patientens överföringar');
INSERT INTO `lang_definitions` VALUES (128, 270, 2, 'tillagd');
INSERT INTO `lang_definitions` VALUES (129, 273, 2, 'Ej tillåtet att lägga till personuppgifter.');
INSERT INTO `lang_definitions` VALUES (130, 275, 2, 'Mb Addison');
INSERT INTO `lang_definitions` VALUES (131, 276, 2, 'Mb Addison');
INSERT INTO `lang_definitions` VALUES (132, 277, 2, 'Flera attribut');
INSERT INTO `lang_definitions` VALUES (133, 280, 2, 'Ytterligare Diagnos:');
INSERT INTO `lang_definitions` VALUES (134, 284, 2, 'Kompletterande anamnes');
INSERT INTO `lang_definitions` VALUES (135, 285, 2, 'Kompletterande anamnesuppgifter');
INSERT INTO `lang_definitions` VALUES (136, 286, 2, 'Kompletterande Information');
INSERT INTO `lang_definitions` VALUES (137, 289, 2, 'Kompletterande Lab. svar');
INSERT INTO `lang_definitions` VALUES (138, 290, 2, 'Kompletterande noteringar');
INSERT INTO `lang_definitions` VALUES (139, 292, 2, 'Ytterligare noteringar för detta resultat eller rekomendation');
INSERT INTO `lang_definitions` VALUES (140, 293, 2, 'Ytterligare noteringar:');
INSERT INTO `lang_definitions` VALUES (141, 294, 2, 'Ytterligare noteringar:');
INSERT INTO `lang_definitions` VALUES (142, 295, 2, 'Ytterligare röntgenanteckningar:');
INSERT INTO `lang_definitions` VALUES (143, 296, 2, 'Som tillägg, motsvarande US Snomed Extension Package can importeras separat efter instalation av den internationella (engelska) Snomed utgåvan');
INSERT INTO `lang_definitions` VALUES (144, 298, 2, 'Lägg endast till');
INSERT INTO `lang_definitions` VALUES (145, 300, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (146, 301, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (147, 302, 2, 'Adress');
INSERT INTO `lang_definitions` VALUES (148, 305, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (149, 306, 2, 'Tillgång till adressboken för företaget som utför denna åtgärd');
INSERT INTO `lang_definitions` VALUES (150, 307, 2, 'Tillgång till adressboken för distributören');
INSERT INTO `lang_definitions` VALUES (151, 308, 2, 'Tillgång till adressboken för försäljare');
INSERT INTO `lang_definitions` VALUES (152, 309, 2, 'Typer av adressböcker');
INSERT INTO `lang_definitions` VALUES (153, 315, 2, 'Adress1');
INSERT INTO `lang_definitions` VALUES (154, 316, 2, 'Adress2');
INSERT INTO `lang_definitions` VALUES (155, 318, 2, 'ADRESSATEN');
INSERT INTO `lang_definitions` VALUES (156, 321, 2, 'Justera');
INSERT INTO `lang_definitions` VALUES (157, 322, 2, 'Korrigera mängd');
INSERT INTO `lang_definitions` VALUES (158, 323, 2, 'Justera');
INSERT INTO `lang_definitions` VALUES (159, 324, 2, 'Korrigering');
INSERT INTO `lang_definitions` VALUES (160, 325, 2, 'Justera mängd');
INSERT INTO `lang_definitions` VALUES (161, 326, 2, 'Orsak till justering');
INSERT INTO `lang_definitions` VALUES (162, 327, 2, 'Justering av värde för kod');
INSERT INTO `lang_definitions` VALUES (163, 328, 2, 'Justeringar');
INSERT INTO `lang_definitions` VALUES (164, 329, 2, 'Administrera justeringar');
INSERT INTO `lang_definitions` VALUES (165, 330, 2, 'Administrera');
INSERT INTO `lang_definitions` VALUES (166, 331, 2, 'Admin E-postadress');
INSERT INTO `lang_definitions` VALUES (167, 332, 2, 'Administrera via');
INSERT INTO `lang_definitions` VALUES (168, 334, 2, 'Administrerad av');
INSERT INTO `lang_definitions` VALUES (169, 335, 2, 'Administrerad av');
INSERT INTO `lang_definitions` VALUES (170, 337, 2, 'Administrera plats');
INSERT INTO `lang_definitions` VALUES (171, 338, 2, 'Administration');
INSERT INTO `lang_definitions` VALUES (172, 340, 2, 'Administrera plats');
INSERT INTO `lang_definitions` VALUES (173, 341, 2, 'Administratörer');
INSERT INTO `lang_definitions` VALUES (174, 342, 2, 'Administratörer kan göra allt');
INSERT INTO `lang_definitions` VALUES (175, 343, 2, 'Godkänn datum');
INSERT INTO `lang_definitions` VALUES (176, 346, 2, 'Viktkontroller med uppföljning för vuxna');
INSERT INTO `lang_definitions` VALUES (177, 347, 2, 'Viktkontroller med uppföljning för vuxna');
INSERT INTO `lang_definitions` VALUES (178, 348, 2, 'Avancerade råd');
INSERT INTO `lang_definitions` VALUES (179, 349, 2, 'Avancerade råd');
INSERT INTO `lang_definitions` VALUES (180, 350, 2, 'Varning i avancerade råd');
INSERT INTO `lang_definitions` VALUES (181, 352, 2, 'Avancerad');
INSERT INTO `lang_definitions` VALUES (182, 355, 2, 'Råd');
INSERT INTO `lang_definitions` VALUES (183, 357, 2, 'Neutral grundstämning');
INSERT INTO `lang_definitions` VALUES (184, 361, 2, 'Joursamtal');
INSERT INTO `lang_definitions` VALUES (185, 362, 2, 'Efter flytt från det gamla lösenordshanteringen där lösenord sparadesokrypterat i användartabellenska denna flagga markeras så att enbart inloggning med den nya metoden kan användas');
INSERT INTO `lang_definitions` VALUES (186, 363, 2, 'Efter genomförandet av ovannämnda konfigurationer, importera admin. klientens certifikat till webläsaren och starta om Apache server ( tömma lösenord )');
INSERT INTO `lang_definitions` VALUES (187, 364, 2, 'Efter att PDF sparats, klicka på [View Log] för att söka efter fel.');
INSERT INTO `lang_definitions` VALUES (188, 366, 2, 'Efter sparandet av TEXT filer , klicka på [View Log] för att leta efter fel');
INSERT INTO `lang_definitions` VALUES (189, 368, 2, 'Efter sparandet av ditt parti, klicka på [View Log] för att granska för fel.');
INSERT INTO `lang_definitions` VALUES (190, 371, 2, 'När informationen är korrekt införd, klicka på Spara knappen.');
INSERT INTO `lang_definitions` VALUES (191, 376, 2, 'Planering av eftervård');
INSERT INTO `lang_definitions` VALUES (192, 377, 2, 'Igen');
INSERT INTO `lang_definitions` VALUES (193, 378, 2, 'Ålder');
INSERT INTO `lang_definitions` VALUES (194, 380, 2, 'Ålder av');
INSERT INTO `lang_definitions` VALUES (195, 381, 2, 'Ålderskategori');
INSERT INTO `lang_definitions` VALUES (196, 382, 2, 'Denna Åder är utanför befintlig intervall');
INSERT INTO `lang_definitions` VALUES (197, 383, 2, 'Format för att visa ålder');
INSERT INTO `lang_definitions` VALUES (198, 384, 2, 'Detta format för \"ålder från\" är inte tillåtet');
INSERT INTO `lang_definitions` VALUES (199, 385, 2, 'Detta format för \"ålder upp till\" är inte tillåtet');
INSERT INTO `lang_definitions` VALUES (200, 386, 2, 'Ålder från');
INSERT INTO `lang_definitions` VALUES (201, 387, 2, 'Ändra format för att visa ålder i år');
INSERT INTO `lang_definitions` VALUES (202, 388, 2, 'Högsta ålder');
INSERT INTO `lang_definitions` VALUES (203, 389, 2, 'Lägsta ålder');
INSERT INTO `lang_definitions` VALUES (204, 390, 2, 'Åldersintervall');
INSERT INTO `lang_definitions` VALUES (205, 392, 2, 'Kolumner med åldern');
INSERT INTO `lang_definitions` VALUES (206, 394, 2, 'Albansk');
INSERT INTO `lang_definitions` VALUES (207, 395, 2, 'Alkohol');
INSERT INTO `lang_definitions` VALUES (208, 396, 2, 'Alkoholkonsumtion');
INSERT INTO `lang_definitions` VALUES (209, 399, 2, 'Antal varningar');
INSERT INTO `lang_definitions` VALUES (210, 405, 2, 'Varningar');
INSERT INTO `lang_definitions` VALUES (211, 409, 2, 'Aleut-befolkning');
INSERT INTO `lang_definitions` VALUES (212, 410, 2, 'Alla');
INSERT INTO `lang_definitions` VALUES (213, 411, 2, 'Alla');
INSERT INTO `lang_definitions` VALUES (214, 413, 2, 'Alla (format A)');
INSERT INTO `lang_definitions` VALUES (215, 414, 2, 'Alla (format B)');
INSERT INTO `lang_definitions` VALUES (216, 415, 2, 'Allt ( Kumulativt )');
INSERT INTO `lang_definitions` VALUES (217, 418, 2, 'Alla Kategorier');
INSERT INTO `lang_definitions` VALUES (218, 420, 2, 'Alla koder');
INSERT INTO `lang_definitions` VALUES (219, 422, 2, 'Hela dagen');
INSERT INTO `lang_definitions` VALUES (220, 423, 2, 'Heldagshändelse');
INSERT INTO `lang_definitions` VALUES (221, 424, 2, 'Alla demografiska fält , med sökning och dubbel kontroll');
INSERT INTO `lang_definitions` VALUES (222, 426, 2, 'Alla kliniker');
INSERT INTO `lang_definitions` VALUES (223, 427, 2, 'Alla skador/problem/frågeställningar');
INSERT INTO `lang_definitions` VALUES (224, 428, 2, 'All språk är tillåtna');
INSERT INTO `lang_definitions` VALUES (225, 431, 2, 'Hela förnamnet eller en del av det');
INSERT INTO `lang_definitions` VALUES (226, 432, 2, 'Hela efternamnet eller en del av det');
INSERT INTO `lang_definitions` VALUES (227, 433, 2, 'Hela organisationen eller delar av namnet');
INSERT INTO `lang_definitions` VALUES (228, 437, 2, 'Alla produkter');
INSERT INTO `lang_definitions` VALUES (229, 438, 2, 'Alla vårdgivare');
INSERT INTO `lang_definitions` VALUES (230, 439, 2, 'Alla granskade och Negativa:');
INSERT INTO `lang_definitions` VALUES (231, 442, 2, 'Alla ämnen');
INSERT INTO `lang_definitions` VALUES (232, 445, 2, 'Alla användare');
INSERT INTO `lang_definitions` VALUES (233, 446, 2, 'Allergisk');
INSERT INTO `lang_definitions` VALUES (234, 448, 2, 'Allergier');
INSERT INTO `lang_definitions` VALUES (235, 451, 2, 'Allergier:');
INSERT INTO `lang_definitions` VALUES (236, 452, 2, 'Allergi');
INSERT INTO `lang_definitions` VALUES (237, 453, 2, 'Import av allergier klart');
INSERT INTO `lang_definitions` VALUES (238, 454, 2, 'Lista på allergier');
INSERT INTO `lang_definitions` VALUES (239, 455, 2, 'Allergisk reaktion');
INSERT INTO `lang_definitions` VALUES (240, 458, 2, 'Tilldela');
INSERT INTO `lang_definitions` VALUES (241, 459, 2, 'Tillåta');
INSERT INTO `lang_definitions` VALUES (242, 461, 2, 'Tillåt alla tillgängliga språk som val i menyn vid inloggning');
INSERT INTO `lang_definitions` VALUES (243, 463, 2, 'Tillåt att skapa krav innehållande diagnoser , men ej procedurer eller betalningar. De flesta kliniker vill inte ha det');
INSERT INTO `lang_definitions` VALUES (244, 464, 2, 'Tillåt debugg språk');
INSERT INTO `lang_definitions` VALUES (245, 466, 2, 'E-post tillåten');
INSERT INTO `lang_definitions` VALUES (246, 467, 2, 'Är e-post meddelande tillåtet ?');
INSERT INTO `lang_definitions` VALUES (247, 468, 2, 'Tillåt e-post?');
INSERT INTO `lang_definitions` VALUES (248, 469, 2, 'Tillåt krav i patient möte');
INSERT INTO `lang_definitions` VALUES (249, 472, 2, 'Tillåt utbyte av hälsoinformationen');
INSERT INTO `lang_definitions` VALUES (250, 474, 2, 'Tillåt att informationen om vaccinationer delas');
INSERT INTO `lang_definitions` VALUES (251, 475, 2, 'Tillåt användning av vaccinationsregistret');
INSERT INTO `lang_definitions` VALUES (252, 478, 2, 'Tillåt e-post meddelanden');
INSERT INTO `lang_definitions` VALUES (253, 492, 2, 'Tillåt patient-inloggning');
INSERT INTO `lang_definitions` VALUES (254, 494, 2, 'Tillåt SMS');
INSERT INTO `lang_definitions` VALUES (255, 495, 2, 'Är SMS meddelanden tillåtna ?');
INSERT INTO `lang_definitions` VALUES (256, 497, 2, 'Tillåt aktuella händelser att vara aktiva omedelbart ?');
INSERT INTO `lang_definitions` VALUES (257, 498, 2, 'Tillåt telefon meddelanden?');
INSERT INTO `lang_definitions` VALUES (258, 500, 2, 'Tillåt användare att publicera Globala Händelser');
INSERT INTO `lang_definitions` VALUES (259, 501, 2, 'Tillåt användare att publicera personliga kalendrar');
INSERT INTO `lang_definitions` VALUES (260, 507, 2, 'Tillåt telefonsvarare');
INSERT INTO `lang_definitions` VALUES (261, 508, 2, 'Tillåten');
INSERT INTO `lang_definitions` VALUES (262, 509, 2, 'Godkända språk');
INSERT INTO `lang_definitions` VALUES (263, 511, 2, 'Godkänt');
INSERT INTO `lang_definitions` VALUES (264, 517, 2, 'finns redan');
INSERT INTO `lang_definitions` VALUES (265, 518, 2, 'Finns redan');
INSERT INTO `lang_definitions` VALUES (266, 520, 2, 'Används redan, välj en annan identitetsbeteckning');
INSERT INTO `lang_definitions` VALUES (267, 521, 2, 'Används redan, välj en annan titel');
INSERT INTO `lang_definitions` VALUES (268, 523, 2, 'Alternativ Adress');
INSERT INTO `lang_definitions` VALUES (269, 524, 2, 'Ändra');
INSERT INTO `lang_definitions` VALUES (270, 531, 2, 'Alternativt kan du använda sökfunktionen för att lägga upp ett elektroniskt godkännande (X12 83l fil) som du fått från din betalare eller clearingorganisationer. Du kan göra detta genom att klicka på knappen Bläddra och välj den fil som ska laddas upp och sedan klicka på Sök för att ladda upp och visa motsvarande fakturor. I detta fall gäller inte de andra parametrar som nämns ovan och de kommer att ignoreras. Överföring sparar filen men processar ännuinte innehållet - detta är gjort separat enligt nedan.');
INSERT INTO `lang_definitions` VALUES (271, 533, 2, 'förmiddag');
INSERT INTO `lang_definitions` VALUES (272, 534, 2, 'Förmiddagens program');
INSERT INTO `lang_definitions` VALUES (273, 539, 2, 'Automatisk beräkning av åtgärder (AMC)');
INSERT INTO `lang_definitions` VALUES (274, 540, 2, 'Spåra AMC');
INSERT INTO `lang_definitions` VALUES (275, 547, 2, 'Ändra Befintlig notering');
INSERT INTO `lang_definitions` VALUES (276, 556, 2, 'Amerikansk indian');
INSERT INTO `lang_definitions` VALUES (277, 557, 2, 'Amerikans indian eller född i alaska');
INSERT INTO `lang_definitions` VALUES (278, 558, 2, 'AMEX');
INSERT INTO `lang_definitions` VALUES (279, 559, 2, 'Etiopier');
INSERT INTO `lang_definitions` VALUES (280, 560, 2, 'Belopp');
INSERT INTO `lang_definitions` VALUES (281, 561, 2, 'Administrerat belopp');
INSERT INTO `lang_definitions` VALUES (282, 563, 2, 'Begärt belopp');
INSERT INTO `lang_definitions` VALUES (283, 566, 2, 'Belopp från tidigare Saldo');
INSERT INTO `lang_definitions` VALUES (284, 567, 2, 'Belopp för besöket');
INSERT INTO `lang_definitions` VALUES (285, 568, 2, 'Belopp som betalts');
INSERT INTO `lang_definitions` VALUES (286, 569, 2, 'Belopp:');
INSERT INTO `lang_definitions` VALUES (287, 572, 2, 'fakturerat belopp');
INSERT INTO `lang_definitions` VALUES (288, 576, 2, 'Ett slutdatum senare än startdatum krävs för upprepade händelser!');
INSERT INTO `lang_definitions` VALUES (289, 578, 2, 'ett fel uppstod när OpenEMR sparades');
INSERT INTO `lang_definitions` VALUES (290, 579, 2, 'Ett fel uppstod när phpGACL sparades');
INSERT INTO `lang_definitions` VALUES (291, 580, 2, 'Ett fel uppstod när SQL-ledger sparades');
INSERT INTO `lang_definitions` VALUES (292, 584, 2, 'En ofullständig GCAC fråga har inrättats och knutits. Någon kommer att behöva fylla i det senare.');
INSERT INTO `lang_definitions` VALUES (293, 590, 2, 'Ett oförutsett fel uppkom');
INSERT INTO `lang_definitions` VALUES (294, 592, 2, 'En stor bokstav');
INSERT INTO `lang_definitions` VALUES (295, 594, 2, 'och');
INSERT INTO `lang_definitions` VALUES (296, 595, 2, 'Och');
INSERT INTO `lang_definitions` VALUES (297, 596, 2, 'OCH');
INSERT INTO `lang_definitions` VALUES (298, 597, 2, 'och');
INSERT INTO `lang_definitions` VALUES (299, 598, 2, 'och alla underordnade data? Denna åtgärd kommer att loggas');
INSERT INTO `lang_definitions` VALUES (300, 599, 2, 'och modifierare');
INSERT INTO `lang_definitions` VALUES (301, 600, 2, 'och hanterad.');
INSERT INTO `lang_definitions` VALUES (302, 601, 2, 'och starta om Apache servern.');
INSERT INTO `lang_definitions` VALUES (303, 602, 2, 'och orsaken är');
INSERT INTO `lang_definitions` VALUES (304, 604, 2, 'Anemi');
INSERT INTO `lang_definitions` VALUES (305, 605, 2, 'Ankel');
INSERT INTO `lang_definitions` VALUES (306, 606, 2, 'Ankel + häl');
INSERT INTO `lang_definitions` VALUES (307, 607, 2, 'Ankel Utvärderingsformulär');
INSERT INTO `lang_definitions` VALUES (308, 608, 2, 'Ankel problem');
INSERT INTO `lang_definitions` VALUES (309, 609, 2, 'Ankyloserande Spondylit');
INSERT INTO `lang_definitions` VALUES (310, 610, 2, 'Ankyloserande Spondylit');
INSERT INTO `lang_definitions` VALUES (311, 611, 2, 'Anorexia');
INSERT INTO `lang_definitions` VALUES (312, 612, 2, 'En annan sak du kan göra i utstationering fönstret är att begära en sekundära fakturering. Om du markerar rutan innan du sparar, så kommer den ursprungliga fordran att öppnas igen och köas på faktureringssidan och sedan behandlas under nästa faktureringskörning.');
INSERT INTO `lang_definitions` VALUES (313, 615, 2, 'framåt');
INSERT INTO `lang_definitions` VALUES (314, 620, 2, 'Anus, ingen rektal ömhet');
INSERT INTO `lang_definitions` VALUES (315, 621, 2, 'Ångest');
INSERT INTO `lang_definitions` VALUES (316, 622, 2, 'Valfri');
INSERT INTO `lang_definitions` VALUES (317, 626, 2, 'någon Kategori');
INSERT INTO `lang_definitions` VALUES (318, 631, 2, 'Någon del av en kod eller dess beskrivning');
INSERT INTO `lang_definitions` VALUES (319, 632, 2, 'Någon del av önskad specialitet');
INSERT INTO `lang_definitions` VALUES (320, 633, 2, 'någon del av medicinens namn eller id');
INSERT INTO `lang_definitions` VALUES (321, 634, 2, 'Någon del av vaccinations namn eller id');
INSERT INTO `lang_definitions` VALUES (322, 635, 2, 'Någon del av patientens namn, eller \"efternamn, förnamn \" eller \"X-Y \"');
INSERT INTO `lang_definitions` VALUES (323, 636, 2, 'Någon annan relevant information');
INSERT INTO `lang_definitions` VALUES (324, 640, 2, 'API nyckel till SMS portal');
INSERT INTO `lang_definitions` VALUES (325, 641, 2, 'Andningsuppehåll');
INSERT INTO `lang_definitions` VALUES (326, 643, 2, 'Utseende');
INSERT INTO `lang_definitions` VALUES (327, 644, 2, 'Utseende:');
INSERT INTO `lang_definitions` VALUES (328, 647, 2, 'Lägg till denna notering');
INSERT INTO `lang_definitions` VALUES (329, 649, 2, 'Lägg till den nuvarande noteringen');
INSERT INTO `lang_definitions` VALUES (330, 650, 2, 'Lägg till denna anmärkning');
INSERT INTO `lang_definitions` VALUES (331, 651, 2, 'Bifoga till denna notering');
INSERT INTO `lang_definitions` VALUES (332, 652, 2, 'Appendektomi');
INSERT INTO `lang_definitions` VALUES (333, 654, 2, 'Tällämpliga patienter');
INSERT INTO `lang_definitions` VALUES (334, 655, 2, 'Ansökan');
INSERT INTO `lang_definitions` VALUES (335, 656, 2, 'Namn på program vid inloggning och titel på sidan');
INSERT INTO `lang_definitions` VALUES (336, 657, 2, 'Mottagarkod (GS03. Om blank kommer ISA08 användas)');
INSERT INTO `lang_definitions` VALUES (337, 658, 2, 'Sändarkod (GS02)');
INSERT INTO `lang_definitions` VALUES (338, 659, 2, 'Programmets titel');
INSERT INTO `lang_definitions` VALUES (339, 660, 2, 'Gäller Formulär för vitalparametrar och tillväxtkurva');
INSERT INTO `lang_definitions` VALUES (340, 661, 2, 'Gäller formulär för vitalparametrar');
INSERT INTO `lang_definitions` VALUES (341, 662, 2, 'Tillämpa ändringen på nuvarande händelse, nuvarande och alla kommande händelser eller alla händelser?');
INSERT INTO `lang_definitions` VALUES (342, 663, 2, 'tillämpas på berörda området');
INSERT INTO `lang_definitions` VALUES (343, 664, 2, 'appliceras på huden');
INSERT INTO `lang_definitions` VALUES (344, 665, 2, 'Lägger till');
INSERT INTO `lang_definitions` VALUES (345, 666, 2, 'Lägger till patch till sidan');
INSERT INTO `lang_definitions` VALUES (346, 667, 2, 'Bokning');
INSERT INTO `lang_definitions` VALUES (347, 669, 2, 'Boknings datum');
INSERT INTO `lang_definitions` VALUES (348, 675, 2, 'Sätt att visa bokning');
INSERT INTO `lang_definitions` VALUES (349, 677, 2, 'Påminnelser för bokning');
INSERT INTO `lang_definitions` VALUES (350, 679, 2, 'Boknings status');
INSERT INTO `lang_definitions` VALUES (351, 680, 2, 'Boknings status');
INSERT INTO `lang_definitions` VALUES (352, 681, 2, 'Bokas inom');
INSERT INTO `lang_definitions` VALUES (353, 682, 2, 'Bokning/händelse färg');
INSERT INTO `lang_definitions` VALUES (354, 683, 2, 'Bokningar');
INSERT INTO `lang_definitions` VALUES (355, 684, 2, 'Bokningar ( valfritt att skriva )');
INSERT INTO `lang_definitions` VALUES (356, 685, 2, 'Bokningar (Skriv, några valbara)');
INSERT INTO `lang_definitions` VALUES (357, 691, 2, 'Bokningar och besök');
INSERT INTO `lang_definitions` VALUES (358, 693, 2, 'Bokningsrapport');
INSERT INTO `lang_definitions` VALUES (359, 694, 2, 'Boknings och besöksrapport');
INSERT INTO `lang_definitions` VALUES (360, 697, 2, 'Godkänn');
INSERT INTO `lang_definitions` VALUES (361, 700, 2, 'Godkänd');
INSERT INTO `lang_definitions` VALUES (362, 701, 2, 'Godkända administrativa händelser');
INSERT INTO `lang_definitions` VALUES (363, 707, 2, 'Bokningar-besök');
INSERT INTO `lang_definitions` VALUES (364, 709, 2, 'Bokningar');
INSERT INTO `lang_definitions` VALUES (365, 712, 2, 'Apr');
INSERT INTO `lang_definitions` VALUES (366, 713, 2, 'April');
INSERT INTO `lang_definitions` VALUES (367, 715, 2, 'Arabisk');
INSERT INTO `lang_definitions` VALUES (368, 717, 2, 'Arkivera');
INSERT INTO `lang_definitions` VALUES (369, 720, 2, 'Ska gruppnamnen översättas?');
INSERT INTO `lang_definitions` VALUES (370, 721, 2, 'Ska bokningstyperna översättas?');
INSERT INTO `lang_definitions` VALUES (371, 722, 2, 'Ska dokumenttyperna översättas?');
INSERT INTO `lang_definitions` VALUES (372, 723, 2, 'Ska avgifter tas ut för denna typ?');
INSERT INTO `lang_definitions` VALUES (373, 726, 2, 'Ska överskrifter på patientanteckningar översättas?');
INSERT INTO `lang_definitions` VALUES (374, 727, 2, 'Är koderna lagrade i externa sql-tabeller (0-Nej, 1-ICD10, 2-SNOMED(RF1), 3-SNOMED(RF2) )');
INSERT INTO `lang_definitions` VALUES (375, 728, 2, 'Är du beredd att genomföra en ny GCAC fråga för detta besök?');
INSERT INTO `lang_definitions` VALUES (376, 730, 2, 'Är du säker du vill bokföra dagens händelser?');
INSERT INTO `lang_definitions` VALUES (377, 731, 2, 'Är du säker på att du vill godkänna dessa händelser?');
INSERT INTO `lang_definitions` VALUES (378, 733, 2, 'Är du säker på att du vill ta bort detta formulär?');
INSERT INTO `lang_definitions` VALUES (379, 735, 2, 'Är du säker på att du vill ta bort denna friskrivning?');
INSERT INTO `lang_definitions` VALUES (380, 736, 2, 'Är du säker på att du vill ta bort denna händelse?');
INSERT INTO `lang_definitions` VALUES (381, 737, 2, 'Är du säker du vill ta bort detta från databasen?');
INSERT INTO `lang_definitions` VALUES (382, 739, 2, 'Är du säker på att du vill ta bort detta meddelande?');
INSERT INTO `lang_definitions` VALUES (383, 741, 2, 'Är du säker på att du vill ändra dessa händelser?');
INSERT INTO `lang_definitions` VALUES (384, 742, 2, 'Är du säker på att du vill dölja dessa händelser?');
INSERT INTO `lang_definitions` VALUES (385, 745, 2, 'Är du säker på att du vill visa dessa händelser?');
INSERT INTO `lang_definitions` VALUES (386, 746, 2, 'Är du säker på att du vill ta bort hela den valda gruppen');
INSERT INTO `lang_definitions` VALUES (387, 747, 2, 'Är du säker på att du vill ta bort hela listan');
INSERT INTO `lang_definitions` VALUES (388, 748, 2, 'Är du säker på att du vill ta bort fältet i');
INSERT INTO `lang_definitions` VALUES (389, 749, 2, 'Är du säker på att du vill ta bort markerade fält?');
INSERT INTO `lang_definitions` VALUES (390, 750, 2, 'Är du säker på att du vill fortsätta med dessa åtgärder?');
INSERT INTO `lang_definitions` VALUES (391, 751, 2, 'Område är ej specifiserat');
INSERT INTO `lang_definitions` VALUES (392, 752, 2, 'Arm');
INSERT INTO `lang_definitions` VALUES (393, 753, 2, 'Armensk');
INSERT INTO `lang_definitions` VALUES (394, 760, 2, 'Arrytmi');
INSERT INTO `lang_definitions` VALUES (395, 761, 2, 'Artrit');
INSERT INTO `lang_definitions` VALUES (396, 762, 2, 'Artrit / Degenerativ ledsjukdom');
INSERT INTO `lang_definitions` VALUES (397, 763, 2, 'Artrit / Degenerativ ledsjukdom');
INSERT INTO `lang_definitions` VALUES (398, 767, 2, 'som');
INSERT INTO `lang_definitions` VALUES (399, 769, 2, 'Per');
INSERT INTO `lang_definitions` VALUES (400, 776, 2, 'Asiatisk');
INSERT INTO `lang_definitions` VALUES (401, 779, 2, 'Bedömning');
INSERT INTO `lang_definitions` VALUES (402, 784, 2, 'Tilldelas');
INSERT INTO `lang_definitions` VALUES (403, 785, 2, 'Assistent');
INSERT INTO `lang_definitions` VALUES (404, 792, 2, 'Astma');
INSERT INTO `lang_definitions` VALUES (405, 793, 2, 'på');
INSERT INTO `lang_definitions` VALUES (406, 794, 2, 'Minst en sök parameter krävs om du väljer Alla');
INSERT INTO `lang_definitions` VALUES (407, 797, 2, 'Vid Båtbenet');
INSERT INTO `lang_definitions` VALUES (408, 798, 2, 'Vid Båtbenet:');
INSERT INTO `lang_definitions` VALUES (409, 799, 2, 'Idrottsgrupp');
INSERT INTO `lang_definitions` VALUES (410, 800, 2, 'Idrottsgrupp');
INSERT INTO `lang_definitions` VALUES (411, 801, 2, 'Idrottsskada');
INSERT INTO `lang_definitions` VALUES (412, 802, 2, 'CA certifikat för ATNA revision');
INSERT INTO `lang_definitions` VALUES (413, 803, 2, 'Värd för ATNA revision');
INSERT INTO `lang_definitions` VALUES (414, 804, 2, 'Lokalt certifikat för ATNA revision');
INSERT INTO `lang_definitions` VALUES (415, 805, 2, 'Posrt för ATNA revision');
INSERT INTO `lang_definitions` VALUES (416, 808, 2, 'Observera');
INSERT INTO `lang_definitions` VALUES (417, 810, 2, 'OBS');
INSERT INTO `lang_definitions` VALUES (418, 813, 2, 'revision CDR urval');
INSERT INTO `lang_definitions` VALUES (419, 820, 2, 'Revisionsloggning backup');
INSERT INTO `lang_definitions` VALUES (420, 821, 2, 'revisionsloggning blandad');
INSERT INTO `lang_definitions` VALUES (421, 822, 2, 'Revisionsloggning sorteringsordning');
INSERT INTO `lang_definitions` VALUES (422, 823, 2, 'Revisionsloggning patientjournal');
INSERT INTO `lang_definitions` VALUES (423, 824, 2, 'revisionsloggning schemaläggning');
INSERT INTO `lang_definitions` VALUES (424, 825, 2, 'Hantera säkerhet för revisorslog');
INSERT INTO `lang_definitions` VALUES (425, 826, 2, 'Urval av revisorlog');
INSERT INTO `lang_definitions` VALUES (426, 828, 2, 'Aug');
INSERT INTO `lang_definitions` VALUES (427, 829, 2, 'Augusti');
INSERT INTO `lang_definitions` VALUES (428, 831, 2, 'Rättigheter');
INSERT INTO `lang_definitions` VALUES (429, 832, 2, 'Rättighet/anteckningar');
INSERT INTO `lang_definitions` VALUES (430, 841, 2, 'Grupprättigheter');
INSERT INTO `lang_definitions` VALUES (431, 842, 2, 'Status på auktorisation');
INSERT INTO `lang_definitions` VALUES (432, 843, 2, 'Tillstånd');
INSERT INTO `lang_definitions` VALUES (433, 844, 2, 'Bemyndiga');
INSERT INTO `lang_definitions` VALUES (434, 845, 2, 'Auktorisera – alla möten');
INSERT INTO `lang_definitions` VALUES (435, 847, 2, 'Auktorisera - Mina möten');
INSERT INTO `lang_definitions` VALUES (436, 852, 2, 'Auktorisera.net');
INSERT INTO `lang_definitions` VALUES (437, 853, 2, 'Auktoriserad');
INSERT INTO `lang_definitions` VALUES (438, 855, 2, 'Enbart auktoriserade');
INSERT INTO `lang_definitions` VALUES (439, 859, 2, 'Skicka automatiskt');
INSERT INTO `lang_definitions` VALUES (440, 862, 2, 'Skapa nytt besök automatiskt');
INSERT INTO `lang_definitions` VALUES (441, 863, 2, 'Autogenererad');
INSERT INTO `lang_definitions` VALUES (442, 865, 2, 'Automatiska beräkningar (AMC)');
INSERT INTO `lang_definitions` VALUES (443, 870, 2, 'Spåra automatiska beräkningar (ATM)');
INSERT INTO `lang_definitions` VALUES (444, 871, 2, 'Automatiska mätningar (AMC)');
INSERT INTO `lang_definitions` VALUES (445, 873, 2, 'Automatiskt');
INSERT INTO `lang_definitions` VALUES (446, 877, 2, 'Automatiskt skapa nytt besök när bokningsstatus är satt till ”@” (Kommit)');
INSERT INTO `lang_definitions` VALUES (447, 880, 2, 'Trafikmedicin');
INSERT INTO `lang_definitions` VALUES (448, 882, 2, 'Sparad automatisk');
INSERT INTO `lang_definitions` VALUES (449, 885, 2, 'Tillgängliga kategorier');
INSERT INTO `lang_definitions` VALUES (450, 888, 2, 'Tillgängliga tider');
INSERT INTO `lang_definitions` VALUES (451, 893, 2, 'Månadsgenomsnitt');
INSERT INTO `lang_definitions` VALUES (452, 897, 2, 'Avulsion / avulsion fraktur');
INSERT INTO `lang_definitions` VALUES (453, 898, 2, 'Avulsion laterala malleolus');
INSERT INTO `lang_definitions` VALUES (454, 899, 2, 'Avulsion mediala malleolus');
INSERT INTO `lang_definitions` VALUES (455, 900, 2, 'Medvetandebaserad');
INSERT INTO `lang_definitions` VALUES (456, 902, 2, 'Axillär');
INSERT INTO `lang_definitions` VALUES (457, 909, 2, '2 ggr/dag');
INSERT INTO `lang_definitions` VALUES (458, 910, 2, 'Tillbaka');
INSERT INTO `lang_definitions` VALUES (459, 911, 2, 'tillbaka');
INSERT INTO `lang_definitions` VALUES (460, 912, 2, 'Bakåt 8 besök');
INSERT INTO `lang_definitions` VALUES (461, 913, 2, 'Bakåt 11 besök');
INSERT INTO `lang_definitions` VALUES (462, 914, 2, 'Bakåt 5 besök');
INSERT INTO `lang_definitions` VALUES (463, 915, 2, 'Bakåt 4 besök');
INSERT INTO `lang_definitions` VALUES (464, 916, 2, 'Bakåt 9 besök');
INSERT INTO `lang_definitions` VALUES (465, 917, 2, 'Bakåt 1 besök');
INSERT INTO `lang_definitions` VALUES (466, 918, 2, 'Ryggsmärta');
INSERT INTO `lang_definitions` VALUES (467, 919, 2, 'Ryggproblem');
INSERT INTO `lang_definitions` VALUES (468, 920, 2, 'Bakåt 7 besök');
INSERT INTO `lang_definitions` VALUES (469, 921, 2, 'Bakåt 6 besök');
INSERT INTO `lang_definitions` VALUES (470, 922, 2, 'Ryggkirurgi');
INSERT INTO `lang_definitions` VALUES (471, 923, 2, 'Bakåt 10 besök');
INSERT INTO `lang_definitions` VALUES (472, 924, 2, 'Bakåt 3 besök');
INSERT INTO `lang_definitions` VALUES (473, 925, 2, 'Tillbaka till Admin sidan');
INSERT INTO `lang_definitions` VALUES (474, 929, 2, 'Tillbaka till patient');
INSERT INTO `lang_definitions` VALUES (475, 931, 2, 'Tillbaka till användare');
INSERT INTO `lang_definitions` VALUES (476, 932, 2, 'Tillbaka till Visa');
INSERT INTO `lang_definitions` VALUES (477, 933, 2, 'Bakåt 12 besök');
INSERT INTO `lang_definitions` VALUES (478, 934, 2, 'Bakåt 2 besök');
INSERT INTO `lang_definitions` VALUES (479, 935, 2, 'Bakgrunds tjänster');
INSERT INTO `lang_definitions` VALUES (480, 936, 2, 'Backup');
INSERT INTO `lang_definitions` VALUES (481, 938, 2, 'Backup-filen har skapats. Kommer nu skicka till nedladdning.');
INSERT INTO `lang_definitions` VALUES (482, 940, 2, 'Backup genomfört i');
INSERT INTO `lang_definitions` VALUES (483, 941, 2, 'Dålig kontroll');
INSERT INTO `lang_definitions` VALUES (484, 942, 2, 'Dålig fordran');
INSERT INTO `lang_definitions` VALUES (485, 943, 2, 'Bahasa Indonesia');
INSERT INTO `lang_definitions` VALUES (486, 944, 2, 'Bal');
INSERT INTO `lang_definitions` VALUES (487, 945, 2, 'Balans');
INSERT INTO `lang_definitions` VALUES (488, 946, 2, 'balans');
INSERT INTO `lang_definitions` VALUES (489, 947, 2, 'Saldo mängd');
INSERT INTO `lang_definitions` VALUES (490, 948, 2, 'Balanserade skulder');
INSERT INTO `lang_definitions` VALUES (491, 952, 2, 'Bankavdrag');
INSERT INTO `lang_definitions` VALUES (492, 956, 2, 'Basen av femte (5e) Metarsal');
INSERT INTO `lang_definitions` VALUES (493, 957, 2, 'Basen av femte (5e) Metarsal');
INSERT INTO `lang_definitions` VALUES (494, 964, 2, 'Samlingsfaktura');
INSERT INTO `lang_definitions` VALUES (495, 965, 2, 'Samlingskummunikationsverktyg');
INSERT INTO `lang_definitions` VALUES (496, 967, 2, 'Samlingsbetalning inskrivning');
INSERT INTO `lang_definitions` VALUES (497, 968, 2, 'samlingsbetalning');
INSERT INTO `lang_definitions` VALUES (498, 969, 2, 'Batchprocess påbörjad, detta kan ta ett tag.');
INSERT INTO `lang_definitions` VALUES (499, 970, 2, 'Samlingsresultat');
INSERT INTO `lang_definitions` VALUES (500, 971, 2, 'BatchCom');
INSERT INTO `lang_definitions` VALUES (501, 977, 2, 'För att ID inte existerar');
INSERT INTO `lang_definitions` VALUES (502, 986, 2, 'Starta');
INSERT INTO `lang_definitions` VALUES (503, 988, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (504, 991, 2, 'Tjänstens startdatum åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (505, 992, 2, 'Start klockslag för kalenderhändelse');
INSERT INTO `lang_definitions` VALUES (506, 996, 2, 'Rapningar');
INSERT INTO `lang_definitions` VALUES (507, 1000, 2, 'Bengali');
INSERT INTO `lang_definitions` VALUES (508, 1003, 2, 'Mellan');
INSERT INTO `lang_definitions` VALUES (509, 1009, 2, 'Bilateral');
INSERT INTO `lang_definitions` VALUES (510, 1010, 2, 'Bilaterala:');
INSERT INTO `lang_definitions` VALUES (511, 1013, 2, 'Faktura datuma:');
INSERT INTO `lang_definitions` VALUES (512, 1015, 2, 'Faktura');
INSERT INTO `lang_definitions` VALUES (513, 1016, 2, 'Fakturerade');
INSERT INTO `lang_definitions` VALUES (514, 1018, 2, 'Fakturering');
INSERT INTO `lang_definitions` VALUES (515, 1019, 2, 'Fakturering (skriv alternativ)');
INSERT INTO `lang_definitions` VALUES (516, 1023, 2, 'Fakturering attestera');
INSERT INTO `lang_definitions` VALUES (517, 1025, 2, 'Betalningskod för begärd service');
INSERT INTO `lang_definitions` VALUES (518, 1026, 2, 'Betalningskoder');
INSERT INTO `lang_definitions` VALUES (519, 1027, 2, 'Faktureringsdata');
INSERT INTO `lang_definitions` VALUES (520, 1028, 2, 'Fakturering avdelning');
INSERT INTO `lang_definitions` VALUES (521, 1029, 2, 'Fakturering Klinik');
INSERT INTO `lang_definitions` VALUES (522, 1031, 2, 'Faktureringsinformation');
INSERT INTO `lang_definitions` VALUES (523, 1032, 2, 'Faktureringsadress');
INSERT INTO `lang_definitions` VALUES (524, 1039, 2, 'Fakturaansvarig');
INSERT INTO `lang_definitions` VALUES (525, 1040, 2, 'Faktura Anmärkning');
INSERT INTO `lang_definitions` VALUES (526, 1041, 2, 'Fakturera anmärkning för');
INSERT INTO `lang_definitions` VALUES (527, 1042, 2, 'Fakturera notering:');
INSERT INTO `lang_definitions` VALUES (528, 1044, 2, 'Fakturera kö resultat:');
INSERT INTO `lang_definitions` VALUES (529, 1045, 2, 'Faktureringsrapport');
INSERT INTO `lang_definitions` VALUES (530, 1046, 2, 'Faktura status');
INSERT INTO `lang_definitions` VALUES (531, 1047, 2, 'Faktura status = Ej skickad');
INSERT INTO `lang_definitions` VALUES (532, 1048, 2, 'fakturera till');
INSERT INTO `lang_definitions` VALUES (533, 1052, 2, 'Biopsi');
INSERT INTO `lang_definitions` VALUES (534, 1054, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (535, 1055, 2, 'Födelse – 24 månader');
INSERT INTO `lang_definitions` VALUES (536, 1058, 2, 'Svart');
INSERT INTO `lang_definitions` VALUES (537, 1061, 2, 'Sotlunga');
INSERT INTO `lang_definitions` VALUES (538, 1062, 2, 'Afrikans amerikan');
INSERT INTO `lang_definitions` VALUES (539, 1063, 2, 'Cancer i urinblåsan');
INSERT INTO `lang_definitions` VALUES (540, 1064, 2, 'Infektioner i urinblåsan');
INSERT INTO `lang_definitions` VALUES (541, 1066, 2, 'Blankt formulär');
INSERT INTO `lang_definitions` VALUES (542, 1067, 2, 'Problem med blödning');
INSERT INTO `lang_definitions` VALUES (543, 1068, 2, 'Blinda punkter');
INSERT INTO `lang_definitions` VALUES (544, 1070, 2, 'Svullnad');
INSERT INTO `lang_definitions` VALUES (545, 1072, 2, 'Blockerade');
INSERT INTO `lang_definitions` VALUES (546, 1073, 2, 'Blod');
INSERT INTO `lang_definitions` VALUES (547, 1074, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (548, 1075, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (549, 1076, 2, 'Näsblod');
INSERT INTO `lang_definitions` VALUES (550, 1077, 2, 'Blått kors blå sköld');
INSERT INTO `lang_definitions` VALUES (551, 1079, 2, 'Blå linjerna i denna rapport är informativa. Svarta linjer visar tidigare information. Gröna linjerna visar förändringar som tillämpats framgångsrikt. Röda linjer visar fel eller förändringar som inte har genomförts, och dessa måste behandlas manuellt. För närvarande nekas fordringar och betalning reverseringar inte hanteras automatiskt och det kommer att visas i rött.');
INSERT INTO `lang_definitions` VALUES (552, 1080, 2, 'Dimsyn');
INSERT INTO `lang_definitions` VALUES (553, 1081, 2, 'BMI');
INSERT INTO `lang_definitions` VALUES (554, 1082, 2, 'BMI status');
INSERT INTO `lang_definitions` VALUES (555, 1084, 2, 'kroppsregion');
INSERT INTO `lang_definitions` VALUES (556, 1085, 2, 'Bkroppsdel');
INSERT INTO `lang_definitions` VALUES (557, 1086, 2, 'Kroppsdel, om tillämplig');
INSERT INTO `lang_definitions` VALUES (558, 1087, 2, 'Benömhet:');
INSERT INTO `lang_definitions` VALUES (559, 1088, 2, 'Benömhet: Malleoulus Medialis');
INSERT INTO `lang_definitions` VALUES (560, 1089, 2, 'Logisk');
INSERT INTO `lang_definitions` VALUES (561, 1093, 2, 'Båda öronen');
INSERT INTO `lang_definitions` VALUES (562, 1094, 2, 'båda öronen');
INSERT INTO `lang_definitions` VALUES (563, 1097, 2, 'Botten');
INSERT INTO `lang_definitions` VALUES (564, 1101, 2, 'RUTA 10 A. Anställningsrelaterad');
INSERT INTO `lang_definitions` VALUES (565, 1103, 2, 'RUTA 10 B. Bilolycka');
INSERT INTO `lang_definitions` VALUES (566, 1105, 2, 'RUTA 10 C. Övriga olyckor');
INSERT INTO `lang_definitions` VALUES (567, 1118, 2, 'BOX 15 Andere datum Qualifier');
INSERT INTO `lang_definitions` VALUES (568, 1119, 2, 'Ruta 15. Datum för samma eller liknande sjukdom (åååå-mm-dd)');
INSERT INTO `lang_definitions` VALUES (569, 1125, 2, 'FÄLT 16. Datum, oförmögen till arbete från (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (570, 1129, 2, 'FÄLT 16. Datum, oförmögen att arbeta tills (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (571, 1141, 2, 'FÄLT 18. Sjukhusvistelse datum, från (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (572, 1145, 2, 'FÄLT 18. Sjukhusvistelse till, datum (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (573, 1149, 2, 'FÄLT 20. Används externt lab?');
INSERT INTO `lang_definitions` VALUES (574, 1153, 2, 'Fält 22. Medicaid återinskickningskod (ICD-9)');
INSERT INTO `lang_definitions` VALUES (575, 1157, 2, 'Fält 23. Tidigare godkännande nr.');
INSERT INTO `lang_definitions` VALUES (576, 1158, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (577, 1159, 2, 'BT Diastoliskt');
INSERT INTO `lang_definitions` VALUES (578, 1160, 2, 'BT Systoliskt');
INSERT INTO `lang_definitions` VALUES (579, 1162, 2, 'BT Diastoliskt');
INSERT INTO `lang_definitions` VALUES (580, 1166, 2, 'BT Systoliskt');
INSERT INTO `lang_definitions` VALUES (581, 1168, 2, 'Brasiliansk portugisiska');
INSERT INTO `lang_definitions` VALUES (582, 1169, 2, 'Bröst');
INSERT INTO `lang_definitions` VALUES (583, 1170, 2, 'Bröst Biopsi');
INSERT INTO `lang_definitions` VALUES (584, 1171, 2, 'Bröst Avsluta');
INSERT INTO `lang_definitions` VALUES (585, 1172, 2, 'Bröstsjukdom');
INSERT INTO `lang_definitions` VALUES (586, 1173, 2, 'Bröstundersökning');
INSERT INTO `lang_definitions` VALUES (587, 1174, 2, 'Bröstvävnad');
INSERT INTO `lang_definitions` VALUES (588, 1176, 2, 'Andningsljud:');
INSERT INTO `lang_definitions` VALUES (589, 1179, 2, 'Brutna ben');
INSERT INTO `lang_definitions` VALUES (590, 1181, 2, 'Bronkit Formulär');
INSERT INTO `lang_definitions` VALUES (591, 1184, 2, 'Bläddra');
INSERT INTO `lang_definitions` VALUES (592, 1185, 2, 'Bläddra efter journal');
INSERT INTO `lang_definitions` VALUES (593, 1186, 2, 'Blåmärken / hematom');
INSERT INTO `lang_definitions` VALUES (594, 1189, 2, 'Utbuktningen Höger:');
INSERT INTO `lang_definitions` VALUES (595, 1191, 2, 'Sveda vid vattenkastning');
INSERT INTO `lang_definitions` VALUES (596, 1192, 2, 'Sveda vid vattenkastning');
INSERT INTO `lang_definitions` VALUES (597, 1195, 2, 'Upptagen');
INSERT INTO `lang_definitions` VALUES (598, 1196, 2, 'ännu ej behandlad');
INSERT INTO `lang_definitions` VALUES (599, 1197, 2, 'Skinka');
INSERT INTO `lang_definitions` VALUES (600, 1198, 2, 'Skinkan och SI-led');
INSERT INTO `lang_definitions` VALUES (601, 1199, 2, 'via');
INSERT INTO `lang_definitions` VALUES (602, 1200, 2, 'via');
INSERT INTO `lang_definitions` VALUES (603, 1206, 2, 'via munnen');
INSERT INTO `lang_definitions` VALUES (604, 1208, 2, 'Genom / Källa');
INSERT INTO `lang_definitions` VALUES (605, 1209, 2, 'Av:');
INSERT INTO `lang_definitions` VALUES (606, 1212, 2, 'Kopia');
INSERT INTO `lang_definitions` VALUES (607, 1214, 2, 'CA certifikat för att verifiera RFS 5425 TLS syslog server');
INSERT INTO `lang_definitions` VALUES (608, 1215, 2, 'Cache, livstid (i sekunder)');
INSERT INTO `lang_definitions` VALUES (609, 1216, 2, 'Cache template output?');
INSERT INTO `lang_definitions` VALUES (610, 1218, 2, 'Kaffe konsumtion');
INSERT INTO `lang_definitions` VALUES (611, 1219, 2, 'Kalender');
INSERT INTO `lang_definitions` VALUES (612, 1220, 2, 'Kalender sluttid');
INSERT INTO `lang_definitions` VALUES (613, 1221, 2, 'Kalender interval');
INSERT INTO `lang_definitions` VALUES (614, 1222, 2, 'Kalender skärm');
INSERT INTO `lang_definitions` VALUES (615, 1223, 2, 'Kalenderinställningar');
INSERT INTO `lang_definitions` VALUES (616, 1225, 2, 'Kalender starttid');
INSERT INTO `lang_definitions` VALUES (617, 1226, 2, 'Kalender UI');
INSERT INTO `lang_definitions` VALUES (618, 1227, 2, 'Kalendervy');
INSERT INTO `lang_definitions` VALUES (619, 1230, 2, 'Anrop till addForm() skriv här. <br>');
INSERT INTO `lang_definitions` VALUES (620, 1234, 2, 'Kalorier');
INSERT INTO `lang_definitions` VALUES (621, 1235, 2, 'Kambodjan');
INSERT INTO `lang_definitions` VALUES (622, 1236, 2, 'CAMOS');
INSERT INTO `lang_definitions` VALUES (623, 1242, 2, 'Avbryt');
INSERT INTO `lang_definitions` VALUES (624, 1244, 2, 'Förkasta ändringar');
INSERT INTO `lang_definitions` VALUES (625, 1245, 2, 'Avbruten');
INSERT INTO `lang_definitions` VALUES (626, 1247, 2, 'Cancer');
INSERT INTO `lang_definitions` VALUES (627, 1248, 2, 'Cancer screening: Colon cancer screening');
INSERT INTO `lang_definitions` VALUES (628, 1249, 2, 'Scancer screening: Mammografi');
INSERT INTO `lang_definitions` VALUES (629, 1250, 2, 'Cancer screening: Pap smear');
INSERT INTO `lang_definitions` VALUES (630, 1251, 2, 'Cancer screening: Prostata cancer');
INSERT INTO `lang_definitions` VALUES (631, 1252, 2, 'Det går ej att lägga till detta för att det redan existerar!');
INSERT INTO `lang_definitions` VALUES (632, 1253, 2, 'Kan inte lägga till / uppdatera den här posten eftersom duplikat redan finns!');
INSERT INTO `lang_definitions` VALUES (633, 1254, 2, 'Kan inte lagra. Kastat.');
INSERT INTO `lang_definitions` VALUES (634, 1255, 2, 'kan inte konverteras till JPEG. Kanske ImageMagick inte är installerad?');
INSERT INTO `lang_definitions` VALUES (635, 1256, 2, 'Kan inte tas bort. Utan åtgärd.');
INSERT INTO `lang_definitions` VALUES (636, 1257, 2, 'kan inte visas online eftersom denna filtyp inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (637, 1258, 2, 'kan inte visas online eftersom denna filtyp inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (638, 1259, 2, 'kan inte visas online eftersom den typen inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (639, 1261, 2, 'Det går inte att skapa');
INSERT INTO `lang_definitions` VALUES (640, 1266, 2, 'Kan ej hitta');
INSERT INTO `lang_definitions` VALUES (641, 1267, 2, 'Kan ej hitta filnamnet');
INSERT INTO `lang_definitions` VALUES (642, 1270, 2, 'Kan inte hitta patienten från SQL-ledgers kundnummer');
INSERT INTO `lang_definitions` VALUES (643, 1271, 2, 'Kan ej hitta postscript dokumenthänvisning i');
INSERT INTO `lang_definitions` VALUES (644, 1272, 2, 'Kan inte hitta vårdgivaren i SQL-ledger');
INSERT INTO `lang_definitions` VALUES (645, 1273, 2, 'Kan inte ändra betalning. Odebiterat belopp är negativt.');
INSERT INTO `lang_definitions` VALUES (646, 1275, 2, 'Går inte att öppna');
INSERT INTO `lang_definitions` VALUES (647, 1276, 2, 'Kan inte bokföra på försäkring. Betalningsansvarig är patienten.');
INSERT INTO `lang_definitions` VALUES (648, 1277, 2, 'Kan inte bokföra på patient. Betalningsansvarig är försäkring.');
INSERT INTO `lang_definitions` VALUES (649, 1278, 2, 'Kan inte bokföra betalning. Odebiterat belopp är negativt.');
INSERT INTO `lang_definitions` VALUES (650, 1279, 2, 'Kan ej läsa');
INSERT INTO `lang_definitions` VALUES (651, 1280, 2, 'Kan ej läsa i mappen');
INSERT INTO `lang_definitions` VALUES (652, 1281, 2, 'Kan inte uppdatera eftersom du inte redigerar en befintlig post!');
INSERT INTO `lang_definitions` VALUES (653, 1282, 2, 'Stor bokstav');
INSERT INTO `lang_definitions` VALUES (654, 1284, 2, 'kapsel');
INSERT INTO `lang_definitions` VALUES (655, 1285, 2, 'Kort');
INSERT INTO `lang_definitions` VALUES (656, 1294, 2, 'Hjärtkateterisering');
INSERT INTO `lang_definitions` VALUES (657, 1295, 2, 'Hjärteko');
INSERT INTO `lang_definitions` VALUES (658, 1296, 2, 'Kardiovaskulära');
INSERT INTO `lang_definitions` VALUES (659, 1308, 2, 'Brosk / menisk skada');
INSERT INTO `lang_definitions` VALUES (660, 1309, 2, 'Broskskada');
INSERT INTO `lang_definitions` VALUES (661, 1310, 2, 'Inga karotispulsar. Inga fotpulsar.');
INSERT INTO `lang_definitions` VALUES (662, 1312, 2, 'kontanter');
INSERT INTO `lang_definitions` VALUES (663, 1313, 2, 'Kontanter');
INSERT INTO `lang_definitions` VALUES (664, 1314, 2, 'Kontantbetalning');
INSERT INTO `lang_definitions` VALUES (665, 1315, 2, 'Kontantkvitton från vårdgivare');
INSERT INTO `lang_definitions` VALUES (666, 1318, 2, 'Kataraktkirurgi');
INSERT INTO `lang_definitions` VALUES (667, 1319, 2, 'Katarakt');
INSERT INTO `lang_definitions` VALUES (668, 1320, 2, 'Kategorier');
INSERT INTO `lang_definitions` VALUES (669, 1321, 2, 'Kategorier av');
INSERT INTO `lang_definitions` VALUES (670, 1322, 2, 'Kategori');
INSERT INTO `lang_definitions` VALUES (671, 1323, 2, 'kategori');
INSERT INTO `lang_definitions` VALUES (672, 1324, 2, 'Kategori');
INSERT INTO `lang_definitions` VALUES (673, 1328, 2, 'Kategori Detaljer');
INSERT INTO `lang_definitions` VALUES (674, 1329, 2, 'Kategori Gränser');
INSERT INTO `lang_definitions` VALUES (675, 1330, 2, 'Kategorinamn');
INSERT INTO `lang_definitions` VALUES (676, 1331, 2, 'Kategorinamn är tomt');
INSERT INTO `lang_definitions` VALUES (677, 1332, 2, 'Kategori/Titel');
INSERT INTO `lang_definitions` VALUES (678, 1333, 2, 'Kaukasisk');
INSERT INTO `lang_definitions` VALUES (679, 1334, 2, 'Kvitto på kontaktorsak att skriva för besök. Primär vårdgivar information');
INSERT INTO `lang_definitions` VALUES (680, 1356, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (681, 1357, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (682, 1359, 2, 'Mobiltelefonnummer');
INSERT INTO `lang_definitions` VALUES (683, 1360, 2, 'Central Certifiering');
INSERT INTO `lang_definitions` VALUES (684, 1362, 2, 'Central/sydamerikan');
INSERT INTO `lang_definitions` VALUES (685, 1363, 2, 'CA certifikats fil-mapp kan inte vara tom');
INSERT INTO `lang_definitions` VALUES (686, 1364, 2, 'CA nyckelfilsmapp kan inte vara tom');
INSERT INTO `lang_definitions` VALUES (687, 1365, 2, 'CA certifikat för att skicka till RFS 5425 TLS syslog server');
INSERT INTO `lang_definitions` VALUES (688, 1366, 2, 'Certifikat användare');
INSERT INTO `lang_definitions` VALUES (689, 1367, 2, 'Certifikat');
INSERT INTO `lang_definitions` VALUES (690, 1369, 2, 'ChampUS');
INSERT INTO `lang_definitions` VALUES (691, 1370, 2, 'ChampUSVA');
INSERT INTO `lang_definitions` VALUES (692, 1371, 2, 'ändra');
INSERT INTO `lang_definitions` VALUES (693, 1372, 2, 'Ändra');
INSERT INTO `lang_definitions` VALUES (694, 1373, 2, 'Ändra Aktivitet');
INSERT INTO `lang_definitions` VALUES (695, 1375, 2, 'Gick inte ändra. CouchDB fel?');
INSERT INTO `lang_definitions` VALUES (696, 1376, 2, 'Synpåverkan');
INSERT INTO `lang_definitions` VALUES (697, 1377, 2, 'Synpåverkan');
INSERT INTO `lang_definitions` VALUES (698, 1378, 2, 'Byta lösenord');
INSERT INTO `lang_definitions` VALUES (699, 1381, 2, 'Ändrad');
INSERT INTO `lang_definitions` VALUES (700, 1382, 2, 'Förändrad tarm');
INSERT INTO `lang_definitions` VALUES (701, 1383, 2, 'Byter patientidentitet för dokument');
INSERT INTO `lang_definitions` VALUES (702, 1388, 2, 'Karaktär');
INSERT INTO `lang_definitions` VALUES (703, 1389, 2, 'Tecken kvar');
INSERT INTO `lang_definitions` VALUES (704, 1390, 2, 'Avgift');
INSERT INTO `lang_definitions` VALUES (705, 1391, 2, 'Justering av avgift');
INSERT INTO `lang_definitions` VALUES (706, 1392, 2, 'Avgift kodad');
INSERT INTO `lang_definitions` VALUES (707, 1394, 2, 'Avgifter');
INSERT INTO `lang_definitions` VALUES (708, 1395, 2, 'Patientkort');
INSERT INTO `lang_definitions` VALUES (709, 1396, 2, 'Patientkort aktivitet');
INSERT INTO `lang_definitions` VALUES (710, 1397, 2, 'Patientkort Check-in/out Aktivitetsrapport?');
INSERT INTO `lang_definitions` VALUES (711, 1398, 2, 'Patientkort ID');
INSERT INTO `lang_definitions` VALUES (712, 1399, 2, 'Patientkort ID');
INSERT INTO `lang_definitions` VALUES (713, 1401, 2, 'Patientkort placering Aktivitet');
INSERT INTO `lang_definitions` VALUES (714, 1402, 2, 'Patientkort notering');
INSERT INTO `lang_definitions` VALUES (715, 1403, 2, 'Patientkort nr');
INSERT INTO `lang_definitions` VALUES (716, 1405, 2, 'Patientkort lagring placering');
INSERT INTO `lang_definitions` VALUES (717, 1406, 2, 'Patientkort spåra');
INSERT INTO `lang_definitions` VALUES (718, 1407, 2, 'Patientkort spåra');
INSERT INTO `lang_definitions` VALUES (719, 1408, 2, 'Patientkort utcheckning');
INSERT INTO `lang_definitions` VALUES (720, 1409, 2, 'Patientkort utcheckning');
INSERT INTO `lang_definitions` VALUES (721, 1413, 2, 'Controleer of u van plan bent om ansichtkaarten te verzenden via MedEx');
INSERT INTO `lang_definitions` VALUES (722, 1414, 2, 'Betalningsanvisning');
INSERT INTO `lang_definitions` VALUES (723, 1415, 2, 'Alla betalningsanvisningar');
INSERT INTO `lang_definitions` VALUES (724, 1417, 2, 'Betalningsanvisning belopp');
INSERT INTO `lang_definitions` VALUES (725, 1419, 2, 'Betalningsanvisning datum');
INSERT INTO `lang_definitions` VALUES (726, 1421, 2, 'Kontrollera skillnader i översättning med översättningstabellen');
INSERT INTO `lang_definitions` VALUES (727, 1427, 2, 'checka in till');
INSERT INTO `lang_definitions` VALUES (728, 1428, 2, 'Kontrollera indata');
INSERT INTO `lang_definitions` VALUES (729, 1430, 2, 'Kontrollera labdata');
INSERT INTO `lang_definitions` VALUES (730, 1431, 2, 'Markering betyder påtittat');
INSERT INTO `lang_definitions` VALUES (731, 1432, 2, 'Betalningsanvisning nr');
INSERT INTO `lang_definitions` VALUES (732, 1433, 2, 'Betalningsanvisning nr');
INSERT INTO `lang_definitions` VALUES (733, 1436, 2, 'Betalningsanvisning betalning');
INSERT INTO `lang_definitions` VALUES (734, 1437, 2, 'Markera ifall filen är krypterad');
INSERT INTO `lang_definitions` VALUES (735, 1441, 2, 'Markera om vårdgivare ska se alla bokade besök som standard och ej enbart deras egna');
INSERT INTO `lang_definitions` VALUES (736, 1443, 2, 'Markera för att skapa \'Problem\' utifrån denna diagnos');
INSERT INTO `lang_definitions` VALUES (737, 1445, 2, 'Check / EOB Datum:');
INSERT INTO `lang_definitions` VALUES (738, 1447, 2, 'Check / EOB Nr:');
INSERT INTO `lang_definitions` VALUES (739, 1448, 2, 'Check / Ref Nr');
INSERT INTO `lang_definitions` VALUES (740, 1449, 2, 'Check / Referensnummer');
INSERT INTO `lang_definitions` VALUES (741, 1450, 2, 'Markeringsrutor lista');
INSERT INTO `lang_definitions` VALUES (742, 1451, 2, 'Markeringsrutor lista');
INSERT INTO `lang_definitions` VALUES (743, 1452, 2, 'Markeringsruta m text');
INSERT INTO `lang_definitions` VALUES (744, 1453, 2, 'Markeringsruta m text');
INSERT INTO `lang_definitions` VALUES (745, 1457, 2, 'Markerade fält = ja, tom = nej');
INSERT INTO `lang_definitions` VALUES (746, 1459, 2, 'Markerade fält = ja, tom = nej');
INSERT INTO `lang_definitions` VALUES (747, 1468, 2, 'Kassa');
INSERT INTO `lang_definitions` VALUES (748, 1469, 2, 'Kontrollsumma');
INSERT INTO `lang_definitions` VALUES (749, 1470, 2, 'Bröstkorg');
INSERT INTO `lang_definitions` VALUES (750, 1471, 2, 'Chest CTAB');
INSERT INTO `lang_definitions` VALUES (751, 1472, 2, 'Bröstsmärtor');
INSERT INTO `lang_definitions` VALUES (752, 1473, 2, 'Bröstsmärta:');
INSERT INTO `lang_definitions` VALUES (753, 1474, 2, 'Bröstsmärtor');
INSERT INTO `lang_definitions` VALUES (754, 1476, 2, 'Byt');
INSERT INTO `lang_definitions` VALUES (755, 1478, 2, 'Huvudproblem');
INSERT INTO `lang_definitions` VALUES (756, 1481, 2, 'Barn');
INSERT INTO `lang_definitions` VALUES (757, 1483, 2, 'Barnvaccinations status');
INSERT INTO `lang_definitions` VALUES (758, 1484, 2, 'Frossbrytningar');
INSERT INTO `lang_definitions` VALUES (759, 1485, 2, 'Kinesiska');
INSERT INTO `lang_definitions` VALUES (760, 1486, 2, 'Kinesiska (Förenklad)');
INSERT INTO `lang_definitions` VALUES (761, 1487, 2, 'Kinesiska (traditionell)');
INSERT INTO `lang_definitions` VALUES (762, 1489, 2, 'Val');
INSERT INTO `lang_definitions` VALUES (763, 1490, 2, 'Kolecystektomi');
INSERT INTO `lang_definitions` VALUES (764, 1492, 2, 'Kolecystektomi');
INSERT INTO `lang_definitions` VALUES (765, 1493, 2, 'Välj');
INSERT INTO `lang_definitions` VALUES (766, 1496, 2, 'Välj ett avsnitt och klicka på ett objekt i den ;i den andra sektionen visas relaterade objekt. Klicka på avsnitten om du vill lägga till och ta bort relationer.');
INSERT INTO `lang_definitions` VALUES (767, 1497, 2, 'Välj kriteria');
INSERT INTO `lang_definitions` VALUES (768, 1501, 2, 'Välj fil');
INSERT INTO `lang_definitions` VALUES (769, 1502, 2, 'Välj från lista');
INSERT INTO `lang_definitions` VALUES (770, 1504, 2, 'Välj lista');
INSERT INTO `lang_definitions` VALUES (771, 1510, 2, 'Välj utskriftsformat för besöksrapport');
INSERT INTO `lang_definitions` VALUES (772, 1514, 2, 'Kronisk bronkit');
INSERT INTO `lang_definitions` VALUES (773, 1515, 2, 'Kronisk ledvärk');
INSERT INTO `lang_definitions` VALUES (774, 1516, 2, 'Kroniska njurbesvär');
INSERT INTO `lang_definitions` VALUES (775, 1519, 2, 'Kronisk synovit / utgjutning / ledvärk / gikt');
INSERT INTO `lang_definitions` VALUES (776, 1521, 2, 'Kronisk / Återkommande');
INSERT INTO `lang_definitions` VALUES (777, 1524, 2, 'Levercirros');
INSERT INTO `lang_definitions` VALUES (778, 1525, 2, 'Levercirros');
INSERT INTO `lang_definitions` VALUES (779, 1526, 2, 'Stad');
INSERT INTO `lang_definitions` VALUES (780, 1527, 2, 'Stadsnamn');
INSERT INTO `lang_definitions` VALUES (781, 1528, 2, 'Stad, stat');
INSERT INTO `lang_definitions` VALUES (782, 1529, 2, 'Stad, stat postnummer');
INSERT INTO `lang_definitions` VALUES (783, 1531, 2, 'Stad / stat');
INSERT INTO `lang_definitions` VALUES (784, 1532, 2, 'Begär');
INSERT INTO `lang_definitions` VALUES (785, 1533, 2, 'Begär');
INSERT INTO `lang_definitions` VALUES (786, 1535, 2, 'Begäran status');
INSERT INTO `lang_definitions` VALUES (787, 1537, 2, 'Begäran typ');
INSERT INTO `lang_definitions` VALUES (788, 1538, 2, 'Begäran skapade fil');
INSERT INTO `lang_definitions` VALUES (789, 1539, 2, 'Begäran skapade fil');
INSERT INTO `lang_definitions` VALUES (790, 1540, 2, 'Begäran');
INSERT INTO `lang_definitions` VALUES (791, 1541, 2, 'Klassificering');
INSERT INTO `lang_definitions` VALUES (792, 1542, 2, 'Rensa');
INSERT INTO `lang_definitions` VALUES (793, 1545, 2, 'RENSA AKTIV PATIENT');
INSERT INTO `lang_definitions` VALUES (794, 1547, 2, 'Rensa allt');
INSERT INTO `lang_definitions` VALUES (795, 1550, 2, 'Rensa HL7 data');
INSERT INTO `lang_definitions` VALUES (796, 1551, 2, 'Rensa justering');
INSERT INTO `lang_definitions` VALUES (797, 1554, 2, 'Rensa Smarty Cache');
INSERT INTO `lang_definitions` VALUES (798, 1556, 2, 'CLIA Antal');
INSERT INTO `lang_definitions` VALUES (799, 1557, 2, 'Klicka');
INSERT INTO `lang_definitions` VALUES (800, 1558, 2, 'Klicka \'export\' för att exportera din kategori, underkategori, enhet eller innehållsdata till en textfil. Någon likhet mellan denna textfil och en XML-fil är enbart en tillfällighet. Start och sluttaggar måste vara på samma rad, måste vara med små bokstäver och utan mellanrum. För att importera, bläddra efter filen, klicka på \'import\'. Om data är helt annorlunda kommer det läggas till existerande data. Om det finns likvärdiga enhetsnamn kommer de gamla att behållas och de nya läggas till med en siffra i slutet av namnet.');
INSERT INTO `lang_definitions` VALUES (801, 1561, 2, 'Klicka på en plats på bilden för att lägga till notering. Klicka igen för att ta bort den.');
INSERT INTO `lang_definitions` VALUES (802, 1565, 2, 'Klicka ”Download Certificate” för att ladda ner certifikatet i filen ssl.zip');
INSERT INTO `lang_definitions` VALUES (803, 1566, 2, 'Klicka för mer');
INSERT INTO `lang_definitions` VALUES (804, 1567, 2, 'Klicka för mer detaljer');
INSERT INTO `lang_definitions` VALUES (805, 1568, 2, 'Klicka för att beställa summering');
INSERT INTO `lang_definitions` VALUES (806, 1569, 2, 'Klicka för resultat');
INSERT INTO `lang_definitions` VALUES (807, 1571, 2, 'Klicka här');
INSERT INTO `lang_definitions` VALUES (808, 1572, 2, 'Klicka här för att lägga till patient');
INSERT INTO `lang_definitions` VALUES (809, 1573, 2, 'Klicka här för att lägga till ny skada, byta status och ändra dagliga aktiviteter');
INSERT INTO `lang_definitions` VALUES (810, 1575, 2, 'Klicka här för att välja ett datum');
INSERT INTO `lang_definitions` VALUES (811, 1576, 2, 'Klicka här för att välja datum och klockslag');
INSERT INTO `lang_definitions` VALUES (812, 1577, 2, 'Klicka här för att välja startdatum');
INSERT INTO `lang_definitions` VALUES (813, 1597, 2, 'Klicka här för att söka');
INSERT INTO `lang_definitions` VALUES (814, 1599, 2, 'Klicka här för att uppdatera prioritet, kategori och smeknamn inställningar');
INSERT INTO `lang_definitions` VALUES (815, 1601, 2, 'Klicka här, för att se alla.');
INSERT INTO `lang_definitions` VALUES (816, 1602, 2, 'Klicka här för att se och rita');
INSERT INTO `lang_definitions` VALUES (817, 1604, 2, 'Klicka här för att se och rita all vitalparametrar');
INSERT INTO `lang_definitions` VALUES (818, 1605, 2, 'Klicka här för att se patient detaljer');
INSERT INTO `lang_definitions` VALUES (819, 1606, 2, 'Klicka här för att se alla');
INSERT INTO `lang_definitions` VALUES (820, 1607, 2, 'Klicka här för att se/ändra mer detaljer');
INSERT INTO `lang_definitions` VALUES (821, 1609, 2, 'Klicka ”install” knappen för att installera databas utgåva sedan följande datum');
INSERT INTO `lang_definitions` VALUES (822, 1615, 2, 'Klicka någonstans på tid för att öka');
INSERT INTO `lang_definitions` VALUES (823, 1636, 2, 'Klicka på patientnamn för att öppna patientfilen');
INSERT INTO `lang_definitions` VALUES (824, 1638, 2, 'Klicka ”uppdatera” för att se alla resultat eller var vänlig ange sökkriterier ovan för att se specifika resultat');
INSERT INTO `lang_definitions` VALUES (825, 1662, 2, 'Klicka för att lägga till diagnos');
INSERT INTO `lang_definitions` VALUES (826, 1664, 2, 'Lklicka för att lägga till komponent');
INSERT INTO `lang_definitions` VALUES (827, 1665, 2, 'Klicka för att lägga till konsultation');
INSERT INTO `lang_definitions` VALUES (828, 1670, 2, 'Klicka för att ladda ner');
INSERT INTO `lang_definitions` VALUES (829, 1671, 2, 'Klicka för att ändra');
INSERT INTO `lang_definitions` VALUES (830, 1672, 2, 'Klicka för att ändra beskrivning');
INSERT INTO `lang_definitions` VALUES (831, 1673, 2, 'Klicka för att ändra denna händelse');
INSERT INTO `lang_definitions` VALUES (832, 1675, 2, 'Klicka för att skapa rapporten');
INSERT INTO `lang_definitions` VALUES (833, 1685, 2, 'Klicka för att skriva ut');
INSERT INTO `lang_definitions` VALUES (834, 1686, 2, 'Klicka för att lägga till/ta emot ny lot');
INSERT INTO `lang_definitions` VALUES (835, 1689, 2, 'Klicka för att välja');
INSERT INTO `lang_definitions` VALUES (836, 1690, 2, 'Klicka för att välja');
INSERT INTO `lang_definitions` VALUES (837, 1692, 2, 'Klicka för att välja en industristandard kod för denna åtgärd');
INSERT INTO `lang_definitions` VALUES (838, 1695, 2, 'Klicka för att välja valbar åtgärdskod');
INSERT INTO `lang_definitions` VALUES (839, 1697, 2, 'Klicka för att välja eller byta CVX kod');
INSERT INTO `lang_definitions` VALUES (840, 1698, 2, 'Klicka för att välja eller ändra diagnoser');
INSERT INTO `lang_definitions` VALUES (841, 1699, 2, 'Klicka för att välja eller ändra tjänst kod');
INSERT INTO `lang_definitions` VALUES (842, 1700, 2, 'Klicka för att välja patient');
INSERT INTO `lang_definitions` VALUES (843, 1701, 2, 'Klicka för att välja tillhörande kod');
INSERT INTO `lang_definitions` VALUES (844, 1702, 2, 'Klicka för att välja tjänster att utföra om resultatet är avvikande');
INSERT INTO `lang_definitions` VALUES (845, 1705, 2, 'Klicka för att välja önskad åtgärd');
INSERT INTO `lang_definitions` VALUES (846, 1712, 2, 'Klicka för att sortera');
INSERT INTO `lang_definitions` VALUES (847, 1713, 2, 'Klicka för att visa eller redigera');
INSERT INTO `lang_definitions` VALUES (848, 1715, 2, 'Klicka för att visa eller redigera');
INSERT INTO `lang_definitions` VALUES (849, 1716, 2, 'Klicka för visa/redigera');
INSERT INTO `lang_definitions` VALUES (850, 1718, 2, 'Klicka Uppdatera knappen för att uppdatera databasutgåvan från följande datum');
INSERT INTO `lang_definitions` VALUES (851, 1720, 2, 'Klicka på:');
INSERT INTO `lang_definitions` VALUES (852, 1742, 2, 'Kund certifikat utgångsdatum');
INSERT INTO `lang_definitions` VALUES (853, 1743, 2, 'kund certifikat giltighetsperiod');
INSERT INTO `lang_definitions` VALUES (854, 1744, 2, 'Kundcertifikats giltighet ska vara ett giltigt nummer');
INSERT INTO `lang_definitions` VALUES (855, 1745, 2, 'kund kopia');
INSERT INTO `lang_definitions` VALUES (856, 1747, 2, 'Sammanfattning av kundens sjukdomshistoria');
INSERT INTO `lang_definitions` VALUES (857, 1748, 2, 'Kund namn');
INSERT INTO `lang_definitions` VALUES (858, 1749, 2, 'Kund nummer');
INSERT INTO `lang_definitions` VALUES (859, 1750, 2, 'Kundprofil - Ny kund');
INSERT INTO `lang_definitions` VALUES (860, 1751, 2, 'Kundprofil - Unika kunder');
INSERT INTO `lang_definitions` VALUES (861, 1752, 2, 'Kunder');
INSERT INTO `lang_definitions` VALUES (862, 1753, 2, 'Klinik');
INSERT INTO `lang_definitions` VALUES (863, 1754, 2, 'Klinik kopiera');
INSERT INTO `lang_definitions` VALUES (864, 1755, 2, 'Kliniken Daily Record');
INSERT INTO `lang_definitions` VALUES (865, 1756, 2, 'Klinik ID');
INSERT INTO `lang_definitions` VALUES (866, 1757, 2, 'Klinisk');
INSERT INTO `lang_definitions` VALUES (867, 1758, 2, 'Kliniskt beslutsstöd Påminnelsehantering');
INSERT INTO `lang_definitions` VALUES (868, 1760, 2, 'Anamnes');
INSERT INTO `lang_definitions` VALUES (869, 1763, 2, 'Klinisk planering');
INSERT INTO `lang_definitions` VALUES (870, 1764, 2, 'Kliniska kvalitetskrav');
INSERT INTO `lang_definitions` VALUES (871, 1767, 2, 'Klinikens påminnelser');
INSERT INTO `lang_definitions` VALUES (872, 1771, 2, 'Klinikens rapporter');
INSERT INTO `lang_definitions` VALUES (873, 1772, 2, 'Kliniskt beslutsstöd Kategorier');
INSERT INTO `lang_definitions` VALUES (874, 1773, 2, 'Kliniskt beslutsstöd Enheter');
INSERT INTO `lang_definitions` VALUES (875, 1774, 2, 'Kliniskt beslutsstöd Urvalsfunktioner');
INSERT INTO `lang_definitions` VALUES (876, 1775, 2, 'Kliniskt beslutsstöd Mål metoder');
INSERT INTO `lang_definitions` VALUES (877, 1776, 2, 'Kliniskt beslutsstöd Enheter');
INSERT INTO `lang_definitions` VALUES (878, 1777, 2, 'Kliniskt beslutsstöd ålders intervaller');
INSERT INTO `lang_definitions` VALUES (879, 1778, 2, 'Kliniskt beslutsstöd jämförelser');
INSERT INTO `lang_definitions` VALUES (880, 1779, 2, 'Kliniskt beslutsstöd Typer av besök');
INSERT INTO `lang_definitions` VALUES (881, 1780, 2, 'Kliniskt beslutsstöd Påminnelser giltighet inställningar');
INSERT INTO `lang_definitions` VALUES (882, 1781, 2, 'Kliniskt beslutsstöd Påminnelser inaktiveringsinställningar');
INSERT INTO `lang_definitions` VALUES (883, 1782, 2, 'Kliniskt beslutsstöd påminnelser intervaller');
INSERT INTO `lang_definitions` VALUES (884, 1783, 2, 'Kliniskt beslutsstöd påminnelser metoder');
INSERT INTO `lang_definitions` VALUES (885, 1784, 2, 'Kliniskt beslutsstöd Mål intervaller');
INSERT INTO `lang_definitions` VALUES (886, 1785, 2, 'Kliniska mål');
INSERT INTO `lang_definitions` VALUES (887, 1786, 2, 'Kliniskt begrepp');
INSERT INTO `lang_definitions` VALUES (888, 1787, 2, 'Kliniska begrepp koder');
INSERT INTO `lang_definitions` VALUES (889, 1789, 2, 'Kliniskt verksamma');
INSERT INTO `lang_definitions` VALUES (890, 1790, 2, 'Kopiera');
INSERT INTO `lang_definitions` VALUES (891, 1791, 2, 'Kopiera tidigare besök');
INSERT INTO `lang_definitions` VALUES (892, 1792, 2, 'Stäng');
INSERT INTO `lang_definitions` VALUES (893, 1799, 2, 'Stäng fönstret');
INSERT INTO `lang_definitions` VALUES (894, 1801, 2, 'Stängt');
INSERT INTO `lang_definitions` VALUES (895, 1802, 2, 'cm');
INSERT INTO `lang_definitions` VALUES (896, 1804, 2, 'CMS 1500 marginal');
INSERT INTO `lang_definitions` VALUES (897, 1813, 2, 'CMS-id');
INSERT INTO `lang_definitions` VALUES (898, 1827, 2, 'CN2-12 intakta');
INSERT INTO `lang_definitions` VALUES (899, 1830, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (900, 1831, 2, 'Medbetalare Betalning');
INSERT INTO `lang_definitions` VALUES (901, 1833, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (902, 1835, 2, 'Kod');
INSERT INTO `lang_definitions` VALUES (903, 1836, 2, 'kod');
INSERT INTO `lang_definitions` VALUES (904, 1837, 2, 'Kodsökare');
INSERT INTO `lang_definitions` VALUES (905, 1838, 2, 'Kod måste vara två bokstäver (små bokstäver)');
INSERT INTO `lang_definitions` VALUES (906, 1839, 2, 'Kod eller symbol för att ange valuta');
INSERT INTO `lang_definitions` VALUES (907, 1841, 2, 'Kod text');
INSERT INTO `lang_definitions` VALUES (908, 1843, 2, 'Kod typer');
INSERT INTO `lang_definitions` VALUES (909, 1846, 2, 'Kod typer');
INSERT INTO `lang_definitions` VALUES (910, 1847, 2, 'Koder');
INSERT INTO `lang_definitions` VALUES (911, 1848, 2, 'Kodad');
INSERT INTO `lang_definitions` VALUES (912, 1849, 2, 'Koder');
INSERT INTO `lang_definitions` VALUES (913, 1851, 2, 'Kodning');
INSERT INTO `lang_definitions` VALUES (914, 1853, 2, 'Kodning – alla besök (skriv, med valbara alternativ)');
INSERT INTO `lang_definitions` VALUES (915, 1855, 2, 'Kodning – mina besök (skriv, med valbara alternativ)');
INSERT INTO `lang_definitions` VALUES (916, 1860, 2, 'Kodning ej godkänd');
INSERT INTO `lang_definitions` VALUES (917, 1861, 2, 'Kaffe');
INSERT INTO `lang_definitions` VALUES (918, 1864, 2, 'Med-försäkring');
INSERT INTO `lang_definitions` VALUES (919, 1865, 2, 'Förf.saml w / o');
INSERT INTO `lang_definitions` VALUES (920, 1867, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (921, 1868, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (922, 1869, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (923, 1870, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (924, 1871, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (925, 1875, 2, 'samlings datum');
INSERT INTO `lang_definitions` VALUES (926, 1877, 2, 'Samlingar');
INSERT INTO `lang_definitions` VALUES (927, 1878, 2, 'Samlingsrapport');
INSERT INTO `lang_definitions` VALUES (928, 1879, 2, 'Koloncancer');
INSERT INTO `lang_definitions` VALUES (929, 1880, 2, 'Koloncancer screening');
INSERT INTO `lang_definitions` VALUES (930, 1881, 2, 'Koloncancer Kirurgi');
INSERT INTO `lang_definitions` VALUES (931, 1882, 2, 'Koloskopi');
INSERT INTO `lang_definitions` VALUES (932, 1883, 2, 'Koloskopi');
INSERT INTO `lang_definitions` VALUES (933, 1884, 2, 'Färg');
INSERT INTO `lang_definitions` VALUES (934, 1890, 2, 'Färg förkortning');
INSERT INTO `lang_definitions` VALUES (935, 1891, 2, 'Kolumn');
INSERT INTO `lang_definitions` VALUES (936, 1892, 2, 'Kolumner');
INSERT INTO `lang_definitions` VALUES (937, 1894, 2, 'Slå ihop grupper');
INSERT INTO `lang_definitions` VALUES (938, 1895, 2, 'Komma');
INSERT INTO `lang_definitions` VALUES (939, 1896, 2, 'Kommentar');
INSERT INTO `lang_definitions` VALUES (940, 1897, 2, 'Kommentarer');
INSERT INTO `lang_definitions` VALUES (941, 1898, 2, 'Kommentarer om detta resultat eller rekomendation');
INSERT INTO `lang_definitions` VALUES (942, 1899, 2, 'Commercial Insurance Co');
INSERT INTO `lang_definitions` VALUES (943, 1900, 2, 'Godkänn Ändringar');
INSERT INTO `lang_definitions` VALUES (944, 1904, 2, 'Förbindelser');
INSERT INTO `lang_definitions` VALUES (945, 1907, 2, 'Företag');
INSERT INTO `lang_definitions` VALUES (946, 1908, 2, 'Företag namn');
INSERT INTO `lang_definitions` VALUES (947, 1909, 2, 'Komplett');
INSERT INTO `lang_definitions` VALUES (948, 1914, 2, 'Klar?');
INSERT INTO `lang_definitions` VALUES (949, 1915, 2, 'Remover por completo la capacidad de mostrar el Tablero de Flujo de Pacientes');
INSERT INTO `lang_definitions` VALUES (950, 1916, 2, 'Estado de finalización');
INSERT INTO `lang_definitions` VALUES (951, 1917, 2, 'Komplikationer orsakade av vårdgivare');
INSERT INTO `lang_definitions` VALUES (952, 1918, 2, 'Abortkomplikationer');
INSERT INTO `lang_definitions` VALUES (953, 1919, 2, 'Enheter');
INSERT INTO `lang_definitions` VALUES (954, 1924, 2, 'Datorstödd Medicinskt beställningssystem');
INSERT INTO `lang_definitions` VALUES (955, 1925, 2, 'Slutsatser');
INSERT INTO `lang_definitions` VALUES (956, 1930, 2, 'Inställningar');
INSERT INTO `lang_definitions` VALUES (957, 1931, 2, 'Inställningar import/export');
INSERT INTO `lang_definitions` VALUES (958, 1933, 2, 'Konfigurera Apache och open EMR för att använda klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (959, 1934, 2, 'Konfigurera Apache att använda Klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (960, 1935, 2, 'Konfigurera apache för att använda HTTPS');
INSERT INTO `lang_definitions` VALUES (961, 1936, 2, 'Konfigurera openEMR för att använda Klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (962, 1945, 2, 'Bekräfta Skapa ny patient');
INSERT INTO `lang_definitions` VALUES (963, 1947, 2, 'Bekräfta Nytt lösenord');
INSERT INTO `lang_definitions` VALUES (964, 1948, 2, 'Bekräfta Betalning');
INSERT INTO `lang_definitions` VALUES (965, 1956, 2, 'Medfödd');
INSERT INTO `lang_definitions` VALUES (966, 1958, 2, 'Konjunktiva, pupiller');
INSERT INTO `lang_definitions` VALUES (967, 1961, 2, 'Sammanbindningar');
INSERT INTO `lang_definitions` VALUES (968, 1962, 2, 'Konstant');
INSERT INTO `lang_definitions` VALUES (969, 1963, 2, 'Konstant namn');
INSERT INTO `lang_definitions` VALUES (970, 1964, 2, 'Konstantnamn är tomt');
INSERT INTO `lang_definitions` VALUES (971, 1965, 2, 'Konstanter');
INSERT INTO `lang_definitions` VALUES (972, 1966, 2, 'Förstoppning');
INSERT INTO `lang_definitions` VALUES (973, 1967, 2, 'Konstitutionella');
INSERT INTO `lang_definitions` VALUES (974, 1970, 2, 'Konsultation, kortfattad beskrivning');
INSERT INTO `lang_definitions` VALUES (975, 1972, 2, 'Kontakt');
INSERT INTO `lang_definitions` VALUES (976, 1973, 2, 'E-postadress');
INSERT INTO `lang_definitions` VALUES (977, 1974, 2, 'Epostadresser');
INSERT INTO `lang_definitions` VALUES (978, 1975, 2, 'Kontakta EMR direkt för att prenumerera på phiMail Direct meddelande service');
INSERT INTO `lang_definitions` VALUES (979, 1976, 2, 'Kontaktinformation');
INSERT INTO `lang_definitions` VALUES (980, 1979, 2, 'Kontaktlinser');
INSERT INTO `lang_definitions` VALUES (981, 1980, 2, 'Contact Medical Information Integration, LLC at http://mi-squared.com for Lab Exchange Service.');
INSERT INTO `lang_definitions` VALUES (982, 1981, 2, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing the eRx service');
INSERT INTO `lang_definitions` VALUES (983, 1984, 2, 'Kontaktnamn');
INSERT INTO `lang_definitions` VALUES (984, 1987, 2, 'Kontaktperson');
INSERT INTO `lang_definitions` VALUES (985, 1989, 2, 'Kontakttelefonnummer');
INSERT INTO `lang_definitions` VALUES (986, 1991, 2, 'Contact ZMG, LLC (zmghealth@gmail.com) for subscribing the eRx service');
INSERT INTO `lang_definitions` VALUES (987, 1993, 2, 'Innehåller minst tre av följande fyra enheter:');
INSERT INTO `lang_definitions` VALUES (988, 1994, 2, 'Behållare Gruppnamn');
INSERT INTO `lang_definitions` VALUES (989, 1995, 2, 'Innehåll');
INSERT INTO `lang_definitions` VALUES (990, 1996, 2, 'innehåll');
INSERT INTO `lang_definitions` VALUES (991, 1998, 2, 'Sammanhang');
INSERT INTO `lang_definitions` VALUES (992, 1999, 2, 'Sammanhangsnamn kan inte vara tomt');
INSERT INTO `lang_definitions` VALUES (993, 2000, 2, 'Fortsätt');
INSERT INTO `lang_definitions` VALUES (994, 2002, 2, 'Vårdplanerings dokument');
INSERT INTO `lang_definitions` VALUES (995, 2005, 2, 'Vårdplanering');
INSERT INTO `lang_definitions` VALUES (996, 2006, 2, 'kontraindikationer');
INSERT INTO `lang_definitions` VALUES (997, 2007, 2, 'Preventivmedel');
INSERT INTO `lang_definitions` VALUES (998, 2008, 2, 'Preventivmedelsproblematik');
INSERT INTO `lang_definitions` VALUES (999, 2009, 2, 'Preventivmedelsproblematik (specificera)');
INSERT INTO `lang_definitions` VALUES (1000, 2010, 2, 'Preventivmedel Metod');
INSERT INTO `lang_definitions` VALUES (1001, 2011, 2, 'Preventivmedel');
INSERT INTO `lang_definitions` VALUES (1002, 2012, 2, 'Preventivmedel, tjänster som tidigare startats');
INSERT INTO `lang_definitions` VALUES (1003, 2013, 2, 'Preventivmedel start');
INSERT INTO `lang_definitions` VALUES (1004, 2018, 2, 'Kontrollnummer');
INSERT INTO `lang_definitions` VALUES (1005, 2019, 2, 'Kontrollnummer');
INSERT INTO `lang_definitions` VALUES (1006, 2028, 2, 'medbetalare');
INSERT INTO `lang_definitions` VALUES (1007, 2029, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1008, 2030, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1009, 2031, 2, 'medbetalare nekar');
INSERT INTO `lang_definitions` VALUES (1010, 2033, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1011, 2034, 2, 'COPD');
INSERT INTO `lang_definitions` VALUES (1012, 2035, 2, 'Kopiera Sidor till Patientdiagram');
INSERT INTO `lang_definitions` VALUES (1013, 2037, 2, 'Kopiera Värderingar');
INSERT INTO `lang_definitions` VALUES (1014, 2038, 2, 'Kopiera databasfilen. Detta tar en stund...');
INSERT INTO `lang_definitions` VALUES (1015, 2039, 2, 'Upphovsrättsskydd');
INSERT INTO `lang_definitions` VALUES (1016, 2044, 2, 'Coronary Artery Bypass');
INSERT INTO `lang_definitions` VALUES (1017, 2045, 2, 'Coronary Artery Bypass Graft (CABG)');
INSERT INTO `lang_definitions` VALUES (1018, 2046, 2, 'Rättad');
INSERT INTO `lang_definitions` VALUES (1019, 2048, 2, 'CouchDB');
INSERT INTO `lang_definitions` VALUES (1020, 2049, 2, 'Kunde inte ansluta till CouchDB');
INSERT INTO `lang_definitions` VALUES (1021, 2050, 2, 'CouchDB databas');
INSERT INTO `lang_definitions` VALUES (1022, 2051, 2, 'CouchDB databas namn');
INSERT INTO `lang_definitions` VALUES (1023, 2054, 2, 'CouchDB värd');
INSERT INTO `lang_definitions` VALUES (1024, 2055, 2, 'CouchDB värdnamn');
INSERT INTO `lang_definitions` VALUES (1025, 2056, 2, 'CouchDB log på');
INSERT INTO `lang_definitions` VALUES (1026, 2057, 2, 'CouchDB lösenord');
INSERT INTO `lang_definitions` VALUES (1027, 2058, 2, 'CouchDB port');
INSERT INTO `lang_definitions` VALUES (1028, 2059, 2, 'CouchDB port');
INSERT INTO `lang_definitions` VALUES (1029, 2061, 2, 'CouchDB användarnamn');
INSERT INTO `lang_definitions` VALUES (1030, 2062, 2, 'Hosta');
INSERT INTO `lang_definitions` VALUES (1031, 2063, 2, 'Hosta:');
INSERT INTO `lang_definitions` VALUES (1032, 2068, 2, 'Kunde ej läsa fil');
INSERT INTO `lang_definitions` VALUES (1033, 2070, 2, 'Kunde inte skicka e-post på grund av en server problem');
INSERT INTO `lang_definitions` VALUES (1034, 2072, 2, 'Kunde inte skicka e-post på grund av en server problem');
INSERT INTO `lang_definitions` VALUES (1035, 2073, 2, 'Kunde inte skapa backup');
INSERT INTO `lang_definitions` VALUES (1036, 2074, 2, 'Kunde inte ta bort mapp');
INSERT INTO `lang_definitions` VALUES (1037, 2075, 2, 'Kunde inte ta bort gammal backup fil');
INSERT INTO `lang_definitions` VALUES (1038, 2076, 2, 'Kunde inte ta bort gammal export fil');
INSERT INTO `lang_definitions` VALUES (1039, 2077, 2, 'Waran INR kontroll');
INSERT INTO `lang_definitions` VALUES (1040, 2078, 2, 'Couns av metod');
INSERT INTO `lang_definitions` VALUES (1041, 2079, 2, 'Rådgivning');
INSERT INTO `lang_definitions` VALUES (1042, 2080, 2, 'Rådgivning, Aktivitet');
INSERT INTO `lang_definitions` VALUES (1043, 2083, 2, 'svarsremiss, formulär');
INSERT INTO `lang_definitions` VALUES (1044, 2084, 2, 'Nation');
INSERT INTO `lang_definitions` VALUES (1045, 2085, 2, 'Land');
INSERT INTO `lang_definitions` VALUES (1046, 2087, 2, 'Typ av nationsdata');
INSERT INTO `lang_definitions` VALUES (1047, 2088, 2, 'Nationslista');
INSERT INTO `lang_definitions` VALUES (1048, 2089, 2, 'Nationslista');
INSERT INTO `lang_definitions` VALUES (1049, 2091, 2, 'Nationsnamn ska representeras av två bokstäver');
INSERT INTO `lang_definitions` VALUES (1050, 2092, 2, 'Landsting');
INSERT INTO `lang_definitions` VALUES (1051, 2094, 2, 'kupong');
INSERT INTO `lang_definitions` VALUES (1052, 2101, 2, 'CPT');
INSERT INTO `lang_definitions` VALUES (1053, 2102, 2, 'CPT Koder');
INSERT INTO `lang_definitions` VALUES (1054, 2103, 2, 'CPT Koder');
INSERT INTO `lang_definitions` VALUES (1055, 2104, 2, 'CPT4 Åtgärder/Tjänster');
INSERT INTO `lang_definitions` VALUES (1056, 2105, 2, 'CPTII Mått på utförande');
INSERT INTO `lang_definitions` VALUES (1057, 2106, 2, 'Kvalitetscertifikat (GCP)');
INSERT INTO `lang_definitions` VALUES (1058, 2108, 2, 'Sprickor:');
INSERT INTO `lang_definitions` VALUES (1059, 2111, 2, 'kräm');
INSERT INTO `lang_definitions` VALUES (1060, 2112, 2, 'Skapa klient certifikat SSL för varje användare eller dator');
INSERT INTO `lang_definitions` VALUES (1061, 2113, 2, 'Skapa klientcertifikat för antingen användare eller datornamn');
INSERT INTO `lang_definitions` VALUES (1062, 2124, 2, 'Skapa en händelse');
INSERT INTO `lang_definitions` VALUES (1063, 2128, 2, 'Skapa och ladda ner en fullständig backup');
INSERT INTO `lang_definitions` VALUES (1064, 2130, 2, 'Skapa beackup');
INSERT INTO `lang_definitions` VALUES (1065, 2131, 2, 'Skapa grupp');
INSERT INTO `lang_definitions` VALUES (1066, 2132, 2, 'Skapa kientcertifikat');
INSERT INTO `lang_definitions` VALUES (1067, 2133, 2, 'Skapa klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (1068, 2136, 2, 'Skapa kopia');
INSERT INTO `lang_definitions` VALUES (1069, 2138, 2, 'Skapa backup av händelselog');
INSERT INTO `lang_definitions` VALUES (1070, 2139, 2, 'Skapa ny aktivitet');
INSERT INTO `lang_definitions` VALUES (1071, 2141, 2, 'Skapa ny patient');
INSERT INTO `lang_definitions` VALUES (1072, 2144, 2, 'Skapa externa port rättigheter');
INSERT INTO `lang_definitions` VALUES (1073, 2146, 2, 'Skapa interna port rättigheter');
INSERT INTO `lang_definitions` VALUES (1074, 2148, 2, 'Skapa Patientanteckning');
INSERT INTO `lang_definitions` VALUES (1075, 2150, 2, 'Skapa SSL certifikat utgivare och server certifikat');
INSERT INTO `lang_definitions` VALUES (1076, 2151, 2, 'Skapa besök');
INSERT INTO `lang_definitions` VALUES (1077, 2152, 2, 'Skapad');
INSERT INTO `lang_definitions` VALUES (1078, 2160, 2, 'Skapa exportfil');
INSERT INTO `lang_definitions` VALUES (1079, 2162, 2, 'Skapande av fil på värden misslyckades');
INSERT INTO `lang_definitions` VALUES (1080, 2163, 2, 'Skapare');
INSERT INTO `lang_definitions` VALUES (1081, 2164, 2, 'kredit');
INSERT INTO `lang_definitions` VALUES (1082, 2165, 2, 'Kreditkort');
INSERT INTO `lang_definitions` VALUES (1083, 2167, 2, 'Kredit');
INSERT INTO `lang_definitions` VALUES (1084, 2169, 2, 'Kriterier');
INSERT INTO `lang_definitions` VALUES (1085, 2171, 2, 'Crohn\'s sjukdom');
INSERT INTO `lang_definitions` VALUES (1086, 2172, 2, 'Chrons sjukdom');
INSERT INTO `lang_definitions` VALUES (1087, 2175, 2, 'export av kommaseparerad lista');
INSERT INTO `lang_definitions` VALUES (1088, 2176, 2, 'Kommaseparerad fil');
INSERT INTO `lang_definitions` VALUES (1089, 2177, 2, 'Kommaseparerad tabell');
INSERT INTO `lang_definitions` VALUES (1090, 2182, 2, 'Kubikmillimeter');
INSERT INTO `lang_definitions` VALUES (1091, 2183, 2, 'Kuban');
INSERT INTO `lang_definitions` VALUES (1092, 2185, 2, 'Valuta decimaler');
INSERT INTO `lang_definitions` VALUES (1093, 2186, 2, 'Valuta decimaltecken');
INSERT INTO `lang_definitions` VALUES (1094, 2187, 2, 'Valutatecken');
INSERT INTO `lang_definitions` VALUES (1095, 2188, 2, 'Valuta tusenseparator');
INSERT INTO `lang_definitions` VALUES (1096, 2189, 2, 'Pågående');
INSERT INTO `lang_definitions` VALUES (1097, 2190, 2, 'Alkohol aktuellt');
INSERT INTO `lang_definitions` VALUES (1098, 2193, 2, 'Pågående konsultation');
INSERT INTO `lang_definitions` VALUES (1099, 2194, 2, 'Aktuella kriterier');
INSERT INTO `lang_definitions` VALUES (1100, 2196, 2, 'Markeringsfärg för aktuell dag');
INSERT INTO `lang_definitions` VALUES (1101, 2197, 2, 'Röker dagligen');
INSERT INTO `lang_definitions` VALUES (1102, 2199, 2, 'Nuvarande filnamn är ändrat till');
INSERT INTO `lang_definitions` VALUES (1103, 2201, 2, 'Använder hash');
INSERT INTO `lang_definitions` VALUES (1104, 2202, 2, 'Nuvarande lokalisation');
INSERT INTO `lang_definitions` VALUES (1105, 2204, 2, 'Aktuell medicinering');
INSERT INTO `lang_definitions` VALUES (1106, 2205, 2, 'Aktuellt lösenord');
INSERT INTO `lang_definitions` VALUES (1107, 2206, 2, 'Pågående patient');
INSERT INTO `lang_definitions` VALUES (1108, 2211, 2, 'Aktuella droger');
INSERT INTO `lang_definitions` VALUES (1109, 2213, 2, 'Tillfällighetsrökare');
INSERT INTO `lang_definitions` VALUES (1110, 2219, 2, 'För närvarande Aktiv');
INSERT INTO `lang_definitions` VALUES (1111, 2222, 2, 'Pågår');
INSERT INTO `lang_definitions` VALUES (1112, 2224, 2, 'Ingen aktuell klinik');
INSERT INTO `lang_definitions` VALUES (1113, 2226, 2, 'Cushing Syndrom');
INSERT INTO `lang_definitions` VALUES (1114, 2227, 2, 'Cushings syndrom');
INSERT INTO `lang_definitions` VALUES (1115, 2230, 2, 'Anpassad');
INSERT INTO `lang_definitions` VALUES (1116, 2237, 2, 'Anpassat input');
INSERT INTO `lang_definitions` VALUES (1117, 2241, 2, 'Anpassad tabell');
INSERT INTO `lang_definitions` VALUES (1118, 2248, 2, 'CVX kod');
INSERT INTO `lang_definitions` VALUES (1119, 2249, 2, 'CVX kod koppling');
INSERT INTO `lang_definitions` VALUES (1120, 2250, 2, 'CVX vaccination');
INSERT INTO `lang_definitions` VALUES (1121, 2258, 2, 'CYP');
INSERT INTO `lang_definitions` VALUES (1122, 2259, 2, 'CYP Factor');
INSERT INTO `lang_definitions` VALUES (1123, 2260, 2, 'CYP Rapport');
INSERT INTO `lang_definitions` VALUES (1124, 2261, 2, 'Tjeckisk');
INSERT INTO `lang_definitions` VALUES (1125, 2262, 2, 'D');
INSERT INTO `lang_definitions` VALUES (1126, 2263, 2, 'D & C');
INSERT INTO `lang_definitions` VALUES (1127, 2264, 2, 'D & E');
INSERT INTO `lang_definitions` VALUES (1128, 2266, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1129, 2267, 2, 'dagligen');
INSERT INTO `lang_definitions` VALUES (1130, 2268, 2, 'Daglig registrering');
INSERT INTO `lang_definitions` VALUES (1131, 2271, 2, 'dansk');
INSERT INTO `lang_definitions` VALUES (1132, 2275, 2, 'Liknande data finns redan i databasen, ändra koden och / eller beskrivning');
INSERT INTO `lang_definitions` VALUES (1133, 2276, 2, 'Liknande data finns redan i databasen, ändra koden och / eller beskrivning');
INSERT INTO `lang_definitions` VALUES (1134, 2277, 2, 'Data kolumner');
INSERT INTO `lang_definitions` VALUES (1135, 2280, 2, 'Data fel');
INSERT INTO `lang_definitions` VALUES (1136, 2285, 2, 'Datattyp');
INSERT INTO `lang_definitions` VALUES (1137, 2286, 2, 'Databas');
INSERT INTO `lang_definitions` VALUES (1138, 2287, 2, 'Databas är inte installerad');
INSERT INTO `lang_definitions` VALUES (1139, 2289, 2, 'databas revision');
INSERT INTO `lang_definitions` VALUES (1140, 2290, 2, 'Databasrapportering');
INSERT INTO `lang_definitions` VALUES (1141, 2292, 2, 'Uppdatering av databas avslutad');
INSERT INTO `lang_definitions` VALUES (1142, 2293, 2, 'Datacols måste ha ett nummer mellan 1 och 999');
INSERT INTO `lang_definitions` VALUES (1143, 2294, 2, 'Datum');
INSERT INTO `lang_definitions` VALUES (1144, 2295, 2, 'DATUM');
INSERT INTO `lang_definitions` VALUES (1145, 2296, 2, 'Hantering av datum och tid');
INSERT INTO `lang_definitions` VALUES (1146, 2298, 2, 'Administreringsdatum');
INSERT INTO `lang_definitions` VALUES (1147, 2299, 2, 'datum och tid för insamling');
INSERT INTO `lang_definitions` VALUES (1148, 2300, 2, 'datum och tid för observation');
INSERT INTO `lang_definitions` VALUES (1149, 2302, 2, 'Datum och tid när provet togs');
INSERT INTO `lang_definitions` VALUES (1150, 2303, 2, 'datum kan inte vara senare än idag');
INSERT INTO `lang_definitions` VALUES (1151, 2304, 2, 'Datum då preventivmeddel insattes för första gången');
INSERT INTO `lang_definitions` VALUES (1152, 2305, 2, 'Skapat datum');
INSERT INTO `lang_definitions` VALUES (1153, 2306, 2, 'Datum avslutad');
INSERT INTO `lang_definitions` VALUES (1154, 2307, 2, 'Förstörd datum');
INSERT INTO `lang_definitions` VALUES (1155, 2308, 2, 'Sätt att visa datum');
INSERT INTO `lang_definitions` VALUES (1156, 2309, 2, 'Datumformat för \"mötet slutar\" är inte giltigt');
INSERT INTO `lang_definitions` VALUES (1157, 2310, 2, 'Datumformat för \"mötet startat \"är inte giltig');
INSERT INTO `lang_definitions` VALUES (1158, 2311, 2, 'Datumformat för \"Nästa Möte\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1159, 2312, 2, 'Datumformat för \"sista besök\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1160, 2314, 2, 'Datumformat för \"sista besök\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1161, 2315, 2, 'Datum för vaccinationsinformation');
INSERT INTO `lang_definitions` VALUES (1162, 2316, 2, 'Datum saknas för kod');
INSERT INTO `lang_definitions` VALUES (1163, 2317, 2, 'Huvudsakligt kriterium för datum');
INSERT INTO `lang_definitions` VALUES (1164, 2320, 2, 'Datum för bankinsättning åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1165, 2321, 2, 'datum för fakturering');
INSERT INTO `lang_definitions` VALUES (1166, 2322, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1167, 2323, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1168, 2324, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1169, 2326, 2, 'datum för registrering');
INSERT INTO `lang_definitions` VALUES (1170, 2328, 2, 'Datum för skada');
INSERT INTO `lang_definitions` VALUES (1171, 2332, 2, 'Datum för betalning åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1172, 2334, 2, 'Remissdatum');
INSERT INTO `lang_definitions` VALUES (1173, 2336, 2, 'Svarsdatum');
INSERT INTO `lang_definitions` VALUES (1174, 2337, 2, 'Rapportdatum');
INSERT INTO `lang_definitions` VALUES (1175, 2338, 2, 'Datum för tjänsten');
INSERT INTO `lang_definitions` VALUES (1176, 2340, 2, 'Datum för tjänst');
INSERT INTO `lang_definitions` VALUES (1177, 2341, 2, 'datum för tjänsten = idag');
INSERT INTO `lang_definitions` VALUES (1178, 2343, 2, 'Datum för tjänst MM / DD / ÅÅÅÅ');
INSERT INTO `lang_definitions` VALUES (1179, 2344, 2, 'Datum för tjänst:');
INSERT INTO `lang_definitions` VALUES (1180, 2345, 2, 'datum för signering');
INSERT INTO `lang_definitions` VALUES (1181, 2346, 2, 'datum för förändrat status');
INSERT INTO `lang_definitions` VALUES (1182, 2348, 2, 'Orderdatum');
INSERT INTO `lang_definitions` VALUES (1183, 2349, 2, 'Rapportdatum');
INSERT INTO `lang_definitions` VALUES (1184, 2350, 2, 'Datum för VIS deklaration');
INSERT INTO `lang_definitions` VALUES (1185, 2351, 2, 'datum beställd');
INSERT INTO `lang_definitions` VALUES (1186, 2354, 2, 'Val av datum');
INSERT INTO `lang_definitions` VALUES (1187, 2355, 2, 'Skickat datum');
INSERT INTO `lang_definitions` VALUES (1188, 2356, 2, 'Datum då meddelande skickades');
INSERT INTO `lang_definitions` VALUES (1189, 2358, 2, 'datumvärde kan inte vara tomt.');
INSERT INTO `lang_definitions` VALUES (1190, 2361, 2, 'datum/planerat besök');
INSERT INTO `lang_definitions` VALUES (1191, 2362, 2, 'Datum/anteckningar');
INSERT INTO `lang_definitions` VALUES (1192, 2363, 2, 'Datum / Anteckningar, senast');
INSERT INTO `lang_definitions` VALUES (1193, 2364, 2, 'datum/tid');
INSERT INTO `lang_definitions` VALUES (1194, 2365, 2, 'Datum:');
INSERT INTO `lang_definitions` VALUES (1195, 2367, 2, 'Daterad meddelande log');
INSERT INTO `lang_definitions` VALUES (1196, 2370, 2, 'Dag');
INSERT INTO `lang_definitions` VALUES (1197, 2371, 2, 'dag');
INSERT INTO `lang_definitions` VALUES (1198, 2374, 2, 'Överblick dag');
INSERT INTO `lang_definitions` VALUES (1199, 2375, 2, 'Dag (ar)');
INSERT INTO `lang_definitions` VALUES (1200, 2376, 2, 'Dag (ar) M-F');
INSERT INTO `lang_definitions` VALUES (1201, 2377, 2, 'dagar');
INSERT INTO `lang_definitions` VALUES (1202, 2378, 2, 'Dagar');
INSERT INTO `lang_definitions` VALUES (1203, 2379, 2, 'dagar sedan');
INSERT INTO `lang_definitions` VALUES (1204, 2380, 2, 'Dagar och spel Missade');
INSERT INTO `lang_definitions` VALUES (1205, 2381, 2, 'Dagar från förra mötet');
INSERT INTO `lang_definitions` VALUES (1206, 2382, 2, 'Missade dagar');
INSERT INTO `lang_definitions` VALUES (1207, 2385, 2, 'Dagar per Kolumn:');
INSERT INTO `lang_definitions` VALUES (1208, 2387, 2, 'dagar/kolumner');
INSERT INTO `lang_definitions` VALUES (1209, 2388, 2, 'DB installerad');
INSERT INTO `lang_definitions` VALUES (1210, 2389, 2, 'DD/MM/ÅÅÅÅ');
INSERT INTO `lang_definitions` VALUES (1211, 2390, 2, 'Avidentifiering');
INSERT INTO `lang_definitions` VALUES (1212, 2391, 2, 'Avidentifiering komplett');
INSERT INTO `lang_definitions` VALUES (1213, 2392, 2, 'Avidentifiering pågår');
INSERT INTO `lang_definitions` VALUES (1214, 2393, 2, 'Avidentifiering påpbörjad och sker i bakgrunden');
INSERT INTO `lang_definitions` VALUES (1215, 2394, 2, 'Avidentifiering kanske inte är komplett');
INSERT INTO `lang_definitions` VALUES (1216, 2395, 2, 'Avidentifierade filer sparas i');
INSERT INTO `lang_definitions` VALUES (1217, 2396, 2, 'Läkemedelsverket (DEA)');
INSERT INTO `lang_definitions` VALUES (1218, 2401, 2, 'Döv');
INSERT INTO `lang_definitions` VALUES (1219, 2403, 2, 'Debuginformation');
INSERT INTO `lang_definitions` VALUES (1220, 2405, 2, 'Debugging');
INSERT INTO `lang_definitions` VALUES (1221, 2406, 2, 'Dec');
INSERT INTO `lang_definitions` VALUES (1222, 2408, 2, 'Avslutad');
INSERT INTO `lang_definitions` VALUES (1223, 2415, 2, 'December');
INSERT INTO `lang_definitions` VALUES (1224, 2419, 2, 'Decimal pound eller pound/ounces delas med # (ex 5#4)');
INSERT INTO `lang_definitions` VALUES (1225, 2421, 2, 'Avdragsgill');
INSERT INTO `lang_definitions` VALUES (1226, 2422, 2, 'Genomförda avdrag');
INSERT INTO `lang_definitions` VALUES (1227, 2424, 2, 'Standard');
INSERT INTO `lang_definitions` VALUES (1228, 2426, 2, 'Standard Kalender vy');
INSERT INTO `lang_definitions` VALUES (1229, 2428, 2, 'Standard Besöksformulär Id');
INSERT INTO `lang_definitions` VALUES (1230, 2430, 2, 'Standard Klinik');
INSERT INTO `lang_definitions` VALUES (1231, 2435, 2, 'Standardspråk');
INSERT INTO `lang_definitions` VALUES (1232, 2436, 2, 'Standardspråk ifall inget annat är tillåtet eller valt');
INSERT INTO `lang_definitions` VALUES (1233, 2439, 2, 'Standardlista');
INSERT INTO `lang_definitions` VALUES (1234, 2441, 2, 'Standardmetod');
INSERT INTO `lang_definitions` VALUES (1235, 2442, 2, 'Standard tid för lösenords giltighet');
INSERT INTO `lang_definitions` VALUES (1236, 2443, 2, 'Standardtid för lösenords giltighetstid. 0 innebär oändlig giltighet.');
INSERT INTO `lang_definitions` VALUES (1237, 2444, 2, 'Standard patient land');
INSERT INTO `lang_definitions` VALUES (1238, 2447, 2, 'Standard prioritet');
INSERT INTO `lang_definitions` VALUES (1239, 2448, 2, 'Standard vårdgivare');
INSERT INTO `lang_definitions` VALUES (1240, 2450, 2, 'Standard range');
INSERT INTO `lang_definitions` VALUES (1241, 2451, 2, 'Standard kontaktorsak');
INSERT INTO `lang_definitions` VALUES (1242, 2456, 2, 'Standard inställningar');
INSERT INTO `lang_definitions` VALUES (1243, 2457, 2, 'Normalt status för \'Nytt fönster\' markering i patientlistan');
INSERT INTO `lang_definitions` VALUES (1244, 2458, 2, 'Standardmall');
INSERT INTO `lang_definitions` VALUES (1245, 2464, 2, 'Standard enhet');
INSERT INTO `lang_definitions` VALUES (1246, 2466, 2, 'Standardvärde');
INSERT INTO `lang_definitions` VALUES (1247, 2468, 2, 'Standard lager');
INSERT INTO `lang_definitions` VALUES (1248, 2469, 2, 'Standard X12 Partner');
INSERT INTO `lang_definitions` VALUES (1249, 2470, 2, 'Default / Global');
INSERT INTO `lang_definitions` VALUES (1250, 2475, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1251, 2476, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1252, 2477, 2, 'Fördröjd Återkommande (> 12 mån)');
INSERT INTO `lang_definitions` VALUES (1253, 2478, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1254, 2479, 2, 'ta bort');
INSERT INTO `lang_definitions` VALUES (1255, 2480, 2, 'Radera Kategorier med ID (s):');
INSERT INTO `lang_definitions` VALUES (1256, 2481, 2, 'Radera katogori');
INSERT INTO `lang_definitions` VALUES (1257, 2484, 2, 'Kunde ej radera!');
INSERT INTO `lang_definitions` VALUES (1258, 2485, 2, 'Ta bort grupp');
INSERT INTO `lang_definitions` VALUES (1259, 2486, 2, 'Ta bort lista');
INSERT INTO `lang_definitions` VALUES (1260, 2488, 2, 'Radera Sidor');
INSERT INTO `lang_definitions` VALUES (1261, 2489, 2, 'Ta bort patient, Möte, Formulär, Ämne, Dokument, Betalning, Fakturering eller transaktionstryck');
INSERT INTO `lang_definitions` VALUES (1262, 2491, 2, 'Ta bort rad');
INSERT INTO `lang_definitions` VALUES (1263, 2492, 2, 'Ta bort markerade enheter');
INSERT INTO `lang_definitions` VALUES (1264, 2495, 2, 'Borttagning OK');
INSERT INTO `lang_definitions` VALUES (1265, 2496, 2, 'Radera detta dokument');
INSERT INTO `lang_definitions` VALUES (1266, 2497, 2, 'Radera detta formulär');
INSERT INTO `lang_definitions` VALUES (1267, 2499, 2, 'Radera denna anteckning');
INSERT INTO `lang_definitions` VALUES (1268, 2501, 2, 'Borttagning OK');
INSERT INTO `lang_definitions` VALUES (1269, 2502, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1270, 2503, 2, 'Borttagen händelse kan inte återskapas. Är du säker på att du vill ta bort händelsen?');
INSERT INTO `lang_definitions` VALUES (1271, 2506, 2, 'Leverans bekräftad');
INSERT INTO `lang_definitions` VALUES (1272, 2508, 2, 'Leverans är inte tillåten till specificerad direkt adress.');
INSERT INTO `lang_definitions` VALUES (1273, 2510, 2, 'Leverans av bifogat kliniskt dokument var begärt av patienten');
INSERT INTO `lang_definitions` VALUES (1274, 2511, 2, 'Demens');
INSERT INTO `lang_definitions` VALUES (1275, 2513, 2, 'Demografi');
INSERT INTO `lang_definitions` VALUES (1276, 2514, 2, 'Demografi');
INSERT INTO `lang_definitions` VALUES (1277, 2518, 2, 'Demografi filter kriterier');
INSERT INTO `lang_definitions` VALUES (1278, 2520, 2, 'Demografi ej auktoriserad');
INSERT INTO `lang_definitions` VALUES (1279, 2521, 2, 'Demografi ej auktoriserad');
INSERT INTO `lang_definitions` VALUES (1280, 2522, 2, 'Nekad');
INSERT INTO `lang_definitions` VALUES (1281, 2524, 2, 'Nämnare');
INSERT INTO `lang_definitions` VALUES (1282, 2527, 2, 'Dental');
INSERT INTO `lang_definitions` VALUES (1283, 2528, 2, 'Tandvård ärende lista');
INSERT INTO `lang_definitions` VALUES (1284, 2529, 2, 'Tandvårds ärenden');
INSERT INTO `lang_definitions` VALUES (1285, 2534, 2, 'Beroende på vilken typ av räkning som testas kommer man kunna se HCFA liknande utskrift på blankt papper om HFCA-räkning testas, flera rader med blurrig text och information ifall X12-claim testas. Denna text är X12 EDI 4010A format. Ibland ser man udda konstiga tecken som liknar små figurer. Detta är kontrolltecken för sidmatning mm och det är helt normalt.');
INSERT INTO `lang_definitions` VALUES (1286, 2536, 2, 'Insättningsdatum');
INSERT INTO `lang_definitions` VALUES (1287, 2537, 2, 'Insättningsdatum kan inte vara senare än idag.');
INSERT INTO `lang_definitions` VALUES (1288, 2538, 2, 'Insättning Datum:');
INSERT INTO `lang_definitions` VALUES (1289, 2539, 2, 'Deprimerad');
INSERT INTO `lang_definitions` VALUES (1290, 2540, 2, 'Depression');
INSERT INTO `lang_definitions` VALUES (1291, 2546, 2, 'Beskrivning');
INSERT INTO `lang_definitions` VALUES (1292, 2547, 2, 'beskrivning');
INSERT INTO `lang_definitions` VALUES (1293, 2549, 2, 'Beskrivning av upptäckten');
INSERT INTO `lang_definitions` VALUES (1294, 2550, 2, 'Beskrivning av åtgärden eller resultatkod');
INSERT INTO `lang_definitions` VALUES (1295, 2551, 2, 'Beskrivning översättning');
INSERT INTO `lang_definitions` VALUES (1296, 2553, 2, 'Mål');
INSERT INTO `lang_definitions` VALUES (1297, 2554, 2, 'Målfilnamn');
INSERT INTO `lang_definitions` VALUES (1298, 2555, 2, 'Förstör Parti');
INSERT INTO `lang_definitions` VALUES (1299, 2556, 2, 'Förstör ...');
INSERT INTO `lang_definitions` VALUES (1300, 2557, 2, 'Förstörd');
INSERT INTO `lang_definitions` VALUES (1301, 2558, 2, 'Förstörda läkemedel');
INSERT INTO `lang_definitions` VALUES (1302, 2559, 2, 'Förstöras narkotika Rapport');
INSERT INTO `lang_definitions` VALUES (1303, 2560, 2, 'Detalj');
INSERT INTO `lang_definitions` VALUES (1304, 2565, 2, 'Detaljer');
INSERT INTO `lang_definitions` VALUES (1305, 2567, 2, 'Utvecklingsstörning');
INSERT INTO `lang_definitions` VALUES (1306, 2569, 2, 'Diabetes');
INSERT INTO `lang_definitions` VALUES (1307, 2570, 2, 'Diabetes Mellitus');
INSERT INTO `lang_definitions` VALUES (1308, 2571, 2, 'Diabetes: Blodtryckskontroll');
INSERT INTO `lang_definitions` VALUES (1309, 2572, 2, 'Diabetes: Ögonundersökning');
INSERT INTO `lang_definitions` VALUES (1310, 2573, 2, 'Diabetes: Ögonundersökning');
INSERT INTO `lang_definitions` VALUES (1311, 2574, 2, 'Diabetes: Fotundersökning');
INSERT INTO `lang_definitions` VALUES (1312, 2575, 2, 'Diabetes: Fotundersökning');
INSERT INTO `lang_definitions` VALUES (1313, 2576, 2, 'Diabetes: HbA1c dåligt reglerat');
INSERT INTO `lang_definitions` VALUES (1314, 2577, 2, 'Diabetes: HbA1c');
INSERT INTO `lang_definitions` VALUES (1315, 2578, 2, 'Diabetes: Blodfetter');
INSERT INTO `lang_definitions` VALUES (1316, 2579, 2, 'Diabetes: Urin microalbumin');
INSERT INTO `lang_definitions` VALUES (1317, 2580, 2, 'Diag');
INSERT INTO `lang_definitions` VALUES (1318, 2581, 2, 'Diagnoser');
INSERT INTO `lang_definitions` VALUES (1319, 2582, 2, 'Diagnos');
INSERT INTO `lang_definitions` VALUES (1320, 2583, 2, 'Diagnoskod');
INSERT INTO `lang_definitions` VALUES (1321, 2585, 2, 'Diagnos datum');
INSERT INTO `lang_definitions` VALUES (1322, 2587, 2, 'Diagnos måste kodas in i ett länkat patientmöte');
INSERT INTO `lang_definitions` VALUES (1323, 2588, 2, 'Diagnos namn');
INSERT INTO `lang_definitions` VALUES (1324, 2589, 2, 'Diagnos rapport');
INSERT INTO `lang_definitions` VALUES (1325, 2590, 2, 'Diagnos rapport');
INSERT INTO `lang_definitions` VALUES (1326, 2591, 2, 'Diagnos rapport enbart');
INSERT INTO `lang_definitions` VALUES (1327, 2592, 2, 'Diagnos titel');
INSERT INTO `lang_definitions` VALUES (1328, 2593, 2, 'Diagnos:');
INSERT INTO `lang_definitions` VALUES (1329, 2594, 2, 'Diagnos:');
INSERT INTO `lang_definitions` VALUES (1330, 2596, 2, 'Diagnostiska tester:');
INSERT INTO `lang_definitions` VALUES (1331, 2597, 2, 'Skala');
INSERT INTO `lang_definitions` VALUES (1332, 2600, 2, 'Membran/kapsel');
INSERT INTO `lang_definitions` VALUES (1333, 2601, 2, 'Diarée');
INSERT INTO `lang_definitions` VALUES (1334, 2603, 2, 'Diktat');
INSERT INTO `lang_definitions` VALUES (1335, 2604, 2, 'Diktat:');
INSERT INTO `lang_definitions` VALUES (1336, 2605, 2, 'Fick du en kopia av denna HIPAA notering?');
INSERT INTO `lang_definitions` VALUES (1337, 2606, 2, 'Diffus');
INSERT INTO `lang_definitions` VALUES (1338, 2607, 2, 'Digitalt signerad');
INSERT INTO `lang_definitions` VALUES (1339, 2615, 2, 'Direkt mail');
INSERT INTO `lang_definitions` VALUES (1340, 2616, 2, 'Log på direktmeddelande');
INSERT INTO `lang_definitions` VALUES (1341, 2617, 2, 'Direkt meddelande mottaget');
INSERT INTO `lang_definitions` VALUES (1342, 2618, 2, 'Direkt meddelande ej tillgängligt');
INSERT INTO `lang_definitions` VALUES (1343, 2619, 2, 'Kunde ej skicka direkt meddelande');
INSERT INTO `lang_definitions` VALUES (1344, 2621, 2, 'Arbetsledare, namn');
INSERT INTO `lang_definitions` VALUES (1345, 2622, 2, 'Kunde ej ta bort mapp. Fortsätt');
INSERT INTO `lang_definitions` VALUES (1346, 2623, 2, 'Funktionshinder');
INSERT INTO `lang_definitions` VALUES (1347, 2628, 2, 'Stäng av kalender');
INSERT INTO `lang_definitions` VALUES (1348, 2629, 2, 'Stäng av spårning av patientkort');
INSERT INTO `lang_definitions` VALUES (1349, 2631, 2, 'Stäng av vaccination');
INSERT INTO `lang_definitions` VALUES (1350, 2633, 2, 'Stäng av gammal metrisk vitala tecken formulär');
INSERT INTO `lang_definitions` VALUES (1351, 2635, 2, 'Stäng av phpMyAdmin');
INSERT INTO `lang_definitions` VALUES (1352, 2636, 2, 'Stäng av receptförskrivning');
INSERT INTO `lang_definitions` VALUES (1353, 2637, 2, 'Stäng av användargrupp');
INSERT INTO `lang_definitions` VALUES (1354, 2638, 2, 'funktionshindrade');
INSERT INTO `lang_definitions` VALUES (1355, 2639, 2, 'Funktionshindrade');
INSERT INTO `lang_definitions` VALUES (1356, 2640, 2, 'Handikappad under 65 år med LGHP-försäkring');
INSERT INTO `lang_definitions` VALUES (1357, 2644, 2, 'Disk');
INSERT INTO `lang_definitions` VALUES (1358, 2647, 2, 'Utskrivning');
INSERT INTO `lang_definitions` VALUES (1359, 2648, 2, 'Flytningar från urinröret');
INSERT INTO `lang_definitions` VALUES (1360, 2650, 2, 'Rätt utskriven');
INSERT INTO `lang_definitions` VALUES (1361, 2651, 2, 'Rätt utskriven');
INSERT INTO `lang_definitions` VALUES (1362, 2655, 2, 'Utskriven');
INSERT INTO `lang_definitions` VALUES (1363, 2656, 2, 'Kvitto information');
INSERT INTO `lang_definitions` VALUES (1364, 2657, 2, 'Kvitto typ');
INSERT INTO `lang_definitions` VALUES (1365, 2658, 2, 'Kvitton typer');
INSERT INTO `lang_definitions` VALUES (1366, 2659, 2, 'Kvitton');
INSERT INTO `lang_definitions` VALUES (1367, 2664, 2, 'Rabatt');
INSERT INTO `lang_definitions` VALUES (1368, 2665, 2, 'Rabatt Belopp');
INSERT INTO `lang_definitions` VALUES (1369, 2666, 2, 'Rabatt nivå');
INSERT INTO `lang_definitions` VALUES (1370, 2667, 2, 'Rabatt procent');
INSERT INTO `lang_definitions` VALUES (1371, 2668, 2, 'Rabatt som belopp');
INSERT INTO `lang_definitions` VALUES (1372, 2669, 2, 'Rabatt vid checkout skrivs in som belopp i stället för som procent');
INSERT INTO `lang_definitions` VALUES (1373, 2670, 2, 'Diskreta resultat');
INSERT INTO `lang_definitions` VALUES (1374, 2672, 2, 'Sjukdom');
INSERT INTO `lang_definitions` VALUES (1375, 2674, 2, 'Förskjutning');
INSERT INTO `lang_definitions` VALUES (1376, 2677, 2, 'Antal:');
INSERT INTO `lang_definitions` VALUES (1377, 2678, 2, 'Skicka i väg');
INSERT INTO `lang_definitions` VALUES (1378, 2679, 2, 'Skicka mottagna dokument');
INSERT INTO `lang_definitions` VALUES (1379, 2683, 2, 'Utlämnad');
INSERT INTO `lang_definitions` VALUES (1380, 2686, 2, 'Visa avancerade inställningar på demografisidan');
INSERT INTO `lang_definitions` VALUES (1381, 2689, 2, 'Visa händelsedatum i blocket?');
INSERT INTO `lang_definitions` VALUES (1382, 2690, 2, 'Visa format får US vikter?');
INSERT INTO `lang_definitions` VALUES (1383, 2691, 2, 'Visa hur många händelser?');
INSERT INTO `lang_definitions` VALUES (1384, 2694, 2, 'Visa plats i blocket?');
INSERT INTO `lang_definitions` VALUES (1385, 2695, 2, 'Visa namn');
INSERT INTO `lang_definitions` VALUES (1386, 2697, 2, 'Visa kalender?');
INSERT INTO `lang_definitions` VALUES (1387, 2704, 2, 'Display dagens händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1388, 2705, 2, 'Visa ämne i blocket?');
INSERT INTO `lang_definitions` VALUES (1389, 2706, 2, 'Visa kommande händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1390, 2708, 2, 'Visa kommande händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1391, 2709, 2, 'Visa följande antal av de senaste meddelandena.');
INSERT INTO `lang_definitions` VALUES (1392, 2711, 2, 'Visa följande antal av senaste noteringarna');
INSERT INTO `lang_definitions` VALUES (1393, 2712, 2, 'Visa följande antal av de senaste noteringarna');
INSERT INTO `lang_definitions` VALUES (1394, 2717, 2, 'Distrubition');
INSERT INTO `lang_definitions` VALUES (1395, 2718, 2, 'Distribution');
INSERT INTO `lang_definitions` VALUES (1396, 2719, 2, 'Leverantör');
INSERT INTO `lang_definitions` VALUES (1397, 2724, 2, 'Divertikulit');
INSERT INTO `lang_definitions` VALUES (1398, 2725, 2, 'Divertikulit kirurgi');
INSERT INTO `lang_definitions` VALUES (1399, 2726, 2, 'Divertikulit');
INSERT INTO `lang_definitions` VALUES (1400, 2727, 2, 'Divertikulit Kirurgi');
INSERT INTO `lang_definitions` VALUES (1401, 2728, 2, 'Skild');
INSERT INTO `lang_definitions` VALUES (1402, 2729, 2, 'Yrsel:');
INSERT INTO `lang_definitions` VALUES (1403, 2732, 2, 'Ändra inte');
INSERT INTO `lang_definitions` VALUES (1404, 2734, 2, 'Visa inte Allergi uppladdad till NewCrop');
INSERT INTO `lang_definitions` VALUES (1405, 2736, 2, 'Visa inte medicinering uppladdad till NewCrop');
INSERT INTO `lang_definitions` VALUES (1406, 2739, 2, 'Visa inte kalender');
INSERT INTO `lang_definitions` VALUES (1407, 2743, 2, 'Lagra och sälj inga produkter');
INSERT INTO `lang_definitions` VALUES (1408, 2746, 2, 'Kräv inte att patientanteckningar blir godkända');
INSERT INTO `lang_definitions` VALUES (1409, 2747, 2, 'Inte HLR beslut');
INSERT INTO `lang_definitions` VALUES (1410, 2748, 2, 'spara inte');
INSERT INTO `lang_definitions` VALUES (1411, 2749, 2, 'ersätt inte');
INSERT INTO `lang_definitions` VALUES (1412, 2751, 2, 'gör ingenting');
INSERT INTO `lang_definitions` VALUES (1413, 2754, 2, 'Vill du verkligen radera?');
INSERT INTO `lang_definitions` VALUES (1414, 2755, 2, 'Vill du verkligen radera detta urval?');
INSERT INTO `lang_definitions` VALUES (1415, 2756, 2, 'Vill du verkligen ta bort den här gruppen');
INSERT INTO `lang_definitions` VALUES (1416, 2758, 2, 'Vill du fortsätta?');
INSERT INTO `lang_definitions` VALUES (1417, 2759, 2, 'Vill du ta bort detta?');
INSERT INTO `lang_definitions` VALUES (1418, 2760, 2, 'Vill du ta bort?');
INSERT INTO `lang_definitions` VALUES (1419, 2761, 2, 'Vill du ta bort denna post?');
INSERT INTO `lang_definitions` VALUES (1420, 2762, 2, 'Vill du fortsätta att lägga till den nya patienten?');
INSERT INTO `lang_definitions` VALUES (1421, 2763, 2, 'Vill du fortsätta med det nya namnet?');
INSERT INTO `lang_definitions` VALUES (1422, 2764, 2, 'Vill du PERMANENT ta bort vaccinationsregistreringen?');
INSERT INTO `lang_definitions` VALUES (1423, 2765, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1424, 2766, 2, 'Födelsedatum saknas, ange om möjligt');
INSERT INTO `lang_definitions` VALUES (1425, 2768, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1426, 2769, 2, 'Läkare');
INSERT INTO `lang_definitions` VALUES (1427, 2770, 2, 'Läkare:');
INSERT INTO `lang_definitions` VALUES (1428, 2771, 2, 'Läkares namn och underskrift');
INSERT INTO `lang_definitions` VALUES (1429, 2772, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1430, 2773, 2, 'dokument');
INSERT INTO `lang_definitions` VALUES (1431, 2775, 2, 'Dokument Kategorier');
INSERT INTO `lang_definitions` VALUES (1432, 2781, 2, 'Dokument kan inte flyttas till patienten id');
INSERT INTO `lang_definitions` VALUES (1433, 2783, 2, 'Dokument Datum');
INSERT INTO `lang_definitions` VALUES (1434, 2784, 2, 'Dokumentets datum och utförande uppdaterats');
INSERT INTO `lang_definitions` VALUES (1435, 2785, 2, 'Dokument id');
INSERT INTO `lang_definitions` VALUES (1436, 2788, 2, 'Dokument är flyttat till ny kategori');
INSERT INTO `lang_definitions` VALUES (1437, 2789, 2, 'Dokument är flyttat till patienten id');
INSERT INTO `lang_definitions` VALUES (1438, 2791, 2, 'Dokument kontrollerat');
INSERT INTO `lang_definitions` VALUES (1439, 2792, 2, 'Sätt att lagra dokument');
INSERT INTO `lang_definitions` VALUES (1440, 2793, 2, 'Namnbyte av dokument lyckats');
INSERT INTO `lang_definitions` VALUES (1441, 2799, 2, 'Dokument/avbildning lagrad');
INSERT INTO `lang_definitions` VALUES (1442, 2801, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1443, 2803, 2, 'Dokument (skriva, tilllägg frivilligt)');
INSERT INTO `lang_definitions` VALUES (1444, 2811, 2, 'Inskrivningsdatum');
INSERT INTO `lang_definitions` VALUES (1445, 2816, 2, 'stämmer inte med PV1 besöksnummer');
INSERT INTO `lang_definitions` VALUES (1446, 2817, 2, 'Verkar inte giltig');
INSERT INTO `lang_definitions` VALUES (1447, 2818, 2, 'Tillåter denna typ relaterade koder?');
INSERT INTO `lang_definitions` VALUES (1448, 2819, 2, 'Sambo');
INSERT INTO `lang_definitions` VALUES (1449, 2820, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1450, 2821, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1451, 2822, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1452, 2824, 2, 'Klart');
INSERT INTO `lang_definitions` VALUES (1453, 2826, 2, 'Klar med:');
INSERT INTO `lang_definitions` VALUES (1454, 2827, 2, 'Klar. Skickas för nedladdning');
INSERT INTO `lang_definitions` VALUES (1455, 2828, 2, 'Datum för tjänsten');
INSERT INTO `lang_definitions` VALUES (1456, 2829, 2, 'Dosering');
INSERT INTO `lang_definitions` VALUES (1457, 2833, 2, 'dubbelklicka för att redigera');
INSERT INTO `lang_definitions` VALUES (1458, 2835, 2, 'Dubbelseende');
INSERT INTO `lang_definitions` VALUES (1459, 2836, 2, 'Ladda ner');
INSERT INTO `lang_definitions` VALUES (1460, 2841, 2, 'Ladda ner ändå');
INSERT INTO `lang_definitions` VALUES (1461, 2842, 2, 'Ladda ner faktura fil, bokför och markera som skickad.');
INSERT INTO `lang_definitions` VALUES (1462, 2844, 2, 'Ladda ner certifikat');
INSERT INTO `lang_definitions` VALUES (1463, 2845, 2, 'Ladda ner configurationsdata');
INSERT INTO `lang_definitions` VALUES (1464, 2849, 2, 'ladda ner krypterad fil');
INSERT INTO `lang_definitions` VALUES (1465, 2855, 2, 'Ladda ner PDF');
INSERT INTO `lang_definitions` VALUES (1466, 2858, 2, 'Ladda ner utvald redogörelse');
INSERT INTO `lang_definitions` VALUES (1467, 2860, 2, 'Läkarkontroll');
INSERT INTO `lang_definitions` VALUES (1468, 2861, 2, 'Läkarbesök');
INSERT INTO `lang_definitions` VALUES (1469, 2862, 2, 'Dr.');
INSERT INTO `lang_definitions` VALUES (1470, 2866, 2, 'Drag för att flytta');
INSERT INTO `lang_definitions` VALUES (1471, 2868, 2, 'Dribblande');
INSERT INTO `lang_definitions` VALUES (1472, 2869, 2, 'Körkortsnr');
INSERT INTO `lang_definitions` VALUES (1473, 2871, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (1474, 2874, 2, 'Leta läkemedel');
INSERT INTO `lang_definitions` VALUES (1475, 2875, 2, 'Läkemedelsformulär');
INSERT INTO `lang_definitions` VALUES (1476, 2876, 2, 'Läkemeddels ID saknas!');
INSERT INTO `lang_definitions` VALUES (1477, 2877, 2, 'Läkemedel intervall');
INSERT INTO `lang_definitions` VALUES (1478, 2878, 2, 'Inventarielista, läkemedel');
INSERT INTO `lang_definitions` VALUES (1479, 2880, 2, 'Läkemedelsnamn');
INSERT INTO `lang_definitions` VALUES (1480, 2881, 2, 'Läkemedel administrationssätt');
INSERT INTO `lang_definitions` VALUES (1481, 2886, 2, 'Läkemedel, enheter');
INSERT INTO `lang_definitions` VALUES (1482, 2892, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (1483, 2893, 2, 'Läkemedel och produkter');
INSERT INTO `lang_definitions` VALUES (1484, 2894, 2, 'Muntorrhet');
INSERT INTO `lang_definitions` VALUES (1485, 2895, 2, 'DSM-4 Diagnos');
INSERT INTO `lang_definitions` VALUES (1486, 2896, 2, 'DT 1');
INSERT INTO `lang_definitions` VALUES (1487, 2897, 2, 'DT 2');
INSERT INTO `lang_definitions` VALUES (1488, 2898, 2, 'DT 3');
INSERT INTO `lang_definitions` VALUES (1489, 2899, 2, 'DT 4');
INSERT INTO `lang_definitions` VALUES (1490, 2900, 2, 'DT 5');
INSERT INTO `lang_definitions` VALUES (1491, 2901, 2, 'DTaP 1');
INSERT INTO `lang_definitions` VALUES (1492, 2902, 2, 'DTaP 2');
INSERT INTO `lang_definitions` VALUES (1493, 2903, 2, 'DTaP 3');
INSERT INTO `lang_definitions` VALUES (1494, 2904, 2, 'DTaP 4');
INSERT INTO `lang_definitions` VALUES (1495, 2905, 2, 'DTaP 5');
INSERT INTO `lang_definitions` VALUES (1496, 2906, 2, 'Förfaller');
INSERT INTO `lang_definitions` VALUES (1497, 2907, 2, 'Förfallodatum');
INSERT INTO `lang_definitions` VALUES (1498, 2909, 2, 'Förfallodatum mm / dd / yyyy eller åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1499, 2910, 2, 'Förfallodatum:');
INSERT INTO `lang_definitions` VALUES (1500, 2912, 2, 'Förfaller patienter');
INSERT INTO `lang_definitions` VALUES (1501, 2913, 2, 'Förfaller snart');
INSERT INTO `lang_definitions` VALUES (1502, 2914, 2, 'Förfallostatus');
INSERT INTO `lang_definitions` VALUES (1503, 2915, 2, 'Uppdatera förfallostatus');
INSERT INTO `lang_definitions` VALUES (1504, 2916, 2, 'Dumping OpenEMR database');
INSERT INTO `lang_definitions` VALUES (1505, 2917, 2, 'Dumping OpenEMR web directory tree');
INSERT INTO `lang_definitions` VALUES (1506, 2918, 2, 'Dumping phpGACL database');
INSERT INTO `lang_definitions` VALUES (1507, 2919, 2, 'Dumping phpGACL web directory tree');
INSERT INTO `lang_definitions` VALUES (1508, 2920, 2, 'Dumping SQL-Ledger database');
INSERT INTO `lang_definitions` VALUES (1509, 2921, 2, 'Dumping SQL-Ledger web directory tree');
INSERT INTO `lang_definitions` VALUES (1510, 2922, 2, 'Dubletter kontroll');
INSERT INTO `lang_definitions` VALUES (1511, 2926, 2, 'Dubletter av ID');
INSERT INTO `lang_definitions` VALUES (1512, 2927, 2, 'Dubletter av namn');
INSERT INTO `lang_definitions` VALUES (1513, 2928, 2, 'DUBLETTER VARNING');
INSERT INTO `lang_definitions` VALUES (1514, 2929, 2, 'Varaktig fullmakt');
INSERT INTO `lang_definitions` VALUES (1515, 2930, 2, 'Varaktighet');
INSERT INTO `lang_definitions` VALUES (1516, 2931, 2, 'varaktighet');
INSERT INTO `lang_definitions` VALUES (1517, 2932, 2, 'Holländsk');
INSERT INTO `lang_definitions` VALUES (1518, 2935, 2, 'Dysfagi');
INSERT INTO `lang_definitions` VALUES (1519, 2936, 2, 'Dyspné:');
INSERT INTO `lang_definitions` VALUES (1520, 2937, 2, 'Urinvägsbesvär');
INSERT INTO `lang_definitions` VALUES (1521, 2946, 2, 'E-recept?');
INSERT INTO `lang_definitions` VALUES (1522, 2947, 2, 'E-rapport');
INSERT INTO `lang_definitions` VALUES (1523, 2948, 2, 'E-recept?');
INSERT INTO `lang_definitions` VALUES (1524, 2950, 2, 'Förnya E-recept');
INSERT INTO `lang_definitions` VALUES (1525, 2953, 2, 'Varje mottagare måste själv ange att meddelanden är avslutade');
INSERT INTO `lang_definitions` VALUES (1526, 2958, 2, 'Tidig Återkommande (<2 Mo)');
INSERT INTO `lang_definitions` VALUES (1527, 2959, 2, 'Öron');
INSERT INTO `lang_definitions` VALUES (1528, 2963, 2, 'EKG');
INSERT INTO `lang_definitions` VALUES (1529, 2964, 2, 'Elektronisk begäran');
INSERT INTO `lang_definitions` VALUES (1530, 2967, 2, 'Ödem');
INSERT INTO `lang_definitions` VALUES (1531, 2974, 2, 'Redigera');
INSERT INTO `lang_definitions` VALUES (1532, 2976, 2, 'Redigera allergier');
INSERT INTO `lang_definitions` VALUES (1533, 2978, 2, 'Edit Kategorier');
INSERT INTO `lang_definitions` VALUES (1534, 2981, 2, 'Redigera definitioner');
INSERT INTO `lang_definitions` VALUES (1535, 2982, 2, 'Redigera diagnoser för');
INSERT INTO `lang_definitions` VALUES (1536, 2988, 2, 'Redigera Kliniker');
INSERT INTO `lang_definitions` VALUES (1537, 2990, 2, 'Redigera Klinikinformation');
INSERT INTO `lang_definitions` VALUES (1538, 2993, 2, 'Redigera form');
INSERT INTO `lang_definitions` VALUES (1539, 2998, 2, 'Redigera layout');
INSERT INTO `lang_definitions` VALUES (1540, 3000, 2, 'Redigera lista');
INSERT INTO `lang_definitions` VALUES (1541, 3004, 2, 'Redigera Struktur');
INSERT INTO `lang_definitions` VALUES (1542, 3011, 2, 'Utbildning');
INSERT INTO `lang_definitions` VALUES (1543, 3012, 2, 'Information');
INSERT INTO `lang_definitions` VALUES (1544, 3015, 2, 'Ikraftträdandedatum');
INSERT INTO `lang_definitions` VALUES (1545, 3017, 2, 'Effektivitet');
INSERT INTO `lang_definitions` VALUES (1546, 3022, 2, 'Ejaculation');
INSERT INTO `lang_definitions` VALUES (1547, 3023, 2, 'Armbåge');
INSERT INTO `lang_definitions` VALUES (1548, 3024, 2, 'Problem med armbågen');
INSERT INTO `lang_definitions` VALUES (1549, 3029, 2, 'Elektronisk remiss');
INSERT INTO `lang_definitions` VALUES (1550, 3040, 2, 'Email');
INSERT INTO `lang_definitions` VALUES (1551, 3051, 2, 'E-post från Batchcom');
INSERT INTO `lang_definitions` VALUES (1552, 3052, 2, 'E-postmeddelande');
INSERT INTO `lang_definitions` VALUES (1553, 3057, 2, 'E-post skicka innan');
INSERT INTO `lang_definitions` VALUES (1554, 3058, 2, 'Email, skicka');
INSERT INTO `lang_definitions` VALUES (1555, 3061, 2, 'Epost Ämnesord');
INSERT INTO `lang_definitions` VALUES (1556, 3063, 2, 'Email Text, användbara Tag: *** NAMN ***, dvs Bäste *** NAMN ***');
INSERT INTO `lang_definitions` VALUES (1557, 3070, 2, 'ICE Kontakt');
INSERT INTO `lang_definitions` VALUES (1558, 3071, 2, 'ICE kontaktperson');
INSERT INTO `lang_definitions` VALUES (1559, 3072, 2, 'ICE kontakt telefonnummer');
INSERT INTO `lang_definitions` VALUES (1560, 3073, 2, 'Akut Preventivmedel');
INSERT INTO `lang_definitions` VALUES (1561, 3079, 2, 'ICE Telefon');
INSERT INTO `lang_definitions` VALUES (1562, 3082, 2, 'Emfysem');
INSERT INTO `lang_definitions` VALUES (1563, 3083, 2, 'Anställd');
INSERT INTO `lang_definitions` VALUES (1564, 3084, 2, 'Arbetsgivare');
INSERT INTO `lang_definitions` VALUES (1565, 3085, 2, 'Arbetsgivarens adress');
INSERT INTO `lang_definitions` VALUES (1566, 3086, 2, 'Arbetsgivare Data');
INSERT INTO `lang_definitions` VALUES (1567, 3087, 2, 'Arbetsgivarens namn');
INSERT INTO `lang_definitions` VALUES (1568, 3089, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1569, 3092, 2, 'Ta bort värdet i \"E-tider\"');
INSERT INTO `lang_definitions` VALUES (1570, 3093, 2, 'Ta bort värde \"Email, skicka\"');
INSERT INTO `lang_definitions` VALUES (1571, 3094, 2, 'Ta bort värde i \"Email, ämne\"');
INSERT INTO `lang_definitions` VALUES (1572, 3095, 2, 'Ta bort i \"text\"');
INSERT INTO `lang_definitions` VALUES (1573, 3096, 2, 'Ta bort i \"Försörjarens namn\"');
INSERT INTO `lang_definitions` VALUES (1574, 3097, 2, 'Ta bort i \"Lösenord\"');
INSERT INTO `lang_definitions` VALUES (1575, 3098, 2, 'Ta bort \"SMS tider\"');
INSERT INTO `lang_definitions` VALUES (1576, 3099, 2, 'Ta bort \"SMS text\"');
INSERT INTO `lang_definitions` VALUES (1577, 3100, 2, 'Ta bort värdet i \"Användarnamn\"');
INSERT INTO `lang_definitions` VALUES (1578, 3191, 2, 'aktiverat');
INSERT INTO `lang_definitions` VALUES (1579, 3199, 2, 'Möte');
INSERT INTO `lang_definitions` VALUES (1580, 3201, 2, 'Patientmöte');
INSERT INTO `lang_definitions` VALUES (1581, 3202, 2, 'patientmöte');
INSERT INTO `lang_definitions` VALUES (1582, 3203, 2, 'Patientmöter');
INSERT INTO `lang_definitions` VALUES (1583, 3215, 2, 'Patientmöte formulär');
INSERT INTO `lang_definitions` VALUES (1584, 3222, 2, 'Patientmöte antal/nummer');
INSERT INTO `lang_definitions` VALUES (1585, 3243, 2, 'Patientmöte har kodats');
INSERT INTO `lang_definitions` VALUES (1586, 3244, 2, 'Patientmöte:');
INSERT INTO `lang_definitions` VALUES (1587, 3246, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (1588, 3247, 2, 'Patientmöte & Formulär');
INSERT INTO `lang_definitions` VALUES (1589, 3248, 2, 'Patientmöte & Formulär');
INSERT INTO `lang_definitions` VALUES (1590, 3249, 2, 'Encounters inte godkända');
INSERT INTO `lang_definitions` VALUES (1591, 3250, 2, 'Patientmöte, rapport');
INSERT INTO `lang_definitions` VALUES (1592, 3251, 2, 'Patientmöte, avsnitt');
INSERT INTO `lang_definitions` VALUES (1593, 3254, 2, 'Slut');
INSERT INTO `lang_definitions` VALUES (1594, 3255, 2, 'Slutar (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (1595, 3256, 2, 'Slutdatum');
INSERT INTO `lang_definitions` VALUES (1596, 3257, 2, 'Slutdatum');
INSERT INTO `lang_definitions` VALUES (1597, 3264, 2, 'Slutdatum:');
INSERT INTO `lang_definitions` VALUES (1598, 3269, 2, 'Sluttid');
INSERT INTO `lang_definitions` VALUES (1599, 3273, 2, 'Tjänsten slutar åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1600, 3277, 2, 'Endokrina');
INSERT INTO `lang_definitions` VALUES (1601, 3278, 2, 'Endoskopi');
INSERT INTO `lang_definitions` VALUES (1602, 3283, 2, 'Engelsk');
INSERT INTO `lang_definitions` VALUES (1603, 3284, 2, 'Engelsk');
INSERT INTO `lang_definitions` VALUES (1604, 3285, 2, 'Engelsk (indien)');
INSERT INTO `lang_definitions` VALUES (1605, 3286, 2, 'Engelsk (standard)');
INSERT INTO `lang_definitions` VALUES (1606, 3290, 2, 'ENT Ansvarsfrihet');
INSERT INTO `lang_definitions` VALUES (1607, 3291, 2, 'ENT Smärta');
INSERT INTO `lang_definitions` VALUES (1608, 3294, 2, 'Skriv en diagnos kod för att utesluta alla fakturor som inte innehåller det');
INSERT INTO `lang_definitions` VALUES (1609, 3359, 2, 'Ange dina sökkriterier ovan');
INSERT INTO `lang_definitions` VALUES (1610, 3368, 2, 'Miljöpåverkan');
INSERT INTO `lang_definitions` VALUES (1611, 3369, 2, 'EOB Data tillträde');
INSERT INTO `lang_definitions` VALUES (1612, 3374, 2, 'EOB Boknings - Instruktioner');
INSERT INTO `lang_definitions` VALUES (1613, 3375, 2, 'EOB Boknings - Faktura');
INSERT INTO `lang_definitions` VALUES (1614, 3376, 2, 'EOB Boknings - Patient Anmärkning');
INSERT INTO `lang_definitions` VALUES (1615, 3377, 2, 'EOB Boknings - Sök');
INSERT INTO `lang_definitions` VALUES (1616, 3379, 2, 'Epilepsi');
INSERT INTO `lang_definitions` VALUES (1617, 3389, 2, 'Radera');
INSERT INTO `lang_definitions` VALUES (1618, 3391, 2, 'Erektion');
INSERT INTO `lang_definitions` VALUES (1619, 3392, 2, 'Fel');
INSERT INTO `lang_definitions` VALUES (1620, 3397, 2, 'Fel i \"kön\" val');
INSERT INTO `lang_definitions` VALUES (1621, 3398, 2, 'Fel i \"HIPAA\" val');
INSERT INTO `lang_definitions` VALUES (1622, 3399, 2, 'Fel i \"Process\" val');
INSERT INTO `lang_definitions` VALUES (1623, 3400, 2, 'Fel i \"SMS Gateway\" val');
INSERT INTO `lang_definitions` VALUES (1624, 3401, 2, 'Fel i \"Sortera efter\" val');
INSERT INTO `lang_definitions` VALUES (1625, 3403, 2, 'Fel i JA eller NEJ alternativ');
INSERT INTO `lang_definitions` VALUES (1626, 3416, 2, 'fel under registrering!');
INSERT INTO `lang_definitions` VALUES (1627, 3417, 2, 'Fel vid sparande av fil');
INSERT INTO `lang_definitions` VALUES (1628, 3419, 2, 'Fel vid skrivning till fil');
INSERT INTO `lang_definitions` VALUES (1629, 3425, 2, 'FEL, kunde inte samla in data från servern');
INSERT INTO `lang_definitions` VALUES (1630, 3434, 2, 'FEL: kunde inte öppna table.sql bruten form?');
INSERT INTO `lang_definitions` VALUES (1631, 3442, 2, 'Fel: lösenord matchar inte. Kontrollera din stavning.');
INSERT INTO `lang_definitions` VALUES (1632, 3452, 2, 'Fel');
INSERT INTO `lang_definitions` VALUES (1633, 3459, 2, 'Erythema:');
INSERT INTO `lang_definitions` VALUES (1634, 3467, 2, 'Redan känd patient');
INSERT INTO `lang_definitions` VALUES (1635, 3469, 2, 'Modersmål/tolkspråk');
INSERT INTO `lang_definitions` VALUES (1636, 3470, 2, 'Modersmål/tolkspråk');
INSERT INTO `lang_definitions` VALUES (1637, 3471, 2, 'Modersmål/tolkspråk Lista');
INSERT INTO `lang_definitions` VALUES (1638, 3474, 2, 'ETIN');
INSERT INTO `lang_definitions` VALUES (1639, 3477, 2, 'Händelse');
INSERT INTO `lang_definitions` VALUES (1640, 3478, 2, 'Händelse Begins');
INSERT INTO `lang_definitions` VALUES (1641, 3479, 2, 'Händelse Kategori');
INSERT INTO `lang_definitions` VALUES (1642, 3480, 2, 'Händelse Datum');
INSERT INTO `lang_definitions` VALUES (1643, 3482, 2, 'Händelse, Beskrivning');
INSERT INTO `lang_definitions` VALUES (1644, 3483, 2, 'Händelse, detaljer');
INSERT INTO `lang_definitions` VALUES (1645, 3484, 2, 'Händelsen upprepas ej');
INSERT INTO `lang_definitions` VALUES (1646, 3485, 2, 'Händelse, Varaktighet');
INSERT INTO `lang_definitions` VALUES (1647, 3486, 2, 'Händelsens tid i minuter');
INSERT INTO `lang_definitions` VALUES (1648, 3487, 2, 'Händelse, Avgift');
INSERT INTO `lang_definitions` VALUES (1649, 3488, 2, 'Event Location');
INSERT INTO `lang_definitions` VALUES (1650, 3489, 2, 'Händelsen upprepas varje');
INSERT INTO `lang_definitions` VALUES (1651, 3490, 2, 'Händelsen upprepas den');
INSERT INTO `lang_definitions` VALUES (1652, 3491, 2, 'Händelse börjar timme');
INSERT INTO `lang_definitions` VALUES (1653, 3492, 2, 'Händelserubrik');
INSERT INTO `lang_definitions` VALUES (1654, 3493, 2, 'Händelserubrik');
INSERT INTO `lang_definitions` VALUES (1655, 3494, 2, 'Händelse Website');
INSERT INTO `lang_definitions` VALUES (1656, 3495, 2, 'Händelse');
INSERT INTO `lang_definitions` VALUES (1657, 3496, 2, 'Händelser för');
INSERT INTO `lang_definitions` VALUES (1658, 3497, 2, 'Händelsen öppnas i nytt fönster');
INSERT INTO `lang_definitions` VALUES (1659, 3499, 2, 'Varje');
INSERT INTO `lang_definitions` VALUES (1660, 3500, 2, 'Varje');
INSERT INTO `lang_definitions` VALUES (1661, 3502, 2, 'var 3:e timme');
INSERT INTO `lang_definitions` VALUES (1662, 3504, 2, 'var 4:e timme');
INSERT INTO `lang_definitions` VALUES (1663, 3506, 2, 'var 5:e timme');
INSERT INTO `lang_definitions` VALUES (1664, 3508, 2, 'var 6 timme');
INSERT INTO `lang_definitions` VALUES (1665, 3510, 2, 'var 8 timme');
INSERT INTO `lang_definitions` VALUES (1666, 3511, 2, 'Var fjärde');
INSERT INTO `lang_definitions` VALUES (1667, 3513, 2, 'Varannan');
INSERT INTO `lang_definitions` VALUES (1668, 3514, 2, 'Var tredje');
INSERT INTO `lang_definitions` VALUES (1669, 3515, 2, 'Varje, var andra, var 3:e, etc');
INSERT INTO `lang_definitions` VALUES (1670, 3517, 2, 'Tenta och testresultat');
INSERT INTO `lang_definitions` VALUES (1671, 3518, 2, 'Testresultat');
INSERT INTO `lang_definitions` VALUES (1672, 3522, 2, 'Examination Datum');
INSERT INTO `lang_definitions` VALUES (1673, 3528, 2, 'Exams / Tester');
INSERT INTO `lang_definitions` VALUES (1674, 3531, 2, 'Överdrivet rivande');
INSERT INTO `lang_definitions` VALUES (1675, 3539, 2, 'Motions mönster');
INSERT INTO `lang_definitions` VALUES (1676, 3540, 2, 'Övningsmönster');
INSERT INTO `lang_definitions` VALUES (1677, 3543, 2, 'lämna från Administration');
INSERT INTO `lang_definitions` VALUES (1678, 3555, 2, 'Utökad vy');
INSERT INTO `lang_definitions` VALUES (1679, 3556, 2, 'Förväntad form_mötes.pid att');
INSERT INTO `lang_definitions` VALUES (1680, 3557, 2, 'Utgångsdatum');
INSERT INTO `lang_definitions` VALUES (1681, 3558, 2, 'Utgångsdatum');
INSERT INTO `lang_definitions` VALUES (1682, 3559, 2, 'Förfaller');
INSERT INTO `lang_definitions` VALUES (1683, 3561, 2, 'Exportera');
INSERT INTO `lang_definitions` VALUES (1684, 3562, 2, 'Exportera som CSV');
INSERT INTO `lang_definitions` VALUES (1685, 3574, 2, 'Exportera till CSV');
INSERT INTO `lang_definitions` VALUES (1686, 3575, 2, 'Exportera till externa faktureringssystem');
INSERT INTO `lang_definitions` VALUES (1687, 3577, 2, 'Exponering för andra länder');
INSERT INTO `lang_definitions` VALUES (1688, 3594, 2, 'Extern remiss');
INSERT INTO `lang_definitions` VALUES (1689, 3596, 2, 'Extern remiss?');
INSERT INTO `lang_definitions` VALUES (1690, 3597, 2, 'Externa remisser');
INSERT INTO `lang_definitions` VALUES (1691, 3624, 2, 'F');
INSERT INTO `lang_definitions` VALUES (1692, 3627, 2, 'Kliniker');
INSERT INTO `lang_definitions` VALUES (1693, 3628, 2, 'Klinik');
INSERT INTO `lang_definitions` VALUES (1694, 3629, 2, 'klinik');
INSERT INTO `lang_definitions` VALUES (1695, 3630, 2, 'Klinikadm');
INSERT INTO `lang_definitions` VALUES (1696, 3632, 2, 'Klinikkod');
INSERT INTO `lang_definitions` VALUES (1697, 3638, 2, 'Klinik NPI');
INSERT INTO `lang_definitions` VALUES (1698, 3647, 2, 'Klinik:');
INSERT INTO `lang_definitions` VALUES (1699, 3650, 2, 'Misslyckades');
INSERT INTO `lang_definitions` VALUES (1700, 3671, 2, 'Familjehistoria');
INSERT INTO `lang_definitions` VALUES (1701, 3674, 2, 'Familjehistoria:');
INSERT INTO `lang_definitions` VALUES (1702, 3677, 2, 'Familj Storlek');
INSERT INTO `lang_definitions` VALUES (1703, 3683, 2, 'Fader');
INSERT INTO `lang_definitions` VALUES (1704, 3686, 2, 'Fatigue');
INSERT INTO `lang_definitions` VALUES (1705, 3688, 2, 'Fax');
INSERT INTO `lang_definitions` VALUES (1706, 3693, 2, 'Fax in');
INSERT INTO `lang_definitions` VALUES (1707, 3694, 2, 'Fax ut');
INSERT INTO `lang_definitions` VALUES (1708, 3697, 2, 'Februari');
INSERT INTO `lang_definitions` VALUES (1709, 3699, 2, 'Läkemedel ID');
INSERT INTO `lang_definitions` VALUES (1710, 3701, 2, 'Skatt ID');
INSERT INTO `lang_definitions` VALUES (1711, 3703, 2, 'Avgift');
INSERT INTO `lang_definitions` VALUES (1712, 3704, 2, 'avgift');
INSERT INTO `lang_definitions` VALUES (1713, 3706, 2, 'Avgift blankett');
INSERT INTO `lang_definitions` VALUES (1714, 3709, 2, 'Avgifter');
INSERT INTO `lang_definitions` VALUES (1715, 3710, 2, 'Kvinna');
INSERT INTO `lang_definitions` VALUES (1716, 3712, 2, 'Kvinnliga Kondomer');
INSERT INTO `lang_definitions` VALUES (1717, 3717, 2, 'Kvinna VSC');
INSERT INTO `lang_definitions` VALUES (1718, 3720, 2, 'Feber');
INSERT INTO `lang_definitions` VALUES (1719, 3721, 2, 'Feber:');
INSERT INTO `lang_definitions` VALUES (1720, 3758, 2, 'Filnamn');
INSERT INTO `lang_definitions` VALUES (1721, 3767, 2, 'Fyll här endast om du skickar e-postmeddelande till patienter');
INSERT INTO `lang_definitions` VALUES (1722, 3785, 2, 'Filter');
INSERT INTO `lang_definitions` VALUES (1723, 3788, 2, 'Slutgiltig diagnos');
INSERT INTO `lang_definitions` VALUES (1724, 3789, 2, 'Slutgiltig diagnos av specialist');
INSERT INTO `lang_definitions` VALUES (1725, 3791, 2, 'Finansiella');
INSERT INTO `lang_definitions` VALUES (1726, 3798, 2, 'Financial Review Datum');
INSERT INTO `lang_definitions` VALUES (1727, 3801, 2, 'Hitta');
INSERT INTO `lang_definitions` VALUES (1728, 3802, 2, 'Hitta Ledig');
INSERT INTO `lang_definitions` VALUES (1729, 3803, 2, 'Sök Ledig mötestider');
INSERT INTO `lang_definitions` VALUES (1730, 3804, 2, 'Hitta Patientient');
INSERT INTO `lang_definitions` VALUES (1731, 3807, 2, 'Undersökningsresultat');
INSERT INTO `lang_definitions` VALUES (1732, 3808, 2, 'Undersökningsresultat av specialist');
INSERT INTO `lang_definitions` VALUES (1733, 3809, 2, 'Fin');
INSERT INTO `lang_definitions` VALUES (1734, 3815, 2, 'Första');
INSERT INTO `lang_definitions` VALUES (1735, 3818, 2, 'Första dagen i veckan');
INSERT INTO `lang_definitions` VALUES (1736, 3821, 2, 'Förnamn');
INSERT INTO `lang_definitions` VALUES (1737, 3823, 2, 'Förnamn:');
INSERT INTO `lang_definitions` VALUES (1738, 3828, 2, 'Fitness');
INSERT INTO `lang_definitions` VALUES (1739, 3832, 2, 'Fitness att spela');
INSERT INTO `lang_definitions` VALUES (1740, 3858, 2, 'Influensavaccination');
INSERT INTO `lang_definitions` VALUES (1741, 3859, 2, 'Vätske-och elektrolyt problem');
INSERT INTO `lang_definitions` VALUES (1742, 3862, 2, 'Följa manuellt');
INSERT INTO `lang_definitions` VALUES (1743, 3877, 2, 'Fot');
INSERT INTO `lang_definitions` VALUES (1744, 3878, 2, 'Fotproblem');
INSERT INTO `lang_definitions` VALUES (1745, 3879, 2, 'Fot:');
INSERT INTO `lang_definitions` VALUES (1746, 3882, 2, 'Fotboll Skaderapport');
INSERT INTO `lang_definitions` VALUES (1747, 3883, 2, 'Skotyp');
INSERT INTO `lang_definitions` VALUES (1748, 3884, 2, 'för');
INSERT INTO `lang_definitions` VALUES (1749, 3935, 2, 'för:');
INSERT INTO `lang_definitions` VALUES (1750, 3939, 2, 'Underarm');
INSERT INTO `lang_definitions` VALUES (1751, 3940, 2, 'Formulär');
INSERT INTO `lang_definitions` VALUES (1752, 3945, 2, 'Format');
INSERT INTO `lang_definitions` VALUES (1753, 3948, 2, 'Format felaktigt för NDC');
INSERT INTO `lang_definitions` VALUES (1754, 3953, 2, 'Formulär');
INSERT INTO `lang_definitions` VALUES (1755, 3954, 2, 'Formulär administration');
INSERT INTO `lang_definitions` VALUES (1756, 3962, 2, 'Vidarebefordra Sidor via Fax');
INSERT INTO `lang_definitions` VALUES (1757, 3967, 2, 'Fjärde');
INSERT INTO `lang_definitions` VALUES (1758, 3969, 2, 'Fraktur');
INSERT INTO `lang_definitions` VALUES (1759, 3970, 2, 'Fracture på Navicula');
INSERT INTO `lang_definitions` VALUES (1760, 3971, 2, 'Fracture laterala malleolus');
INSERT INTO `lang_definitions` VALUES (1761, 3972, 2, 'Fracture mediala malleolus');
INSERT INTO `lang_definitions` VALUES (1762, 3983, 2, 'Fre');
INSERT INTO `lang_definitions` VALUES (1763, 3984, 2, 'Fredag');
INSERT INTO `lang_definitions` VALUES (1764, 3986, 2, 'Från');
INSERT INTO `lang_definitions` VALUES (1765, 3994, 2, 'Från:');
INSERT INTO `lang_definitions` VALUES (1766, 3995, 2, 'Från:');
INSERT INTO `lang_definitions` VALUES (1767, 4008, 2, 'Reception');
INSERT INTO `lang_definitions` VALUES (1768, 4009, 2, 'Reception, kvitton');
INSERT INTO `lang_definitions` VALUES (1769, 4010, 2, 'Reception, kvitton, rapport');
INSERT INTO `lang_definitions` VALUES (1770, 4012, 2, 'Frontal Höger:');
INSERT INTO `lang_definitions` VALUES (1771, 4026, 2, 'All utbildning');
INSERT INTO `lang_definitions` VALUES (1772, 4043, 2, 'Gallsten');
INSERT INTO `lang_definitions` VALUES (1773, 4044, 2, 'Game Period');
INSERT INTO `lang_definitions` VALUES (1774, 4045, 2, 'Spel');
INSERT INTO `lang_definitions` VALUES (1775, 4047, 2, 'spel / evenemang');
INSERT INTO `lang_definitions` VALUES (1776, 4050, 2, 'Gastrit');
INSERT INTO `lang_definitions` VALUES (1777, 4052, 2, 'Gastrointestinala');
INSERT INTO `lang_definitions` VALUES (1778, 4056, 2, 'GCAC Statistik Rapport');
INSERT INTO `lang_definitions` VALUES (1779, 4060, 2, 'Kön');
INSERT INTO `lang_definitions` VALUES (1780, 4061, 2, 'Allmänt');
INSERT INTO `lang_definitions` VALUES (1781, 4065, 2, 'Allmänna Tjänstekategori');
INSERT INTO `lang_definitions` VALUES (1782, 4074, 2, 'Skapa och hämta HCFA 1500 papper fordringar');
INSERT INTO `lang_definitions` VALUES (1783, 4077, 2, 'Skapa och hämta X12 parti');
INSERT INTO `lang_definitions` VALUES (1784, 4089, 2, 'Generera Skrivelse angående');
INSERT INTO `lang_definitions` VALUES (1785, 4097, 2, 'Generera rapport');
INSERT INTO `lang_definitions` VALUES (1786, 4110, 2, 'Skapad på');
INSERT INTO `lang_definitions` VALUES (1787, 4112, 2, 'Genererar');
INSERT INTO `lang_definitions` VALUES (1788, 4132, 2, 'Glaukom');
INSERT INTO `lang_definitions` VALUES (1789, 4135, 2, 'Global');
INSERT INTO `lang_definitions` VALUES (1790, 4142, 2, 'gå');
INSERT INTO `lang_definitions` VALUES (1791, 4144, 2, 'Gå');
INSERT INTO `lang_definitions` VALUES (1792, 4167, 2, 'Grad:');
INSERT INTO `lang_definitions` VALUES (1793, 4169, 2, 'Totalsumma');
INSERT INTO `lang_definitions` VALUES (1794, 4170, 2, 'Totalsummor');
INSERT INTO `lang_definitions` VALUES (1795, 4180, 2, 'Grupp');
INSERT INTO `lang_definitions` VALUES (1796, 4201, 2, 'Gruppnummer');
INSERT INTO `lang_definitions` VALUES (1797, 4209, 2, 'Grupp:');
INSERT INTO `lang_definitions` VALUES (1798, 4210, 2, 'Gruppnamn');
INSERT INTO `lang_definitions` VALUES (1799, 4213, 2, 'Grupper och åtkomstkontroller');
INSERT INTO `lang_definitions` VALUES (1800, 4216, 2, 'Droppar');
INSERT INTO `lang_definitions` VALUES (1801, 4233, 2, 'Hematom / blåmärken');
INSERT INTO `lang_definitions` VALUES (1802, 4237, 2, 'Hand + fingrar');
INSERT INTO `lang_definitions` VALUES (1803, 4238, 2, 'Handproblem');
INSERT INTO `lang_definitions` VALUES (1804, 4244, 2, 'Umbäranden w / o');
INSERT INTO `lang_definitions` VALUES (1805, 4253, 2, 'Farliga aktiviteter');
INSERT INTO `lang_definitions` VALUES (1806, 4263, 2, 'han PostCalendar');
INSERT INTO `lang_definitions` VALUES (1807, 4264, 2, 'Huvud');
INSERT INTO `lang_definitions` VALUES (1808, 4268, 2, 'Huvudvärk');
INSERT INTO `lang_definitions` VALUES (1809, 4279, 2, 'Heart Attack');
INSERT INTO `lang_definitions` VALUES (1810, 4281, 2, 'Hjärtsvikt');
INSERT INTO `lang_definitions` VALUES (1811, 4283, 2, 'Hjärtproblem');
INSERT INTO `lang_definitions` VALUES (1812, 4284, 2, 'Hjärtkirurgi');
INSERT INTO `lang_definitions` VALUES (1813, 4285, 2, 'Heart Transplant');
INSERT INTO `lang_definitions` VALUES (1814, 4286, 2, 'Heart:');
INSERT INTO `lang_definitions` VALUES (1815, 4294, 2, 'Längd');
INSERT INTO `lang_definitions` VALUES (1816, 4296, 2, 'Hjälp');
INSERT INTO `lang_definitions` VALUES (1817, 4297, 2, 'hjälp');
INSERT INTO `lang_definitions` VALUES (1818, 4303, 2, 'Hemoglobin');
INSERT INTO `lang_definitions` VALUES (1819, 4306, 2, 'Hepatit');
INSERT INTO `lang_definitions` VALUES (1820, 4315, 2, 'Bråck Reparation');
INSERT INTO `lang_definitions` VALUES (1821, 4316, 2, 'Diskbråck');
INSERT INTO `lang_definitions` VALUES (1822, 4317, 2, 'Herpes');
INSERT INTO `lang_definitions` VALUES (1823, 4321, 2, 'heyyo. du har varit här i');
INSERT INTO `lang_definitions` VALUES (1824, 4326, 2, 'Dolda');
INSERT INTO `lang_definitions` VALUES (1825, 4327, 2, 'Dolda Händelser Administration');
INSERT INTO `lang_definitions` VALUES (1826, 4328, 2, 'Gömma');
INSERT INTO `lang_definitions` VALUES (1827, 4330, 2, 'Dölj detaljer');
INSERT INTO `lang_definitions` VALUES (1828, 4334, 2, 'Göm meny');
INSERT INTO `lang_definitions` VALUES (1829, 4336, 2, 'Göm påminnelser');
INSERT INTO `lang_definitions` VALUES (1830, 4338, 2, 'Göm/Visa kolumner');
INSERT INTO `lang_definitions` VALUES (1831, 4340, 2, 'Hög');
INSERT INTO `lang_definitions` VALUES (1832, 4342, 2, 'Högt blodtryck');
INSERT INTO `lang_definitions` VALUES (1833, 4344, 2, 'Höft + ljumske');
INSERT INTO `lang_definitions` VALUES (1834, 4345, 2, 'Höft och ljumske');
INSERT INTO `lang_definitions` VALUES (1835, 4346, 2, 'Hip Problem');
INSERT INTO `lang_definitions` VALUES (1836, 4347, 2, 'Höftledsplastik');
INSERT INTO `lang_definitions` VALUES (1837, 4349, 2, 'Ej Tilldelad');
INSERT INTO `lang_definitions` VALUES (1838, 4352, 2, 'Spansktalande');
INSERT INTO `lang_definitions` VALUES (1839, 4357, 2, 'Historia');
INSERT INTO `lang_definitions` VALUES (1840, 4363, 2, 'Historikdata');
INSERT INTO `lang_definitions` VALUES (1841, 4387, 2, 'Håll ner [Ctrl] för flera val eller avmarkera');
INSERT INTO `lang_definitions` VALUES (1842, 4389, 2, 'Håll ned Ctrl för att välja flera objekt');
INSERT INTO `lang_definitions` VALUES (1843, 4390, 2, 'Håll ned Ctrl för att välja flera patruller');
INSERT INTO `lang_definitions` VALUES (1844, 4392, 2, 'Hem');
INSERT INTO `lang_definitions` VALUES (1845, 4393, 2, 'Hemtelefon');
INSERT INTO `lang_definitions` VALUES (1846, 4396, 2, 'Hemlös eller liknande?');
INSERT INTO `lang_definitions` VALUES (1847, 4398, 2, 'Hemlös');
INSERT INTO `lang_definitions` VALUES (1848, 4399, 2, 'Hemlös');
INSERT INTO `lang_definitions` VALUES (1849, 4412, 2, 'Timmar');
INSERT INTO `lang_definitions` VALUES (1850, 4415, 2, 'Hur uppstod skadan?');
INSERT INTO `lang_definitions` VALUES (1851, 4416, 2, 'Hur uppstod skadan?:');
INSERT INTO `lang_definitions` VALUES (1852, 4419, 2, 'Hur många månader att fråga efter kommande evenemang?');
INSERT INTO `lang_definitions` VALUES (1853, 4440, 2, 'Hyperaktiv');
INSERT INTO `lang_definitions` VALUES (1854, 4445, 2, 'Hyperthyroidism');
INSERT INTO `lang_definitions` VALUES (1855, 4447, 2, 'Hypotyreoidism');
INSERT INTO `lang_definitions` VALUES (1856, 4450, 2, 'Hysterektomi');
INSERT INTO `lang_definitions` VALUES (1857, 4452, 2, 'Jag är upptagen under denna tid.');
INSERT INTO `lang_definitions` VALUES (1858, 4453, 2, 'Jag har inte behörighet att läsa');
INSERT INTO `lang_definitions` VALUES (1859, 4477, 2, 'Identifierare (ett ord)');
INSERT INTO `lang_definitions` VALUES (1860, 4487, 2, 'Om alla uppgifter för alla kolumner är komplett för denna form');
INSERT INTO `lang_definitions` VALUES (1861, 4495, 2, 'Om namn, någon del av efternamn eller efternamn, förnamn');
INSERT INTO `lang_definitions` VALUES (1862, 4501, 2, 'Om personen avlidit ange dödsdatum');
INSERT INTO `lang_definitions` VALUES (1863, 4533, 2, 'om arbetslösa lägg till student');
INSERT INTO `lang_definitions` VALUES (1864, 4578, 2, 'Om du vill ändra datatyper, lägg till rader eller kolumner');
INSERT INTO `lang_definitions` VALUES (1865, 4584, 2, 'Sjukdom');
INSERT INTO `lang_definitions` VALUES (1866, 4593, 2, 'Vaccinering');
INSERT INTO `lang_definitions` VALUES (1867, 4600, 2, 'Vaccin, Lotnummer');
INSERT INTO `lang_definitions` VALUES (1868, 4601, 2, 'Vaccin, tillverkare');
INSERT INTO `lang_definitions` VALUES (1869, 4613, 2, 'Vaccineringar');
INSERT INTO `lang_definitions` VALUES (1870, 4615, 2, 'Vaccinera');
INSERT INTO `lang_definitions` VALUES (1871, 4619, 2, 'Implantat');
INSERT INTO `lang_definitions` VALUES (1872, 4620, 2, 'Importera');
INSERT INTO `lang_definitions` VALUES (1873, 4630, 2, 'Importera patient');
INSERT INTO `lang_definitions` VALUES (1874, 4631, 2, 'Importera Patientdemografi');
INSERT INTO `lang_definitions` VALUES (1875, 4640, 2, 'Importerad från Accounting');
INSERT INTO `lang_definitions` VALUES (1876, 4646, 2, 'förbättrad');
INSERT INTO `lang_definitions` VALUES (1877, 4648, 2, 'i');
INSERT INTO `lang_definitions` VALUES (1878, 4657, 2, 'i båda ögonen');
INSERT INTO `lang_definitions` VALUES (1879, 4660, 2, 'i vänster öga');
INSERT INTO `lang_definitions` VALUES (1880, 4661, 2, 'i näsborre');
INSERT INTO `lang_definitions` VALUES (1881, 4662, 2, 'Arbetar');
INSERT INTO `lang_definitions` VALUES (1882, 4673, 2, 'i höger öga');
INSERT INTO `lang_definitions` VALUES (1883, 4691, 2, 'Inaktiv Dagar');
INSERT INTO `lang_definitions` VALUES (1884, 4702, 2, 'Inkludera mätväden');
INSERT INTO `lang_definitions` VALUES (1885, 4707, 2, 'Inkomst');
INSERT INTO `lang_definitions` VALUES (1886, 4715, 2, 'ökat:');
INSERT INTO `lang_definitions` VALUES (1887, 4716, 2, 'Ansvarsförsäkring');
INSERT INTO `lang_definitions` VALUES (1888, 4719, 2, 'Obestämd');
INSERT INTO `lang_definitions` VALUES (1889, 4725, 2, 'Indikerar om detta problem/frågeställning är aktiv');
INSERT INTO `lang_definitions` VALUES (1890, 4729, 2, 'Hjälpbehövande Patienter Rapport');
INSERT INTO `lang_definitions` VALUES (1891, 4738, 2, 'Infektion / Abscess');
INSERT INTO `lang_definitions` VALUES (1892, 4739, 2, 'Infektioner');
INSERT INTO `lang_definitions` VALUES (1893, 4740, 2, 'Infert Couns');
INSERT INTO `lang_definitions` VALUES (1894, 4747, 2, 'Info');
INSERT INTO `lang_definitions` VALUES (1895, 4748, 2, 'Info test 1');
INSERT INTO `lang_definitions` VALUES (1896, 4749, 2, 'Info test 2');
INSERT INTO `lang_definitions` VALUES (1897, 4750, 2, 'Info test 3');
INSERT INTO `lang_definitions` VALUES (1898, 4751, 2, 'Info test 4');
INSERT INTO `lang_definitions` VALUES (1899, 4752, 2, 'Info test 5');
INSERT INTO `lang_definitions` VALUES (1900, 4753, 2, 'Info test 6');
INSERT INTO `lang_definitions` VALUES (1901, 4758, 2, 'inhalation');
INSERT INTO `lang_definitions` VALUES (1902, 4760, 2, 'inhalationer');
INSERT INTO `lang_definitions` VALUES (1903, 4763, 2, 'Ursprunglig användare');
INSERT INTO `lang_definitions` VALUES (1904, 4766, 2, 'Injeserbara');
INSERT INTO `lang_definitions` VALUES (1905, 4769, 2, 'Skadade ut');
INSERT INTO `lang_definitions` VALUES (1906, 4771, 2, 'Skademekanism');
INSERT INTO `lang_definitions` VALUES (1907, 4772, 2, 'Skada, översiktsrapport');
INSERT INTO `lang_definitions` VALUES (1908, 4774, 2, 'Skada Typ');
INSERT INTO `lang_definitions` VALUES (1909, 4780, 2, 'Inmatningsfält');
INSERT INTO `lang_definitions` VALUES (1910, 4785, 2, 'Ins justera');
INSERT INTO `lang_definitions` VALUES (1911, 4786, 2, 'Ins paketering');
INSERT INTO `lang_definitions` VALUES (1912, 4790, 2, 'Ins överskjutande');
INSERT INTO `lang_definitions` VALUES (1913, 4792, 2, 'Ins återbetalning');
INSERT INTO `lang_definitions` VALUES (1914, 4793, 2, 'Ins Sammering');
INSERT INTO `lang_definitions` VALUES (1915, 4795, 2, 'Ins1');
INSERT INTO `lang_definitions` VALUES (1916, 4796, 2, 'Ins2');
INSERT INTO `lang_definitions` VALUES (1917, 4797, 2, 'Ins3');
INSERT INTO `lang_definitions` VALUES (1918, 4799, 2, 'isättning misslyckades:');
INSERT INTO `lang_definitions` VALUES (1919, 4803, 2, 'Sätt gamla händelser i tabeller');
INSERT INTO `lang_definitions` VALUES (1920, 4809, 2, 'Insomnia');
INSERT INTO `lang_definitions` VALUES (1921, 4811, 2, 'Inspektion');
INSERT INTO `lang_definitions` VALUES (1922, 4812, 2, 'Instabilitet / subluxation');
INSERT INTO `lang_definitions` VALUES (1923, 4816, 2, 'installera DB');
INSERT INTO `lang_definitions` VALUES (1924, 4823, 2, 'Instruerad');
INSERT INTO `lang_definitions` VALUES (1925, 4826, 2, 'Instruktioner:');
INSERT INTO `lang_definitions` VALUES (1926, 4829, 2, 'Insulinberoende diabetiker');
INSERT INTO `lang_definitions` VALUES (1927, 4830, 2, 'Försäkring');
INSERT INTO `lang_definitions` VALUES (1928, 4831, 2, 'försäkring');
INSERT INTO `lang_definitions` VALUES (1929, 4838, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1930, 4839, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1931, 4840, 2, 'Försäkringsbolag Sök / Köp');
INSERT INTO `lang_definitions` VALUES (1932, 4842, 2, 'Försäkring Data');
INSERT INTO `lang_definitions` VALUES (1933, 4847, 2, 'Försäkring Number');
INSERT INTO `lang_definitions` VALUES (1934, 4850, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1935, 4870, 2, 'Internt fel - inga sidor valdes!');
INSERT INTO `lang_definitions` VALUES (1936, 4871, 2, 'Internt fel - patient-ID fanns inte!');
INSERT INTO `lang_definitions` VALUES (1937, 4874, 2, 'Internt fel!');
INSERT INTO `lang_definitions` VALUES (1938, 4877, 2, 'Internt fel: påstående');
INSERT INTO `lang_definitions` VALUES (1939, 4878, 2, 'Internt fel: möter\"');
INSERT INTO `lang_definitions` VALUES (1940, 4884, 2, 'Inre Övergångar');
INSERT INTO `lang_definitions` VALUES (1941, 4888, 2, 'Tolk');
INSERT INTO `lang_definitions` VALUES (1942, 4890, 2, 'Interstitiell lungsjukdom');
INSERT INTO `lang_definitions` VALUES (1943, 4891, 2, 'Interval');
INSERT INTO `lang_definitions` VALUES (1944, 4896, 2, 'Intolerans');
INSERT INTO `lang_definitions` VALUES (1945, 4899, 2, 'intramuskulärt');
INSERT INTO `lang_definitions` VALUES (1946, 4902, 2, 'intravenöst');
INSERT INTO `lang_definitions` VALUES (1947, 4903, 2, 'Introduktion');
INSERT INTO `lang_definitions` VALUES (1948, 4916, 2, 'Ogiltig eller saknas betalaren i källan för kod');
INSERT INTO `lang_definitions` VALUES (1949, 4919, 2, 'Ogiltig Service Kod');
INSERT INTO `lang_definitions` VALUES (1950, 4920, 2, 'Ogiltig källdestination\"');
INSERT INTO `lang_definitions` VALUES (1951, 4924, 2, 'Inventering');
INSERT INTO `lang_definitions` VALUES (1952, 4928, 2, 'Inventering är inte tillgänglig för denna beställning.');
INSERT INTO `lang_definitions` VALUES (1953, 4929, 2, 'Inventeringslista');
INSERT INTO `lang_definitions` VALUES (1954, 4931, 2, 'Faktura');
INSERT INTO `lang_definitions` VALUES (1955, 4932, 2, 'faktura');
INSERT INTO `lang_definitions` VALUES (1956, 4936, 2, 'Fakturadatum');
INSERT INTO `lang_definitions` VALUES (1957, 4938, 2, 'Fakturanhar inget datum!');
INSERT INTO `lang_definitions` VALUES (1958, 4945, 2, 'Faktura:');
INSERT INTO `lang_definitions` VALUES (1959, 4968, 2, 'Oregelbunden hjärtrytm');
INSERT INTO `lang_definitions` VALUES (1960, 4969, 2, 'Retlighet');
INSERT INTO `lang_definitions` VALUES (1961, 4970, 2, 'Irritation');
INSERT INTO `lang_definitions` VALUES (1962, 4975, 2, 'är ett obligatoriskt fält.');
INSERT INTO `lang_definitions` VALUES (1963, 4984, 2, 'inte är giltig (decimalbråk är OK).');
INSERT INTO `lang_definitions` VALUES (1964, 4985, 2, 'Är PHP använder felsäkert läge?');
INSERT INTO `lang_definitions` VALUES (1965, 5004, 2, 'Frågeställning');
INSERT INTO `lang_definitions` VALUES (1966, 5005, 2, 'frågeställning');
INSERT INTO `lang_definitions` VALUES (1967, 5012, 2, 'Aktuellt');
INSERT INTO `lang_definitions` VALUES (1968, 5014, 2, 'Aktuellt (Problem / Medicin / Allergi):');
INSERT INTO `lang_definitions` VALUES (1969, 5016, 2, 'Information och Patientmöten');
INSERT INTO `lang_definitions` VALUES (1970, 5017, 2, 'Information och möten för');
INSERT INTO `lang_definitions` VALUES (1971, 5022, 2, 'Problematik, ej behörig');
INSERT INTO `lang_definitions` VALUES (1972, 5023, 2, 'Frågeställningssektion');
INSERT INTO `lang_definitions` VALUES (1973, 5078, 2, 'Artikel');
INSERT INTO `lang_definitions` VALUES (1974, 5079, 2, 'artikel');
INSERT INTO `lang_definitions` VALUES (1975, 5082, 2, 'Poster laddades inte');
INSERT INTO `lang_definitions` VALUES (1976, 5089, 2, 'Januari');
INSERT INTO `lang_definitions` VALUES (1977, 5093, 2, 'Jobb-beskrivning');
INSERT INTO `lang_definitions` VALUES (1978, 5094, 2, 'Jobb id');
INSERT INTO `lang_definitions` VALUES (1979, 5095, 2, 'Led dislokation');
INSERT INTO `lang_definitions` VALUES (1980, 5096, 2, 'Led smärta');
INSERT INTO `lang_definitions` VALUES (1981, 5097, 2, 'Led vrickning');
INSERT INTO `lang_definitions` VALUES (1982, 5099, 2, 'Juli');
INSERT INTO `lang_definitions` VALUES (1983, 5102, 2, 'Juni');
INSERT INTO `lang_definitions` VALUES (1984, 5104, 2, 'Bara min');
INSERT INTO `lang_definitions` VALUES (1985, 5106, 2, 'Motivera');
INSERT INTO `lang_definitions` VALUES (1986, 5109, 2, 'Motivera / Spara');
INSERT INTO `lang_definitions` VALUES (1987, 5111, 2, 'k, här är resten');
INSERT INTO `lang_definitions` VALUES (1988, 5124, 2, 'Nyckelord');
INSERT INTO `lang_definitions` VALUES (1989, 5128, 2, 'Njurcancer');
INSERT INTO `lang_definitions` VALUES (1990, 5129, 2, 'Njursvikt');
INSERT INTO `lang_definitions` VALUES (1991, 5130, 2, 'Njure Infektioner');
INSERT INTO `lang_definitions` VALUES (1992, 5131, 2, 'Njursten');
INSERT INTO `lang_definitions` VALUES (1993, 5132, 2, 'Njurtransplantation');
INSERT INTO `lang_definitions` VALUES (1994, 5138, 2, 'Knä');
INSERT INTO `lang_definitions` VALUES (1995, 5139, 2, 'Knä Problem');
INSERT INTO `lang_definitions` VALUES (1996, 5140, 2, 'Knä Ersättning /protes');
INSERT INTO `lang_definitions` VALUES (1997, 5147, 2, 'Lab');
INSERT INTO `lang_definitions` VALUES (1998, 5157, 2, 'Lab Rapport');
INSERT INTO `lang_definitions` VALUES (1999, 5166, 2, 'Etikett');
INSERT INTO `lang_definitions` VALUES (2000, 5168, 2, 'Label Cols');
INSERT INTO `lang_definitions` VALUES (2001, 5172, 2, 'Etiketter');
INSERT INTO `lang_definitions` VALUES (2002, 5176, 2, 'Labs');
INSERT INTO `lang_definitions` VALUES (2003, 5177, 2, 'Laceration / hudkodition');
INSERT INTO `lang_definitions` VALUES (2004, 5178, 2, 'Laceration / nötning');
INSERT INTO `lang_definitions` VALUES (2005, 5183, 2, 'Språk');
INSERT INTO `lang_definitions` VALUES (2006, 5184, 2, 'Språk-kod');
INSERT INTO `lang_definitions` VALUES (2007, 5185, 2, 'Språk definition tillagd');
INSERT INTO `lang_definitions` VALUES (2008, 5190, 2, 'Språknamn');
INSERT INTO `lang_definitions` VALUES (2009, 5191, 2, 'Språk:');
INSERT INTO `lang_definitions` VALUES (2010, 5197, 2, 'Sist');
INSERT INTO `lang_definitions` VALUES (2011, 5198, 2, 'Datum för senaste aktivitet');
INSERT INTO `lang_definitions` VALUES (2012, 5200, 2, 'Sista betalnings dag på faktura:');
INSERT INTO `lang_definitions` VALUES (2013, 5206, 2, 'Senaste patientmötet');
INSERT INTO `lang_definitions` VALUES (2014, 5218, 2, 'Efternamn');
INSERT INTO `lang_definitions` VALUES (2015, 5219, 2, 'Efternamn');
INSERT INTO `lang_definitions` VALUES (2016, 5224, 2, 'Efternamn:');
INSERT INTO `lang_definitions` VALUES (2017, 5230, 2, 'Senast sparad');
INSERT INTO `lang_definitions` VALUES (2018, 5236, 2, 'Senast uppdaterad av');
INSERT INTO `lang_definitions` VALUES (2019, 5238, 2, 'Senaste besöket');
INSERT INTO `lang_definitions` VALUES (2020, 5240, 2, 'Sen Återkommande (2-12 mån)');
INSERT INTO `lang_definitions` VALUES (2021, 5245, 2, 'sidled fördrivna PMI:');
INSERT INTO `lang_definitions` VALUES (2022, 5259, 2, 'Layout Editor');
INSERT INTO `lang_definitions` VALUES (2023, 5266, 2, 'Layouter');
INSERT INTO `lang_definitions` VALUES (2024, 5275, 2, 'LDL');
INSERT INTO `lang_definitions` VALUES (2025, 5277, 2, 'lämna tom om fortfarande aktiv');
INSERT INTO `lang_definitions` VALUES (2026, 5279, 2, 'Lämna tomt för att hålla lösenord oförändrad.');
INSERT INTO `lang_definitions` VALUES (2027, 5284, 2, 'Kontakt via');
INSERT INTO `lang_definitions` VALUES (2028, 5286, 2, 'Lämna Form');
INSERT INTO `lang_definitions` VALUES (2029, 5290, 2, 'Vänster');
INSERT INTO `lang_definitions` VALUES (2030, 5293, 2, 'vänster öra');
INSERT INTO `lang_definitions` VALUES (2031, 5294, 2, 'vänster öra');
INSERT INTO `lang_definitions` VALUES (2032, 5302, 2, 'Vänster:');
INSERT INTO `lang_definitions` VALUES (2033, 5303, 2, 'Vänster:');
INSERT INTO `lang_definitions` VALUES (2034, 5304, 2, 'Ben smärta / Kramper');
INSERT INTO `lang_definitions` VALUES (2035, 5305, 2, 'Rättsärenden');
INSERT INTO `lang_definitions` VALUES (2036, 5308, 2, 'Förklaring:');
INSERT INTO `lang_definitions` VALUES (2037, 5309, 2, 'Längd');
INSERT INTO `lang_definitions` VALUES (2038, 5323, 2, 'Brev');
INSERT INTO `lang_definitions` VALUES (2039, 5324, 2, 'Brevgenerator');
INSERT INTO `lang_definitions` VALUES (2040, 5333, 2, 'Ansvar');
INSERT INTO `lang_definitions` VALUES (2041, 5334, 2, 'Ansvar för medicinskt');
INSERT INTO `lang_definitions` VALUES (2042, 5336, 2, 'passnr');
INSERT INTO `lang_definitions` VALUES (2043, 5347, 2, 'Livsstil');
INSERT INTO `lang_definitions` VALUES (2044, 5350, 2, 'Ligament skada eller vrickning');
INSERT INTO `lang_definitions` VALUES (2045, 5354, 2, 'Begränsning av händelser');
INSERT INTO `lang_definitions` VALUES (2046, 5368, 2, 'Förteckning');
INSERT INTO `lang_definitions` VALUES (2047, 5373, 2, 'List Editor');
INSERT INTO `lang_definitions` VALUES (2048, 5376, 2, 'Lista Insurance Companies');
INSERT INTO `lang_definitions` VALUES (2049, 5381, 2, 'Lista listor');
INSERT INTO `lang_definitions` VALUES (2050, 5383, 2, 'Lista Namn');
INSERT INTO `lang_definitions` VALUES (2051, 5389, 2, 'Lista recept');
INSERT INTO `lang_definitions` VALUES (2052, 5394, 2, 'Listor');
INSERT INTO `lang_definitions` VALUES (2053, 5409, 2, 'Ladda definitioner');
INSERT INTO `lang_definitions` VALUES (2054, 5415, 2, 'Laddar');
INSERT INTO `lang_definitions` VALUES (2055, 5422, 2, 'Lokalt');
INSERT INTO `lang_definitions` VALUES (2056, 5427, 2, 'Lokalitet');
INSERT INTO `lang_definitions` VALUES (2057, 5428, 2, 'Lokalisation');
INSERT INTO `lang_definitions` VALUES (2058, 5431, 2, 'Lokalisation ospecificerad');
INSERT INTO `lang_definitions` VALUES (2059, 5434, 2, 'Lokalisation');
INSERT INTO `lang_definitions` VALUES (2060, 5446, 2, 'Inloggad');
INSERT INTO `lang_definitions` VALUES (2061, 5447, 2, 'Inloggad som');
INSERT INTO `lang_definitions` VALUES (2062, 5448, 2, 'Inloggad som:');
INSERT INTO `lang_definitions` VALUES (2063, 5449, 2, 'Utloggad.');
INSERT INTO `lang_definitions` VALUES (2064, 5451, 2, 'Logga in');
INSERT INTO `lang_definitions` VALUES (2065, 5452, 2, 'logga in');
INSERT INTO `lang_definitions` VALUES (2066, 5459, 2, 'Logout');
INSERT INTO `lang_definitions` VALUES (2067, 5460, 2, 'logout');
INSERT INTO `lang_definitions` VALUES (2068, 5461, 2, 'Loggar');
INSERT INTO `lang_definitions` VALUES (2069, 5466, 2, 'Slå upp');
INSERT INTO `lang_definitions` VALUES (2070, 5467, 2, 'Batch');
INSERT INTO `lang_definitions` VALUES (2071, 5469, 2, 'Batchnummer');
INSERT INTO `lang_definitions` VALUES (2072, 5470, 2, 'låg');
INSERT INTO `lang_definitions` VALUES (2073, 5472, 2, 'Benet');
INSERT INTO `lang_definitions` VALUES (2074, 5480, 2, 'Lumbal delen av ryggraden');
INSERT INTO `lang_definitions` VALUES (2075, 5481, 2, 'LUNCH');
INSERT INTO `lang_definitions` VALUES (2076, 5482, 2, 'Lunch');
INSERT INTO `lang_definitions` VALUES (2077, 5483, 2, 'Lung Cancer');
INSERT INTO `lang_definitions` VALUES (2078, 5484, 2, 'Lung Cancer kirurgi');
INSERT INTO `lang_definitions` VALUES (2079, 5485, 2, 'Lungor:');
INSERT INTO `lang_definitions` VALUES (2080, 5486, 2, 'Lungor:');
INSERT INTO `lang_definitions` VALUES (2081, 5493, 2, 'M');
INSERT INTO `lang_definitions` VALUES (2082, 5494, 2, 'MA Kategori');
INSERT INTO `lang_definitions` VALUES (2083, 5504, 2, 'Huvudadress');
INSERT INTO `lang_definitions` VALUES (2084, 5515, 2, 'Gör ändringar i nuvarande kategorier.');
INSERT INTO `lang_definitions` VALUES (2085, 5519, 2, 'Försäkra \"');
INSERT INTO `lang_definitions` VALUES (2086, 5522, 2, 'Sjukdomskänsla:');
INSERT INTO `lang_definitions` VALUES (2087, 5525, 2, 'Man');
INSERT INTO `lang_definitions` VALUES (2088, 5526, 2, 'Manlig Kondomer');
INSERT INTO `lang_definitions` VALUES (2089, 5529, 2, 'Mammogram');
INSERT INTO `lang_definitions` VALUES (2090, 5539, 2, 'Administration');
INSERT INTO `lang_definitions` VALUES (2091, 5548, 2, 'Manuell post');
INSERT INTO `lang_definitions` VALUES (2092, 5552, 2, 'Tillverkare');
INSERT INTO `lang_definitions` VALUES (2093, 5562, 2, 'Mars');
INSERT INTO `lang_definitions` VALUES (2094, 5565, 2, 'Civilstånd');
INSERT INTO `lang_definitions` VALUES (2095, 5568, 2, 'Markera som faktureras men hoppa fakturering');
INSERT INTO `lang_definitions` VALUES (2096, 5569, 2, 'Markera som avklarad');
INSERT INTO `lang_definitions` VALUES (2097, 5570, 2, 'Markera som ej fakturerad');
INSERT INTO `lang_definitions` VALUES (2098, 5574, 2, 'Markerad som avslutad');
INSERT INTO `lang_definitions` VALUES (2099, 5575, 2, 'Gift');
INSERT INTO `lang_definitions` VALUES (2100, 5600, 2, 'Maxillary Höger:');
INSERT INTO `lang_definitions` VALUES (2101, 5612, 2, 'Maj');
INSERT INTO `lang_definitions` VALUES (2102, 5614, 2, 'MC');
INSERT INTO `lang_definitions` VALUES (2103, 5615, 2, 'mcg');
INSERT INTO `lang_definitions` VALUES (2104, 5630, 2, 'Medicinsk');
INSERT INTO `lang_definitions` VALUES (2105, 5640, 2, 'Medicinska problem');
INSERT INTO `lang_definitions` VALUES (2106, 5642, 2, 'Medicinska problem');
INSERT INTO `lang_definitions` VALUES (2107, 5644, 2, 'Journal');
INSERT INTO `lang_definitions` VALUES (2108, 5645, 2, 'Journal #');
INSERT INTO `lang_definitions` VALUES (2109, 5647, 2, 'Journaler');
INSERT INTO `lang_definitions` VALUES (2110, 5654, 2, 'Journal / Historia ( frivilligt att skriva )');
INSERT INTO `lang_definitions` VALUES (2111, 5658, 2, 'Medicin');
INSERT INTO `lang_definitions` VALUES (2112, 5663, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (2113, 5666, 2, 'Läkemedel:');
INSERT INTO `lang_definitions` VALUES (2114, 5667, 2, 'Medicinska enheter');
INSERT INTO `lang_definitions` VALUES (2115, 5668, 2, 'Medium');
INSERT INTO `lang_definitions` VALUES (2116, 5671, 2, 'Ledamot Association Statistik Rapport');
INSERT INTO `lang_definitions` VALUES (2117, 5673, 2, 'Minnes Problem');
INSERT INTO `lang_definitions` VALUES (2118, 5674, 2, 'Män');
INSERT INTO `lang_definitions` VALUES (2119, 5675, 2, 'Män och kvinnor');
INSERT INTO `lang_definitions` VALUES (2120, 5676, 2, 'Män Endast');
INSERT INTO `lang_definitions` VALUES (2121, 5678, 2, 'Klimakteriet');
INSERT INTO `lang_definitions` VALUES (2122, 5681, 2, 'Psykisk sjukdom');
INSERT INTO `lang_definitions` VALUES (2123, 5692, 2, 'Meddelande');
INSERT INTO `lang_definitions` VALUES (2124, 5693, 2, 'Meddelanden och Påminnelser');
INSERT INTO `lang_definitions` VALUES (2125, 5705, 2, 'MEDELANDE:');
INSERT INTO `lang_definitions` VALUES (2126, 5706, 2, 'Meddelanden');
INSERT INTO `lang_definitions` VALUES (2127, 5713, 2, 'Metod');
INSERT INTO `lang_definitions` VALUES (2128, 5717, 2, 'Metod för förstöring');
INSERT INTO `lang_definitions` VALUES (2129, 5724, 2, 'mg');
INSERT INTO `lang_definitions` VALUES (2130, 5725, 2, 'mg/ml');
INSERT INTO `lang_definitions` VALUES (2131, 5726, 2, 'g');
INSERT INTO `lang_definitions` VALUES (2132, 5727, 2, 'g/ml');
INSERT INTO `lang_definitions` VALUES (2133, 5732, 2, 'Mellan');
INSERT INTO `lang_definitions` VALUES (2134, 5733, 2, 'Mellannamn');
INSERT INTO `lang_definitions` VALUES (2135, 5734, 2, 'Mellannamn');
INSERT INTO `lang_definitions` VALUES (2136, 5747, 2, 'Migrerande eller säsongsarbetare?');
INSERT INTO `lang_definitions` VALUES (2137, 5749, 2, 'Migrerande / Säsong');
INSERT INTO `lang_definitions` VALUES (2138, 5763, 2, 'minuter');
INSERT INTO `lang_definitions` VALUES (2139, 5764, 2, 'Protokoll');
INSERT INTO `lang_definitions` VALUES (2140, 5770, 2, 'Diverse');
INSERT INTO `lang_definitions` VALUES (2141, 5772, 2, 'Missade');
INSERT INTO `lang_definitions` VALUES (2142, 5786, 2, 'Blandat');
INSERT INTO `lang_definitions` VALUES (2143, 5788, 2, 'ml');
INSERT INTO `lang_definitions` VALUES (2144, 5795, 2, 'Mobil');
INSERT INTO `lang_definitions` VALUES (2145, 5796, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (2146, 5828, 2, 'Mån');
INSERT INTO `lang_definitions` VALUES (2147, 5829, 2, 'Mån tills fredag');
INSERT INTO `lang_definitions` VALUES (2148, 5830, 2, 'Måndag, onsdag och fredag');
INSERT INTO `lang_definitions` VALUES (2149, 5831, 2, 'Måndag');
INSERT INTO `lang_definitions` VALUES (2150, 5835, 2, 'månad');
INSERT INTO `lang_definitions` VALUES (2151, 5836, 2, 'Månad');
INSERT INTO `lang_definitions` VALUES (2152, 5837, 2, 'Månadsvy');
INSERT INTO `lang_definitions` VALUES (2153, 5838, 2, 'Månad (er)');
INSERT INTO `lang_definitions` VALUES (2154, 5839, 2, 'Månadsinkomst');
INSERT INTO `lang_definitions` VALUES (2155, 5853, 2, 'Mer än 50 resultat, gör din sökning mer specifik.');
INSERT INTO `lang_definitions` VALUES (2156, 5863, 2, 'Moder');
INSERT INTO `lang_definitions` VALUES (2157, 5869, 2, 'Flytta');
INSERT INTO `lang_definitions` VALUES (2158, 5874, 2, 'Flytta till patient');
INSERT INTO `lang_definitions` VALUES (2159, 5875, 2, 'Flytta till...');
INSERT INTO `lang_definitions` VALUES (2160, 5876, 2, 'flytta up');
INSERT INTO `lang_definitions` VALUES (2161, 5882, 2, 'Herr.');
INSERT INTO `lang_definitions` VALUES (2162, 5887, 2, 'Fru.');
INSERT INTO `lang_definitions` VALUES (2163, 5889, 2, 'Fröken');
INSERT INTO `lang_definitions` VALUES (2164, 5901, 2, 'Multi Language Tool');
INSERT INTO `lang_definitions` VALUES (2165, 5903, 2, 'Flera områden');
INSERT INTO `lang_definitions` VALUES (2166, 5912, 2, 'Sorla:');
INSERT INTO `lang_definitions` VALUES (2167, 5913, 2, 'Muskel värk');
INSERT INTO `lang_definitions` VALUES (2168, 5919, 2, 'Muskel');
INSERT INTO `lang_definitions` VALUES (2169, 5920, 2, 'Muskel skada');
INSERT INTO `lang_definitions` VALUES (2170, 5921, 2, 'Muskuloskeletala');
INSERT INTO `lang_definitions` VALUES (2171, 5927, 2, 'Ömsesidigt Definierad');
INSERT INTO `lang_definitions` VALUES (2172, 5942, 2, 'Namn');
INSERT INTO `lang_definitions` VALUES (2173, 5946, 2, 'Namn 1');
INSERT INTO `lang_definitions` VALUES (2174, 5947, 2, 'Namn 2');
INSERT INTO `lang_definitions` VALUES (2175, 5948, 2, 'Namn på administratör');
INSERT INTO `lang_definitions` VALUES (2176, 5953, 2, 'Namn på försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2177, 5954, 2, 'Namn på Provider');
INSERT INTO `lang_definitions` VALUES (2178, 5964, 2, 'Namn:');
INSERT INTO `lang_definitions` VALUES (2179, 5968, 2, 'Narės:');
INSERT INTO `lang_definitions` VALUES (2180, 5969, 2, 'Narės: Normal Rätt');
INSERT INTO `lang_definitions` VALUES (2181, 5972, 2, 'Nasal mucosa rosa, septumets mittlinje');
INSERT INTO `lang_definitions` VALUES (2182, 5978, 2, 'Nationalitet');
INSERT INTO `lang_definitions` VALUES (2183, 5990, 2, 'Navigering');
INSERT INTO `lang_definitions` VALUES (2184, 6016, 2, 'Nacke');
INSERT INTO `lang_definitions` VALUES (2185, 6017, 2, 'Nackproblem');
INSERT INTO `lang_definitions` VALUES (2186, 6020, 2, 'Måste ange en beskrivning');
INSERT INTO `lang_definitions` VALUES (2187, 6021, 2, 'Ange ett returvärde');
INSERT INTO `lang_definitions` VALUES (2188, 6022, 2, 'Ange identifieraren');
INSERT INTO `lang_definitions` VALUES (2189, 6023, 2, 'Ange titel');
INSERT INTO `lang_definitions` VALUES (2190, 6028, 2, 'Ange sekundära fakturering');
INSERT INTO `lang_definitions` VALUES (2191, 6037, 2, 'Nervskada');
INSERT INTO `lang_definitions` VALUES (2192, 6039, 2, 'Neurala tillstånd / nervskada');
INSERT INTO `lang_definitions` VALUES (2193, 6052, 2, 'Ny');
INSERT INTO `lang_definitions` VALUES (2194, 6053, 2, 'Ny =>');
INSERT INTO `lang_definitions` VALUES (2195, 6054, 2, 'Nya mottagare');
INSERT INTO `lang_definitions` VALUES (2196, 6058, 2, 'Nytt möte');
INSERT INTO `lang_definitions` VALUES (2197, 6059, 2, 'Nya kategorier');
INSERT INTO `lang_definitions` VALUES (2198, 6061, 2, 'Nya kunder');
INSERT INTO `lang_definitions` VALUES (2199, 6062, 2, 'Ny konsultation');
INSERT INTO `lang_definitions` VALUES (2200, 6064, 2, 'Nytt definitionset tillagt');
INSERT INTO `lang_definitions` VALUES (2201, 6071, 2, 'Nya Patientbesöksformulär');
INSERT INTO `lang_definitions` VALUES (2202, 6072, 2, 'Nya möten som inte godkänts');
INSERT INTO `lang_definitions` VALUES (2203, 6074, 2, 'Nya Klinikinformation');
INSERT INTO `lang_definitions` VALUES (2204, 6078, 2, 'Ny grupp');
INSERT INTO `lang_definitions` VALUES (2205, 6093, 2, 'Ny begränsning av händelser');
INSERT INTO `lang_definitions` VALUES (2206, 6101, 2, 'Ny Patient');
INSERT INTO `lang_definitions` VALUES (2207, 6102, 2, 'NY PATIENT');
INSERT INTO `lang_definitions` VALUES (2208, 6103, 2, 'Nytt Patientbesök');
INSERT INTO `lang_definitions` VALUES (2209, 6105, 2, 'Nytt patient-ID');
INSERT INTO `lang_definitions` VALUES (2210, 6114, 2, 'Nya förslag');
INSERT INTO `lang_definitions` VALUES (2211, 6116, 2, 'Ny användare');
INSERT INTO `lang_definitions` VALUES (2212, 6118, 2, 'Nytt besök');
INSERT INTO `lang_definitions` VALUES (2213, 6119, 2, 'Ny/Sök');
INSERT INTO `lang_definitions` VALUES (2214, 6146, 2, 'Dagstidning');
INSERT INTO `lang_definitions` VALUES (2215, 6147, 2, 'Nästa');
INSERT INTO `lang_definitions` VALUES (2216, 6149, 2, 'Nästa dag');
INSERT INTO `lang_definitions` VALUES (2217, 6150, 2, 'Nästa Månad');
INSERT INTO `lang_definitions` VALUES (2218, 6156, 2, 'Nästa vecka');
INSERT INTO `lang_definitions` VALUES (2219, 6159, 2, 'Alias');
INSERT INTO `lang_definitions` VALUES (2220, 6161, 2, 'Nattliga svettningar');
INSERT INTO `lang_definitions` VALUES (2221, 6164, 2, 'Nej');
INSERT INTO `lang_definitions` VALUES (2222, 6165, 2, 'NEJ');
INSERT INTO `lang_definitions` VALUES (2223, 6167, 2, 'Ingen tillgång');
INSERT INTO `lang_definitions` VALUES (2224, 6179, 2, 'Inget faktureringssystem är aktivt');
INSERT INTO `lang_definitions` VALUES (2225, 6183, 2, 'Ingen kod specificerades!');
INSERT INTO `lang_definitions` VALUES (2226, 6187, 2, 'Ingen diagnos');
INSERT INTO `lang_definitions` VALUES (2227, 6193, 2, 'Inget slutdatum');
INSERT INTO `lang_definitions` VALUES (2228, 6194, 2, 'Inga poster funna, använda formuläret nedan för att lägga till en post.');
INSERT INTO `lang_definitions` VALUES (2229, 6196, 2, 'Inga händelser');
INSERT INTO `lang_definitions` VALUES (2230, 6199, 2, 'Ingen grupp valdes');
INSERT INTO `lang_definitions` VALUES (2231, 6200, 2, 'Inga bråck');
INSERT INTO `lang_definitions` VALUES (2232, 6204, 2, 'Nr Insurance Companies Found');
INSERT INTO `lang_definitions` VALUES (2233, 6241, 2, 'Inga tider hittades för denna period.');
INSERT INTO `lang_definitions` VALUES (2234, 6246, 2, 'Inga Partners hittades');
INSERT INTO `lang_definitions` VALUES (2235, 6249, 2, 'Inga perifera ödem');
INSERT INTO `lang_definitions` VALUES (2236, 6250, 2, 'Inga apotek hittades');
INSERT INTO `lang_definitions` VALUES (2237, 6251, 2, 'Inga recept hittades');
INSERT INTO `lang_definitions` VALUES (2238, 6253, 2, 'Ingen sjukdom / skada visas');
INSERT INTO `lang_definitions` VALUES (2239, 6272, 2, 'Inga resultat hittades i sökningen');
INSERT INTO `lang_definitions` VALUES (2240, 6274, 2, 'Inga resultat, försök igen.');
INSERT INTO `lang_definitions` VALUES (2241, 6277, 2, 'Ej kommit på avtalad tid');
INSERT INTO `lang_definitions` VALUES (2242, 6282, 2, 'Ingen hud dimpling eller bröst knölar');
INSERT INTO `lang_definitions` VALUES (2243, 6295, 2, 'Nr:');
INSERT INTO `lang_definitions` VALUES (2244, 6299, 2, 'Icke specifika skada');
INSERT INTO `lang_definitions` VALUES (2245, 6301, 2, 'Icke-insulinberoende diabetes');
INSERT INTO `lang_definitions` VALUES (2246, 6304, 2, 'Icke-SRH Medical');
INSERT INTO `lang_definitions` VALUES (2247, 6305, 2, 'Icke-SRH icke-medicinska');
INSERT INTO `lang_definitions` VALUES (2248, 6306, 2, 'Ingen');
INSERT INTO `lang_definitions` VALUES (2249, 6307, 2, 'ingen');
INSERT INTO `lang_definitions` VALUES (2250, 6311, 2, 'Inget av ovanstående');
INSERT INTO `lang_definitions` VALUES (2251, 6317, 2, 'Inte heller');
INSERT INTO `lang_definitions` VALUES (2252, 6318, 2, 'Normal');
INSERT INTO `lang_definitions` VALUES (2253, 6330, 2, 'Normal:');
INSERT INTO `lang_definitions` VALUES (2254, 6343, 2, 'Alla fält är obligatoriska för alla nummer eller kod typer.');
INSERT INTO `lang_definitions` VALUES (2255, 6345, 2, 'Ej tillåtet');
INSERT INTO `lang_definitions` VALUES (2256, 6346, 2, 'Ej tillåtet att ta bort gruppen Administratörer');
INSERT INTO `lang_definitions` VALUES (2257, 6348, 2, 'Ej tillåtet att inaktivera alla trygghet objekt');
INSERT INTO `lang_definitions` VALUES (2258, 6349, 2, 'Ej tillåtet att inaktivera allt från Administratörer ACL');
INSERT INTO `lang_definitions` VALUES (2259, 6350, 2, 'Ej tillåtet att ta bort admin-användare från gruppen Administratörer');
INSERT INTO `lang_definitions` VALUES (2260, 6353, 2, 'Ej behörighet att nå PostCalendar modulen');
INSERT INTO `lang_definitions` VALUES (2261, 6371, 2, 'Inte undersökt');
INSERT INTO `lang_definitions` VALUES (2262, 6372, 2, 'Inte undersökt:');
INSERT INTO `lang_definitions` VALUES (2263, 6373, 2, 'Inte undersökt:');
INSERT INTO `lang_definitions` VALUES (2264, 6382, 2, 'Inte sett sedan');
INSERT INTO `lang_definitions` VALUES (2265, 6389, 2, 'kommentera');
INSERT INTO `lang_definitions` VALUES (2266, 6400, 2, 'Kommentartyp');
INSERT INTO `lang_definitions` VALUES (2267, 6409, 2, 'Anmärkning: Denna kod har inte förts in av en auktoriserad användare. Endast godkända koder kan laddas upp till Open Medical Billing nätverket för bearbetning. Om du vill ladda upp dessa nummer kan du välja en auktoriserad användare här.');
INSERT INTO `lang_definitions` VALUES (2268, 6413, 2, 'OBS: Överföra filer med duplikat namn gör att filerna automatiskt ska döpas. Till exempel \"<i> file.jpg </ i>\" blir \"<i> file.jpg.1 </ i>\". Filnamnen anses unika per patient, inte per kategori.');
INSERT INTO `lang_definitions` VALUES (2269, 6414, 2, 'Kommentarer');
INSERT INTO `lang_definitions` VALUES (2270, 6433, 2, 'Ingenting valdes');
INSERT INTO `lang_definitions` VALUES (2271, 6437, 2, 'MEDDELANDE: PostCalendar Inlämning / Modifiering');
INSERT INTO `lang_definitions` VALUES (2272, 6438, 2, 'Besked');
INSERT INTO `lang_definitions` VALUES (2273, 6445, 2, 'Meddela Admin Om Händelse Inlämning / Modifieringsförslag?');
INSERT INTO `lang_definitions` VALUES (2274, 6449, 2, 'November');
INSERT INTO `lang_definitions` VALUES (2275, 6462, 2, 'NPI');
INSERT INTO `lang_definitions` VALUES (2276, 6465, 2, 'Nummer');
INSERT INTO `lang_definitions` VALUES (2277, 6471, 2, 'Antal kolumner i år-vy.');
INSERT INTO `lang_definitions` VALUES (2278, 6504, 2, 'Status');
INSERT INTO `lang_definitions` VALUES (2279, 6513, 2, 'Yrke');
INSERT INTO `lang_definitions` VALUES (2280, 6516, 2, 'Förekomst');
INSERT INTO `lang_definitions` VALUES (2281, 6518, 2, 'Oktober');
INSERT INTO `lang_definitions` VALUES (2282, 6524, 2, 'tabletter');
INSERT INTO `lang_definitions` VALUES (2283, 6525, 2, 'i månaden per');
INSERT INTO `lang_definitions` VALUES (2284, 6533, 2, 'Mottagningskommentarer');
INSERT INTO `lang_definitions` VALUES (2285, 6534, 2, 'Mottagningsbesök');
INSERT INTO `lang_definitions` VALUES (2286, 6547, 2, 'Avkomma');
INSERT INTO `lang_definitions` VALUES (2287, 6551, 2, 'salva');
INSERT INTO `lang_definitions` VALUES (2288, 6553, 2, 'OK');
INSERT INTO `lang_definitions` VALUES (2289, 6558, 2, 'Gamla klienter');
INSERT INTO `lang_definitions` VALUES (2290, 6572, 2, 'underlåtit att autoassign');
INSERT INTO `lang_definitions` VALUES (2291, 6574, 2, 'på');
INSERT INTO `lang_definitions` VALUES (2292, 6577, 2, 'På Hand');
INSERT INTO `lang_definitions` VALUES (2293, 6579, 2, 'På beställning');
INSERT INTO `lang_definitions` VALUES (2294, 6598, 2, 'När du byter lösenord måste du logga in på nytt.');
INSERT INTO `lang_definitions` VALUES (2295, 6615, 2, 'Endast aktiva');
INSERT INTO `lang_definitions` VALUES (2296, 6620, 2, 'endast om faktureringsadress');
INSERT INTO `lang_definitions` VALUES (2297, 6622, 2, 'Endast Inaktiva');
INSERT INTO `lang_definitions` VALUES (2298, 6623, 2, 'Endast Min');
INSERT INTO `lang_definitions` VALUES (2299, 6633, 2, 'Uppkomsten av sjukdom:');
INSERT INTO `lang_definitions` VALUES (2300, 6634, 2, 'Uppkomsten av sjukdom:');
INSERT INTO `lang_definitions` VALUES (2301, 6635, 2, 'Uppkomsten av Svullnad:');
INSERT INTO `lang_definitions` VALUES (2302, 6638, 2, 'Debut / Inskrivning. Datum:');
INSERT INTO `lang_definitions` VALUES (2303, 6646, 2, 'Öppen');
INSERT INTO `lang_definitions` VALUES (2304, 6689, 2, 'OpenEMR kräver Javascript för att utföra användarverifiering.');
INSERT INTO `lang_definitions` VALUES (2305, 6700, 2, 'Alternativ');
INSERT INTO `lang_definitions` VALUES (2306, 6703, 2, 'Valfritt');
INSERT INTO `lang_definitions` VALUES (2307, 6714, 2, 'Frivillig information om denna händelse');
INSERT INTO `lang_definitions` VALUES (2308, 6717, 2, 'Valfri procedurkodkod');
INSERT INTO `lang_definitions` VALUES (2309, 6720, 2, 'ELLER');
INSERT INTO `lang_definitions` VALUES (2310, 6721, 2, 'Eller');
INSERT INTO `lang_definitions` VALUES (2311, 6722, 2, 'Eller välj');
INSERT INTO `lang_definitions` VALUES (2312, 6728, 2, 'Eller ladda upp ERA fil:');
INSERT INTO `lang_definitions` VALUES (2313, 6732, 2, 'Ordning');
INSERT INTO `lang_definitions` VALUES (2314, 6766, 2, 'Organskada');
INSERT INTO `lang_definitions` VALUES (2315, 6767, 2, 'Organisation');
INSERT INTO `lang_definitions` VALUES (2316, 6771, 2, 'Orienterad x 3');
INSERT INTO `lang_definitions` VALUES (2317, 6786, 2, 'P.O. (via munnen)');
INSERT INTO `lang_definitions` VALUES (2318, 6791, 2, 'Övrigt');
INSERT INTO `lang_definitions` VALUES (2319, 6793, 2, 'annan');
INSERT INTO `lang_definitions` VALUES (2320, 6801, 2, 'Andra skador inte specificerade på någon annan plats');
INSERT INTO `lang_definitions` VALUES (2321, 6804, 2, 'annan månad');
INSERT INTO `lang_definitions` VALUES (2322, 6805, 2, 'Andra icke-federala program');
INSERT INTO `lang_definitions` VALUES (2323, 6807, 2, 'Andra relevanta Symtom');
INSERT INTO `lang_definitions` VALUES (2324, 6808, 2, 'Andra relevanta Symtom:');
INSERT INTO `lang_definitions` VALUES (2325, 6814, 2, 'Andra kirurgiska');
INSERT INTO `lang_definitions` VALUES (2326, 6823, 2, 'OU');
INSERT INTO `lang_definitions` VALUES (2327, 6829, 2, 'Utfall');
INSERT INTO `lang_definitions` VALUES (2328, 6832, 2, 'Outlook');
INSERT INTO `lang_definitions` VALUES (2329, 6842, 2, 'Överutnyttjande');
INSERT INTO `lang_definitions` VALUES (2330, 6850, 2, 'vid behov');
INSERT INTO `lang_definitions` VALUES (2331, 6857, 2, 'Pedriatisk');
INSERT INTO `lang_definitions` VALUES (2332, 6860, 2, 'Sidor');
INSERT INTO `lang_definitions` VALUES (2333, 6861, 2, 'Betald');
INSERT INTO `lang_definitions` VALUES (2334, 6862, 2, 'Betalt belopp som du kommer att fördela');
INSERT INTO `lang_definitions` VALUES (2335, 6864, 2, 'Betalas via');
INSERT INTO `lang_definitions` VALUES (2336, 6886, 2, 'Partner');
INSERT INTO `lang_definitions` VALUES (2337, 6898, 2, 'Lösenord');
INSERT INTO `lang_definitions` VALUES (2338, 6899, 2, 'Ändra lösenord');
INSERT INTO `lang_definitions` VALUES (2339, 6906, 2, 'Lösenord för SMS Gateway');
INSERT INTO `lang_definitions` VALUES (2340, 6912, 2, 'Lösenord:');
INSERT INTO `lang_definitions` VALUES (2341, 6927, 2, 'Tidigare möten');
INSERT INTO `lang_definitions` VALUES (2342, 6928, 2, 'Tidigare möten och dokument');
INSERT INTO `lang_definitions` VALUES (2343, 6937, 2, 'Klistra in HL7 Data');
INSERT INTO `lang_definitions` VALUES (2344, 6962, 2, 'Patient Allergier');
INSERT INTO `lang_definitions` VALUES (2345, 6965, 2, 'Patient träff/bokning');
INSERT INTO `lang_definitions` VALUES (2346, 6971, 2, 'Patient diagram ID');
INSERT INTO `lang_definitions` VALUES (2347, 6986, 2, 'Patientdata');
INSERT INTO `lang_definitions` VALUES (2348, 6996, 2, 'Patientdokument');
INSERT INTO `lang_definitions` VALUES (2349, 7002, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (2350, 7003, 2, 'Patientmötesformulär');
INSERT INTO `lang_definitions` VALUES (2351, 7004, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (2352, 7005, 2, 'Patientsök');
INSERT INTO `lang_definitions` VALUES (2353, 7017, 2, 'Patienthistoria');
INSERT INTO `lang_definitions` VALUES (2354, 7018, 2, 'Patientens historia / Livsstil');
INSERT INTO `lang_definitions` VALUES (2355, 7020, 2, 'Patient-ID');
INSERT INTO `lang_definitions` VALUES (2356, 7026, 2, 'Patient -vaccination');
INSERT INTO `lang_definitions` VALUES (2357, 7030, 2, 'Ej tilldelad!');
INSERT INTO `lang_definitions` VALUES (2358, 7034, 2, 'Patient -problem');
INSERT INTO `lang_definitions` VALUES (2359, 7043, 2, 'Patientlista');
INSERT INTO `lang_definitions` VALUES (2360, 7051, 2, 'Patientens medicinska problem');
INSERT INTO `lang_definitions` VALUES (2361, 7052, 2, 'Patient -Mediciner');
INSERT INTO `lang_definitions` VALUES (2362, 7060, 2, 'Patient: Namn och Adress');
INSERT INTO `lang_definitions` VALUES (2363, 7066, 2, 'Patientanteckning, typ');
INSERT INTO `lang_definitions` VALUES (2364, 7067, 2, 'Patient -kommentarer');
INSERT INTO `lang_definitions` VALUES (2365, 7070, 2, 'Patientnummer');
INSERT INTO `lang_definitions` VALUES (2366, 7085, 2, 'Patient -Journalrapport');
INSERT INTO `lang_definitions` VALUES (2367, 7100, 2, 'Patientrapport');
INSERT INTO `lang_definitions` VALUES (2368, 7103, 2, 'Patientförfrågan');
INSERT INTO `lang_definitions` VALUES (2369, 7123, 2, 'Patient -Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2370, 7125, 2, 'Patient -Remisser m.m.');
INSERT INTO `lang_definitions` VALUES (2371, 7132, 2, 'Patient / Klient');
INSERT INTO `lang_definitions` VALUES (2372, 7133, 2, 'Patient:');
INSERT INTO `lang_definitions` VALUES (2373, 7135, 2, 'Patienter');
INSERT INTO `lang_definitions` VALUES (2374, 7140, 2, 'Betala');
INSERT INTO `lang_definitions` VALUES (2375, 7144, 2, 'Betalningsdatum:');
INSERT INTO `lang_definitions` VALUES (2376, 7149, 2, 'Betalare');
INSERT INTO `lang_definitions` VALUES (2377, 7153, 2, 'Betalare Typ');
INSERT INTO `lang_definitions` VALUES (2378, 7154, 2, 'Utbetalande');
INSERT INTO `lang_definitions` VALUES (2379, 7156, 2, 'Betalning');
INSERT INTO `lang_definitions` VALUES (2380, 7164, 2, 'Betalningsdatum');
INSERT INTO `lang_definitions` VALUES (2381, 7171, 2, 'Betalningsmetod');
INSERT INTO `lang_definitions` VALUES (2382, 7179, 2, 'Betalning värde för kod');
INSERT INTO `lang_definitions` VALUES (2383, 7181, 2, 'Betalningar');
INSERT INTO `lang_definitions` VALUES (2384, 7201, 2, 'Oavslutad');
INSERT INTO `lang_definitions` VALUES (2385, 7207, 2, 'Oklart');
INSERT INTO `lang_definitions` VALUES (2386, 7219, 2, 'via näsborre');
INSERT INTO `lang_definitions` VALUES (2387, 7220, 2, 'via näsborre');
INSERT INTO `lang_definitions` VALUES (2388, 7223, 2, 'Rektalt');
INSERT INTO `lang_definitions` VALUES (2389, 7224, 2, 'rektalt');
INSERT INTO `lang_definitions` VALUES (2390, 7231, 2, 'Utför sökning');
INSERT INTO `lang_definitions` VALUES (2391, 7232, 2, 'Utför åtgärden');
INSERT INTO `lang_definitions` VALUES (2392, 7254, 2, 'Apotek');
INSERT INTO `lang_definitions` VALUES (2393, 7255, 2, 'Patient Insurance Distribution');
INSERT INTO `lang_definitions` VALUES (2394, 7262, 2, 'Pheumothorax');
INSERT INTO `lang_definitions` VALUES (2395, 7271, 2, 'Telefon');
INSERT INTO `lang_definitions` VALUES (2396, 7273, 2, 'Telefon samtalslistan');
INSERT INTO `lang_definitions` VALUES (2397, 7285, 2, 'Telefonnummer');
INSERT INTO `lang_definitions` VALUES (2398, 7296, 2, 'Hälsokontroll');
INSERT INTO `lang_definitions` VALUES (2399, 7298, 2, 'Läkares Begäran');
INSERT INTO `lang_definitions` VALUES (2400, 7299, 2, 'Läkares Underskrift');
INSERT INTO `lang_definitions` VALUES (2401, 7302, 2, 'Läkare');
INSERT INTO `lang_definitions` VALUES (2402, 7306, 2, 'välj');
INSERT INTO `lang_definitions` VALUES (2403, 7314, 2, 'Tablett Storlek');
INSERT INTO `lang_definitions` VALUES (2404, 7315, 2, 'Tabletter');
INSERT INTO `lang_definitions` VALUES (2405, 7329, 2, 'Vanlig text');
INSERT INTO `lang_definitions` VALUES (2406, 7330, 2, 'Planering');
INSERT INTO `lang_definitions` VALUES (2407, 7335, 2, 'Planering namn');
INSERT INTO `lang_definitions` VALUES (2408, 7346, 2, 'Planering:');
INSERT INTO `lang_definitions` VALUES (2409, 7349, 2, 'Planering');
INSERT INTO `lang_definitions` VALUES (2410, 7351, 2, 'Spelare');
INSERT INTO `lang_definitions` VALUES (2411, 7352, 2, 'Position');
INSERT INTO `lang_definitions` VALUES (2412, 7362, 2, 'Välj ett värde för');
INSERT INTO `lang_definitions` VALUES (2413, 7367, 2, 'Stäng detta fönster');
INSERT INTO `lang_definitions` VALUES (2414, 7368, 2, 'Jämför det nya namnet');
INSERT INTO `lang_definitions` VALUES (2415, 7427, 2, 'Vänligen använ endast alfabetiska tecken');
INSERT INTO `lang_definitions` VALUES (2416, 7428, 2, 'Vänligen använd endast alfabetiska tecken utan mellanslag');
INSERT INTO `lang_definitions` VALUES (2417, 7429, 2, 'Vänligen betala detta belopp');
INSERT INTO `lang_definitions` VALUES (2418, 7453, 2, 'Välj en händelse');
INSERT INTO `lang_definitions` VALUES (2419, 7488, 2, 'EM');
INSERT INTO `lang_definitions` VALUES (2420, 7502, 2, 'Lunginflammations Vaccination');
INSERT INTO `lang_definitions` VALUES (2421, 7509, 2, 'Förhållningssätt');
INSERT INTO `lang_definitions` VALUES (2422, 7517, 2, 'Polyper');
INSERT INTO `lang_definitions` VALUES (2423, 7519, 2, 'Dålig apptit');
INSERT INTO `lang_definitions` VALUES (2424, 7520, 2, 'Dålig cirkulation');
INSERT INTO `lang_definitions` VALUES (2425, 7521, 2, 'Dålig hörsel');
INSERT INTO `lang_definitions` VALUES (2426, 7526, 2, 'Popup-fönster');
INSERT INTO `lang_definitions` VALUES (2427, 7567, 2, 'Postnr');
INSERT INTO `lang_definitions` VALUES (2428, 7568, 2, 'Postnummer');
INSERT INTO `lang_definitions` VALUES (2429, 7582, 2, 'Överförings Datum');
INSERT INTO `lang_definitions` VALUES (2430, 7593, 2, 'Practice');
INSERT INTO `lang_definitions` VALUES (2431, 7612, 2, 'Graviditets test');
INSERT INTO `lang_definitions` VALUES (2432, 7615, 2, 'Förskottsbetalning');
INSERT INTO `lang_definitions` VALUES (2433, 7622, 2, 'Receptbelagda märken');
INSERT INTO `lang_definitions` VALUES (2434, 7626, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2435, 7629, 2, 'Föreskrifter och dispenser');
INSERT INTO `lang_definitions` VALUES (2436, 7630, 2, 'Recept och andra råd');
INSERT INTO `lang_definitions` VALUES (2437, 7631, 2, 'Recept och andra råd av specialist');
INSERT INTO `lang_definitions` VALUES (2438, 7632, 2, 'recept rapport');
INSERT INTO `lang_definitions` VALUES (2439, 7633, 2, 'Recept/råd');
INSERT INTO `lang_definitions` VALUES (2440, 7635, 2, 'Presentera Klagomål');
INSERT INTO `lang_definitions` VALUES (2441, 7637, 2, 'Tryck på fortsätt för att fortsätta');
INSERT INTO `lang_definitions` VALUES (2442, 7640, 2, 'Förmodad diagnos');
INSERT INTO `lang_definitions` VALUES (2443, 7641, 2, 'Förmodad diagnos från specialist');
INSERT INTO `lang_definitions` VALUES (2444, 7642, 2, 'Föregående');
INSERT INTO `lang_definitions` VALUES (2445, 7653, 2, 'Föregående');
INSERT INTO `lang_definitions` VALUES (2446, 7654, 2, 'Föregående konsultation');
INSERT INTO `lang_definitions` VALUES (2447, 7655, 2, 'Föregående dag');
INSERT INTO `lang_definitions` VALUES (2448, 7657, 2, 'Föregående månad');
INSERT INTO `lang_definitions` VALUES (2449, 7658, 2, 'Föregående vecka');
INSERT INTO `lang_definitions` VALUES (2450, 7659, 2, 'Pris');
INSERT INTO `lang_definitions` VALUES (2451, 7663, 2, 'Prisnivå');
INSERT INTO `lang_definitions` VALUES (2452, 7665, 2, 'Prisnivå:');
INSERT INTO `lang_definitions` VALUES (2453, 7668, 2, 'Primär');
INSERT INTO `lang_definitions` VALUES (2454, 7680, 2, 'Primära Försäkring');
INSERT INTO `lang_definitions` VALUES (2455, 7681, 2, 'Primära Försäkrings Data');
INSERT INTO `lang_definitions` VALUES (2456, 7682, 2, 'Primär försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2457, 7684, 2, 'Skriv ut');
INSERT INTO `lang_definitions` VALUES (2458, 7689, 2, 'Printa blankt remissformulär');
INSERT INTO `lang_definitions` VALUES (2459, 7702, 2, 'Skriv ut flera');
INSERT INTO `lang_definitions` VALUES (2460, 7719, 2, 'Skriv ut denna anmärkning');
INSERT INTO `lang_definitions` VALUES (2461, 7720, 2, 'Skriv ut Denna Anmärkning');
INSERT INTO `lang_definitions` VALUES (2462, 7724, 2, 'Utskrivbar');
INSERT INTO `lang_definitions` VALUES (2463, 7725, 2, 'Utskriftsversion');
INSERT INTO `lang_definitions` VALUES (2464, 7729, 2, 'Skriva ut resultat:');
INSERT INTO `lang_definitions` VALUES (2465, 7742, 2, 'Prioritet');
INSERT INTO `lang_definitions` VALUES (2466, 7746, 2, 'Privat');
INSERT INTO `lang_definitions` VALUES (2467, 7752, 2, 'Problem/anledningar');
INSERT INTO `lang_definitions` VALUES (2468, 7759, 2, 'Förfarande');
INSERT INTO `lang_definitions` VALUES (2469, 7804, 2, 'Förfarande');
INSERT INTO `lang_definitions` VALUES (2470, 7806, 2, 'Process');
INSERT INTO `lang_definitions` VALUES (2471, 7817, 2, 'Bearbetning');
INSERT INTO `lang_definitions` VALUES (2472, 7828, 2, 'Produkter');
INSERT INTO `lang_definitions` VALUES (2473, 7831, 2, 'Prof.');
INSERT INTO `lang_definitions` VALUES (2474, 7843, 2, 'Prostata Cancer');
INSERT INTO `lang_definitions` VALUES (2475, 7845, 2, 'Prostata undersökning');
INSERT INTO `lang_definitions` VALUES (2476, 7846, 2, 'Prostata problem');
INSERT INTO `lang_definitions` VALUES (2477, 7864, 2, 'Vårdgivare');
INSERT INTO `lang_definitions` VALUES (2478, 7868, 2, 'Vårdgivare ID');
INSERT INTO `lang_definitions` VALUES (2479, 7869, 2, 'Vårdgivare ID');
INSERT INTO `lang_definitions` VALUES (2480, 7870, 2, 'Vårdgivare ID på specificerad klinik');
INSERT INTO `lang_definitions` VALUES (2481, 7871, 2, 'Kan ej matcha vårdgivare');
INSERT INTO `lang_definitions` VALUES (2482, 7876, 2, 'Vårdgivare, nummmer');
INSERT INTO `lang_definitions` VALUES (2483, 7882, 2, 'Vårdgivare:');
INSERT INTO `lang_definitions` VALUES (2484, 7883, 2, 'Vårdgivare:');
INSERT INTO `lang_definitions` VALUES (2485, 7887, 2, 'PSA');
INSERT INTO `lang_definitions` VALUES (2486, 7888, 2, 'Psoriasis');
INSERT INTO `lang_definitions` VALUES (2487, 7890, 2, 'Psykisk diagnos');
INSERT INTO `lang_definitions` VALUES (2488, 7891, 2, 'Psykiatrisk mediciinering');
INSERT INTO `lang_definitions` VALUES (2489, 7892, 2, 'Psykiatrisk mediciinering');
INSERT INTO `lang_definitions` VALUES (2490, 7942, 2, 'Puls');
INSERT INTO `lang_definitions` VALUES (2491, 7952, 2, 'Var 3:e timme');
INSERT INTO `lang_definitions` VALUES (2492, 7953, 2, 'Var 4:e timme');
INSERT INTO `lang_definitions` VALUES (2493, 7954, 2, 'Var 5:e timme');
INSERT INTO `lang_definitions` VALUES (2494, 7955, 2, 'Var 6:e timme');
INSERT INTO `lang_definitions` VALUES (2495, 7956, 2, 'Var 8:e timme');
INSERT INTO `lang_definitions` VALUES (2496, 7957, 2, '1 ggr/dag');
INSERT INTO `lang_definitions` VALUES (2497, 7958, 2, '4ggr/dag');
INSERT INTO `lang_definitions` VALUES (2498, 7963, 2, 'Antal');
INSERT INTO `lang_definitions` VALUES (2499, 7965, 2, 'Kvalitet');
INSERT INTO `lang_definitions` VALUES (2500, 7967, 2, 'Kvantitet');
INSERT INTO `lang_definitions` VALUES (2501, 7969, 2, 'Kvantitet för NDC');
INSERT INTO `lang_definitions` VALUES (2502, 7980, 2, 'köad');
INSERT INTO `lang_definitions` VALUES (2503, 7981, 2, 'Kö Evenemang Administration');
INSERT INTO `lang_definitions` VALUES (2504, 7982, 2, 'köad för');
INSERT INTO `lang_definitions` VALUES (2505, 7984, 2, 'Kö föreläggande Administration');
INSERT INTO `lang_definitions` VALUES (2506, 7996, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2507, 7997, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2508, 7998, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2509, 8000, 2, 'Radio');
INSERT INTO `lang_definitions` VALUES (2510, 8001, 2, 'Radioknapp');
INSERT INTO `lang_definitions` VALUES (2511, 8007, 2, 'Utslag');
INSERT INTO `lang_definitions` VALUES (2512, 8008, 2, 'Betygsätta');
INSERT INTO `lang_definitions` VALUES (2513, 8010, 2, 'Andel');
INSERT INTO `lang_definitions` VALUES (2514, 8026, 2, 'Åter öppnas');
INSERT INTO `lang_definitions` VALUES (2515, 8030, 2, 'Reaktioner');
INSERT INTO `lang_definitions` VALUES (2516, 8040, 2, 'Riktigt namn');
INSERT INTO `lang_definitions` VALUES (2517, 8042, 2, 'Anledning');
INSERT INTO `lang_definitions` VALUES (2518, 8043, 2, 'Orsak till avslutande');
INSERT INTO `lang_definitions` VALUES (2519, 8046, 2, 'Anledning till remiss');
INSERT INTO `lang_definitions` VALUES (2520, 8048, 2, 'Anledning till besök');
INSERT INTO `lang_definitions` VALUES (2521, 8049, 2, 'Orsak / Form');
INSERT INTO `lang_definitions` VALUES (2522, 8063, 2, 'Kvitto');
INSERT INTO `lang_definitions` VALUES (2523, 8064, 2, 'Kvitto för betalning');
INSERT INTO `lang_definitions` VALUES (2524, 8067, 2, 'Kvitton Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2525, 8068, 2, 'Mottagna');
INSERT INTO `lang_definitions` VALUES (2526, 8069, 2, 'Mottagna av');
INSERT INTO `lang_definitions` VALUES (2527, 8070, 2, 'Mottagna fax');
INSERT INTO `lang_definitions` VALUES (2528, 8074, 2, 'Mottagare');
INSERT INTO `lang_definitions` VALUES (2529, 8075, 2, 'Mottagare ID');
INSERT INTO `lang_definitions` VALUES (2530, 8092, 2, 'Rekomendationer');
INSERT INTO `lang_definitions` VALUES (2531, 8093, 2, 'Rekomendationer och behandling');
INSERT INTO `lang_definitions` VALUES (2532, 8094, 2, 'Rekomendationer av specialist');
INSERT INTO `lang_definitions` VALUES (2533, 8132, 2, 'reduceras:');
INSERT INTO `lang_definitions` VALUES (2534, 8134, 2, 'Remitera');
INSERT INTO `lang_definitions` VALUES (2535, 8135, 2, 'Remiterad av');
INSERT INTO `lang_definitions` VALUES (2536, 8136, 2, 'Remissdatum');
INSERT INTO `lang_definitions` VALUES (2537, 8137, 2, 'Remiteras till');
INSERT INTO `lang_definitions` VALUES (2538, 8139, 2, 'Prioritetsnivå (Risknivå)');
INSERT INTO `lang_definitions` VALUES (2539, 8141, 2, 'Orsak till remiss');
INSERT INTO `lang_definitions` VALUES (2540, 8144, 2, 'Remittent, namn och signatur');
INSERT INTO `lang_definitions` VALUES (2541, 8145, 2, 'Remiss');
INSERT INTO `lang_definitions` VALUES (2542, 8146, 2, 'Remitterad av');
INSERT INTO `lang_definitions` VALUES (2543, 8147, 2, 'Remisskort');
INSERT INTO `lang_definitions` VALUES (2544, 8148, 2, 'Remissdadum');
INSERT INTO `lang_definitions` VALUES (2545, 8149, 2, 'Remissformulär');
INSERT INTO `lang_definitions` VALUES (2546, 8150, 2, 'REMISSFORMULÄR');
INSERT INTO `lang_definitions` VALUES (2547, 8154, 2, 'Remisskälla');
INSERT INTO `lang_definitions` VALUES (2548, 8156, 2, 'Remitteras till');
INSERT INTO `lang_definitions` VALUES (2549, 8157, 2, 'remittering');
INSERT INTO `lang_definitions` VALUES (2550, 8158, 2, 'remiss');
INSERT INTO `lang_definitions` VALUES (2551, 8159, 2, 'Remiterats från');
INSERT INTO `lang_definitions` VALUES (2552, 8160, 2, 'Remiterats från');
INSERT INTO `lang_definitions` VALUES (2553, 8162, 2, 'Remitterats till');
INSERT INTO `lang_definitions` VALUES (2554, 8163, 2, 'Remiterats av');
INSERT INTO `lang_definitions` VALUES (2555, 8174, 2, 'Påfyllnad');
INSERT INTO `lang_definitions` VALUES (2556, 8175, 2, 'påfyllnad');
INSERT INTO `lang_definitions` VALUES (2557, 8176, 2, 'Reflexer normala');
INSERT INTO `lang_definitions` VALUES (2558, 8180, 2, 'Uppdatera');
INSERT INTO `lang_definitions` VALUES (2559, 8197, 2, 'Registrerad');
INSERT INTO `lang_definitions` VALUES (2560, 8198, 2, 'registrerade');
INSERT INTO `lang_definitions` VALUES (2561, 8202, 2, 'Registreringsdag');
INSERT INTO `lang_definitions` VALUES (2562, 8206, 2, 'Rehabilitering');
INSERT INTO `lang_definitions` VALUES (2563, 8211, 2, 'Relaterat');
INSERT INTO `lang_definitions` VALUES (2564, 8216, 2, 'Förhållande');
INSERT INTO `lang_definitions` VALUES (2565, 8218, 2, 'Anhöriga');
INSERT INTO `lang_definitions` VALUES (2566, 8234, 2, 'Religion');
INSERT INTO `lang_definitions` VALUES (2567, 8239, 2, 'Relogin');
INSERT INTO `lang_definitions` VALUES (2568, 8266, 2, 'Ta bort grupp');
INSERT INTO `lang_definitions` VALUES (2569, 8293, 2, 'Upprepar');
INSERT INTO `lang_definitions` VALUES (2570, 8304, 2, 'Svars Datum');
INSERT INTO `lang_definitions` VALUES (2571, 8307, 2, 'Rapport');
INSERT INTO `lang_definitions` VALUES (2572, 8330, 2, 'Rapporter');
INSERT INTO `lang_definitions` VALUES (2573, 8353, 2, 'Nödvändig');
INSERT INTO `lang_definitions` VALUES (2574, 8362, 2, 'RESERVERAD');
INSERT INTO `lang_definitions` VALUES (2575, 8363, 2, 'reserverad');
INSERT INTO `lang_definitions` VALUES (2576, 8382, 2, 'Löst');
INSERT INTO `lang_definitions` VALUES (2577, 8396, 2, 'Begränsat Utbildning');
INSERT INTO `lang_definitions` VALUES (2578, 8397, 2, 'Resultat');
INSERT INTO `lang_definitions` VALUES (2579, 8414, 2, 'Infällda Höger:');
INSERT INTO `lang_definitions` VALUES (2580, 8415, 2, 'Avkastning');
INSERT INTO `lang_definitions` VALUES (2581, 8426, 2, 'Returvärde');
INSERT INTO `lang_definitions` VALUES (2582, 8427, 2, 'Återresa');
INSERT INTO `lang_definitions` VALUES (2583, 8444, 2, 'Översyn av System Kontroller');
INSERT INTO `lang_definitions` VALUES (2584, 8450, 2, 'Revision');
INSERT INTO `lang_definitions` VALUES (2585, 8454, 2, 'Höger');
INSERT INTO `lang_definitions` VALUES (2586, 8457, 2, 'Höger öra');
INSERT INTO `lang_definitions` VALUES (2587, 8458, 2, 'höger öra');
INSERT INTO `lang_definitions` VALUES (2588, 8465, 2, 'Höger:');
INSERT INTO `lang_definitions` VALUES (2589, 8466, 2, 'Ringningar i öron');
INSERT INTO `lang_definitions` VALUES (2590, 8467, 2, 'Tinitus');
INSERT INTO `lang_definitions` VALUES (2591, 8490, 2, 'Rutt');
INSERT INTO `lang_definitions` VALUES (2592, 8493, 2, 'Rader');
INSERT INTO `lang_definitions` VALUES (2593, 8496, 2, 'Massera:');
INSERT INTO `lang_definitions` VALUES (2594, 8497, 2, 'Gnuggar:');
INSERT INTO `lang_definitions` VALUES (2595, 8513, 2, 'Kör kommando:');
INSERT INTO `lang_definitions` VALUES (2596, 8519, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2597, 8520, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2598, 8551, 2, 'K');
INSERT INTO `lang_definitions` VALUES (2599, 8552, 2, 'Personnr');
INSERT INTO `lang_definitions` VALUES (2600, 8562, 2, 'Samma dag');
INSERT INTO `lang_definitions` VALUES (2601, 8565, 2, 'Sanktions Typ');
INSERT INTO `lang_definitions` VALUES (2602, 8570, 2, 'Lördag');
INSERT INTO `lang_definitions` VALUES (2603, 8571, 2, 'Lördag & söndag');
INSERT INTO `lang_definitions` VALUES (2604, 8572, 2, 'Lördag');
INSERT INTO `lang_definitions` VALUES (2605, 8573, 2, 'Spara');
INSERT INTO `lang_definitions` VALUES (2606, 8581, 2, 'Spara och fördela');
INSERT INTO `lang_definitions` VALUES (2607, 8584, 2, 'Spara som ny');
INSERT INTO `lang_definitions` VALUES (2608, 8590, 2, 'Spara ändringar');
INSERT INTO `lang_definitions` VALUES (2609, 8599, 2, 'Spara vaccination');
INSERT INTO `lang_definitions` VALUES (2610, 8611, 2, 'Spara transaktionen');
INSERT INTO `lang_definitions` VALUES (2611, 8619, 2, 'Inskannade');
INSERT INTO `lang_definitions` VALUES (2612, 8625, 2, 'Schema');
INSERT INTO `lang_definitions` VALUES (2613, 8642, 2, 'Skolios');
INSERT INTO `lang_definitions` VALUES (2614, 8649, 2, 'SE');
INSERT INTO `lang_definitions` VALUES (2615, 8650, 2, 'SE Adress');
INSERT INTO `lang_definitions` VALUES (2616, 8651, 2, 'SE Stad');
INSERT INTO `lang_definitions` VALUES (2617, 8652, 2, 'SE Land');
INSERT INTO `lang_definitions` VALUES (2618, 8657, 2, 'Söka');
INSERT INTO `lang_definitions` VALUES (2619, 8659, 2, 'söka');
INSERT INTO `lang_definitions` VALUES (2620, 8660, 2, 'Sök igen');
INSERT INTO `lang_definitions` VALUES (2621, 8665, 2, 'Sök efter:');
INSERT INTO `lang_definitions` VALUES (2622, 8670, 2, 'Sök efter:');
INSERT INTO `lang_definitions` VALUES (2623, 8675, 2, 'Sök efter eller lägg till patient');
INSERT INTO `lang_definitions` VALUES (2624, 8680, 2, 'Sökresultat:');
INSERT INTO `lang_definitions` VALUES (2625, 8687, 2, 'Sök i Evenemang');
INSERT INTO `lang_definitions` VALUES (2626, 8691, 2, 'Sök / Lägg till försäkringsgivaren');
INSERT INTO `lang_definitions` VALUES (2627, 8697, 2, 'Bilbältesanvändning');
INSERT INTO `lang_definitions` VALUES (2628, 8698, 2, 'Andra');
INSERT INTO `lang_definitions` VALUES (2629, 8701, 2, 'Sekundär');
INSERT INTO `lang_definitions` VALUES (2630, 8703, 2, 'Sekundär Försäkring');
INSERT INTO `lang_definitions` VALUES (2631, 8704, 2, 'Sekundär Försäkrings Data');
INSERT INTO `lang_definitions` VALUES (2632, 8720, 2, 'Se Alla');
INSERT INTO `lang_definitions` VALUES (2633, 8722, 2, 'Se Auktoriseringar');
INSERT INTO `lang_definitions` VALUES (2634, 8729, 2, 'Sett sedan');
INSERT INTO `lang_definitions` VALUES (2635, 8735, 2, 'Välj');
INSERT INTO `lang_definitions` VALUES (2636, 8749, 2, 'Välj Alla');
INSERT INTO `lang_definitions` VALUES (2637, 8847, 2, 'Selecionar usuários da lista suspensa');
INSERT INTO `lang_definitions` VALUES (2638, 8865, 2, 'Egen lön');
INSERT INTO `lang_definitions` VALUES (2639, 8876, 2, 'Överföring pågår');
INSERT INTO `lang_definitions` VALUES (2640, 8902, 2, 'Avsändare');
INSERT INTO `lang_definitions` VALUES (2641, 8903, 2, 'Avsändar ID');
INSERT INTO `lang_definitions` VALUES (2642, 8918, 2, 'Känslighet:');
INSERT INTO `lang_definitions` VALUES (2643, 8927, 2, 'Skickats');
INSERT INTO `lang_definitions` VALUES (2644, 8930, 2, 'skickas till skrivaren.');
INSERT INTO `lang_definitions` VALUES (2645, 8936, 2, 'Separerade');
INSERT INTO `lang_definitions` VALUES (2646, 8937, 2, 'September');
INSERT INTO `lang_definitions` VALUES (2647, 8955, 2, 'Service Datum:');
INSERT INTO `lang_definitions` VALUES (2648, 8959, 2, 'Service Location');
INSERT INTO `lang_definitions` VALUES (2649, 8965, 2, 'Tjänster');
INSERT INTO `lang_definitions` VALUES (2650, 8966, 2, 'Tjänster efter kategori');
INSERT INTO `lang_definitions` VALUES (2651, 8967, 2, 'Tjänster som Tillhandahålls');
INSERT INTO `lang_definitions` VALUES (2652, 8968, 2, 'Tjänster som tillhandahålls');
INSERT INTO `lang_definitions` VALUES (2653, 8990, 2, 'Inställningar');
INSERT INTO `lang_definitions` VALUES (2654, 8995, 2, 'Svår huvudvärk');
INSERT INTO `lang_definitions` VALUES (2655, 8998, 2, 'Svårighetsgrad av smärta');
INSERT INTO `lang_definitions` VALUES (2656, 8999, 2, 'Svårighetsgrad av smärta:');
INSERT INTO `lang_definitions` VALUES (2657, 9000, 2, 'Kön');
INSERT INTO `lang_definitions` VALUES (2658, 9001, 2, 'Sexuellt överförbara sjukdomar');
INSERT INTO `lang_definitions` VALUES (2659, 9005, 2, 'Dela');
INSERT INTO `lang_definitions` VALUES (2660, 9012, 2, 'Andnöd');
INSERT INTO `lang_definitions` VALUES (2661, 9018, 2, 'bör vara som nnnnn-nnnn-nn');
INSERT INTO `lang_definitions` VALUES (2662, 9022, 2, 'Axel');
INSERT INTO `lang_definitions` VALUES (2663, 9023, 2, 'Axel + nyckelben');
INSERT INTO `lang_definitions` VALUES (2664, 9024, 2, 'Axelproblem');
INSERT INTO `lang_definitions` VALUES (2665, 9025, 2, 'visa');
INSERT INTO `lang_definitions` VALUES (2666, 9034, 2, 'Visa som upptagen');
INSERT INTO `lang_definitions` VALUES (2667, 9035, 2, 'Visa endast behöriga');
INSERT INTO `lang_definitions` VALUES (2668, 9042, 2, 'Visa detaljer');
INSERT INTO `lang_definitions` VALUES (2669, 9071, 2, 'Visa rapport');
INSERT INTO `lang_definitions` VALUES (2670, 9081, 2, 'Visa endast icke fakturerad');
INSERT INTO `lang_definitions` VALUES (2671, 9095, 2, 'Syskon');
INSERT INTO `lang_definitions` VALUES (2672, 9106, 2, 'Underskrift');
INSERT INTO `lang_definitions` VALUES (2673, 9109, 2, 'Underskrift:');
INSERT INTO `lang_definitions` VALUES (2674, 9112, 2, 'Betydande Svullnad:');
INSERT INTO `lang_definitions` VALUES (2675, 9120, 2, 'Singel');
INSERT INTO `lang_definitions` VALUES (2676, 9139, 2, 'Storlek');
INSERT INTO `lang_definitions` VALUES (2677, 9142, 2, 'Storlek / Lista');
INSERT INTO `lang_definitions` VALUES (2678, 9144, 2, 'Hud');
INSERT INTO `lang_definitions` VALUES (2679, 9155, 2, 'sömn mönster');
INSERT INTO `lang_definitions` VALUES (2680, 9156, 2, 'sover');
INSERT INTO `lang_definitions` VALUES (2681, 9215, 2, 'Social History:');
INSERT INTO `lang_definitions` VALUES (2682, 9218, 2, 'lösning');
INSERT INTO `lang_definitions` VALUES (2683, 9223, 2, 'Vissa möten visas inte. Klicka här för att visa alla.');
INSERT INTO `lang_definitions` VALUES (2684, 9226, 2, 'Vissa anteckningar visades inte');
INSERT INTO `lang_definitions` VALUES (2685, 9229, 2, 'några ord');
INSERT INTO `lang_definitions` VALUES (2686, 9243, 2, 'Sortera efter');
INSERT INTO `lang_definitions` VALUES (2687, 9264, 2, 'Källa');
INSERT INTO `lang_definitions` VALUES (2688, 9268, 2, 'Källa saknas för kod');
INSERT INTO `lang_definitions` VALUES (2689, 9274, 2, 'Källa:');
INSERT INTO `lang_definitions` VALUES (2690, 9287, 2, 'Specialist namn och signatur');
INSERT INTO `lang_definitions` VALUES (2691, 9289, 2, 'Specialtet');
INSERT INTO `lang_definitions` VALUES (2692, 9291, 2, 'Specialitet:');
INSERT INTO `lang_definitions` VALUES (2693, 9292, 2, 'Särskilda');
INSERT INTO `lang_definitions` VALUES (2694, 9296, 2, 'Särskilda tjänster');
INSERT INTO `lang_definitions` VALUES (2695, 9312, 2, 'Tal diktamen');
INSERT INTO `lang_definitions` VALUES (2696, 9313, 2, 'Spermiedödande');
INSERT INTO `lang_definitions` VALUES (2697, 9317, 2, 'Maka');
INSERT INTO `lang_definitions` VALUES (2698, 9320, 2, 'Sputum:');
INSERT INTO `lang_definitions` VALUES (2699, 9334, 2, 'Personnummmer');
INSERT INTO `lang_definitions` VALUES (2700, 9336, 2, 'Persnr');
INSERT INTO `lang_definitions` VALUES (2701, 9337, 2, 'Stabilitet');
INSERT INTO `lang_definitions` VALUES (2702, 9340, 2, 'Standard');
INSERT INTO `lang_definitions` VALUES (2703, 9349, 2, 'Start');
INSERT INTO `lang_definitions` VALUES (2704, 9350, 2, 'Start (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (2705, 9356, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (2706, 9358, 2, 'Start datum vid denna klinik');
INSERT INTO `lang_definitions` VALUES (2707, 9360, 2, 'Startdatum:');
INSERT INTO `lang_definitions` VALUES (2708, 9361, 2, 'Startdatum:');
INSERT INTO `lang_definitions` VALUES (2709, 9363, 2, 'Start tid');
INSERT INTO `lang_definitions` VALUES (2710, 9365, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (2711, 9370, 2, 'Stat');
INSERT INTO `lang_definitions` VALUES (2712, 9379, 2, 'församling');
INSERT INTO `lang_definitions` VALUES (2713, 9390, 2, 'Statistik');
INSERT INTO `lang_definitions` VALUES (2714, 9391, 2, 'Övrigt');
INSERT INTO `lang_definitions` VALUES (2715, 9392, 2, 'Status');
INSERT INTO `lang_definitions` VALUES (2716, 9397, 2, 'Oförändrat');
INSERT INTO `lang_definitions` VALUES (2717, 9413, 2, 'Stela leder');
INSERT INTO `lang_definitions` VALUES (2718, 9417, 2, 'Ont i magen');
INSERT INTO `lang_definitions` VALUES (2719, 9423, 2, 'Överbelastade muskler');
INSERT INTO `lang_definitions` VALUES (2720, 9426, 2, 'Gata');
INSERT INTO `lang_definitions` VALUES (2721, 9428, 2, 'Gatu nummer');
INSERT INTO `lang_definitions` VALUES (2722, 9429, 2, 'styrka');
INSERT INTO `lang_definitions` VALUES (2723, 9432, 2, 'Stress fraktur');
INSERT INTO `lang_definitions` VALUES (2724, 9433, 2, 'Stresstest');
INSERT INTO `lang_definitions` VALUES (2725, 9435, 2, 'Stroke');
INSERT INTO `lang_definitions` VALUES (2726, 9444, 2, 'Delsumma');
INSERT INTO `lang_definitions` VALUES (2727, 9445, 2, 'Underkategori');
INSERT INTO `lang_definitions` VALUES (2728, 9446, 2, 'underkategori');
INSERT INTO `lang_definitions` VALUES (2729, 9447, 2, 'subkutant');
INSERT INTO `lang_definitions` VALUES (2730, 9449, 2, 'Anamnes');
INSERT INTO `lang_definitions` VALUES (2731, 9450, 2, 'Sublingual');
INSERT INTO `lang_definitions` VALUES (2732, 9451, 2, 'sublingual');
INSERT INTO `lang_definitions` VALUES (2733, 9452, 2, 'Lämna in');
INSERT INTO `lang_definitions` VALUES (2734, 9457, 2, 'Lämna in händelsen');
INSERT INTO `lang_definitions` VALUES (2735, 9458, 2, 'lämna in blanketten');
INSERT INTO `lang_definitions` VALUES (2736, 9463, 2, 'Inlämnat av');
INSERT INTO `lang_definitions` VALUES (2737, 9465, 2, 'Prenuremant');
INSERT INTO `lang_definitions` VALUES (2738, 9466, 2, 'Prenuremants Adress');
INSERT INTO `lang_definitions` VALUES (2739, 9498, 2, 'Ersättare');
INSERT INTO `lang_definitions` VALUES (2740, 9499, 2, 'Ersättare tillåts');
INSERT INTO `lang_definitions` VALUES (2741, 9525, 2, 'Självmord');
INSERT INTO `lang_definitions` VALUES (2742, 9527, 2, 'Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2743, 9534, 2, 'Sön');
INSERT INTO `lang_definitions` VALUES (2744, 9536, 2, 'Söndag');
INSERT INTO `lang_definitions` VALUES (2745, 9568, 2, 'Kirurgi');
INSERT INTO `lang_definitions` VALUES (2746, 9570, 2, 'avstänga');
INSERT INTO `lang_definitions` VALUES (2747, 9571, 2, 'Uppslammad vätska');
INSERT INTO `lang_definitions` VALUES (2748, 9578, 2, 'Svenska');
INSERT INTO `lang_definitions` VALUES (2749, 9602, 2, '3 ggr/dag');
INSERT INTO `lang_definitions` VALUES (2750, 9608, 2, 'Tabell skapas inte');
INSERT INTO `lang_definitions` VALUES (2751, 9609, 2, 'Tabell uppdateringen misslyckades');
INSERT INTO `lang_definitions` VALUES (2752, 9611, 2, 'tablett');
INSERT INTO `lang_definitions` VALUES (2753, 9620, 2, 'Ta');
INSERT INTO `lang_definitions` VALUES (2754, 9625, 2, 'Tar lång tid');
INSERT INTO `lang_definitions` VALUES (2755, 9646, 2, 'Skatter');
INSERT INTO `lang_definitions` VALUES (2756, 9668, 2, 'Mall');
INSERT INTO `lang_definitions` VALUES (2757, 9672, 2, 'Mall:');
INSERT INTO `lang_definitions` VALUES (2758, 9690, 2, 'Testa schema');
INSERT INTO `lang_definitions` VALUES (2759, 9691, 2, 'Testa system');
INSERT INTO `lang_definitions` VALUES (2760, 9713, 2, 'Tack');
INSERT INTO `lang_definitions` VALUES (2761, 9753, 2, 'Påstående ärendet:');
INSERT INTO `lang_definitions` VALUES (2762, 9818, 2, 'Händelsen har godkänts.');
INSERT INTO `lang_definitions` VALUES (2763, 9819, 2, 'Händelsen har gömts undan');
INSERT INTO `lang_definitions` VALUES (2764, 9846, 2, 'Följande kalenderhändelse har lagts till:');
INSERT INTO `lang_definitions` VALUES (2765, 9847, 2, 'Följande kalenderhändelse har modifierats:');
INSERT INTO `lang_definitions` VALUES (2766, 10058, 2, 'Terapeutiska Injektioner');
INSERT INTO `lang_definitions` VALUES (2767, 10068, 2, 'Det är fel med din ansökan. Dessa beskrivs nedan.');
INSERT INTO `lang_definitions` VALUES (2768, 10077, 2, 'Det finns inga nya synpunkter');
INSERT INTO `lang_definitions` VALUES (2769, 10112, 2, 'Det uppstod ett fel när din begäran behandlades.');
INSERT INTO `lang_definitions` VALUES (2770, 10137, 2, 'Förtjockad Höger:');
INSERT INTO `lang_definitions` VALUES (2771, 10138, 2, 'Lår');
INSERT INTO `lang_definitions` VALUES (2772, 10139, 2, 'Lår + knäsena');
INSERT INTO `lang_definitions` VALUES (2773, 10156, 2, 'Tredje');
INSERT INTO `lang_definitions` VALUES (2774, 10186, 2, 'Pågående besök');
INSERT INTO `lang_definitions` VALUES (2775, 10205, 2, 'Detta fakturanumret har ändrats till');
INSERT INTO `lang_definitions` VALUES (2776, 10254, 2, 'Denna patient har ingen aktivitet');
INSERT INTO `lang_definitions` VALUES (2777, 10255, 2, 'Denna patients ID används redan!');
INSERT INTO `lang_definitions` VALUES (2778, 10329, 2, 'Tor');
INSERT INTO `lang_definitions` VALUES (2779, 10331, 2, 'torsdag');
INSERT INTO `lang_definitions` VALUES (2780, 10332, 2, 'Torsdag');
INSERT INTO `lang_definitions` VALUES (2781, 10334, 2, 'Sköldkörtel normal');
INSERT INTO `lang_definitions` VALUES (2782, 10349, 2, 'Tid');
INSERT INTO `lang_definitions` VALUES (2783, 10360, 2, 'beräkna tid på händelse');
INSERT INTO `lang_definitions` VALUES (2784, 10362, 2, 'Tidsstämpel och Text');
INSERT INTO `lang_definitions` VALUES (2785, 10367, 2, 'Titel');
INSERT INTO `lang_definitions` VALUES (2786, 10374, 2, 'till');
INSERT INTO `lang_definitions` VALUES (2787, 10375, 2, 'Till');
INSERT INTO `lang_definitions` VALUES (2788, 10376, 2, 'TILL');
INSERT INTO `lang_definitions` VALUES (2789, 10384, 2, 'På det påverkade området');
INSERT INTO `lang_definitions` VALUES (2790, 10385, 2, 'på det påverkade området');
INSERT INTO `lang_definitions` VALUES (2791, 10391, 2, 'till kategori');
INSERT INTO `lang_definitions` VALUES (2792, 10395, 2, 'Till medbetalare');
INSERT INTO `lang_definitions` VALUES (2793, 10417, 2, 'Till Besök');
INSERT INTO `lang_definitions` VALUES (2794, 10418, 2, 'Om du vill filtrera efter kön');
INSERT INTO `lang_definitions` VALUES (2795, 10425, 2, 'Till Historik');
INSERT INTO `lang_definitions` VALUES (2796, 10427, 2, 'Till frågor');
INSERT INTO `lang_definitions` VALUES (2797, 10430, 2, 'För att länka detta besök till objekt i ovanstående lista, markera önskade objekt och klicka sedan på [spara]. Håll ner [Ctrl] för att markera fler objekt.');
INSERT INTO `lang_definitions` VALUES (2798, 10432, 2, 'för att logga in igen');
INSERT INTO `lang_definitions` VALUES (2799, 10447, 2, 'Huden');
INSERT INTO `lang_definitions` VALUES (2800, 10448, 2, 'huden');
INSERT INTO `lang_definitions` VALUES (2801, 10450, 2, 'Till detta besök?');
INSERT INTO `lang_definitions` VALUES (2802, 10455, 2, 'Till:');
INSERT INTO `lang_definitions` VALUES (2803, 10456, 2, 'Till:');
INSERT INTO `lang_definitions` VALUES (2804, 10470, 2, 'Tobak');
INSERT INTO `lang_definitions` VALUES (2805, 10473, 2, 'Tobaks användande');
INSERT INTO `lang_definitions` VALUES (2806, 10477, 2, 'Idag');
INSERT INTO `lang_definitions` VALUES (2807, 10482, 2, 'Dagens datum');
INSERT INTO `lang_definitions` VALUES (2808, 10483, 2, 'Dagens händelser');
INSERT INTO `lang_definitions` VALUES (2809, 10492, 2, 'Tonsillektomi');
INSERT INTO `lang_definitions` VALUES (2810, 10495, 2, 'Topp');
INSERT INTO `lang_definitions` VALUES (2811, 10498, 2, 'Ämne');
INSERT INTO `lang_definitions` VALUES (2812, 10499, 2, 'Totalt');
INSERT INTO `lang_definitions` VALUES (2813, 10500, 2, 'totalt');
INSERT INTO `lang_definitions` VALUES (2814, 10506, 2, 'Sammanlagt belopp som betalats');
INSERT INTO `lang_definitions` VALUES (2815, 10509, 2, 'Totala kostnader');
INSERT INTO `lang_definitions` VALUES (2816, 10510, 2, 'Totalt antal Kunder');
INSERT INTO `lang_definitions` VALUES (2817, 10517, 2, 'Totalt för');
INSERT INTO `lang_definitions` VALUES (2818, 10518, 2, 'Totalt för');
INSERT INTO `lang_definitions` VALUES (2819, 10519, 2, 'Totalt för kategori');
INSERT INTO `lang_definitions` VALUES (2820, 10529, 2, 'Totalt antal patienter');
INSERT INTO `lang_definitions` VALUES (2821, 10550, 2, 'Totalt');
INSERT INTO `lang_definitions` VALUES (2822, 10551, 2, 'Totalbeloppen för');
INSERT INTO `lang_definitions` VALUES (2823, 10552, 2, 'Totalbeloppen för');
INSERT INTO `lang_definitions` VALUES (2824, 10574, 2, 'Utbildnings sort');
INSERT INTO `lang_definitions` VALUES (2825, 10575, 2, 'Remiss m.m.');
INSERT INTO `lang_definitions` VALUES (2826, 10576, 2, 'Transaktion');
INSERT INTO `lang_definitions` VALUES (2827, 10577, 2, 'Transaktion');
INSERT INTO `lang_definitions` VALUES (2828, 10581, 2, 'Transaktionstyp');
INSERT INTO `lang_definitions` VALUES (2829, 10582, 2, 'Transaktioner');
INSERT INTO `lang_definitions` VALUES (2830, 10584, 2, 'Transaktioner (skriva valfritt)');
INSERT INTO `lang_definitions` VALUES (2831, 10590, 2, 'Transaktioner / Övergångar');
INSERT INTO `lang_definitions` VALUES (2832, 10608, 2, 'översätt detta');
INSERT INTO `lang_definitions` VALUES (2833, 10609, 2, 'översätta');
INSERT INTO `lang_definitions` VALUES (2834, 10618, 2, 'Trauma');
INSERT INTO `lang_definitions` VALUES (2835, 10621, 2, 'Behandlings mål');
INSERT INTO `lang_definitions` VALUES (2836, 10622, 2, 'Behandlings plan');
INSERT INTO `lang_definitions` VALUES (2837, 10625, 2, 'Behandling:');
INSERT INTO `lang_definitions` VALUES (2838, 10626, 2, 'Behandling:');
INSERT INTO `lang_definitions` VALUES (2839, 10643, 2, 'tesked');
INSERT INTO `lang_definitions` VALUES (2840, 10647, 2, 'Tis');
INSERT INTO `lang_definitions` VALUES (2841, 10649, 2, 'Tisdag');
INSERT INTO `lang_definitions` VALUES (2842, 10650, 2, 'Tumör');
INSERT INTO `lang_definitions` VALUES (2843, 10659, 2, 'två gånger dagligen');
INSERT INTO `lang_definitions` VALUES (2844, 10664, 2, 'Typ');
INSERT INTO `lang_definitions` VALUES (2845, 10679, 2, 'Skriv in eller skanna patientidentifikation här');
INSERT INTO `lang_definitions` VALUES (2846, 10708, 2, 'Ulcerations');
INSERT INTO `lang_definitions` VALUES (2847, 10709, 2, 'Ulcerös kolit');
INSERT INTO `lang_definitions` VALUES (2848, 10710, 2, 'Sår:');
INSERT INTO `lang_definitions` VALUES (2849, 10727, 2, 'Ej tilldelad');
INSERT INTO `lang_definitions` VALUES (2850, 10730, 2, 'Obehörig åtkomst.');
INSERT INTO `lang_definitions` VALUES (2851, 10735, 2, 'under tungan');
INSERT INTO `lang_definitions` VALUES (2852, 10738, 2, 'Undervikt');
INSERT INTO `lang_definitions` VALUES (2853, 10739, 2, 'odiagnosticerad');
INSERT INTO `lang_definitions` VALUES (2854, 10744, 2, 'Ångra Kassa');
INSERT INTO `lang_definitions` VALUES (2855, 10746, 2, 'Unika Kunder');
INSERT INTO `lang_definitions` VALUES (2856, 10748, 2, 'Unika nya kunder');
INSERT INTO `lang_definitions` VALUES (2857, 10753, 2, 'Enhet');
INSERT INTO `lang_definitions` VALUES (2858, 10754, 2, 'Enheter');
INSERT INTO `lang_definitions` VALUES (2859, 10755, 2, 'enheter');
INSERT INTO `lang_definitions` VALUES (2860, 10761, 2, 'Okänt');
INSERT INTO `lang_definitions` VALUES (2861, 10765, 2, 'Okänd eller N / A');
INSERT INTO `lang_definitions` VALUES (2862, 10776, 2, 'Namnlöst försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2863, 10777, 2, 'Oregistrerad');
INSERT INTO `lang_definitions` VALUES (2864, 10780, 2, 'Avmarkera alla');
INSERT INTO `lang_definitions` VALUES (2865, 10781, 2, 'Omarkerat');
INSERT INTO `lang_definitions` VALUES (2866, 10782, 2, 'Ospecificerad');
INSERT INTO `lang_definitions` VALUES (2867, 10787, 2, 'tills');
INSERT INTO `lang_definitions` VALUES (2868, 10791, 2, 'Outnyttjad');
INSERT INTO `lang_definitions` VALUES (2869, 10793, 2, 'Upp till');
INSERT INTO `lang_definitions` VALUES (2870, 10795, 2, 'Kommande möten');
INSERT INTO `lang_definitions` VALUES (2871, 10796, 2, 'Kommande evenemang');
INSERT INTO `lang_definitions` VALUES (2872, 10797, 2, 'Uppdatera');
INSERT INTO `lang_definitions` VALUES (2873, 10798, 2, 'uppdatera');
INSERT INTO `lang_definitions` VALUES (2874, 10801, 2, 'Uppdateringsfilerna');
INSERT INTO `lang_definitions` VALUES (2875, 10802, 2, 'Uppdatera Info');
INSERT INTO `lang_definitions` VALUES (2876, 10825, 2, 'Uppladdning');
INSERT INTO `lang_definitions` VALUES (2877, 10831, 2, 'Ladda upp dokument');
INSERT INTO `lang_definitions` VALUES (2878, 10834, 2, 'Ladda upp fil att importera:');
INSERT INTO `lang_definitions` VALUES (2879, 10838, 2, 'Ladda upp rapport');
INSERT INTO `lang_definitions` VALUES (2880, 10841, 2, 'Ladda upp den här filen:');
INSERT INTO `lang_definitions` VALUES (2881, 10851, 2, 'Överarmen');
INSERT INTO `lang_definitions` VALUES (2882, 10854, 2, 'Brådskande');
INSERT INTO `lang_definitions` VALUES (2883, 10859, 2, 'Urin Frekvens');
INSERT INTO `lang_definitions` VALUES (2884, 10860, 2, 'Urin Tveksamhet');
INSERT INTO `lang_definitions` VALUES (2885, 10864, 2, 'URL');
INSERT INTO `lang_definitions` VALUES (2886, 10878, 2, 'Använd 24-timmars format?');
INSERT INTO `lang_definitions` VALUES (2887, 10898, 2, 'Använd Standardinställningar');
INSERT INTO `lang_definitions` VALUES (2888, 10900, 2, 'Använd internationellt utseende på datum?');
INSERT INTO `lang_definitions` VALUES (2889, 10911, 2, 'Använd ämnen?');
INSERT INTO `lang_definitions` VALUES (2890, 10913, 2, 'Användare');
INSERT INTO `lang_definitions` VALUES (2891, 10916, 2, 'Användaradministration');
INSERT INTO `lang_definitions` VALUES (2892, 10917, 2, 'Användar-och Facility Administration');
INSERT INTO `lang_definitions` VALUES (2893, 10918, 2, 'Användare och grupp Administration');
INSERT INTO `lang_definitions` VALUES (2894, 10923, 2, 'Användardefinierad');
INSERT INTO `lang_definitions` VALUES (2895, 10924, 2, 'Användar definierad Area 11');
INSERT INTO `lang_definitions` VALUES (2896, 10925, 2, 'Användar definierad Area 12');
INSERT INTO `lang_definitions` VALUES (2897, 10949, 2, 'Användare Medlemskap');
INSERT INTO `lang_definitions` VALUES (2898, 10968, 2, 'Användarnamn');
INSERT INTO `lang_definitions` VALUES (2899, 10971, 2, 'Användarnamn för SMS Gateway');
INSERT INTO `lang_definitions` VALUES (2900, 10974, 2, 'Användarnamn:');
INSERT INTO `lang_definitions` VALUES (2901, 10975, 2, 'Användare');
INSERT INTO `lang_definitions` VALUES (2902, 10979, 2, 'Användare / grupper / Logs Administration');
INSERT INTO `lang_definitions` VALUES (2903, 11000, 2, 'SEMESTER');
INSERT INTO `lang_definitions` VALUES (2904, 11001, 2, 'Semester');
INSERT INTO `lang_definitions` VALUES (2905, 11002, 2, 'Vaccin');
INSERT INTO `lang_definitions` VALUES (2906, 11016, 2, 'Wert');
INSERT INTO `lang_definitions` VALUES (2907, 11017, 2, 'Wert 1');
INSERT INTO `lang_definitions` VALUES (2908, 11018, 2, 'Wert 2');
INSERT INTO `lang_definitions` VALUES (2909, 11020, 2, 'Wert muss numerisch sein');
INSERT INTO `lang_definitions` VALUES (2910, 11030, 2, 'Blodkärls kondition');
INSERT INTO `lang_definitions` VALUES (2911, 11031, 2, 'Blodkärsl skada');
INSERT INTO `lang_definitions` VALUES (2912, 11032, 2, 'Kärlkirurgi');
INSERT INTO `lang_definitions` VALUES (2913, 11040, 2, 'Version');
INSERT INTO `lang_definitions` VALUES (2914, 11059, 2, 'Svindel');
INSERT INTO `lang_definitions` VALUES (2915, 11073, 2, 'visa');
INSERT INTO `lang_definitions` VALUES (2916, 11074, 2, 'Visa');
INSERT INTO `lang_definitions` VALUES (2917, 11076, 2, 'Visa allergier');
INSERT INTO `lang_definitions` VALUES (2918, 11082, 2, 'Visa Omfattande Patient Rapport');
INSERT INTO `lang_definitions` VALUES (2919, 11085, 2, 'Visa dokument');
INSERT INTO `lang_definitions` VALUES (2920, 11087, 2, 'Visa möte');
INSERT INTO `lang_definitions` VALUES (2921, 11089, 2, 'Visa händelser i ett popup-fönster?');
INSERT INTO `lang_definitions` VALUES (2922, 11096, 2, 'Visa Sida 1');
INSERT INTO `lang_definitions` VALUES (2923, 11097, 2, 'Visa sida 2');
INSERT INTO `lang_definitions` VALUES (2924, 11106, 2, 'Se relaterade möten');
INSERT INTO `lang_definitions` VALUES (2925, 11123, 2, 'Visa:');
INSERT INTO `lang_definitions` VALUES (2926, 11124, 2, 'VISA');
INSERT INTO `lang_definitions` VALUES (2927, 11125, 2, 'VISA/MC/AMEX/Dis');
INSERT INTO `lang_definitions` VALUES (2928, 11127, 2, 'Visceral skada / trauma / kirurgi');
INSERT INTO `lang_definitions` VALUES (2929, 11134, 2, 'Besökskategori:');
INSERT INTO `lang_definitions` VALUES (2930, 11135, 2, 'Besöks Datum');
INSERT INTO `lang_definitions` VALUES (2931, 11150, 2, 'Besök');
INSERT INTO `lang_definitions` VALUES (2932, 11151, 2, 'Besök från');
INSERT INTO `lang_definitions` VALUES (2933, 11156, 2, 'Vitalparametrar');
INSERT INTO `lang_definitions` VALUES (2934, 11157, 2, 'Vitalparametrar');
INSERT INTO `lang_definitions` VALUES (2935, 11158, 2, 'Vitalparametrar (metriska)');
INSERT INTO `lang_definitions` VALUES (2936, 11159, 2, 'Vitalparametrar Formulär inställningar');
INSERT INTO `lang_definitions` VALUES (2937, 11168, 2, 'Kräkningar');
INSERT INTO `lang_definitions` VALUES (2938, 11172, 2, 'W');
INSERT INTO `lang_definitions` VALUES (2939, 11177, 2, 'Väntar');
INSERT INTO `lang_definitions` VALUES (2940, 11188, 2, 'Varm');
INSERT INTO `lang_definitions` VALUES (2941, 11190, 2, 'VARNING');
INSERT INTO `lang_definitions` VALUES (2942, 11194, 2, 'Varning: Ett besök var redan skapat för denna patient idag!');
INSERT INTO `lang_definitions` VALUES (2943, 11199, 2, 'Varning: patient-ID är inte unikt!');
INSERT INTO `lang_definitions` VALUES (2944, 11221, 2, 'Svaghet');
INSERT INTO `lang_definitions` VALUES (2945, 11227, 2, 'Hemsida');
INSERT INTO `lang_definitions` VALUES (2946, 11231, 2, 'Ons');
INSERT INTO `lang_definitions` VALUES (2947, 11232, 2, 'Onsdag');
INSERT INTO `lang_definitions` VALUES (2948, 11233, 2, 'Vecka');
INSERT INTO `lang_definitions` VALUES (2949, 11234, 2, 'vecka');
INSERT INTO `lang_definitions` VALUES (2950, 11235, 2, 'Veckovy');
INSERT INTO `lang_definitions` VALUES (2951, 11236, 2, 'Veckan (s)');
INSERT INTO `lang_definitions` VALUES (2952, 11240, 2, 'Vikt');
INSERT INTO `lang_definitions` VALUES (2953, 11243, 2, 'Vikt förändring');
INSERT INTO `lang_definitions` VALUES (2954, 11244, 2, 'Viktminskning');
INSERT INTO `lang_definitions` VALUES (2955, 11261, 2, 'Vad är det som räknas?');
INSERT INTO `lang_definitions` VALUES (2956, 11265, 2, 'Wheezing:');
INSERT INTO `lang_definitions` VALUES (2957, 11289, 2, 'Whiplash');
INSERT INTO `lang_definitions` VALUES (2958, 11293, 2, 'Vem');
INSERT INTO `lang_definitions` VALUES (2959, 11294, 2, 'Vem har svarat?');
INSERT INTO `lang_definitions` VALUES (2960, 11296, 2, 'Änka/änkeman');
INSERT INTO `lang_definitions` VALUES (2961, 11297, 2, 'Vidd');
INSERT INTO `lang_definitions` VALUES (2962, 11299, 2, 'Vidd i punkter på vänstra navigeringsfönstret');
INSERT INTO `lang_definitions` VALUES (2963, 11306, 2, 'Med vald:');
INSERT INTO `lang_definitions` VALUES (2964, 11307, 2, 'med det gamla namnet');
INSERT INTO `lang_definitions` VALUES (2965, 11310, 2, 'Med vem kan vi lämna ett meddelande?');
INSERT INTO `lang_definitions` VALUES (2966, 11311, 2, 'Återtagen/innehållen');
INSERT INTO `lang_definitions` VALUES (2967, 11312, 2, 'inom några timmar');
INSERT INTO `lang_definitions` VALUES (2968, 11313, 2, 'inom några timmar:');
INSERT INTO `lang_definitions` VALUES (2969, 11314, 2, 'inom några minuter');
INSERT INTO `lang_definitions` VALUES (2970, 11315, 2, 'inom några minuter:');
INSERT INTO `lang_definitions` VALUES (2971, 11318, 2, 'Utan Updatering');
INSERT INTO `lang_definitions` VALUES (2972, 11319, 2, 'vittne');
INSERT INTO `lang_definitions` VALUES (2973, 11323, 2, 'Kvinnor');
INSERT INTO `lang_definitions` VALUES (2974, 11324, 2, 'Enbart kvinnor');
INSERT INTO `lang_definitions` VALUES (2975, 11326, 2, 'Arbete');
INSERT INTO `lang_definitions` VALUES (2976, 11328, 2, 'Telefon, arbete');
INSERT INTO `lang_definitions` VALUES (2977, 11329, 2, 'Telefon, Arbete, Nummer');
INSERT INTO `lang_definitions` VALUES (2978, 11330, 2, 'Arbetsrelaterat?');
INSERT INTO `lang_definitions` VALUES (2979, 11331, 2, 'Arbete/ Utbildning/ Hobby');
INSERT INTO `lang_definitions` VALUES (2980, 11332, 2, 'Arbete / Skola Anmärkning');
INSERT INTO `lang_definitions` VALUES (2981, 11333, 2, 'arbetsdag');
INSERT INTO `lang_definitions` VALUES (2982, 11339, 2, 'förvärrad');
INSERT INTO `lang_definitions` VALUES (2983, 11351, 2, 'Handled');
INSERT INTO `lang_definitions` VALUES (2984, 11352, 2, 'Handled och hand');
INSERT INTO `lang_definitions` VALUES (2985, 11353, 2, 'Handleds Problem');
INSERT INTO `lang_definitions` VALUES (2986, 11354, 2, 'skriv');
INSERT INTO `lang_definitions` VALUES (2987, 11356, 2, 'avskriva');
INSERT INTO `lang_definitions` VALUES (2988, 11365, 2, 'x inställt');
INSERT INTO `lang_definitions` VALUES (2989, 11367, 2, 'Röntgen');
INSERT INTO `lang_definitions` VALUES (2990, 11368, 2, 'Röntgen Tolkning:');
INSERT INTO `lang_definitions` VALUES (2991, 11369, 2, 'Röntgen Tolkning:');
INSERT INTO `lang_definitions` VALUES (2992, 11373, 2, 'Endast X12: Ersättningskrav');
INSERT INTO `lang_definitions` VALUES (2993, 11376, 2, 'X12 Partner');
INSERT INTO `lang_definitions` VALUES (2994, 11377, 2, 'X12 Partners');
INSERT INTO `lang_definitions` VALUES (2995, 11385, 2, 'Y');
INSERT INTO `lang_definitions` VALUES (2996, 11386, 2, 'år');
INSERT INTO `lang_definitions` VALUES (2997, 11387, 2, 'År');
INSERT INTO `lang_definitions` VALUES (2998, 11388, 2, 'År Visa');
INSERT INTO `lang_definitions` VALUES (2999, 11389, 2, 'År');
INSERT INTO `lang_definitions` VALUES (3000, 11394, 2, 'Ja');
INSERT INTO `lang_definitions` VALUES (3001, 11395, 2, 'JA');
INSERT INTO `lang_definitions` VALUES (3002, 11396, 2, 'ja');
INSERT INTO `lang_definitions` VALUES (3003, 11397, 2, 'JA!');
INSERT INTO `lang_definitions` VALUES (3004, 11398, 2, 'Ja, radera och logga');
INSERT INTO `lang_definitions` VALUES (3005, 11400, 2, 'Ja/Nej');
INSERT INTO `lang_definitions` VALUES (3006, 11401, 2, 'Ja:');
INSERT INTO `lang_definitions` VALUES (3007, 11406, 2, 'Du håller på att permanent ersätta den befintliga mallen. Är du säker på att du vill fortsätta?');
INSERT INTO `lang_definitions` VALUES (3008, 11409, 2, 'Det är inte tillåtet att ta bort denna händelse');
INSERT INTO `lang_definitions` VALUES (3009, 11410, 2, 'Du har inte tillåtelse att redigera den här händelsen');
INSERT INTO `lang_definitions` VALUES (3010, 11411, 2, 'Du har inte behörighet för detta.');
INSERT INTO `lang_definitions` VALUES (3011, 11413, 2, 'Du har inte behörighet att komma åt den här gruppen.');
INSERT INTO `lang_definitions` VALUES (3012, 11414, 2, 'Du har inte behörighet att lägga till / redigera frågor');
INSERT INTO `lang_definitions` VALUES (3013, 11416, 2, 'Du har inte behörighet att se det här mötet.');
INSERT INTO `lang_definitions` VALUES (3014, 11435, 2, 'Du kan inte komma åt denna funktion direkt.');
INSERT INTO `lang_definitions` VALUES (3015, 11447, 2, 'Du kan inte komma åt den här sidan direkt.');
INSERT INTO `lang_definitions` VALUES (3016, 11454, 2, 'Du har inte valt några åtgärder.');
INSERT INTO `lang_definitions` VALUES (3017, 11455, 2, 'Du har inte behörighet att se / redigera denna anmärkning');
INSERT INTO `lang_definitions` VALUES (3018, 11479, 2, 'Du måste först välja eller lägga till en patient.');
INSERT INTO `lang_definitions` VALUES (3019, 11480, 2, 'Du måste först välja eller skapa ett möte.');
INSERT INTO `lang_definitions` VALUES (3020, 11483, 2, 'Du måste välja några områden för att fortsätta.');
INSERT INTO `lang_definitions` VALUES (3021, 11509, 2, 'Ditt slutdatum är ogiltig');
INSERT INTO `lang_definitions` VALUES (3022, 11510, 2, 'Din händelse har strukits.');
INSERT INTO `lang_definitions` VALUES (3023, 11511, 2, 'Din händelse har ändrats.');
INSERT INTO `lang_definitions` VALUES (3024, 11512, 2, 'Din händelse har lämnats in.');
INSERT INTO `lang_definitions` VALUES (3025, 11518, 2, 'Din namnlista har ändrats för att uppfylla namngivnings krav.');
INSERT INTO `lang_definitions` VALUES (3026, 11529, 2, 'Din Post Kalender konfiguration har återställts att använda standardvärden.');
INSERT INTO `lang_definitions` VALUES (3027, 11530, 2, 'Din Post Kalender konfiguration har uppdaterats.');
INSERT INTO `lang_definitions` VALUES (3028, 11531, 2, 'Den upprepade frekvens måste vara ett heltal.');
INSERT INTO `lang_definitions` VALUES (3029, 11532, 2, 'Den upprepade frekvensen måste vara minst 1.');
INSERT INTO `lang_definitions` VALUES (3030, 11534, 2, 'Ditt startdatum är större än ditt slutdatum');
INSERT INTO `lang_definitions` VALUES (3031, 11535, 2, 'Ditt startdatum är ogiltig');
INSERT INTO `lang_definitions` VALUES (3032, 11536, 2, 'Ditt förslag misslyckats.');
INSERT INTO `lang_definitions` VALUES (3033, 11539, 2, 'åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (3034, 11541, 2, 'åååå-mm-dd dag är förknippade med detta dokument');
INSERT INTO `lang_definitions` VALUES (3035, 11543, 2, 'åååå-mm-dd födelsedatum');
INSERT INTO `lang_definitions` VALUES (3036, 11544, 2, 'åååå-mm-dd Födelsedatum');
INSERT INTO `lang_definitions` VALUES (3037, 11545, 2, 'ååå-mm-dd datum för utlöpande');
INSERT INTO `lang_definitions` VALUES (3038, 11546, 2, 'åååå-mm-dd Datum för uppkomsten eller sjukhusvistelse');
INSERT INTO `lang_definitions` VALUES (3039, 11547, 2, 'åååå-mm-dd datum debut, kirurgi eller början av medicinering');
INSERT INTO `lang_definitions` VALUES (3040, 11549, 2, 'åååå-mm-dd dagen för tillfrisknande eller slutet av medicinering');
INSERT INTO `lang_definitions` VALUES (3041, 11551, 2, 'åååå-mm-dd Delgivningsdatum');
INSERT INTO `lang_definitions` VALUES (3042, 11552, 2, 'åååå-mm-dd dagen för denna skrivelse');
INSERT INTO `lang_definitions` VALUES (3043, 11554, 2, 'åååå-mm-dd dokumentets datum');
INSERT INTO `lang_definitions` VALUES (3044, 11556, 2, 'åååå-mm-dd händelse datum eller startdatum');
INSERT INTO `lang_definitions` VALUES (3045, 11563, 2, 'åååå-mm-dd sista datum för detta evenemang');
INSERT INTO `lang_definitions` VALUES (3046, 11569, 2, 'noll');
INSERT INTO `lang_definitions` VALUES (3047, 11571, 2, 'postadress');
INSERT INTO `lang_definitions` VALUES (3048, 11572, 2, 'postnummer');
INSERT INTO `lang_definitions` VALUES (3049, 11573, 2, 'land');
INSERT INTO `lang_definitions` VALUES (3050, 11579, 2, 'men var');
INSERT INTO `lang_definitions` VALUES (3051, 11580, 2, 'gick inte att komma åt');
INSERT INTO `lang_definitions` VALUES (3052, 11581, 2, 'Vill du verkligen radera');
INSERT INTO `lang_definitions` VALUES (3053, 11582, 2, 'läkemedel');
INSERT INTO `lang_definitions` VALUES (3054, 11583, 2, 'e-postmeddelande ej skickat');
INSERT INTO `lang_definitions` VALUES (3055, 11584, 2, 'från');
INSERT INTO `lang_definitions` VALUES (3056, 11585, 2, 'har skapats');
INSERT INTO `lang_definitions` VALUES (3057, 11586, 2, 'har återupptagits');
INSERT INTO `lang_definitions` VALUES (3058, 11587, 2, 'Historia');
INSERT INTO `lang_definitions` VALUES (3059, 11588, 2, 'är inget nummer');
INSERT INTO `lang_definitions` VALUES (3060, 11589, 2, 'är redo för ny fakturering');
INSERT INTO `lang_definitions` VALUES (3061, 11590, 2, 'LLL:');
INSERT INTO `lang_definitions` VALUES (3062, 11591, 2, 'Batchnr');
INSERT INTO `lang_definitions` VALUES (3063, 11592, 2, 'Medicaid orginal referensnr.');
INSERT INTO `lang_definitions` VALUES (3064, 11594, 2, 'finns ej!');
INSERT INTO `lang_definitions` VALUES (3065, 11597, 2, 'Tills');
INSERT INTO `lang_definitions` VALUES (3066, 11598, 2, 'Uppdateringen misslyckades, inte i databasen?');
INSERT INTO `lang_definitions` VALUES (3067, 11599, 2, 'präglades som faktureras endast.');
INSERT INTO `lang_definitions` VALUES (3068, 11600, 2, 'var kö framgångsrikt.');
INSERT INTO `lang_definitions` VALUES (3069, 11601, 2, '! Lämnat utan besök');
INSERT INTO `lang_definitions` VALUES (3070, 11602, 2, '\" För kod');
INSERT INTO `lang_definitions` VALUES (3071, 11603, 2, '\" Kontrolleras PostCalendar Inställningar!');
INSERT INTO `lang_definitions` VALUES (3072, 11606, 2, 'kr');
INSERT INTO `lang_definitions` VALUES (3073, 11607, 2, 'Kodningen av kronor är färdig');
INSERT INTO `lang_definitions` VALUES (3074, 11608, 2, '$ etikett (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3075, 11609, 2, '%');
INSERT INTO `lang_definitions` VALUES (3076, 11611, 2, '% Annullerat <24h');
INSERT INTO `lang_definitions` VALUES (3077, 11612, 2, 'bör finnas, men finns inte.');
INSERT INTO `lang_definitions` VALUES (3078, 11613, 2, '(% Matchar alla strängar, _ matchar alla tecken)');
INSERT INTO `lang_definitions` VALUES (3079, 11615, 2, '(Tillbaka)');
INSERT INTO `lang_definitions` VALUES (3080, 11616, 2, '(Klicka för att redigera)');
INSERT INTO `lang_definitions` VALUES (3081, 11618, 2, '(Mer)');
INSERT INTO `lang_definitions` VALUES (3082, 11619, 2, '(Ny Patient)');
INSERT INTO `lang_definitions` VALUES (3083, 11620, 2, '(Anteckningar och Auktoriseringar)');
INSERT INTO `lang_definitions` VALUES (3084, 11621, 2, '(Patient anteckningar)');
INSERT INTO `lang_definitions` VALUES (3085, 11622, 2, '(Välj ett av dessa, eller skriv din egen rubrik)');
INSERT INTO `lang_definitions` VALUES (3086, 11624, 2, '* Påminnelse skickad');
INSERT INTO `lang_definitions` VALUES (3087, 11625, 2, '** Gör om kirurgi till enheter');
INSERT INTO `lang_definitions` VALUES (3088, 11626, 2, '* Obligatorisk');
INSERT INTO `lang_definitions` VALUES (3089, 11627, 2, '+ Patientkort hämtat');
INSERT INTO `lang_definitions` VALUES (3090, 11631, 2, '- Ingen');
INSERT INTO `lang_definitions` VALUES (3091, 11633, 2, '-- Alla --');
INSERT INTO `lang_definitions` VALUES (3092, 11634, 2, '--Välj uppdrag--');
INSERT INTO `lang_definitions` VALUES (3093, 11635, 2, '.');
INSERT INTO `lang_definitions` VALUES (3094, 11636, 2, '0');
INSERT INTO `lang_definitions` VALUES (3095, 11637, 2, '0-10');
INSERT INTO `lang_definitions` VALUES (3096, 11638, 2, '0-24');
INSERT INTO `lang_definitions` VALUES (3097, 11641, 2, '1');
INSERT INTO `lang_definitions` VALUES (3098, 11642, 2, '46 = Sverige. Se http://www.wtng.info för lista på andra landskoder');
INSERT INTO `lang_definitions` VALUES (3099, 11647, 2, '1.Vila 2. Lägg på is i två dagar 3. Komprimering lämna förbandet på plats om inte foten utvecklar domningar eller blek färg 4. Ha foten och ben i Upphöjt läge.');
INSERT INTO `lang_definitions` VALUES (3100, 11648, 2, '11-14');
INSERT INTO `lang_definitions` VALUES (3101, 11649, 2, '12 hr');
INSERT INTO `lang_definitions` VALUES (3102, 11650, 2, '15-19');
INSERT INTO `lang_definitions` VALUES (3103, 11659, 2, '20-24');
INSERT INTO `lang_definitions` VALUES (3104, 11668, 2, '2111-13');
INSERT INTO `lang_definitions` VALUES (3105, 11671, 2, '25-29');
INSERT INTO `lang_definitions` VALUES (3106, 11674, 2, '2:a');
INSERT INTO `lang_definitions` VALUES (3107, 11676, 2, '3 månader');
INSERT INTO `lang_definitions` VALUES (3108, 11678, 2, '3 gånger dagligen');
INSERT INTO `lang_definitions` VALUES (3109, 11680, 2, '30-34');
INSERT INTO `lang_definitions` VALUES (3110, 11681, 2, '35-39');
INSERT INTO `lang_definitions` VALUES (3111, 11683, 2, '3:e');
INSERT INTO `lang_definitions` VALUES (3112, 11685, 2, '4 månader');
INSERT INTO `lang_definitions` VALUES (3113, 11687, 2, '4 gånger dagligen');
INSERT INTO `lang_definitions` VALUES (3114, 11689, 2, '40-44');
INSERT INTO `lang_definitions` VALUES (3115, 11690, 2, '45');
INSERT INTO `lang_definitions` VALUES (3116, 11700, 2, '4:e');
INSERT INTO `lang_definitions` VALUES (3117, 11706, 2, '5:e');
INSERT INTO `lang_definitions` VALUES (3118, 11707, 2, '6 dagar från nu');
INSERT INTO `lang_definitions` VALUES (3119, 11708, 2, '6 månader');
INSERT INTO `lang_definitions` VALUES (3120, 11709, 2, '6 månader från nu');
INSERT INTO `lang_definitions` VALUES (3121, 11710, 2, '6 veckor från nu');
INSERT INTO `lang_definitions` VALUES (3122, 11711, 2, '6:e');
INSERT INTO `lang_definitions` VALUES (3123, 11712, 2, '7 månader från nu');
INSERT INTO `lang_definitions` VALUES (3124, 11713, 2, '8 månader från nu');
INSERT INTO `lang_definitions` VALUES (3125, 11715, 2, '824.0 Sluten fraktur mediala malleolen');
INSERT INTO `lang_definitions` VALUES (3126, 11716, 2, '824.2 Sluten fraktur laterala malleolen');
INSERT INTO `lang_definitions` VALUES (3127, 11717, 2, '842.6 Sluten trimalleolarfraktur');
INSERT INTO `lang_definitions` VALUES (3128, 11718, 2, '825.32 Fraktur os naviculare (fotled)');
INSERT INTO `lang_definitions` VALUES (3129, 11719, 2, '825.35 Fraktur basen av 5:e metatarsalbenet');
INSERT INTO `lang_definitions` VALUES (3130, 11720, 2, '845.00 Stukad fotled UNS');
INSERT INTO `lang_definitions` VALUES (3131, 11721, 2, '845.01 Stukad fotled deltoideus lig.');
INSERT INTO `lang_definitions` VALUES (3132, 11722, 2, '845.02 Stukad fortled, fc-ligament');
INSERT INTO `lang_definitions` VALUES (3133, 11723, 2, '9 månader från nu');
INSERT INTO `lang_definitions` VALUES (3134, 11724, 2, '99212 Etablerade - okomplicerad');
INSERT INTO `lang_definitions` VALUES (3135, 11725, 2, '99213 Etablerade - Låg komplexitet');
INSERT INTO `lang_definitions` VALUES (3136, 11726, 2, '< I undersökningsrummet');
INSERT INTO `lang_definitions` VALUES (3137, 11730, 2, '> Avslutat');
INSERT INTO `lang_definitions` VALUES (3138, 11732, 2, '?');
INSERT INTO `lang_definitions` VALUES (3139, 11734, 2, '? Har ej dykt upp på avtalad tid');
INSERT INTO `lang_definitions` VALUES (3140, 11735, 2, 'Anlänt');
INSERT INTO `lang_definitions` VALUES (3141, 11737, 2, '[Ändra vy]');
INSERT INTO `lang_definitions` VALUES (3142, 11738, 2, '[Datum för senaste mötet]');
INSERT INTO `lang_definitions` VALUES (3143, 11739, 2, '[Dagar sedan senaste mötet]');
INSERT INTO `lang_definitions` VALUES (3144, 11742, 2, '[rekommenderas inte]');
INSERT INTO `lang_definitions` VALUES (3145, 11743, 2, '[Antalet möten]');
INSERT INTO `lang_definitions` VALUES (3146, 11744, 2, '[Rapporter]');
INSERT INTO `lang_definitions` VALUES (3147, 11745, 2, '[Markera alla]');
INSERT INTO `lang_definitions` VALUES (3148, 11746, 2, '[SQL-Ledger]');
INSERT INTO `lang_definitions` VALUES (3149, 11747, 2, '[Starta batchprocess]');
INSERT INTO `lang_definitions` VALUES (3150, 11748, 2, '[Titta på logg]');
INSERT INTO `lang_definitions` VALUES (3151, 11749, 2, '[Se utskrivbar rapport]');
INSERT INTO `lang_definitions` VALUES (3152, 11751, 2, '_PC_DUR_HOURS');
INSERT INTO `lang_definitions` VALUES (3153, 11752, 2, '_PC_DUR_MINUTES');
INSERT INTO `lang_definitions` VALUES (3154, 11753, 2, '_PC_LOCALE');
INSERT INTO `lang_definitions` VALUES (3155, 11754, 2, '~ Kommit sent');
INSERT INTO `lang_definitions` VALUES (3156, 1, 3, 'Un, Una');
INSERT INTO `lang_definitions` VALUES (3157, 2, 3, 'Un número de cheque o reclamación para identificar el pago');
INSERT INTO `lang_definitions` VALUES (3158, 4, 3, 'Un certificado de cliente para el usuario administrador');
INSERT INTO `lang_definitions` VALUES (3159, 6, 3, 'Adjunto está un documento clínico.');
INSERT INTO `lang_definitions` VALUES (3160, 7, 3, 'Adjunto está un documento clínico.');
INSERT INTO `lang_definitions` VALUES (3161, 13, 3, 'Se requiere un distribuidor');
INSERT INTO `lang_definitions` VALUES (3162, 17, 3, 'Formulario de visita GCAC debe ser agregado a esta visita');
INSERT INTO `lang_definitions` VALUES (3163, 20, 3, 'Un número de lote es requerido');
INSERT INTO `lang_definitions` VALUES (3164, 21, 3, 'Un número de lote es requerido!');
INSERT INTO `lang_definitions` VALUES (3165, 22, 3, 'Una letra minúscula');
INSERT INTO `lang_definitions` VALUES (3166, 27, 3, 'Un número');
INSERT INTO `lang_definitions` VALUES (3167, 28, 3, 'Debe seleccionar un paciente para generar un reporte');
INSERT INTO `lang_definitions` VALUES (3168, 29, 3, 'Un paciente con ese Nº ID ya existe');
INSERT INTO `lang_definitions` VALUES (3169, 30, 3, 'Un paciente con este nombre ya existe.');
INSERT INTO `lang_definitions` VALUES (3170, 31, 3, 'Un paciente con este Nº Seguridad Social ya existe');
INSERT INTO `lang_definitions` VALUES (3171, 35, 3, 'Un número positivo mostrará tantas citas pasadas en un Widget en la pantalla de resumen del cliente (un número negativo mostrará las citas pasadas en orden descendente)');
INSERT INTO `lang_definitions` VALUES (3172, 36, 3, 'Un número positivo mostrará tantas citas pasadas en un Widget en la pantalla de resumen del cliente (un número negativo mostrará las citas pasadas en orden descendente)');
INSERT INTO `lang_definitions` VALUES (3173, 41, 3, 'Una fuente de derivación puede ser especificada para cada visita');
INSERT INTO `lang_definitions` VALUES (3174, 42, 3, 'Un código IPPF relacionado es requerido!');
INSERT INTO `lang_definitions` VALUES (3175, 47, 3, 'Un carácter especial');
INSERT INTO `lang_definitions` VALUES (3176, 51, 3, 'Un valor único para identificar este campo, no visible al usuario');
INSERT INTO `lang_definitions` VALUES (3177, 55, 3, 'antes de las comidas');
INSERT INTO `lang_definitions` VALUES (3178, 56, 3, 'a.m.');
INSERT INTO `lang_definitions` VALUES (3179, 58, 3, 'A/F Nivel de Derecho:');
INSERT INTO `lang_definitions` VALUES (3180, 60, 3, 'AB');
INSERT INTO `lang_definitions` VALUES (3181, 61, 3, 'Abreviatura');
INSERT INTO `lang_definitions` VALUES (3182, 62, 3, 'Abceso:');
INSERT INTO `lang_definitions` VALUES (3183, 63, 3, 'Abdominal');
INSERT INTO `lang_definitions` VALUES (3184, 64, 3, 'Capaz de cargar peso cuatro (4) pasos:');
INSERT INTO `lang_definitions` VALUES (3185, 65, 3, 'Anormal');
INSERT INTO `lang_definitions` VALUES (3186, 66, 3, 'ABN1');
INSERT INTO `lang_definitions` VALUES (3187, 68, 3, 'Anormal');
INSERT INTO `lang_definitions` VALUES (3188, 69, 3, 'Análisis de sangre anormal');
INSERT INTO `lang_definitions` VALUES (3189, 70, 3, 'Crecimiento anormal del pelo');
INSERT INTO `lang_definitions` VALUES (3190, 71, 3, 'Mamografía anormal');
INSERT INTO `lang_definitions` VALUES (3191, 73, 3, 'Aborto');
INSERT INTO `lang_definitions` VALUES (3192, 74, 3, 'Problemas del Aborto');
INSERT INTO `lang_definitions` VALUES (3193, 75, 3, 'Método abortivo');
INSERT INTO `lang_definitions` VALUES (3194, 76, 3, 'Categorías relacionadas al Aborto');
INSERT INTO `lang_definitions` VALUES (3195, 77, 3, 'Abortos');
INSERT INTO `lang_definitions` VALUES (3196, 78, 3, 'Acerca de');
INSERT INTO `lang_definitions` VALUES (3197, 80, 3, 'Acerca del calendario');
INSERT INTO `lang_definitions` VALUES (3198, 83, 3, 'Ausencias por Diagnóstico');
INSERT INTO `lang_definitions` VALUES (3199, 85, 3, 'Aceptar la tarea');
INSERT INTO `lang_definitions` VALUES (3200, 87, 3, 'Aceptar pago por');
INSERT INTO `lang_definitions` VALUES (3201, 88, 3, 'Aceptar Pago por');
INSERT INTO `lang_definitions` VALUES (3202, 89, 3, 'Acepta la tarea');
INSERT INTO `lang_definitions` VALUES (3203, 91, 3, 'Control de acceso');
INSERT INTO `lang_definitions` VALUES (3204, 92, 3, 'Administración de la Lista de Control de Acceso');
INSERT INTO `lang_definitions` VALUES (3205, 100, 3, 'Acceso no permitido');
INSERT INTO `lang_definitions` VALUES (3206, 103, 3, 'Acceder al Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (3207, 104, 3, 'Accidente');
INSERT INTO `lang_definitions` VALUES (3208, 110, 3, 'Nombre de la Cuenta');
INSERT INTO `lang_definitions` VALUES (3209, 113, 3, 'Contabilidad');
INSERT INTO `lang_definitions` VALUES (3210, 116, 3, 'Contab.');
INSERT INTO `lang_definitions` VALUES (3211, 118, 3, 'Dolores');
INSERT INTO `lang_definitions` VALUES (3212, 119, 3, 'Reconocer como mi firma electrónica');
INSERT INTO `lang_definitions` VALUES (3213, 120, 3, 'Solicitud de reconocimiento (ISA14)');
INSERT INTO `lang_definitions` VALUES (3214, 121, 3, 'Reconocimientos, Licencias y Certificaciones');
INSERT INTO `lang_definitions` VALUES (3215, 122, 3, 'ACL');
INSERT INTO `lang_definitions` VALUES (3216, 123, 3, 'ACL Administración');
INSERT INTO `lang_definitions` VALUES (3217, 125, 3, 'ACL Administración no autorizada');
INSERT INTO `lang_definitions` VALUES (3218, 127, 3, 'ACL actualizada exitósamente');
INSERT INTO `lang_definitions` VALUES (3219, 128, 3, 'Acné');
INSERT INTO `lang_definitions` VALUES (3220, 131, 3, 'Acta');
INSERT INTO `lang_definitions` VALUES (3221, 132, 3, 'Fecha de Acta');
INSERT INTO `lang_definitions` VALUES (3222, 133, 3, 'Acción');
INSERT INTO `lang_definitions` VALUES (3223, 137, 3, 'Acciones');
INSERT INTO `lang_definitions` VALUES (3224, 138, 3, 'Activar');
INSERT INTO `lang_definitions` VALUES (3225, 139, 3, 'Activar Reportes CCR/CCD');
INSERT INTO `lang_definitions` VALUES (3226, 143, 3, 'Activo');
INSERT INTO `lang_definitions` VALUES (3227, 145, 3, 'Alerta Activa');
INSERT INTO `lang_definitions` VALUES (3228, 147, 3, 'Reglas de Alerta Activa');
INSERT INTO `lang_definitions` VALUES (3229, 148, 3, 'Alertas activas/Recordatorios');
INSERT INTO `lang_definitions` VALUES (3230, 153, 3, 'Visita Activa');
INSERT INTO `lang_definitions` VALUES (3231, 155, 3, 'Listas Activas');
INSERT INTO `lang_definitions` VALUES (3232, 157, 3, 'Paciente Activo');
INSERT INTO `lang_definitions` VALUES (3233, 158, 3, 'Planes Activos');
INSERT INTO `lang_definitions` VALUES (3234, 160, 3, 'Actividad');
INSERT INTO `lang_definitions` VALUES (3235, 161, 3, 'Tipo de Actividad');
INSERT INTO `lang_definitions` VALUES (3236, 174, 3, 'Agudo en Crónico');
INSERT INTO `lang_definitions` VALUES (3237, 176, 3, 'Añadir');
INSERT INTO `lang_definitions` VALUES (3238, 177, 3, 'añadir');
INSERT INTO `lang_definitions` VALUES (3239, 178, 3, 'AÑADIR');
INSERT INTO `lang_definitions` VALUES (3240, 179, 3, 'Añadir una Sociedad');
INSERT INTO `lang_definitions` VALUES (3241, 184, 3, 'Añadir una Farmacia');
INSERT INTO `lang_definitions` VALUES (3242, 187, 3, 'Añadir un evento para');
INSERT INTO `lang_definitions` VALUES (3243, 189, 3, 'Añadir como nueva nota');
INSERT INTO `lang_definitions` VALUES (3244, 190, 3, 'Añadir como Nuevo');
INSERT INTO `lang_definitions` VALUES (3245, 193, 3, 'Agregar Botones');
INSERT INTO `lang_definitions` VALUES (3246, 194, 3, 'Agregar botones para caracteres especiales, Textos serán mostrados sobre el editor para incluir en el texto con un Click.');
INSERT INTO `lang_definitions` VALUES (3247, 195, 3, 'Añadir Categoría');
INSERT INTO `lang_definitions` VALUES (3248, 196, 3, 'Añadir Constante');
INSERT INTO `lang_definitions` VALUES (3249, 197, 3, 'Añadir Contexto');
INSERT INTO `lang_definitions` VALUES (3250, 198, 3, 'Añadir Co-pago');
INSERT INTO `lang_definitions` VALUES (3251, 199, 3, 'Añadir Criterios');
INSERT INTO `lang_definitions` VALUES (3252, 200, 3, 'Añadir Botón Personalizado');
INSERT INTO `lang_definitions` VALUES (3253, 203, 3, 'Añadir Diagnóstico');
INSERT INTO `lang_definitions` VALUES (3254, 204, 3, 'Añadir Medicamento');
INSERT INTO `lang_definitions` VALUES (3255, 207, 3, 'Añadir Visita');
INSERT INTO `lang_definitions` VALUES (3256, 208, 3, 'Añadir Visita/notas');
INSERT INTO `lang_definitions` VALUES (3257, 209, 3, 'Añadir Centro');
INSERT INTO `lang_definitions` VALUES (3258, 210, 3, 'Añadir Campo');
INSERT INTO `lang_definitions` VALUES (3259, 211, 3, 'Añadir las siguientes líneas al fichero de configuración de Apache');
INSERT INTO `lang_definitions` VALUES (3260, 212, 3, 'Añadir Grupo');
INSERT INTO `lang_definitions` VALUES (3261, 214, 3, 'Añadir Código CIE');
INSERT INTO `lang_definitions` VALUES (3262, 215, 3, 'Agregar Vacunación');
INSERT INTO `lang_definitions` VALUES (3263, 216, 3, 'Añadir no permitido!');
INSERT INTO `lang_definitions` VALUES (3264, 217, 3, 'Añadir Incidencia');
INSERT INTO `lang_definitions` VALUES (3265, 219, 3, 'Añadir Idioma');
INSERT INTO `lang_definitions` VALUES (3266, 224, 3, 'Añadir Nuevo');
INSERT INTO `lang_definitions` VALUES (3267, 225, 3, 'Añadir nuevo');
INSERT INTO `lang_definitions` VALUES (3268, 226, 3, 'Añadir nueva categoría:');
INSERT INTO `lang_definitions` VALUES (3269, 227, 3, 'Añadir nuevos Certificados al fichero de configuración de Apache');
INSERT INTO `lang_definitions` VALUES (3270, 234, 3, 'Añadir Nuevo Grupo');
INSERT INTO `lang_definitions` VALUES (3271, 236, 3, 'Añadir nuevo lote y transacción');
INSERT INTO `lang_definitions` VALUES (3272, 238, 3, 'Añadir Nueva Nota');
INSERT INTO `lang_definitions` VALUES (3273, 239, 3, 'Añadir nueva nota');
INSERT INTO `lang_definitions` VALUES (3274, 240, 3, 'Añadir Nuevo Socio');
INSERT INTO `lang_definitions` VALUES (3275, 244, 3, 'Añadir Nota');
INSERT INTO `lang_definitions` VALUES (3276, 248, 3, 'Añadir Registro de Paciente');
INSERT INTO `lang_definitions` VALUES (3277, 249, 3, 'Añadir Receta');
INSERT INTO `lang_definitions` VALUES (3278, 251, 3, 'Añadir numero del proveedor');
INSERT INTO `lang_definitions` VALUES (3279, 253, 3, 'Añadir Rehabilitación');
INSERT INTO `lang_definitions` VALUES (3280, 254, 3, 'Añadir Regla');
INSERT INTO `lang_definitions` VALUES (3281, 257, 3, 'Añadir a');
INSERT INTO `lang_definitions` VALUES (3282, 261, 3, 'Añadir a Lista de Medicación');
INSERT INTO `lang_definitions` VALUES (3283, 262, 3, 'Añadir Nivel Superior');
INSERT INTO `lang_definitions` VALUES (3284, 263, 3, 'Añadir Transacción');
INSERT INTO `lang_definitions` VALUES (3285, 264, 3, 'Añadir Usuario');
INSERT INTO `lang_definitions` VALUES (3286, 265, 3, 'Añadir Usuario al Grupo');
INSERT INTO `lang_definitions` VALUES (3287, 267, 3, 'Añadir/Editar Receta electrónica');
INSERT INTO `lang_definitions` VALUES (3288, 269, 3, 'Añadir/Editar Transacción de paciente');
INSERT INTO `lang_definitions` VALUES (3289, 270, 3, 'añadido');
INSERT INTO `lang_definitions` VALUES (3290, 273, 3, 'Añadir datos demográficos no autorizado.');
INSERT INTO `lang_definitions` VALUES (3291, 275, 3, 'Síndrome de Addison');
INSERT INTO `lang_definitions` VALUES (3292, 276, 3, 'Síndrome de Addison');
INSERT INTO `lang_definitions` VALUES (3293, 277, 3, 'Atributos adicionales');
INSERT INTO `lang_definitions` VALUES (3294, 280, 3, 'Diagnóstico adicional:');
INSERT INTO `lang_definitions` VALUES (3295, 284, 3, 'Historia Adicional');
INSERT INTO `lang_definitions` VALUES (3296, 285, 3, 'Notas adicionales a la historia');
INSERT INTO `lang_definitions` VALUES (3297, 286, 3, 'Información adicional');
INSERT INTO `lang_definitions` VALUES (3298, 289, 3, 'Laboratorios adicionales');
INSERT INTO `lang_definitions` VALUES (3299, 290, 3, 'Notas adicionales');
INSERT INTO `lang_definitions` VALUES (3300, 293, 3, 'Notas adicionales:');
INSERT INTO `lang_definitions` VALUES (3301, 294, 3, 'Notas adicionales:');
INSERT INTO `lang_definitions` VALUES (3302, 295, 3, 'Notas de Rayos X adicionales:');
INSERT INTO `lang_definitions` VALUES (3303, 298, 3, 'Sólo añadir');
INSERT INTO `lang_definitions` VALUES (3304, 300, 3, 'Libreta Direcciones');
INSERT INTO `lang_definitions` VALUES (3305, 301, 3, 'Libreta Direcciones');
INSERT INTO `lang_definitions` VALUES (3306, 302, 3, 'Dirección');
INSERT INTO `lang_definitions` VALUES (3307, 303, 3, 'Dirección y Código Postal');
INSERT INTO `lang_definitions` VALUES (3308, 304, 3, 'Dirección y Provincia/Departamento');
INSERT INTO `lang_definitions` VALUES (3309, 305, 3, 'Libreta de Direcciones');
INSERT INTO `lang_definitions` VALUES (3310, 306, 3, 'Entrada a la libreta de Direcciones de la empresa que realiza este procedimiento');
INSERT INTO `lang_definitions` VALUES (3311, 307, 3, 'Entrada a la libreta de Direcciones para el distribuidor');
INSERT INTO `lang_definitions` VALUES (3312, 308, 3, 'Entrada a la Libreta de Direcciones para el vendedor');
INSERT INTO `lang_definitions` VALUES (3313, 309, 3, 'Tipos de Libreta de Direcciones');
INSERT INTO `lang_definitions` VALUES (3314, 310, 3, 'Etiqueta de Dirección');
INSERT INTO `lang_definitions` VALUES (3315, 311, 3, 'Etiquetas de Dirección');
INSERT INTO `lang_definitions` VALUES (3316, 312, 3, 'Dirección Sola');
INSERT INTO `lang_definitions` VALUES (3317, 314, 3, 'Dirección, Provincia/Estado/Departamento y Código Postal');
INSERT INTO `lang_definitions` VALUES (3318, 315, 3, 'Dirección1');
INSERT INTO `lang_definitions` VALUES (3319, 316, 3, 'Dirección2');
INSERT INTO `lang_definitions` VALUES (3320, 318, 3, 'DESTINATARIO');
INSERT INTO `lang_definitions` VALUES (3321, 321, 3, 'Ajuste');
INSERT INTO `lang_definitions` VALUES (3322, 322, 3, 'Importe de Ajuste');
INSERT INTO `lang_definitions` VALUES (3323, 323, 3, 'Ajustar');
INSERT INTO `lang_definitions` VALUES (3324, 324, 3, 'Ajuste');
INSERT INTO `lang_definitions` VALUES (3325, 325, 3, 'Ajuste importe');
INSERT INTO `lang_definitions` VALUES (3326, 326, 3, 'Motivos del ajuste');
INSERT INTO `lang_definitions` VALUES (3327, 327, 3, 'Valor de ajuste para código');
INSERT INTO `lang_definitions` VALUES (3328, 328, 3, 'Ajustes');
INSERT INTO `lang_definitions` VALUES (3329, 329, 3, 'Ajuste administrador');
INSERT INTO `lang_definitions` VALUES (3330, 330, 3, 'Administrador');
INSERT INTO `lang_definitions` VALUES (3331, 331, 3, 'email administrador');
INSERT INTO `lang_definitions` VALUES (3332, 332, 3, 'Administrar a través de');
INSERT INTO `lang_definitions` VALUES (3333, 334, 3, 'Administrado');
INSERT INTO `lang_definitions` VALUES (3334, 335, 3, 'Administrado por');
INSERT INTO `lang_definitions` VALUES (3335, 336, 3, 'Fecha Administrado');
INSERT INTO `lang_definitions` VALUES (3336, 337, 3, 'Sitio Administrado');
INSERT INTO `lang_definitions` VALUES (3337, 338, 3, 'Administración');
INSERT INTO `lang_definitions` VALUES (3338, 340, 3, 'Sitio de administración');
INSERT INTO `lang_definitions` VALUES (3339, 341, 3, 'Administradores');
INSERT INTO `lang_definitions` VALUES (3340, 342, 3, 'Los administradores pueden hacer todo');
INSERT INTO `lang_definitions` VALUES (3341, 346, 3, 'Revisión Peso de Adulto y Seguimiento');
INSERT INTO `lang_definitions` VALUES (3342, 347, 3, 'Revisión Peso de Adulto y Seguimiento (GCC)');
INSERT INTO `lang_definitions` VALUES (3343, 348, 3, 'Instrucción anticipada');
INSERT INTO `lang_definitions` VALUES (3344, 349, 3, 'Directriz Anticipada');
INSERT INTO `lang_definitions` VALUES (3345, 350, 3, 'Aviso Directriz Anticipada');
INSERT INTO `lang_definitions` VALUES (3346, 352, 3, 'Anticipado');
INSERT INTO `lang_definitions` VALUES (3347, 355, 3, 'Consejo');
INSERT INTO `lang_definitions` VALUES (3348, 357, 3, 'Afecta normales');
INSERT INTO `lang_definitions` VALUES (3349, 361, 3, 'llamadas fuera horario laboral');
INSERT INTO `lang_definitions` VALUES (3350, 363, 3, 'Después de hacer las configuraciones mencionadas, importar el certificado del cliente de administrador al navegador y reiniciar el servidor Apache (Contraseña vacía)');
INSERT INTO `lang_definitions` VALUES (3351, 364, 3, 'Después de guardar el PDF, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3352, 366, 3, 'Después de guardar los ficheros de TEXTO, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3353, 368, 3, 'Después de guardar su Batch, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3354, 371, 3, 'Una vez completada la informacion correctamente, click en botón Guardar');
INSERT INTO `lang_definitions` VALUES (3355, 372, 3, 'Después de subir, haga click en el botón \"Importar\"');
INSERT INTO `lang_definitions` VALUES (3356, 376, 3, 'Planificación posterior al cuidado');
INSERT INTO `lang_definitions` VALUES (3357, 377, 3, 'Otra vez');
INSERT INTO `lang_definitions` VALUES (3358, 378, 3, 'Edad');
INSERT INTO `lang_definitions` VALUES (3359, 380, 3, 'Por Edad');
INSERT INTO `lang_definitions` VALUES (3360, 381, 3, 'Categoría edad');
INSERT INTO `lang_definitions` VALUES (3361, 382, 3, 'Dato edad fuera de rango.');
INSERT INTO `lang_definitions` VALUES (3362, 383, 3, 'Formato para mostrar edad');
INSERT INTO `lang_definitions` VALUES (3363, 384, 3, 'Formato edad en \'desde edad\' no es válido');
INSERT INTO `lang_definitions` VALUES (3364, 385, 3, 'Formato edad en \'hasta edad\' no es válido');
INSERT INTO `lang_definitions` VALUES (3365, 386, 3, 'Edad desde');
INSERT INTO `lang_definitions` VALUES (3366, 387, 3, 'Edad en años para cambio de formato');
INSERT INTO `lang_definitions` VALUES (3367, 388, 3, 'Edad Máxima');
INSERT INTO `lang_definitions` VALUES (3368, 389, 3, 'Edad Mínima');
INSERT INTO `lang_definitions` VALUES (3369, 390, 3, 'Rango de Edad');
INSERT INTO `lang_definitions` VALUES (3370, 392, 3, 'Columnas del envejecimiento:');
INSERT INTO `lang_definitions` VALUES (3371, 394, 3, 'Albanés');
INSERT INTO `lang_definitions` VALUES (3372, 395, 3, 'Alcohol');
INSERT INTO `lang_definitions` VALUES (3373, 396, 3, 'Consumo de alcohol');
INSERT INTO `lang_definitions` VALUES (3374, 399, 3, 'Contador de Alerta');
INSERT INTO `lang_definitions` VALUES (3375, 405, 3, 'Alertas');
INSERT INTO `lang_definitions` VALUES (3376, 409, 3, 'ALEUTIANO');
INSERT INTO `lang_definitions` VALUES (3377, 410, 3, 'Todos');
INSERT INTO `lang_definitions` VALUES (3378, 411, 3, 'TODOS');
INSERT INTO `lang_definitions` VALUES (3379, 413, 3, 'Todos (Formatos Compaginados A)');
INSERT INTO `lang_definitions` VALUES (3380, 414, 3, 'Todos (Formatos Compaginados B)');
INSERT INTO `lang_definitions` VALUES (3381, 415, 3, 'Todos (Acumulativo)');
INSERT INTO `lang_definitions` VALUES (3382, 418, 3, 'Todas las Categorías');
INSERT INTO `lang_definitions` VALUES (3383, 420, 3, 'Todos los Códigos');
INSERT INTO `lang_definitions` VALUES (3384, 422, 3, 'Todo el día');
INSERT INTO `lang_definitions` VALUES (3385, 423, 3, 'Evento de día completo');
INSERT INTO `lang_definitions` VALUES (3386, 424, 3, 'Todos los campos demográficos, con búsqueda y chequeo de dupicados');
INSERT INTO `lang_definitions` VALUES (3387, 426, 3, 'Todas las Clínicas');
INSERT INTO `lang_definitions` VALUES (3388, 427, 3, 'Todas las Lesiones/Problemas/Incidencias');
INSERT INTO `lang_definitions` VALUES (3389, 428, 3, 'Permitidos todos los Idiomas');
INSERT INTO `lang_definitions` VALUES (3390, 431, 3, 'Todo o parte del nombre');
INSERT INTO `lang_definitions` VALUES (3391, 432, 3, 'Todo o parte del apellido');
INSERT INTO `lang_definitions` VALUES (3392, 433, 3, 'Todo o parte de la organización');
INSERT INTO `lang_definitions` VALUES (3393, 437, 3, 'Todos los productos');
INSERT INTO `lang_definitions` VALUES (3394, 438, 3, 'Todos los proveedores');
INSERT INTO `lang_definitions` VALUES (3395, 439, 3, 'Todos Revisados y Negativos:');
INSERT INTO `lang_definitions` VALUES (3396, 442, 3, 'Todos los Temas');
INSERT INTO `lang_definitions` VALUES (3397, 445, 3, 'Todos los Usuarios');
INSERT INTO `lang_definitions` VALUES (3398, 446, 3, 'Alérgico');
INSERT INTO `lang_definitions` VALUES (3399, 448, 3, 'Alergias');
INSERT INTO `lang_definitions` VALUES (3400, 451, 3, 'Alergias:');
INSERT INTO `lang_definitions` VALUES (3401, 452, 3, 'Alergia');
INSERT INTO `lang_definitions` VALUES (3402, 453, 3, 'Importación de Alergia completado con éxito');
INSERT INTO `lang_definitions` VALUES (3403, 455, 3, 'Reacción Alérgica');
INSERT INTO `lang_definitions` VALUES (3404, 458, 3, 'Asignar');
INSERT INTO `lang_definitions` VALUES (3405, 459, 3, 'Permitir');
INSERT INTO `lang_definitions` VALUES (3406, 461, 3, 'Permitir todos los idiomas disponibles como opción en el menú de inicio sesión.');
INSERT INTO `lang_definitions` VALUES (3407, 463, 3, 'Permitir creación de reclamaciones con diagnósticos pero no procedimientos o cargos. La mayoría de clínicas no desean esto.');
INSERT INTO `lang_definitions` VALUES (3408, 464, 3, 'Permitir Depuración de Idioma');
INSERT INTO `lang_definitions` VALUES (3409, 466, 3, 'Permitir Email');
INSERT INTO `lang_definitions` VALUES (3410, 467, 3, '¿Permitir mensajes email?');
INSERT INTO `lang_definitions` VALUES (3411, 468, 3, '¿Permitir Email?');
INSERT INTO `lang_definitions` VALUES (3412, 469, 3, 'Permitir reclamación de Visita');
INSERT INTO `lang_definitions` VALUES (3413, 472, 3, 'Permitir el Intercambio de Información de Salud');
INSERT INTO `lang_definitions` VALUES (3414, 474, 3, 'Permitir Compartir Información de Vacunación');
INSERT INTO `lang_definitions` VALUES (3415, 475, 3, 'Permitir el Uso del Registro de Vacunaciones');
INSERT INTO `lang_definitions` VALUES (3416, 478, 3, 'Permitir mensajes email');
INSERT INTO `lang_definitions` VALUES (3417, 492, 3, 'Permitir Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (3418, 494, 3, 'Permitir SMS');
INSERT INTO `lang_definitions` VALUES (3419, 495, 3, '¿Permitir SMS (mensajes de texto)?');
INSERT INTO `lang_definitions` VALUES (3420, 497, 3, '¿Permitir la activación instantánea de los eventos introducidos?');
INSERT INTO `lang_definitions` VALUES (3421, 498, 3, '¿Permitir mensajes telefónicos?');
INSERT INTO `lang_definitions` VALUES (3422, 500, 3, 'Permitir a los usuarios publicar eventos globales');
INSERT INTO `lang_definitions` VALUES (3423, 501, 3, 'Permitir a los usuarios publicar calendarios personales');
INSERT INTO `lang_definitions` VALUES (3424, 507, 3, 'Permitir Mensaje de Voz');
INSERT INTO `lang_definitions` VALUES (3425, 508, 3, 'Permitido');
INSERT INTO `lang_definitions` VALUES (3426, 509, 3, 'Idiomas Permitidos');
INSERT INTO `lang_definitions` VALUES (3427, 511, 3, 'Asignado ©');
INSERT INTO `lang_definitions` VALUES (3428, 512, 3, 'Permite E-sign en todo el encuentro');
INSERT INTO `lang_definitions` VALUES (3429, 513, 3, 'Permite E-sign para formas individuales');
INSERT INTO `lang_definitions` VALUES (3430, 514, 3, 'Permitir Correo Electrónico');
INSERT INTO `lang_definitions` VALUES (3431, 515, 3, 'Permitir Mensajes de voz');
INSERT INTO `lang_definitions` VALUES (3432, 517, 3, 'ya existe');
INSERT INTO `lang_definitions` VALUES (3433, 518, 3, 'ya existe.');
INSERT INTO `lang_definitions` VALUES (3434, 520, 3, 'Identificador ya usado, elija otro');
INSERT INTO `lang_definitions` VALUES (3435, 521, 3, 'Título ya usado, elija otro');
INSERT INTO `lang_definitions` VALUES (3436, 523, 3, 'Dirección alternativa');
INSERT INTO `lang_definitions` VALUES (3437, 524, 3, 'modificar');
INSERT INTO `lang_definitions` VALUES (3438, 531, 3, 'De forma alternativa, puede usar la página de búsqueda para cargar un fichero electrónico (X12835) que haya recibido de su pagador. Puede hacerlo presionando el botón Explorar y seleccionar el fichero a cargar, y luego pulsando Explorar para ejecutar la carga y mostrar las facturas correspondientes. En este caso, los otros parámetros mencionados arriba no se aplican y pueden ser ignorados. La carga guarda el fichero pero no procesa su contenido - esto se realiza de forma separada como se describe abajo.');
INSERT INTO `lang_definitions` VALUES (3439, 533, 3, 'AM');
INSERT INTO `lang_definitions` VALUES (3440, 534, 3, 'Programa AM');
INSERT INTO `lang_definitions` VALUES (3441, 539, 3, 'Cálculo Automático de Medidas (CAM)');
INSERT INTO `lang_definitions` VALUES (3442, 540, 3, 'Rastreo CAM');
INSERT INTO `lang_definitions` VALUES (3443, 547, 3, 'Corregir nota existente');
INSERT INTO `lang_definitions` VALUES (3444, 556, 3, 'Indígena americano');
INSERT INTO `lang_definitions` VALUES (3445, 557, 3, 'Indígena americano o Nativo de Alaska');
INSERT INTO `lang_definitions` VALUES (3446, 558, 3, 'AMEX');
INSERT INTO `lang_definitions` VALUES (3447, 559, 3, 'Amárico (Lengua de Etiopia)');
INSERT INTO `lang_definitions` VALUES (3448, 560, 3, 'Importe');
INSERT INTO `lang_definitions` VALUES (3449, 563, 3, 'Importes Cargados');
INSERT INTO `lang_definitions` VALUES (3450, 566, 3, 'Importe Saldo Vencido');
INSERT INTO `lang_definitions` VALUES (3451, 567, 3, 'Importe por esta visita');
INSERT INTO `lang_definitions` VALUES (3452, 568, 3, 'Importe pagado');
INSERT INTO `lang_definitions` VALUES (3453, 569, 3, 'Importe:');
INSERT INTO `lang_definitions` VALUES (3454, 572, 3, 'Importe Facturado');
INSERT INTO `lang_definitions` VALUES (3455, 576, 3, '¡Se requiere una fecha de finalización posterior a la fecha de inicio para los eventos repetidos!');
INSERT INTO `lang_definitions` VALUES (3456, 578, 3, 'Ocurrió un error durante la descarga web de los directorios de OpenEMR');
INSERT INTO `lang_definitions` VALUES (3457, 579, 3, 'Ocurrió un error durante la descarga web de los directorios de phpGACL');
INSERT INTO `lang_definitions` VALUES (3458, 580, 3, 'Ocurrió un error durante la descarga web de los directorios SQL-Ledger');
INSERT INTO `lang_definitions` VALUES (3459, 584, 3, 'Una incidencia GCAC incompleta ha sido creada y vinculada. Alguien tendrá que completarla más tarde.');
INSERT INTO `lang_definitions` VALUES (3460, 590, 3, 'Ocurrio un error inesperado.');
INSERT INTO `lang_definitions` VALUES (3461, 592, 3, 'Una letra mayúscula');
INSERT INTO `lang_definitions` VALUES (3462, 594, 3, 'y');
INSERT INTO `lang_definitions` VALUES (3463, 595, 3, 'Y');
INSERT INTO `lang_definitions` VALUES (3464, 596, 3, 'Y');
INSERT INTO `lang_definitions` VALUES (3465, 597, 3, 'y');
INSERT INTO `lang_definitions` VALUES (3466, 598, 3, '¿y toda la información subordinada? Esta acción será registrada');
INSERT INTO `lang_definitions` VALUES (3467, 599, 3, 'y modificador');
INSERT INTO `lang_definitions` VALUES (3468, 600, 3, 'y procesado.');
INSERT INTO `lang_definitions` VALUES (3469, 601, 3, 'y reiniciar servidor Apache');
INSERT INTO `lang_definitions` VALUES (3470, 602, 3, 'y la Razón es');
INSERT INTO `lang_definitions` VALUES (3471, 604, 3, 'Anemia');
INSERT INTO `lang_definitions` VALUES (3472, 605, 3, 'Tobillo');
INSERT INTO `lang_definitions` VALUES (3473, 606, 3, 'Tobillo + talón');
INSERT INTO `lang_definitions` VALUES (3474, 607, 3, 'Formulario de Evaluación del tobillo');
INSERT INTO `lang_definitions` VALUES (3475, 608, 3, 'Problemas de tobillo');
INSERT INTO `lang_definitions` VALUES (3476, 609, 3, 'Espondilitis anquilosante');
INSERT INTO `lang_definitions` VALUES (3477, 610, 3, 'Espondilitis anquilosante');
INSERT INTO `lang_definitions` VALUES (3478, 611, 3, 'Anorexia');
INSERT INTO `lang_definitions` VALUES (3479, 612, 3, 'Otra cosa que puede hacer en la ventana de publicación es solicitar facturación secundaria. Si selecciona la casilla de verificación antes de guardar, la reclamación original será reabierta y puesta en cola en la página de Facturación, y será procesada en el siguiente proceso de facturación.');
INSERT INTO `lang_definitions` VALUES (3480, 615, 3, 'ante');
INSERT INTO `lang_definitions` VALUES (3481, 617, 3, 'Segmento Anterior');
INSERT INTO `lang_definitions` VALUES (3482, 618, 3, 'Valores por Defecto para el Segmento Anterior');
INSERT INTO `lang_definitions` VALUES (3483, 620, 3, 'Ano normal, recto sin distensión ni masa');
INSERT INTO `lang_definitions` VALUES (3484, 621, 3, 'Ansiedad');
INSERT INTO `lang_definitions` VALUES (3485, 622, 3, 'Cualquiera');
INSERT INTO `lang_definitions` VALUES (3486, 626, 3, 'Cualquier Categoría');
INSERT INTO `lang_definitions` VALUES (3487, 631, 3, 'Cualquier parte del código deseado o su descripción');
INSERT INTO `lang_definitions` VALUES (3488, 632, 3, 'Cualquier parte de la especialidad deseada');
INSERT INTO `lang_definitions` VALUES (3489, 633, 3, 'Cualquier parte del identificador o nombre de medicamento');
INSERT INTO `lang_definitions` VALUES (3490, 634, 3, 'Cualquier parte del identificador o nombre de vacuna');
INSERT INTO `lang_definitions` VALUES (3491, 635, 3, 'Cualquier parte del nombre del paciente, o Apellido, Nombre, o X-Y');
INSERT INTO `lang_definitions` VALUES (3492, 637, 3, '¿Algo más ocurre al mismo tiempo?');
INSERT INTO `lang_definitions` VALUES (3493, 640, 3, 'Clave API para puerta enlace SMS');
INSERT INTO `lang_definitions` VALUES (3494, 641, 3, 'Apnea');
INSERT INTO `lang_definitions` VALUES (3495, 643, 3, 'Aspecto');
INSERT INTO `lang_definitions` VALUES (3496, 644, 3, 'Aspecto:');
INSERT INTO `lang_definitions` VALUES (3497, 647, 3, 'Añadir esta nota');
INSERT INTO `lang_definitions` VALUES (3498, 649, 3, 'Añadir a la nota existente');
INSERT INTO `lang_definitions` VALUES (3499, 650, 3, 'Añadir a sta nota');
INSERT INTO `lang_definitions` VALUES (3500, 651, 3, 'Añadir a Esta Nota');
INSERT INTO `lang_definitions` VALUES (3501, 652, 3, 'Apendicectomía');
INSERT INTO `lang_definitions` VALUES (3502, 654, 3, 'Pacientes Aplicables');
INSERT INTO `lang_definitions` VALUES (3503, 656, 3, 'Nombre de aplicación para página de inicio de sesión y título de ventana principal');
INSERT INTO `lang_definitions` VALUES (3504, 657, 3, 'Código de Aplicación del receptor (GS03 - si está en blanco se usará ISA08)');
INSERT INTO `lang_definitions` VALUES (3505, 658, 3, 'Codigo de Aplicacion del Enviador (GS02)');
INSERT INTO `lang_definitions` VALUES (3506, 659, 3, 'Título de Aplicación');
INSERT INTO `lang_definitions` VALUES (3507, 660, 3, 'Se aplica al formulario de Constantes Vitales y Gráfica de Crecimiento');
INSERT INTO `lang_definitions` VALUES (3508, 662, 3, '¿Aplicar los cambios sólo al evento actual, a éste y todos los episodios futuros, o a todos los episodios?');
INSERT INTO `lang_definitions` VALUES (3509, 663, 3, 'aplicar a la zona afectada');
INSERT INTO `lang_definitions` VALUES (3510, 664, 3, 'aplicar a la piel');
INSERT INTO `lang_definitions` VALUES (3511, 665, 3, 'Aplicando');
INSERT INTO `lang_definitions` VALUES (3512, 666, 3, 'Aplicando parche al sitio');
INSERT INTO `lang_definitions` VALUES (3513, 667, 3, 'Cita');
INSERT INTO `lang_definitions` VALUES (3514, 669, 3, 'Fecha de Cita');
INSERT INTO `lang_definitions` VALUES (3515, 675, 3, 'Estilo de visualizacion de la cita');
INSERT INTO `lang_definitions` VALUES (3516, 677, 3, 'Regla para recordar Cita');
INSERT INTO `lang_definitions` VALUES (3517, 679, 3, 'Estado de la Cita');
INSERT INTO `lang_definitions` VALUES (3518, 680, 3, 'Estados de la cita');
INSERT INTO `lang_definitions` VALUES (3519, 681, 3, 'Cita dentro de');
INSERT INTO `lang_definitions` VALUES (3520, 682, 3, 'Color de Cita/Evento');
INSERT INTO `lang_definitions` VALUES (3521, 683, 3, 'Citas');
INSERT INTO `lang_definitions` VALUES (3522, 684, 3, 'Citas (escriba opcional)');
INSERT INTO `lang_definitions` VALUES (3523, 685, 3, 'Citas (escribir, algunos opcional)');
INSERT INTO `lang_definitions` VALUES (3524, 691, 3, 'Citas y Visitas');
INSERT INTO `lang_definitions` VALUES (3525, 692, 3, 'Encuentros para');
INSERT INTO `lang_definitions` VALUES (3526, 693, 3, 'Informe de citas');
INSERT INTO `lang_definitions` VALUES (3527, 694, 3, 'Informes Citas-Visitas');
INSERT INTO `lang_definitions` VALUES (3528, 697, 3, 'Aprobar');
INSERT INTO `lang_definitions` VALUES (3529, 700, 3, 'Aprobado');
INSERT INTO `lang_definitions` VALUES (3530, 701, 3, 'Eventos Administrativos Aprobados');
INSERT INTO `lang_definitions` VALUES (3531, 707, 3, 'Citas-Visitas');
INSERT INTO `lang_definitions` VALUES (3532, 709, 3, 'Citas');
INSERT INTO `lang_definitions` VALUES (3533, 712, 3, 'Abr');
INSERT INTO `lang_definitions` VALUES (3534, 713, 3, 'Abril');
INSERT INTO `lang_definitions` VALUES (3535, 715, 3, 'Arábigo');
INSERT INTO `lang_definitions` VALUES (3536, 716, 3, 'Aragonés');
INSERT INTO `lang_definitions` VALUES (3537, 717, 3, 'Archivo');
INSERT INTO `lang_definitions` VALUES (3538, 718, 3, 'Archivar los Registros Cronológicos');
INSERT INTO `lang_definitions` VALUES (3539, 719, 3, 'Archivas Registros (Logs) Viejos');
INSERT INTO `lang_definitions` VALUES (3540, 720, 3, '¿Se traducen los nombres del grupo de control de acceso?');
INSERT INTO `lang_definitions` VALUES (3541, 721, 3, '¿Se traducen los nombres de las categorías de cita?');
INSERT INTO `lang_definitions` VALUES (3542, 722, 3, '¿Se traducen los nombres de categorías de documento?');
INSERT INTO `lang_definitions` VALUES (3543, 723, 3, '¿Se cobran honorarios por este tipo?');
INSERT INTO `lang_definitions` VALUES (3544, 724, 3, 'están apagados');
INSERT INTO `lang_definitions` VALUES (3545, 725, 3, 'están encendidos');
INSERT INTO `lang_definitions` VALUES (3546, 726, 3, '¿Se traducen los títulos de las notas del paciente?');
INSERT INTO `lang_definitions` VALUES (3547, 727, 3, '¿Están los códigos archivados en tablas sql externas (0-No, 1-CIE10, 2-SNOMED(RF1), 3-SNOMED(rf2))?');
INSERT INTO `lang_definitions` VALUES (3548, 728, 3, '¿Está preparado para completar una nueva incidencia de GCAC (Global Connection Admission Control) para esta visita?');
INSERT INTO `lang_definitions` VALUES (3549, 730, 3, '¿Está seguro de enviar hoy?');
INSERT INTO `lang_definitions` VALUES (3550, 731, 3, '¿Está seguro que quiere aprobar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3551, 732, 3, '¿Está seguro de querer cancelar los cambios?');
INSERT INTO `lang_definitions` VALUES (3552, 733, 3, '¿Está seguro de que desea eliminar por completo este formulario?');
INSERT INTO `lang_definitions` VALUES (3553, 735, 3, '¿Está seguro que desea eliminar este aviso?');
INSERT INTO `lang_definitions` VALUES (3554, 736, 3, '¿Está seguro que quiere eliminar este evento?');
INSERT INTO `lang_definitions` VALUES (3555, 737, 3, '¿Está seguro que quiere eliminar este asunto de la base de datos?');
INSERT INTO `lang_definitions` VALUES (3556, 739, 3, '¿Está usted seguro que quiere eliminar esta nota?');
INSERT INTO `lang_definitions` VALUES (3557, 741, 3, '¿Está seguro que quiere editar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3558, 742, 3, '¿Está seguro que quiere ocultar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3559, 745, 3, '¿Está seguro que quiere visualizar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3560, 746, 3, 'Está seguro que desea eliminar el grupo entero nombrado');
INSERT INTO `lang_definitions` VALUES (3561, 747, 3, 'Está seguro que desea eliminar la lista entera');
INSERT INTO `lang_definitions` VALUES (3562, 748, 3, 'Está seguro que quiere eliminar el campo interno');
INSERT INTO `lang_definitions` VALUES (3563, 749, 3, '¿Está seguro que quiere eliminar los campos seleccionados?');
INSERT INTO `lang_definitions` VALUES (3564, 750, 3, '¿Está seguro que quiere continuar con estas acciones?');
INSERT INTO `lang_definitions` VALUES (3565, 751, 3, 'Zona no especificada');
INSERT INTO `lang_definitions` VALUES (3566, 752, 3, 'Brazo');
INSERT INTO `lang_definitions` VALUES (3567, 753, 3, 'Armenio');
INSERT INTO `lang_definitions` VALUES (3568, 760, 3, 'Arritmia');
INSERT INTO `lang_definitions` VALUES (3569, 761, 3, 'Artritis');
INSERT INTO `lang_definitions` VALUES (3570, 762, 3, 'Artritis/Enfermedad degenerativa de articulaciones');
INSERT INTO `lang_definitions` VALUES (3571, 763, 3, 'Artritis/Enfermedad degenerativa de articulaciones');
INSERT INTO `lang_definitions` VALUES (3572, 767, 3, 'como');
INSERT INTO `lang_definitions` VALUES (3573, 769, 3, 'Desde');
INSERT INTO `lang_definitions` VALUES (3574, 776, 3, 'Asiático');
INSERT INTO `lang_definitions` VALUES (3575, 779, 3, 'Evaluación');
INSERT INTO `lang_definitions` VALUES (3576, 784, 3, 'Asignado a');
INSERT INTO `lang_definitions` VALUES (3577, 785, 3, 'Ayudante');
INSERT INTO `lang_definitions` VALUES (3578, 792, 3, 'Asma');
INSERT INTO `lang_definitions` VALUES (3579, 793, 3, 'en');
INSERT INTO `lang_definitions` VALUES (3580, 794, 3, 'Se requiere al menos un parámetro de búsqueda si selecciona Todos.');
INSERT INTO `lang_definitions` VALUES (3581, 797, 3, 'En el Escafoides');
INSERT INTO `lang_definitions` VALUES (3582, 798, 3, 'En el Escafoides:');
INSERT INTO `lang_definitions` VALUES (3583, 799, 3, 'Equipo de atletismo');
INSERT INTO `lang_definitions` VALUES (3584, 801, 3, 'Lesión Deportiva');
INSERT INTO `lang_definitions` VALUES (3585, 802, 3, 'Certificado CA de ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3586, 803, 3, 'Host de auditoría ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3587, 804, 3, 'Certificado local de ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3588, 805, 3, 'Puerto de auditoría ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3589, 808, 3, 'Atención');
INSERT INTO `lang_definitions` VALUES (3590, 810, 3, 'Atención');
INSERT INTO `lang_definitions` VALUES (3591, 820, 3, 'Auditoría Backups de inicio de sesión');
INSERT INTO `lang_definitions` VALUES (3592, 821, 3, 'Auditoría de inicio de sesión varios');
INSERT INTO `lang_definitions` VALUES (3593, 822, 3, 'Auditoría Orden de inicio de sesión');
INSERT INTO `lang_definitions` VALUES (3594, 823, 3, 'Auditoría registro inicio de sesión del paciente');
INSERT INTO `lang_definitions` VALUES (3595, 824, 3, 'Auditoría Planificación inicio sesión');
INSERT INTO `lang_definitions` VALUES (3596, 825, 3, 'Auditoría Administración de Seguridad inicio sesión');
INSERT INTO `lang_definitions` VALUES (3597, 826, 3, 'Auditoría Consulta SELECT inicio sesión');
INSERT INTO `lang_definitions` VALUES (3598, 828, 3, 'Ago');
INSERT INTO `lang_definitions` VALUES (3599, 829, 3, 'Agosto');
INSERT INTO `lang_definitions` VALUES (3600, 831, 3, 'Autorización');
INSERT INTO `lang_definitions` VALUES (3601, 832, 3, 'Autorización/notas');
INSERT INTO `lang_definitions` VALUES (3602, 841, 3, 'Grupo de Autorización');
INSERT INTO `lang_definitions` VALUES (3603, 842, 3, 'Estatus de autorización');
INSERT INTO `lang_definitions` VALUES (3604, 843, 3, 'Autorizaciones');
INSERT INTO `lang_definitions` VALUES (3605, 844, 3, 'Autorizar');
INSERT INTO `lang_definitions` VALUES (3606, 845, 3, 'Autorizar - cualquier visita');
INSERT INTO `lang_definitions` VALUES (3607, 847, 3, 'Autorizar - mis visitas');
INSERT INTO `lang_definitions` VALUES (3608, 853, 3, 'Autorizado');
INSERT INTO `lang_definitions` VALUES (3609, 855, 3, 'Autorización solamente');
INSERT INTO `lang_definitions` VALUES (3610, 859, 3, 'Envío automático');
INSERT INTO `lang_definitions` VALUES (3611, 862, 3, 'Crear automáticamente nuevas visitas');
INSERT INTO `lang_definitions` VALUES (3612, 863, 3, 'Auto-generado');
INSERT INTO `lang_definitions` VALUES (3613, 865, 3, 'Cálculos Automáticos de Medida (CAM)');
INSERT INTO `lang_definitions` VALUES (3614, 870, 3, 'Seguimiento Cálculos Automáticos de Medida (CAM)');
INSERT INTO `lang_definitions` VALUES (3615, 871, 3, 'Medidas Automatizadas');
INSERT INTO `lang_definitions` VALUES (3616, 873, 3, 'Automático');
INSERT INTO `lang_definitions` VALUES (3617, 877, 3, 'Crear automáticamente nuevas visitas cuando en el estado de una cita se selecciona -@- (llegado)');
INSERT INTO `lang_definitions` VALUES (3618, 880, 3, 'Automóvil Médico');
INSERT INTO `lang_definitions` VALUES (3619, 882, 3, 'Autoguardado');
INSERT INTO `lang_definitions` VALUES (3620, 885, 3, 'Categorías Disponibles');
INSERT INTO `lang_definitions` VALUES (3621, 888, 3, 'Horas disponibles');
INSERT INTO `lang_definitions` VALUES (3622, 893, 3, 'Media Mensual');
INSERT INTO `lang_definitions` VALUES (3623, 897, 3, 'Avulsión/fractura por avulsión');
INSERT INTO `lang_definitions` VALUES (3624, 898, 3, 'Avulsión de maleolo lateral');
INSERT INTO `lang_definitions` VALUES (3625, 899, 3, 'Avulsión de maléolo tibial');
INSERT INTO `lang_definitions` VALUES (3626, 900, 3, 'Basado en el Conocimiento');
INSERT INTO `lang_definitions` VALUES (3627, 902, 3, 'Axilar');
INSERT INTO `lang_definitions` VALUES (3628, 909, 3, 'dos veces por día');
INSERT INTO `lang_definitions` VALUES (3629, 910, 3, 'Atrás');
INSERT INTO `lang_definitions` VALUES (3630, 911, 3, 'atrás');
INSERT INTO `lang_definitions` VALUES (3631, 912, 3, 'Retrocede ocho visitas');
INSERT INTO `lang_definitions` VALUES (3632, 913, 3, 'Retrocede once visitas');
INSERT INTO `lang_definitions` VALUES (3633, 914, 3, 'Retroceder cinco visitas');
INSERT INTO `lang_definitions` VALUES (3634, 915, 3, 'Retrocede cuatro visitas');
INSERT INTO `lang_definitions` VALUES (3635, 916, 3, 'Retrocede nueve visitas');
INSERT INTO `lang_definitions` VALUES (3636, 917, 3, 'Retroced una visita');
INSERT INTO `lang_definitions` VALUES (3637, 918, 3, 'Dolor de espalda');
INSERT INTO `lang_definitions` VALUES (3638, 919, 3, 'Problemas de espalda');
INSERT INTO `lang_definitions` VALUES (3639, 920, 3, 'Retrocede siete visitas');
INSERT INTO `lang_definitions` VALUES (3640, 921, 3, 'Retrocede seis visitas');
INSERT INTO `lang_definitions` VALUES (3641, 922, 3, 'Cirugia de espalda');
INSERT INTO `lang_definitions` VALUES (3642, 923, 3, 'Retrocede diez visitas');
INSERT INTO `lang_definitions` VALUES (3643, 924, 3, 'Retrocede tres visitas');
INSERT INTO `lang_definitions` VALUES (3644, 925, 3, 'Volver a la página de Administración');
INSERT INTO `lang_definitions` VALUES (3645, 929, 3, 'Volver al paciente');
INSERT INTO `lang_definitions` VALUES (3646, 931, 3, 'Volver a los usuarios');
INSERT INTO `lang_definitions` VALUES (3647, 932, 3, 'Volver a Vista');
INSERT INTO `lang_definitions` VALUES (3648, 933, 3, 'Retrocede doce visitas');
INSERT INTO `lang_definitions` VALUES (3649, 934, 3, 'Retrocede dos visitas');
INSERT INTO `lang_definitions` VALUES (3650, 936, 3, 'Backup');
INSERT INTO `lang_definitions` VALUES (3651, 938, 3, 'Se ha creado el fichero de backup. Ahora comenzará la descarga.');
INSERT INTO `lang_definitions` VALUES (3652, 940, 3, 'Backup creado correctamente');
INSERT INTO `lang_definitions` VALUES (3653, 941, 3, 'Cheque sin fondos');
INSERT INTO `lang_definitions` VALUES (3654, 942, 3, 'Mal crédito');
INSERT INTO `lang_definitions` VALUES (3655, 943, 3, 'Bahasa Indonesia');
INSERT INTO `lang_definitions` VALUES (3656, 944, 3, 'Bal');
INSERT INTO `lang_definitions` VALUES (3657, 945, 3, 'Balance');
INSERT INTO `lang_definitions` VALUES (3658, 946, 3, 'balance');
INSERT INTO `lang_definitions` VALUES (3659, 947, 3, 'Importe Balance');
INSERT INTO `lang_definitions` VALUES (3660, 948, 3, 'Balance a pagar');
INSERT INTO `lang_definitions` VALUES (3661, 952, 3, 'Recibo bancario');
INSERT INTO `lang_definitions` VALUES (3662, 956, 3, 'Base del quinto (5to) Metatarsiano');
INSERT INTO `lang_definitions` VALUES (3663, 957, 3, 'Base del quinto (5to) Metatarsiano:');
INSERT INTO `lang_definitions` VALUES (3664, 965, 3, 'Herramienta de Comunicación del Batch');
INSERT INTO `lang_definitions` VALUES (3665, 967, 3, 'Batch de entrada de pagos');
INSERT INTO `lang_definitions` VALUES (3666, 968, 3, 'Serie de Pagos');
INSERT INTO `lang_definitions` VALUES (3667, 969, 3, 'Iniciado proceso Batch; esto puede tardar unos minutos.');
INSERT INTO `lang_definitions` VALUES (3668, 970, 3, 'Resultados de la serie (Batch)');
INSERT INTO `lang_definitions` VALUES (3669, 971, 3, 'Comunicación en serie');
INSERT INTO `lang_definitions` VALUES (3670, 977, 3, 'porque no existe ese id.');
INSERT INTO `lang_definitions` VALUES (3671, 986, 3, 'Empezar');
INSERT INTO `lang_definitions` VALUES (3672, 988, 3, 'Fecha comienzo');
INSERT INTO `lang_definitions` VALUES (3673, 991, 3, 'Fecha de inicio de servicio aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (3674, 992, 3, 'Hora de inicio del día para los eventos del calendario');
INSERT INTO `lang_definitions` VALUES (3675, 996, 3, 'Eructo');
INSERT INTO `lang_definitions` VALUES (3676, 1000, 3, 'Bengali');
INSERT INTO `lang_definitions` VALUES (3677, 1003, 3, 'entre');
INSERT INTO `lang_definitions` VALUES (3678, 1009, 3, 'Bilateral');
INSERT INTO `lang_definitions` VALUES (3679, 1010, 3, 'Bilateral:');
INSERT INTO `lang_definitions` VALUES (3680, 1013, 3, 'Fecha factura:');
INSERT INTO `lang_definitions` VALUES (3681, 1015, 3, 'Factura/Cobrar');
INSERT INTO `lang_definitions` VALUES (3682, 1016, 3, 'Facturado');
INSERT INTO `lang_definitions` VALUES (3683, 1018, 3, 'Facturación');
INSERT INTO `lang_definitions` VALUES (3684, 1019, 3, 'Facturación (escritura opcional)');
INSERT INTO `lang_definitions` VALUES (3685, 1023, 3, 'Atención facturación');
INSERT INTO `lang_definitions` VALUES (3686, 1025, 3, 'Código de facturación para el Servicio Solicitado');
INSERT INTO `lang_definitions` VALUES (3687, 1026, 3, 'Códigos de facturación');
INSERT INTO `lang_definitions` VALUES (3688, 1027, 3, 'Datos de facturación');
INSERT INTO `lang_definitions` VALUES (3689, 1028, 3, 'Departamento de Facturación');
INSERT INTO `lang_definitions` VALUES (3690, 1029, 3, 'Centro de Facturación');
INSERT INTO `lang_definitions` VALUES (3691, 1031, 3, 'Información facturación');
INSERT INTO `lang_definitions` VALUES (3692, 1032, 3, 'Dirección facturación');
INSERT INTO `lang_definitions` VALUES (3693, 1039, 3, 'Administrador de Facturación');
INSERT INTO `lang_definitions` VALUES (3694, 1040, 3, 'Nota de facturación');
INSERT INTO `lang_definitions` VALUES (3695, 1041, 3, 'Nota de facturación para');
INSERT INTO `lang_definitions` VALUES (3696, 1042, 3, 'Nota de facturación:');
INSERT INTO `lang_definitions` VALUES (3697, 1044, 3, 'Resultados de la cola de la facturación:');
INSERT INTO `lang_definitions` VALUES (3698, 1045, 3, 'Informe de Facturación');
INSERT INTO `lang_definitions` VALUES (3699, 1046, 3, 'Estado de facturación');
INSERT INTO `lang_definitions` VALUES (3700, 1047, 3, 'Estado de Facturación = No facturados');
INSERT INTO `lang_definitions` VALUES (3701, 1048, 3, 'facturación para');
INSERT INTO `lang_definitions` VALUES (3702, 1052, 3, 'Biopsia');
INSERT INTO `lang_definitions` VALUES (3703, 1054, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (3704, 1058, 3, 'Negro');
INSERT INTO `lang_definitions` VALUES (3705, 1061, 3, 'Pulmón negro');
INSERT INTO `lang_definitions` VALUES (3706, 1062, 3, 'Negro o Afroamericano');
INSERT INTO `lang_definitions` VALUES (3707, 1063, 3, 'Cáncer de vejiga');
INSERT INTO `lang_definitions` VALUES (3708, 1064, 3, 'Infecciones de vejiga');
INSERT INTO `lang_definitions` VALUES (3709, 1066, 3, 'Formularios en Blanco');
INSERT INTO `lang_definitions` VALUES (3710, 1067, 3, 'Problemas de sangrado');
INSERT INTO `lang_definitions` VALUES (3711, 1068, 3, 'Puntos ciegos');
INSERT INTO `lang_definitions` VALUES (3712, 1070, 3, 'Hinchazón');
INSERT INTO `lang_definitions` VALUES (3713, 1072, 3, 'Atascado');
INSERT INTO `lang_definitions` VALUES (3714, 1073, 3, 'Sangre');
INSERT INTO `lang_definitions` VALUES (3715, 1074, 3, 'Presión Arterial');
INSERT INTO `lang_definitions` VALUES (3716, 1075, 3, 'Presión arterial');
INSERT INTO `lang_definitions` VALUES (3717, 1076, 3, 'Sangra por la nariz');
INSERT INTO `lang_definitions` VALUES (3718, 1077, 3, 'Blue Cross Blue Shield');
INSERT INTO `lang_definitions` VALUES (3719, 1079, 3, 'Las líneas azules en este reporte son informativas. Líneas negras muestran información existente. Líneas verdes muestran cambios aplicados correctamente. Líneas rojas indican errores o cambios que no fueron aplicados, y deben ser procesados manualmente. Reclamaciones actuales denegadas y pagos revertidos no se manejan automáticamente y aparecerán en rojo.');
INSERT INTO `lang_definitions` VALUES (3720, 1080, 3, 'Visión borrosa');
INSERT INTO `lang_definitions` VALUES (3721, 1081, 3, 'IMC');
INSERT INTO `lang_definitions` VALUES (3722, 1082, 3, 'Estado del IMC');
INSERT INTO `lang_definitions` VALUES (3723, 1084, 3, 'Región corporal');
INSERT INTO `lang_definitions` VALUES (3724, 1085, 3, 'Área Corporal');
INSERT INTO `lang_definitions` VALUES (3725, 1086, 3, 'Área corporal, si es aplicable');
INSERT INTO `lang_definitions` VALUES (3726, 1087, 3, 'Sensibilidad en hueso:');
INSERT INTO `lang_definitions` VALUES (3727, 1088, 3, 'Sensibilidad en hueso: Maléolo Tibial');
INSERT INTO `lang_definitions` VALUES (3728, 1089, 3, 'Boleano');
INSERT INTO `lang_definitions` VALUES (3729, 1091, 3, 'Infer.');
INSERT INTO `lang_definitions` VALUES (3730, 1093, 3, 'Ambos Oídos');
INSERT INTO `lang_definitions` VALUES (3731, 1094, 3, 'ambos oídos');
INSERT INTO `lang_definitions` VALUES (3732, 1097, 3, 'inferior');
INSERT INTO `lang_definitions` VALUES (3733, 1101, 3, 'CASILLA 10 A. relacionados con el Empleo');
INSERT INTO `lang_definitions` VALUES (3734, 1103, 3, 'CASILLA 10 B. Accidentes de tráfico');
INSERT INTO `lang_definitions` VALUES (3735, 1105, 3, 'CASILLA 10 C. Otros Accidentes');
INSERT INTO `lang_definitions` VALUES (3736, 1119, 3, 'CASILLA 15. Fecha de la misma o similar enfermedad (aaaa-mm-dd)');
INSERT INTO `lang_definitions` VALUES (3737, 1125, 3, 'CASILLA 16. Fecha de incapacidad a partir de (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3738, 1129, 3, 'CASILLA 16. Fecha de incapacidad (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3739, 1141, 3, 'CASILLA 18. Fecha de inicio de hospitalización (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3740, 1145, 3, 'CASILLA 18. Fecha de inicio de hospitalización (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3741, 1149, 3, 'CASILLA 20. ¿Se utiliza Laboratorio externo?');
INSERT INTO `lang_definitions` VALUES (3742, 1153, 3, 'CASILLA 22. Código del re-envío de Medicaid (CIE-9)');
INSERT INTO `lang_definitions` VALUES (3743, 1157, 3, 'CASILLA 23. Número de Autorización previa');
INSERT INTO `lang_definitions` VALUES (3744, 1158, 3, 'PA');
INSERT INTO `lang_definitions` VALUES (3745, 1159, 3, 'PA Diastólica');
INSERT INTO `lang_definitions` VALUES (3746, 1160, 3, 'PA Sistólica');
INSERT INTO `lang_definitions` VALUES (3747, 1162, 3, 'Pad');
INSERT INTO `lang_definitions` VALUES (3748, 1166, 3, 'Pas');
INSERT INTO `lang_definitions` VALUES (3749, 1168, 3, 'Portugués brasileño');
INSERT INTO `lang_definitions` VALUES (3750, 1169, 3, 'mama');
INSERT INTO `lang_definitions` VALUES (3751, 1170, 3, 'Biopsia de mama');
INSERT INTO `lang_definitions` VALUES (3752, 1171, 3, 'Secreción de la mama');
INSERT INTO `lang_definitions` VALUES (3753, 1172, 3, 'Enfermedad de la mama');
INSERT INTO `lang_definitions` VALUES (3754, 1173, 3, 'Revisión de mama');
INSERT INTO `lang_definitions` VALUES (3755, 1174, 3, 'Masa en la mama');
INSERT INTO `lang_definitions` VALUES (3756, 1176, 3, 'Sonidos respiratorios:');
INSERT INTO `lang_definitions` VALUES (3757, 1179, 3, 'Huesos fracturados');
INSERT INTO `lang_definitions` VALUES (3758, 1181, 3, 'Forma de bronquitis');
INSERT INTO `lang_definitions` VALUES (3759, 1184, 3, 'Explorar');
INSERT INTO `lang_definitions` VALUES (3760, 1185, 3, 'Explorar para Registro');
INSERT INTO `lang_definitions` VALUES (3761, 1186, 3, 'Contusiones/Hematomas');
INSERT INTO `lang_definitions` VALUES (3762, 1189, 3, 'Abultamiento derecho:');
INSERT INTO `lang_definitions` VALUES (3763, 1191, 3, 'Ardor al orinar');
INSERT INTO `lang_definitions` VALUES (3764, 1192, 3, 'Ardor Al Orinar');
INSERT INTO `lang_definitions` VALUES (3765, 1195, 3, 'Ocupado');
INSERT INTO `lang_definitions` VALUES (3766, 1196, 3, 'pero todavía no procesado.');
INSERT INTO `lang_definitions` VALUES (3767, 1197, 3, 'Glúteo');
INSERT INTO `lang_definitions` VALUES (3768, 1198, 3, 'Gluteos + S.I.');
INSERT INTO `lang_definitions` VALUES (3769, 1199, 3, 'por');
INSERT INTO `lang_definitions` VALUES (3770, 1200, 3, 'Por');
INSERT INTO `lang_definitions` VALUES (3771, 1206, 3, 'por boca');
INSERT INTO `lang_definitions` VALUES (3772, 1208, 3, 'Por/Origen');
INSERT INTO `lang_definitions` VALUES (3773, 1209, 3, 'Por:');
INSERT INTO `lang_definitions` VALUES (3774, 1212, 3, 'C');
INSERT INTO `lang_definitions` VALUES (3775, 1214, 3, 'Certificado de CA para verificar el RFC 5425 TLS del servidor syslog.');
INSERT INTO `lang_definitions` VALUES (3776, 1215, 3, 'Tiempo de Vida del Caché (en segundos)');
INSERT INTO `lang_definitions` VALUES (3777, 1216, 3, '¿Plantilla de salida del caché?');
INSERT INTO `lang_definitions` VALUES (3778, 1218, 3, 'Consumo de cafeína');
INSERT INTO `lang_definitions` VALUES (3779, 1219, 3, 'Calendario');
INSERT INTO `lang_definitions` VALUES (3780, 1220, 3, 'Fin Hora Calendario');
INSERT INTO `lang_definitions` VALUES (3781, 1221, 3, 'Intervalo Calendario');
INSERT INTO `lang_definitions` VALUES (3782, 1222, 3, 'Pantalla de calendario');
INSERT INTO `lang_definitions` VALUES (3783, 1223, 3, 'Ajustes del calendario');
INSERT INTO `lang_definitions` VALUES (3784, 1225, 3, 'Hora de inicio de calendario');
INSERT INTO `lang_definitions` VALUES (3785, 1226, 3, 'Calendario UI');
INSERT INTO `lang_definitions` VALUES (3786, 1227, 3, 'Vista de Calendario');
INSERT INTO `lang_definitions` VALUES (3787, 1230, 3, 'Llamada para añadir Formulario () va aquí.<br>');
INSERT INTO `lang_definitions` VALUES (3788, 1234, 3, 'Calorías');
INSERT INTO `lang_definitions` VALUES (3789, 1235, 3, 'Camboyano');
INSERT INTO `lang_definitions` VALUES (3790, 1236, 3, 'CAMOS');
INSERT INTO `lang_definitions` VALUES (3791, 1242, 3, 'Cancelar');
INSERT INTO `lang_definitions` VALUES (3792, 1244, 3, 'Cancelar cambios');
INSERT INTO `lang_definitions` VALUES (3793, 1245, 3, 'Cancelado');
INSERT INTO `lang_definitions` VALUES (3794, 1247, 3, 'Cáncer');
INSERT INTO `lang_definitions` VALUES (3795, 1248, 3, 'Detección de Cancer: Detección Cancer de Colon');
INSERT INTO `lang_definitions` VALUES (3796, 1249, 3, 'Detección de Cancer: Mamografía');
INSERT INTO `lang_definitions` VALUES (3797, 1250, 3, 'Detección de Cancer: Prueba de Papanicolau');
INSERT INTO `lang_definitions` VALUES (3798, 1251, 3, 'Detección de Cancer: Detección de Cancer de Próstata');
INSERT INTO `lang_definitions` VALUES (3799, 1252, 3, 'No se puede agregar esta entrada, ¡porque ya existe!');
INSERT INTO `lang_definitions` VALUES (3800, 1253, 3, '¡No se puede agregar/actualizar esta entrada porque ya existe un duplicado!');
INSERT INTO `lang_definitions` VALUES (3801, 1255, 3, 'no puede convertirse a JPEG. ¿probablemente ImageMagick no está instalado?');
INSERT INTO `lang_definitions` VALUES (3802, 1257, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador.');
INSERT INTO `lang_definitions` VALUES (3803, 1258, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador');
INSERT INTO `lang_definitions` VALUES (3804, 1259, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador.');
INSERT INTO `lang_definitions` VALUES (3805, 1261, 3, 'No se puede crear');
INSERT INTO `lang_definitions` VALUES (3806, 1266, 3, 'No se puede encontrar');
INSERT INTO `lang_definitions` VALUES (3807, 1267, 3, 'No se puede encontrar fichero de destino');
INSERT INTO `lang_definitions` VALUES (3808, 1270, 3, 'No puede encontrar al paciente con ese ID de cliente en SQL-Ledger');
INSERT INTO `lang_definitions` VALUES (3809, 1271, 3, 'No se puede encontrar el documento de referencia de postscript en');
INSERT INTO `lang_definitions` VALUES (3810, 1272, 3, 'No puede encontrar al facultativo con SQL-Ledger empleado');
INSERT INTO `lang_definitions` VALUES (3811, 1273, 3, 'No puede modificar los pagos. La no-distribución es negativa.');
INSERT INTO `lang_definitions` VALUES (3812, 1275, 3, 'No se puede abrir');
INSERT INTO `lang_definitions` VALUES (3813, 1276, 3, 'No se puede enviar al seguro.La entidad pagadora seleccionada es el paciente.');
INSERT INTO `lang_definitions` VALUES (3814, 1277, 3, 'No puede enviar al Paciente. La Entidad pagadora seleccionada es el seguro.');
INSERT INTO `lang_definitions` VALUES (3815, 1278, 3, 'No puede enviar pagos. La distribución es negativa.');
INSERT INTO `lang_definitions` VALUES (3816, 1279, 3, 'No se puede leer');
INSERT INTO `lang_definitions` VALUES (3817, 1280, 3, 'No se puede leer el directorio');
INSERT INTO `lang_definitions` VALUES (3818, 1281, 3, '¡No se puede actualizar porque no está editando una entrada existente!.');
INSERT INTO `lang_definitions` VALUES (3819, 1282, 3, 'Poner en Mayúsculas');
INSERT INTO `lang_definitions` VALUES (3820, 1284, 3, 'cápsula');
INSERT INTO `lang_definitions` VALUES (3821, 1285, 3, 'Tarjeta');
INSERT INTO `lang_definitions` VALUES (3822, 1294, 3, 'Cateterismo Cardiaco');
INSERT INTO `lang_definitions` VALUES (3823, 1295, 3, 'Ecocardiograma');
INSERT INTO `lang_definitions` VALUES (3824, 1296, 3, 'Cardiovascular');
INSERT INTO `lang_definitions` VALUES (3825, 1308, 3, 'Daño de cartílago/ condral / disco articular.');
INSERT INTO `lang_definitions` VALUES (3826, 1309, 3, 'Lesión de cartílago');
INSERT INTO `lang_definitions` VALUES (3827, 1310, 3, 'Nl Pulsos Carotideos, pulsos pedios nl');
INSERT INTO `lang_definitions` VALUES (3828, 1312, 3, 'efectivo');
INSERT INTO `lang_definitions` VALUES (3829, 1313, 3, 'Efectivo');
INSERT INTO `lang_definitions` VALUES (3830, 1314, 3, 'Entradas Efectivo');
INSERT INTO `lang_definitions` VALUES (3831, 1315, 3, 'Entradas de efectivo por facultativo');
INSERT INTO `lang_definitions` VALUES (3832, 1318, 3, 'Cirugía de cataratas');
INSERT INTO `lang_definitions` VALUES (3833, 1319, 3, 'Cataratas');
INSERT INTO `lang_definitions` VALUES (3834, 1320, 3, 'Categorías');
INSERT INTO `lang_definitions` VALUES (3835, 1321, 3, 'Categorías para');
INSERT INTO `lang_definitions` VALUES (3836, 1322, 3, 'Categoría');
INSERT INTO `lang_definitions` VALUES (3837, 1323, 3, 'categoría');
INSERT INTO `lang_definitions` VALUES (3838, 1324, 3, 'Categoría');
INSERT INTO `lang_definitions` VALUES (3839, 1328, 3, 'Detalles de Categoría');
INSERT INTO `lang_definitions` VALUES (3840, 1329, 3, 'Límites de Categoría');
INSERT INTO `lang_definitions` VALUES (3841, 1330, 3, 'Nombre de Categoría');
INSERT INTO `lang_definitions` VALUES (3842, 1331, 3, 'Nombre de la Categoria está vacío');
INSERT INTO `lang_definitions` VALUES (3843, 1332, 3, 'Categoría/Título');
INSERT INTO `lang_definitions` VALUES (3844, 1333, 3, 'Caucásico');
INSERT INTO `lang_definitions` VALUES (3845, 1334, 3, 'Imprime la receta de la visita con la información del proveedor primario');
INSERT INTO `lang_definitions` VALUES (3846, 1354, 3, 'CDR');
INSERT INTO `lang_definitions` VALUES (3847, 1356, 3, 'Celda');
INSERT INTO `lang_definitions` VALUES (3848, 1357, 3, 'Teléfono Móvil');
INSERT INTO `lang_definitions` VALUES (3849, 1359, 3, 'Teléfono Móvil');
INSERT INTO `lang_definitions` VALUES (3850, 1360, 3, 'Certificación central');
INSERT INTO `lang_definitions` VALUES (3851, 1362, 3, 'Centroamericano/Sudamericano');
INSERT INTO `lang_definitions` VALUES (3852, 1363, 3, 'La localización del fichero de Certificado de Autoridad crt no puede estar vacía');
INSERT INTO `lang_definitions` VALUES (3853, 1364, 3, 'La localizacion de la clave del fichero del Certificado de Autoridad no puede estar vacía');
INSERT INTO `lang_definitions` VALUES (3854, 1365, 3, 'Certificado para enviar a la RFC 5425 TLS del servidor syslog.');
INSERT INTO `lang_definitions` VALUES (3855, 1366, 3, 'Usuario del Certificado');
INSERT INTO `lang_definitions` VALUES (3856, 1367, 3, 'Certificados');
INSERT INTO `lang_definitions` VALUES (3857, 1369, 3, 'ChampUS');
INSERT INTO `lang_definitions` VALUES (3858, 1370, 3, 'ChampUSVA');
INSERT INTO `lang_definitions` VALUES (3859, 1371, 3, 'cambiar');
INSERT INTO `lang_definitions` VALUES (3860, 1372, 3, 'Cambio');
INSERT INTO `lang_definitions` VALUES (3861, 1373, 3, 'Cambia actividad');
INSERT INTO `lang_definitions` VALUES (3862, 1376, 3, 'Cambio en la Visión');
INSERT INTO `lang_definitions` VALUES (3863, 1377, 3, 'Cambio en la Visión');
INSERT INTO `lang_definitions` VALUES (3864, 1381, 3, 'Cambiado');
INSERT INTO `lang_definitions` VALUES (3865, 1382, 3, 'Intestino Cambiado');
INSERT INTO `lang_definitions` VALUES (3866, 1388, 3, 'Características');
INSERT INTO `lang_definitions` VALUES (3867, 1389, 3, 'Caracteres Restantes');
INSERT INTO `lang_definitions` VALUES (3868, 1390, 3, 'Cargo');
INSERT INTO `lang_definitions` VALUES (3869, 1391, 3, 'Ajuste del cargo');
INSERT INTO `lang_definitions` VALUES (3870, 1392, 3, 'Cobro codificado');
INSERT INTO `lang_definitions` VALUES (3871, 1394, 3, 'Cargos');
INSERT INTO `lang_definitions` VALUES (3872, 1395, 3, 'Historia');
INSERT INTO `lang_definitions` VALUES (3873, 1396, 3, 'Gráfico de Actividad');
INSERT INTO `lang_definitions` VALUES (3874, 1397, 3, 'Informe de Actividad - Entradas/Salidas de gráficos');
INSERT INTO `lang_definitions` VALUES (3875, 1398, 3, 'Nº Identificación de gráfico');
INSERT INTO `lang_definitions` VALUES (3876, 1399, 3, 'Nº Identificación de gráfico:');
INSERT INTO `lang_definitions` VALUES (3877, 1401, 3, 'Actividad de Localización de Gráficos');
INSERT INTO `lang_definitions` VALUES (3878, 1402, 3, 'Nota en el gráfico');
INSERT INTO `lang_definitions` VALUES (3879, 1403, 3, 'Número de gráfico');
INSERT INTO `lang_definitions` VALUES (3880, 1405, 3, 'Gráfico de Localizaciones archivadas');
INSERT INTO `lang_definitions` VALUES (3881, 1406, 3, 'Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (3882, 1407, 3, 'Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (3883, 1408, 3, 'Gráficas retiradas');
INSERT INTO `lang_definitions` VALUES (3884, 1409, 3, 'Gráficas retiradas');
INSERT INTO `lang_definitions` VALUES (3885, 1413, 3, 'Comprobar');
INSERT INTO `lang_definitions` VALUES (3886, 1414, 3, 'comprobar');
INSERT INTO `lang_definitions` VALUES (3887, 1415, 3, 'Comprobar todo');
INSERT INTO `lang_definitions` VALUES (3888, 1417, 3, 'Importe del cheque');
INSERT INTO `lang_definitions` VALUES (3889, 1419, 3, 'Fecha del cheque');
INSERT INTO `lang_definitions` VALUES (3890, 1421, 3, 'Comprobar diferencias entre las traducciones con Tabla del Idioma Personalizada');
INSERT INTO `lang_definitions` VALUES (3891, 1427, 3, 'Llegue a');
INSERT INTO `lang_definitions` VALUES (3892, 1428, 3, 'Comprobar Fecha Entrada');
INSERT INTO `lang_definitions` VALUES (3893, 1430, 3, 'Revisar los Resultados de Laboratorio');
INSERT INTO `lang_definitions` VALUES (3894, 1433, 3, 'Número de cheque');
INSERT INTO `lang_definitions` VALUES (3895, 1436, 3, 'Pago por Cheque');
INSERT INTO `lang_definitions` VALUES (3896, 1437, 3, 'Marque la casilla si es un fichero encriptado');
INSERT INTO `lang_definitions` VALUES (3897, 1441, 3, 'Selecciona ésto si quiere que los facultativos vean todas las citas por defecto y no sólo las suyas.');
INSERT INTO `lang_definitions` VALUES (3898, 1445, 3, 'Comprobar Fecha/EOB:');
INSERT INTO `lang_definitions` VALUES (3899, 1447, 3, 'Comprobar Número EOB.:');
INSERT INTO `lang_definitions` VALUES (3900, 1448, 3, 'Comprobar/Número de Referencia');
INSERT INTO `lang_definitions` VALUES (3901, 1449, 3, 'Comprobar/Número de referencia');
INSERT INTO `lang_definitions` VALUES (3902, 1450, 3, 'Lista de casillas');
INSERT INTO `lang_definitions` VALUES (3903, 1451, 3, 'Lista de casillas');
INSERT INTO `lang_definitions` VALUES (3904, 1452, 3, 'Casilla con Texto');
INSERT INTO `lang_definitions` VALUES (3905, 1453, 3, 'Casilla con texto');
INSERT INTO `lang_definitions` VALUES (3906, 1457, 3, 'Comprobado');
INSERT INTO `lang_definitions` VALUES (3907, 1459, 3, 'Casilla marcada = sí, vacía = no');
INSERT INTO `lang_definitions` VALUES (3908, 1468, 3, 'Comprobación');
INSERT INTO `lang_definitions` VALUES (3909, 1469, 3, 'Sumatorio');
INSERT INTO `lang_definitions` VALUES (3910, 1470, 3, 'Pecho');
INSERT INTO `lang_definitions` VALUES (3911, 1471, 3, 'Pecho CTAB');
INSERT INTO `lang_definitions` VALUES (3912, 1472, 3, 'Dolor de Pecho');
INSERT INTO `lang_definitions` VALUES (3913, 1473, 3, 'Dolor de Pecho:');
INSERT INTO `lang_definitions` VALUES (3914, 1474, 3, 'Dolores de Pecho');
INSERT INTO `lang_definitions` VALUES (3915, 1476, 3, 'Var');
INSERT INTO `lang_definitions` VALUES (3916, 1478, 3, 'Síntoma Principal');
INSERT INTO `lang_definitions` VALUES (3917, 1481, 3, 'Niño');
INSERT INTO `lang_definitions` VALUES (3918, 1483, 3, 'Estado de vacunación de la niñez (GCC)');
INSERT INTO `lang_definitions` VALUES (3919, 1484, 3, 'Escalofríos');
INSERT INTO `lang_definitions` VALUES (3920, 1485, 3, 'Chino');
INSERT INTO `lang_definitions` VALUES (3921, 1486, 3, 'Chino (simplificado)');
INSERT INTO `lang_definitions` VALUES (3922, 1487, 3, 'Chino (tradicional)');
INSERT INTO `lang_definitions` VALUES (3923, 1489, 3, 'Opciones');
INSERT INTO `lang_definitions` VALUES (3924, 1490, 3, 'Colecistectomía');
INSERT INTO `lang_definitions` VALUES (3925, 1492, 3, 'Colecistectomía');
INSERT INTO `lang_definitions` VALUES (3926, 1493, 3, 'Elegir');
INSERT INTO `lang_definitions` VALUES (3927, 1496, 3, 'Elija una sección y haga click en un elemento dentro de ella; luego, en la otra sección, verá remarcados los elementos relacionados, puede hacer click en esa sección para añadir y borrar relaciones.');
INSERT INTO `lang_definitions` VALUES (3928, 1497, 3, 'Criterios de selección');
INSERT INTO `lang_definitions` VALUES (3929, 1504, 3, 'Lista de Selecciones');
INSERT INTO `lang_definitions` VALUES (3930, 1510, 3, 'Seleccione formato de impresión para este informe de visitas.');
INSERT INTO `lang_definitions` VALUES (3931, 1514, 3, 'Bronquitis Crónica');
INSERT INTO `lang_definitions` VALUES (3932, 1515, 3, 'Dolor crónico de articulaciones');
INSERT INTO `lang_definitions` VALUES (3933, 1516, 3, 'Enfermedad Renal Crónica (ERC)');
INSERT INTO `lang_definitions` VALUES (3934, 1519, 3, 'Sinovitis crónica/derrame/dolor articular/gota');
INSERT INTO `lang_definitions` VALUES (3935, 1521, 3, 'Crónico/Recurrente');
INSERT INTO `lang_definitions` VALUES (3936, 1524, 3, 'Cirrosis de hígado');
INSERT INTO `lang_definitions` VALUES (3937, 1525, 3, 'Cirrosis del Hígado');
INSERT INTO `lang_definitions` VALUES (3938, 1526, 3, 'Ciudad');
INSERT INTO `lang_definitions` VALUES (3939, 1527, 3, 'Nombre de Ciudad');
INSERT INTO `lang_definitions` VALUES (3940, 1528, 3, 'Ciudad, Provincia');
INSERT INTO `lang_definitions` VALUES (3941, 1529, 3, 'Ciudad, Código Postal');
INSERT INTO `lang_definitions` VALUES (3942, 1531, 3, 'Ciudad/Provincia');
INSERT INTO `lang_definitions` VALUES (3943, 1532, 3, 'Reclamación');
INSERT INTO `lang_definitions` VALUES (3944, 1533, 3, 'Reclamación');
INSERT INTO `lang_definitions` VALUES (3945, 1536, 3, 'Prueba de Reclamación ha terminado');
INSERT INTO `lang_definitions` VALUES (3946, 1537, 3, 'Tipo de Reclamación');
INSERT INTO `lang_definitions` VALUES (3947, 1538, 3, 'Reclamación generada para presentar');
INSERT INTO `lang_definitions` VALUES (3948, 1539, 3, 'La Reclamación se ha guardado en el fichero');
INSERT INTO `lang_definitions` VALUES (3949, 1540, 3, 'Reclamaciones');
INSERT INTO `lang_definitions` VALUES (3950, 1541, 3, 'Clasificación');
INSERT INTO `lang_definitions` VALUES (3951, 1542, 3, 'Limpiar');
INSERT INTO `lang_definitions` VALUES (3952, 1547, 3, 'Limpiar todos');
INSERT INTO `lang_definitions` VALUES (3953, 1550, 3, 'Limpiar Datos HL7');
INSERT INTO `lang_definitions` VALUES (3954, 1551, 3, 'Limpiar Justificación');
INSERT INTO `lang_definitions` VALUES (3955, 1554, 3, 'Vaciar Cache Smarty');
INSERT INTO `lang_definitions` VALUES (3956, 1555, 3, 'Información requerida por la Cámara de compensación en la creación del Batch EDI 270');
INSERT INTO `lang_definitions` VALUES (3957, 1556, 3, 'Número CLIA');
INSERT INTO `lang_definitions` VALUES (3958, 1557, 3, 'Click');
INSERT INTO `lang_definitions` VALUES (3959, 1558, 3, 'Click \'export\' para exportar su Categoría, Subcategoría, Item o Datos contenidos a un fichero de texto. Cualquier similitud de este fichero con un fichero tipo XML es pura coincidencia. Las etiquetas de abrir y cerrar deben estar en la misma línea y deben ser minúsculas sin espacios. Para importar, localize el fichero y click \'Importar\'. Si los datos son completamente diferentes se unen a los datos existentes. Si hay datos con nombres similares, el nombre más antiguo se mantiene mientras que al nuevo se le agrega un número al final.');
INSERT INTO `lang_definitions` VALUES (3960, 1561, 3, 'Click en el gráfico para nueva anotacion, click de nuevo para eliminarla.');
INSERT INTO `lang_definitions` VALUES (3961, 1565, 3, 'Click descargar Certificado para descargar los certificados en el fichero ssl.zip');
INSERT INTO `lang_definitions` VALUES (3962, 1566, 3, 'Click para más');
INSERT INTO `lang_definitions` VALUES (3963, 1571, 3, 'Click aquí');
INSERT INTO `lang_definitions` VALUES (3964, 1572, 3, 'Click aquí para añadir un nuevo paciente.');
INSERT INTO `lang_definitions` VALUES (3965, 1573, 3, 'Click aqui para añadir un nuevo cambio de estado de la lesion y editar la actividad diaria.');
INSERT INTO `lang_definitions` VALUES (3966, 1575, 3, 'Click aquí para elegir una fecha');
INSERT INTO `lang_definitions` VALUES (3967, 1576, 3, 'Click aquí para elegir una fecha y hora');
INSERT INTO `lang_definitions` VALUES (3968, 1577, 3, 'Click aquí para elegir una fecha de inicio');
INSERT INTO `lang_definitions` VALUES (3969, 1597, 3, 'Click aquí para buscar');
INSERT INTO `lang_definitions` VALUES (3970, 1599, 3, 'Click aquí para actualizar configuración de prioridad, categoría y apodos');
INSERT INTO `lang_definitions` VALUES (3971, 1601, 3, 'Click aquí para ver todo.');
INSERT INTO `lang_definitions` VALUES (3972, 1602, 3, 'Click aqui para vista y gráficos');
INSERT INTO `lang_definitions` VALUES (3973, 1604, 3, 'Click aquí para vista y grafico de todas las constantes vitales.');
INSERT INTO `lang_definitions` VALUES (3974, 1605, 3, 'Click aquí para ver los detalles del paciente');
INSERT INTO `lang_definitions` VALUES (3975, 1606, 3, 'Click aquí para ver todos.');
INSERT INTO `lang_definitions` VALUES (3976, 1609, 3, 'Click botón Instalar para instalar la versión de la base de datos desde la siguiente fecha');
INSERT INTO `lang_definitions` VALUES (3977, 1615, 3, 'Click aquí para aumentar los intervalos de tiempo');
INSERT INTO `lang_definitions` VALUES (3978, 1636, 3, 'Click en Nombre Paciente para abrir el fichero del paciente');
INSERT INTO `lang_definitions` VALUES (3979, 1638, 3, 'Click Refrescar para ver todos los resultados o introduzca un criterio de búsqueda arriba para ver resultados específicos.');
INSERT INTO `lang_definitions` VALUES (3980, 1664, 3, 'Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (3981, 1665, 3, 'Click para agregar nueva consulta');
INSERT INTO `lang_definitions` VALUES (3982, 1670, 3, 'Click para descargar');
INSERT INTO `lang_definitions` VALUES (3983, 1671, 3, 'Click para editar');
INSERT INTO `lang_definitions` VALUES (3984, 1673, 3, 'Click para editar este evento');
INSERT INTO `lang_definitions` VALUES (3985, 1675, 3, 'Click para generar el informe');
INSERT INTO `lang_definitions` VALUES (3986, 1685, 3, 'Click para imprimir');
INSERT INTO `lang_definitions` VALUES (3987, 1686, 3, 'Click para recibir (añadir) nuevo lote');
INSERT INTO `lang_definitions` VALUES (3988, 1689, 3, 'Click para seleccionar');
INSERT INTO `lang_definitions` VALUES (3989, 1690, 3, 'Click Para Seleccionar');
INSERT INTO `lang_definitions` VALUES (3990, 1692, 3, 'Click para seleccionar un código estándar industrial para este procedimiento');
INSERT INTO `lang_definitions` VALUES (3991, 1695, 3, 'Click para seleccionar el codigo de procedimiento opcional');
INSERT INTO `lang_definitions` VALUES (3992, 1697, 3, 'Click para seleccionar o cambiar código CVX');
INSERT INTO `lang_definitions` VALUES (3993, 1698, 3, 'Click para seleccionar o cambiar diagnósticos');
INSERT INTO `lang_definitions` VALUES (3994, 1699, 3, 'Click para seleccionar o cambiar códigos de servicios');
INSERT INTO `lang_definitions` VALUES (3995, 1700, 3, 'Click para seleccionar el paciente');
INSERT INTO `lang_definitions` VALUES (3996, 1701, 3, 'Click para seleccionar un código relacionado');
INSERT INTO `lang_definitions` VALUES (3997, 1702, 3, 'Click para seleccionar servicios a realizar si este resultado es anormal');
INSERT INTO `lang_definitions` VALUES (3998, 1705, 3, 'Click para seleccionar el procedimiento deseado');
INSERT INTO `lang_definitions` VALUES (3999, 1713, 3, 'Click para ver');
INSERT INTO `lang_definitions` VALUES (4000, 1715, 3, 'Click para ver o editar');
INSERT INTO `lang_definitions` VALUES (4001, 1716, 3, 'Click para ver/editar');
INSERT INTO `lang_definitions` VALUES (4002, 1718, 3, 'Click botón Actualizar para actualizar la versión de la base de datos desde la fecha siguiente');
INSERT INTO `lang_definitions` VALUES (4003, 1720, 3, 'Click:');
INSERT INTO `lang_definitions` VALUES (4004, 1742, 3, 'Días para Vencimiento del Certificado del Cliente');
INSERT INTO `lang_definitions` VALUES (4005, 1743, 3, 'Periodo de validación del Certificado del Cliente');
INSERT INTO `lang_definitions` VALUES (4006, 1744, 3, 'El certificado de validación del cliente debe ser un número válido');
INSERT INTO `lang_definitions` VALUES (4007, 1745, 3, 'Copia para el cliente');
INSERT INTO `lang_definitions` VALUES (4008, 1747, 3, 'Resumen de historia clínica del cliente');
INSERT INTO `lang_definitions` VALUES (4009, 1750, 3, 'Perfil de cliente - Nuevos Clientes');
INSERT INTO `lang_definitions` VALUES (4010, 1751, 3, 'Perfil de cliente - Clientes Únicos');
INSERT INTO `lang_definitions` VALUES (4011, 1752, 3, 'Clientes');
INSERT INTO `lang_definitions` VALUES (4012, 1753, 3, 'Clínica');
INSERT INTO `lang_definitions` VALUES (4013, 1754, 3, 'Copia para la Clínica');
INSERT INTO `lang_definitions` VALUES (4014, 1755, 3, 'Registro Diario de la Clínica');
INSERT INTO `lang_definitions` VALUES (4015, 1756, 3, 'Nº Identificación de Clínica');
INSERT INTO `lang_definitions` VALUES (4016, 1757, 3, 'Clínico');
INSERT INTO `lang_definitions` VALUES (4017, 1758, 3, 'Gestor de Alertas para las Reglas de Decisión Clinicas');
INSERT INTO `lang_definitions` VALUES (4018, 1763, 3, 'Planes Clínicos');
INSERT INTO `lang_definitions` VALUES (4019, 1764, 3, 'Medidas de Calidad Clínica (GCC)');
INSERT INTO `lang_definitions` VALUES (4020, 1767, 3, 'Recordatorios Clínicos');
INSERT INTO `lang_definitions` VALUES (4021, 1771, 3, 'Reportes Clínicos');
INSERT INTO `lang_definitions` VALUES (4022, 1772, 3, 'Reglas Clínicas para Categoría de Acción');
INSERT INTO `lang_definitions` VALUES (4023, 1773, 3, 'Reglas Clínicas para Asunto de Acción');
INSERT INTO `lang_definitions` VALUES (4024, 1774, 3, 'Reglas Clínicas para Métodos de filtro');
INSERT INTO `lang_definitions` VALUES (4025, 1775, 3, 'Reglas Clínicas para Objetivo de Métodos');
INSERT INTO `lang_definitions` VALUES (4026, 1776, 3, 'Reglas Clínicas');
INSERT INTO `lang_definitions` VALUES (4027, 1777, 3, 'Reglas Clínicas para Intervalos de Edad');
INSERT INTO `lang_definitions` VALUES (4028, 1778, 3, 'Reglas Clínicas de Comparación');
INSERT INTO `lang_definitions` VALUES (4029, 1779, 3, 'Reglas Clínicas de Tipos de Visitas');
INSERT INTO `lang_definitions` VALUES (4030, 1780, 3, 'Reglas Clínicas de opciones de Vencimientos de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4031, 1781, 3, 'Reglas Clínicas de opciones de Desactivación de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4032, 1782, 3, 'Reglas Clínicas de intervalos de recordatorios');
INSERT INTO `lang_definitions` VALUES (4033, 1783, 3, 'Reglas Clínicas de Métodos de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4034, 1784, 3, 'Reglas Clínicas de Intervalos de Destino');
INSERT INTO `lang_definitions` VALUES (4035, 1785, 3, 'Destinos Clínicos');
INSERT INTO `lang_definitions` VALUES (4036, 1788, 3, 'Vista de Clínica');
INSERT INTO `lang_definitions` VALUES (4037, 1789, 3, 'Médicos');
INSERT INTO `lang_definitions` VALUES (4038, 1790, 3, 'Clonar');
INSERT INTO `lang_definitions` VALUES (4039, 1791, 3, 'Clonar Visita Anterior');
INSERT INTO `lang_definitions` VALUES (4040, 1792, 3, 'Cerrar');
INSERT INTO `lang_definitions` VALUES (4041, 1798, 3, 'Cerrar Ventana');
INSERT INTO `lang_definitions` VALUES (4042, 1799, 3, 'cerrar ventana');
INSERT INTO `lang_definitions` VALUES (4043, 1801, 3, 'Cerrado');
INSERT INTO `lang_definitions` VALUES (4044, 1802, 3, 'cm');
INSERT INTO `lang_definitions` VALUES (4045, 1804, 3, 'Margenes del formulario CMS 1500');
INSERT INTO `lang_definitions` VALUES (4046, 1813, 3, 'CMS ID');
INSERT INTO `lang_definitions` VALUES (4047, 1827, 3, 'NC 2-12 Intacto');
INSERT INTO `lang_definitions` VALUES (4048, 1830, 3, 'Copago');
INSERT INTO `lang_definitions` VALUES (4049, 1831, 3, 'Copago pagado');
INSERT INTO `lang_definitions` VALUES (4050, 1833, 3, 'Copago');
INSERT INTO `lang_definitions` VALUES (4051, 1835, 3, 'Código');
INSERT INTO `lang_definitions` VALUES (4052, 1836, 3, 'código');
INSERT INTO `lang_definitions` VALUES (4053, 1837, 3, 'Buscador de Código');
INSERT INTO `lang_definitions` VALUES (4054, 1838, 3, 'Código debe ser dos letras en minúscula');
INSERT INTO `lang_definitions` VALUES (4055, 1839, 3, 'Código o símbolo para indicar moneda');
INSERT INTO `lang_definitions` VALUES (4056, 1841, 3, 'Código de Texto');
INSERT INTO `lang_definitions` VALUES (4057, 1843, 3, 'tipo de código');
INSERT INTO `lang_definitions` VALUES (4058, 1846, 3, 'Típos de Código');
INSERT INTO `lang_definitions` VALUES (4059, 1848, 3, 'Codificado');
INSERT INTO `lang_definitions` VALUES (4060, 1849, 3, 'Códigos');
INSERT INTO `lang_definitions` VALUES (4061, 1851, 3, 'Codificando');
INSERT INTO `lang_definitions` VALUES (4062, 1853, 3, 'Codificación - cualquier visita(escribir, con algunas opciones)');
INSERT INTO `lang_definitions` VALUES (4063, 1855, 3, 'Codificación - mis visitas(escribir, con algunas opciones)');
INSERT INTO `lang_definitions` VALUES (4064, 1860, 3, 'Codificación no autorizada');
INSERT INTO `lang_definitions` VALUES (4065, 1861, 3, 'Café');
INSERT INTO `lang_definitions` VALUES (4066, 1864, 3, 'Coseguro');
INSERT INTO `lang_definitions` VALUES (4067, 1865, 3, 'Coll w/o');
INSERT INTO `lang_definitions` VALUES (4068, 1867, 3, 'Contraer');
INSERT INTO `lang_definitions` VALUES (4069, 1868, 3, 'contraer');
INSERT INTO `lang_definitions` VALUES (4070, 1869, 3, 'Contraer Todo');
INSERT INTO `lang_definitions` VALUES (4071, 1870, 3, 'Contraer todo');
INSERT INTO `lang_definitions` VALUES (4072, 1871, 3, 'contraer todo');
INSERT INTO `lang_definitions` VALUES (4073, 1875, 3, 'Fecha de recolecciòn');
INSERT INTO `lang_definitions` VALUES (4074, 1877, 3, 'Recobro');
INSERT INTO `lang_definitions` VALUES (4075, 1878, 3, 'Informe de Recobro');
INSERT INTO `lang_definitions` VALUES (4076, 1879, 3, 'Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4077, 1880, 3, 'Detección de Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4078, 1881, 3, 'Cirugía de Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4079, 1882, 3, 'Colonoscopia');
INSERT INTO `lang_definitions` VALUES (4080, 1883, 3, 'colonoscopía');
INSERT INTO `lang_definitions` VALUES (4081, 1884, 3, 'Color');
INSERT INTO `lang_definitions` VALUES (4082, 1890, 3, 'Abreviatura de color');
INSERT INTO `lang_definitions` VALUES (4083, 1891, 3, 'Colunma');
INSERT INTO `lang_definitions` VALUES (4084, 1892, 3, 'Columnas');
INSERT INTO `lang_definitions` VALUES (4085, 1894, 3, 'Combinando Lotes');
INSERT INTO `lang_definitions` VALUES (4086, 1895, 3, 'Coma');
INSERT INTO `lang_definitions` VALUES (4087, 1896, 3, 'Comentario');
INSERT INTO `lang_definitions` VALUES (4088, 1897, 3, 'Comentarios');
INSERT INTO `lang_definitions` VALUES (4089, 1898, 3, 'Comentarios para este resultado o recomendación');
INSERT INTO `lang_definitions` VALUES (4090, 1899, 3, 'Sociedad Comercial de Seguros');
INSERT INTO `lang_definitions` VALUES (4091, 1900, 3, 'Guardar Cambios');
INSERT INTO `lang_definitions` VALUES (4092, 1904, 3, 'Comunicaciones');
INSERT INTO `lang_definitions` VALUES (4093, 1907, 3, 'Compañía');
INSERT INTO `lang_definitions` VALUES (4094, 1908, 3, 'Nombre Empresa');
INSERT INTO `lang_definitions` VALUES (4095, 1909, 3, 'Completo');
INSERT INTO `lang_definitions` VALUES (4096, 1911, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (4097, 1914, 3, 'Terminado?');
INSERT INTO `lang_definitions` VALUES (4098, 1917, 3, 'Conplicaciones por el proveedor de servicios');
INSERT INTO `lang_definitions` VALUES (4099, 1918, 3, 'Complicaciones de aborto');
INSERT INTO `lang_definitions` VALUES (4100, 1919, 3, 'Componentes');
INSERT INTO `lang_definitions` VALUES (4101, 1924, 3, 'Sistema Computarizado de Pedidos Médicos');
INSERT INTO `lang_definitions` VALUES (4102, 1925, 3, 'Conclusiones');
INSERT INTO `lang_definitions` VALUES (4103, 1929, 3, 'Config');
INSERT INTO `lang_definitions` VALUES (4104, 1930, 3, 'Configuración');
INSERT INTO `lang_definitions` VALUES (4105, 1931, 3, 'Configuración Exportar/Importar');
INSERT INTO `lang_definitions` VALUES (4106, 1933, 3, 'Configure Apache y OpenEMR para usar certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4107, 1934, 3, 'Configure Apache para usar certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4108, 1935, 3, 'Configure Apache para usar HTTPS');
INSERT INTO `lang_definitions` VALUES (4109, 1936, 3, 'Configure Openemr para usar certificado SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4110, 1945, 3, 'Confirma Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (4111, 1947, 3, 'Confirmar Nueva Contraseña');
INSERT INTO `lang_definitions` VALUES (4112, 1948, 3, 'Confirmar Pago');
INSERT INTO `lang_definitions` VALUES (4113, 1956, 3, 'Congénito');
INSERT INTO `lang_definitions` VALUES (4114, 1958, 3, 'Conjuntiva, pupilas');
INSERT INTO `lang_definitions` VALUES (4115, 1961, 3, 'Conectores');
INSERT INTO `lang_definitions` VALUES (4116, 1962, 3, 'Constante');
INSERT INTO `lang_definitions` VALUES (4117, 1963, 3, 'Nombre constante');
INSERT INTO `lang_definitions` VALUES (4118, 1964, 3, 'Nombre constante está en blanco');
INSERT INTO `lang_definitions` VALUES (4119, 1965, 3, 'constantes');
INSERT INTO `lang_definitions` VALUES (4120, 1966, 3, 'Estreñimiento');
INSERT INTO `lang_definitions` VALUES (4121, 1967, 3, 'Constitucional');
INSERT INTO `lang_definitions` VALUES (4122, 1970, 3, 'Breve Descripción de Consulta');
INSERT INTO `lang_definitions` VALUES (4123, 1972, 3, 'Contacto');
INSERT INTO `lang_definitions` VALUES (4124, 1973, 3, 'email del contacto');
INSERT INTO `lang_definitions` VALUES (4125, 1974, 3, 'email de contacto');
INSERT INTO `lang_definitions` VALUES (4126, 1976, 3, 'Informacion de contacto');
INSERT INTO `lang_definitions` VALUES (4127, 1979, 3, 'Lentes de Contacto');
INSERT INTO `lang_definitions` VALUES (4128, 1984, 3, 'Nombre del contacto');
INSERT INTO `lang_definitions` VALUES (4129, 1987, 3, 'Persona de Contacto');
INSERT INTO `lang_definitions` VALUES (4130, 1989, 3, 'Número de Teléfono de Contacto');
INSERT INTO `lang_definitions` VALUES (4131, 1991, 3, 'Contactar ZMG, LLC (zmghealth@gmail.com) para suscribir el servicio de receta electrónica');
INSERT INTO `lang_definitions` VALUES (4132, 1993, 3, 'contiene por lo menos tres de las cuatro cosas siguientes:');
INSERT INTO `lang_definitions` VALUES (4133, 1995, 3, 'Contenido');
INSERT INTO `lang_definitions` VALUES (4134, 1996, 3, 'contenido');
INSERT INTO `lang_definitions` VALUES (4135, 1998, 3, 'Contexto');
INSERT INTO `lang_definitions` VALUES (4136, 1999, 3, 'El nombre de contexto no puede estar vacío');
INSERT INTO `lang_definitions` VALUES (4137, 2000, 3, 'Continuar');
INSERT INTO `lang_definitions` VALUES (4138, 2002, 3, 'Continuidad del Documento de Atención (CCD)');
INSERT INTO `lang_definitions` VALUES (4139, 2005, 3, 'Continuidad del registro de cuidados (CCR)');
INSERT INTO `lang_definitions` VALUES (4140, 2006, 3, 'Contra Clientes');
INSERT INTO `lang_definitions` VALUES (4141, 2007, 3, 'Contracepción');
INSERT INTO `lang_definitions` VALUES (4142, 2008, 3, 'Incidencias de Anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4143, 2009, 3, 'Complicación anticonceptivos (especificar)');
INSERT INTO `lang_definitions` VALUES (4144, 2010, 3, 'Método Anticonceptivo');
INSERT INTO `lang_definitions` VALUES (4145, 2011, 3, 'Productos Anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4146, 2012, 3, 'Servicios anticonceptivos ya empezados');
INSERT INTO `lang_definitions` VALUES (4147, 2013, 3, 'Comienzo de anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4148, 2018, 3, 'Nº Identificación de control');
INSERT INTO `lang_definitions` VALUES (4149, 2019, 3, 'N º de control');
INSERT INTO `lang_definitions` VALUES (4150, 2028, 3, 'COPAGO');
INSERT INTO `lang_definitions` VALUES (4151, 2029, 3, 'Co-pago');
INSERT INTO `lang_definitions` VALUES (4152, 2030, 3, 'Co-Pago');
INSERT INTO `lang_definitions` VALUES (4153, 2031, 3, 'El Co-pago no es positivo');
INSERT INTO `lang_definitions` VALUES (4154, 2033, 3, 'Co-pagos');
INSERT INTO `lang_definitions` VALUES (4155, 2034, 3, 'COPD');
INSERT INTO `lang_definitions` VALUES (4156, 2035, 3, 'Copiar páginas a la Historia del Paciente');
INSERT INTO `lang_definitions` VALUES (4157, 2037, 3, 'Copiar Valores');
INSERT INTO `lang_definitions` VALUES (4158, 2038, 3, 'Copiando base de datos. Puede tardar algún tiempo');
INSERT INTO `lang_definitions` VALUES (4159, 2039, 3, 'Aviso de Derechos Reservados');
INSERT INTO `lang_definitions` VALUES (4160, 2044, 3, 'Bypass coronario arterial');
INSERT INTO `lang_definitions` VALUES (4161, 2045, 3, 'Cirugía de revascularización coronaria');
INSERT INTO `lang_definitions` VALUES (4162, 2046, 3, 'Corregido');
INSERT INTO `lang_definitions` VALUES (4163, 2048, 3, 'CouchDB');
INSERT INTO `lang_definitions` VALUES (4164, 2049, 3, 'Conexión a CouchDB fallida.');
INSERT INTO `lang_definitions` VALUES (4165, 2050, 3, 'bbdd CouchDB');
INSERT INTO `lang_definitions` VALUES (4166, 2051, 3, 'Nombre de bbdd CouchDB');
INSERT INTO `lang_definitions` VALUES (4167, 2054, 3, 'Host CouchDB');
INSERT INTO `lang_definitions` VALUES (4168, 2055, 3, 'Nombre Host CouchDB');
INSERT INTO `lang_definitions` VALUES (4169, 2056, 3, 'Activar Log CouchDB');
INSERT INTO `lang_definitions` VALUES (4170, 2057, 3, 'Contraseña CouchDB');
INSERT INTO `lang_definitions` VALUES (4171, 2058, 3, 'Puerto CouchDB');
INSERT INTO `lang_definitions` VALUES (4172, 2059, 3, 'puerto CouchDB');
INSERT INTO `lang_definitions` VALUES (4173, 2061, 3, 'Nombre usuario CouchDB');
INSERT INTO `lang_definitions` VALUES (4174, 2062, 3, 'Tos');
INSERT INTO `lang_definitions` VALUES (4175, 2063, 3, 'Tos:');
INSERT INTO `lang_definitions` VALUES (4176, 2068, 3, 'No se pudo leer el fichero');
INSERT INTO `lang_definitions` VALUES (4177, 2070, 3, 'email no enviado por problema en el servidor,');
INSERT INTO `lang_definitions` VALUES (4178, 2072, 3, 'No se pudo enviar email debido a problemas en el servidor.');
INSERT INTO `lang_definitions` VALUES (4179, 2073, 3, 'No se pudo crear el dir de backup:');
INSERT INTO `lang_definitions` VALUES (4180, 2074, 3, 'No se pudo eliminar dir:');
INSERT INTO `lang_definitions` VALUES (4181, 2075, 3, 'No se pudo eliminar el antiguo fichero de Backup:');
INSERT INTO `lang_definitions` VALUES (4182, 2076, 3, 'No se pudo eliminar el antiguo fichero de exportación:');
INSERT INTO `lang_definitions` VALUES (4183, 2077, 3, 'Tratamiento con Coumadin - Seguimiento del Ratio Internacional Normalizado (RIN)');
INSERT INTO `lang_definitions` VALUES (4184, 2078, 3, 'Counseling por Método');
INSERT INTO `lang_definitions` VALUES (4185, 2079, 3, 'Orientación');
INSERT INTO `lang_definitions` VALUES (4186, 2080, 3, 'Actividades de orientación');
INSERT INTO `lang_definitions` VALUES (4187, 2083, 3, 'FORMULARIO CONTADOR DE DERIVACIONES');
INSERT INTO `lang_definitions` VALUES (4188, 2084, 3, 'Contador-Derivación');
INSERT INTO `lang_definitions` VALUES (4189, 2085, 3, 'País');
INSERT INTO `lang_definitions` VALUES (4190, 2087, 3, 'Tipo de datos País');
INSERT INTO `lang_definitions` VALUES (4191, 2088, 3, 'Lista de País');
INSERT INTO `lang_definitions` VALUES (4192, 2089, 3, 'Lista del país (escriba, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (4193, 2091, 3, 'Nombre del Pais deber ser representados por dos letras');
INSERT INTO `lang_definitions` VALUES (4194, 2092, 3, 'condado');
INSERT INTO `lang_definitions` VALUES (4195, 2094, 3, 'Cupón');
INSERT INTO `lang_definitions` VALUES (4196, 2101, 3, 'CPT');
INSERT INTO `lang_definitions` VALUES (4197, 2102, 3, 'Código CPT');
INSERT INTO `lang_definitions` VALUES (4198, 2103, 3, 'Código CPT');
INSERT INTO `lang_definitions` VALUES (4199, 2104, 3, 'Procedimiento/Servicio CPT4');
INSERT INTO `lang_definitions` VALUES (4200, 2105, 3, 'Medidas de Rendimiento CPTII');
INSERT INTO `lang_definitions` VALUES (4201, 2106, 3, 'Gestión Calidad Continua (GCC)');
INSERT INTO `lang_definitions` VALUES (4202, 2108, 3, 'Crujidos, crepitaciones');
INSERT INTO `lang_definitions` VALUES (4203, 2111, 3, 'crema');
INSERT INTO `lang_definitions` VALUES (4204, 2112, 3, 'Crear un certificado SSL del Cliente por usuario o cliente de maquina');
INSERT INTO `lang_definitions` VALUES (4205, 2113, 3, 'Crear un certificado SSL del lado del cliente, ya sea para un usuario o un nombre de host cliente.');
INSERT INTO `lang_definitions` VALUES (4206, 2124, 3, 'Crear un evento');
INSERT INTO `lang_definitions` VALUES (4207, 2128, 3, 'Crear y descargar un respaldo completo');
INSERT INTO `lang_definitions` VALUES (4208, 2130, 3, 'Crear Respaldo');
INSERT INTO `lang_definitions` VALUES (4209, 2131, 3, 'Crear batch');
INSERT INTO `lang_definitions` VALUES (4210, 2132, 3, 'Crear Certificado de Cliente');
INSERT INTO `lang_definitions` VALUES (4211, 2133, 3, 'Crear Certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4212, 2136, 3, 'Crear Duplicado');
INSERT INTO `lang_definitions` VALUES (4213, 2138, 3, 'Crear backup de registro de eventos');
INSERT INTO `lang_definitions` VALUES (4214, 2139, 3, 'Crear nueva incidencia');
INSERT INTO `lang_definitions` VALUES (4215, 2141, 3, 'Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (4216, 2144, 3, 'Crear Credenciales para el Portal Offsite');
INSERT INTO `lang_definitions` VALUES (4217, 2146, 3, 'Crear Credenciales para el Portal Onsite');
INSERT INTO `lang_definitions` VALUES (4218, 2148, 3, 'Crear nota de paciente');
INSERT INTO `lang_definitions` VALUES (4219, 2150, 3, 'Crear Certificado de Autoridad SSL y Certificados del Servidor.');
INSERT INTO `lang_definitions` VALUES (4220, 2151, 3, 'Crear visita');
INSERT INTO `lang_definitions` VALUES (4221, 2152, 3, 'Creado');
INSERT INTO `lang_definitions` VALUES (4222, 2160, 3, 'Creando fichero de exportación');
INSERT INTO `lang_definitions` VALUES (4223, 2163, 3, 'Creador');
INSERT INTO `lang_definitions` VALUES (4224, 2164, 3, 'crédito');
INSERT INTO `lang_definitions` VALUES (4225, 2165, 3, 'Tarjeta de Credito');
INSERT INTO `lang_definitions` VALUES (4226, 2167, 3, 'Créditos');
INSERT INTO `lang_definitions` VALUES (4227, 2169, 3, 'Criterio');
INSERT INTO `lang_definitions` VALUES (4228, 2171, 3, 'Enfermedad de Crohn');
INSERT INTO `lang_definitions` VALUES (4229, 2172, 3, 'Enfermedad de Crohn');
INSERT INTO `lang_definitions` VALUES (4230, 2175, 3, 'CSV');
INSERT INTO `lang_definitions` VALUES (4231, 2176, 3, 'Fichero CSV');
INSERT INTO `lang_definitions` VALUES (4232, 2182, 3, 'MM.CU (Mililitros cubicos)');
INSERT INTO `lang_definitions` VALUES (4233, 2183, 3, 'Cubano');
INSERT INTO `lang_definitions` VALUES (4234, 2185, 3, 'Número de decimales en moneda');
INSERT INTO `lang_definitions` VALUES (4235, 2186, 3, 'Tipo de Cambio - Símbolo de Punto Decimal');
INSERT INTO `lang_definitions` VALUES (4236, 2187, 3, 'Indicador de Tipo de Cambio');
INSERT INTO `lang_definitions` VALUES (4237, 2188, 3, 'Tipo de Cambio - Separador de Miles');
INSERT INTO `lang_definitions` VALUES (4238, 2189, 3, 'Actual');
INSERT INTO `lang_definitions` VALUES (4239, 2190, 3, 'Alcohol actual');
INSERT INTO `lang_definitions` VALUES (4240, 2193, 3, 'Consulta Actual');
INSERT INTO `lang_definitions` VALUES (4241, 2194, 3, 'Criterio Actual');
INSERT INTO `lang_definitions` VALUES (4242, 2196, 3, 'Color resaltado del presente día');
INSERT INTO `lang_definitions` VALUES (4243, 2197, 3, 'Actualmente fumador diario');
INSERT INTO `lang_definitions` VALUES (4244, 2199, 3, 'El nombre de fichero actual fue cambiado a');
INSERT INTO `lang_definitions` VALUES (4245, 2201, 3, 'Hash actual');
INSERT INTO `lang_definitions` VALUES (4246, 2202, 3, 'Ubicación actual');
INSERT INTO `lang_definitions` VALUES (4247, 2204, 3, 'Medicamentos Actuales');
INSERT INTO `lang_definitions` VALUES (4248, 2205, 3, 'Contraseña Actual');
INSERT INTO `lang_definitions` VALUES (4249, 2206, 3, 'Paciente Actual');
INSERT INTO `lang_definitions` VALUES (4250, 2211, 3, 'Drogas no farmacológicas actuales');
INSERT INTO `lang_definitions` VALUES (4251, 2213, 3, 'Actualmente fumador ocasional');
INSERT INTO `lang_definitions` VALUES (4252, 2219, 3, 'Actualmente Activo');
INSERT INTO `lang_definitions` VALUES (4253, 2224, 3, 'Actualmente no hay clínicas');
INSERT INTO `lang_definitions` VALUES (4254, 2226, 3, 'Síndrome de Cushing');
INSERT INTO `lang_definitions` VALUES (4255, 2227, 3, 'Síndrome de Cushing');
INSERT INTO `lang_definitions` VALUES (4256, 2230, 3, 'Costumbre');
INSERT INTO `lang_definitions` VALUES (4257, 2237, 3, '¿Entrada cliente?');
INSERT INTO `lang_definitions` VALUES (4258, 2241, 3, 'Tabla Cliente');
INSERT INTO `lang_definitions` VALUES (4259, 2248, 3, 'Código CVX');
INSERT INTO `lang_definitions` VALUES (4260, 2249, 3, 'Mapa de Código CVX');
INSERT INTO `lang_definitions` VALUES (4261, 2250, 3, 'Vacunación CVX');
INSERT INTO `lang_definitions` VALUES (4262, 2252, 3, 'Ciclo');
INSERT INTO `lang_definitions` VALUES (4263, 2258, 3, 'CYP');
INSERT INTO `lang_definitions` VALUES (4264, 2259, 3, 'Factor de CYP');
INSERT INTO `lang_definitions` VALUES (4265, 2260, 3, 'Informe de CYP');
INSERT INTO `lang_definitions` VALUES (4266, 2261, 3, 'Checo');
INSERT INTO `lang_definitions` VALUES (4267, 2262, 3, 'D');
INSERT INTO `lang_definitions` VALUES (4268, 2263, 3, 'D&C');
INSERT INTO `lang_definitions` VALUES (4269, 2264, 3, 'D&E');
INSERT INTO `lang_definitions` VALUES (4270, 2266, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4271, 2267, 3, 'diariamente');
INSERT INTO `lang_definitions` VALUES (4272, 2268, 3, 'Registro Diario');
INSERT INTO `lang_definitions` VALUES (4273, 2271, 3, 'Danés');
INSERT INTO `lang_definitions` VALUES (4274, 2275, 3, 'Información parecida está ya en la base de datos, por favor cambie el código o la descripción');
INSERT INTO `lang_definitions` VALUES (4275, 2276, 3, 'Información parecida está ya en la base de datos, por favor cambie el nombre de la constante');
INSERT INTO `lang_definitions` VALUES (4276, 2277, 3, 'Datos Cols');
INSERT INTO `lang_definitions` VALUES (4277, 2280, 3, 'Error de datos');
INSERT INTO `lang_definitions` VALUES (4278, 2285, 3, 'Tipo de datos');
INSERT INTO `lang_definitions` VALUES (4279, 2286, 3, 'Base de datos');
INSERT INTO `lang_definitions` VALUES (4280, 2287, 3, 'Base de datos sin instalar');
INSERT INTO `lang_definitions` VALUES (4281, 2289, 3, 'Revisión bbdd');
INSERT INTO `lang_definitions` VALUES (4282, 2290, 3, 'Información de la base de datos');
INSERT INTO `lang_definitions` VALUES (4283, 2292, 3, 'Actualización de base de datos completa');
INSERT INTO `lang_definitions` VALUES (4284, 2293, 3, 'DataCols debe ser un número entre 1 y 999');
INSERT INTO `lang_definitions` VALUES (4285, 2294, 3, 'Fecha');
INSERT INTO `lang_definitions` VALUES (4286, 2295, 3, 'FECHA');
INSERT INTO `lang_definitions` VALUES (4287, 2298, 3, 'Fecha adminstrada');
INSERT INTO `lang_definitions` VALUES (4288, 2299, 3, 'Fecha y hora de coleccion de muestra');
INSERT INTO `lang_definitions` VALUES (4289, 2300, 3, 'Fecha y hora de esta observación');
INSERT INTO `lang_definitions` VALUES (4290, 2302, 3, 'Fecha y hora cuando la muestra fue colectada');
INSERT INTO `lang_definitions` VALUES (4291, 2303, 3, 'La fecha no puede ser mayor a la de hoy');
INSERT INTO `lang_definitions` VALUES (4292, 2304, 3, 'Fecha en que fueron provistos inicialmente los servicios anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4293, 2305, 3, 'Fecha Creacion');
INSERT INTO `lang_definitions` VALUES (4294, 2306, 3, 'Fecha Defunción');
INSERT INTO `lang_definitions` VALUES (4295, 2307, 3, 'Fecha destruída');
INSERT INTO `lang_definitions` VALUES (4296, 2308, 3, 'Formato visualización de fecha');
INSERT INTO `lang_definitions` VALUES (4297, 2309, 3, 'Formato fecha para última cita no es válido');
INSERT INTO `lang_definitions` VALUES (4298, 2310, 3, 'Formato fecha para inicio de cita no es válido');
INSERT INTO `lang_definitions` VALUES (4299, 2311, 3, 'Formato fecha en \'Próxima Cita\' no es válido');
INSERT INTO `lang_definitions` VALUES (4300, 2312, 3, 'Formato fecha en \'no visto desde\' no es válido');
INSERT INTO `lang_definitions` VALUES (4301, 2314, 3, 'Formato fecha en \'visto en\' no es válido');
INSERT INTO `lang_definitions` VALUES (4302, 2315, 3, 'Comunicados de fechas de vacunación entregados');
INSERT INTO `lang_definitions` VALUES (4303, 2316, 3, 'Falta fecha para código');
INSERT INTO `lang_definitions` VALUES (4304, 2317, 3, 'Criterio maestro de fecha');
INSERT INTO `lang_definitions` VALUES (4305, 2320, 3, 'Fecha ingreso en banco aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4306, 2321, 3, 'Fecha de factura');
INSERT INTO `lang_definitions` VALUES (4307, 2322, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4308, 2323, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4309, 2324, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4310, 2326, 3, 'Fecha de entrada');
INSERT INTO `lang_definitions` VALUES (4311, 2328, 3, 'Fecha de la lesión');
INSERT INTO `lang_definitions` VALUES (4312, 2332, 3, 'Fecha de pago aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4313, 2334, 3, 'Fecha de derivación');
INSERT INTO `lang_definitions` VALUES (4314, 2336, 3, 'Fecha de la respuesta');
INSERT INTO `lang_definitions` VALUES (4315, 2338, 3, 'Fecha De Servicio');
INSERT INTO `lang_definitions` VALUES (4316, 2340, 3, 'Fecha de servicio');
INSERT INTO `lang_definitions` VALUES (4317, 2341, 3, 'Fecha de servicio = hoy');
INSERT INTO `lang_definitions` VALUES (4318, 2343, 3, 'Fecha de servicio mm/dd/aaaa');
INSERT INTO `lang_definitions` VALUES (4319, 2344, 3, 'Fecha de Servicio:');
INSERT INTO `lang_definitions` VALUES (4320, 2345, 3, 'Fecha de firma');
INSERT INTO `lang_definitions` VALUES (4321, 2348, 3, 'Fecha de esta orden');
INSERT INTO `lang_definitions` VALUES (4322, 2349, 3, 'Fecha de este reporte');
INSERT INTO `lang_definitions` VALUES (4323, 2350, 3, 'Fecha de la Declaración de VIS');
INSERT INTO `lang_definitions` VALUES (4324, 2351, 3, 'Fecha en que se ordenó');
INSERT INTO `lang_definitions` VALUES (4325, 2354, 3, 'Seleccionador de fecha');
INSERT INTO `lang_definitions` VALUES (4326, 2355, 3, 'Fecha Envio');
INSERT INTO `lang_definitions` VALUES (4327, 2356, 3, 'Fecha del mensaje enviado');
INSERT INTO `lang_definitions` VALUES (4328, 2358, 3, 'La fecha no puede estar en blanco');
INSERT INTO `lang_definitions` VALUES (4329, 2361, 3, 'Fecha/Cita');
INSERT INTO `lang_definitions` VALUES (4330, 2362, 3, 'Fecha/Notas');
INSERT INTO `lang_definitions` VALUES (4331, 2363, 3, 'Fecha/Notas de Último');
INSERT INTO `lang_definitions` VALUES (4332, 2364, 3, 'Fecha/Hora');
INSERT INTO `lang_definitions` VALUES (4333, 2365, 3, 'Fecha:');
INSERT INTO `lang_definitions` VALUES (4334, 2367, 3, 'Registro mensaje fechado');
INSERT INTO `lang_definitions` VALUES (4335, 2370, 3, 'Día');
INSERT INTO `lang_definitions` VALUES (4336, 2371, 3, 'dia');
INSERT INTO `lang_definitions` VALUES (4337, 2374, 3, 'Vista de día');
INSERT INTO `lang_definitions` VALUES (4338, 2375, 3, 'Día(s)');
INSERT INTO `lang_definitions` VALUES (4339, 2376, 3, 'Día(s) L-V');
INSERT INTO `lang_definitions` VALUES (4340, 2377, 3, 'días');
INSERT INTO `lang_definitions` VALUES (4341, 2378, 3, 'Días');
INSERT INTO `lang_definitions` VALUES (4342, 2379, 3, 'días pasados');
INSERT INTO `lang_definitions` VALUES (4343, 2380, 3, 'Dïas y juegos perdidos');
INSERT INTO `lang_definitions` VALUES (4344, 2381, 3, 'Días Desde la Última Visita');
INSERT INTO `lang_definitions` VALUES (4345, 2382, 3, 'Dias faltados');
INSERT INTO `lang_definitions` VALUES (4346, 2385, 3, 'Días por columna');
INSERT INTO `lang_definitions` VALUES (4347, 2387, 3, 'Días/Col');
INSERT INTO `lang_definitions` VALUES (4348, 2388, 3, 'DB instalado');
INSERT INTO `lang_definitions` VALUES (4349, 2389, 3, 'DD/MM/AAAA');
INSERT INTO `lang_definitions` VALUES (4350, 2390, 3, 'Anonimato');
INSERT INTO `lang_definitions` VALUES (4351, 2391, 3, 'El proceso de anonimato está completo');
INSERT INTO `lang_definitions` VALUES (4352, 2392, 3, 'El proceso de anonimato está en proceso');
INSERT INTO `lang_definitions` VALUES (4353, 2393, 3, 'El proceso de anonimato ha iniciado y está corriendo en el fondo');
INSERT INTO `lang_definitions` VALUES (4354, 2394, 3, 'Los datos anónimos pueden no estar completos');
INSERT INTO `lang_definitions` VALUES (4355, 2395, 3, 'Los ficheros anónimos serán guardados en');
INSERT INTO `lang_definitions` VALUES (4356, 2396, 3, 'DEA');
INSERT INTO `lang_definitions` VALUES (4357, 2401, 3, 'Sordera');
INSERT INTO `lang_definitions` VALUES (4358, 2403, 3, 'Elimine errores de la información');
INSERT INTO `lang_definitions` VALUES (4359, 2406, 3, 'Dic');
INSERT INTO `lang_definitions` VALUES (4360, 2408, 3, 'DIFUNTO');
INSERT INTO `lang_definitions` VALUES (4361, 2415, 3, 'Diciembre');
INSERT INTO `lang_definitions` VALUES (4362, 2421, 3, 'Deducible');
INSERT INTO `lang_definitions` VALUES (4363, 2422, 3, 'Deducible alcanzado');
INSERT INTO `lang_definitions` VALUES (4364, 2424, 3, 'Por Defecto');
INSERT INTO `lang_definitions` VALUES (4365, 2426, 3, 'Vista Calendario por defecto');
INSERT INTO `lang_definitions` VALUES (4366, 2428, 3, 'Formulario ID para Visita por defecto');
INSERT INTO `lang_definitions` VALUES (4367, 2430, 3, 'Centro por defecto');
INSERT INTO `lang_definitions` VALUES (4368, 2435, 3, 'Idioma por defecto');
INSERT INTO `lang_definitions` VALUES (4369, 2436, 3, 'Idioma por defecto si no se permite otro, o bien elegir.');
INSERT INTO `lang_definitions` VALUES (4370, 2439, 3, 'Lista por defecto (escriba, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (4371, 2441, 3, 'Método por defecto');
INSERT INTO `lang_definitions` VALUES (4372, 2442, 3, 'Días Expiración Contraseña por Defecto');
INSERT INTO `lang_definitions` VALUES (4373, 2443, 3, 'El periodo de vencimiento de la contraseña por defecto es 0. Ésto significa que la función está desactivada');
INSERT INTO `lang_definitions` VALUES (4374, 2444, 3, 'País por defecto del Paciente');
INSERT INTO `lang_definitions` VALUES (4375, 2448, 3, 'Médico por defecto');
INSERT INTO `lang_definitions` VALUES (4376, 2450, 3, 'Rango por defecto');
INSERT INTO `lang_definitions` VALUES (4377, 2451, 3, 'Razón por defecto de la visita');
INSERT INTO `lang_definitions` VALUES (4378, 2456, 3, 'Configuración por defecto');
INSERT INTO `lang_definitions` VALUES (4379, 2457, 3, 'Estado de la casilla por defecto de nueva ventana en la lista de pacientes.');
INSERT INTO `lang_definitions` VALUES (4380, 2458, 3, 'Plantilla por defecto');
INSERT INTO `lang_definitions` VALUES (4381, 2464, 3, 'Unidades por defecto');
INSERT INTO `lang_definitions` VALUES (4382, 2466, 3, 'Valor por defecto');
INSERT INTO `lang_definitions` VALUES (4383, 2468, 3, 'Deposito por defecto');
INSERT INTO `lang_definitions` VALUES (4384, 2469, 3, 'Socio X12 por defecto');
INSERT INTO `lang_definitions` VALUES (4385, 2470, 3, 'Por defecto/Global');
INSERT INTO `lang_definitions` VALUES (4386, 2475, 3, 'Borrar');
INSERT INTO `lang_definitions` VALUES (4387, 2476, 3, 'borrar');
INSERT INTO `lang_definitions` VALUES (4388, 2477, 3, 'Repetición retrasada (> 12 Mo)');
INSERT INTO `lang_definitions` VALUES (4389, 2478, 3, 'Eliminar');
INSERT INTO `lang_definitions` VALUES (4390, 2479, 3, 'eliminar');
INSERT INTO `lang_definitions` VALUES (4391, 2480, 3, 'Eliminar Categorías con identificador(es) :');
INSERT INTO `lang_definitions` VALUES (4392, 2481, 3, 'Borrar Categoría');
INSERT INTO `lang_definitions` VALUES (4393, 2485, 3, 'Eliminar Grupo');
INSERT INTO `lang_definitions` VALUES (4394, 2486, 3, 'Eliminar Lista');
INSERT INTO `lang_definitions` VALUES (4395, 2488, 3, 'Eliminar Páginas');
INSERT INTO `lang_definitions` VALUES (4396, 2489, 3, 'Borrar Paciente, visita, formulario, Incidencia, Documento, Pago, facturación o Transacción');
INSERT INTO `lang_definitions` VALUES (4397, 2491, 3, 'Borrar fila');
INSERT INTO `lang_definitions` VALUES (4398, 2492, 3, 'Borrar ítems selectos');
INSERT INTO `lang_definitions` VALUES (4399, 2495, 3, 'Eliminar éxito.');
INSERT INTO `lang_definitions` VALUES (4400, 2496, 3, 'Eliminar este documento');
INSERT INTO `lang_definitions` VALUES (4401, 2497, 3, 'Eliminar este formulario');
INSERT INTO `lang_definitions` VALUES (4402, 2499, 3, 'Eliminar esta nota');
INSERT INTO `lang_definitions` VALUES (4403, 2501, 3, 'Borrado Completado');
INSERT INTO `lang_definitions` VALUES (4404, 2503, 3, 'No se puede deshacer la eliminación de este evento. No se puede recuperar una vez que se ha hecho. ¿Está seguro que desea eliminar este evento?');
INSERT INTO `lang_definitions` VALUES (4405, 2511, 3, 'Demencia');
INSERT INTO `lang_definitions` VALUES (4406, 2513, 3, 'Datos demográficos');
INSERT INTO `lang_definitions` VALUES (4407, 2514, 3, 'Demografía (escribir, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (4408, 2518, 3, 'Criterio de Filtro Demográficos');
INSERT INTO `lang_definitions` VALUES (4409, 2520, 3, 'Datos demográficos no autorizados');
INSERT INTO `lang_definitions` VALUES (4410, 2521, 3, 'Datos demográficos no autorizados');
INSERT INTO `lang_definitions` VALUES (4411, 2522, 3, 'Denegado');
INSERT INTO `lang_definitions` VALUES (4412, 2524, 3, 'Denominador');
INSERT INTO `lang_definitions` VALUES (4413, 2527, 3, 'Dental');
INSERT INTO `lang_definitions` VALUES (4414, 2529, 3, 'Incidencias Dentales');
INSERT INTO `lang_definitions` VALUES (4415, 2534, 3, 'Dependiendo del tipo de cuenta que usted prueba, usted verá salida tipo HCFA en una página en blanco para las cuentas de HCFA, o usted verá muchas líneas de texto e información alteradas, si usted está probando una demanda X12. Ese texto mutilado es el formato del X12 IED 4010A. Usted verá de vez en cuando los caracteres extraños que parecen dominós o basura, se trata de caracteres de control tales como alimentaciones de página y son normales.');
INSERT INTO `lang_definitions` VALUES (4416, 2536, 3, 'Fecha de depósito');
INSERT INTO `lang_definitions` VALUES (4417, 2537, 3, 'La fecha del deposiito no puede ser mayor a la de hoy');
INSERT INTO `lang_definitions` VALUES (4418, 2538, 3, 'Fecha del depósito');
INSERT INTO `lang_definitions` VALUES (4419, 2539, 3, 'Depresivo');
INSERT INTO `lang_definitions` VALUES (4420, 2540, 3, 'Depresión');
INSERT INTO `lang_definitions` VALUES (4421, 2546, 3, 'Descripción');
INSERT INTO `lang_definitions` VALUES (4422, 2547, 3, 'descripción');
INSERT INTO `lang_definitions` VALUES (4423, 2549, 3, 'Descripción de la publicación');
INSERT INTO `lang_definitions` VALUES (4424, 2550, 3, 'Desceripcion de este procedimiento o codigo resultante');
INSERT INTO `lang_definitions` VALUES (4425, 2551, 3, 'Traducción de la descripción');
INSERT INTO `lang_definitions` VALUES (4426, 2553, 3, 'Destino');
INSERT INTO `lang_definitions` VALUES (4427, 2554, 3, 'Nombre del fichero destino');
INSERT INTO `lang_definitions` VALUES (4428, 2555, 3, 'Destruir todo el lote');
INSERT INTO `lang_definitions` VALUES (4429, 2556, 3, 'Destruido ...');
INSERT INTO `lang_definitions` VALUES (4430, 2557, 3, 'Destruido');
INSERT INTO `lang_definitions` VALUES (4431, 2558, 3, 'Drogas destruidas');
INSERT INTO `lang_definitions` VALUES (4432, 2559, 3, 'Informe drogas destruidas');
INSERT INTO `lang_definitions` VALUES (4433, 2560, 3, 'Detalle');
INSERT INTO `lang_definitions` VALUES (4434, 2565, 3, 'Detalles');
INSERT INTO `lang_definitions` VALUES (4435, 2567, 3, 'Anormalidad del desarrollo');
INSERT INTO `lang_definitions` VALUES (4436, 2569, 3, 'Diabetes');
INSERT INTO `lang_definitions` VALUES (4437, 2570, 3, 'Diabetes Mellitus');
INSERT INTO `lang_definitions` VALUES (4438, 2571, 3, 'Diabetes: Gestión presión arterial (GCC)');
INSERT INTO `lang_definitions` VALUES (4439, 2572, 3, 'Diabetes:Examen Ocular');
INSERT INTO `lang_definitions` VALUES (4440, 2573, 3, 'Diabetes: Examen ocular (GCC)');
INSERT INTO `lang_definitions` VALUES (4441, 2574, 3, 'Diabetes: Examen de los pies');
INSERT INTO `lang_definitions` VALUES (4442, 2575, 3, 'Diabetes: Examen de los pies (GCC)');
INSERT INTO `lang_definitions` VALUES (4443, 2576, 3, 'Diabetes:Control HbA1c Deficiente (GCC)');
INSERT INTO `lang_definitions` VALUES (4444, 2577, 3, 'Diabetes: Hemoglobina A1C');
INSERT INTO `lang_definitions` VALUES (4445, 2578, 3, 'Diabetes: Gestión LDL y Control (GCC)');
INSERT INTO `lang_definitions` VALUES (4446, 2579, 3, 'Diabetes: Microalbúmina de la orina');
INSERT INTO `lang_definitions` VALUES (4447, 2580, 3, 'Diag');
INSERT INTO `lang_definitions` VALUES (4448, 2581, 3, 'Diagnósticos');
INSERT INTO `lang_definitions` VALUES (4449, 2582, 3, 'Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4450, 2583, 3, 'Cód. Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4451, 2584, 3, 'Códigos diagnósticos');
INSERT INTO `lang_definitions` VALUES (4452, 2585, 3, 'Fecha de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4453, 2587, 3, 'El diagnóstico debe ser codificado en una visita vinculada');
INSERT INTO `lang_definitions` VALUES (4454, 2588, 3, 'Nombre del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4455, 2589, 3, 'Reporte del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4456, 2590, 3, 'Informe de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4457, 2591, 3, 'Informe sólo de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4458, 2592, 3, 'Título del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4459, 2593, 3, 'Diagnóstico:');
INSERT INTO `lang_definitions` VALUES (4460, 2594, 3, 'Diagnóstico:');
INSERT INTO `lang_definitions` VALUES (4461, 2595, 3, 'Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4462, 2596, 3, 'Pruebas diagnósticas:');
INSERT INTO `lang_definitions` VALUES (4463, 2597, 3, 'Diales');
INSERT INTO `lang_definitions` VALUES (4464, 2600, 3, 'Diafragmas/Capuchón cervical');
INSERT INTO `lang_definitions` VALUES (4465, 2601, 3, 'Diarrea');
INSERT INTO `lang_definitions` VALUES (4466, 2602, 3, 'Diastólico');
INSERT INTO `lang_definitions` VALUES (4467, 2603, 3, 'Dictado');
INSERT INTO `lang_definitions` VALUES (4468, 2604, 3, 'Dictado:');
INSERT INTO `lang_definitions` VALUES (4469, 2605, 3, '¿Usted recibió una copia del aviso de HIPAA?');
INSERT INTO `lang_definitions` VALUES (4470, 2606, 3, 'Difuso:');
INSERT INTO `lang_definitions` VALUES (4471, 2607, 3, 'Firmado digitalmente');
INSERT INTO `lang_definitions` VALUES (4472, 2608, 3, 'Dilatado con');
INSERT INTO `lang_definitions` VALUES (4473, 2611, 3, 'Directo');
INSERT INTO `lang_definitions` VALUES (4474, 2612, 3, 'Dirección Directa');
INSERT INTO `lang_definitions` VALUES (4475, 2613, 3, 'Dirección Directa');
INSERT INTO `lang_definitions` VALUES (4476, 2614, 3, 'Mail directo');
INSERT INTO `lang_definitions` VALUES (4477, 2615, 3, 'Correo Directo');
INSERT INTO `lang_definitions` VALUES (4478, 2616, 3, 'Registro Mens. Directo');
INSERT INTO `lang_definitions` VALUES (4479, 2617, 3, 'Mens.Directo recibido');
INSERT INTO `lang_definitions` VALUES (4480, 2618, 3, 'Mensaje directo no disponible ahora');
INSERT INTO `lang_definitions` VALUES (4481, 2619, 3, 'Falla de envío de mensaje directo');
INSERT INTO `lang_definitions` VALUES (4482, 2620, 3, 'Directivas');
INSERT INTO `lang_definitions` VALUES (4483, 2621, 3, 'Nombre del director');
INSERT INTO `lang_definitions` VALUES (4484, 2623, 3, 'inhabilitación');
INSERT INTO `lang_definitions` VALUES (4485, 2628, 3, 'Deshabilitar calendario');
INSERT INTO `lang_definitions` VALUES (4486, 2629, 3, 'Deshabilitar Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (4487, 2631, 3, 'Deshabilitar vacunaciones');
INSERT INTO `lang_definitions` VALUES (4488, 2633, 3, 'Deshabilitar vieja forma métrica de constantes vitales');
INSERT INTO `lang_definitions` VALUES (4489, 2635, 3, 'Deshabilitar phpMyAdmin');
INSERT INTO `lang_definitions` VALUES (4490, 2636, 3, 'Deshabilitar prescriciones');
INSERT INTO `lang_definitions` VALUES (4491, 2637, 3, 'Deshabilitar grupos de usuarios');
INSERT INTO `lang_definitions` VALUES (4492, 2638, 3, 'inhabilitado');
INSERT INTO `lang_definitions` VALUES (4493, 2639, 3, 'inhabilitado');
INSERT INTO `lang_definitions` VALUES (4494, 2640, 3, 'Beneficiario discapacitado menor de 65 años con un Plan de salud para grandes grupos (LGHP)');
INSERT INTO `lang_definitions` VALUES (4495, 2644, 3, 'DISCO');
INSERT INTO `lang_definitions` VALUES (4496, 2647, 3, 'Descarga');
INSERT INTO `lang_definitions` VALUES (4497, 2648, 3, 'Pérdidas/secreciones de la uretra');
INSERT INTO `lang_definitions` VALUES (4498, 2650, 3, 'Derecho de alta');
INSERT INTO `lang_definitions` VALUES (4499, 2651, 3, 'Derecho de alta:');
INSERT INTO `lang_definitions` VALUES (4500, 2656, 3, 'Informacion de publicación');
INSERT INTO `lang_definitions` VALUES (4501, 2657, 3, 'Tipo de publicación');
INSERT INTO `lang_definitions` VALUES (4502, 2658, 3, 'Tipos de publicación');
INSERT INTO `lang_definitions` VALUES (4503, 2659, 3, 'Publicaciones');
INSERT INTO `lang_definitions` VALUES (4504, 2663, 3, 'Suspender');
INSERT INTO `lang_definitions` VALUES (4505, 2664, 3, 'Descuento');
INSERT INTO `lang_definitions` VALUES (4506, 2665, 3, 'Suma de descuento');
INSERT INTO `lang_definitions` VALUES (4507, 2666, 3, 'Nivel del Descuento');
INSERT INTO `lang_definitions` VALUES (4508, 2667, 3, 'Porcentaje de descuento');
INSERT INTO `lang_definitions` VALUES (4509, 2668, 3, 'Descuentos como importes monetarios');
INSERT INTO `lang_definitions` VALUES (4510, 2669, 3, 'Descuentos a la hora de salida se introducen como cantidades de dinero, a diferencia de porcentaje.');
INSERT INTO `lang_definitions` VALUES (4511, 2670, 3, 'Resultado discreto');
INSERT INTO `lang_definitions` VALUES (4512, 2672, 3, 'Enfermedad');
INSERT INTO `lang_definitions` VALUES (4513, 2674, 3, 'Dislocación');
INSERT INTO `lang_definitions` VALUES (4514, 2677, 3, '# Disp');
INSERT INTO `lang_definitions` VALUES (4515, 2678, 3, 'Informe');
INSERT INTO `lang_definitions` VALUES (4516, 2679, 3, 'Remitir documento recibido');
INSERT INTO `lang_definitions` VALUES (4517, 2683, 3, 'Prescrito');
INSERT INTO `lang_definitions` VALUES (4518, 2686, 3, 'Mostrar las directivas anticipadas en la página de la demografía.');
INSERT INTO `lang_definitions` VALUES (4519, 2689, 3, '¿Mostrar fechas de eventos en bloque?');
INSERT INTO `lang_definitions` VALUES (4520, 2691, 3, '¿Mostrar cuántos eventos?');
INSERT INTO `lang_definitions` VALUES (4521, 2694, 3, '¿Mostrar lugar/sitio en bloque?');
INSERT INTO `lang_definitions` VALUES (4522, 2695, 3, 'Nombre Pantalla');
INSERT INTO `lang_definitions` VALUES (4523, 2697, 3, '¿Mostrar el calendario?');
INSERT INTO `lang_definitions` VALUES (4524, 2704, 3, '¿Mostrar los eventos de hoy en el bloque?');
INSERT INTO `lang_definitions` VALUES (4525, 2705, 3, '¿Mostrar tema en el bloque?');
INSERT INTO `lang_definitions` VALUES (4526, 2706, 3, '¿Mostrar los eventos próximos en tabla?');
INSERT INTO `lang_definitions` VALUES (4527, 2708, 3, 'Mostrar columnas');
INSERT INTO `lang_definitions` VALUES (4528, 2709, 3, 'Viendo el siguiente número de las publicaciones más recientes:');
INSERT INTO `lang_definitions` VALUES (4529, 2711, 3, 'Mostrando el siguiente número de las notas más recientes');
INSERT INTO `lang_definitions` VALUES (4530, 2712, 3, 'Mostrando el siguiente número de las notas más recientes:');
INSERT INTO `lang_definitions` VALUES (4531, 2717, 3, 'Distribución');
INSERT INTO `lang_definitions` VALUES (4532, 2718, 3, 'Distribuciones');
INSERT INTO `lang_definitions` VALUES (4533, 2719, 3, 'Distribuidor');
INSERT INTO `lang_definitions` VALUES (4534, 2724, 3, 'Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4535, 2725, 3, 'Operación de Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4536, 2726, 3, 'Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4537, 2727, 3, 'Operación de Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4538, 2728, 3, 'Divorciado');
INSERT INTO `lang_definitions` VALUES (4539, 2729, 3, 'Mareo:');
INSERT INTO `lang_definitions` VALUES (4540, 2732, 3, 'No cambiar');
INSERT INTO `lang_definitions` VALUES (4541, 2734, 3, 'No mostrar alergia subida a NewCrop');
INSERT INTO `lang_definitions` VALUES (4542, 2736, 3, 'No mostrar medicación subida a NewCrop');
INSERT INTO `lang_definitions` VALUES (4543, 2739, 3, 'No mostrar el calendario');
INSERT INTO `lang_definitions` VALUES (4544, 2743, 3, 'No inventariar ni vender nigun producto');
INSERT INTO `lang_definitions` VALUES (4545, 2746, 3, 'No requiere notas del paciente para ser autorizado');
INSERT INTO `lang_definitions` VALUES (4546, 2747, 3, 'Orden de No Resucitar');
INSERT INTO `lang_definitions` VALUES (4547, 2748, 3, 'no guardar');
INSERT INTO `lang_definitions` VALUES (4548, 2749, 3, 'no sustituir');
INSERT INTO `lang_definitions` VALUES (4549, 2751, 3, 'no actuar');
INSERT INTO `lang_definitions` VALUES (4550, 2754, 3, 'De verdad quiere suprimir?');
INSERT INTO `lang_definitions` VALUES (4551, 2755, 3, '¿Verdaderamente desea borrar la selección?');
INSERT INTO `lang_definitions` VALUES (4552, 2756, 3, 'Está seguro que quiere eliminar este grupo');
INSERT INTO `lang_definitions` VALUES (4553, 2758, 3, '¿Quiere continuar?');
INSERT INTO `lang_definitions` VALUES (4554, 2759, 3, '¿Quiere borrar esto?');
INSERT INTO `lang_definitions` VALUES (4555, 2760, 3, '¿Quiere borrar?');
INSERT INTO `lang_definitions` VALUES (4556, 2761, 3, '¿Desea remover este registro?');
INSERT INTO `lang_definitions` VALUES (4557, 2762, 3, '¿Desea continuar añadiendo este nuevo paciente?');
INSERT INTO `lang_definitions` VALUES (4558, 2763, 3, '¿Usted desea continuar con el nuevo nombre?');
INSERT INTO `lang_definitions` VALUES (4559, 2764, 3, '¿Usted desea suprimir DEFINITIVAMENTE este registro de vacunación?');
INSERT INTO `lang_definitions` VALUES (4560, 2765, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4561, 2766, 3, 'Falta F.Nacimiento, por favor insertarla si es posible');
INSERT INTO `lang_definitions` VALUES (4562, 2768, 3, 'Documentos');
INSERT INTO `lang_definitions` VALUES (4563, 2769, 3, 'Médico');
INSERT INTO `lang_definitions` VALUES (4564, 2770, 3, 'Médico:');
INSERT INTO `lang_definitions` VALUES (4565, 2771, 3, 'Nombre del médico y firma');
INSERT INTO `lang_definitions` VALUES (4566, 2772, 3, 'Documento');
INSERT INTO `lang_definitions` VALUES (4567, 2773, 3, 'documento');
INSERT INTO `lang_definitions` VALUES (4568, 2775, 3, 'Categorías documento');
INSERT INTO `lang_definitions` VALUES (4569, 2781, 3, 'El documento no ha podido ser trasladado al Nº Identificación del paciente');
INSERT INTO `lang_definitions` VALUES (4570, 2783, 3, 'Fecha de documento');
INSERT INTO `lang_definitions` VALUES (4571, 2784, 3, 'Fecha del documento e incidencia actualizadas con éxito');
INSERT INTO `lang_definitions` VALUES (4572, 2785, 3, 'Nº Identificación de Documento');
INSERT INTO `lang_definitions` VALUES (4573, 2788, 3, 'Documento se trasladó a nueva categoría');
INSERT INTO `lang_definitions` VALUES (4574, 2789, 3, 'Documento se trasladó al Nº Identificación del paciente');
INSERT INTO `lang_definitions` VALUES (4575, 2791, 3, 'Documento aprobó la comprobación de integridad');
INSERT INTO `lang_definitions` VALUES (4576, 2792, 3, 'Método de archivo de documentos');
INSERT INTO `lang_definitions` VALUES (4577, 2793, 3, 'Documento renombrado con éxito');
INSERT INTO `lang_definitions` VALUES (4578, 2799, 3, 'Depósito de documentos/Imágenes');
INSERT INTO `lang_definitions` VALUES (4579, 2801, 3, 'Documentos');
INSERT INTO `lang_definitions` VALUES (4580, 2803, 3, 'Documentos (escribir, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (4581, 2811, 3, 'DOE');
INSERT INTO `lang_definitions` VALUES (4582, 2818, 3, '¿Este tipo permite codigos relacionados?');
INSERT INTO `lang_definitions` VALUES (4583, 2819, 3, 'Socio doméstico');
INSERT INTO `lang_definitions` VALUES (4584, 2820, 3, 'No Guardar');
INSERT INTO `lang_definitions` VALUES (4585, 2821, 3, 'No Guardar');
INSERT INTO `lang_definitions` VALUES (4586, 2822, 3, 'No Guardar Cambios');
INSERT INTO `lang_definitions` VALUES (4587, 2824, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (4588, 2826, 3, 'Hecho con:');
INSERT INTO `lang_definitions` VALUES (4589, 2827, 3, 'Terminado. Ahora se enviará la descarga');
INSERT INTO `lang_definitions` VALUES (4590, 2828, 3, 'DOS');
INSERT INTO `lang_definitions` VALUES (4591, 2829, 3, 'Dosis');
INSERT INTO `lang_definitions` VALUES (4592, 2833, 3, 'Doble click para editar');
INSERT INTO `lang_definitions` VALUES (4593, 2835, 3, 'Visión doble');
INSERT INTO `lang_definitions` VALUES (4594, 2836, 3, 'Descarga');
INSERT INTO `lang_definitions` VALUES (4595, 2841, 3, 'Descargar de todas formas');
INSERT INTO `lang_definitions` VALUES (4596, 2842, 3, 'Descargar expediente de factura, mandar a contabilidad y marcar como facturado.');
INSERT INTO `lang_definitions` VALUES (4597, 2844, 3, 'Certificados de descargas');
INSERT INTO `lang_definitions` VALUES (4598, 2845, 3, 'Descargar datos de configuración');
INSERT INTO `lang_definitions` VALUES (4599, 2849, 3, 'Descargar fichero encriptado');
INSERT INTO `lang_definitions` VALUES (4600, 2850, 3, 'Descargar FAX');
INSERT INTO `lang_definitions` VALUES (4601, 2854, 3, 'Descargar o Borrar una plantilla');
INSERT INTO `lang_definitions` VALUES (4602, 2855, 3, 'Descargar PDF');
INSERT INTO `lang_definitions` VALUES (4603, 2858, 3, 'Descargar seleccionados');
INSERT INTO `lang_definitions` VALUES (4604, 2860, 3, 'Revisar médico');
INSERT INTO `lang_definitions` VALUES (4605, 2861, 3, 'Visitar médico');
INSERT INTO `lang_definitions` VALUES (4606, 2862, 3, 'Dr.');
INSERT INTO `lang_definitions` VALUES (4607, 2866, 3, 'Arrastre para mover');
INSERT INTO `lang_definitions` VALUES (4608, 2868, 3, 'Goteo');
INSERT INTO `lang_definitions` VALUES (4609, 2869, 3, 'Permiso de conducir o D.N.I.');
INSERT INTO `lang_definitions` VALUES (4610, 2871, 3, 'Medicamento');
INSERT INTO `lang_definitions` VALUES (4611, 2874, 3, 'Buscador de medicamentos');
INSERT INTO `lang_definitions` VALUES (4612, 2875, 3, 'Formularios de Medicamento');
INSERT INTO `lang_definitions` VALUES (4613, 2876, 3, 'Nº Identificación medicamento falta!');
INSERT INTO `lang_definitions` VALUES (4614, 2877, 3, 'Intervalos de Medicamento');
INSERT INTO `lang_definitions` VALUES (4615, 2878, 3, 'Inventario de Medicamentos');
INSERT INTO `lang_definitions` VALUES (4616, 2880, 3, 'Nombre del Medicamento');
INSERT INTO `lang_definitions` VALUES (4617, 2881, 3, 'Vía de administración del Medicamento');
INSERT INTO `lang_definitions` VALUES (4618, 2886, 3, 'Unidades de Medicamento');
INSERT INTO `lang_definitions` VALUES (4619, 2892, 3, 'Medicamentos');
INSERT INTO `lang_definitions` VALUES (4620, 2893, 3, 'Medicamentos y productos');
INSERT INTO `lang_definitions` VALUES (4621, 2894, 3, 'Boca seca');
INSERT INTO `lang_definitions` VALUES (4622, 2895, 3, 'Diagnóstico DSMIV');
INSERT INTO `lang_definitions` VALUES (4623, 2896, 3, 'DT 1');
INSERT INTO `lang_definitions` VALUES (4624, 2897, 3, 'DT 2');
INSERT INTO `lang_definitions` VALUES (4625, 2898, 3, 'DT 3');
INSERT INTO `lang_definitions` VALUES (4626, 2899, 3, 'DT 4');
INSERT INTO `lang_definitions` VALUES (4627, 2900, 3, 'DT 5');
INSERT INTO `lang_definitions` VALUES (4628, 2901, 3, 'DTaP 1');
INSERT INTO `lang_definitions` VALUES (4629, 2902, 3, 'DTaP 2');
INSERT INTO `lang_definitions` VALUES (4630, 2903, 3, 'DTaP 3');
INSERT INTO `lang_definitions` VALUES (4631, 2904, 3, 'DTaP 4');
INSERT INTO `lang_definitions` VALUES (4632, 2905, 3, 'DTaP 5');
INSERT INTO `lang_definitions` VALUES (4633, 2906, 3, 'Adeudado');
INSERT INTO `lang_definitions` VALUES (4634, 2907, 3, 'Fecha del parto');
INSERT INTO `lang_definitions` VALUES (4635, 2909, 3, 'Fecha del parto mm/dd/aaaa o aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4636, 2910, 3, 'Fecha del parto:');
INSERT INTO `lang_definitions` VALUES (4637, 2911, 3, 'Deuda Seguro');
INSERT INTO `lang_definitions` VALUES (4638, 2912, 3, 'Deuda Paciente');
INSERT INTO `lang_definitions` VALUES (4639, 2913, 3, 'Deuda próxima');
INSERT INTO `lang_definitions` VALUES (4640, 2914, 3, 'Estado de Deuda');
INSERT INTO `lang_definitions` VALUES (4641, 2915, 3, 'Actualización Estado de Deuda');
INSERT INTO `lang_definitions` VALUES (4642, 2916, 3, 'Volcar OpenEMR base de datos');
INSERT INTO `lang_definitions` VALUES (4643, 2917, 3, 'Volcar OpenEMR web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4644, 2918, 3, 'Volcar phpGACL base de datos');
INSERT INTO `lang_definitions` VALUES (4645, 2919, 3, 'volcar phpGACL web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4646, 2920, 3, 'Volcar SQL-Ledger base de datos');
INSERT INTO `lang_definitions` VALUES (4647, 2921, 3, 'Volcar phpGACL web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4648, 2922, 3, 'Compruebe duplicado');
INSERT INTO `lang_definitions` VALUES (4649, 2926, 3, 'ID duplicado en linea');
INSERT INTO `lang_definitions` VALUES (4650, 2927, 3, 'Nombre duplicado en linea');
INSERT INTO `lang_definitions` VALUES (4651, 2928, 3, 'AVISO DE DUPLICACION');
INSERT INTO `lang_definitions` VALUES (4652, 2929, 3, 'Poder Legal Duradero');
INSERT INTO `lang_definitions` VALUES (4653, 2930, 3, 'Duración');
INSERT INTO `lang_definitions` VALUES (4654, 2931, 3, 'duración');
INSERT INTO `lang_definitions` VALUES (4655, 2932, 3, 'Holandés');
INSERT INTO `lang_definitions` VALUES (4656, 2934, 3, 'Dx Rep');
INSERT INTO `lang_definitions` VALUES (4657, 2935, 3, 'Disfagia');
INSERT INTO `lang_definitions` VALUES (4658, 2936, 3, 'Disnea');
INSERT INTO `lang_definitions` VALUES (4659, 2937, 3, 'Disuria');
INSERT INTO `lang_definitions` VALUES (4660, 2940, 3, 'E-Mail');
INSERT INTO `lang_definitions` VALUES (4661, 2941, 3, 'E-mail');
INSERT INTO `lang_definitions` VALUES (4662, 2946, 3, '¿E-Receta?');
INSERT INTO `lang_definitions` VALUES (4663, 2948, 3, 'Receta Electrónica');
INSERT INTO `lang_definitions` VALUES (4664, 2950, 3, 'Renovación Receta Electrónica');
INSERT INTO `lang_definitions` VALUES (4665, 2953, 3, 'Cada destinatario debe establecer sus propios mensajes como terminados.');
INSERT INTO `lang_definitions` VALUES (4666, 2958, 3, 'Repetición Temprana (<2 Mo)');
INSERT INTO `lang_definitions` VALUES (4667, 2959, 3, 'Orejas');
INSERT INTO `lang_definitions` VALUES (4668, 2963, 3, 'Electrocardiograma');
INSERT INTO `lang_definitions` VALUES (4669, 2964, 3, 'Reclamaciones electrónicas');
INSERT INTO `lang_definitions` VALUES (4670, 2967, 3, 'Edema');
INSERT INTO `lang_definitions` VALUES (4671, 2972, 3, 'Adjuntar fichero EDI-271');
INSERT INTO `lang_definitions` VALUES (4672, 2973, 3, 'Respuesta de carga de fichero EDI-271');
INSERT INTO `lang_definitions` VALUES (4673, 2974, 3, 'Editar');
INSERT INTO `lang_definitions` VALUES (4674, 2975, 3, 'editar');
INSERT INTO `lang_definitions` VALUES (4675, 2976, 3, 'Editar alergias');
INSERT INTO `lang_definitions` VALUES (4676, 2978, 3, 'Editar categorías');
INSERT INTO `lang_definitions` VALUES (4677, 2980, 3, 'Editar Definiciones');
INSERT INTO `lang_definitions` VALUES (4678, 2981, 3, 'Editar definiciones');
INSERT INTO `lang_definitions` VALUES (4679, 2982, 3, 'Editar diagnóstico para');
INSERT INTO `lang_definitions` VALUES (4680, 2983, 3, 'editar publicación');
INSERT INTO `lang_definitions` VALUES (4681, 2988, 3, 'Editar Clínicas');
INSERT INTO `lang_definitions` VALUES (4682, 2989, 3, 'Editar Centro');
INSERT INTO `lang_definitions` VALUES (4683, 2990, 3, 'Editar información del Centro');
INSERT INTO `lang_definitions` VALUES (4684, 2991, 3, 'Editar información de instalación de usuario específico');
INSERT INTO `lang_definitions` VALUES (4685, 2992, 3, 'editar fichero en');
INSERT INTO `lang_definitions` VALUES (4686, 2993, 3, 'Editar forma');
INSERT INTO `lang_definitions` VALUES (4687, 2994, 3, 'Editar configuración global');
INSERT INTO `lang_definitions` VALUES (4688, 2996, 3, 'Edición no permitida');
INSERT INTO `lang_definitions` VALUES (4689, 2998, 3, 'Editar el diseño');
INSERT INTO `lang_definitions` VALUES (4690, 3000, 3, 'Editar la lista');
INSERT INTO `lang_definitions` VALUES (4691, 3003, 3, 'Editar Pago');
INSERT INTO `lang_definitions` VALUES (4692, 3004, 3, 'Editar estructura');
INSERT INTO `lang_definitions` VALUES (4693, 3007, 3, 'Editar usuario');
INSERT INTO `lang_definitions` VALUES (4694, 3008, 3, 'Editar configuración de usuario');
INSERT INTO `lang_definitions` VALUES (4695, 3009, 3, 'Editar su información');
INSERT INTO `lang_definitions` VALUES (4696, 3010, 3, 'La edición falló');
INSERT INTO `lang_definitions` VALUES (4697, 3011, 3, 'Educación');
INSERT INTO `lang_definitions` VALUES (4698, 3012, 3, 'Fecha educación');
INSERT INTO `lang_definitions` VALUES (4699, 3014, 3, 'Debería haber recibido una copia del GNU con este programa, si no, escriba al Free');
INSERT INTO `lang_definitions` VALUES (4700, 3015, 3, 'Fecha efectiva');
INSERT INTO `lang_definitions` VALUES (4701, 3017, 3, 'Efectividad');
INSERT INTO `lang_definitions` VALUES (4702, 3019, 3, 'EIN');
INSERT INTO `lang_definitions` VALUES (4703, 3022, 3, 'Eyaculaciones');
INSERT INTO `lang_definitions` VALUES (4704, 3023, 3, 'Codo');
INSERT INTO `lang_definitions` VALUES (4705, 3024, 3, 'Problemas del codo');
INSERT INTO `lang_definitions` VALUES (4706, 3025, 3, 'Electrónico');
INSERT INTO `lang_definitions` VALUES (4707, 3029, 3, 'Mandatos Electronicos');
INSERT INTO `lang_definitions` VALUES (4708, 3033, 3, 'Elegibilidad');
INSERT INTO `lang_definitions` VALUES (4709, 3034, 3, 'Elegibilidad Batch Consulta 270');
INSERT INTO `lang_definitions` VALUES (4710, 3035, 3, 'Elegibilidad de Respuesta');
INSERT INTO `lang_definitions` VALUES (4711, 3037, 3, 'Estado de elegibilidad para la vacuna suministrada para niños');
INSERT INTO `lang_definitions` VALUES (4712, 3038, 3, 'Elegible');
INSERT INTO `lang_definitions` VALUES (4713, 3040, 3, 'email');
INSERT INTO `lang_definitions` VALUES (4714, 3043, 3, 'email');
INSERT INTO `lang_definitions` VALUES (4715, 3045, 3, 'email del remitente para los recordatorios de pacientes. Las respuestas de los pacientes irán a esa dirección. Es importante usar una dirección del dominio de la Clínica para evitar que las respuestas de recordatorios de los pacientes vayan a la carpeta de correo basura.');
INSERT INTO `lang_definitions` VALUES (4716, 3046, 3, 'email, si hay, para recibir notificaciones administrativas.');
INSERT INTO `lang_definitions` VALUES (4717, 3047, 3, 'email, si hay, para recibir mensajes de activación de inicio sesión de usuario.');
INSERT INTO `lang_definitions` VALUES (4718, 3048, 3, 'Autenticación email');
INSERT INTO `lang_definitions` VALUES (4719, 3051, 3, 'email de Batchcom');
INSERT INTO `lang_definitions` VALUES (4720, 3052, 3, 'Notificación email');
INSERT INTO `lang_definitions` VALUES (4721, 3053, 3, 'Horario Notificación Email');
INSERT INTO `lang_definitions` VALUES (4722, 3054, 3, 'Informe de notificación de email');
INSERT INTO `lang_definitions` VALUES (4723, 3057, 3, 'email enviado antes');
INSERT INTO `lang_definitions` VALUES (4724, 3058, 3, 'Remitente de email');
INSERT INTO `lang_definitions` VALUES (4725, 3059, 3, 'Email enviado');
INSERT INTO `lang_definitions` VALUES (4726, 3060, 3, 'email enviado a');
INSERT INTO `lang_definitions` VALUES (4727, 3061, 3, 'Asunto del email');
INSERT INTO `lang_definitions` VALUES (4728, 3063, 3, 'Texto del email, etiqueta útil: ***NAME***, Ej. Estimado ***NAME***');
INSERT INTO `lang_definitions` VALUES (4729, 3064, 3, 'Texto email, etiqueta útil:***NAME***, por ej. Querido ***NAME***{{No traducir el elemento ***NAME*** de esta constante}}');
INSERT INTO `lang_definitions` VALUES (4730, 3065, 3, 'Método de envío de email');
INSERT INTO `lang_definitions` VALUES (4731, 3066, 3, 'Email enviado a las siguientes direcciones');
INSERT INTO `lang_definitions` VALUES (4732, 3070, 3, 'Contacto en caso de emergencia');
INSERT INTO `lang_definitions` VALUES (4733, 3071, 3, 'Persona de Contacto de Emergencia');
INSERT INTO `lang_definitions` VALUES (4734, 3072, 3, 'Teléfono de Contacto de Emergencias');
INSERT INTO `lang_definitions` VALUES (4735, 3073, 3, 'Emergencia anticonceptiva');
INSERT INTO `lang_definitions` VALUES (4736, 3074, 3, 'Acceso de Emergencia');
INSERT INTO `lang_definitions` VALUES (4737, 3075, 3, 'Inicio sesión de Emergencia ACL elegido. El usuario esta aún activo, favor desactivar usuario y activarlo cuando la situación de emergencia lo requiera. Visitar Administración>Usuario para activación o deactivación');
INSERT INTO `lang_definitions` VALUES (4738, 3076, 3, 'El email de activación de inicio de sesión de emergencia ha de circular sólo si los siguientes ajustes del fichero interfase/globals.php están configurados:');
INSERT INTO `lang_definitions` VALUES (4739, 3077, 3, 'email de inicio de sesión de emergencia');
INSERT INTO `lang_definitions` VALUES (4740, 3078, 3, 'El usuario de Inicio de sesión de emergencia puede hacer cualquier cosa');
INSERT INTO `lang_definitions` VALUES (4741, 3079, 3, 'Teléfono de emergencia');
INSERT INTO `lang_definitions` VALUES (4742, 3082, 3, 'Enfisema');
INSERT INTO `lang_definitions` VALUES (4743, 3083, 3, 'Empleado');
INSERT INTO `lang_definitions` VALUES (4744, 3084, 3, 'Empresa');
INSERT INTO `lang_definitions` VALUES (4745, 3085, 3, 'Dirección del empleador');
INSERT INTO `lang_definitions` VALUES (4746, 3086, 3, 'Datos de la empresa');
INSERT INTO `lang_definitions` VALUES (4747, 3087, 3, 'Nombre de Empresa');
INSERT INTO `lang_definitions` VALUES (4748, 3088, 3, 'VACIO');
INSERT INTO `lang_definitions` VALUES (4749, 3089, 3, 'Vacio');
INSERT INTO `lang_definitions` VALUES (4750, 3092, 3, 'Valor vacío en -Horas de eEmail-');
INSERT INTO `lang_definitions` VALUES (4751, 3093, 3, 'Valor vacío en -Remitente de email-');
INSERT INTO `lang_definitions` VALUES (4752, 3094, 3, 'Valor vacío en-Tema de email-');
INSERT INTO `lang_definitions` VALUES (4753, 3095, 3, 'Valor vacío en-Texto de email-');
INSERT INTO `lang_definitions` VALUES (4754, 3096, 3, 'Valor vacío en -Nombre del Facultativo-');
INSERT INTO `lang_definitions` VALUES (4755, 3097, 3, 'Valor vacío en -Contraseña-');
INSERT INTO `lang_definitions` VALUES (4756, 3098, 3, 'Valor vacío en -Horas de SMS-');
INSERT INTO `lang_definitions` VALUES (4757, 3099, 3, 'Vaciar en el valor -Texto SMS-');
INSERT INTO `lang_definitions` VALUES (4758, 3100, 3, 'Vaciar en el valor -Usuario-');
INSERT INTO `lang_definitions` VALUES (4759, 3109, 3, 'Activar aviso MCA');
INSERT INTO `lang_definitions` VALUES (4760, 3111, 3, 'Activar Informe MCA');
INSERT INTO `lang_definitions` VALUES (4761, 3112, 3, 'Activar seguimiento MCA');
INSERT INTO `lang_definitions` VALUES (4762, 3114, 3, 'Activar auditoría RANA');
INSERT INTO `lang_definitions` VALUES (4763, 3116, 3, 'Inicio de sesión Auditoría habilitado');
INSERT INTO `lang_definitions` VALUES (4764, 3117, 3, 'Activar Auditoría Registro y Autenticación del Nodo (ATNA)');
INSERT INTO `lang_definitions` VALUES (4765, 3118, 3, 'Activar Informe Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4766, 3121, 3, 'Activar Cliente SSL');
INSERT INTO `lang_definitions` VALUES (4767, 3122, 3, 'Activar Cliente SSL con certificado de autenticación.');
INSERT INTO `lang_definitions` VALUES (4768, 3124, 3, 'Activar Reglas Clínicas de Decisión (CDR)');
INSERT INTO `lang_definitions` VALUES (4769, 3127, 3, 'Activar informe medidas de calidad clínica (GCC)');
INSERT INTO `lang_definitions` VALUES (4770, 3128, 3, 'Activar popup recordatorios clínicos');
INSERT INTO `lang_definitions` VALUES (4771, 3129, 3, 'Activar Widget Recordatorios clínicos');
INSERT INTO `lang_definitions` VALUES (4772, 3132, 3, 'Activar Informes GCC');
INSERT INTO `lang_definitions` VALUES (4773, 3138, 3, 'Habilitar tarifas en el menú de la izquierda');
INSERT INTO `lang_definitions` VALUES (4774, 3143, 3, 'Activar Soporte Hylafax');
INSERT INTO `lang_definitions` VALUES (4775, 3145, 3, 'Activar el estado de importación de mensajes para Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (4776, 3149, 3, 'Activar intercambio Laboratorio');
INSERT INTO `lang_definitions` VALUES (4777, 3151, 3, 'Habilitar registro para documentos subidos/bajados de CouchDB');
INSERT INTO `lang_definitions` VALUES (4778, 3152, 3, 'Activar registro de todas las consultas SQL SELECT.');
INSERT INTO `lang_definitions` VALUES (4779, 3153, 3, 'Activar registro de backup de actividades relacionadas.');
INSERT INTO `lang_definitions` VALUES (4780, 3155, 3, 'Activar inicio sesión de actividades varias.');
INSERT INTO `lang_definitions` VALUES (4781, 3156, 3, 'Activar registro de actividades solicitadas.');
INSERT INTO `lang_definitions` VALUES (4782, 3157, 3, 'Activar registro de modificaciones del registro de pacientes.');
INSERT INTO `lang_definitions` VALUES (4783, 3158, 3, 'Activar registro de programar actividades.');
INSERT INTO `lang_definitions` VALUES (4784, 3159, 3, 'Activar registro de seguridad y administración de actividades.');
INSERT INTO `lang_definitions` VALUES (4785, 3162, 3, 'Activar servicio Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (4786, 3165, 3, 'Activar Portal Paciente Externo');
INSERT INTO `lang_definitions` VALUES (4787, 3166, 3, 'Activar Portal paciente desde el exterior.');
INSERT INTO `lang_definitions` VALUES (4788, 3168, 3, 'Activar Portal paciente in-situ');
INSERT INTO `lang_definitions` VALUES (4789, 3171, 3, 'Activar Portal paciente in-situ.');
INSERT INTO `lang_definitions` VALUES (4790, 3174, 3, 'Activar widget recordatorios del paciente');
INSERT INTO `lang_definitions` VALUES (4791, 3177, 3, 'Activar aviso fecha requerida para Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4792, 3179, 3, 'Activar Informe de Seguimiento de Fecha para Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4793, 3180, 3, 'Activar Soporte escaner');
INSERT INTO `lang_definitions` VALUES (4794, 3184, 3, 'Activar servicio de soporte OpenEMR LLC Laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (4795, 3185, 3, 'Activar Certificado de Autenticación del usuario.');
INSERT INTO `lang_definitions` VALUES (4796, 3190, 3, 'Activar servicio ZMG, Receta electrónica LLC');
INSERT INTO `lang_definitions` VALUES (4797, 3191, 3, 'Activado');
INSERT INTO `lang_definitions` VALUES (4798, 3196, 3, 'Activar el viejo panel de cargos para introducir códigos de facturas y pagos. No se recomienda usar la hoja de honorarios en su lugar.');
INSERT INTO `lang_definitions` VALUES (4799, 3199, 3, 'Encuentro');
INSERT INTO `lang_definitions` VALUES (4800, 3200, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4801, 3201, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4802, 3202, 3, 'visita');
INSERT INTO `lang_definitions` VALUES (4803, 3203, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4804, 3204, 3, 'Visita a un hospitalizado agudo o ED');
INSERT INTO `lang_definitions` VALUES (4805, 3210, 3, 'Fecha visita');
INSERT INTO `lang_definitions` VALUES (4806, 3215, 3, 'Formularios visita');
INSERT INTO `lang_definitions` VALUES (4807, 3216, 3, 'visita de salud y evaluación de comportamiento');
INSERT INTO `lang_definitions` VALUES (4808, 3217, 3, 'Histórico de visitas');
INSERT INTO `lang_definitions` VALUES (4809, 3218, 3, 'ID Visita');
INSERT INTO `lang_definitions` VALUES (4810, 3219, 3, 'Visita gripe');
INSERT INTO `lang_definitions` VALUES (4811, 3222, 3, 'número visita');
INSERT INTO `lang_definitions` VALUES (4812, 3224, 3, 'visita cuidado enfermería');
INSERT INTO `lang_definitions` VALUES (4813, 3225, 3, 'visita centro enfermería');
INSERT INTO `lang_definitions` VALUES (4814, 3226, 3, 'visita terapia ocupacional');
INSERT INTO `lang_definitions` VALUES (4815, 3227, 3, 'visita a consultorio');
INSERT INTO `lang_definitions` VALUES (4816, 3228, 3, 'visita paciente externo');
INSERT INTO `lang_definitions` VALUES (4817, 3229, 3, 'visita paciente externo w/PCP y obgyn');
INSERT INTO `lang_definitions` VALUES (4818, 3230, 3, 'Tamaño página visita');
INSERT INTO `lang_definitions` VALUES (4819, 3231, 3, 'Pago visita');
INSERT INTO `lang_definitions` VALUES (4820, 3232, 3, 'visita embarazo');
INSERT INTO `lang_definitions` VALUES (4821, 3233, 3, 'visita medicina preventiva - asesoramiento individual');
INSERT INTO `lang_definitions` VALUES (4822, 3234, 3, 'visita medicina preventiva para mayores de 40');
INSERT INTO `lang_definitions` VALUES (4823, 3235, 3, 'visita de medicina preventiva - asesoramiento en grupo');
INSERT INTO `lang_definitions` VALUES (4824, 3236, 3, 'visita medicina preventiva otros servicios');
INSERT INTO `lang_definitions` VALUES (4825, 3237, 3, 'visita servicios medicina preventiva mayores de 18');
INSERT INTO `lang_definitions` VALUES (4826, 3239, 3, 'visita psiquiatrica y psicológica');
INSERT INTO `lang_definitions` VALUES (4827, 3240, 3, 'Estadísticas de visitas');
INSERT INTO `lang_definitions` VALUES (4828, 3241, 3, 'Resumen de visitas');
INSERT INTO `lang_definitions` VALUES (4829, 3243, 3, 'Visita codificada');
INSERT INTO `lang_definitions` VALUES (4830, 3244, 3, 'Visita:');
INSERT INTO `lang_definitions` VALUES (4831, 3245, 3, 'Visita: visita ingreso no agudo, paciente externo, o oftalmológico');
INSERT INTO `lang_definitions` VALUES (4832, 3246, 3, 'Visitas');
INSERT INTO `lang_definitions` VALUES (4833, 3247, 3, 'Visitas y Formularios');
INSERT INTO `lang_definitions` VALUES (4834, 3248, 3, 'Visitas y Formularios');
INSERT INTO `lang_definitions` VALUES (4835, 3249, 3, 'Visitas no autorizadas');
INSERT INTO `lang_definitions` VALUES (4836, 3250, 3, 'Informe de visitas');
INSERT INTO `lang_definitions` VALUES (4837, 3251, 3, 'Sección visitas');
INSERT INTO `lang_definitions` VALUES (4838, 3253, 3, 'Encriptación');
INSERT INTO `lang_definitions` VALUES (4839, 3254, 3, 'Final');
INSERT INTO `lang_definitions` VALUES (4840, 3255, 3, 'Final (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (4841, 3256, 3, 'Fecha final');
INSERT INTO `lang_definitions` VALUES (4842, 3257, 3, 'Fecha final');
INSERT INTO `lang_definitions` VALUES (4843, 3262, 3, 'Fecha final debe ser posterior a fecha inicio');
INSERT INTO `lang_definitions` VALUES (4844, 3264, 3, 'Fecha Final:');
INSERT INTO `lang_definitions` VALUES (4845, 3269, 3, 'Hora finalización');
INSERT INTO `lang_definitions` VALUES (4846, 3270, 3, 'Enfermedad renal en Etapa Final - Beneficiario de MCP con un Plan de grupo del empleador');
INSERT INTO `lang_definitions` VALUES (4847, 3273, 3, 'Fecha final de servicio aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4848, 3274, 3, 'Termina DOS dd/mm/aaaa si desea entrar en una serie');
INSERT INTO `lang_definitions` VALUES (4849, 3275, 3, 'Hora final del día para eventos de calendario');
INSERT INTO `lang_definitions` VALUES (4850, 3276, 3, 'Sangre anormal Endo');
INSERT INTO `lang_definitions` VALUES (4851, 3277, 3, 'Endocrino');
INSERT INTO `lang_definitions` VALUES (4852, 3278, 3, 'Endoscopía');
INSERT INTO `lang_definitions` VALUES (4853, 3283, 3, 'Inglés');
INSERT INTO `lang_definitions` VALUES (4854, 3284, 3, 'Inglés');
INSERT INTO `lang_definitions` VALUES (4855, 3285, 3, 'Ingleses (Indios)');
INSERT INTO `lang_definitions` VALUES (4856, 3286, 3, 'Inglés (Estándar)');
INSERT INTO `lang_definitions` VALUES (4857, 3287, 3, 'Enscript comando usado por Hylafax.');
INSERT INTO `lang_definitions` VALUES (4858, 3288, 3, 'Garantizar OpenEMR tiene privilegios al directorio');
INSERT INTO `lang_definitions` VALUES (4859, 3290, 3, 'ENT Descarga');
INSERT INTO `lang_definitions` VALUES (4860, 3291, 3, 'ENT Dolor');
INSERT INTO `lang_definitions` VALUES (4861, 3294, 3, 'Introduzca un código de la diagnosis para excluir todas las facturas que no lo contienen');
INSERT INTO `lang_definitions` VALUES (4862, 3299, 3, 'Incorpore el cuerpo de la carta aquí');
INSERT INTO `lang_definitions` VALUES (4863, 3301, 3, 'Introduzca Contraseña root para Base Datos');
INSERT INTO `lang_definitions` VALUES (4864, 3302, 3, 'Introduzca Usuario root para Base Datos');
INSERT INTO `lang_definitions` VALUES (4865, 3310, 3, 'Introduzca Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4866, 3311, 3, 'Introduzca Medicamentos');
INSERT INTO `lang_definitions` VALUES (4867, 3318, 3, 'Introduzca Vacunas');
INSERT INTO `lang_definitions` VALUES (4868, 3319, 3, 'Introducir Clave');
INSERT INTO `lang_definitions` VALUES (4869, 3325, 3, 'Escriba el nuevo Estado');
INSERT INTO `lang_definitions` VALUES (4870, 3349, 3, 'Introducir código Re-identificación');
INSERT INTO `lang_definitions` VALUES (4871, 3359, 3, 'Incorpore sus criterios de búsqueda arriba');
INSERT INTO `lang_definitions` VALUES (4872, 3363, 3, 'entradas');
INSERT INTO `lang_definitions` VALUES (4873, 3368, 3, 'Ambiental');
INSERT INTO `lang_definitions` VALUES (4874, 3369, 3, 'Entrada de datos de EOB');
INSERT INTO `lang_definitions` VALUES (4875, 3373, 3, 'EOB envío - Remesas electrónicas');
INSERT INTO `lang_definitions` VALUES (4876, 3374, 3, 'EOB envío - Instrucciones');
INSERT INTO `lang_definitions` VALUES (4877, 3375, 3, 'EOB envío - Factura');
INSERT INTO `lang_definitions` VALUES (4878, 3376, 3, 'EOB envío - Nota del Paciente');
INSERT INTO `lang_definitions` VALUES (4879, 3377, 3, 'EOB envío - Buscar');
INSERT INTO `lang_definitions` VALUES (4880, 3379, 3, 'Epilepsia');
INSERT INTO `lang_definitions` VALUES (4881, 3385, 3, 'ERA (Remesa Electrónica de Aviso)');
INSERT INTO `lang_definitions` VALUES (4882, 3387, 3, 'Envío ERA (Remesa Electrónica de Aviso)');
INSERT INTO `lang_definitions` VALUES (4883, 3389, 3, 'Borrar');
INSERT INTO `lang_definitions` VALUES (4884, 3391, 3, 'Erecciones');
INSERT INTO `lang_definitions` VALUES (4885, 3392, 3, 'Error');
INSERT INTO `lang_definitions` VALUES (4886, 3394, 3, 'Error confirmando la recepción de los resultados del laboratorio');
INSERT INTO `lang_definitions` VALUES (4887, 3396, 3, 'Error al obtener los resultados de laboratorio de la red de intercambio del laboratorio');
INSERT INTO `lang_definitions` VALUES (4888, 3397, 3, 'Error en selección de género');
INSERT INTO `lang_definitions` VALUES (4889, 3398, 3, 'Error en -HIPAA- selección');
INSERT INTO `lang_definitions` VALUES (4890, 3399, 3, 'Error en el -Proceso de selección');
INSERT INTO `lang_definitions` VALUES (4891, 3400, 3, 'El error en la selección de -Puerta enlace SMS-');
INSERT INTO `lang_definitions` VALUES (4892, 3401, 3, 'Error en -Ordenar por- selección');
INSERT INTO `lang_definitions` VALUES (4893, 3402, 3, 'Error del file de compresion gzip');
INSERT INTO `lang_definitions` VALUES (4894, 3403, 3, 'Error en la opción SI o NO');
INSERT INTO `lang_definitions` VALUES (4895, 3406, 3, 'Error al abrir fichero adjunto para lectura');
INSERT INTO `lang_definitions` VALUES (4896, 3409, 3, 'Error al eliminar el mensaje');
INSERT INTO `lang_definitions` VALUES (4897, 3410, 3, 'Error recuperando resultados de la red de intercambio del laboratorio');
INSERT INTO `lang_definitions` VALUES (4898, 3413, 3, 'Error en el fichero de concesión de privilegios para el usuario de OpenEMR.');
INSERT INTO `lang_definitions` VALUES (4899, 3416, 3, 'error al registrar la forma!');
INSERT INTO `lang_definitions` VALUES (4900, 3417, 3, 'Error al guardar el fichero');
INSERT INTO `lang_definitions` VALUES (4901, 3419, 3, 'Error al escribir en el fichero');
INSERT INTO `lang_definitions` VALUES (4902, 3424, 3, 'Error, Este file no existe');
INSERT INTO `lang_definitions` VALUES (4903, 3425, 3, 'ERROR, incapaz de recoger los datos de servidor');
INSERT INTO `lang_definitions` VALUES (4904, 3426, 3, 'Error, incapaz de crear certificado de cliente');
INSERT INTO `lang_definitions` VALUES (4905, 3427, 3, 'Error, incapaz de crear el certificado p12 de Admin');
INSERT INTO `lang_definitions` VALUES (4906, 3428, 3, 'Error. No puede crearse certificadodo de Certificado de Autenticación');
INSERT INTO `lang_definitions` VALUES (4907, 3429, 3, 'Error, incapaz de crear el certificado del servidor');
INSERT INTO `lang_definitions` VALUES (4908, 3430, 3, 'Error, incapaz de abrir el file');
INSERT INTO `lang_definitions` VALUES (4909, 3431, 3, 'Error. Certificado de Autenticación de usuario no está activado en OpenEMR');
INSERT INTO `lang_definitions` VALUES (4910, 3433, 3, 'Error. Necesita instalar el fichero/Tar.php módulo php');
INSERT INTO `lang_definitions` VALUES (4911, 3434, 3, 'ERROR: no pudo abrir tabla sql, formulario roto?');
INSERT INTO `lang_definitions` VALUES (4912, 3437, 3, 'Error: ID duplicado en línea');
INSERT INTO `lang_definitions` VALUES (4913, 3438, 3, 'Error: Nombre duplicado en línea');
INSERT INTO `lang_definitions` VALUES (4914, 3439, 3, 'ERROR: Campo');
INSERT INTO `lang_definitions` VALUES (4915, 3440, 3, 'ERROR: Falta el fichero comprimido del Módulo PHP');
INSERT INTO `lang_definitions` VALUES (4916, 3441, 3, 'ERROR: Sin directorio de importación ICD');
INSERT INTO `lang_definitions` VALUES (4917, 3442, 3, 'Error: las contraseñas no coinciden. Por favor, compruebe lo tecleado.');
INSERT INTO `lang_definitions` VALUES (4918, 3443, 3, 'Error: las contraseñas no coinciden. Por favor, compruebe lo tecleado.');
INSERT INTO `lang_definitions` VALUES (4919, 3444, 3, 'Error, este file no existe');
INSERT INTO `lang_definitions` VALUES (4920, 3445, 3, 'ERROR: La siguiente variable contiene caracteres inválidos');
INSERT INTO `lang_definitions` VALUES (4921, 3446, 3, 'ERROR: No se puede copiar el fichero.');
INSERT INTO `lang_definitions` VALUES (4922, 3447, 3, 'Error, incapaz de crear el fichero de descarga');
INSERT INTO `lang_definitions` VALUES (4923, 3448, 3, 'ERROR: No se puede crear el fichero comprimido.');
INSERT INTO `lang_definitions` VALUES (4924, 3449, 3, 'ERROR: No se puede extraer el fichero.');
INSERT INTO `lang_definitions` VALUES (4925, 3450, 3, 'ERROR: No se puede leer el fichero en la base de datos.');
INSERT INTO `lang_definitions` VALUES (4926, 3451, 3, 'ERROR: No se puede establecer el número de versión.');
INSERT INTO `lang_definitions` VALUES (4927, 3452, 3, 'Errores');
INSERT INTO `lang_definitions` VALUES (4928, 3453, 3, 'Estado cuenta Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4929, 3454, 3, 'Registros Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4930, 3455, 3, 'Nombre Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4931, 3456, 3, 'Contraseña Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4932, 3457, 3, 'Rol Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4933, 3458, 3, 'Usuario Receta electrónica');
INSERT INTO `lang_definitions` VALUES (4934, 3459, 3, 'Eritema');
INSERT INTO `lang_definitions` VALUES (4935, 3462, 3, 'Esquimal');
INSERT INTO `lang_definitions` VALUES (4936, 3467, 3, 'Paciente regular');
INSERT INTO `lang_definitions` VALUES (4937, 3469, 3, 'Raza');
INSERT INTO `lang_definitions` VALUES (4938, 3470, 3, 'La etnia o la raza');
INSERT INTO `lang_definitions` VALUES (4939, 3471, 3, 'Lista de Origen étnico--Raza (escriba, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (4940, 3474, 3, 'ETIN');
INSERT INTO `lang_definitions` VALUES (4941, 3477, 3, 'Evento');
INSERT INTO `lang_definitions` VALUES (4942, 3478, 3, 'Fecha comienzo de evento');
INSERT INTO `lang_definitions` VALUES (4943, 3479, 3, 'Categoría de evento');
INSERT INTO `lang_definitions` VALUES (4944, 3480, 3, 'Fecha evento');
INSERT INTO `lang_definitions` VALUES (4945, 3482, 3, 'Descripción evento');
INSERT INTO `lang_definitions` VALUES (4946, 3483, 3, 'Detalles evento');
INSERT INTO `lang_definitions` VALUES (4947, 3484, 3, 'Evento no se repite');
INSERT INTO `lang_definitions` VALUES (4948, 3485, 3, 'Duración de Evento');
INSERT INTO `lang_definitions` VALUES (4949, 3486, 3, 'Duración de evento en minutos');
INSERT INTO `lang_definitions` VALUES (4950, 3487, 3, 'Honorarios del evento');
INSERT INTO `lang_definitions` VALUES (4951, 3488, 3, 'Lugar de evento');
INSERT INTO `lang_definitions` VALUES (4952, 3489, 3, 'Evento repite cada');
INSERT INTO `lang_definitions` VALUES (4953, 3490, 3, 'Evento repite en');
INSERT INTO `lang_definitions` VALUES (4954, 3491, 3, 'Hora comienzo evento');
INSERT INTO `lang_definitions` VALUES (4955, 3492, 3, 'Título de evento');
INSERT INTO `lang_definitions` VALUES (4956, 3493, 3, 'Título de Evento');
INSERT INTO `lang_definitions` VALUES (4957, 3494, 3, 'Página web de evento');
INSERT INTO `lang_definitions` VALUES (4958, 3495, 3, 'Eventos');
INSERT INTO `lang_definitions` VALUES (4959, 3496, 3, 'Eventos para');
INSERT INTO `lang_definitions` VALUES (4960, 3497, 3, 'Eventos abre en nueva ventana');
INSERT INTO `lang_definitions` VALUES (4961, 3499, 3, 'cada');
INSERT INTO `lang_definitions` VALUES (4962, 3500, 3, 'Cada');
INSERT INTO `lang_definitions` VALUES (4963, 3502, 3, 'cada 3 horas');
INSERT INTO `lang_definitions` VALUES (4964, 3504, 3, 'cada 4 horas');
INSERT INTO `lang_definitions` VALUES (4965, 3506, 3, 'cada 5 horas');
INSERT INTO `lang_definitions` VALUES (4966, 3508, 3, 'cada 6 horas');
INSERT INTO `lang_definitions` VALUES (4967, 3510, 3, 'cada 8 horas');
INSERT INTO `lang_definitions` VALUES (4968, 3511, 3, 'cada cuarto');
INSERT INTO `lang_definitions` VALUES (4969, 3513, 3, 'uno sí, otro no');
INSERT INTO `lang_definitions` VALUES (4970, 3514, 3, 'cada tercero');
INSERT INTO `lang_definitions` VALUES (4971, 3515, 3, 'Cada, cada otro, cada 3ro, etc.');
INSERT INTO `lang_definitions` VALUES (4972, 3517, 3, 'Examen y los resultados de las pruebas');
INSERT INTO `lang_definitions` VALUES (4973, 3518, 3, 'Resultados del examen');
INSERT INTO `lang_definitions` VALUES (4974, 3521, 3, 'Examen');
INSERT INTO `lang_definitions` VALUES (4975, 3522, 3, 'Fecha de examen');
INSERT INTO `lang_definitions` VALUES (4976, 3523, 3, 'Ejemplo');
INSERT INTO `lang_definitions` VALUES (4977, 3526, 3, 'Ejemplos');
INSERT INTO `lang_definitions` VALUES (4978, 3528, 3, 'Exámenes/Pruebas');
INSERT INTO `lang_definitions` VALUES (4979, 3530, 3, 'Excepto');
INSERT INTO `lang_definitions` VALUES (4980, 3531, 3, 'Lagrimeo Excesivo');
INSERT INTO `lang_definitions` VALUES (4981, 3533, 3, 'Pacientes Excluídos');
INSERT INTO `lang_definitions` VALUES (4982, 3534, 3, 'Exclusiones');
INSERT INTO `lang_definitions` VALUES (4983, 3535, 3, 'Organización de provedor exclusivo (OPE)');
INSERT INTO `lang_definitions` VALUES (4984, 3537, 3, 'Tamaño papel ejecutivo');
INSERT INTO `lang_definitions` VALUES (4985, 3538, 3, 'Ejercicio');
INSERT INTO `lang_definitions` VALUES (4986, 3539, 3, 'Patrones de ejercicio');
INSERT INTO `lang_definitions` VALUES (4987, 3540, 3, 'Patrones del ejercicio');
INSERT INTO `lang_definitions` VALUES (4988, 3541, 3, 'Existe');
INSERT INTO `lang_definitions` VALUES (4989, 3543, 3, 'Salir de Administración');
INSERT INTO `lang_definitions` VALUES (4990, 3547, 3, 'Exp');
INSERT INTO `lang_definitions` VALUES (4991, 3549, 3, 'Expandir');
INSERT INTO `lang_definitions` VALUES (4992, 3550, 3, 'Expandir');
INSERT INTO `lang_definitions` VALUES (4993, 3551, 3, 'Expandir Todo');
INSERT INTO `lang_definitions` VALUES (4994, 3555, 3, 'Vista ampliada');
INSERT INTO `lang_definitions` VALUES (4995, 3556, 3, 'Se espera form_encounter.pid para ser');
INSERT INTO `lang_definitions` VALUES (4996, 3557, 3, 'Caducidad');
INSERT INTO `lang_definitions` VALUES (4997, 3558, 3, 'Fecha de caducidad');
INSERT INTO `lang_definitions` VALUES (4998, 3559, 3, 'Caducidad');
INSERT INTO `lang_definitions` VALUES (4999, 3560, 3, 'Expira en');
INSERT INTO `lang_definitions` VALUES (5000, 3561, 3, 'Exportar');
INSERT INTO `lang_definitions` VALUES (5001, 3562, 3, 'Exportar con CSV');
INSERT INTO `lang_definitions` VALUES (5002, 3564, 3, 'Exportar configuración');
INSERT INTO `lang_definitions` VALUES (5003, 3568, 3, 'Exportación de Demograficos del paciente');
INSERT INTO `lang_definitions` VALUES (5004, 3570, 3, 'Exportar Informe PQRI');
INSERT INTO `lang_definitions` VALUES (5005, 3572, 3, 'Selección de exportación como CSV');
INSERT INTO `lang_definitions` VALUES (5006, 3573, 3, 'Selección de las colecciones a la exportación');
INSERT INTO `lang_definitions` VALUES (5007, 3574, 3, 'Exportar a CSV');
INSERT INTO `lang_definitions` VALUES (5008, 3575, 3, 'Exportación al sistema de facturación externo');
INSERT INTO `lang_definitions` VALUES (5009, 3577, 3, 'Exposición a los países extranjeros');
INSERT INTO `lang_definitions` VALUES (5010, 3578, 3, 'Exposición a Países Extranjeros');
INSERT INTO `lang_definitions` VALUES (5011, 3579, 3, 'Ext tiempo de coleccionar');
INSERT INTO `lang_definitions` VALUES (5012, 3581, 3, 'Externo');
INSERT INTO `lang_definitions` VALUES (5013, 3584, 3, 'Carga de datos externos');
INSERT INTO `lang_definitions` VALUES (5014, 3585, 3, 'Utilidad de importación bbdd externa');
INSERT INTO `lang_definitions` VALUES (5015, 3588, 3, 'D.N.I.');
INSERT INTO `lang_definitions` VALUES (5016, 3589, 3, 'ID externo');
INSERT INTO `lang_definitions` VALUES (5017, 3590, 3, 'identificación externos');
INSERT INTO `lang_definitions` VALUES (5018, 3591, 3, 'Identificador externo');
INSERT INTO `lang_definitions` VALUES (5019, 3594, 3, 'Derivación externa');
INSERT INTO `lang_definitions` VALUES (5020, 3595, 3, 'Seguimiento de Derivaciones Externas');
INSERT INTO `lang_definitions` VALUES (5021, 3596, 3, '¿Derivación externa?');
INSERT INTO `lang_definitions` VALUES (5022, 3597, 3, 'Derivaciones externas');
INSERT INTO `lang_definitions` VALUES (5023, 3598, 3, 'Extraer este file comprimido');
INSERT INTO `lang_definitions` VALUES (5024, 3599, 3, 'Extrayendo fichero. Esto puede tardar algún tiempo...');
INSERT INTO `lang_definitions` VALUES (5025, 3600, 3, 'Exudado:');
INSERT INTO `lang_definitions` VALUES (5026, 3610, 3, 'Irritación de Ojo');
INSERT INTO `lang_definitions` VALUES (5027, 3615, 3, 'Dolor de Ojo');
INSERT INTO `lang_definitions` VALUES (5028, 3619, 3, 'Enrojecimiento de Ojo');
INSERT INTO `lang_definitions` VALUES (5029, 3622, 3, 'Ojos');
INSERT INTO `lang_definitions` VALUES (5030, 3624, 3, 'F');
INSERT INTO `lang_definitions` VALUES (5031, 3625, 3, 'F/H Problemas de Sangre');
INSERT INTO `lang_definitions` VALUES (5032, 3626, 3, 'F/H Hirsutismo Femenino/Estrías');
INSERT INTO `lang_definitions` VALUES (5033, 3627, 3, 'Centros');
INSERT INTO `lang_definitions` VALUES (5034, 3628, 3, 'Centro');
INSERT INTO `lang_definitions` VALUES (5035, 3629, 3, 'centro');
INSERT INTO `lang_definitions` VALUES (5036, 3630, 3, 'Administración del Centro');
INSERT INTO `lang_definitions` VALUES (5037, 3631, 3, 'Ciudad del Centro');
INSERT INTO `lang_definitions` VALUES (5038, 3632, 3, 'Código del Centro');
INSERT INTO `lang_definitions` VALUES (5039, 3634, 3, 'Código País del Centro');
INSERT INTO `lang_definitions` VALUES (5040, 3635, 3, 'Fax del Centro');
INSERT INTO `lang_definitions` VALUES (5041, 3637, 3, 'Nombre del Centro');
INSERT INTO `lang_definitions` VALUES (5042, 3638, 3, 'NPI del Centro');
INSERT INTO `lang_definitions` VALUES (5043, 3639, 3, 'Teléfono del Centro');
INSERT INTO `lang_definitions` VALUES (5044, 3641, 3, 'Información de usuario en el centro especificado');
INSERT INTO `lang_definitions` VALUES (5045, 3642, 3, 'Estado del Centro');
INSERT INTO `lang_definitions` VALUES (5046, 3643, 3, 'Dirección del Centro');
INSERT INTO `lang_definitions` VALUES (5047, 3645, 3, 'Código Postal del Centro');
INSERT INTO `lang_definitions` VALUES (5048, 3647, 3, 'Centro:');
INSERT INTO `lang_definitions` VALUES (5049, 3648, 3, 'Fallo');
INSERT INTO `lang_definitions` VALUES (5050, 3649, 3, 'fallado');
INSERT INTO `lang_definitions` VALUES (5051, 3650, 3, 'Fallado');
INSERT INTO `lang_definitions` VALUES (5052, 3658, 3, 'Fallo al crear la carpeta temporal. CouchDB no funcionará.');
INSERT INTO `lang_definitions` VALUES (5053, 3663, 3, 'Fallo');
INSERT INTO `lang_definitions` VALUES (5054, 3664, 3, 'error');
INSERT INTO `lang_definitions` VALUES (5055, 3671, 3, 'Historia familiar');
INSERT INTO `lang_definitions` VALUES (5056, 3673, 3, 'Historia Familiar de Glaucoma');
INSERT INTO `lang_definitions` VALUES (5057, 3674, 3, 'Historia');
INSERT INTO `lang_definitions` VALUES (5058, 3676, 3, 'Familia de pago');
INSERT INTO `lang_definitions` VALUES (5059, 3677, 3, 'Tamaño familia');
INSERT INTO `lang_definitions` VALUES (5060, 3678, 3, 'Suposición');
INSERT INTO `lang_definitions` VALUES (5061, 3680, 3, 'Iraní');
INSERT INTO `lang_definitions` VALUES (5062, 3683, 3, 'Padre');
INSERT INTO `lang_definitions` VALUES (5063, 3685, 3, 'Fatiga');
INSERT INTO `lang_definitions` VALUES (5064, 3686, 3, 'Fatigado');
INSERT INTO `lang_definitions` VALUES (5065, 3688, 3, 'Fax');
INSERT INTO `lang_definitions` VALUES (5066, 3689, 3, 'Contador fax');
INSERT INTO `lang_definitions` VALUES (5067, 3690, 3, 'Número de fax');
INSERT INTO `lang_definitions` VALUES (5068, 3692, 3, 'Fax/Escanear');
INSERT INTO `lang_definitions` VALUES (5069, 3693, 3, 'Faxes entrada');
INSERT INTO `lang_definitions` VALUES (5070, 3694, 3, 'Faxes salida');
INSERT INTO `lang_definitions` VALUES (5071, 3695, 3, 'Características');
INSERT INTO `lang_definitions` VALUES (5072, 3696, 3, 'Feb');
INSERT INTO `lang_definitions` VALUES (5073, 3697, 3, 'Febrero');
INSERT INTO `lang_definitions` VALUES (5074, 3698, 3, 'FECA');
INSERT INTO `lang_definitions` VALUES (5075, 3699, 3, 'Nº Colegiado');
INSERT INTO `lang_definitions` VALUES (5076, 3700, 3, 'Federal EIN');
INSERT INTO `lang_definitions` VALUES (5077, 3701, 3, 'Nº Identificación de impuesto federal');
INSERT INTO `lang_definitions` VALUES (5078, 3703, 3, 'Honorario');
INSERT INTO `lang_definitions` VALUES (5079, 3704, 3, 'honorario');
INSERT INTO `lang_definitions` VALUES (5080, 3705, 3, 'No se permiten honorarios');
INSERT INTO `lang_definitions` VALUES (5081, 3706, 3, 'Hoja de honorarios');
INSERT INTO `lang_definitions` VALUES (5082, 3708, 3, 'Opciones de la hoja de honorarios');
INSERT INTO `lang_definitions` VALUES (5083, 3709, 3, 'Honorarios');
INSERT INTO `lang_definitions` VALUES (5084, 3710, 3, 'Femenino');
INSERT INTO `lang_definitions` VALUES (5085, 3711, 3, 'AP Femenino');
INSERT INTO `lang_definitions` VALUES (5086, 3712, 3, 'Condones femeninos');
INSERT INTO `lang_definitions` VALUES (5087, 3713, 3, 'G Femenino');
INSERT INTO `lang_definitions` VALUES (5088, 3714, 3, 'LC Femenino');
INSERT INTO `lang_definitions` VALUES (5089, 3715, 3, 'P Femenino');
INSERT INTO `lang_definitions` VALUES (5090, 3716, 3, 'Síntomas Femeninos');
INSERT INTO `lang_definitions` VALUES (5091, 3717, 3, 'Mujeres VSC');
INSERT INTO `lang_definitions` VALUES (5092, 3720, 3, 'Fiebre');
INSERT INTO `lang_definitions` VALUES (5093, 3721, 3, 'Fiebre:');
INSERT INTO `lang_definitions` VALUES (5094, 3722, 3, 'Problemas de Sangre FH');
INSERT INTO `lang_definitions` VALUES (5095, 3726, 3, 'Fibromas');
INSERT INTO `lang_definitions` VALUES (5096, 3732, 3, 'Tipo de campo a utilizar para el país del empleador o abonado en demográficos.');
INSERT INTO `lang_definitions` VALUES (5097, 3733, 3, 'Tipo de campo a utilizar para el estado del empleador o abonado en demográficos.');
INSERT INTO `lang_definitions` VALUES (5098, 3734, 3, 'Falta Campo(s)!');
INSERT INTO `lang_definitions` VALUES (5099, 3740, 3, 'Fichero');
INSERT INTO `lang_definitions` VALUES (5100, 3743, 3, 'Fichero en el directorio de documentación para aprender como automatizar el proceso de creación de logs de backup');
INSERT INTO `lang_definitions` VALUES (5101, 3744, 3, 'Ubicacion del file');
INSERT INTO `lang_definitions` VALUES (5102, 3745, 3, 'Gestión de Fichero');
INSERT INTO `lang_definitions` VALUES (5103, 3752, 3, 'Fichero de permisos de usuario de OpenEMR');
INSERT INTO `lang_definitions` VALUES (5104, 3753, 3, 'Fallo en la recuperación de archivo de CouchDB');
INSERT INTO `lang_definitions` VALUES (5105, 3754, 3, 'Sala de archivo');
INSERT INTO `lang_definitions` VALUES (5106, 3755, 3, 'Fichero para adjuntar');
INSERT INTO `lang_definitions` VALUES (5107, 3757, 3, 'Un fichero con el mismo nombre ya existe en la ubicación:');
INSERT INTO `lang_definitions` VALUES (5108, 3758, 3, 'Nombre de fichero');
INSERT INTO `lang_definitions` VALUES (5109, 3760, 3, 'Ficheros');
INSERT INTO `lang_definitions` VALUES (5110, 3764, 3, 'Filipino');
INSERT INTO `lang_definitions` VALUES (5111, 3766, 3, 'Rellene cualquiera de las filas de abajo.');
INSERT INTO `lang_definitions` VALUES (5112, 3767, 3, 'Rellenar sólo si manda notificación a paciente por email');
INSERT INTO `lang_definitions` VALUES (5113, 3776, 3, 'Llenar los valores abajo');
INSERT INTO `lang_definitions` VALUES (5114, 3778, 3, 'Rellene la fila');
INSERT INTO `lang_definitions` VALUES (5115, 3781, 3, 'Filtro');
INSERT INTO `lang_definitions` VALUES (5116, 3782, 3, 'Filtro para los constantes');
INSERT INTO `lang_definitions` VALUES (5117, 3783, 3, 'Filtro por Definición');
INSERT INTO `lang_definitions` VALUES (5118, 3784, 3, 'Filtrado desde');
INSERT INTO `lang_definitions` VALUES (5119, 3785, 3, 'Filtros');
INSERT INTO `lang_definitions` VALUES (5120, 3786, 3, 'filtros');
INSERT INTO `lang_definitions` VALUES (5121, 3787, 3, 'Final');
INSERT INTO `lang_definitions` VALUES (5122, 3788, 3, 'Diagnóstico final');
INSERT INTO `lang_definitions` VALUES (5123, 3789, 3, 'Diagnóstico final por especialista');
INSERT INTO `lang_definitions` VALUES (5124, 3791, 3, 'Financiero');
INSERT INTO `lang_definitions` VALUES (5125, 3792, 3, 'Fecha cierre financiero (aaaa-mm-dd)');
INSERT INTO `lang_definitions` VALUES (5126, 3793, 3, 'Información financiera - cualquier cosa');
INSERT INTO `lang_definitions` VALUES (5127, 3795, 3, 'Información financiera - mis visitas');
INSERT INTO `lang_definitions` VALUES (5128, 3798, 3, 'Fecha de revisión financiero');
INSERT INTO `lang_definitions` VALUES (5129, 3799, 3, 'Resumen Financiero por Código de Servicio');
INSERT INTO `lang_definitions` VALUES (5130, 3801, 3, 'Buscar');
INSERT INTO `lang_definitions` VALUES (5131, 3802, 3, 'Buscar disponible');
INSERT INTO `lang_definitions` VALUES (5132, 3803, 3, 'Buscar citas disponibles');
INSERT INTO `lang_definitions` VALUES (5133, 3804, 3, 'Busca paciente');
INSERT INTO `lang_definitions` VALUES (5134, 3805, 3, 'Buscar materiales educativos para el paciente');
INSERT INTO `lang_definitions` VALUES (5135, 3807, 3, 'Conclusiones');
INSERT INTO `lang_definitions` VALUES (5136, 3808, 3, 'Conclusiones por especialista');
INSERT INTO `lang_definitions` VALUES (5137, 3809, 3, 'Multa');
INSERT INTO `lang_definitions` VALUES (5138, 3811, 3, 'Final Pagos');
INSERT INTO `lang_definitions` VALUES (5139, 3813, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (5140, 3815, 3, 'Primero');
INSERT INTO `lang_definitions` VALUES (5141, 3818, 3, 'Primer día de la semana');
INSERT INTO `lang_definitions` VALUES (5142, 3821, 3, 'Nombre');
INSERT INTO `lang_definitions` VALUES (5143, 3822, 3, 'Nombre');
INSERT INTO `lang_definitions` VALUES (5144, 3823, 3, 'Nombre:');
INSERT INTO `lang_definitions` VALUES (5145, 3828, 3, 'Aptitud');
INSERT INTO `lang_definitions` VALUES (5146, 3829, 3, 'Condicion Fisica');
INSERT INTO `lang_definitions` VALUES (5147, 3830, 3, 'Condicion Fisica para este jugador hoy');
INSERT INTO `lang_definitions` VALUES (5148, 3832, 3, 'Aptitud para jugar');
INSERT INTO `lang_definitions` VALUES (5149, 3833, 3, 'Fijar fechas visita - cualquier visita');
INSERT INTO `lang_definitions` VALUES (5150, 3835, 3, 'Solucionar este');
INSERT INTO `lang_definitions` VALUES (5151, 3836, 3, 'FL');
INSERT INTO `lang_definitions` VALUES (5152, 3838, 3, 'Flatulencia');
INSERT INTO `lang_definitions` VALUES (5153, 3839, 3, 'Flujo');
INSERT INTO `lang_definitions` VALUES (5154, 3856, 3, 'Temporada de gripe');
INSERT INTO `lang_definitions` VALUES (5155, 3857, 3, 'Temporada de Gripe');
INSERT INTO `lang_definitions` VALUES (5156, 3858, 3, 'Vacunación gripe');
INSERT INTO `lang_definitions` VALUES (5157, 3859, 3, 'Problema de fluído y electrolito');
INSERT INTO `lang_definitions` VALUES (5158, 3860, 3, 'FMS');
INSERT INTO `lang_definitions` VALUES (5159, 3861, 3, 'Tamaño papel folio');
INSERT INTO `lang_definitions` VALUES (5160, 3862, 3, 'Seguir manualmente');
INSERT INTO `lang_definitions` VALUES (5161, 3863, 3, 'Siga estas instrucciones para instalar o actualizar la siguiente bbdd');
INSERT INTO `lang_definitions` VALUES (5162, 3864, 3, 'Seguimineto');
INSERT INTO `lang_definitions` VALUES (5163, 3866, 3, 'Motivo de seguimiento');
INSERT INTO `lang_definitions` VALUES (5164, 3868, 3, 'A continuación una nueva constante de cliente:');
INSERT INTO `lang_definitions` VALUES (5165, 3869, 3, 'A continuación un nuevo idioma de cliente:');
INSERT INTO `lang_definitions` VALUES (5166, 3870, 3, 'A continuación una nueva definición (Idioma, Constante, Definición):');
INSERT INTO `lang_definitions` VALUES (5167, 3872, 3, 'Servicios de seguimiento');
INSERT INTO `lang_definitions` VALUES (5168, 3873, 3, 'Seguimiento indicado');
INSERT INTO `lang_definitions` VALUES (5169, 3876, 3, 'Intolerancia del Alimento');
INSERT INTO `lang_definitions` VALUES (5170, 3877, 3, 'Pie');
INSERT INTO `lang_definitions` VALUES (5171, 3878, 3, 'Problemas en los píes');
INSERT INTO `lang_definitions` VALUES (5172, 3879, 3, 'Píe:');
INSERT INTO `lang_definitions` VALUES (5173, 3880, 3, 'Lesiones de fútbol');
INSERT INTO `lang_definitions` VALUES (5174, 3882, 3, 'Informe de lesión futbolística');
INSERT INTO `lang_definitions` VALUES (5175, 3883, 3, 'Tipo de calzado');
INSERT INTO `lang_definitions` VALUES (5176, 3884, 3, 'para');
INSERT INTO `lang_definitions` VALUES (5177, 3885, 3, 'Para');
INSERT INTO `lang_definitions` VALUES (5178, 3891, 3, 'Por Código');
INSERT INTO `lang_definitions` VALUES (5179, 3899, 3, 'Para reclamaciones de visita');
INSERT INTO `lang_definitions` VALUES (5180, 3901, 3, 'Por Ejemplo');
INSERT INTO `lang_definitions` VALUES (5181, 3907, 3, 'Por Factura');
INSERT INTO `lang_definitions` VALUES (5182, 3909, 3, 'Para Seguro médico sólo, obliga al facultativo de referencia a ser el mismo que el facultativo del representado.');
INSERT INTO `lang_definitions` VALUES (5183, 3919, 3, 'Para el profesional/Organizacion referida');
INSERT INTO `lang_definitions` VALUES (5184, 3922, 3, 'Por el pasado');
INSERT INTO `lang_definitions` VALUES (5185, 3934, 3, 'por variable');
INSERT INTO `lang_definitions` VALUES (5186, 3935, 3, 'para:');
INSERT INTO `lang_definitions` VALUES (5187, 3936, 3, 'Fuerza la apertura del widget de facturación');
INSERT INTO `lang_definitions` VALUES (5188, 3937, 3, 'Forzar Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (5189, 3939, 3, 'Antebrazo');
INSERT INTO `lang_definitions` VALUES (5190, 3940, 3, 'Formulario');
INSERT INTO `lang_definitions` VALUES (5191, 3941, 3, 'formulario');
INSERT INTO `lang_definitions` VALUES (5192, 3945, 3, 'Formato');
INSERT INTO `lang_definitions` VALUES (5193, 3946, 3, 'formato');
INSERT INTO `lang_definitions` VALUES (5194, 3948, 3, 'Formato incorrecto para el NDC');
INSERT INTO `lang_definitions` VALUES (5195, 3949, 3, 'Formato usado para la mayoría de fechas');
INSERT INTO `lang_definitions` VALUES (5196, 3950, 3, 'Formato usado para mostrar la mayoría de horas.');
INSERT INTO `lang_definitions` VALUES (5197, 3951, 3, 'Informe Formateado');
INSERT INTO `lang_definitions` VALUES (5198, 3952, 3, 'Ex-fumador');
INSERT INTO `lang_definitions` VALUES (5199, 3953, 3, 'Formularios');
INSERT INTO `lang_definitions` VALUES (5200, 3954, 3, 'Formas de administración');
INSERT INTO `lang_definitions` VALUES (5201, 3959, 3, 'Re-enviar');
INSERT INTO `lang_definitions` VALUES (5202, 3962, 3, 'Reenviar Páginas vía fax');
INSERT INTO `lang_definitions` VALUES (5203, 3964, 3, 'Remitido');
INSERT INTO `lang_definitions` VALUES (5204, 3967, 3, 'Cuarto');
INSERT INTO `lang_definitions` VALUES (5205, 3969, 3, 'Fractura');
INSERT INTO `lang_definitions` VALUES (5206, 3970, 3, 'Fractura de escafoides');
INSERT INTO `lang_definitions` VALUES (5207, 3971, 3, 'Fractura del maléolo lat.');
INSERT INTO `lang_definitions` VALUES (5208, 3972, 3, 'Fractura del maléolo tibial.');
INSERT INTO `lang_definitions` VALUES (5209, 3973, 3, 'Fractura de base quinta (5 ª) metatarsianas');
INSERT INTO `lang_definitions` VALUES (5210, 3974, 3, 'Marco');
INSERT INTO `lang_definitions` VALUES (5211, 3975, 3, 'Soporte para Marcos requeridos');
INSERT INTO `lang_definitions` VALUES (5212, 3977, 3, 'Francés');
INSERT INTO `lang_definitions` VALUES (5213, 3978, 3, 'Francés (Canadiense)');
INSERT INTO `lang_definitions` VALUES (5214, 3979, 3, 'Francés (Standard)');
INSERT INTO `lang_definitions` VALUES (5215, 3980, 3, 'Frecuencia');
INSERT INTO `lang_definitions` VALUES (5216, 3981, 3, 'Resfriados Frecuentes');
INSERT INTO `lang_definitions` VALUES (5217, 3982, 3, 'Enfermedades Frecuentes');
INSERT INTO `lang_definitions` VALUES (5218, 3983, 3, 'Viernes');
INSERT INTO `lang_definitions` VALUES (5219, 3984, 3, 'Viernes');
INSERT INTO `lang_definitions` VALUES (5220, 3986, 3, 'Desde');
INSERT INTO `lang_definitions` VALUES (5221, 3987, 3, 'DESDE');
INSERT INTO `lang_definitions` VALUES (5222, 3988, 3, 'desde');
INSERT INTO `lang_definitions` VALUES (5223, 3989, 3, 'Fecha desde no puede ser mayor que fecha hasta');
INSERT INTO `lang_definitions` VALUES (5224, 3994, 3, 'Desde:');
INSERT INTO `lang_definitions` VALUES (5225, 3995, 3, 'Desde:');
INSERT INTO `lang_definitions` VALUES (5226, 3996, 3, 'FROM_CITY');
INSERT INTO `lang_definitions` VALUES (5227, 3998, 3, 'FROM_FNAME');
INSERT INTO `lang_definitions` VALUES (5228, 3999, 3, 'FROM_LNAME');
INSERT INTO `lang_definitions` VALUES (5229, 4000, 3, 'FROM_MNAME');
INSERT INTO `lang_definitions` VALUES (5230, 4002, 3, 'FROM_PHONECELL');
INSERT INTO `lang_definitions` VALUES (5231, 4003, 3, 'FROM_POSTAL');
INSERT INTO `lang_definitions` VALUES (5232, 4004, 3, 'FROM_STATE');
INSERT INTO `lang_definitions` VALUES (5233, 4005, 3, 'FROM_STREET');
INSERT INTO `lang_definitions` VALUES (5234, 4006, 3, 'FROM_TITLE');
INSERT INTO `lang_definitions` VALUES (5235, 4007, 3, 'FROM_VALEDICTORY');
INSERT INTO `lang_definitions` VALUES (5236, 4008, 3, 'Oficina central');
INSERT INTO `lang_definitions` VALUES (5237, 4009, 3, 'Recibos de la Oficina Central');
INSERT INTO `lang_definitions` VALUES (5238, 4010, 3, 'Reportes de Recibos de la Oficina Central');
INSERT INTO `lang_definitions` VALUES (5239, 4011, 3, 'Rec. Oficina Central');
INSERT INTO `lang_definitions` VALUES (5240, 4012, 3, 'La derecha frontal:');
INSERT INTO `lang_definitions` VALUES (5241, 4018, 3, 'Nombre Completo');
INSERT INTO `lang_definitions` VALUES (5242, 4020, 3, 'Ruta completa del directorio que contiene los ejecutables MySQL.');
INSERT INTO `lang_definitions` VALUES (5243, 4021, 3, 'Ruta completa del directorio que contiene los ejecutables Perl.');
INSERT INTO `lang_definitions` VALUES (5244, 4022, 3, 'Ruta completa del directorio para log de eventos de backup');
INSERT INTO `lang_definitions` VALUES (5245, 4023, 3, 'Ruta completa del directorio usado para ficheros temporales');
INSERT INTO `lang_definitions` VALUES (5246, 4024, 3, 'Juego completo');
INSERT INTO `lang_definitions` VALUES (5247, 4026, 3, 'Entrenamiento completo');
INSERT INTO `lang_definitions` VALUES (5248, 4028, 3, 'Pagado Total');
INSERT INTO `lang_definitions` VALUES (5249, 4038, 3, 'G');
INSERT INTO `lang_definitions` VALUES (5250, 4039, 3, 'G/DL');
INSERT INTO `lang_definitions` VALUES (5251, 4042, 3, 'Afección de la vesícula biliar');
INSERT INTO `lang_definitions` VALUES (5252, 4043, 3, 'Piedras en la vesícula');
INSERT INTO `lang_definitions` VALUES (5253, 4044, 3, 'Periodo de Juego');
INSERT INTO `lang_definitions` VALUES (5254, 4045, 3, 'Juegos');
INSERT INTO `lang_definitions` VALUES (5255, 4046, 3, 'Juegos faltados');
INSERT INTO `lang_definitions` VALUES (5256, 4047, 3, 'juegos/eventos');
INSERT INTO `lang_definitions` VALUES (5257, 4048, 3, 'Juegos/Eventos perdidos');
INSERT INTO `lang_definitions` VALUES (5258, 4050, 3, 'Gastritis');
INSERT INTO `lang_definitions` VALUES (5259, 4051, 3, 'Dolor Gastrointestinal');
INSERT INTO `lang_definitions` VALUES (5260, 4052, 3, 'Gastrointestinal');
INSERT INTO `lang_definitions` VALUES (5261, 4056, 3, 'Informe de estadísticas del GCAC');
INSERT INTO `lang_definitions` VALUES (5262, 4057, 3, 'Estadísticas GCAC');
INSERT INTO `lang_definitions` VALUES (5263, 4058, 3, 'Falta la forma de la visita del GCAC');
INSERT INTO `lang_definitions` VALUES (5264, 4059, 3, 'Género');
INSERT INTO `lang_definitions` VALUES (5265, 4060, 3, 'Género');
INSERT INTO `lang_definitions` VALUES (5266, 4061, 3, 'General');
INSERT INTO `lang_definitions` VALUES (5267, 4065, 3, 'Categoría de servicio general');
INSERT INTO `lang_definitions` VALUES (5268, 4072, 3, 'Generar y Descargar');
INSERT INTO `lang_definitions` VALUES (5269, 4074, 3, 'Generar y descargar HCFA 1500 reclamaciones en papel');
INSERT INTO `lang_definitions` VALUES (5270, 4077, 3, 'Generar y descargar batch X12');
INSERT INTO `lang_definitions` VALUES (5271, 4078, 3, 'Generar y descargar batch X12 de reclamación por visita');
INSERT INTO `lang_definitions` VALUES (5272, 4081, 3, 'Generar y transmitir electrónicamente las recetas autorizadas.');
INSERT INTO `lang_definitions` VALUES (5273, 4082, 3, 'Generar formulario CMS 1500');
INSERT INTO `lang_definitions` VALUES (5274, 4083, 3, 'Generar formulario CMS 1500 PDF');
INSERT INTO `lang_definitions` VALUES (5275, 4084, 3, 'Generar formulario CMS 1500 TEXTO');
INSERT INTO `lang_definitions` VALUES (5276, 4085, 3, 'Genere HCFA');
INSERT INTO `lang_definitions` VALUES (5277, 4087, 3, 'Generar factura');
INSERT INTO `lang_definitions` VALUES (5278, 4088, 3, 'Genere la Carta');
INSERT INTO `lang_definitions` VALUES (5279, 4089, 3, 'Generar carta relacionada');
INSERT INTO `lang_definitions` VALUES (5280, 4091, 3, 'Generar informe PQRI (Método A)');
INSERT INTO `lang_definitions` VALUES (5281, 4093, 3, 'Generar informe PQRI (Método E)');
INSERT INTO `lang_definitions` VALUES (5282, 4097, 3, 'Generar informe');
INSERT INTO `lang_definitions` VALUES (5283, 4105, 3, 'Generar usuario y contraseña para');
INSERT INTO `lang_definitions` VALUES (5284, 4106, 3, 'Generar X12');
INSERT INTO `lang_definitions` VALUES (5285, 4108, 3, 'Generar visita X12');
INSERT INTO `lang_definitions` VALUES (5286, 4110, 3, 'Generado en');
INSERT INTO `lang_definitions` VALUES (5287, 4112, 3, 'genera');
INSERT INTO `lang_definitions` VALUES (5288, 4117, 3, 'Genitourinario');
INSERT INTO `lang_definitions` VALUES (5289, 4121, 3, 'Alemán');
INSERT INTO `lang_definitions` VALUES (5290, 4126, 3, 'Obtener HL7');
INSERT INTO `lang_definitions` VALUES (5291, 4132, 3, 'Glaucoma');
INSERT INTO `lang_definitions` VALUES (5292, 4133, 3, 'Historia Familiar de Glaucoma');
INSERT INTO `lang_definitions` VALUES (5293, 4135, 3, 'Global');
INSERT INTO `lang_definitions` VALUES (5294, 4138, 3, 'ID Global');
INSERT INTO `lang_definitions` VALUES (5295, 4139, 3, 'Ajustes Globales');
INSERT INTO `lang_definitions` VALUES (5296, 4140, 3, 'Globales');
INSERT INTO `lang_definitions` VALUES (5297, 4141, 3, 'GM/DL');
INSERT INTO `lang_definitions` VALUES (5298, 4142, 3, 'ir');
INSERT INTO `lang_definitions` VALUES (5299, 4144, 3, 'Ir');
INSERT INTO `lang_definitions` VALUES (5300, 4147, 3, 'Ir a');
INSERT INTO `lang_definitions` VALUES (5301, 4157, 3, 'Ir a la semana del');
INSERT INTO `lang_definitions` VALUES (5302, 4158, 3, 'Ir hoy');
INSERT INTO `lang_definitions` VALUES (5303, 4166, 3, 'Grado de la lesión');
INSERT INTO `lang_definitions` VALUES (5304, 4167, 3, 'Grado:');
INSERT INTO `lang_definitions` VALUES (5305, 4168, 3, 'Gramos');
INSERT INTO `lang_definitions` VALUES (5306, 4169, 3, 'Suma total');
INSERT INTO `lang_definitions` VALUES (5307, 4170, 3, 'Sumas totales');
INSERT INTO `lang_definitions` VALUES (5308, 4173, 3, 'Posibilidad de gráfico');
INSERT INTO `lang_definitions` VALUES (5309, 4175, 3, 'Mayor que');
INSERT INTO `lang_definitions` VALUES (5310, 4176, 3, 'Mayor que o Igual a');
INSERT INTO `lang_definitions` VALUES (5311, 4177, 3, 'Griego');
INSERT INTO `lang_definitions` VALUES (5312, 4180, 3, 'Grupo');
INSERT INTO `lang_definitions` VALUES (5313, 4197, 3, 'Nombre de Grupo');
INSERT INTO `lang_definitions` VALUES (5314, 4198, 3, 'Los nombres de los grupos no pueden quedar en blanco');
INSERT INTO `lang_definitions` VALUES (5315, 4199, 3, 'Los nombres de los grupos no pueden iniciar con números');
INSERT INTO `lang_definitions` VALUES (5316, 4200, 3, 'Los nombres de grupo no pueden comenzar con números.');
INSERT INTO `lang_definitions` VALUES (5317, 4201, 3, 'Número de grupo');
INSERT INTO `lang_definitions` VALUES (5318, 4203, 3, 'Grupo de pago');
INSERT INTO `lang_definitions` VALUES (5319, 4209, 3, 'Grupo:');
INSERT INTO `lang_definitions` VALUES (5320, 4210, 3, 'Nombre del grupo');
INSERT INTO `lang_definitions` VALUES (5321, 4213, 3, 'Controles de grupos y accesos');
INSERT INTO `lang_definitions` VALUES (5322, 4214, 3, 'Gráfico de Crecimiento');
INSERT INTO `lang_definitions` VALUES (5323, 4215, 3, 'Gráfico de Crecimiento');
INSERT INTO `lang_definitions` VALUES (5324, 4216, 3, 'gtts (gotas)');
INSERT INTO `lang_definitions` VALUES (5325, 4217, 3, 'Guamés');
INSERT INTO `lang_definitions` VALUES (5326, 4222, 3, 'Nombre del tutor');
INSERT INTO `lang_definitions` VALUES (5327, 4227, 3, 'Examen ginecológico');
INSERT INTO `lang_definitions` VALUES (5328, 4228, 3, 'h');
INSERT INTO `lang_definitions` VALUES (5329, 4230, 3, 'h.s.');
INSERT INTO `lang_definitions` VALUES (5330, 4231, 3, 'H/O Hepatitis');
INSERT INTO `lang_definitions` VALUES (5331, 4232, 3, 'se ha suprimido con éxito. Cualquier sub-categorías si fueron trasladados abajo');
INSERT INTO `lang_definitions` VALUES (5332, 4233, 3, 'Hematoma/moratón');
INSERT INTO `lang_definitions` VALUES (5333, 4234, 3, 'HAI Estado');
INSERT INTO `lang_definitions` VALUES (5334, 4237, 3, 'manos + dedos');
INSERT INTO `lang_definitions` VALUES (5335, 4238, 3, 'Problemas de manos');
INSERT INTO `lang_definitions` VALUES (5336, 4243, 3, 'Disco Duro');
INSERT INTO `lang_definitions` VALUES (5337, 4244, 3, 'Dificultad sin');
INSERT INTO `lang_definitions` VALUES (5338, 4245, 3, 'se ha ligado para visitar');
INSERT INTO `lang_definitions` VALUES (5339, 4246, 3, 'ha expirado');
INSERT INTO `lang_definitions` VALUES (5340, 4247, 3, 'Función Hash');
INSERT INTO `lang_definitions` VALUES (5341, 4248, 3, 'No existe hash para este fichero. Un nuevo hash será generado.');
INSERT INTO `lang_definitions` VALUES (5342, 4249, 3, 'Hash no coincide. La integridad de datos se ha visto comprometida.');
INSERT INTO `lang_definitions` VALUES (5343, 4251, 3, 'Hawaiano');
INSERT INTO `lang_definitions` VALUES (5344, 4252, 3, 'Actividades peligrosas');
INSERT INTO `lang_definitions` VALUES (5345, 4253, 3, 'Actividades peligrosas');
INSERT INTO `lang_definitions` VALUES (5346, 4257, 3, 'Margen izquierdo de HCFA en puntos');
INSERT INTO `lang_definitions` VALUES (5347, 4258, 3, 'Márgenes de HCFA');
INSERT INTO `lang_definitions` VALUES (5348, 4259, 3, 'Margen superior en puntos de HCFA');
INSERT INTO `lang_definitions` VALUES (5349, 4260, 3, 'Procedimiento/Servicio HCPCS');
INSERT INTO `lang_definitions` VALUES (5350, 4263, 3, 'PostCalendar');
INSERT INTO `lang_definitions` VALUES (5351, 4264, 3, 'Cabeza');
INSERT INTO `lang_definitions` VALUES (5352, 4265, 3, 'Jefe Circ');
INSERT INTO `lang_definitions` VALUES (5353, 4266, 3, 'Circunferencia de la cabeza');
INSERT INTO `lang_definitions` VALUES (5354, 4267, 3, 'Dolor de cabeza');
INSERT INTO `lang_definitions` VALUES (5355, 4268, 3, 'Dolores de cabeza');
INSERT INTO `lang_definitions` VALUES (5356, 4270, 3, 'Operaciones de atención médica');
INSERT INTO `lang_definitions` VALUES (5357, 4271, 3, 'Operaciones de Atención Médica');
INSERT INTO `lang_definitions` VALUES (5358, 4273, 3, 'Centro de salud/clínica');
INSERT INTO `lang_definitions` VALUES (5359, 4276, 3, 'Organización para el mantenimiento de la salud');
INSERT INTO `lang_definitions` VALUES (5360, 4277, 3, 'Riesgo de Seguro médico de la organización de mantenimiento de salud (HMO)');
INSERT INTO `lang_definitions` VALUES (5361, 4278, 3, 'Pérdida de Oído');
INSERT INTO `lang_definitions` VALUES (5362, 4279, 3, 'Ataque al Corazón');
INSERT INTO `lang_definitions` VALUES (5363, 4280, 3, 'Enfermedad del corazón');
INSERT INTO `lang_definitions` VALUES (5364, 4281, 3, 'Fallo cardiaco');
INSERT INTO `lang_definitions` VALUES (5365, 4282, 3, 'Problema del Corazón');
INSERT INTO `lang_definitions` VALUES (5366, 4283, 3, 'Problemas de corazón');
INSERT INTO `lang_definitions` VALUES (5367, 4284, 3, 'Cirugía del Corazón');
INSERT INTO `lang_definitions` VALUES (5368, 4285, 3, 'Transplante de corazón');
INSERT INTO `lang_definitions` VALUES (5369, 4286, 3, 'CORAZÓN:');
INSERT INTO `lang_definitions` VALUES (5370, 4287, 3, 'Ardor de estómago');
INSERT INTO `lang_definitions` VALUES (5371, 4288, 3, 'Calor o Frío');
INSERT INTO `lang_definitions` VALUES (5372, 4289, 3, 'Calor o Frío');
INSERT INTO `lang_definitions` VALUES (5373, 4291, 3, 'Hebreo');
INSERT INTO `lang_definitions` VALUES (5374, 4293, 3, 'HEENT');
INSERT INTO `lang_definitions` VALUES (5375, 4294, 3, 'Altura');
INSERT INTO `lang_definitions` VALUES (5376, 4296, 3, 'Ayuda');
INSERT INTO `lang_definitions` VALUES (5377, 4297, 3, 'ayuda');
INSERT INTO `lang_definitions` VALUES (5378, 4299, 3, 'Hematemesis');
INSERT INTO `lang_definitions` VALUES (5379, 4300, 3, 'Hematoquecia');
INSERT INTO `lang_definitions` VALUES (5380, 4301, 3, 'Hematológico');
INSERT INTO `lang_definitions` VALUES (5381, 4302, 3, 'Hematuria');
INSERT INTO `lang_definitions` VALUES (5382, 4303, 3, 'Hemoglobina');
INSERT INTO `lang_definitions` VALUES (5383, 4304, 3, 'Hemoglobina A1C');
INSERT INTO `lang_definitions` VALUES (5384, 4305, 3, 'Hemoptisis');
INSERT INTO `lang_definitions` VALUES (5385, 4306, 3, 'Hepatitis');
INSERT INTO `lang_definitions` VALUES (5386, 4307, 3, 'Hepatitis A 1');
INSERT INTO `lang_definitions` VALUES (5387, 4308, 3, 'Hepatitis A 2');
INSERT INTO `lang_definitions` VALUES (5388, 4309, 3, 'Hepatitis B 1');
INSERT INTO `lang_definitions` VALUES (5389, 4310, 3, 'Hepatitis B 2');
INSERT INTO `lang_definitions` VALUES (5390, 4311, 3, 'Hepatitis B 3');
INSERT INTO `lang_definitions` VALUES (5391, 4312, 3, 'aqui');
INSERT INTO `lang_definitions` VALUES (5392, 4315, 3, 'Reparación de la hernia');
INSERT INTO `lang_definitions` VALUES (5393, 4316, 3, 'disco herniado');
INSERT INTO `lang_definitions` VALUES (5394, 4317, 3, 'Herpes');
INSERT INTO `lang_definitions` VALUES (5395, 4320, 3, 'Vacilación');
INSERT INTO `lang_definitions` VALUES (5396, 4321, 3, 'Ey, tú. has estado aquí para');
INSERT INTO `lang_definitions` VALUES (5397, 4322, 3, 'Hib 1');
INSERT INTO `lang_definitions` VALUES (5398, 4323, 3, 'Hib 2');
INSERT INTO `lang_definitions` VALUES (5399, 4324, 3, 'Hib 3');
INSERT INTO `lang_definitions` VALUES (5400, 4325, 3, 'Hib 4');
INSERT INTO `lang_definitions` VALUES (5401, 4326, 3, 'Oculto');
INSERT INTO `lang_definitions` VALUES (5402, 4327, 3, 'Administración de eventos ocultos');
INSERT INTO `lang_definitions` VALUES (5403, 4328, 3, 'Ocultar');
INSERT INTO `lang_definitions` VALUES (5404, 4330, 3, 'Ocultar detalles');
INSERT INTO `lang_definitions` VALUES (5405, 4332, 3, 'Ocultar Opciones Encriptación/Desencriptación en Documento de Gestión');
INSERT INTO `lang_definitions` VALUES (5406, 4334, 3, 'Ocultar Menú');
INSERT INTO `lang_definitions` VALUES (5407, 4336, 3, 'Ocultar avisos');
INSERT INTO `lang_definitions` VALUES (5408, 4338, 3, 'Ocultar/Mostrar Columnas');
INSERT INTO `lang_definitions` VALUES (5409, 4340, 3, 'Alto');
INSERT INTO `lang_definitions` VALUES (5410, 4342, 3, 'Presión Sanguínea Alta');
INSERT INTO `lang_definitions` VALUES (5411, 4343, 3, 'Indú');
INSERT INTO `lang_definitions` VALUES (5412, 4344, 3, 'Cadera + ingle');
INSERT INTO `lang_definitions` VALUES (5413, 4345, 3, 'Cadera y ingle');
INSERT INTO `lang_definitions` VALUES (5414, 4346, 3, 'Problemas de cadera');
INSERT INTO `lang_definitions` VALUES (5415, 4347, 3, 'Reemplazo de Cadera');
INSERT INTO `lang_definitions` VALUES (5416, 4349, 3, 'Aviso Recibido de HIPPA');
INSERT INTO `lang_definitions` VALUES (5417, 4351, 3, 'Hirsutismo/Estrías');
INSERT INTO `lang_definitions` VALUES (5418, 4352, 3, 'Hispano');
INSERT INTO `lang_definitions` VALUES (5419, 4353, 3, 'Hispano - Otro (Nacido en USA)');
INSERT INTO `lang_definitions` VALUES (5420, 4354, 3, 'Hispano - Otro (Nacido fuera de USA)');
INSERT INTO `lang_definitions` VALUES (5421, 4355, 3, 'Hispano o Latino');
INSERT INTO `lang_definitions` VALUES (5422, 4357, 3, 'Historia');
INSERT INTO `lang_definitions` VALUES (5423, 4363, 3, 'Historia de Datos');
INSERT INTO `lang_definitions` VALUES (5424, 4364, 3, 'Fecha historia');
INSERT INTO `lang_definitions` VALUES (5425, 4366, 3, 'Historia de Murmullos');
INSERT INTO `lang_definitions` VALUES (5426, 4367, 3, 'Historia no autorizada');
INSERT INTO `lang_definitions` VALUES (5427, 4368, 3, 'Historia de los Murmullos de Corazón');
INSERT INTO `lang_definitions` VALUES (5428, 4372, 3, 'Hits');
INSERT INTO `lang_definitions` VALUES (5429, 4373, 3, 'HIV');
INSERT INTO `lang_definitions` VALUES (5430, 4383, 3, 'Visor HL7');
INSERT INTO `lang_definitions` VALUES (5431, 4385, 3, 'HMO/L');
INSERT INTO `lang_definitions` VALUES (5432, 4386, 3, 'Hmong');
INSERT INTO `lang_definitions` VALUES (5433, 4387, 3, 'Mantener pulsado [Ctrl] para múltiples selecciones o desmarcados');
INSERT INTO `lang_definitions` VALUES (5434, 4389, 3, 'Mantener pulsado Ctrl para seleccionar múltiples elementos');
INSERT INTO `lang_definitions` VALUES (5435, 4390, 3, 'Mantenga presionada la tecla CTRL para seleccionar varios escuadrones');
INSERT INTO `lang_definitions` VALUES (5436, 4392, 3, 'Inicio');
INSERT INTO `lang_definitions` VALUES (5437, 4393, 3, 'Teléfono de casa');
INSERT INTO `lang_definitions` VALUES (5438, 4394, 3, 'Número de Teléfono de Casa');
INSERT INTO `lang_definitions` VALUES (5439, 4396, 3, 'Sin hogar o similares?');
INSERT INTO `lang_definitions` VALUES (5440, 4398, 3, 'Sin hogar, etc.');
INSERT INTO `lang_definitions` VALUES (5441, 4399, 3, 'Sin hogar, etc');
INSERT INTO `lang_definitions` VALUES (5442, 4408, 3, 'Nombre de Huesped');
INSERT INTO `lang_definitions` VALUES (5443, 4409, 3, 'El nombre del huesped no puede estar vacio');
INSERT INTO `lang_definitions` VALUES (5444, 4411, 3, 'Hora');
INSERT INTO `lang_definitions` VALUES (5445, 4412, 3, 'Horas');
INSERT INTO `lang_definitions` VALUES (5446, 4415, 3, '¿Cómo ocurrió la lesión?');
INSERT INTO `lang_definitions` VALUES (5447, 4416, 3, '¿Cómo ocurrió la lesión?:');
INSERT INTO `lang_definitions` VALUES (5448, 4417, 3, 'Como nos ha conocido');
INSERT INTO `lang_definitions` VALUES (5449, 4419, 3, '¿Cuántos meses de antelación a la consulta para los próximos eventos?');
INSERT INTO `lang_definitions` VALUES (5450, 4426, 3, 'HPI:');
INSERT INTO `lang_definitions` VALUES (5451, 4428, 3, 'Altura');
INSERT INTO `lang_definitions` VALUES (5452, 4429, 3, 'HTML');
INSERT INTO `lang_definitions` VALUES (5453, 4433, 3, 'Vínculo Https segurizado para el soporte OpenEMR LLC Laboratorio de intercambio de sevicio.');
INSERT INTO `lang_definitions` VALUES (5454, 4435, 3, 'Húngaro');
INSERT INTO `lang_definitions` VALUES (5455, 4436, 3, 'Hylafax Directorio');
INSERT INTO `lang_definitions` VALUES (5456, 4437, 3, 'Hylafax Commando Enscript');
INSERT INTO `lang_definitions` VALUES (5457, 4438, 3, 'Hylafax Servidor');
INSERT INTO `lang_definitions` VALUES (5458, 4439, 3, 'Hylafax Servidor Hostname');
INSERT INTO `lang_definitions` VALUES (5459, 4440, 3, 'Hiperactivo');
INSERT INTO `lang_definitions` VALUES (5460, 4442, 3, 'Hipertensión');
INSERT INTO `lang_definitions` VALUES (5461, 4443, 3, 'Hipertensión: Medida de presión arterial');
INSERT INTO `lang_definitions` VALUES (5462, 4444, 3, 'Hipertensión: Medida de presión arterial (GCC)');
INSERT INTO `lang_definitions` VALUES (5463, 4445, 3, 'Hipertiroidismo');
INSERT INTO `lang_definitions` VALUES (5464, 4447, 3, 'Hipotiroidismo');
INSERT INTO `lang_definitions` VALUES (5465, 4450, 3, 'Histerectomía');
INSERT INTO `lang_definitions` VALUES (5466, 4451, 3, 'I');
INSERT INTO `lang_definitions` VALUES (5467, 4452, 3, 'Estoy ocupado durante este periodo.');
INSERT INTO `lang_definitions` VALUES (5468, 4453, 3, 'No tengo permiso para leer');
INSERT INTO `lang_definitions` VALUES (5469, 4457, 3, 'CIE');
INSERT INTO `lang_definitions` VALUES (5470, 4458, 3, 'Diagnóstico ICD10');
INSERT INTO `lang_definitions` VALUES (5471, 4459, 3, 'Procedimiento/Servicio ICD10');
INSERT INTO `lang_definitions` VALUES (5472, 4460, 3, 'CIE9');
INSERT INTO `lang_definitions` VALUES (5473, 4461, 3, 'Diagnóstico ICD9');
INSERT INTO `lang_definitions` VALUES (5474, 4462, 3, 'Procedimiento/Servicio ICD9');
INSERT INTO `lang_definitions` VALUES (5475, 4467, 3, 'Nº Identificación');
INSERT INTO `lang_definitions` VALUES (5476, 4469, 3, 'Id');
INSERT INTO `lang_definitions` VALUES (5477, 4471, 3, 'La ID no puede quedar en blanco');
INSERT INTO `lang_definitions` VALUES (5478, 4472, 3, 'Tarjeta ID');
INSERT INTO `lang_definitions` VALUES (5479, 4475, 3, 'IDays');
INSERT INTO `lang_definitions` VALUES (5480, 4476, 3, 'identificado como');
INSERT INTO `lang_definitions` VALUES (5481, 4477, 3, 'Identificador (una palabra)');
INSERT INTO `lang_definitions` VALUES (5482, 4479, 3, 'Tiempo de espera inactivo en segundos');
INSERT INTO `lang_definitions` VALUES (5483, 4487, 3, 'Si todos los datos para todas las columnas están completos para este formulario');
INSERT INTO `lang_definitions` VALUES (5484, 4489, 3, 'Si la justificación de facturación se utiliza introduzca el nombre del código de tipo de diagnóstico.');
INSERT INTO `lang_definitions` VALUES (5485, 4493, 3, 'Si es introducido, seleccione solamente aquel que ha tenido este servicio');
INSERT INTO `lang_definitions` VALUES (5486, 4495, 3, 'Si el nombre, apellido de cualquier parte o apellido, Nombre');
INSERT INTO `lang_definitions` VALUES (5487, 4500, 3, 'Si pagando por');
INSERT INTO `lang_definitions` VALUES (5488, 4501, 3, 'Si la persona ha fallecido, introducir la fecha de la muerte.');
INSERT INTO `lang_definitions` VALUES (5489, 4505, 3, 'Si usa SMTP, nombre del servidor host o la dirección IP.');
INSERT INTO `lang_definitions` VALUES (5490, 4506, 3, 'Si usa SMTP, puerto TCP del servidor (normalmente 25).');
INSERT INTO `lang_definitions` VALUES (5491, 4533, 3, 'Si no tiene trabajo, poner Estudiante');
INSERT INTO `lang_definitions` VALUES (5492, 4542, 3, 'Si cambia el rol de la ePrescripción de receta electrónica, puede afectar al flujo de la ePrescripción. Frente a cualquier dificultad, contacte con su prescriptor de ePrescripción.');
INSERT INTO `lang_definitions` VALUES (5493, 4561, 3, 'Si ha elegido adjuntar las remesas electrónicas, entonces la ventana de búsqueda se vuelve a mostrar con las facturas correspondientes al fichero X12. Puede hacer click en cualquiera de estos números de factura (como se describe a continuación) si desea hacer las correcciones antes de enviar la remesa. Para aplicar los cambios, haga click en el botón de procesar ficheros ERA en la parte inferior de la pantalla. Esto generará una nueva ventana con un informe detallado.');
INSERT INTO `lang_definitions` VALUES (5494, 4564, 3, 'Si ha introducido una Fecha de Pago en la página de búsqueda, esto sobreescribirá la fecha de contabilización de los pagos y ajustes que de otro modo son tomados del fichero X12. Esto puede ser útil para los informes, si usted quiere que sus informes de recetas usen su fecha en lugar que la de proceso de la Sociedad Médica. Recuerde que esto también afectará a las fechas de pagos anteriores y a los ajustes que se ponen en reclamaciones secundarias.');
INSERT INTO `lang_definitions` VALUES (5495, 4578, 3, 'Si quiere cambiar tipos de datos, o añadir filas o columnas');
INSERT INTO `lang_definitions` VALUES (5496, 4579, 3, 'Si quiere actualizar la base de datos, coloque el fichero comprimido de base de datos en el siguiente directorio');
INSERT INTO `lang_definitions` VALUES (5497, 4582, 3, 'Desconocido');
INSERT INTO `lang_definitions` VALUES (5498, 4584, 3, 'Enfermedad');
INSERT INTO `lang_definitions` VALUES (5499, 4585, 3, 'IM');
INSERT INTO `lang_definitions` VALUES (5500, 4591, 3, 'Servicio de imágenes');
INSERT INTO `lang_definitions` VALUES (5501, 4593, 3, 'Vacunación');
INSERT INTO `lang_definitions` VALUES (5502, 4595, 3, 'Código Vacunación');
INSERT INTO `lang_definitions` VALUES (5503, 4597, 3, 'Fecha Vacunación');
INSERT INTO `lang_definitions` VALUES (5504, 4600, 3, 'Número de lote Vacunación');
INSERT INTO `lang_definitions` VALUES (5505, 4601, 3, 'Fabricante de Vacunación');
INSERT INTO `lang_definitions` VALUES (5506, 4606, 3, 'Registro Vacunación');
INSERT INTO `lang_definitions` VALUES (5507, 4610, 3, 'Servicio de Vacunación');
INSERT INTO `lang_definitions` VALUES (5508, 4611, 3, 'Título Vacunación');
INSERT INTO `lang_definitions` VALUES (5509, 4613, 3, 'Vacunaciones');
INSERT INTO `lang_definitions` VALUES (5510, 4615, 3, 'Vacunar');
INSERT INTO `lang_definitions` VALUES (5511, 4616, 3, 'Inmunológicas');
INSERT INTO `lang_definitions` VALUES (5512, 4619, 3, 'Implantes');
INSERT INTO `lang_definitions` VALUES (5513, 4620, 3, 'Importar');
INSERT INTO `lang_definitions` VALUES (5514, 4624, 3, 'Importarr el certificado al buscador');
INSERT INTO `lang_definitions` VALUES (5515, 4625, 3, 'Importar configuración');
INSERT INTO `lang_definitions` VALUES (5516, 4630, 3, 'Importar Paciente');
INSERT INTO `lang_definitions` VALUES (5517, 4631, 3, 'Importar Demográficos del Paciente');
INSERT INTO `lang_definitions` VALUES (5518, 4636, 3, 'Códigos importantes');
INSERT INTO `lang_definitions` VALUES (5519, 4640, 3, 'Importados de Contabilidad');
INSERT INTO `lang_definitions` VALUES (5520, 4646, 3, 'Mejorado');
INSERT INTO `lang_definitions` VALUES (5521, 4648, 3, 'ingreso');
INSERT INTO `lang_definitions` VALUES (5522, 4649, 3, 'ingreso');
INSERT INTO `lang_definitions` VALUES (5523, 4657, 3, 'dentro de cada ojo');
INSERT INTO `lang_definitions` VALUES (5524, 4660, 3, 'en ojo izquierdo');
INSERT INTO `lang_definitions` VALUES (5525, 4661, 3, 'en los agujeros de la nariz');
INSERT INTO `lang_definitions` VALUES (5526, 4662, 3, 'Entrada');
INSERT INTO `lang_definitions` VALUES (5527, 4673, 3, 'en ojo derecho');
INSERT INTO `lang_definitions` VALUES (5528, 4684, 3, 'Dentro de la empresa');
INSERT INTO `lang_definitions` VALUES (5529, 4686, 3, 'Inactivo');
INSERT INTO `lang_definitions` VALUES (5530, 4691, 3, 'Días no activo');
INSERT INTO `lang_definitions` VALUES (5531, 4693, 3, 'Entrada');
INSERT INTO `lang_definitions` VALUES (5532, 4696, 3, 'Incluya checksum');
INSERT INTO `lang_definitions` VALUES (5533, 4697, 3, 'Incluya completado');
INSERT INTO `lang_definitions` VALUES (5534, 4699, 3, 'Incluir los usuarios inactivos');
INSERT INTO `lang_definitions` VALUES (5535, 4700, 3, 'Incluir a un no clasificado');
INSERT INTO `lang_definitions` VALUES (5536, 4701, 3, 'Incluir datos no estructurados');
INSERT INTO `lang_definitions` VALUES (5537, 4702, 3, 'Incluir constantes vitales');
INSERT INTO `lang_definitions` VALUES (5538, 4703, 3, '¿Incluir las constantes vitales?');
INSERT INTO `lang_definitions` VALUES (5539, 4706, 3, 'Inclusión');
INSERT INTO `lang_definitions` VALUES (5540, 4707, 3, 'Ingresos');
INSERT INTO `lang_definitions` VALUES (5541, 4709, 3, 'Incompleto');
INSERT INTO `lang_definitions` VALUES (5542, 4710, 3, 'Tratamiento Aborto incompleto');
INSERT INTO `lang_definitions` VALUES (5543, 4711, 3, 'Incontinencia');
INSERT INTO `lang_definitions` VALUES (5544, 4712, 3, 'Incorporar resultados clínicos del test de laboratorio al certificado tecnológico EHR como estructura');
INSERT INTO `lang_definitions` VALUES (5545, 4715, 3, 'aumentado:');
INSERT INTO `lang_definitions` VALUES (5546, 4716, 3, 'Seguro de Indemnización');
INSERT INTO `lang_definitions` VALUES (5547, 4719, 3, 'indeterminado');
INSERT INTO `lang_definitions` VALUES (5548, 4720, 3, 'Indio');
INSERT INTO `lang_definitions` VALUES (5549, 4723, 3, 'Indica anormalidad');
INSERT INTO `lang_definitions` VALUES (5550, 4725, 3, 'Indica si esta incidencia está activa');
INSERT INTO `lang_definitions` VALUES (5551, 4727, 3, 'Indicador de uso especializado');
INSERT INTO `lang_definitions` VALUES (5552, 4728, 3, 'Pacientes indigentes');
INSERT INTO `lang_definitions` VALUES (5553, 4729, 3, 'Informe de Pacientes Indigentes');
INSERT INTO `lang_definitions` VALUES (5554, 4730, 3, 'Indigentes');
INSERT INTO `lang_definitions` VALUES (5555, 4735, 3, 'Aborto Inducido');
INSERT INTO `lang_definitions` VALUES (5556, 4737, 3, 'Ilegible');
INSERT INTO `lang_definitions` VALUES (5557, 4738, 3, 'Infección/abceso');
INSERT INTO `lang_definitions` VALUES (5558, 4739, 3, 'Infecciones');
INSERT INTO `lang_definitions` VALUES (5559, 4740, 3, 'Consejo Infertilidad');
INSERT INTO `lang_definitions` VALUES (5560, 4741, 3, 'Infertilidad');
INSERT INTO `lang_definitions` VALUES (5561, 4742, 3, 'Gripe 1');
INSERT INTO `lang_definitions` VALUES (5562, 4743, 3, 'Gripe 2');
INSERT INTO `lang_definitions` VALUES (5563, 4744, 3, 'Vacunación gripe p/ pacientes may.50 años');
INSERT INTO `lang_definitions` VALUES (5564, 4745, 3, 'Vacunación gripe p/ pacientes may.50 años (GCC)');
INSERT INTO `lang_definitions` VALUES (5565, 4746, 3, 'Vacuna gripe');
INSERT INTO `lang_definitions` VALUES (5566, 4747, 3, 'Información');
INSERT INTO `lang_definitions` VALUES (5567, 4748, 3, 'Información de ensayo 1');
INSERT INTO `lang_definitions` VALUES (5568, 4749, 3, 'Información de ensayo 2');
INSERT INTO `lang_definitions` VALUES (5569, 4750, 3, 'Información de ensayo 3');
INSERT INTO `lang_definitions` VALUES (5570, 4751, 3, 'Información de ensayo 4');
INSERT INTO `lang_definitions` VALUES (5571, 4752, 3, 'Información de ensayo 5');
INSERT INTO `lang_definitions` VALUES (5572, 4753, 3, 'Información de ensayo 6');
INSERT INTO `lang_definitions` VALUES (5573, 4758, 3, 'Inhalaciones');
INSERT INTO `lang_definitions` VALUES (5574, 4760, 3, 'Inhalaciones');
INSERT INTO `lang_definitions` VALUES (5575, 4763, 3, 'Usuario Inicial');
INSERT INTO `lang_definitions` VALUES (5576, 4765, 3, 'Lesión/Rehabilitación');
INSERT INTO `lang_definitions` VALUES (5577, 4766, 3, 'Inyectables');
INSERT INTO `lang_definitions` VALUES (5578, 4767, 3, 'Inyeccion');
INSERT INTO `lang_definitions` VALUES (5579, 4768, 3, 'Parte del cuerpo lesionada');
INSERT INTO `lang_definitions` VALUES (5580, 4769, 3, 'Herido a Fuera');
INSERT INTO `lang_definitions` VALUES (5581, 4770, 3, 'Herido');
INSERT INTO `lang_definitions` VALUES (5582, 4771, 3, 'Mecanismo de lesión');
INSERT INTO `lang_definitions` VALUES (5583, 4772, 3, 'Informe General de lesión');
INSERT INTO `lang_definitions` VALUES (5584, 4773, 3, 'Vigilancia de Lesiones');
INSERT INTO `lang_definitions` VALUES (5585, 4774, 3, 'Tipo de lesión');
INSERT INTO `lang_definitions` VALUES (5586, 4775, 3, 'Relacionado a lesion/enfermedad');
INSERT INTO `lang_definitions` VALUES (5587, 4780, 3, 'Campos de entrada');
INSERT INTO `lang_definitions` VALUES (5588, 4781, 3, 'Tiempo Protrombina');
INSERT INTO `lang_definitions` VALUES (5589, 4782, 3, 'Ins 1');
INSERT INTO `lang_definitions` VALUES (5590, 4783, 3, 'Ins 2 o Ins 3');
INSERT INTO `lang_definitions` VALUES (5591, 4785, 3, 'Ajuste Seg');
INSERT INTO `lang_definitions` VALUES (5592, 4786, 3, 'Ins bundling');
INSERT INTO `lang_definitions` VALUES (5593, 4787, 3, 'Código Aseguradora');
INSERT INTO `lang_definitions` VALUES (5594, 4790, 3, 'Sobre pago Seg');
INSERT INTO `lang_definitions` VALUES (5595, 4792, 3, 'Reembolso Seg');
INSERT INTO `lang_definitions` VALUES (5596, 4793, 3, 'Resumen Seg');
INSERT INTO `lang_definitions` VALUES (5597, 4795, 3, 'Seg1');
INSERT INTO `lang_definitions` VALUES (5598, 4796, 3, 'Seg2');
INSERT INTO `lang_definitions` VALUES (5599, 4797, 3, 'Seg3');
INSERT INTO `lang_definitions` VALUES (5600, 4799, 3, 'Insertar fallido:');
INSERT INTO `lang_definitions` VALUES (5601, 4803, 3, 'Introduzca los eventos antiguos en tablas');
INSERT INTO `lang_definitions` VALUES (5602, 4809, 3, 'Insomnio');
INSERT INTO `lang_definitions` VALUES (5603, 4811, 3, 'Inspección');
INSERT INTO `lang_definitions` VALUES (5604, 4812, 3, 'Inestabilidad/subluxación');
INSERT INTO `lang_definitions` VALUES (5605, 4813, 3, 'INSTALAR');
INSERT INTO `lang_definitions` VALUES (5606, 4814, 3, 'Instalar');
INSERT INTO `lang_definitions` VALUES (5607, 4816, 3, 'Instalar DB');
INSERT INTO `lang_definitions` VALUES (5608, 4821, 3, 'Versión instalada');
INSERT INTO `lang_definitions` VALUES (5609, 4823, 3, 'instrucciones');
INSERT INTO `lang_definitions` VALUES (5610, 4824, 3, 'Instrucción');
INSERT INTO `lang_definitions` VALUES (5611, 4826, 3, 'instrucciones:');
INSERT INTO `lang_definitions` VALUES (5612, 4828, 3, 'Inventario insuficiente para ID producto');
INSERT INTO `lang_definitions` VALUES (5613, 4829, 3, 'Diabetes insulino dependente');
INSERT INTO `lang_definitions` VALUES (5614, 4830, 3, 'Seguro');
INSERT INTO `lang_definitions` VALUES (5615, 4831, 3, 'Seguro');
INSERT INTO `lang_definitions` VALUES (5616, 4835, 3, 'Saldo del seguro');
INSERT INTO `lang_definitions` VALUES (5617, 4837, 3, 'Sociedad Médica');
INSERT INTO `lang_definitions` VALUES (5618, 4838, 3, 'Sociedades Médicas');
INSERT INTO `lang_definitions` VALUES (5619, 4839, 3, 'Sociedad Médica');
INSERT INTO `lang_definitions` VALUES (5620, 4840, 3, 'Sociedad Médica Buscar/Añadir');
INSERT INTO `lang_definitions` VALUES (5621, 4842, 3, 'Data Seguro');
INSERT INTO `lang_definitions` VALUES (5622, 4845, 3, 'Información del Seguro en fichero');
INSERT INTO `lang_definitions` VALUES (5623, 4847, 3, 'Num Seguro');
INSERT INTO `lang_definitions` VALUES (5624, 4848, 3, 'Pago Aseguradora');
INSERT INTO `lang_definitions` VALUES (5625, 4850, 3, 'Proveedor de Seguro');
INSERT INTO `lang_definitions` VALUES (5626, 4854, 3, 'Asegurado');
INSERT INTO `lang_definitions` VALUES (5627, 4855, 3, 'Conclusión Ingesta');
INSERT INTO `lang_definitions` VALUES (5628, 4856, 3, 'Fecha de Ingesta');
INSERT INTO `lang_definitions` VALUES (5629, 4859, 3, 'Declinación intelectual');
INSERT INTO `lang_definitions` VALUES (5630, 4870, 3, 'Error interno - no se seleccionó ningunas páginas!');
INSERT INTO `lang_definitions` VALUES (5631, 4871, 3, 'Error interno - Nº Identificación del paciente no proporcionado!');
INSERT INTO `lang_definitions` VALUES (5632, 4872, 3, '¡Error interno al accede al fichero adjunto!');
INSERT INTO `lang_definitions` VALUES (5633, 4874, 3, '¡Error interno!');
INSERT INTO `lang_definitions` VALUES (5634, 4875, 3, 'Error interno, Nº Identificación de medicamento no especificado!');
INSERT INTO `lang_definitions` VALUES (5635, 4877, 3, 'Error interno: reclamación');
INSERT INTO `lang_definitions` VALUES (5636, 4878, 3, 'Error Interno: visita \'');
INSERT INTO `lang_definitions` VALUES (5637, 4879, 3, 'Error interno: pid o visita no existe.');
INSERT INTO `lang_definitions` VALUES (5638, 4880, 3, 'Error interno: no parece haber una visita!');
INSERT INTO `lang_definitions` VALUES (5639, 4881, 3, 'Identificador interno (pid)');
INSERT INTO `lang_definitions` VALUES (5640, 4884, 3, 'Derivaciones Internas');
INSERT INTO `lang_definitions` VALUES (5641, 4885, 3, 'Tiempo de coleccion interno');
INSERT INTO `lang_definitions` VALUES (5642, 4886, 3, 'Deber Internacional');
INSERT INTO `lang_definitions` VALUES (5643, 4888, 3, 'Intérprete');
INSERT INTO `lang_definitions` VALUES (5644, 4889, 3, 'Require Intérprete?');
INSERT INTO `lang_definitions` VALUES (5645, 4890, 3, 'Enfermedad Pulmonar Intersticial');
INSERT INTO `lang_definitions` VALUES (5646, 4891, 3, 'Intervalo');
INSERT INTO `lang_definitions` VALUES (5647, 4894, 3, 'Intervención');
INSERT INTO `lang_definitions` VALUES (5648, 4896, 3, 'Intolerancia');
INSERT INTO `lang_definitions` VALUES (5649, 4899, 3, 'Intramuscularmente');
INSERT INTO `lang_definitions` VALUES (5650, 4902, 3, 'Intravenoso');
INSERT INTO `lang_definitions` VALUES (5651, 4903, 3, 'Introducción');
INSERT INTO `lang_definitions` VALUES (5652, 4906, 3, 'Carácter inválido en');
INSERT INTO `lang_definitions` VALUES (5653, 4914, 3, 'Longitud inválida para');
INSERT INTO `lang_definitions` VALUES (5654, 4915, 3, 'Carácter no-numérico inválido en');
INSERT INTO `lang_definitions` VALUES (5655, 4916, 3, 'Inválido o pagador ausente en fuente para código');
INSERT INTO `lang_definitions` VALUES (5656, 4919, 3, 'Códigos de Servicio Inválidos');
INSERT INTO `lang_definitions` VALUES (5657, 4920, 3, 'Designación de la fuente inválida -');
INSERT INTO `lang_definitions` VALUES (5658, 4923, 3, 'InvAmt');
INSERT INTO `lang_definitions` VALUES (5659, 4924, 3, 'Inventario');
INSERT INTO `lang_definitions` VALUES (5660, 4925, 3, 'Actividad de inventario');
INSERT INTO `lang_definitions` VALUES (5661, 4926, 3, 'Inventario y venta, ambos medicamentos y productos no farmacológicos');
INSERT INTO `lang_definitions` VALUES (5662, 4927, 3, 'Inventario y venta medicamentos sólo');
INSERT INTO `lang_definitions` VALUES (5663, 4928, 3, 'El inventario no está disponible para esta orden.');
INSERT INTO `lang_definitions` VALUES (5664, 4929, 3, 'Lista de Inventario');
INSERT INTO `lang_definitions` VALUES (5665, 4930, 3, 'Inventario Transacciones');
INSERT INTO `lang_definitions` VALUES (5666, 4931, 3, 'Factura');
INSERT INTO `lang_definitions` VALUES (5667, 4932, 3, 'factura');
INSERT INTO `lang_definitions` VALUES (5668, 4934, 3, 'Factura saldo');
INSERT INTO `lang_definitions` VALUES (5669, 4935, 3, 'Factura saldo no puede ser enviado. No hay visita creada.');
INSERT INTO `lang_definitions` VALUES (5670, 4936, 3, 'Fecha de Factura');
INSERT INTO `lang_definitions` VALUES (5671, 4938, 3, 'Factura no tiene fecha');
INSERT INTO `lang_definitions` VALUES (5672, 4939, 3, 'Número Factura');
INSERT INTO `lang_definitions` VALUES (5673, 4940, 3, 'Número Referencia Factura');
INSERT INTO `lang_definitions` VALUES (5674, 4941, 3, 'Número referencia factura, si se usa');
INSERT INTO `lang_definitions` VALUES (5675, 4942, 3, 'Número referencia factura');
INSERT INTO `lang_definitions` VALUES (5676, 4943, 3, 'Número referencia factura');
INSERT INTO `lang_definitions` VALUES (5677, 4945, 3, 'Factura:');
INSERT INTO `lang_definitions` VALUES (5678, 4956, 3, 'Fundación Internacional de Planificación Familiar');
INSERT INTO `lang_definitions` VALUES (5679, 4959, 3, 'Datos para SRH IPPF');
INSERT INTO `lang_definitions` VALUES (5680, 4960, 3, 'Informe de las estadísticas de IPPF');
INSERT INTO `lang_definitions` VALUES (5681, 4961, 3, 'Estado Fundación Internacional de Planificación Familiar');
INSERT INTO `lang_definitions` VALUES (5682, 4962, 3, 'IPV 1');
INSERT INTO `lang_definitions` VALUES (5683, 4963, 3, 'IPV 2');
INSERT INTO `lang_definitions` VALUES (5684, 4964, 3, 'IPV 3');
INSERT INTO `lang_definitions` VALUES (5685, 4965, 3, 'IPV 4');
INSERT INTO `lang_definitions` VALUES (5686, 4968, 3, 'Latido de Corazón Irregular');
INSERT INTO `lang_definitions` VALUES (5687, 4969, 3, 'Irritabilidad');
INSERT INTO `lang_definitions` VALUES (5688, 4970, 3, 'Irritación');
INSERT INTO `lang_definitions` VALUES (5689, 4973, 3, 'es la versión más reciente de la siguiente bbdd');
INSERT INTO `lang_definitions` VALUES (5690, 4975, 3, 'es un campo requerido.');
INSERT INTO `lang_definitions` VALUES (5691, 4976, 3, 'es un nodo de raíz y no puede ser suprimido.');
INSERT INTO `lang_definitions` VALUES (5692, 4977, 3, 'es una extensión de la siguiente base de datos');
INSERT INTO `lang_definitions` VALUES (5693, 4980, 3, 'está mal ubicada o es desconocida');
INSERT INTO `lang_definitions` VALUES (5694, 4981, 3, 'no es una dirección de correo electrónico válida');
INSERT INTO `lang_definitions` VALUES (5695, 4982, 3, 'No está seleccionada');
INSERT INTO `lang_definitions` VALUES (5696, 4983, 3, 'no es válida');
INSERT INTO `lang_definitions` VALUES (5697, 4984, 3, 'no es válido (las fracciones decimales están bien).');
INSERT INTO `lang_definitions` VALUES (5698, 4985, 3, '¿El PHP utiliza el modo a prueba de fallos?');
INSERT INTO `lang_definitions` VALUES (5699, 4986, 3, 'Está seleccionada');
INSERT INTO `lang_definitions` VALUES (5700, 4987, 3, '¿Se traduce el texto del formulario plantilla?');
INSERT INTO `lang_definitions` VALUES (5701, 4988, 3, '¿Se traduce el texto de listas?');
INSERT INTO `lang_definitions` VALUES (5702, 4989, 3, '¿Está encriptado el fichero?');
INSERT INTO `lang_definitions` VALUES (5703, 4991, 3, '¿Este es un tipo de diagnóstico?');
INSERT INTO `lang_definitions` VALUES (5704, 4994, 3, '¿Es un tipo de procedimiento/servicio?');
INSERT INTO `lang_definitions` VALUES (5705, 4995, 3, '¿Está esto activo?');
INSERT INTO `lang_definitions` VALUES (5706, 4996, 3, '¿Este tipo de código está activo?');
INSERT INTO `lang_definitions` VALUES (5707, 4997, 3, '¿Este código se usa en reclamaciones?');
INSERT INTO `lang_definitions` VALUES (5708, 4999, 3, '¿Está verdaderamente bien?');
INSERT INTO `lang_definitions` VALUES (5709, 5000, 3, '¿Es un tipo oculto en la hoja de honorarios?');
INSERT INTO `lang_definitions` VALUES (5710, 5001, 3, '¿Se usa en las tablas sql externas? Si es así, elija el formato.');
INSERT INTO `lang_definitions` VALUES (5711, 5002, 3, 'es muy largo');
INSERT INTO `lang_definitions` VALUES (5712, 5003, 3, 'Código ISO 639-2');
INSERT INTO `lang_definitions` VALUES (5713, 5004, 3, 'Incidencia');
INSERT INTO `lang_definitions` VALUES (5714, 5005, 3, 'incidencia');
INSERT INTO `lang_definitions` VALUES (5715, 5006, 3, 'Fecha Incidencia');
INSERT INTO `lang_definitions` VALUES (5716, 5007, 3, 'Nº Identificación incidencia');
INSERT INTO `lang_definitions` VALUES (5717, 5008, 3, 'Subtipos de Incidencias');
INSERT INTO `lang_definitions` VALUES (5718, 5009, 3, 'Título de incidencia');
INSERT INTO `lang_definitions` VALUES (5719, 5010, 3, 'Tipo de Incidencia');
INSERT INTO `lang_definitions` VALUES (5720, 5011, 3, 'Tipos de Incidencia');
INSERT INTO `lang_definitions` VALUES (5721, 5012, 3, 'Incidencias');
INSERT INTO `lang_definitions` VALUES (5722, 5013, 3, 'Incidencias (Lesiones, Médicas, Alergias)');
INSERT INTO `lang_definitions` VALUES (5723, 5014, 3, 'Incidencias (Lesiones, Médicas, Alergias):');
INSERT INTO `lang_definitions` VALUES (5724, 5016, 3, 'Incidencias y Encuentros');
INSERT INTO `lang_definitions` VALUES (5725, 5017, 3, 'Incidencias y Encuentros de');
INSERT INTO `lang_definitions` VALUES (5726, 5022, 3, 'Incidencias no autorizadas');
INSERT INTO `lang_definitions` VALUES (5727, 5023, 3, 'Sección de Incidencias');
INSERT INTO `lang_definitions` VALUES (5728, 5077, 3, 'Italiano');
INSERT INTO `lang_definitions` VALUES (5729, 5078, 3, 'Artículo');
INSERT INTO `lang_definitions` VALUES (5730, 5079, 3, 'Artículo');
INSERT INTO `lang_definitions` VALUES (5731, 5081, 3, 'temas');
INSERT INTO `lang_definitions` VALUES (5732, 5082, 3, 'La carga de artículos falló');
INSERT INTO `lang_definitions` VALUES (5733, 5083, 3, 'IU/L');
INSERT INTO `lang_definitions` VALUES (5734, 5084, 3, 'IUD');
INSERT INTO `lang_definitions` VALUES (5735, 5085, 3, 'IV');
INSERT INTO `lang_definitions` VALUES (5736, 5088, 3, 'Ener');
INSERT INTO `lang_definitions` VALUES (5737, 5089, 3, 'Enero');
INSERT INTO `lang_definitions` VALUES (5738, 5090, 3, 'Japonés');
INSERT INTO `lang_definitions` VALUES (5739, 5091, 3, 'Ictericia');
INSERT INTO `lang_definitions` VALUES (5740, 5093, 3, 'Descripción del trabajo');
INSERT INTO `lang_definitions` VALUES (5741, 5094, 3, 'Nº Identificación del trabajo');
INSERT INTO `lang_definitions` VALUES (5742, 5095, 3, 'Dislocaciones de articulaciones');
INSERT INTO `lang_definitions` VALUES (5743, 5096, 3, 'Dolor en las Articulaciones');
INSERT INTO `lang_definitions` VALUES (5744, 5097, 3, 'Esguinces de articulaciones');
INSERT INTO `lang_definitions` VALUES (5745, 5098, 3, 'Jul');
INSERT INTO `lang_definitions` VALUES (5746, 5099, 3, 'Julio');
INSERT INTO `lang_definitions` VALUES (5747, 5101, 3, 'Jun');
INSERT INTO `lang_definitions` VALUES (5748, 5102, 3, 'Junio');
INSERT INTO `lang_definitions` VALUES (5749, 5103, 3, 'Justo debajo, revise la información del área azul donde pone sus parámetros de búsqueda. Puede buscar por nombre del paciente, número de gráfico, número de visita o fecha de servicio, o cualquier combinación de éstos. También puede ver todas las facturas, facturas pendientes o impagadas (por el paciente). Click en el botón de búsqueda para realizar la búsqueda.');
INSERT INTO `lang_definitions` VALUES (5750, 5104, 3, 'Solo mío');
INSERT INTO `lang_definitions` VALUES (5751, 5106, 3, 'Justificar');
INSERT INTO `lang_definitions` VALUES (5752, 5109, 3, 'Justificar/Guardar');
INSERT INTO `lang_definitions` VALUES (5753, 5111, 3, 'k, aquí está el resto');
INSERT INTO `lang_definitions` VALUES (5754, 5120, 3, 'Clave');
INSERT INTO `lang_definitions` VALUES (5755, 5124, 3, 'Palabras Claves');
INSERT INTO `lang_definitions` VALUES (5756, 5125, 3, 'kg');
INSERT INTO `lang_definitions` VALUES (5757, 5126, 3, 'kg/m^2');
INSERT INTO `lang_definitions` VALUES (5758, 5128, 3, 'Cáncer de Riñon');
INSERT INTO `lang_definitions` VALUES (5759, 5129, 3, 'Fallo Renal');
INSERT INTO `lang_definitions` VALUES (5760, 5130, 3, 'Infecciones de Riñón');
INSERT INTO `lang_definitions` VALUES (5761, 5131, 3, 'Piedra en el Riñón');
INSERT INTO `lang_definitions` VALUES (5762, 5132, 3, 'Transplante de Riñon');
INSERT INTO `lang_definitions` VALUES (5763, 5138, 3, 'Rodilla');
INSERT INTO `lang_definitions` VALUES (5764, 5139, 3, 'Problemas de la rodilla');
INSERT INTO `lang_definitions` VALUES (5765, 5140, 3, 'Reemplazo de Rodilla');
INSERT INTO `lang_definitions` VALUES (5766, 5143, 3, 'Coreano');
INSERT INTO `lang_definitions` VALUES (5767, 5147, 3, 'Laboratorio');
INSERT INTO `lang_definitions` VALUES (5768, 5149, 3, 'Sitio Web del Laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (5769, 5150, 3, 'Nº Identificación Laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (5770, 5151, 3, 'Nº Identificación ficha Laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (5771, 5155, 3, 'Consulta de estado de Laboratorio');
INSERT INTO `lang_definitions` VALUES (5772, 5157, 3, 'Informe del Laboratorio');
INSERT INTO `lang_definitions` VALUES (5773, 5158, 3, 'Resultado Laboratorio');
INSERT INTO `lang_definitions` VALUES (5774, 5159, 3, 'Resultados Laboratorio');
INSERT INTO `lang_definitions` VALUES (5775, 5162, 3, 'Informe Resultados Laboratorio');
INSERT INTO `lang_definitions` VALUES (5776, 5163, 3, 'Servicio de laboratorio');
INSERT INTO `lang_definitions` VALUES (5777, 5164, 3, 'Resultados del test de Laboratorio');
INSERT INTO `lang_definitions` VALUES (5778, 5166, 3, 'Etiqueta');
INSERT INTO `lang_definitions` VALUES (5779, 5167, 3, 'Etiqueta no puede estar en blanco');
INSERT INTO `lang_definitions` VALUES (5780, 5168, 3, 'Col etiqueta');
INSERT INTO `lang_definitions` VALUES (5781, 5169, 3, 'Etiqueta para este tipo');
INSERT INTO `lang_definitions` VALUES (5782, 5171, 3, 'EtiquetasColumn debe ser un número entre 1 y 999');
INSERT INTO `lang_definitions` VALUES (5783, 5172, 3, 'Etiquetas');
INSERT INTO `lang_definitions` VALUES (5784, 5176, 3, 'Laboratorio');
INSERT INTO `lang_definitions` VALUES (5785, 5177, 3, 'Laceración/Cond. Piel');
INSERT INTO `lang_definitions` VALUES (5786, 5178, 3, 'Laceración/abrasión');
INSERT INTO `lang_definitions` VALUES (5787, 5183, 3, 'Idioma');
INSERT INTO `lang_definitions` VALUES (5788, 5184, 3, 'Código Idioma');
INSERT INTO `lang_definitions` VALUES (5789, 5185, 3, 'Definición de lenguaje agregada');
INSERT INTO `lang_definitions` VALUES (5790, 5186, 3, 'Herramienta de interfaz de idioma');
INSERT INTO `lang_definitions` VALUES (5791, 5188, 3, 'Lista de lenguajes (escribir, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (5792, 5190, 3, 'Nombre Idioma');
INSERT INTO `lang_definitions` VALUES (5793, 5191, 3, 'Idioma:');
INSERT INTO `lang_definitions` VALUES (5794, 5193, 3, 'Laosiano');
INSERT INTO `lang_definitions` VALUES (5795, 5197, 3, 'Último');
INSERT INTO `lang_definitions` VALUES (5796, 5198, 3, 'Última Actividad Fecha');
INSERT INTO `lang_definitions` VALUES (5797, 5200, 3, 'Última Fecha de Cuenta');
INSERT INTO `lang_definitions` VALUES (5798, 5202, 3, 'Último año calendario');
INSERT INTO `lang_definitions` VALUES (5799, 5206, 3, 'Última visita');
INSERT INTO `lang_definitions` VALUES (5800, 5213, 3, 'Último nivel facturado');
INSERT INTO `lang_definitions` VALUES (5801, 5217, 3, 'Último Mes');
INSERT INTO `lang_definitions` VALUES (5802, 5218, 3, 'Apellido(s)');
INSERT INTO `lang_definitions` VALUES (5803, 5219, 3, 'Apellido(s)');
INSERT INTO `lang_definitions` VALUES (5804, 5224, 3, 'Apellido(s):');
INSERT INTO `lang_definitions` VALUES (5805, 5228, 3, 'Ultima revision');
INSERT INTO `lang_definitions` VALUES (5806, 5230, 3, 'Última guardados');
INSERT INTO `lang_definitions` VALUES (5807, 5236, 3, 'Última actualización por');
INSERT INTO `lang_definitions` VALUES (5808, 5237, 3, 'Ultima verificación el');
INSERT INTO `lang_definitions` VALUES (5809, 5238, 3, 'Última Visita');
INSERT INTO `lang_definitions` VALUES (5810, 5240, 3, 'Recurrencia tardía (2-12 Mes)');
INSERT INTO `lang_definitions` VALUES (5811, 5241, 3, 'Maléolo lateral');
INSERT INTO `lang_definitions` VALUES (5812, 5242, 3, 'Maléolo lateral:');
INSERT INTO `lang_definitions` VALUES (5813, 5243, 3, 'Lateralidad');
INSERT INTO `lang_definitions` VALUES (5814, 5244, 3, 'Lateralidad de este procedimiento si se aplica');
INSERT INTO `lang_definitions` VALUES (5815, 5245, 3, 'desplazados lateralmente PMI:');
INSERT INTO `lang_definitions` VALUES (5816, 5248, 3, 'Últimos resultados únicamente');
INSERT INTO `lang_definitions` VALUES (5817, 5249, 3, 'Última Visita o Consula');
INSERT INTO `lang_definitions` VALUES (5818, 5250, 3, 'Latín');
INSERT INTO `lang_definitions` VALUES (5819, 5251, 3, 'Latvio');
INSERT INTO `lang_definitions` VALUES (5820, 5253, 3, 'Firma de Abogados');
INSERT INTO `lang_definitions` VALUES (5821, 5254, 3, 'Abogado');
INSERT INTO `lang_definitions` VALUES (5822, 5255, 3, 'Distribución en pantalla');
INSERT INTO `lang_definitions` VALUES (5823, 5256, 3, 'Distribución (necesita salir y entrar después de haber cambiado esta opción)');
INSERT INTO `lang_definitions` VALUES (5824, 5257, 3, 'de la base');
INSERT INTO `lang_definitions` VALUES (5825, 5259, 3, 'Redactor de Disposición');
INSERT INTO `lang_definitions` VALUES (5826, 5260, 3, 'Diseño de Grupos');
INSERT INTO `lang_definitions` VALUES (5827, 5263, 3, 'Estilo plantilla');
INSERT INTO `lang_definitions` VALUES (5828, 5265, 3, 'Diseño basado en la visita las formas');
INSERT INTO `lang_definitions` VALUES (5829, 5266, 3, 'Disposición');
INSERT INTO `lang_definitions` VALUES (5830, 5267, 3, 'libra');
INSERT INTO `lang_definitions` VALUES (5831, 5270, 3, 'libra');
INSERT INTO `lang_definitions` VALUES (5832, 5275, 3, 'Colesterol LDL');
INSERT INTO `lang_definitions` VALUES (5833, 5277, 3, 'dejar en blanco si sigue activo');
INSERT INTO `lang_definitions` VALUES (5834, 5278, 3, 'Dejar en blanco para mantener el nombre de fichero original');
INSERT INTO `lang_definitions` VALUES (5835, 5279, 3, 'Deje en blanco para no cambiar la contraseña');
INSERT INTO `lang_definitions` VALUES (5836, 5284, 3, 'Dejar mensaje Con');
INSERT INTO `lang_definitions` VALUES (5837, 5286, 3, 'Salir del Formulario');
INSERT INTO `lang_definitions` VALUES (5838, 5287, 3, 'Dejando la contraseña en blanco no se encriptará el documento');
INSERT INTO `lang_definitions` VALUES (5839, 5290, 3, 'Izquierda');
INSERT INTO `lang_definitions` VALUES (5840, 5291, 3, 'Brazo izquierdo');
INSERT INTO `lang_definitions` VALUES (5841, 5292, 3, 'Deltoide Izquierdo');
INSERT INTO `lang_definitions` VALUES (5842, 5293, 3, 'Oído izquierdo');
INSERT INTO `lang_definitions` VALUES (5843, 5294, 3, 'oreja izquierda');
INSERT INTO `lang_definitions` VALUES (5844, 5295, 3, 'Glúteo Medio Izquierdo');
INSERT INTO `lang_definitions` VALUES (5845, 5296, 3, 'Lente Izquierdo');
INSERT INTO `lang_definitions` VALUES (5846, 5298, 3, 'Margen Izquierdo (mm)');
INSERT INTO `lang_definitions` VALUES (5847, 5302, 3, 'Izquierda:');
INSERT INTO `lang_definitions` VALUES (5848, 5303, 3, 'Izquierda:');
INSERT INTO `lang_definitions` VALUES (5849, 5304, 3, 'Dolor de Pierna/Calambres');
INSERT INTO `lang_definitions` VALUES (5850, 5305, 3, 'Legal');
INSERT INTO `lang_definitions` VALUES (5851, 5307, 3, 'Tamaño papel Legal');
INSERT INTO `lang_definitions` VALUES (5852, 5308, 3, 'Leyenda:');
INSERT INTO `lang_definitions` VALUES (5853, 5309, 3, 'Longitud');
INSERT INTO `lang_definitions` VALUES (5854, 5310, 3, 'Longitud del modificador, 0 si no hay');
INSERT INTO `lang_definitions` VALUES (5855, 5316, 3, 'Menor que');
INSERT INTO `lang_definitions` VALUES (5856, 5317, 3, 'Menor que o Igual a');
INSERT INTO `lang_definitions` VALUES (5857, 5318, 3, 'Menos la información privada (escribir, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (5858, 5323, 3, 'Carta');
INSERT INTO `lang_definitions` VALUES (5859, 5324, 3, 'Carta');
INSERT INTO `lang_definitions` VALUES (5860, 5325, 3, 'Tamaño papel Carta');
INSERT INTO `lang_definitions` VALUES (5861, 5326, 3, 'Papelería membretada que el médico firma');
INSERT INTO `lang_definitions` VALUES (5862, 5327, 3, 'Papelería membretada que el paciente firma');
INSERT INTO `lang_definitions` VALUES (5863, 5330, 3, 'Nivel de urgencia');
INSERT INTO `lang_definitions` VALUES (5864, 5333, 3, 'Responsabilidad');
INSERT INTO `lang_definitions` VALUES (5865, 5334, 3, 'Responsabilidad Médica');
INSERT INTO `lang_definitions` VALUES (5866, 5336, 3, 'Licencia/Nº Id.');
INSERT INTO `lang_definitions` VALUES (5867, 5342, 3, 'Apellido del médico');
INSERT INTO `lang_definitions` VALUES (5868, 5343, 3, 'NºColegiado médico');
INSERT INTO `lang_definitions` VALUES (58