<?php
/**
 * external_data.php
 *
 * @package   OpenEMR
 * @link      http://www.open-emr.org
 * @author    Jacob T Paul <jacob@zhservices.com>
 * @author    Vinish K <vinish@zhservices.com>
 * @author    Brady Miller <brady.g.miller@gmail.com>
 * @copyright Copyright (c) 2015 Z&H Consultancy Services Private Limited <sam@zhservices.com>
 * @copyright Copyright (c) 2018 Brady Miller <brady.g.miller@gmail.com>
 * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3
 */


require_once("../globals.php");
require_once("$srcdir/patient.inc");
require_once($GLOBALS['srcdir'].'/acl.inc');
require_once "$srcdir/options.inc.php";

use OpenEMR\Core\Header;
use OpenEMR\Menu\PatientMenuRole;
use OpenEMR\OeUI\OemrUI;

$records1 = array();
$records2 = array();
?>
<html>
    <head>
        <?php Header::setupHeader();?>
        <title><?php echo xlt('External Data'); ?></title>
        <script>
            $(function() {
                $('.ext-tab-head li').click(function() {
                    $('.ext-tab-head li').removeClass("child-active");
                    $(this).addClass("child-active");
                });
                $('.ext-enc').click(function() {
                    $('.dm-ed-in-4').hide();
                    $('.dm-ed-in-3').show();
                });
                $('.ext-proc').click(function() {
                    $('.dm-ed-in-3').hide();
                    $('.dm-ed-in-4').show();
                });
            });
        </script>
        <style>
            .dm-ed-in-1 {
                height: 35px;
                width: 100%;
                background-color: #E7ECF2;
                border-bottom: thin solid #C0C0C0;
                padding: 5px 0; z-index: 100;
            }
            .dm-ed-in-1 h3 {
                color: rgb(8, 102, 198);
                font-size: 20px; float: left;
                line-height: 0px;
            }
            .dm-ed-in-2 {
                background: url("data:image/png;base64,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");
                width: 32px;
                height: 32px;
                float: left;
                margin:2px 6px 0 6px;background-size: contain;
            }
            .dm-ed-in-4 {
                display: none;
            }
            .dm-ed-in-5 {
                margin-left: 10%;
                margin-top: 3%;
            }
            .dm-ed-in-6 {
                width: 20% !important;
            }
            .dm-ed-in-7 {
                font-size: 12px;
            }
            .dm-ed-in-8 {
                width: 60%;
                margin-left: 10%;
                margin-top: 40px;
                border: 1px solid #CCCCCC;
                text-align:center;
                padding: 30px;
                font-size: 15px;
                font-weight: bold;
                background: #f7f7f7;
            }
            .dm-ed-in-9 {
                line-height:30px;
            }
            ul.ext-tab-head li {
                border-bottom: 2px solid #faffff;
                color: #222222;
                cursor: pointer;
                display: inline-block;
                font-size: 14px;
                margin-bottom: 0;
                padding: 3px 5px;
                text-decoration: none;
            }
            ul.ext-tab-head li.child-active {
                border-bottom: 2px solid #003366;
            }
        </style>
        <script> <?php require_once("$include_root/patient_file/erx_patient_portal_js.php"); // jQuery for popups for eRx and patient portal ?></script>
        <?php
        $arrOeUiSettings = array(
            'heading_title' => xl('External Data'),
            'include_patient_name' => true,
            'expandable' => true,
            'expandable_files' => array("external_data_patient_xpd", "stats_full_patient_xpd", "patient_ledger_patient_xpd"),//all file names need suffix _xpd
            'action' => "",//conceal, reveal, search, reset, link or back
            'action_title' => "",
            'action_href' => "",//only for actions - reset, link or back
            'show_help_icon' => false,
            'help_file_name' => "external_data_dashboard_help.php"
        );
        $oemr_ui = new OemrUI($arrOeUiSettings);
        ?>
    </head>
    <body class="body_top">
        <div id="container_div" class="<?php echo $oemr_ui->oeContainer();?>">
            <div class="row">
                <div class="col-sm-12">
                    <?php
                    require_once("$include_root/patient_file/summary/dashboard_header.php")
                    ?>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="col-sm-12">
                            <?php
                            $list_id = "external_data"; // to indicate nav item is active, count and give correct id
                            // Collect the patient menu then build it
                            $menuPatient = new PatientMenuRole();
                            $menuPatient->displayHorizNavBarMenu();
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="clear"></div>
            <div class="row">
                <div class="col-sm-12">
                    <ul class="ext-tab-head">
                        <li class="child-active ext-enc"><?php echo xlt('Encounters'); ?></li>
                        <li class="ext-proc"><?php echo xlt('Procedures'); ?></li>
                    </ul>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <div class="dm-ed-in-3 dm-ed-in-5">
                        <table width="100%;">
                            <tr class="dm-ed-in-9">
                                <td class="dm-ed-in-6"><label><?php echo xlt('Date'); ?></label></td>
                                <td class="dm-ed-in-6"><label><?php echo xlt('Diagnosis'); ?></label></td>
                                <td class="dm-ed-in-6"><label><?php echo xlt('Provider'); ?></label></td>
                                <td class="dm-ed-in-6"><label><?php echo xlt('Facility'); ?></label></td>
                            </tr>
                            <?php
                            $query1 = "SELECT ee.*,CONCAT_WS(' ',u1.lname, u1.fname) AS provider,u2.organization AS facility
                         FROM external_encounters AS ee
                         LEFT JOIN users AS u1 ON u1.id = ee.ee_provider_id
                         LEFT JOIN users AS u2 ON u2.id = ee.ee_facility_id
                         WHERE ee.ee_pid = ?";
                            $res1 = sqlStatement($query1, array($pid));
                            while ($row1 = sqlFetchArray($res1)) {
                                $records1[] = $row1;
                            }

                            foreach ($records1 as $value1) {
                                ?>
                                <tr>
                                    <td><span class="dm-ed-in-7"><?php echo text(oeFormatShortDate($value1['ee_date'])); ?></span></td>
                                    <td><span class="dm-ed-in-7"><?php echo text($value1['ee_encounter_diagnosis']); ?></span></td>
                                    <td><span class="dm-ed-in-7"><?php echo text($value1['provider']); ?></span></td>
                                    <td><span class="dm-ed-in-7"><?php echo text($value1['facility']); ?></span></td>
                                </tr>
                                <?php
                            } ?>
                        </table>
                        <?php if (empty($records1)) { ?>
                            <div class="dm-ed-in-8">
                                <?php echo xlt('Nothing to display'); ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="dm-ed-in-4 dm-ed-in-5">
                        <table width="100%;">
                            <tr class="dm-ed-in-9">
                                <td class="dm-ed-in-6"><label><?php echo xlt('Date'); ?></label></td>
                                <td class="dm-ed-in-6"><label><?php echo xlt('Code'); ?></label></td>
                                <td class="dm-ed-in-6"><label><?php echo xlt('Code Text'); ?></label></td>
                                <td class="dm-ed-in-6"><label><?php echo xlt('Facility'); ?></label></td>
                            </tr>
                            <?php
                            $query2 = "SELECT ep.*,u.organization AS facility
                         FROM external_procedures AS ep
                         LEFT JOIN users AS u ON u.id = ep.ep_facility_id
                         WHERE ep.ep_pid = ?";
                            $res2 = sqlStatement($query2, array($pid));
                            while ($row2 = sqlFetchArray($res2)) {
                                $records2[] = $row2;
                            }

                            foreach ($records2 as $value2) { ?>
                                <tr>
                                    <td><span class="dm-ed-in-7"><?php echo text(oeFormatShortDate($value2['ep_date'])); ?></span></td>
                                    <td><span class="dm-ed-in-7"><?php echo text($value2['ep_code_type'] . ':' . $value2['ep_code']); ?></span></td>
                                    <td><span class="dm-ed-in-7"><?php echo text($value2['ep_code_text']); ?></span></td>
                                    <td><span class="dm-ed-in-7"><?php echo text($value2['facility']); ?></span></td>
                                </tr>
                                <?php
                            } ?>
                        </table>
                            <?php if (empty($records2)) { ?>
                            <div class="dm-ed-in-8">
                                <?php echo xlt('Nothing to display'); ?>
                            </div>
                            <?php } ?>
                    </div>
                </div>
            </div>
        </div><!--end of container div-->
        <?php $oemr_ui->oeBelowContainerDiv();?>
    <script>
        var listId = '#' + <?php echo js_escape($list_id); ?>;
        $(function(){
            $(listId).addClass("active");
        });
    </script>
    </body>
</html>
