<?php
// Copyright (C) 2011 Ken Chapple <ken@mi-squared.com>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
class Codes
{
    const ICD9 = 'ICD9';
    const CUSTOM = 'CUSTOM';
    const OPTION_ID = 'OPTION_ID'; // This  code maps to an option_id in the list_options table.  The list_id is in the class.

    public static function lookup($clinicalType, $codeType = null)
    {
        if ($codeType != null) {
            if (isset(self::$_codes[$clinicalType][$codeType])) {
                return self::$_codes[$clinicalType][$codeType];
            }
        } else if (isset(self::$_codes[$clinicalType])) {
            return self::$_codes[$clinicalType];
        }
         
        return array();
    }
    
    protected static $_codes = array(
        Allergy::EGGS => array(
            'ICD9' => array( 'V15.03' )
        ),
        Allergy::DTAP_VAC => array(
            'RXNORM' => array( '204525','205257','205259','260122','359454','562372','795926','795930','795938','795939','795942','798309','798347','802049','805375','805379','806587','806593','807277','807415','824542','829894','829971','829987','830518','830549','830555','830893','835879' )
        ),
        Allergy::HIB => array(
            'RXNORM' => array( '260123','798282','798348','798440','798447','860904' )
        ),
        Allergy::IPV => array(
            'RXNORM' => array( '763103', '866820' )
        ),
        Allergy::NEOMYCIN => array(
            'RXNORM' => array( 'C0988018','C1123055','C1123343','C1123363','C1124224','C1127589','C1134215','C1140030','C1140542','C1186980','C1704126','C272305' )
        ),
        Allergy::POLYMYXIN => array(
            'RxNORM' => array( 'C0988924','C1123393','C1125567','C1133048','C2729553' )
        ),
        Allergy::STREPTOMYCIN => array(
            'RXNORM' => array( 'C1134151' )
        ),
        Communication::COUNS_NUTRITION => array(
            'ICD9' => array( 'V65.3' )
        ),
        Communication::COUNS_PHYS_ACTIVITY => array(
            'ICD9' => array( 'V65.41' )
        ),
        Communication::PREV_RECEIPT_VACCINE => array(
            'SNOMED' => array('185900003','185901004','185902006', '416928007')
        ),
        Diagnosis::ASYMPTOMATIC_HIV => array(
            'ICD9' => array( '042','V08' )
        ),
        Diagnosis::CANCER_LYMPH_HIST => array(
            'ICD9' => array( '201','202','203' )
        ),
        Diagnosis::DIABETES => array(
            'ICD9' => array( '250','250.0','250.00','250.01','250.02','250.03','250.10','250.11','250.12','250.13','250.20','250.21','250.22','250.23','250.30','250.31','250.32','250.33','250.4','250.40','250.41','250.42','250.43','250.50','250.51','250.52','250.53','250.60','250.61','250.62','250.63','250.7','250.70','250.71','250.72','250.73','250.8','250.80','250.81','250.82','250.83','250.9','250.90','250.91','250.92','250.93','357.2','362.0','362.01','362.02','362.03','362.04','362.05','362.06','362.07','366.41','648.0','648.00','648.01','648.02','648.03','648.04'),
            'SNOMED-CT' => array(190330002, 190331003, 190368000, 190369008, 190372001, 190389009, 190390000, 199223000, 199225007, 199226008, 199227004, 199228009, 199229001, 199230006, 23045005, 237599002, 237618001, 237627000, 28032008, 313435000, 313436004, 314771006, 314772004, 314893005, 314894004, 314902007, 314903002, 314904008, 359642000, 44054006, 46635009, 4783006, 75682002, 76751001, 81531005, 9859006),
        ),
        Diagnosis::ENCEPHALOPATHY => array(
            'ICD9' => array( '323.51' )
        ),
        Diagnosis::HEP_A => array(
            'ICD9' => array( '070.0','070.1' )
        ),
        Diagnosis::HEP_B => array(
            'ICD9' => array( '070.2','070.3','V02.61' )
        ),
        Diagnosis::PREGNANCY => array(
            'ICD9' => array( '630','631','632','633','633.0','633.00','633.01','633.1','633.10','633.11','633.2','633.20','633.21','633.8','633.80','633.81','633.9','633.90','633.91','634','634.0','634.00','634.01','634.02','634.1','634.10','634.11','634.12','634.2','634.20','634.21','634.22','634.3','634.30','634.31','634.32','634.4','634.40','634.41','634.42','634.5','634.50','634.51','634.52','634.6','634.60','634.61','634.62','634.7','634.70','634.71','634.72','634.8','634.80','634.81','634.82','634.9','634.90','634.91','634.92','635','635.0','635.00','635.01','635.02','635.1','635.10','635.11','635.12','635.2','635.20','635.21','635.22','635.3','635.30','635.31','635.32','635.4','635.40','635.41','635.42','635.5','635.50','635.51','635.52','635.6','635.60','635.61','635.62','635.7','635.70','635.71','635.72','635.8','635.80','635.81','635.82','635.9','635.90','635.91','635.92','636','636.0','636.00','636.01','636.02','636.1','636.10','636.11','636.12','636.2','636.20','636.21','636.22','636.3','636.30','636.31','636.32','636.4','636.40','636.41','636.42','636.5','636.50','636.51','636.52','636.6','636.60','636.61','636.62','636.7','636.70','636.71','636.72','636.8','636.80','636.81','636.82','636.9','636.90','636.91','636.92','637','637.0','637.00','637.01','637.02','637.1','637.10','637.11','637.12','637.2','637.20','637.21','637.22','637.3','637.30','637.31','637.32','637.4','637.40','637.41','637.42','637.5','637.50','637.51','637.52','637.6','637.60','637.61','637.62','637.7','637.70','637.71','637.72','637.8','637.80','637.81','637.82','637.9','637.90','637.91','637.92','638','638.0','638.1','638.2','638.3','638.4','638.5','638.6','638.7','638.8','638.9','639','639.0','639.1','639.2','639.3','639.4','639.5','639.6','639.8','639.9','640','640.0','640.00','640.01','640.03','640.8','640.80','640.81','640.83','640.9','640.90','640.91','640.93','641','641.0','641.00','641.01','641.03','641.1','641.10','641.11','641.13','641.2','641.20','641.21','641.23','641.3','641.30','641.31','641.33','641.8','641.80','641.81','641.83','641.9','641.90','641.91','641.93','642','642.0','642.00','642.01','642.02','642.03','642.04','642.1','642.10','642.11','642.12','642.13','642.14','642.2','642.20','642.21','642.22','642.23','642.24','642.3','642.30','642.31','642.32','642.33','642.34','642.4','642.40','642.41','642.42','642.43','642.44','642.5','642.50','642.51','642.52','642.53','642.54','642.6','642.60','642.61','642.62','642.63','642.64','642.7','642.70','642.71','642.72','642.73','642.74','642.9','642.90','642.91','642.92','642.93','642.94','643','643.0','643.00','643.01','643.03','643.1','643.10','643.11','643.13','643.2','643.20','643.21','643.23','643.8','643.80','643.81','643.83','643.9','643.90','643.91','643.93','644','644.0','644.00','644.03','644.1','644.10','644.13','644.2','644.20','644.21','645','645.1','645.10','645.11','645.13','645.2','645.20','645.21','645.23','646','646.0','646.00','646.01','646.03','646.1','646.10','646.11','646.12','646.13','646.14','646.2','646.20','646.21','646.22','646.23','646.24','646.3','646.30','646.31','646.33','646.4','646.40','646.41','646.42','646.43','646.44','646.5','646.50','646.51','646.52','646.53','646.54','646.6','646.60','646.61','646.62','646.63','646.64','646.7','646.70','646.71','646.73','646.8','646.80','646.81','646.82','646.83','646.84','646.9','646.90','646.91','646.93','647','647.0','647.00','647.01','647.02','647.03','647.04','647.1','647.10','647.11','647.12','647.13','647.14','647.2','647.20','647.21','647.22','647.23','647.24','647.3','647.30','647.31','647.32','647.33','647.34','647.4','647.40','647.41','647.42','647.43','647.44','647.5','647.50','647.51','647.52','647.53','647.54','647.6','647.60','647.61','647.62','647.63','647.64','647.8','647.80','647.81','647.82','647.83','647.84','647.9','647.90','647.91','647.92','647.93','647.94','648','648.0','648.00','648.01','648.02','648.03','648.04','648.1','648.10','648.11','648.12','648.13','648.14','648.2','648.20','648.21','648.22','648.23','648.24','648.3','648.30','648.31','648.32','648.33','648.34','648.4','648.40','648.41','648.42','648.43','648.44','648.5','648.50','648.51','648.52','648.53','648.54','648.6','648.60','648.61','648.62','648.63','648.64','648.7','648.70','648.71','648.72','648.73','648.74','648.8','648.80','648.81','648.82','648.83','648.84','648.9','648.90','648.91','648.92','648.93','648.94','649','649.0','649.00','649.01','649.02','649.03','649.04','649.1','649.10','649.11','649.12','649.13','649.14','649.2','649.20','649.21','649.22','649.23','649.24','649.3','649.30','649.31','649.32','649.33','649.34','649.4','649.40','649.41','649.42','649.43','649.44','649.5','649.50','649.51','649.53','649.6','649.60','649.61','649.62','649.63','649.64','649.7','649.70','649.71','649.73','650','651','651.0','651.00','651.01','651.03','651.1','651.10','651.11','651.13','651.2','651.20','651.21','651.23','651.3','651.30','651.31','651.33','651.4','651.40','651.41','651.43','651.5','651.50','651.51','651.53','651.6','651.60','651.61','651.63','651.7','651.70','651.71','651.73','651.8','651.80','651.81','651.83','651.9','651.90','651.91','651.93','652','652.0','652.00','652.01','652.03','652.1','652.10','652.11','652.13','652.2','652.20','652.21','652.23','652.3','652.30','652.31','652.33','652.4','652.40','652.41','652.43','652.5','652.50','652.51','652.53','652.6','652.60','652.61','652.63','652.7','652.70','652.71','652.73','652.8','652.80','652.81','652.83','652.9','652.90','652.91','652.93','653','653.0','653.00','653.01','653.03','653.1','653.10','653.11','653.13','653.2','653.20','653.21','653.23','653.3','653.30','653.31','653.33','653.4','653.40','653.41','653.43','653.5','653.50','653.51','653.53','653.6','653.60','653.61','653.63','653.7','653.70','653.71','653.73','653.8','653.80','653.81','653.83','653.9','653.90','653.91','653.93','654','654.0','654.00','654.01','654.02','654.03','654.04','654.1','654.10','654.11','654.12','654.13','654.14','654.2','654.20','654.21','654.23','654.3','654.30','654.31','654.32','654.33','654.34','654.4','654.40','654.41','654.42','654.43','654.44','654.5','654.50','654.51','654.52','654.53','654.54','654.6','654.60','654.61','654.62','654.63','654.64','654.7','654.70','654.71','654.72','654.73','654.74','654.8','654.80','654.81','654.82','654.83','654.84','654.9','654.90','654.91','654.92','654.93','654.94','655','655.0','655.00','655.01','655.03','655.1','655.10','655.11','655.13','655.2','655.20','655.21','655.23','655.3','655.30','655.31','655.33','655.4','655.40','655.41','655.43','655.5','655.50','655.51','655.53','655.6','655.60','655.61','655.63','655.7','655.70','655.71','655.73','655.8','655.80','655.81','655.83','655.9','655.90','655.91','655.93','656','656.0','656.00','656.01','656.03','656.1','656.10','656.11','656.13','656.2','656.20','656.21','656.23','656.3','656.30','656.31','656.33','656.4','656.40','656.41','656.43','656.5','656.50','656.51','656.53','656.6','656.60','656.61','656.63','656.7','656.70','656.71','656.73','656.8','656.80','656.81','656.83','656.9','656.90','656.91','656.93','657','657.0','657.00','657.01','657.03','658','658.0','658.00','658.01','658.03','658.1','658.10','658.11','658.13','658.2','658.20','658.21','658.23','658.3','658.30','658.31','658.33','658.4','658.40','658.41','658.43','658.8','658.80','658.81','658.83','658.9','658.90','658.91','658.93','659','659.0','659.00','659.01','659.03','659.1','659.10','659.11','659.13','659.2','659.20','659.21','659.23','659.3','659.30','659.31','659.33','659.4','659.40','659.41','659.43','659.5','659.50','659.51','659.53','659.6','659.60','659.61','659.63','659.7','659.70','659.71','659.73','659.8','659.80','659.81','659.83','659.9','659.90','659.91','659.93','660','660.0','660.00','660.01','660.03','660.1','660.10','660.11','660.13','660.2','660.20','660.21','660.23','660.3','660.30','660.31','660.33','660.4','660.40','660.41','660.43','660.5','660.50','660.51','660.53','660.6','660.60','660.61','660.63','660.7','660.70','660.71','660.73','660.8','660.80','660.81','660.83','660.9','660.90','660.91','660.93','661','661.0','661.00','661.01','661.03','661.1','661.10','661.11','661.13','661.2','661.20','661.21','661.23','661.3','661.30','661.31','661.33','661.4','661.40','661.41','661.43','661.9','661.90','661.91','661.93','662','662.0','662.00','662.01','662.03','662.1','662.10','662.11','662.13','662.2','662.20','662.21','662.23','662.3','662.30','662.31','662.33','663','663.0','663.00','663.01','663.03','663.1','663.10','663.11','663.13','663.2','663.20','663.21','663.23','663.3','663.30','663.31','663.33','663.4','663.40','663.41','663.43','663.5','663.50','663.51','663.53','663.6','663.60','663.61','663.63','663.8','663.80','663.81','663.83','663.9','663.90','663.91','663.93','664','664.0','664.00','664.01','664.04','664.1','664.10','664.11','664.14','664.2','664.20','664.21','664.24','664.3','664.30','664.31','664.34','664.4','664.40','664.41','664.44','664.5','664.50','664.51','664.54','664.6','664.60','664.61','664.64','664.8','664.80','664.81','664.84','664.9','664.90','664.91','664.94','665','665.0','665.00','665.01','665.03','665.1','665.10','665.11','665.2','665.20','665.22','665.24','665.3','665.30','665.31','665.34','665.4','665.40','665.41','665.44','665.5','665.50','665.51','665.54','665.6','665.60','665.61','665.64','665.7','665.70','665.71','665.72','665.74','665.8','665.80','665.81','665.82','665.83','665.84','665.9','665.90','665.91','665.92','665.93','665.94','666','666.0','666.00','666.02','666.04','666.1','666.10','666.12','666.14','666.2','666.20','666.22','666.24','666.3','666.30','666.32','666.34','667','667.0','667.00','667.02','667.04','667.1','667.10','667.12','667.14','668','668.0','668.00','668.01','668.02','668.03','668.04','668.1','668.10','668.11','668.12','668.13','668.14','668.2','668.20','668.21','668.22','668.23','668.24','668.8','668.80','668.81','668.82','668.83','668.84','668.9','668.90','668.91','668.92','668.93','668.94','669','669.0','669.00','669.01','669.02','669.03','669.04','669.1','669.10','669.11','669.12','669.13','669.14','669.2','669.20','669.21','669.22','669.23','669.24','669.3','669.30','669.32','669.34','669.4','669.40','669.41','669.42','669.43','669.44','669.5','669.50','669.51','669.6','669.60','669.61','669.7','669.70','669.71','669.8','669.80','669.81','669.82','669.83','669.84','669.9','669.90','669.91','669.92','669.93','669.94','670','670.0','670.00','670.02','670.04','671','671.0','671.00','671.01','671.02','671.03','671.04','671.1','671.10','671.11','671.12','671.13','671.14','671.2','671.20','671.21','671.22','671.23','671.24','671.3','671.30','671.31','671.33','671.4','671.40','671.42','671.44','671.5','671.50','671.51','671.52','671.53','671.54','671.8','671.80','671.81','671.82','671.83','671.84','671.9','671.90','671.91','671.92','671.93','671.94','672','672.0','672.00','672.02','672.04','673','673.0','673.00','673.01','673.02','673.03','673.04','673.1','673.10','673.11','673.12','673.13','673.14','673.2','673.20','673.21','673.22','673.23','673.24','673.3','673.30','673.31','673.32','673.33','673.34','673.8','673.80','673.81','673.82','673.83','673.84','674','674.0','674.00','674.01','674.02','674.03','674.04','674.1','674.10','674.12','674.14','674.2','674.20','674.22','674.24','674.3','674.30','674.32','674.34','674.4','674.40','674.42','674.44','674.5','674.50','674.51','674.52','674.53','674.54','674.8','674.80','674.82','674.84','674.9','674.90','674.92','674.94','675','675.0','675.00','675.01','675.02','675.03','675.04','675.1','675.10','675.11','675.12','675.13','675.14','675.2','675.20','675.21','675.22','675.23','675.24','675.8','675.80','675.81','675.82','675.83','675.84','675.9','675.90','675.91','675.92','675.93','675.94','676','676.0','676.00','676.01','676.02','676.03','676.04','676.1','676.10','676.11','676.12','676.13','676.14','676.2','676.20','676.21','676.22','676.23','676.24','676.3','676.30','676.31','676.32','676.33','676.34','676.4','676.40','676.41','676.42','676.43','676.44','676.5','676.50','676.51','676.52','676.53','676.54','676.6','676.60','676.61','676.62','676.63','676.64','676.8','676.80','676.81','676.82','676.83','676.84','676.9','676.90','676.91','676.92','676.93','676.94','677','678','678.0','678.00','678.01','678.03','678.1','678.10','678.11','678.13','679','679.0','679.00','679.01','679.02','679.03','679.04','679.1','679.10','679.11','679.12','679.13','679.14','V22','V22.0','V22.1','V22.2','V23','V23.0','V23.1','V23.2','V23.3','V23.4','V23.41','V23.49','V23.5','V23.7','V23.8','V23.81','V23.82','V23.83','V23.84','V23.85','V23.86','V23.89','V23.9','V28','V28.0','V28.1','V28.2','V28.3','V28.4','V28.5','V28.6','V28.8','V28.81','V28.82','V28.89','V28.9'),
            'ICD10' => array('O00.1','O00.2','O00.8','O00.9','O09.00','O09.01','O09.02','O09.03','O09.10','O09.11','O09.12','O09.13','O09.211','O09.212','O09.213','O09.219','O09.291','O09.292','O09.293','O09.299','O09.30','O09.31','O09.32','O09.33','O09.40','O09.41','O09.42','O09.43','O09.511','O09.512','O09.513','O09.519','O09.521','O09.522','O09.523','O09.529','O09.611','O09.612','O09.613','O09.619','O09.621','O09.622','O09.623','O09.629','O09.70','O09.71','O09.72','O09.73','O09.811','O09.812','O09.813','O09.819','O09.821','O09.822','O09.823','O09.829','O09.891','O09.892','O09.893','O09.899','O09.90','O09.91','O09.92','O09.93','O10.011','O10.012','O10.013','O10.019','O10.111','O10.112','O10.113','O10.119','O10.211','O10.212','O10.213','O10.219','O10.311','O10.312','O10.313','O10.319','O10.411','O10.412','O10.413','O10.419','O10.911','O10.912','O10.913','O10.919','O11.1','O11.2','O11.3','O11.9','O12.00','O12.01','O12.02','O12.03','O12.10','O12.11','O12.12','O12.13','O12.20','O12.21','O12.22','O12.23','O13.1','O13.2','O13.3','O13.9','O14.00','O14.02','O14.03','O14.10','O14.12','O14.13','O14.20','O14.22','O14.23','O14.90','O14.92','O14.93','O15.00','O15.02','O15.03','O16.1','O16.2','O16.3','O16.9','O20.0','O20.8','O20.9','O21.0','O21.1','O21.2','O21.8','O21.9','O22.00','O22.01','O22.02','O22.03','O22.10','O22.11','O22.12','O22.13','O22.20','O22.21','O22.22','O22.23','O22.30','O22.31','O22.32','O22.33','O22.40','O22.41','O22.42','O22.43','O22.50','O22.51','O22.52','O22.53','O22.8X1','O22.8X2','O22.8X3','O22.8X9','O22.90','O22.91','O22.92','O22.93','O23.00','O23.01','O23.02','O23.03','O23.10','O23.11','O23.12','O23.13','O23.20','O23.21','O23.22','O23.23','O23.30','O23.31','O23.32','O23.33','O23.40','O23.41','O23.42','O23.43','O23.511','O23.512','O23.513','O23.519','O23.521','O23.522','O23.523','O23.529','O23.591','O23.592','O23.593','O23.599','O23.90','O23.91','O23.92','O23.93','O24.011','O24.012','O24.013','O24.019','O24.111','O24.112','O24.113','O24.119','O24.311','O24.312','O24.313','O24.319','O24.410','O24.414','O24.419','O24.811','O24.812','O24.813','O24.819','O24.911','O24.912','O24.913','O24.919','O25.10','O25.11','O25.12','O25.13','O26.00','O26.01','O26.02','O26.03','O26.10','O26.11','O26.12','O26.13','O26.20','O26.21','O26.22','O26.23','O26.30','O26.31','O26.32','O26.33','O26.40','O26.41','O26.42','O26.43','O26.50','O26.51','O26.52','O26.53','O26.611','O26.612','O26.613','O26.619','O26.711','O26.712','O26.713','O26.719','O26.811','O26.812','O26.813','O26.819','O26.821','O26.822','O26.823','O26.829','O26.831','O26.832','O26.833','O26.839','O26.841','O26.842','O26.843','O26.849','O26.851','O26.852','O26.853','O26.859','O26.86','O26.872','O26.873','O26.879','O26.891','O26.892','O26.893','O26.899','O26.90','O26.91','O26.92','O26.93','O28.0','O28.1','O28.2','O28.3','O28.4','O28.5','O28.8','O28.9','O29.011','O29.012','O29.013','O29.019','O29.021','O29.022','O29.023','O29.029','O29.091','O29.092','O29.093','O29.099','O29.111','O29.112','O29.113','O29.119','O29.121','O29.122','O29.123','O29.129','O29.191','O29.192','O29.193','O29.199','O29.211','O29.212','O29.213','O29.219','O29.291','O29.292','O29.293','O29.299','O29.3X1','O29.3X2','O29.3X3','O29.3X9','O29.40','O29.41','O29.42','O29.43','O29.5X1','O29.5X2','O29.5X3','O29.5X9','O29.60','O29.61','O29.62','O29.63','O29.8X1','O29.8X2','O29.8X3','O29.8X9','O29.90','O29.91','O29.92','O29.93','O30.001','O30.002','O30.003','O30.009','O30.011','O30.012','O30.013','O30.019','O30.021','O30.022','O30.023','O30.029','O30.031','O30.032','O30.033','O30.039','O30.041','O30.042','O30.043','O30.049','O30.091','O30.092','O30.093','O30.099','O30.101','O30.102','O30.103','O30.109','O30.111','O30.112','O30.113','O30.119','O30.121','O30.122','O30.123','O30.129','O30.191','O30.192','O30.193','O30.199','O30.201','O30.202','O30.203','O30.209','O30.211','O30.212','O30.213','O30.219','O30.221','O30.222','O30.223','O30.229','O30.291','O30.292','O30.293','O30.299','O30.801','O30.802','O30.803','O30.809','O30.811','O30.812','O30.813','O30.819','O30.821','O30.822','O30.823','O30.829','O30.891','O30.892','O30.893','O30.899','O30.90','O30.91','O30.92','O30.93','O31.00X0','O31.00X1','O31.00X2','O31.00X3','O31.00X4','O31.00X5','O31.00X9','O31.01X0','O31.01X1','O31.01X2','O31.01X3','O31.01X4','O31.01X5','O31.01X9','O31.02X0','O31.02X1','O31.02X2','O31.02X3','O31.02X4','O31.02X5','O31.02X9','O31.03X0','O31.03X1','O31.03X2','O31.03X3','O31.03X4','O31.03X5','O31.03X9','O31.10X0','O31.10X1','O31.10X2','O31.10X3','O31.10X4','O31.10X5','O31.10X9','O31.11X0','O31.11X1','O31.11X2','O31.11X3','O31.11X4','O31.11X5','O31.11X9','O31.12X0','O31.12X1','O31.12X2','O31.12X3','O31.12X4','O31.12X5','O31.12X9','O31.13X0','O31.13X1','O31.13X2','O31.13X3','O31.13X4','O31.13X5','O31.13X9','O31.20X0','O31.20X1','O31.20X2','O31.20X3','O31.20X4','O31.20X5','O31.20X9','O31.21X0','O31.21X1','O31.21X2','O31.21X3','O31.21X4','O31.21X5','O31.21X9','O31.22X0','O31.22X1','O31.22X2','O31.22X3','O31.22X4','O31.22X5','O31.22X9','O31.23X0','O31.23X1','O31.23X2','O31.23X3','O31.23X4','O31.23X5','O31.23X9','O31.30X0','O31.30X1','O31.30X2','O31.30X3','O31.30X4','O31.30X5','O31.30X9','O31.31X0','O31.31X1','O31.31X2','O31.31X3','O31.31X4','O31.31X5','O31.31X9','O31.32X0','O31.32X1','O31.32X2','O31.32X3','O31.32X4','O31.32X5','O31.32X9','O31.33X0','O31.33X1','O31.33X2','O31.33X3','O31.33X4','O31.33X5','O31.33X9','O31.8X10','O31.8X11','O31.8X12','O31.8X13','O31.8X14','O31.8X15','O31.8X19','O31.8X20','O31.8X21','O31.8X22','O31.8X23','O31.8X24','O31.8X25','O31.8X29','O31.8X30','O31.8X31','O31.8X32','O31.8X33','O31.8X34','O31.8X35','O31.8X39','O31.8X90','O31.8X91','O31.8X92','O31.8X93','O31.8X94','O31.8X95','O31.8X99','O32.0XX0','O32.0XX1','O32.0XX2','O32.0XX3','O32.0XX4','O32.0XX5','O32.0XX9','O32.1XX0','O32.1XX1','O32.1XX2','O32.1XX3','O32.1XX4','O32.1XX5','O32.1XX9','O32.2XX0','O32.2XX1','O32.2XX2','O32.2XX3','O32.2XX4','O32.2XX5','O32.2XX9','O32.3XX0','O32.3XX1','O32.3XX2','O32.3XX3','O32.3XX4','O32.3XX5','O32.3XX9','O32.4XX0','O32.4XX1','O32.4XX2','O32.4XX3','O32.4XX4','O32.4XX5','O32.4XX9','O32.6XX0','O32.6XX1','O32.6XX2','O32.6XX3','O32.6XX4','O32.6XX5','O32.6XX9','O32.8XX0','O32.8XX1','O32.8XX2','O32.8XX3','O32.8XX4','O32.8XX5','O32.8XX9','O32.9XX0','O32.9XX1','O32.9XX2','O32.9XX3','O32.9XX4','O32.9XX5','O32.9XX9','O33.0','O33.1','O33.2','O33.3XX0','O33.3XX1','O33.3XX2','O33.3XX3','O33.3XX4','O33.3XX5','O33.3XX9','O33.4XX0','O33.4XX1','O33.4XX2','O33.4XX3','O33.4XX4','O33.4XX5','O33.4XX9','O33.5XX0','O33.5XX1','O33.5XX2','O33.5XX3','O33.5XX4','O33.5XX5','O33.5XX9','O33.6XX0','O33.6XX1','O33.6XX2','O33.6XX3','O33.6XX4','O33.6XX5','O33.6XX9','O33.7','O33.8','O33.9','O34.00','O34.01','O34.02','O34.03','O34.10','O34.11','O34.12','O34.13','O34.21','O34.29','O34.30','O34.31','O34.32','O34.33','O34.40','O34.41','O34.42','O34.43','O34.511','O34.512','O34.513','O34.519','O34.521','O34.522','O34.523','O34.529','O34.531','O34.532','O34.533','O34.539','O34.591','O34.592','O34.593','O34.599','O34.60','O34.61','O34.62','O34.63','O34.70','O34.71','O34.72','O34.73','O34.80','O34.81','O34.82','O34.83','O34.90','O34.91','O34.92','O34.93','O35.0XX0','O35.0XX1','O35.0XX2','O35.0XX3','O35.0XX4','O35.0XX5','O35.0XX9','O35.1XX0','O35.1XX1','O35.1XX2','O35.1XX3','O35.1XX4','O35.1XX5','O35.1XX9','O35.2XX0','O35.2XX1','O35.2XX2','O35.2XX3','O35.2XX4','O35.2XX5','O35.2XX9','O35.3XX0','O35.3XX1','O35.3XX2','O35.3XX3','O35.3XX4','O35.3XX5','O35.3XX9','O35.4XX0','O35.4XX1','O35.4XX2','O35.4XX3','O35.4XX4','O35.4XX5','O35.4XX9','O35.5XX0','O35.5XX1','O35.5XX2','O35.5XX3','O35.5XX4','O35.5XX5','O35.5XX9','O35.6XX0','O35.6XX1','O35.6XX2','O35.6XX3','O35.6XX4','O35.6XX5','O35.6XX9','O35.7XX0','O35.7XX1','O35.7XX2','O35.7XX3','O35.7XX4','O35.7XX5','O35.7XX9','O35.8XX0','O35.8XX1','O35.8XX2','O35.8XX3','O35.8XX4','O35.8XX5','O35.8XX9','O35.9XX0','O35.9XX1','O35.9XX2','O35.9XX3','O35.9XX4','O35.9XX5','O35.9XX9','O36.0110','O36.0111','O36.0112','O36.0113','O36.0114','O36.0115','O36.0119','O36.0120','O36.0121','O36.0122','O36.0123','O36.0124','O36.0125','O36.0129','O36.0130','O36.0131','O36.0132','O36.0133','O36.0134','O36.0135','O36.0139','O36.0190','O36.0191','O36.0192','O36.0193','O36.0194','O36.0195','O36.0199','O36.0910','O36.0911','O36.0912','O36.0913','O36.0914','O36.0915','O36.0919','O36.0920','O36.0921','O36.0922','O36.0923','O36.0924','O36.0925','O36.0929','O36.0930','O36.0931','O36.0932','O36.0933','O36.0934','O36.0935','O36.0939','O36.0990','O36.0991','O36.0992','O36.0993','O36.0994','O36.0995','O36.0999','O36.1110','O36.1111','O36.1112','O36.1113','O36.1114','O36.1115','O36.1119','O36.1120','O36.1121','O36.1122','O36.1123','O36.1124','O36.1125','O36.1129','O36.1130','O36.1131','O36.1132','O36.1133','O36.1134','O36.1135','O36.1139','O36.1190','O36.1191','O36.1192','O36.1193','O36.1194','O36.1195','O36.1199','O36.1910','O36.1911','O36.1912','O36.1913','O36.1914','O36.1915','O36.1919','O36.1920','O36.1921','O36.1922','O36.1923','O36.1924','O36.1925','O36.1929','O36.1930','O36.1931','O36.1932','O36.1933','O36.1934','O36.1935','O36.1939','O36.1990','O36.1991','O36.1992','O36.1993','O36.1994','O36.1995','O36.1999','O36.20X0','O36.20X1','O36.20X2','O36.20X3','O36.20X4','O36.20X5','O36.20X9','O36.21X0','O36.21X1','O36.21X2','O36.21X3','O36.21X4','O36.21X5','O36.21X9','O36.22X0','O36.22X1','O36.22X2','O36.22X3','O36.22X4','O36.22X5','O36.22X9','O36.23X0','O36.23X1','O36.23X2','O36.23X3','O36.23X4','O36.23X5','O36.23X9','O36.4XX0','O36.4XX1','O36.4XX2','O36.4XX3','O36.4XX4','O36.4XX5','O36.4XX9','O36.5110','O36.5111','O36.5112','O36.5113','O36.5114','O36.5115','O36.5119','O36.5120','O36.5121','O36.5122','O36.5123','O36.5124','O36.5125','O36.5129','O36.5130','O36.5131','O36.5132','O36.5133','O36.5134','O36.5135','O36.5139','O36.5190','O36.5191','O36.5192','O36.5193','O36.5194','O36.5195','O36.5199','O36.5910','O36.5911','O36.5912','O36.5913','O36.5914','O36.5915','O36.5919','O36.5920','O36.5921','O36.5922','O36.5923','O36.5924','O36.5925','O36.5929','O36.5930','O36.5931','O36.5932','O36.5933','O36.5934','O36.5935','O36.5939','O36.5990','O36.5991','O36.5992','O36.5993','O36.5994','O36.5995','O36.5999','O36.60X0','O36.60X1','O36.60X2','O36.60X3','O36.60X4','O36.60X5','O36.60X9','O36.61X0','O36.61X1','O36.61X2','O36.61X3','O36.61X4','O36.61X5','O36.61X9','O36.62X0','O36.62X1','O36.62X2','O36.62X3','O36.62X4','O36.62X5','O36.62X9','O36.63X0','O36.63X1','O36.63X2','O36.63X3','O36.63X4','O36.63X5','O36.63X9','O36.70X0','O36.70X1','O36.70X2','O36.70X3','O36.70X4','O36.70X5','O36.70X9','O36.71X0','O36.71X1','O36.71X2','O36.71X3','O36.71X4','O36.71X5','O36.71X9','O36.72X0','O36.72X1','O36.72X2','O36.72X3','O36.72X4','O36.72X5','O36.72X9','O36.73X0','O36.73X1','O36.73X2','O36.73X3','O36.73X4','O36.73X5','O36.73X9','O36.8120','O36.8121','O36.8122','O36.8123','O36.8124','O36.8125','O36.8129','O36.8130','O36.8131','O36.8132','O36.8133','O36.8134','O36.8135','O36.8139','O36.8190','O36.8191','O36.8192','O36.8193','O36.8194','O36.8195','O36.8199','O36.8210','O36.8211','O36.8212','O36.8213','O36.8214','O36.8215','O36.8219','O36.8220','O36.8221','O36.8222','O36.8223','O36.8224','O36.8225','O36.8229','O36.8230','O36.8231','O36.8232','O36.8233','O36.8234','O36.8235','O36.8239','O36.8290','O36.8291','O36.8292','O36.8293','O36.8294','O36.8295','O36.8299','O36.8910','O36.8911','O36.8912','O36.8913','O36.8914','O36.8915','O36.8919','O36.8920','O36.8921','O36.8922','O36.8923','O36.8924','O36.8925','O36.8929','O36.8930','O36.8931','O36.8932','O36.8933','O36.8934','O36.8935','O36.8939','O36.8990','O36.8991','O36.8992','O36.8993','O36.8994','O36.8995','O36.8999','O36.90X0','O36.90X1','O36.90X2','O36.90X3','O36.90X4','O36.90X5','O36.90X9','O36.91X0','O36.91X1','O36.91X2','O36.91X3','O36.91X4','O36.91X5','O36.91X9','O36.92X0','O36.92X1','O36.92X2','O36.92X3','O36.92X4','O36.92X5','O36.92X9','O36.93X0','O36.93X1','O36.93X2','O36.93X3','O36.93X4','O36.93X5','O36.93X9','O40.1XX0','O40.1XX1','O40.1XX2','O40.1XX3','O40.1XX4','O40.1XX5','O40.1XX9','O40.2XX0','O40.2XX1','O40.2XX2','O40.2XX3','O40.2XX4','O40.2XX5','O40.2XX9','O40.3XX0','O40.3XX1','O40.3XX2','O40.3XX3','O40.3XX4','O40.3XX5','O40.3XX9','O40.9XX0','O40.9XX1','O40.9XX2','O40.9XX3','O40.9XX4','O40.9XX5','O40.9XX9','O41.00X0','O41.00X1','O41.00X2','O41.00X3','O41.00X4','O41.00X5','O41.00X9','O41.01X0','O41.01X1','O41.01X2','O41.01X3','O41.01X4','O41.01X5','O41.01X9','O41.02X0','O41.02X1','O41.02X2','O41.02X3','O41.02X4','O41.02X5','O41.02X9','O41.03X0','O41.03X1','O41.03X2','O41.03X3','O41.03X4','O41.03X5','O41.03X9','O41.1010','O41.1011','O41.1012','O41.1013','O41.1014','O41.1015','O41.1019','O41.1020','O41.1021','O41.1022','O41.1023','O41.1024','O41.1025','O41.1029','O41.1030','O41.1031','O41.1032','O41.1033','O41.1034','O41.1035','O41.1039','O41.1090','O41.1091','O41.1092','O41.1093','O41.1094','O41.1095','O41.1099','O41.1210','O41.1211','O41.1212','O41.1213','O41.1214','O41.1215','O41.1219','O41.1220','O41.1221','O41.1222','O41.1223','O41.1224','O41.1225','O41.1229','O41.1230','O41.1231','O41.1232','O41.1233','O41.1234','O41.1235','O41.1239','O41.1290','O41.1291','O41.1292','O41.1293','O41.1294','O41.1295','O41.1299','O41.1410','O41.1411','O41.1412','O41.1413','O41.1414','O41.1415','O41.1419','O41.1420','O41.1421','O41.1422','O41.1423','O41.1424','O41.1425','O41.1429','O41.1430','O41.1431','O41.1432','O41.1433','O41.1434','O41.1435','O41.1439','O41.1490','O41.1491','O41.1492','O41.1493','O41.1494','O41.1495','O41.1499','O41.8X10','O41.8X11','O41.8X12','O41.8X13','O41.8X14','O41.8X15','O41.8X19','O41.8X20','O41.8X21','O41.8X22','O41.8X23','O41.8X24','O41.8X25','O41.8X29','O41.8X30','O41.8X31','O41.8X32','O41.8X33','O41.8X34','O41.8X35','O41.8X39','O41.8X90','O41.8X91','O41.8X92','O41.8X93','O41.8X94','O41.8X95','O41.8X99','O41.90X0','O41.90X1','O41.90X2','O41.90X3','O41.90X4','O41.90X5','O41.90X9','O41.91X0','O41.91X1','O41.91X2','O41.91X3','O41.91X4','O41.91X5','O41.91X9','O41.92X0','O41.92X1','O41.92X2','O41.92X3','O41.92X4','O41.92X5','O41.92X9','O41.93X0','O41.93X1','O41.93X2','O41.93X3','O41.93X4','O41.93X5','O41.93X9','O42.00','O42.011','O42.012','O42.013','O42.019','O42.02','O42.10','O42.111','O42.112','O42.113','O42.119','O42.12','O42.90','O42.911','O42.912','O42.913','O42.919','O42.92','O43.011','O43.012','O43.013','O43.019','O43.021','O43.022','O43.023','O43.029','O43.101','O43.102','O43.103','O43.109','O43.111','O43.112','O43.113','O43.119','O43.121','O43.122','O43.123','O43.129','O43.191','O43.192','O43.193','O43.199','O43.211','O43.212','O43.213','O43.219','O43.221','O43.222','O43.223','O43.229','O43.231','O43.232','O43.233','O43.239','O43.811','O43.812','O43.813','O43.819','O43.891','O43.892','O43.893','O43.899','O43.90','O43.91','O43.92','O43.93','O44.00','O44.01','O44.02','O44.03','O44.10','O44.11','O44.12','O44.13','O45.001','O45.002','O45.003','O45.009','O45.011','O45.012','O45.013','O45.019','O45.021','O45.022','O45.023','O45.029','O45.091','O45.092','O45.093','O45.099','O45.8X1','O45.8X2','O45.8X3','O45.8X9','O45.90','O45.91','O45.92','O45.93','O46.001','O46.002','O46.003','O46.009','O46.011','O46.012','O46.013','O46.019','O46.021','O46.022','O46.023','O46.029','O46.091','O46.092','O46.093','O46.099','O46.8X1','O46.8X2','O46.8X3','O46.8X9','O46.90','O46.91','O46.92','O46.93','O47.00','O47.02','O47.03','O47.1','O47.9','O48.0','O48.1','O60.00','O60.02','O60.03','O71.00','O71.02','O71.03','O88.011','O88.012','O88.013','O88.019','O88.111','O88.112','O88.113','O88.119','O88.211','O88.212','O88.213','O88.219','O88.311','O88.312','O88.313','O88.319','O88.811','O88.812','O88.813','O88.819','O90.3','O91.011','O91.012','O91.013','O91.019','O91.111','O91.112','O91.113','O91.119','O91.211','O91.212','O91.213','O91.219','O92.011','O92.012','O92.013','O92.019','O92.111','O92.112','O92.113','O92.119','O92.20','O92.29','O98.011','O98.012','O98.013','O98.019','O98.111','O98.112','O98.113','O98.119','O98.211','O98.212','O98.213','O98.219','O98.311','O98.312','O98.313','O98.319','O98.411','O98.412','O98.413','O98.419','O98.511','O98.512','O98.513','O98.519','O98.611','O98.612','O98.613','O98.619','O98.711','O98.712','O98.713','O98.719','O98.811','O98.812','O98.813','O98.819','O98.911','O98.912','O98.913','O98.919','O99.011','O99.012','O99.013','O99.019','O99.111','O99.112','O99.113','O99.119','O99.210','O99.211','O99.212','O99.213','O99.280','O99.281','O99.282','O99.283','O99.310','O99.311','O99.312','O99.313','O99.320','O99.321','O99.322','O99.323','O99.330','O99.331','O99.332','O99.333','O99.340','O99.341','O99.342','O99.343','O99.350','O99.351','O99.352','O99.353','O99.411','O99.412','O99.413','O99.419','O99.511','O99.512','O99.513','O99.519','O99.611','O99.612','O99.613','O99.619','O99.711','O99.712','O99.713','O99.719','O99.810','O99.820','O99.830','O99.840','O99.841','O99.842','O99.843','O99.89','O9A.111','O9A.112','O9A.113','O9A.119','O9A.211','O9A.212','O9A.213','O9A.219','O9A.311','O9A.312','O9A.313','O9A.319','O9A.411','O9A.412','O9A.413','O9A.419','O9A.511','O9A.512','O9A.513','O9A.519','Z33.1','Z34.00','Z34.01','Z34.02','Z34.03','Z34.80','Z34.81','Z34.82','Z34.83','Z34.90','Z34.91','Z34.92','Z34.93','Z36'),
            'SNOMED-CT' => array(102872000, 102873005, 102875003, 14418008, 169560008, 169561007, 169562000, 169563005, 169564004, 169565003, 169566002, 169567006, 169568001, 199715003, 237233002, 237238006, 237239003, 237240001, 237241002, 237242009, 237244005, 248985009, 281307002, 314204000, 41587001, 45307008, 47200007, 57630001, 58532003, 59466002, 65727000, 72892002, 77386006, 83074005, 9279009),
        ),
        Diagnosis::HYPERTENSION => array(
            'CUSTOM' => array( 'HTN' ),
            'SNOMED-CT' => array('10725009','1201005','276789009','371125006','429198000','429457004','46481004','48146000','52698002','56218007','59621000','59720008','62275004','65518004','78975002'),
            'ICD9' => array( '401.0','401.1','401.9','402.00','402.01','402.10','402.11','402.90','402.91','403.00','403.01','403.10','403.11','403.90','403.91','404.00','404.01','404.02','404.03','404.10','404.11','404.12','404.13','404.90','404.91','404.92','404.93' )
        ),
        Diagnosis::ENCEPHALOPATHY => array(
            'ICD9' => array( '323.51' )
        ),
        Diagnosis::GESTATIONAL_DIABETES => array(
            'ICD9' => array( '648.8','648.80','648.81','648.82','648.83','648.84' )
        ),
        Diagnosis::IMMUNODEF => array(
            'ICD9' => array( '279' )
        ),
        Diagnosis::LUKEMIA => array(
            'ICD9' => array( '200','202','204','205','206','207','208' )
        ),
        Diagnosis::MEASLES => array(
            'ICD9' => array( '055' )
        ),
        Diagnosis::MULT_MYELOMA => array(
            'ICD9' => array( '203' )
        ),
        Diagnosis::MUMPS => array(
            'ICD9' => array() // TODO
        ),
        Diagnosis::POLYCYSTIC_OVARIES => array(
            'ICD9' => array( '256.4' )
        ),
        Diagnosis::PROG_NEURO_DISORDER => array(
            'ICD9' => array() ,
            'SNOMED' => array( '230363006', '292925004', '292927007', '292992006' )
        ),
        Diagnosis::RUBELLA => array(
            'ICD9' => array() // TODO
        ),
        Diagnosis::STEROID_INDUCED_DIABETES => array(
            'ICD9' => array( '249','249.0','249.00','249.01','249.1','249.10','249.11','249.2','249.20','249.21','249.3','249.30','249.31','249.4','249.40','249.41','249.5','249.50','249.51','249.6','249.60','249.61','249.7','249.70','249.71','249.8','249.80','249.81','249.9','249.90','249.91','251.8','962.0')
        ),
        Diagnosis::VZV => array(
            'ICD9' => array( '052','053' )
        ),
        Diagnosis::END_STAGE_RENAL_DISEASE => array(
            'ICD9' => array('585.6')
        ),
        Diagnosis::CHRONIC_KIDNEY_DISEASE => array(
            'ICD9' => array('585.5')
        ),
        Diagnosis::ACUTE_PHARYNGITIS => array(
            'ICD9'      => array('034.0','462'),
            'ICD10'     => array('J02.0','J02.9'),
            'SNOMED-CT' => array('1532007', '195655000', '195656004', '195657008', '195658003', '195659006', '195660001', '195662009', '232399005', '232400003', '363746003', '40766000', '43878008', '55355000','58031004')
        ),
        Diagnosis::ACUTE_TONSILLITIS => array(
            'ICD9'      => array('463'),
            'ICD10'     => array('J03.00', 'J03.01', 'J03.80', 'J03.81', 'J03.90', 'J03.91'),
            'SNOMED-CT' => array('17741008', '195666007', '195667003', '195668008', '195669000', '195670004', '195671000', '195672007', '195673002', '195676005', '195677001', '302911003')
        ),
        Diagnosis::LIMITED_LIFE => array(
            'SNOMED-CT' => array(162607003, 162608008, 170969009, 27143004, 300936002)
        ),
        Encounter::ENC_OUT_PCP_OBGYN => array(
            'ICD9' => array( 'V24','V25','V26','V27','V28','V45.5','V61.5','V61.6','V61.7','V69.2','V72.3','V72.4' )
        ),
        Encounter::ENC_OUTPATIENT => array(
            'ICD9' => array( 'V70.0','V70.3','V70.5','V70.6','V70.8','V70.9' )
        ),
        Encounter::ENC_PREGNANCY => array(
            'ICD9' => array( 'V24','V24.0','V24.2','V25','V25.01','V25.02','V25.03','V25.09','V26.81','V28','V28.3','V28.81','V28.82','V72.4','V72.40','V72.41','V72.42' )
        ),
        LabResult::HB1AC_TEST => array(
            'CPT4'  => array( '83036','83037' ),
            'LOINC' => array('17856-6', '4548-4', '4549-2')
        ),
        LabResult::LDL_TEST => array(
            'CPT4' => array( '80061','83700','83701','83704','83721')
        ),
        LabResult::STREPTOCOCCUS_TEST => array(
            'LOINC' => array('11268-0', '17656-0', '18481-2', '31971-5', '49610-9', '5036-9', '60489-2', '626-2', '6556-5', '6557-3', '6558-1', '6559-9', '68954-7')
        ),
        Medication::DTAP_VAC => array(
            'CVX' => array( 20, 50, 106, 107, 110, 120, 130, 132 )
        ),
        Medication::HEP_A_VAC => array(
            'CVX' => array( 31, 52, 83, 84, 85, 104)
        ),
        Medication::HEP_B_VAC => array(
            'CVX' => array( 8, 42, 43, 44, 45, 51, 102, 104, 110, 132 )
        ),
        Medication::HIB => array(
            'CVX' => array( 17, 22, 46, 47, 48, 49, 50, 51, 102, 120, 132 )
        ),
        Medication::IPV => array(
            'CVX' => array( 10, 110, 120, 130, 132 )
        ),
        Medication::MEASLES_VAC => array(
            'CVX' => array( 3, 4, 5, 94 )
        ),
        Medication::MMR => array(
            'CVX' => array( 3, 94 )
        ),
        Medication::MUMPS_VAC => array(
            'CVX' => array( 3, 7, 38, 94 )
        ),
        Medication::PNEUMOCOCCAL_VAC => array(
            'CVX' => array (33)
        ),
        Medication::RUBELLA_VAC => array(
            'CVX' => array( 3, 4, 6, 38, 94 )
        ),
        Medication::ROTAVIRUS_VAC => array(
            'CVX' => array( 74, 116, 119, 122 )
        ),
        Medication::VZV => array(
            'CVX' => array( 21, 21 )
        ),
        Medication::INFLUENZA_VAC => array(
            'CVX' => array( 15, 16, 88, 111, 125, 126, 127, 128, 135, 140, 141, 144 )
        ),
        Medication::ANTIBIOTIC_FOR_PHARYNGITIS => array(
            'RXNORM' => array(1013659, 1013662, 1013665, 1043022, 1043027, 1043030, 105152, 105170, 105171, 108449, 1113012, 1148107, 1244762, 1249602, 1302650, 1302659, 1302664, 1302669, 1302674, 1373014, 141962, 141963, 142118, 1423080, 1483787, 197449, 197450, 197451, 197452, 197453, 197454, 197511, 197512, 197516, 197517, 197518, 197595, 197596, 197633, 197650, 197984, 197985, 198048, 198049, 198050, 198250, 198252, 198332, 198334, 198335, 199026, 199027, 199332, 199370, 199884, 199885, 199886, 200346, 204466, 204844, 204871, 204929, 205964, 207362, 207364, 207390, 207391, 226633, 239191, 240637, 240639, 240640, 240741, 240984, 242807, 245240, 245242, 246282, 248656, 250582, 283535, 284215, 308177, 308181, 308182, 308188, 308189, 308191, 308192, 308194, 308207, 308208, 308210, 308212, 308459, 308460, 308461, 309040, 309042, 309043, 309044, 309045, 309047, 309048, 309049, 309051, 309052, 309053, 309054, 309058, 309076, 309077, 309078, 309079, 309080, 309081, 309085, 309086, 309087, 309090, 309091, 309092, 309093, 309095, 309096, 309097, 309098, 309099, 309100, 309101, 309110, 309111, 309112, 309113, 309114, 309115, 309304, 309308, 309309, 309310, 309322, 309329, 309335, 309336, 309339, 309860, 310026, 310027, 310028, 310029, 310030, 310151, 310154, 310155, 310156, 310157, 310160, 310163, 310165, 311296, 311787, 312127, 312128, 312130, 313133, 313134, 313135, 313137, 313251, 313253, 313797, 313799, 313800, 313819, 313850, 313888, 313920, 313926, 313929, 314108, 315065, 315090, 315219, 317127, 348869, 348870, 351121, 351127, 351156, 351239, 359383, 359385, 359465, 403840, 403921, 403945, 406524, 406696, 409823, 413716, 419849, 434018, 476193, 476299, 476322, 476325, 476327, 476576, 476623, 477391, 486912, 487129, 562251, 562253, 562266, 562508, 562707, 597194, 597298, 597455, 597808, 598006, 598025, 617296, 617302, 617304, 617309, 617316, 617322, 617423, 617430, 617993, 617995, 623677, 623695, 629695, 629697, 629699, 636559, 637173, 645617, 686355, 686383, 686400, 686405, 686406, 686418, 700408, 728207, 731538, 731564, 731567, 731570, 731572, 731575, 745047, 745053, 745276, 745278, 745280, 745282, 745302, 745303, 745462, 745519, 745560, 745561, 745585, 749780, 749783, 756189, 756192, 757460, 757464, 757466, 761979, 762666, 762893, 789980, 796301, 799048, 802550, 835341, 835700, 836306, 847360, 852868, 854220, 858062, 858372, 861416, 863538, 877486, 895915, 900424, 901399, 904288, 993109, 997632, 997656, 997665, 997999, 998004, 998756)
        ),
        Medication::INFLUENZA_VACCINE => array(
            'CVX' => array(111, 135, 140, 141, 144, 149, 150)
        ),
        PhysicalExam::FINDING_BMI_PERC => array(
            'ICD9' => array( 'V85.5','V85.51','V85.52','V85.53','V85.54' )
        ),
        Procedure::DIALYSIS_SERVICE => array(
            'SNOMED' => array(108241001, 10848006, 11932001, 14684005, 180273006, 225230008, 225231007, 233575001, 233576000, 233577009, 233578004, 233579007, 233580005, 233581009, 233582002, 233583007, 233584001, 233585000, 233586004, 233587008, 233588003, 233589006, 233590002, 238316008, 238317004, 238318009, 238319001, 238321006, 238322004, 238323009, 265764009, 288182009, 302497006, 34897002, 427053002, 428648006, 439278006, 439976001, 57274006, 676002, 67970008, 68341005, 71192002)
        ),
        Procedure::INFLU_VACCINE => array(
            'SNOMED' => array(442333005, 86198006)
        ),
        Procedure::PNEUMOCOCCAL_VACCINE => array(
            'SNOMED' => array(12866006, 394678003)
        ),
        
    );
}
