<?php
/**
 * @link      http://github.com/zendframework/zend-mvc-console for the canonical source repository
 * @copyright Copyright (c) 2005-2016 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Zend\Mvc\Console\View;

use Zend\Console\Response as ConsoleResponse;
use Zend\EventManager\AbstractListenerAggregate;
use Zend\EventManager\EventManagerInterface;
use Zend\Mvc\Console\View\ViewModel as ConsoleViewModel;
use Zend\Mvc\MvcEvent;
use Zend\Stdlib\ResponseInterface as Response;

class DefaultRenderingStrategy extends AbstractListenerAggregate
{
    /**
     * @var Renderer
     */
    private $renderer;

    /**
     * @param Renderer $renderer
     */
    public function __construct(Renderer $renderer)
    {
        $this->renderer = $renderer;
    }

    /**
     * {@inheritDoc}
     */
    public function attach(EventManagerInterface $events, $priority = 1)
    {
        $this->listeners[] = $events->attach(MvcEvent::EVENT_RENDER, [$this, 'render'], -10000);
    }

    /**
     * Render the view
     *
     * @param  MvcEvent $e
     * @return Response
     */
    public function render(MvcEvent $e)
    {
        $result = $e->getResult();
        if ($result instanceof Response) {
            return $result; // the result is already rendered ...
        }

        // Marshal arguments
        $response  = $e->getResponse();

        // Render the result
        $responseText = $this->renderer->render($result);

        // Fetch service manager
        $sm = $e->getApplication()->getServiceManager();

        // Fetch console
        $console = $sm->get('console');

        // Append console response to response object
        $content = $response->getContent() . $responseText;
        if (is_callable([$console, 'encodeText'])) {
            $content = $console->encodeText($content);
        }
        $response->setContent($content);

        // Pass on console-specific options
        if ($response instanceof ConsoleResponse
            && $result instanceof ConsoleViewModel
        ) {
            $errorLevel = $result->getErrorLevel();
            $response->setErrorLevel($errorLevel);
        }

        return $response;
    }
}
